# Препроцессинг набора аудиоданных

Загрузка набора данных с помощью 🤗 Datasets - это только половина удовольствия. Если вы планируете использовать его либо для обучения модели, либо для выполнения
инференса, необходимо предварительно обработать данные. В общем случае это включает в себя следующие шаги:

* Передискретизация аудиоданных
* Фильтрация набора данных
* Преобразование аудиоданных в ожидаемый моделью формат входных данных

## Передискретизация аудиоданных

Функция `load_dataset` загружает аудиопримеры с той частотой дискретизации, с которой они были опубликованы. Это не
всегда та частота дискретизации, которая ожидается моделью, которую вы планируете обучать или использовать для инференса. Если есть расхождение между
частотой дискретизации, можно передискретизировать звук до ожидаемой моделью частоты дискретизации.

Большинство имеющихся предварительно обученных моделей были обучены на аудиоданных с частотой дискретизации 16 кГц.
Когда мы исследовали набор данных MINDS-14, вы могли заметить, что он сэмплирован с частотой 8 кГц, что означает, что нам, скорее всего, потребуется
увеличить частоту дискретизации.

Чтобы сделать это, используйте метод 🤗 Datasets `cast_column`. Эта операция не изменяет звук непосредственно в наборе данных (in-place), а дает сигнал
datasets для передискретизации аудиопримеров "на лету" при их загрузке. Следующий код установит частоту дискретизации
равной 16 кГц:

```py
from datasets import Audio

minds = minds.cast_column("audio", Audio(sampling_rate=16_000))
```

Перезагрузим первый аудиопример из набора данных MINDS-14 и проверим, что он был передискретизирован до нужной `sampling rate`:

```py
minds[0]
```

**Output:**
```out
{
    "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
    "audio": {
        "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
        "array": array(
            [
                2.0634243e-05,
                1.9437837e-04,
                2.2419340e-04,
                ...,
                9.3852862e-04,
                1.1302452e-03,
                7.1531429e-04,
            ],
            dtype=float32,
        ),
        "sampling_rate": 16000,
    },
    "transcription": "I would like to pay my electricity bill using my card can you please assist",
    "intent_class": 13,
}
```

Вы можете заметить, что значения массива теперь также отличаются. Это связано с тем, что теперь для
каждого значения амплитуды мы имеем в два раза больше значений чем раньше.

💡 Некоторые сведения о передискретизации: Если аудиосигнал дискретизирован с частотой 8 кГц, т. е. имеет 8000 выборок в
секунду, то мы знаем, что он не содержит частот выше 4 кГц. Это гарантируется теоремой Найквиста 
о дискретизации. Благодаря этому мы можем быть уверены, что между точками дискретизации исходный непрерывный сигнал всегда
имеет плавную кривую. Повышение частоты дискретизации до более высокой сводится к вычислению дополнительных значений выборки, которые находятся между
существующими, путем аппроксимации этой кривой. Однако понижающая дискретизация требует, чтобы мы сначала отфильтровали все частоты,
которые будут выше нового предела Найквиста, прежде чем оценивать новые точки дискретизации. Другими словами, нельзя
понизить дискретизацию в 2 раза, просто отбрасывая каждый второй сэмпл - это приведет к появлению искажений в сигнале, называемых
наложениями. Корректная передискретизация - дело непростое, и его лучше доверить проверенным библиотекам, таким как librosa или 🤗 Datasets.

## Фильтрация набора данных

Возможно, потребуется отфильтровать данные по каким-либо критериям. Одним из распространенных случаев является ограничение аудиопримеров
определенной продолжительности. Например, для предотвращения ошибок, связанных с выходом за пределы доступного обьёма памяти,
необходимо отфильтровать все примеры длительностью более 20 секунд при обучении модели.

Мы можем сделать это, используя метод 🤗 Datasets `filter` и передать ему функцию с логикой фильтрации. Начнем с того, что напишем функцию
которая определяет, какие примеры следует оставить, а какие отбросить. Эта функция, `is_audio_length_in_range`,
возвращает `True`, если длина образца меньше 20 с, и `False`, если больше 20 с.

```py
MAX_DURATION_IN_SECONDS = 20.0

def is_audio_length_in_range(input_length):
    return input_length 

Теперь вы можете увидеть, как выглядит входной аудиосигнал для модели Whisper после препроцессинга.

Класс модели feature extractor занимается преобразованием сырых аудиоданных в формат, ожидаемый моделью. Однако,
многие задачи с использованием звука являются мультимодальными, например, распознавание речи.
В таких случаях 🤗 Transformers также предлагает специфичные для конкретной модели
токенизаторы для обработки текстовых данных. Для более глубокого изучения токенизаторов обратитесь к нашему [курсу по NLP](https://huggingface.co/course/chapter2/4).

Вы можете загрузить экстрактор признаков и токенизатор для Whisper и других мультимодальных моделей отдельно, либо загрузить их через 
так называемый процессор. Чтобы еще больше упростить задачу, используйте `AutoProcessor` для загрузки экстрактора признаков и процессора модели из контрольной точки,
например, так:

```py
from transformers import AutoProcessor

processor = AutoProcessor.from_pretrained("openai/whisper-small")
```

Здесь мы проиллюстрировали основные этапы подготовки данных. Конечно, пользовательские данные могут потребовать более сложного препроцессинга.
В этом случае можно расширить функцию `prepare_dataset` для выполнения любых преобразований пользовательских данных. С 🤗 Datasets,
если вы можете записать процес подготовки данных как функцию Python, вы можете [применить его](https://huggingface.co/docs/datasets/audio_process) к вашему набору данных!

