import{s as Jl,n as xl,o as $l}from"../chunks/scheduler.cd324960.js";import{S as Cl,i as gl,e as p,s as n,c as o,h as dl,a as i,d as e,b as a,f as bl,g as M,j as m,k as As,l as wl,m as l,n as u,t as c,o as y,p as f}from"../chunks/index.d5c3adcc.js";import{C as vl,H as j,E as Il}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b3ee0d86.js";import{C as r}from"../chunks/CodeBlock.6bf7b79a.js";function Nl(xe){let h,Fs,Es,Bs,x,Ps,$,Vs,C,$e=`Hugging Face Hub содержит более 500 предварительно обученных моделей для классификации звука. В этом разделе мы рассмотрим
несколько наиболее распространенных задач классификации звука и предложим для каждой из них подходящие предварительно обученные модели.
Использование <code>pipeline()</code> позволяет легко переключаться между моделями и задачами - как только вы узнаете, как использовать
<code>pipeline()</code> для одной модели, вы сможете использовать его для любой модели на Hugging Face Hub без изменений кода! Это делает эксперименты с
<code>pipeline()</code> чрезвычайно быстрыми, позволяя быстро выбрать наилучшую предварительно обученную модель для ваших нужд.`,Xs,g,Ce=`Прежде чем перейти к рассмотрению различных задач классификации звука, давайте кратко перечислим обычно используемые архитектуры
трансформеров. Стандартная архитектура классификации звука обусловлена характером задачи; мы хотим преобразовать последовательность
входных аудиосигналов (т.е. наш входной массив аудиосигналов) в предсказание метки одного из классов. Модели, архитектура которых состоит
только из кодировщика, сначала преобразуют входную звуковую последовательность в последовательность представлений скрытых состояний,
пропуская входные сигналы через блок трансформации. Последовательность представлений скрытых состояний преобразуется в выходную метку
класса путем взятия среднего значения по скрытым состояниям и пропускания полученного вектора через слой линейной классификации.
Поэтому для классификации аудиосигналов предпочтение отдается моделям, архитектура которых состоит только из <em>кодировщика</em>.`,Os,d,ge=`Модели, архитектура которых состоит только из декодировщика излишне усложняют задачу, поскольку предполагают что выходы могут быть в том
числе и <em>последовательностью</em> предсказаний (а не одним предсказанием метки класса), и поэтому генерируют несколько выходов. Поэтому они
имеют более низкую скорость вывода и, как правило, не используются. По этой же причине модели кодеровщик-декодировщик в значительной степени
не рассматриваются. Такой выбор архитектуры аналогичен выбору в NLP, где для задач классификации последовательностей предпочтение отдается
только моделям-кодировщикам, таким как <a href="https://huggingface.co/blog/bert-101" rel="nofollow">BERT</a>, а для задач генерации последовательностей - только
моделям-декодировщикам, таким как GPT.`,Ks,w,de=`Теперь, когда мы рассказали о стандартной архитектуре трансформеров для классификации звука, перейдем к рассмотрению различных подмножеств
классификации звука и наиболее популярных моделей!`,st,v,tt,I,we=`На момент написания статьи последние обновления, необходимые для работы конвейера классификации звука, находятся только в <code>main</code> ветке
репозитория 🤗 Transformers, а не в последней версии PyPi. Чтобы убедиться в наличии этих обновлений локально, мы установим Transformers
из ветки <code>main</code> следующей командой:`,et,N,lt,_,nt,H,ve=`Поиск ключевых слов (Keyword Spotting, KWS) - это задача идентификации ключевого слова в произносимой речи. Набор возможных ключевых слов
формирует набор прогнозируемых меток классов. Поэтому для использования предварительно обученной модели выделения ключевых слов необходимо
убедиться, что ваши ключевые слова совпадают с теми, на которых модель была предварительно обучена. Ниже мы представим два набора данных
и модели для выявления ключевых слов.`,at,L,pt,Z,Ie=`Воспользуемся тем же набором данных <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, который вы исследовали в предыдущем разделе.
Если вы помните, MINDS-14 содержит записи людей, задающих вопросы системе дистанционного банковского обслуживания на нескольких языках и
диалектах, и для каждой записи имеет значение <code>intent_class</code>. Мы можем классифицировать записи по намерению звонящего.`,it,q,mt,Q,Ne=`Загрузим контрольную точку <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>, которая
представляет собой XLS-R-модель, дообученную на MINDS-14 в течение примерно 50 эпох. На оценочной выборке набора MINDS-14 она достигает 90%
по метрике accuracy по всем языкам.`,ot,W,Mt,S,_e="Наконец, мы можем передать сэмпл в конвейер классификации, чтобы сделать предсказание:",ut,z,ct,k,He="<strong>Output:</strong>",yt,Y,ft,G,Le=`Отлично! Мы определили, что целью звонка была оплата счета, с вероятностью 96%. Можно представить, что подобная система выявления ключевых
слов используется в качестве первого этапа автоматизированного центра обработки вызовов (call-центр), где мы хотим классифицировать входящие
звонки клиентов в зависимости от их запроса и предложить им соответствующую контекстную поддержку.`,rt,D,ht,A,Ze=`Speech Commands - это набор устных слов, предназначенный для оценки моделей классификации звука на простых командных словах. Набор данных
состоит из 15 классов ключевых слов, класса молчания и неизвестного класса, включающего ложные срабатывания. 15 ключевых слов - это отдельные
слова, которые обычно используются в настройках устройства для управления основными задачами или запуска других процессов.`,jt,E,qe=`Аналогичная модель постоянно работает в вашем мобильном телефоне. Здесь вместо отдельных командных слов используются “слова пробуждения”,
характерные для конкретного устройства, например “Привет, Google” или “Привет, Siri”. Когда модель классификации звука обнаруживает эти слова,
она заставляет телефон начать прослушивание микрофона и транскрибировать вашу речь с помощью модели распознавания речи.`,Tt,R,Qe=`Модель классификации звука гораздо меньше и легче, чем модель распознавания речи, зачастую в ней всего несколько миллионов параметров по
сравнению с несколькими сотнями миллионов параметров в модели для распознавания речи. Таким образом, она может непрерывно работать на вашем
устройстве, не разряжая аккумулятор! Более крупная модель распознавания речи запускается только при обнаружении слова-пробуждения, после чего
она снова отключается. В следующем разделе мы рассмотрим модели трансформеров для распознавания речи, так что к концу курса у вас должны быть
все необходимые инструменты для создания собственного голосового помощника!`,Ut,F,We=`Как и в случае с любым набором данных на Hugging Face Hub, мы можем получить представление о том, какие аудиоданные в нем присутствуют,
не скачивая и не сохраняя их в памяти компьютера. Перейдя к карточке набора данных <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands’ dataset</a>
на Hugging Face Hub, мы можем воспользоваться средством просмотра набора данных (Dataset Viewer), чтобы пролистать первые 100 образцов набора,
прослушать аудиофайлы и проверить любые другие метаданные:`,bt,T,Se='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',Jt,B,ze=`Предварительный просмотр данных - это отличный способ ознакомиться с наборами аудиоданных, прежде чем приступить к их использованию. Вы можете выбрать
любой набор данных на Hugging Face Hub, пролистать примеры и прослушать аудиозаписи для различных подмножеств и разбиений, чтобы понять, подходит ли
этот набор данных для ваших нужд. Выбрав набор данных, несложно загрузить данные, чтобы начать их использовать.`,xt,P,ke="Давайте сделаем именно это и загрузим образец набора данных Speech Commands в потоковом режиме:",$t,V,Ct,X,Ye=`Загрузим официальную контрольную точку <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogram-transformer" rel="nofollow">Audio Spectrogram Transformer</a>,
прошедшую дообучение на наборе данных Speech Commands, в пространстве имен <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow"><code>&quot;MIT/ast-finetuned-speech-commands-v2&quot;</code></a>:`,gt,O,dt,K,Ge="<strong>Output:</strong>",wt,ss,vt,ts,De="Класс! Похоже, что пример с высокой вероятностью содержит слово “назад”. Мы можем прослушать пример и убедиться что это действительно так:",It,es,Nt,ls,Ae=`Теперь вам, возможно, интересно, как мы выбрали эти предварительно обученные модели, чтобы показать их на этих примерах классификации звука.
На самом деле, найти предварительно обученные модели для вашего набора данных и задачи очень просто! Первое, что нам нужно сделать, это зайти
в Hugging Face Hub и перейти на вкладку “Models” (Модели): <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>`,_t,ns,Ee="В результате будут отображены все модели на Hugging Face Hub, отсортированные по количеству загрузок за последние 30 дней:",Ht,U,Re='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',Lt,as,Fe=`С левой стороны можно заметить ряд вкладок, на которых можно отфильтровать модели по задачам, библиотекам, наборам данных и т.д. Прокрутите
страницу вниз и выберите задачу “Audio Classification” (Классификация аудио) из списка задач аудио:`,Zt,b,Be='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',qt,ps,Pe=`Теперь нам представлено подмножество из 500+ моделей классификации звука на хабе. Для дальнейшего уточнения этого отбора мы можем отфильтровать
модели по набору данных. Перейдите на вкладку “Datasets” и в строке поиска введите “speech_commands”. Когда вы начнете вводить текст, под
вкладкой поиска появится выбор для <code>speech_commands</code>. Нажав на эту кнопку, вы можете отфильтровать все модели классификации звука от тех,
которые были настроены на наборе данных Speech Commands:`,Qt,J,Ve='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Wt,is,Xe=`Отлично! Мы видим, что для данного набора данных и задачи нам доступны 6 предварительно обученных моделей. Вы заметите первую из этих моделей
Audio Spectrogram Transformer, контрольную точку которой мы использовали в предыдущем примере. Этот процесс фильтрации моделей на Hugging Face Hub -
именно то, как мы выбирали контрольную точку для показа вам!`,St,ms,zt,os,Oe=`Идентификация языка (LID) - это задача определения языка, на котором говорят в аудиосэмпле, из списка языков-кандидатов. LID может стать важной
частью многих речевых конвейеров. Например, при получении образца аудиозаписи на неизвестном языке модель LID может быть использована для классификации
языка (языков), на котором разговаривают в аудиозаписи, и последующего выбора соответствующей модели распознавания речи, обученной на этом языке,
для транскрибации аудиозаписи.`,kt,Ms,Yt,us,Ke=`FLEURS (Few-shot Learning Evaluation of Universal Representations of Speech) - это набор данных для оценки систем распознавания речи на 102 языках,
в том числе на многих языках, которые относятся к категории “малоресурсных”. Ознакомьтесь с карточкой набора данных FLEURS на Hugging Face Hub
и изучите различные языки, которые в нем представлены: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>. Можете ли Вы найти здесь
свой родной язык? Если нет, то какой язык наиболее близок к нему?`,Gt,cs,sl="Загрузим выборку из валидационной части набора данных FLEURS в потоковом режиме:",Dt,ys,At,fs,tl=`Отлично! Теперь мы можем загрузить нашу модель классификации звука. Для этого мы будем использовать версию <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>
дообученный на наборе данных FLEURS, который в настоящее время является наиболее производительной моделью LID на Hugging Face Hub:`,Et,rs,Rt,hs,el="Затем мы можем пропустить звук через наш классификатор и сгенерировать предсказание:",Ft,js,Bt,Ts,ll="<strong>Output:</strong>",Pt,Us,Vt,bs,nl=`Видно, что модель предсказала, что звук был на “Afrikaans” с очень высокой вероятностью (близкой к 1). Набор данных FLEURS
содержит аудиоданные из широкого спектра языков - мы видим, что возможные метки классов включают “Northern-Sotho”, “Icelandic”,
“Danish” и “Cantonese Chinese” языки, а также другие. Полный список языков, представленных в карточке набора данных, можно найти здесь: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.`,Xt,Js,al="Посмотрите самостоятельно! Какие еще контрольные точки можно найти для FLEURS LID на хабе? Какие модели трансформаторов используются под капотом?",Ot,xs,Kt,$s,pl=`В традиционной парадигме классификации звука модель предсказывает метку класса из <em>предварительно определенного</em> набора возможных классов.
Это создает препятствие для использования предварительно обученных моделей для классификации звука, поскольку набор меток предварительно обученной
модели должен соответствовать набору меток последующей задачи. В предыдущем примере LID модель должна предсказать один из 102 языковых классов,
на которых она была обучена. Если для решения поставленной задачи требуется 110 языков, то модель не сможет предсказать 8 из 110 языков, и для
достижения полного покрытия потребуется повторное обучение. Это ограничивает эффективность применения трансферного обучения для задач классификации звука.`,se,Cs,il=`Zero-shot классификация звука это метод, позволяющий использовать предварительно обученную модель классификации аудиоданных, натренированную на множестве
размеченных примеров, для классификации новых примеров из ранее не встречавшихся классов. Давайте рассмотрим, как этого можно добиться!`,te,gs,ml=`В настоящее время 🤗 Transformers поддерживает один вид модели для Zero-shot классификации звука: это <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">CLAP model</a>.
CLAP - это модель, основанная на трансформации, которая принимает в качестве входных данных звук и текст и вычисляет <em>сходство</em> между ними.
Если мы передаем текстовый ввод, который сильно коррелирует с аудиовводом, мы получим высокую оценку сходства. И наоборот, при передаче текстового ввода,
совершенно не связанного с аудиовводом, будет получено низкое сходство.`,ee,ds,ol=`Мы можем использовать это предсказание сходства для zero-shot классификации звука, передавая модели один аудиовход и несколько меток-кандидатов.
Модель вернет оценку сходства для каждой из меток-кандидатов, и мы можем выбрать в качестве прогноза ту, которая имеет наибольшую оценку.`,le,ws,Ml='Рассмотрим пример, в котором мы используем один аудиовход от набора данных <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a>:',ne,vs,ae,Is,ul=`Затем мы определяем наши метки-кандидаты, которые образуют набор возможных классификационных меток. Модель будет возвращать вероятность принадлежности к классу
для каждой из заданных нами меток. Это означает, что нам необходимо знать <em>априори</em> набор возможных меток в нашей задаче классификации, причем так, чтобы правильная
метка содержалась в этом наборе и, следовательно, ей была присвоена правильная вероятностная оценка. Обратите внимание, что мы можем передать модели
либо полный набор меток, либо отобранное вручную подмножество, которое, по нашему мнению, содержит правильную метку. Передача полного набора меток
будет более исчерпывающей, но за счет более низкой точности классификации, поскольку пространство классификации больше (при условии,
что правильной меткой является выбранное нами подмножество меток):`,pe,Ns,ie,_s,cl="Мы можем прогнать обе эти метки через модель, чтобы найти метку-кандидата, которая <em>наиболее</em> похожа на входной аудиосигнал:",me,Hs,oe,Ls,yl="<strong>Output:</strong>",Me,Zs,ue,qs,fl=`Отлично! Модель, похоже, уверена, что у нас есть звук собаки - она предсказывает его с вероятностью 99,96%, так что мы примем
это за наше предсказание. Убедимся в том, что мы не ошиблись, прослушав аудиопример (не увеличивайте громкость слишком сильно!):`,ce,Qs,ye,Ws,rl=`Отлично! У нас есть звук лая собаки 🐕, что соответствует предсказанию модели. Поиграйте с разными аудиосэмплами и разными
кандидатами на метки - сможете ли вы определить набор меток, которые дают хорошее обобщение по всему набору данных ESC? Подсказка:
подумайте, где можно найти информацию о возможных звуках в ESC, и постройте свои метки соответствующим образом!`,fe,Ss,hl=`Возможно, вы зададитесь вопросом, почему мы не используем конвейер zero-shot классификации звука для <strong>всех</strong> задач классификации звука?
Кажется, что мы можем делать предсказания для любой задачи классификации звука, определяя соответствующие метки классов <em>априори</em>,
тем самым обходя ограничения, связанные с тем, что наша задача классификации должна соответствовать меткам, на которых была предварительно
обучена модель. Это связано с характером модели CLAP, используемой в zero-shot конвейере: CLAP предварительно обучена на <em>общих</em> аудиоданных
для классификации, таких как звуки окружающей среды в наборе данных ESC, а не на речевых данных, как в задаче LID. Если дать ему речь на
английском и речь на испанском языках, CLAP поймет, что оба примера являются речевыми данными 🗣️. Но он не сможет различить языки так, как
это может сделать специализированная LID-модель.`,re,zs,he,ks,jl=`Мы рассмотрели ряд различных задач классификации звука и представили наиболее актуальные наборы данных и модели, которые можно загрузить с
Hugging Face Hub и использовать всего в нескольких строках кода с помощью <code>pipeline()</code>. Эти задачи включали в себя выделение ключевых слов,
идентификацию языка и zero-shot классификацию аудиозаписей.`,je,Ys,Tl=`Но что, если мы хотим сделать что-то <strong>новое</strong>? Мы много работали над задачами обработки речи, но это лишь один из аспектов классификации аудио.
Другая популярная область обработки звука связана с <strong>музыкой</strong>. Хотя музыка по своей сути отличается от речи, многие из тех же принципов,
о которых мы уже узнали, могут быть применены и к музыке.`,Te,Gs,Ul=`В следующем разделе мы рассмотрим пошаговое руководство по тонкой настройке модели трансформера с помощью 🤗 Transformers на задаче классификации музыки.
К концу этой работы у вас будет контрольная точка дообученной модели, которую вы сможете передать в <code>pipeline()</code>, что позволит вам классифицировать
песни точно так же, как мы классифицировали здесь речь!`,Ue,Ds,be,Rs,Je;return x=new vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new j({props:{title:"Предварительно обученные модели и наборы данных для классификации звука",local:"предварительно-обученные-модели-и-наборы-данных-для-классификации-звука",headingTag:"h1"}}),v=new j({props:{title:"🤗 Установка библиотеки Transformers",local:"-установка-библиотеки-transformers",headingTag:"h2"}}),N=new r({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers',wrap:!1}}),_=new j({props:{title:"Поиск ключевых слов",local:"поиск-ключевых-слов",headingTag:"h2"}}),L=new j({props:{title:"Minds-14",local:"minds-14",headingTag:"h3"}}),q=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),W=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),z=new r({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJwYXRoJTIyJTVEKQ==",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;path&quot;</span>])',wrap:!1}}),Y=new r({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),D=new j({props:{title:"Speech Commands",local:"speech-commands",headingTag:"h3"}}),V=new r({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`,wrap:!1}}),O=new r({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`,wrap:!1}}),ss=new r({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`,wrap:!1}}),es=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`,wrap:!1}}),ms=new j({props:{title:"Идентификация языка (Language Identification)",local:"идентификация-языка-language-identification",headingTag:"h2"}}),Ms=new j({props:{title:"FLEURS",local:"fleurs",headingTag:"h3"}}),ys=new r({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`,wrap:!1}}),rs=new r({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`,wrap:!1}}),js=new r({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),Us=new r({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`,wrap:!1}}),xs=new j({props:{title:"Zero-Shot Audio Classification",local:"zero-shot-audio-classification",headingTag:"h2"}}),vs=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`,wrap:!1}}),Ns=new r({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]',wrap:!1}}),Hs=new r({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`,wrap:!1}}),Zs=new r({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]',wrap:!1}}),Qs=new r({props:{code:"QXVkaW8oYXVkaW9fc2FtcGxlJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:'Audio(audio_sample, rate=<span class="hljs-number">16000</span>)',wrap:!1}}),zs=new j({props:{title:"Что дальше?",local:"что-дальше",headingTag:"h2"}}),Ds=new Il({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter4/classification_models.mdx"}}),{c(){h=p("meta"),Fs=n(),Es=p("p"),Bs=n(),o(x.$$.fragment),Ps=n(),o($.$$.fragment),Vs=n(),C=p("p"),C.innerHTML=$e,Xs=n(),g=p("p"),g.innerHTML=Ce,Os=n(),d=p("p"),d.innerHTML=ge,Ks=n(),w=p("p"),w.textContent=de,st=n(),o(v.$$.fragment),tt=n(),I=p("p"),I.innerHTML=we,et=n(),o(N.$$.fragment),lt=n(),o(_.$$.fragment),nt=n(),H=p("p"),H.textContent=ve,at=n(),o(L.$$.fragment),pt=n(),Z=p("p"),Z.innerHTML=Ie,it=n(),o(q.$$.fragment),mt=n(),Q=p("p"),Q.innerHTML=Ne,ot=n(),o(W.$$.fragment),Mt=n(),S=p("p"),S.textContent=_e,ut=n(),o(z.$$.fragment),ct=n(),k=p("p"),k.innerHTML=He,yt=n(),o(Y.$$.fragment),ft=n(),G=p("p"),G.textContent=Le,rt=n(),o(D.$$.fragment),ht=n(),A=p("p"),A.textContent=Ze,jt=n(),E=p("p"),E.textContent=qe,Tt=n(),R=p("p"),R.textContent=Qe,Ut=n(),F=p("p"),F.innerHTML=We,bt=n(),T=p("div"),T.innerHTML=Se,Jt=n(),B=p("p"),B.textContent=ze,xt=n(),P=p("p"),P.textContent=ke,$t=n(),o(V.$$.fragment),Ct=n(),X=p("p"),X.innerHTML=Ye,gt=n(),o(O.$$.fragment),dt=n(),K=p("p"),K.innerHTML=Ge,wt=n(),o(ss.$$.fragment),vt=n(),ts=p("p"),ts.textContent=De,It=n(),o(es.$$.fragment),Nt=n(),ls=p("p"),ls.innerHTML=Ae,_t=n(),ns=p("p"),ns.textContent=Ee,Ht=n(),U=p("div"),U.innerHTML=Re,Lt=n(),as=p("p"),as.textContent=Fe,Zt=n(),b=p("div"),b.innerHTML=Be,qt=n(),ps=p("p"),ps.innerHTML=Pe,Qt=n(),J=p("div"),J.innerHTML=Ve,Wt=n(),is=p("p"),is.textContent=Xe,St=n(),o(ms.$$.fragment),zt=n(),os=p("p"),os.textContent=Oe,kt=n(),o(Ms.$$.fragment),Yt=n(),us=p("p"),us.innerHTML=Ke,Gt=n(),cs=p("p"),cs.textContent=sl,Dt=n(),o(ys.$$.fragment),At=n(),fs=p("p"),fs.innerHTML=tl,Et=n(),o(rs.$$.fragment),Rt=n(),hs=p("p"),hs.textContent=el,Ft=n(),o(js.$$.fragment),Bt=n(),Ts=p("p"),Ts.innerHTML=ll,Pt=n(),o(Us.$$.fragment),Vt=n(),bs=p("p"),bs.innerHTML=nl,Xt=n(),Js=p("p"),Js.textContent=al,Ot=n(),o(xs.$$.fragment),Kt=n(),$s=p("p"),$s.innerHTML=pl,se=n(),Cs=p("p"),Cs.textContent=il,te=n(),gs=p("p"),gs.innerHTML=ml,ee=n(),ds=p("p"),ds.textContent=ol,le=n(),ws=p("p"),ws.innerHTML=Ml,ne=n(),o(vs.$$.fragment),ae=n(),Is=p("p"),Is.innerHTML=ul,pe=n(),o(Ns.$$.fragment),ie=n(),_s=p("p"),_s.innerHTML=cl,me=n(),o(Hs.$$.fragment),oe=n(),Ls=p("p"),Ls.innerHTML=yl,Me=n(),o(Zs.$$.fragment),ue=n(),qs=p("p"),qs.textContent=fl,ce=n(),o(Qs.$$.fragment),ye=n(),Ws=p("p"),Ws.textContent=rl,fe=n(),Ss=p("p"),Ss.innerHTML=hl,re=n(),o(zs.$$.fragment),he=n(),ks=p("p"),ks.innerHTML=jl,je=n(),Ys=p("p"),Ys.innerHTML=Tl,Te=n(),Gs=p("p"),Gs.innerHTML=Ul,Ue=n(),o(Ds.$$.fragment),be=n(),Rs=p("p"),this.h()},l(s){const t=dl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(e),Fs=a(s),Es=i(s,"P",{}),bl(Es).forEach(e),Bs=a(s),M(x.$$.fragment,s),Ps=a(s),M($.$$.fragment,s),Vs=a(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-ap0uou"&&(C.innerHTML=$e),Xs=a(s),g=i(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-ph2fq"&&(g.innerHTML=Ce),Os=a(s),d=i(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-10llo6t"&&(d.innerHTML=ge),Ks=a(s),w=i(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1vx4ept"&&(w.textContent=de),st=a(s),M(v.$$.fragment,s),tt=a(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-3z4va9"&&(I.innerHTML=we),et=a(s),M(N.$$.fragment,s),lt=a(s),M(_.$$.fragment,s),nt=a(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-110kfei"&&(H.textContent=ve),at=a(s),M(L.$$.fragment,s),pt=a(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-11lxa7c"&&(Z.innerHTML=Ie),it=a(s),M(q.$$.fragment,s),mt=a(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1fqw984"&&(Q.innerHTML=Ne),ot=a(s),M(W.$$.fragment,s),Mt=a(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1ieiz33"&&(S.textContent=_e),ut=a(s),M(z.$$.fragment,s),ct=a(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1mvdyro"&&(k.innerHTML=He),yt=a(s),M(Y.$$.fragment,s),ft=a(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-vvoew6"&&(G.textContent=Le),rt=a(s),M(D.$$.fragment,s),ht=a(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-i9p3do"&&(A.textContent=Ze),jt=a(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-jsk7sc"&&(E.textContent=qe),Tt=a(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-7bcxx5"&&(R.textContent=Qe),Ut=a(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-ajxwut"&&(F.innerHTML=We),bt=a(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-sk0ezl"&&(T.innerHTML=Se),Jt=a(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1t3wmxk"&&(B.textContent=ze),xt=a(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-9qf0i2"&&(P.textContent=ke),$t=a(s),M(V.$$.fragment,s),Ct=a(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-i4yoac"&&(X.innerHTML=Ye),gt=a(s),M(O.$$.fragment,s),dt=a(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1mvdyro"&&(K.innerHTML=Ge),wt=a(s),M(ss.$$.fragment,s),vt=a(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-q0jbem"&&(ts.textContent=De),It=a(s),M(es.$$.fragment,s),Nt=a(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-dpdp8o"&&(ls.innerHTML=Ae),_t=a(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-nhracm"&&(ns.textContent=Ee),Ht=a(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-bqfzrn"&&(U.innerHTML=Re),Lt=a(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-8np7kl"&&(as.textContent=Fe),Zt=a(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1t2za6k"&&(b.innerHTML=Be),qt=a(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-1trtdyo"&&(ps.innerHTML=Pe),Qt=a(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-1sstogo"&&(J.innerHTML=Ve),Wt=a(s),is=i(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-4dm6ct"&&(is.textContent=Xe),St=a(s),M(ms.$$.fragment,s),zt=a(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-1mt2yih"&&(os.textContent=Oe),kt=a(s),M(Ms.$$.fragment,s),Yt=a(s),us=i(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-1dl0tzy"&&(us.innerHTML=Ke),Gt=a(s),cs=i(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-104oux4"&&(cs.textContent=sl),Dt=a(s),M(ys.$$.fragment,s),At=a(s),fs=i(s,"P",{"data-svelte-h":!0}),m(fs)!=="svelte-1ye8nye"&&(fs.innerHTML=tl),Et=a(s),M(rs.$$.fragment,s),Rt=a(s),hs=i(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-1m9d93j"&&(hs.textContent=el),Ft=a(s),M(js.$$.fragment,s),Bt=a(s),Ts=i(s,"P",{"data-svelte-h":!0}),m(Ts)!=="svelte-1mvdyro"&&(Ts.innerHTML=ll),Pt=a(s),M(Us.$$.fragment,s),Vt=a(s),bs=i(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-1519t0r"&&(bs.innerHTML=nl),Xt=a(s),Js=i(s,"P",{"data-svelte-h":!0}),m(Js)!=="svelte-juxvqf"&&(Js.textContent=al),Ot=a(s),M(xs.$$.fragment,s),Kt=a(s),$s=i(s,"P",{"data-svelte-h":!0}),m($s)!=="svelte-1mqwwhn"&&($s.innerHTML=pl),se=a(s),Cs=i(s,"P",{"data-svelte-h":!0}),m(Cs)!=="svelte-1lwceaq"&&(Cs.textContent=il),te=a(s),gs=i(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-13ya0h5"&&(gs.innerHTML=ml),ee=a(s),ds=i(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-pd07zn"&&(ds.textContent=ol),le=a(s),ws=i(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-1gwtc8z"&&(ws.innerHTML=Ml),ne=a(s),M(vs.$$.fragment,s),ae=a(s),Is=i(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-outb36"&&(Is.innerHTML=ul),pe=a(s),M(Ns.$$.fragment,s),ie=a(s),_s=i(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-1to7bbm"&&(_s.innerHTML=cl),me=a(s),M(Hs.$$.fragment,s),oe=a(s),Ls=i(s,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-1mvdyro"&&(Ls.innerHTML=yl),Me=a(s),M(Zs.$$.fragment,s),ue=a(s),qs=i(s,"P",{"data-svelte-h":!0}),m(qs)!=="svelte-184c90m"&&(qs.textContent=fl),ce=a(s),M(Qs.$$.fragment,s),ye=a(s),Ws=i(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-9ybn5p"&&(Ws.textContent=rl),fe=a(s),Ss=i(s,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-cd2td6"&&(Ss.innerHTML=hl),re=a(s),M(zs.$$.fragment,s),he=a(s),ks=i(s,"P",{"data-svelte-h":!0}),m(ks)!=="svelte-qfel0u"&&(ks.innerHTML=jl),je=a(s),Ys=i(s,"P",{"data-svelte-h":!0}),m(Ys)!=="svelte-neppwa"&&(Ys.innerHTML=Tl),Te=a(s),Gs=i(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-47lk6o"&&(Gs.innerHTML=Ul),Ue=a(s),M(Ds.$$.fragment,s),be=a(s),Rs=i(s,"P",{}),bl(Rs).forEach(e),this.h()},h(){As(h,"name","hf:doc:metadata"),As(h,"content",_l),As(T,"class","flex justify-center"),As(U,"class","flex justify-center"),As(b,"class","flex justify-center"),As(J,"class","flex justify-center")},m(s,t){wl(document.head,h),l(s,Fs,t),l(s,Es,t),l(s,Bs,t),u(x,s,t),l(s,Ps,t),u($,s,t),l(s,Vs,t),l(s,C,t),l(s,Xs,t),l(s,g,t),l(s,Os,t),l(s,d,t),l(s,Ks,t),l(s,w,t),l(s,st,t),u(v,s,t),l(s,tt,t),l(s,I,t),l(s,et,t),u(N,s,t),l(s,lt,t),u(_,s,t),l(s,nt,t),l(s,H,t),l(s,at,t),u(L,s,t),l(s,pt,t),l(s,Z,t),l(s,it,t),u(q,s,t),l(s,mt,t),l(s,Q,t),l(s,ot,t),u(W,s,t),l(s,Mt,t),l(s,S,t),l(s,ut,t),u(z,s,t),l(s,ct,t),l(s,k,t),l(s,yt,t),u(Y,s,t),l(s,ft,t),l(s,G,t),l(s,rt,t),u(D,s,t),l(s,ht,t),l(s,A,t),l(s,jt,t),l(s,E,t),l(s,Tt,t),l(s,R,t),l(s,Ut,t),l(s,F,t),l(s,bt,t),l(s,T,t),l(s,Jt,t),l(s,B,t),l(s,xt,t),l(s,P,t),l(s,$t,t),u(V,s,t),l(s,Ct,t),l(s,X,t),l(s,gt,t),u(O,s,t),l(s,dt,t),l(s,K,t),l(s,wt,t),u(ss,s,t),l(s,vt,t),l(s,ts,t),l(s,It,t),u(es,s,t),l(s,Nt,t),l(s,ls,t),l(s,_t,t),l(s,ns,t),l(s,Ht,t),l(s,U,t),l(s,Lt,t),l(s,as,t),l(s,Zt,t),l(s,b,t),l(s,qt,t),l(s,ps,t),l(s,Qt,t),l(s,J,t),l(s,Wt,t),l(s,is,t),l(s,St,t),u(ms,s,t),l(s,zt,t),l(s,os,t),l(s,kt,t),u(Ms,s,t),l(s,Yt,t),l(s,us,t),l(s,Gt,t),l(s,cs,t),l(s,Dt,t),u(ys,s,t),l(s,At,t),l(s,fs,t),l(s,Et,t),u(rs,s,t),l(s,Rt,t),l(s,hs,t),l(s,Ft,t),u(js,s,t),l(s,Bt,t),l(s,Ts,t),l(s,Pt,t),u(Us,s,t),l(s,Vt,t),l(s,bs,t),l(s,Xt,t),l(s,Js,t),l(s,Ot,t),u(xs,s,t),l(s,Kt,t),l(s,$s,t),l(s,se,t),l(s,Cs,t),l(s,te,t),l(s,gs,t),l(s,ee,t),l(s,ds,t),l(s,le,t),l(s,ws,t),l(s,ne,t),u(vs,s,t),l(s,ae,t),l(s,Is,t),l(s,pe,t),u(Ns,s,t),l(s,ie,t),l(s,_s,t),l(s,me,t),u(Hs,s,t),l(s,oe,t),l(s,Ls,t),l(s,Me,t),u(Zs,s,t),l(s,ue,t),l(s,qs,t),l(s,ce,t),u(Qs,s,t),l(s,ye,t),l(s,Ws,t),l(s,fe,t),l(s,Ss,t),l(s,re,t),u(zs,s,t),l(s,he,t),l(s,ks,t),l(s,je,t),l(s,Ys,t),l(s,Te,t),l(s,Gs,t),l(s,Ue,t),u(Ds,s,t),l(s,be,t),l(s,Rs,t),Je=!0},p:xl,i(s){Je||(c(x.$$.fragment,s),c($.$$.fragment,s),c(v.$$.fragment,s),c(N.$$.fragment,s),c(_.$$.fragment,s),c(L.$$.fragment,s),c(q.$$.fragment,s),c(W.$$.fragment,s),c(z.$$.fragment,s),c(Y.$$.fragment,s),c(D.$$.fragment,s),c(V.$$.fragment,s),c(O.$$.fragment,s),c(ss.$$.fragment,s),c(es.$$.fragment,s),c(ms.$$.fragment,s),c(Ms.$$.fragment,s),c(ys.$$.fragment,s),c(rs.$$.fragment,s),c(js.$$.fragment,s),c(Us.$$.fragment,s),c(xs.$$.fragment,s),c(vs.$$.fragment,s),c(Ns.$$.fragment,s),c(Hs.$$.fragment,s),c(Zs.$$.fragment,s),c(Qs.$$.fragment,s),c(zs.$$.fragment,s),c(Ds.$$.fragment,s),Je=!0)},o(s){y(x.$$.fragment,s),y($.$$.fragment,s),y(v.$$.fragment,s),y(N.$$.fragment,s),y(_.$$.fragment,s),y(L.$$.fragment,s),y(q.$$.fragment,s),y(W.$$.fragment,s),y(z.$$.fragment,s),y(Y.$$.fragment,s),y(D.$$.fragment,s),y(V.$$.fragment,s),y(O.$$.fragment,s),y(ss.$$.fragment,s),y(es.$$.fragment,s),y(ms.$$.fragment,s),y(Ms.$$.fragment,s),y(ys.$$.fragment,s),y(rs.$$.fragment,s),y(js.$$.fragment,s),y(Us.$$.fragment,s),y(xs.$$.fragment,s),y(vs.$$.fragment,s),y(Ns.$$.fragment,s),y(Hs.$$.fragment,s),y(Zs.$$.fragment,s),y(Qs.$$.fragment,s),y(zs.$$.fragment,s),y(Ds.$$.fragment,s),Je=!1},d(s){s&&(e(Fs),e(Es),e(Bs),e(Ps),e(Vs),e(C),e(Xs),e(g),e(Os),e(d),e(Ks),e(w),e(st),e(tt),e(I),e(et),e(lt),e(nt),e(H),e(at),e(pt),e(Z),e(it),e(mt),e(Q),e(ot),e(Mt),e(S),e(ut),e(ct),e(k),e(yt),e(ft),e(G),e(rt),e(ht),e(A),e(jt),e(E),e(Tt),e(R),e(Ut),e(F),e(bt),e(T),e(Jt),e(B),e(xt),e(P),e($t),e(Ct),e(X),e(gt),e(dt),e(K),e(wt),e(vt),e(ts),e(It),e(Nt),e(ls),e(_t),e(ns),e(Ht),e(U),e(Lt),e(as),e(Zt),e(b),e(qt),e(ps),e(Qt),e(J),e(Wt),e(is),e(St),e(zt),e(os),e(kt),e(Yt),e(us),e(Gt),e(cs),e(Dt),e(At),e(fs),e(Et),e(Rt),e(hs),e(Ft),e(Bt),e(Ts),e(Pt),e(Vt),e(bs),e(Xt),e(Js),e(Ot),e(Kt),e($s),e(se),e(Cs),e(te),e(gs),e(ee),e(ds),e(le),e(ws),e(ne),e(ae),e(Is),e(pe),e(ie),e(_s),e(me),e(oe),e(Ls),e(Me),e(ue),e(qs),e(ce),e(ye),e(Ws),e(fe),e(Ss),e(re),e(he),e(ks),e(je),e(Ys),e(Te),e(Gs),e(Ue),e(be),e(Rs)),e(h),f(x,s),f($,s),f(v,s),f(N,s),f(_,s),f(L,s),f(q,s),f(W,s),f(z,s),f(Y,s),f(D,s),f(V,s),f(O,s),f(ss,s),f(es,s),f(ms,s),f(Ms,s),f(ys,s),f(rs,s),f(js,s),f(Us,s),f(xs,s),f(vs,s),f(Ns,s),f(Hs,s),f(Zs,s),f(Qs,s),f(zs,s),f(Ds,s)}}}const _l='{"title":"Предварительно обученные модели и наборы данных для классификации звука","local":"предварительно-обученные-модели-и-наборы-данных-для-классификации-звука","sections":[{"title":"🤗 Установка библиотеки Transformers","local":"-установка-библиотеки-transformers","sections":[],"depth":2},{"title":"Поиск ключевых слов","local":"поиск-ключевых-слов","sections":[{"title":"Minds-14","local":"minds-14","sections":[],"depth":3},{"title":"Speech Commands","local":"speech-commands","sections":[],"depth":3}],"depth":2},{"title":"Идентификация языка (Language Identification)","local":"идентификация-языка-language-identification","sections":[{"title":"FLEURS","local":"fleurs","sections":[],"depth":3}],"depth":2},{"title":"Zero-Shot Audio Classification","local":"zero-shot-audio-classification","sections":[],"depth":2},{"title":"Что дальше?","local":"что-дальше","sections":[],"depth":2}],"depth":1}';function Hl(xe){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends Cl{constructor(h){super(),gl(this,h,Hl,Nl,Jl,{})}}export{Wl as component};
