# Avalie seus conhecimentos

### 1. Em que unidades a taxa de amostragem é medida?

### 2. Ao usar o streaming de um grande dataset de áudio, em que momento ele se torna disponível para usá-lo?

### 3. O que é um espectrograma?

### 4. Qual é a maneira mais fácil de converter dados de áudio brutos em espectrograma log-mel esperado pelo Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### 5. Como você carrega um conjunto de dados do 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### 6. Seu dataset personalizado contém áudios de alta qualidade com taxa de amostragem de 32 kHz. Você quer treinar um modelo de reconhecimento de fala que espera que os exemplos de áudio tenham uma taxa de amostragem de 16 kHz. O que você deve fazer?

### 7. Como você pode converter um espectrograma gerado por um modelo de machine learning em uma forma de onda?

