# Bem vindo ao curso de Áudio do Hugging Face!

Caro aluno,

Bem vindo a este curso sobre o uso de transformers para áudio. Cada vez mais os transformers se provam como uma das arquiteturas deep learning mais poderosas e versáteis, capaz de alcançar resultados de ponta em uma variedade de tarefas, incluindo o processamento de linguagem natural, visão computacional, e mais recentemente, processamento de áudio.

Neste curso, nós iremos explorar como os transformers podem ser usados em dados de áudio. Você aprenderá como usá-los para lidar com uma série de tarefas relacionadas ao áudio. Se você está interessado em reconhecimento de fala, classificação de áudio, ou geração de fala a partir do texto, os transformers e este curso vão atender as suas necessidades.

Para te dar um gostinho do que esses modelos podem fazer, diga algumas palavras na demo abaixo e veja o modelo transcrevê-las em tempo real!

Através do curso, você entenderá detalhes do trabalho com dados de áudio, aprenderá sobre as diferentes arquiteturas de transformers e irá treinar seu próprio transformer de áudio aproveitando poderosos modelos pré-treinados.

Este curso é voltado para estudantes com algum conhecimento prévio em deep learning e transformers. Nenhuma expertise em processamento de áudio é necessária. Se você precisa revisar seu conhecimento de transformers, dê uma olhada no nosso [curso de NLP](https://huggingface.co/course/chapter1/1) que aborda em detalhes os conceitos básicos de transformers.

## Conheça a equipe do curso

**Sanchit Gandhi, Engenheiro de Pesquisa em Machine Learning no Hugging Face**

Olá! Me chamo Sanchit e sou o engenheiro de pesquisa em machine learning para áudio no time de open-source do Hugging Face 🤗. Meu foco principal é o reconhecimento e a tradução automáticos de fala, com o objetivo atual de tornar os modelos de fala mais rápidos, leves e fáceis de usar!

**Matthijs Hollemans, Engenheiro de Machine Learning no Hugging Face**

Me chamo Matthijs, e sou o engenheiro de machine learning para áudio no time de open source do Hugging Face. Eu também sou o autor do livro sobre como escrever um sintetizador de som e crio plugins de áudio no meu tempo livre.

**Maria Khalusova, Cursos & Documentação no Hugging Face**

Eu sou Maria e crio conteúdo educacional e documentação para fazer os Transformers e outras ferramentas open source ainda mais acessíveis. Eu simplifico conceitos técnicos complexos e ajudo as pessoas a iniciarem em tecnologias de ponta.

**Vaibhav Srivastav, ML Developer Advocate Engineer no Hugging Face**

Me chamo Vaibhav (VB) e sou o Engenheiro Developer Advocate para áudio no time de open source do Hugging Face. Eu estudo soluções de Texto para Fala de baixo recurso e ajudo a levar pesquisas estado da arte em fala para o grande público.

## Estrutura do Curso

O curso está estruturado em várias unidades que abordam diversos tópicos em detalhes:

* [Unidade 1](https://huggingface.co/learn/audio-course/chapter1): aprenda sobre detalhes do trabalho com dados de áudio, incluindo técnicas de processamento de áudio e preparação de dados.
* [Unidade 2](https://huggingface.co/learn/audio-course/chapter2): conheça aplicações de áudio e aprenda como usar 🤗 Transformers pipelines para diferentes tarefas, como classificação de áudio e reconhecimento de fala.
* [Unidade 3](https://huggingface.co/learn/audio-course/chapter3): explore arquiteturas de transformers de áudio, aprenda como eles se diferem e para quais tarefas são mais adequados
* [Unidade 4](https://huggingface.co/learn/audio-course/chapter4): aprenda como fazer seu próprio classificador de gênero musical
* [Unidade 5](https://huggingface.co/learn/audio-course/chapter5): mergulhe no reconhecimento de fala e construa um modelo que faça transcrição de reuniões gravadas
* [Unidade 6](https://huggingface.co/learn/audio-course/chapter6): aprenda como gerar fala a partir do texto
* [Unidade 7](https://huggingface.co/learn/audio-course/chapter7): aprenda como construir aplicações do mundo real com transformers

Cada unidade inclui uma parte teórica, onde você irá compreender os conceitos e as técnicas. Ao longo do curso, nós vamos fornecer questionários para te ajudar a testar seu conhecimento e reforçar seu aprendizado. Alguns capítulos incluem exercícios práticos, onde você terá a oportunidade de testar o que você aprendeu.

No final do curso, você terá uma base sólida sobre o uso de transformers para os dados de áudio e está pronto para aplicar essas técnicas em uma varidade de tarefas relacionadas à áudio.

Este curso será lançado em vários blocos consecutivos respeitando o seguinte agendamento:

| Unidades   				  	|Data de Publicação |
|-------------------------------|-------------------|
| Unidade 0, 1 e 2  		  	| 14 de Junho 2023  |
| Unidade 3 e 4  		  		| 21 de Junho 2023  |
| Unidade 5			  		  	| 28 de Junho 2023  |
| Unidade 6  		  			| 5 de Julho 2023  	|	
| Unidade 7 e 8 		  		| 12 de Julho 2023  |

## Trilhas de aprendizado e certificação

Não existe um jeito certo ou errado de fazer este curso. Todos os materiais nesse curso são 100% gratuitos, públicos e open source.
Você pode fazer o curso no seu próprio ritmo, contudo, nós recomendamos ir na ordem numérica das unidades.

Se você quiser obter um certificado ao completar o curso, nós oferecemos duas opções:

| Tipo Certificado   | Requisitos                                                       |
|---|--------------------------------------------------------------------|
| Certificado de conclusão  | Complete 80% dos exercícios práticos conforme as instruções  |
| Certificado de honras  | Complete 100% dos exercícios práticos conforme as instruções |

Cada exercício determina seus critérios de conclusão. Quando você concluir exercícios suficiente para se qualificar para algum dos certificados, vá a última unidade para aprender como você pode obtê-lo. Bons estudos!

## Inscreva-se no curso

As unidades deste curso serão lançadas gradualmente ao longo de algumas semanas. Encorajamos você a se inscrever nas atualizações, assim você fica sabendo das unidades assim que elas forem lançadas. Ao se inscrever nas atualizações do curso, o estudante também ficará sabendo em primeira mão, sobre eventos sociais que nós planejamos realizar.

[INSCREVA-SE](http://eepurl.com/insvcI)

Aproveite o curso!

