import{s as Ea,o as Ya}from"../chunks/scheduler.a045fce0.js";import{S as Va,i as Ha,e as r,s as o,c as i,h as Fa,a as n,d as s,b as l,f as Na,g as d,j as m,k as da,l as Xa,m as t,n as p,t as u,o as M,p as c,q as Qa,r as Sa}from"../chunks/index.bc14ef44.js";import{T as La}from"../chunks/Tip.3a2ad1d6.js";import{C as Pa,H as ia,E as Da}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.a8501855.js";import{C as j}from"../chunks/CodeBlock.c19e5c8a.js";function Oa(Me){let f;return{c(){f=Qa("💡 Algumas informações sobre a reamostragem (resampling): Se um sinal de áudio foi amostrado a 8 kHz, de modo que possui 8000 amostras coletadas por segundo, sabemos que o áudio não contém frequências acima de 4 kHz. Isso é garantido pelo teorema de Nyquist. Com base nisso, podemos assumir que entre as amostras de um sinal contínuo, especificamente os pontos que existem entre elas, e não foram coletados, devido a amostragem, formam uma curva suave. Então, aumentar a taxa de amostragem para um valor mais alto é apenas uma questão de calcular valores de amostra adicionais que vão entre os existentes, formando essa curva suave. No entanto, diminuir a amostragem (downsampling) requer primeiro filtrar quaisquer frequências que seriam maiores que o novo limite de Nyquist, antes de estimar os novos pontos de amostra (pois diminuindo a amostragem, a frequência máxima também diminuiria). Em outras palavras, você não pode diminuir a amostragem por um fator de 2x simplesmente descartando todas as outras amostras - isso criará distorções no sinal chamadas de alias. Fazer a reamostragem corretamente é complicado e é melhor deixar para bibliotecas bem testadas como librosa ou 🤗 Datasets.")},l(y){f=Sa(y,"💡 Algumas informações sobre a reamostragem (resampling): Se um sinal de áudio foi amostrado a 8 kHz, de modo que possui 8000 amostras coletadas por segundo, sabemos que o áudio não contém frequências acima de 4 kHz. Isso é garantido pelo teorema de Nyquist. Com base nisso, podemos assumir que entre as amostras de um sinal contínuo, especificamente os pontos que existem entre elas, e não foram coletados, devido a amostragem, formam uma curva suave. Então, aumentar a taxa de amostragem para um valor mais alto é apenas uma questão de calcular valores de amostra adicionais que vão entre os existentes, formando essa curva suave. No entanto, diminuir a amostragem (downsampling) requer primeiro filtrar quaisquer frequências que seriam maiores que o novo limite de Nyquist, antes de estimar os novos pontos de amostra (pois diminuindo a amostragem, a frequência máxima também diminuiria). Em outras palavras, você não pode diminuir a amostragem por um fator de 2x simplesmente descartando todas as outras amostras - isso criará distorções no sinal chamadas de alias. Fazer a reamostragem corretamente é complicado e é melhor deixar para bibliotecas bem testadas como librosa ou 🤗 Datasets.")},m(y,U){t(y,f,U)},d(y){y&&s(f)}}}function Ka(Me){let f,y,U,ce,h,fe,w,je,b,pa="Carregar um dataset com 🤗 Datasets é parte da brincadeira. Se você planeja usá-lo para treinar um modelo, ou para executar inferência, você precisará pré-processar os dados primeiro. Geralmente, isso se resume nas seguintes etapas:",ye,g,ua="<li>Reamostragem (resampling) dos dados de áudio</li> <li>Filtragem do dataset</li> <li>Conversão dos dados de áudio para a formato esperado pelo modelo</li>",Je,I,Te,C,Ma="A função <code>load_dataset</code> baixa exemplos de áudio com a taxa de amostragem na qual foram publicados. Esta não é sempre a taxa de amostragem esperada por um modelo que você planeja treinar, ou usar para inferência. Se houver uma diferença entre as taxas de amostragem, você pode reamostrar (resample) o áudio para a taxa de amostragem esperada pelo modelo.",Ue,A,ca="A maioria dos modelos pré-treinados disponíveis foram treinados em datasets de áudio com uma taxa de amostragem de 16 kHz. Quando exploramos o dataset MINDS-14, você pode ter notado que ele é amostrado a 8 kHz, o que significa que provavelmente precisaremos aumentar a amostragem.",he,v,fa="Para fazer isso, use o método <code>cast_column</code> de 🤗 Datasets. Esta operação não altera o arquivo de áudio baixado, mas indica aos datasets para reamostrar os exemplos de áudio sob demanda a medida que forem carregados. O seguinte código definirá a taxa de amostragem para 16kHz:",we,x,be,$,ja="Recarregue o primeiro exemplo de áudio no dataset MINDS-14, e verifique se ele foi reamostrado para a <code>taxa de amostragem</code> desejada:",ge,q,Ie,z,ya="<strong>Saída:</strong>",Ce,_,Ae,k,Ja="Repare que os valores do array também estão diferentes agora. Isso ocorre porque agora temos o dobro do número de valores de amplitude para cada um que tínhamos antes.",ve,J,xe,B,$e,G,Ta="Talvez você precise filtrar os dados com base em alguns critérios. Um dos casos comuns envolve limitar os exemplos de áudio a uma certa duração. Por exemplo, podemos querer ignorar quaisquer exemplos mais longos que 20s para prevenir erros de falta de memória ao treinar um modelo.",qe,R,Ua="Podemos fazer isso usando o método <code>filter</code> da 🤗 Datasets e passando uma função com a lógica de filtragem para ele. Vamos começar escrevendo uma função que indica quais exemplos manter e quais descartar. Esta função, <code>is_audio_length_in_range</code>, retorna <code>True</code> se a duração for menor 20s, e <code>False</code> se for maior.",ze,W,_e,Z,ha="A função de filtragem pode ser aplicada a uma coluna do dataset, mas não temos uma coluna com a duração da do áudio neste dataset. No entanto, podemos criar uma, filtrar com base nos valores dessa coluna e, em seguida, removê-la.",ke,N,Be,E,wa="<strong>Saída:</strong>",Ge,Y,Re,V,ba="Perceba que o dataset foi filtrado de 654 exemplos para 624 (num_rows).",We,H,Ze,F,ga="Um dos aspectos mais desafiadores de trabalhar com datasets de áudio é preparar os dados no formato correto para o treinamento do modelo. Como você viu, os dados de áudio brutos vêm como um array de valores de amostras (do sinal original). No entanto, modelos pré-treinados, seja para usá-los em inferência, seja para ajustá-los (fine tuning) ao seu projeto, esperam que os dados brutos sejam convertidos em características (features) de entrada. Os requisitos para as características de entrada podem variar de um modelo para outro - eles dependem da arquitetura do modelo e dos dados com os quais foi pré-treinado. A boa notícia é que, para cada modelo de áudio suportado, 🤗 Transformers oferece uma classe de extrator de características (feature extractor) que pode converter dados de áudio brutos nas características de entrada que o modelo espera.",Ne,X,Ia='Então, o que um extrator de características faz com os dados de áudio brutos? Vamos dar uma olhada extrator de características chamado <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a> para entender algumas transformações comuns de extração de características. Whisper é um modelo pré-treinado para reconhecimento automático de fala (ASR) publicado em setembro de 2022 por Alec Radford et al. da OpenAI.',Ee,Q,Ca="Primeiro, o extrator de características do Whisper preenche/corta um grupo (batch) de exemplos de áudio de forma que todos os exemplos tenham uma duração de 30s. Exemplos mais curtos que isso são complementados com zeros no final, até formar 30s de duração (zeros em um sinal de áudio correspondem a silêncio ou nada de sinal). Exemplos que tem mais de 30s são cortados nos 30s. Uma vez que todos os elementos no grupo são padronizados para uma duração fixa, não há necessidade de uma máscara de atenção (attention mask). O Whisper é único neste aspecto, a maioria dos outros modelos de áudio requer uma máscara de atenção que detalha onde as sequências foram preenchidas, e assim onde elas devem ser ignoradas no mecanismo de auto-atenção (self-attention). O Whisper é treinado para operar sem uma máscara de atenção e inferir do próprio sinal onde ele deve ignorar.",Ye,S,Aa="A segunda operação que o extrator de características do Whisper realiza é converter os arrays de áudio padronizados em espectrogramas log-mel. Lembre que esses espectrogramas descrevem como as frequências de um sinal mudam ao longo do tempo, expressas na escala mel e medidas em decibéis (a parte do log) para tornar as frequências e amplitudes mais representativas da audição humana.",Ve,L,va="Todas essas transformações podem ser aplicadas aos seus dados de áudio brutos com algumas poucas linhas de código. Vamos colocar a mão na massa e carregar o extrator de características a partir do checkpoint pré-treinado do Whisper e deixá-lo pronto para usar nos nossos dados de áudio:",He,P,Fe,D,xa="Então, você pode escrever uma função para pré-processar um exemplo de áudio, passando ele para o <code>feature_extractor</code>.",Xe,O,Qe,K,$a="Podemos aplicar a função de preparação de dados a todos os nossos exemplos de treinamento usando o método <code>map</code> de 🤗 Datasets:",Se,ee,Le,ae,qa="<strong>Saída:</strong>",Pe,se,De,te,za="Sem muito esforço, agora temos espectrogramas log-mel no campo <code>input_features</code> do dataset.",Oe,oe,_a="Vamos visualizá-lo em dos exemplos do dataset <code>minds</code>:",Ke,le,ea,T,ka='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Gráfico de espectrograma log mel"/>',aa,re,Ba="Agora você pode ver como fica um input de áudio para o modelo Whisper após o pré-processamento.",sa,ne,Ga='A classe de extrator de características do modelo cuida de transformar os dados de áudio brutos para o formato que o modelo espera. No entanto, muitas tarefas envolvendo áudio são multimodais, como, por exemplo, o reconhecimento de fala. Nestes casos, 🤗 Transformers também oferece tokenizadores (tokenizers) específicos do modelo para processar as entradas de texto. Para se aprofundar em tokenizadores, consulte nosso <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">curso de NLP</a>.',ta,me,Ra="Você pode carregar o extrator de características e o tokenizador do Whisper (e outros modelos multimodais) separadamente, ou você pode carregar ambos por meio de algo chamado de processor (processador). Para simplificar ainda mais, use <code>AutoProcessor</code> para carregar o extrator de características e processador de um modelo a partir de um checkpoint, assim:",oa,ie,la,de,Wa='Aqui mostramos os passos fundamentais de preparação dos dados. Claro, dados personalizados podem exigir pré-processamento mais complexo. Neste caso, você pode estender a função <code>prepare_dataset</code> para realizar qualquer tipo de transformação de dados personalizada. Com 🤗 Datasets, se você pode escrever sua personalização como uma função Python, então você pode <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">aplicá-la</a> ao seu dataset!',ra,pe,na,ue,ma;return h=new Pa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ia({props:{title:"Pré-processamento de um dataset de áudio",local:"pré-processamento-de-um-dataset-de-áudio",headingTag:"h1"}}),I=new ia({props:{title:"Reamostragem dos dados de áudio",local:"reamostragem-dos-dados-de-áudio",headingTag:"h2"}}),x=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),q=new j({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),J=new La({props:{$$slots:{default:[Oa]},$$scope:{ctx:Me}}}),B=new ia({props:{title:"Filtragem do dataset",local:"filtragem-do-dataset",headingTag:"h2"}}),W=new j({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),N=new j({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHBhcmElMjBvYnRlciUyMGElMjBkdXJhJUMzJUE3JUMzJUEzbyUyMGRvJTIwJUMzJUExdWRpbyUwQW5ld19jb2x1bW4lMjAlM0QlMjAlNUJsaWJyb3NhLmdldF9kdXJhdGlvbihwYXRoJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMHVzZSUyMG8lMjBtJUMzJUE5dG9kbyUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwYXJhJTIwYXBsaWNhciUyMGElMjBmdW4lQzMlQTclQzMlQTNvJTIwZGUlMjBmaWx0cmFnZW0lMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwcmVtb3ZhJTIwYSUyMGNvbHVuYSUyMGF1eGlsaWFyJTIwdGVtcG9yJUMzJUExcmlhJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJkdXJhdGlvbiUyMiU1RCklMEFtaW5kcw==",highlighted:`<span class="hljs-comment"># use librosa para obter a duração do áudio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use o método \`filter\` de 🤗 Datasets para aplicar a função de filtragem</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remova a coluna auxiliar temporária</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),Y=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),H=new ia({props:{title:"Pré-processamento dos dados de áudio",local:"pré-processamento-dos-dados-de-áudio",headingTag:"h2"}}),P=new j({props:{code:"JTIzJTIwSW5zdGFsZSUyMGNvbSUyMG8lMjBjb21hbmRvJTNBJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQSUyMyUyMFZvYyVDMyVBQSUyMHBvZGUlMjBhY2Vzc2FyJTIwYSUyMHAlQzMlQTFnaW5hJTIwaW5jaWFsJTIwZG9zJTIwVHJhbnNmb3JtZXJzJTIwcGFyYSUyMGluc3RydSVDMyVBNyVDMyVCNWVzJTIwZGUlMjBpbnN0YWxhJUMzJUE3JUMzJUEzbyElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwV2hpc3BlckZlYXR1cmVFeHRyYWN0b3IlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-comment"># Instale com o comando: pip install transformers</span>
<span class="hljs-comment"># Você pode acessar a página incial dos Transformers para instruções de instalação!</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),O=new j({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),ee=new j({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),se=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),le=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),ie=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),pe=new Da({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/pt-BR/chapter1/preprocessing.mdx"}}),{c(){f=r("meta"),y=o(),U=r("p"),ce=o(),i(h.$$.fragment),fe=o(),i(w.$$.fragment),je=o(),b=r("p"),b.textContent=pa,ye=o(),g=r("ul"),g.innerHTML=ua,Je=o(),i(I.$$.fragment),Te=o(),C=r("p"),C.innerHTML=Ma,Ue=o(),A=r("p"),A.textContent=ca,he=o(),v=r("p"),v.innerHTML=fa,we=o(),i(x.$$.fragment),be=o(),$=r("p"),$.innerHTML=ja,ge=o(),i(q.$$.fragment),Ie=o(),z=r("p"),z.innerHTML=ya,Ce=o(),i(_.$$.fragment),Ae=o(),k=r("p"),k.textContent=Ja,ve=o(),i(J.$$.fragment),xe=o(),i(B.$$.fragment),$e=o(),G=r("p"),G.textContent=Ta,qe=o(),R=r("p"),R.innerHTML=Ua,ze=o(),i(W.$$.fragment),_e=o(),Z=r("p"),Z.textContent=ha,ke=o(),i(N.$$.fragment),Be=o(),E=r("p"),E.innerHTML=wa,Ge=o(),i(Y.$$.fragment),Re=o(),V=r("p"),V.textContent=ba,We=o(),i(H.$$.fragment),Ze=o(),F=r("p"),F.textContent=ga,Ne=o(),X=r("p"),X.innerHTML=Ia,Ee=o(),Q=r("p"),Q.textContent=Ca,Ye=o(),S=r("p"),S.textContent=Aa,Ve=o(),L=r("p"),L.textContent=va,He=o(),i(P.$$.fragment),Fe=o(),D=r("p"),D.innerHTML=xa,Xe=o(),i(O.$$.fragment),Qe=o(),K=r("p"),K.innerHTML=$a,Se=o(),i(ee.$$.fragment),Le=o(),ae=r("p"),ae.innerHTML=qa,Pe=o(),i(se.$$.fragment),De=o(),te=r("p"),te.innerHTML=za,Oe=o(),oe=r("p"),oe.innerHTML=_a,Ke=o(),i(le.$$.fragment),ea=o(),T=r("div"),T.innerHTML=ka,aa=o(),re=r("p"),re.textContent=Ba,sa=o(),ne=r("p"),ne.innerHTML=Ga,ta=o(),me=r("p"),me.innerHTML=Ra,oa=o(),i(ie.$$.fragment),la=o(),de=r("p"),de.innerHTML=Wa,ra=o(),i(pe.$$.fragment),na=o(),ue=r("p"),this.h()},l(e){const a=Fa("svelte-u9bgzb",document.head);f=n(a,"META",{name:!0,content:!0}),a.forEach(s),y=l(e),U=n(e,"P",{}),Na(U).forEach(s),ce=l(e),d(h.$$.fragment,e),fe=l(e),d(w.$$.fragment,e),je=l(e),b=n(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-lvwhhl"&&(b.textContent=pa),ye=l(e),g=n(e,"UL",{"data-svelte-h":!0}),m(g)!=="svelte-1b4cyan"&&(g.innerHTML=ua),Je=l(e),d(I.$$.fragment,e),Te=l(e),C=n(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1u9skk8"&&(C.innerHTML=Ma),Ue=l(e),A=n(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-marfpr"&&(A.textContent=ca),he=l(e),v=n(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1o1bxi6"&&(v.innerHTML=fa),we=l(e),d(x.$$.fragment,e),be=l(e),$=n(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-13lb6so"&&($.innerHTML=ja),ge=l(e),d(q.$$.fragment,e),Ie=l(e),z=n(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1usoza3"&&(z.innerHTML=ya),Ce=l(e),d(_.$$.fragment,e),Ae=l(e),k=n(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1fk04pf"&&(k.textContent=Ja),ve=l(e),d(J.$$.fragment,e),xe=l(e),d(B.$$.fragment,e),$e=l(e),G=n(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-eo5ip5"&&(G.textContent=Ta),qe=l(e),R=n(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-yl0fth"&&(R.innerHTML=Ua),ze=l(e),d(W.$$.fragment,e),_e=l(e),Z=n(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2zshoe"&&(Z.textContent=ha),ke=l(e),d(N.$$.fragment,e),Be=l(e),E=n(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1usoza3"&&(E.innerHTML=wa),Ge=l(e),d(Y.$$.fragment,e),Re=l(e),V=n(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1hcj7t1"&&(V.textContent=ba),We=l(e),d(H.$$.fragment,e),Ze=l(e),F=n(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-42caqy"&&(F.textContent=ga),Ne=l(e),X=n(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-hy1g44"&&(X.innerHTML=Ia),Ee=l(e),Q=n(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1o0fi04"&&(Q.textContent=Ca),Ye=l(e),S=n(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-s2y5v4"&&(S.textContent=Aa),Ve=l(e),L=n(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1rwn9ln"&&(L.textContent=va),He=l(e),d(P.$$.fragment,e),Fe=l(e),D=n(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-cupw90"&&(D.innerHTML=xa),Xe=l(e),d(O.$$.fragment,e),Qe=l(e),K=n(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1b4t3v9"&&(K.innerHTML=$a),Se=l(e),d(ee.$$.fragment,e),Le=l(e),ae=n(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1usoza3"&&(ae.innerHTML=qa),Pe=l(e),d(se.$$.fragment,e),De=l(e),te=n(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-ien326"&&(te.innerHTML=za),Oe=l(e),oe=n(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1n38tby"&&(oe.innerHTML=_a),Ke=l(e),d(le.$$.fragment,e),ea=l(e),T=n(e,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-x6says"&&(T.innerHTML=ka),aa=l(e),re=n(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-mpjv2n"&&(re.textContent=Ba),sa=l(e),ne=n(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1g71by9"&&(ne.innerHTML=Ga),ta=l(e),me=n(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1jkytzh"&&(me.innerHTML=Ra),oa=l(e),d(ie.$$.fragment,e),la=l(e),de=n(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-qmlpls"&&(de.innerHTML=Wa),ra=l(e),d(pe.$$.fragment,e),na=l(e),ue=n(e,"P",{}),Na(ue).forEach(s),this.h()},h(){da(f,"name","hf:doc:metadata"),da(f,"content",es),da(T,"class","flex justify-center")},m(e,a){Xa(document.head,f),t(e,y,a),t(e,U,a),t(e,ce,a),p(h,e,a),t(e,fe,a),p(w,e,a),t(e,je,a),t(e,b,a),t(e,ye,a),t(e,g,a),t(e,Je,a),p(I,e,a),t(e,Te,a),t(e,C,a),t(e,Ue,a),t(e,A,a),t(e,he,a),t(e,v,a),t(e,we,a),p(x,e,a),t(e,be,a),t(e,$,a),t(e,ge,a),p(q,e,a),t(e,Ie,a),t(e,z,a),t(e,Ce,a),p(_,e,a),t(e,Ae,a),t(e,k,a),t(e,ve,a),p(J,e,a),t(e,xe,a),p(B,e,a),t(e,$e,a),t(e,G,a),t(e,qe,a),t(e,R,a),t(e,ze,a),p(W,e,a),t(e,_e,a),t(e,Z,a),t(e,ke,a),p(N,e,a),t(e,Be,a),t(e,E,a),t(e,Ge,a),p(Y,e,a),t(e,Re,a),t(e,V,a),t(e,We,a),p(H,e,a),t(e,Ze,a),t(e,F,a),t(e,Ne,a),t(e,X,a),t(e,Ee,a),t(e,Q,a),t(e,Ye,a),t(e,S,a),t(e,Ve,a),t(e,L,a),t(e,He,a),p(P,e,a),t(e,Fe,a),t(e,D,a),t(e,Xe,a),p(O,e,a),t(e,Qe,a),t(e,K,a),t(e,Se,a),p(ee,e,a),t(e,Le,a),t(e,ae,a),t(e,Pe,a),p(se,e,a),t(e,De,a),t(e,te,a),t(e,Oe,a),t(e,oe,a),t(e,Ke,a),p(le,e,a),t(e,ea,a),t(e,T,a),t(e,aa,a),t(e,re,a),t(e,sa,a),t(e,ne,a),t(e,ta,a),t(e,me,a),t(e,oa,a),p(ie,e,a),t(e,la,a),t(e,de,a),t(e,ra,a),p(pe,e,a),t(e,na,a),t(e,ue,a),ma=!0},p(e,[a]){const Za={};a&2&&(Za.$$scope={dirty:a,ctx:e}),J.$set(Za)},i(e){ma||(u(h.$$.fragment,e),u(w.$$.fragment,e),u(I.$$.fragment,e),u(x.$$.fragment,e),u(q.$$.fragment,e),u(_.$$.fragment,e),u(J.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),ma=!0)},o(e){M(h.$$.fragment,e),M(w.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(q.$$.fragment,e),M(_.$$.fragment,e),M(J.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),ma=!1},d(e){e&&(s(y),s(U),s(ce),s(fe),s(je),s(b),s(ye),s(g),s(Je),s(Te),s(C),s(Ue),s(A),s(he),s(v),s(we),s(be),s($),s(ge),s(Ie),s(z),s(Ce),s(Ae),s(k),s(ve),s(xe),s($e),s(G),s(qe),s(R),s(ze),s(_e),s(Z),s(ke),s(Be),s(E),s(Ge),s(Re),s(V),s(We),s(Ze),s(F),s(Ne),s(X),s(Ee),s(Q),s(Ye),s(S),s(Ve),s(L),s(He),s(Fe),s(D),s(Xe),s(Qe),s(K),s(Se),s(Le),s(ae),s(Pe),s(De),s(te),s(Oe),s(oe),s(Ke),s(ea),s(T),s(aa),s(re),s(sa),s(ne),s(ta),s(me),s(oa),s(la),s(de),s(ra),s(na),s(ue)),s(f),c(h,e),c(w,e),c(I,e),c(x,e),c(q,e),c(_,e),c(J,e),c(B,e),c(W,e),c(N,e),c(Y,e),c(H,e),c(P,e),c(O,e),c(ee,e),c(se,e),c(le,e),c(ie,e),c(pe,e)}}}const es='{"title":"Pré-processamento de um dataset de áudio","local":"pré-processamento-de-um-dataset-de-áudio","sections":[{"title":"Reamostragem dos dados de áudio","local":"reamostragem-dos-dados-de-áudio","sections":[],"depth":2},{"title":"Filtragem do dataset","local":"filtragem-do-dataset","sections":[],"depth":2},{"title":"Pré-processamento dos dados de áudio","local":"pré-processamento-dos-dados-de-áudio","sections":[],"depth":2}],"depth":1}';function as(Me){return Ya(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Va{constructor(f){super(),Ha(this,f,as,Ka,Ea,{})}}export{ns as component};
