# 코스에 대한 이해도를 체크해보세요[[check-your-understanding-of-the-course-material]]

### 1. 샘플링 속도는 어떤 단위를 사용합니까?

### 2. 큰 오디오 데이터셋을 스트리밍한다면 어느 시점부터 이를 사용할 수 있습니까?

### 3. 스펙트로그램이란 무엇인가요?

### 4. 원시 오디오 데이터를 Whisper에 적합한 로그-멜 스펙트로그램으로 변환하는 가장 쉬운 방법은?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### 5. 🤗 허브에서 데이터셋을 불러오는 방법은?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### 6. 32 kHz의 샘플링 속도를 가진 고품질 오디오 데이터셋으로 16 kHz 샘플링 속도를 요구하는 음성 인식 모델을 학습하고자 합니다. 그렇다면 무엇을 해야합니까?

### 7. 머신러닝 모델에 의해 만들어진 스펙트로그램을 파형으로 바꾸는 방법으로 옳은 것은?

