# Lectures et ressources complémentaires

Cette unité est une introduction pratique à la reconnaissance automatique de la parole, l'une des tâches les plus populaires dans le domaine audio.
Vous voulez en savoir plus ? Vous trouverez ici des ressources supplémentaires (en anglais) qui vous aideront à approfondir votre compréhension du sujet et à améliorer votre expérience d'apprentissage.

* [Whisper Talk](https://www.youtube.com/live/fZMiD8sDzzg?feature=share) par Jong Wook Kim : une présentation du modèle Whisper, expliquant la motivation, l'architecture, l'entraînement et les résultats, par l'auteur du modèle.
* [End-to-End Speech Benchmark (ESB)](https://arxiv.org/abs/2210.13352) : un papier qui plaide en faveur de l'utilisation du WER orthographique plutôt que du WER normalisé pour l'évaluation des systèmes de reconnaissance automatique de la parole et qui présente un benchmark correspondant.
* [Fine-Tuning Whisper for Multilingual ASR](https://huggingface.co/blog/fine-tune-whisper) : un article de blog qui explique le fonctionnement du modèle Whisper de manière plus détaillée, ainsi que les étapes de pré- et post-traitement impliquées dans l'extracteur de caractéristiques et le *tokenizer*.
* [Fine-tuning MMS Adapter Models for Multi-Lingual ASR](https://huggingface.co/blog/mms_adapters) : un guide complet pour *finetuner* les nouveaux modèles de reconnaissance vocale [MMS](https://ai.facebook.com/blog/multilingual-model-speech-recognition/) de Meta, en gelant les poids du modèle de base et en ne finetunant qu'un petit nombre de couches.
* Boosting Wav2Vec2 with n-grams in 🤗 Transformers](https://huggingface.co/blog/wav2vec2-with-ngram) : un article de blog pour combiner les modèles CTC avec des modèles de langage externes pour combattre les erreurs d'orthographe et de ponctuation.

