# Vérifier votre compréhension de l'unité

### 1. En quelles unités le taux d'échantillonnage est-il mesuré ?

### 2. Lorsqu'un grand jeu de données audio est streamé, à quel moment peut-on commencer à l'utiliser ?

### 3. Qu'est-ce qu'un spectrogramme ?

### 4. Quel est le moyen le plus simple de convertir des données audio brutes en spectrogramme log-mel attendu par Whisper ?

A.

```python
librosa.feature.melspectrogram(audio["array"])
```

B.

```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.

```python
dataset.feature(audio["array"], model="whisper")
```

Transformers, ceci est fait par le préprocesseur du modèle."
		}
	]}
/>

### 5. Comment charger un jeu de données depuis me 🤗 Hub ?

A.

```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.

```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.

```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

Datasets.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load est utile pour charger un fichier audio individuel à partir d'un chemin dans un tuple avec des séries temporelles audio et une fréquence d'échantillonnage, mais pas un jeu de données entier avec de nombreux exemples et de multiples caractéristiques. "
		},
		{
			text: "C",
			explain: "La méthode load_dataset se trouve dans la bibliothèque 🤗 Datasets, pas dans 🤗 Transformers."
		}
	]}
/>

### 6. Votre jeu de données personnalisé contient des données audio de haute qualité avec une fréquence d'échantillonnage de 32 kHz. Vous souhaitez entraîner un modèle de reconnaissance vocale qui s'attend à ce que les exemples audio aient une fréquence d'échantillonnage de 16 kHz. Que devez-vous faire ?

Audio de la bibliothèque 🤗 Datasets pour sous-échantillonner les exemples du jeu de données personnalisé.",
			explain: "",
			correct: true
		},
		{
			text: "Réduire l'échantillonnage d'un facteur 2 en éliminant tous les autres échantillons.",
			explain: "Cela créera des distorsions dans le signal, appelées alias. Le rééchantillonnage est une opération délicate qu'il vaut mieux confier à des bibliothèques éprouvées telles que librosa ou 🤗 Datasets."
		}
	]}
/>

### 7. Comment convertir un spectrogramme généré par un modèle d'apprentissage automatique en une forme d'onde ?

