# Revisa tu comprensión del material del curso

### 1. En que unidades se mide la frecuencia de muestreo?

### 2. Cuando haces streaming de una gran base de datos, ¿Qué tan pronto puedes empezar a usarla?

### 3. ¿Qué es un espectrograma?

### 4. ¿Cúal es la forma más fácil de convertir una señal de audio en el espectro logarítmico de mel esperado por Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### 5.¿Cómo cargas un dataset desde el 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### 6. Tu conjunto de datos contiene audios de alta calidad con una frecuencia de muestreo de 32 kHz. Quieres entrenar un modelo de reconocimiento de voz que espera muestras de audio de 16kHz. ¿Qué debes hacer?

### 7. ¿Cómo se puede convertir un espectrograma generado por un modelo de machine learning en una forma de onda? 

