import{s as ne,n as Me,o as oe}from"../chunks/scheduler.a045fce0.js";import{S as ie,i as pe,e as M,s as t,c as p,h as re,a as o,d as s,b as n,f as te,g as r,j as i,k as Bl,l as ue,m as a,n as u,t as d,o as c,p as j}from"../chunks/index.bc14ef44.js";import{C as de,H as ce,E as je}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.411edb81.js";import{C as m}from"../chunks/CodeBlock.4b065942.js";function me(_l){let y,K,D,ll,J,el,T,sl,w,Ql=`En este curso usaremos la libreria 🤗 Datasets para trabajar con bases de datos de audio. 🤗 Datasets es una libreria de
código abierto para descargar y preparar conjuntos de datos de todos los tipos, incluyendo audio. La libreria ofrece un
acceso fácil a una gran cantidad de conjuntos de datos públicos almacenados en el Hugging Face Hub. Además, 🤗 Datasets incluye
multiples funcionalidades pensadas para simplificar el trabajo con conjuntos de datos de audio para investigadores y desarrolladores.`,al,b,Wl="Para empezar a trabajar con bases de datos de audio, asegurate de tener la librería 🤗 Datasets instalada:",tl,h,nl,f,Rl=`Una de las principales características de 🤗 Datasets es la posibilidad de descargar y preparar un conjunto de datos
en una sola linea de código usando la función <code>load_dataset()</code>`,Ml,A,Fl=`Carguemos y exploremos un conjunto de audios llamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, el cual contiene
grabaciones de personas haciendo preguntas sobre sistemas electrónicos bancarios en diferentes lenguajes y dialectos.`,ol,C,Hl=`Para cargar MINDS-14, necesitamos copiar el identificador de la base de datos que aparece en el Hub (<code>PolyAI/minds14</code>) y pasarlo
como argumento a la función <code>load_dataset</code>. Tambien especificaremos que solo estamos interesados en el subconjunto de inglés Australiano(<code>en-AU</code>)
y la partición de entrenamiento(“train”):`,il,g,pl,I,Yl="<strong>Output:</strong>",rl,$,ul,G,Sl=`El conjunto de datos contiene 654 audios, cada uno acompañado de su transcripción, una transcripción en inglés, y una etiqueta
que indica la intención de la pregunta de la persona. La columna de audio, contiene la información en bruto del audio. Examinemos
ahora uno de los ejemplos:`,dl,v,cl,k,zl="<strong>Output:</strong>",jl,q,ml,x,Nl="Puedes ver que la columna de audio se compone de las siguiente información:",yl,E,Xl="<li><code>path</code>: La ruta al archivo de audio (<code>*.wav</code> en este caso).</li> <li><code>array</code>: Los datos decodificados de audios, representedos como un NumPy array de 1 dimensión.</li> <li><code>sampling_rate</code>. La frecuencia de muestreo del archivo (8,000 Hz en este ejemplo).</li>",Ul,Z,Ll=`La columna <code>intent_class</code> es de tipo categórico codificado en enteros. Para convertir este número en una texto con significado
podemos usar el método <code>int2str()</code>:`,Jl,B,Tl,_,Vl="<strong>Output:</strong>",wl,Q,bl,W,Pl=`Si miras la columna de <code>transcription</code>, puedes ver que en efecto la persona ha grabado un audio haciendo una pregunta sobre
pagar una cuenta.`,hl,R,Dl=`Si planeas entrenar un clasificador de audio en este subconjunto de datos, no necesitas toda la información contenida en las
columnas del conjunto de datos. Por ejemplo, la información en <code>lang_id</code> sera igual para todos los ejemplos y no nos será útil.
La columna <code>english_transcription&#39; seguramente sera un duplicado de la columna </code>transcription\` en este subconjunto, por lo que
podemos removerla tambien.`,fl,F,Ol="Puedes eliminar características irrelevantes usando el método `<code>remove_columns</code>de 🤗 Datasets",Al,H,Cl,Y,Kl="<strong>Output:</strong>",gl,S,Il,z,le=`Ahora que hemos cargado e inspeccionado los contenidos del conjunto de datos, ¡escuchemos algunos ejemplos! Usaremos <code>Blocks</code>
y <code>Audio</code> de <code>Gradio</code> para cargar algunos ejemplos del dataset.`,$l,N,Gl,X,ee="Podemos visulizar tambien algunos de los ejemplos. Grafiquemos ahora la forma de onda del primer ejemplo.",vl,L,kl,U,se='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',ql,V,ae=`¡Pruebalo! Decarga otro dialecto o lenguaje del conjunto MINDS-14, escucha y visualiza ajgunos ejemplos para tener un
sentido de la variación de toda la base de datos. Puedes ver una lista de todos los lenguajes <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.`,xl,P,El,O,Zl;return J=new de({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new ce({props:{title:"Cargar y explorar una base de datos de audio",local:"cargar-y-explorar-una-base-de-datos-de-audio",headingTag:"h1"}}),h=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),g=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),$=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),v=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),q=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),B=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),Q=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),H=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),S=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),P=new je({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/es/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),K=t(),D=M("p"),ll=t(),p(J.$$.fragment),el=t(),p(T.$$.fragment),sl=t(),w=M("p"),w.textContent=Ql,al=t(),b=M("p"),b.textContent=Wl,tl=t(),p(h.$$.fragment),nl=t(),f=M("p"),f.innerHTML=Rl,Ml=t(),A=M("p"),A.innerHTML=Fl,ol=t(),C=M("p"),C.innerHTML=Hl,il=t(),p(g.$$.fragment),pl=t(),I=M("p"),I.innerHTML=Yl,rl=t(),p($.$$.fragment),ul=t(),G=M("p"),G.textContent=Sl,dl=t(),p(v.$$.fragment),cl=t(),k=M("p"),k.innerHTML=zl,jl=t(),p(q.$$.fragment),ml=t(),x=M("p"),x.textContent=Nl,yl=t(),E=M("ul"),E.innerHTML=Xl,Ul=t(),Z=M("p"),Z.innerHTML=Ll,Jl=t(),p(B.$$.fragment),Tl=t(),_=M("p"),_.innerHTML=Vl,wl=t(),p(Q.$$.fragment),bl=t(),W=M("p"),W.innerHTML=Pl,hl=t(),R=M("p"),R.innerHTML=Dl,fl=t(),F=M("p"),F.innerHTML=Ol,Al=t(),p(H.$$.fragment),Cl=t(),Y=M("p"),Y.innerHTML=Kl,gl=t(),p(S.$$.fragment),Il=t(),z=M("p"),z.innerHTML=le,$l=t(),p(N.$$.fragment),Gl=t(),X=M("p"),X.textContent=ee,vl=t(),p(L.$$.fragment),kl=t(),U=M("div"),U.innerHTML=se,ql=t(),V=M("p"),V.innerHTML=ae,xl=t(),p(P.$$.fragment),El=t(),O=M("p"),this.h()},l(l){const e=re("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(s),K=n(l),D=o(l,"P",{}),te(D).forEach(s),ll=n(l),r(J.$$.fragment,l),el=n(l),r(T.$$.fragment,l),sl=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-fms3f9"&&(w.textContent=Ql),al=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1o8p9et"&&(b.textContent=Wl),tl=n(l),r(h.$$.fragment,l),nl=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1kcnm3r"&&(f.innerHTML=Rl),Ml=n(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1yiem8x"&&(A.innerHTML=Fl),ol=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1ir28gq"&&(C.innerHTML=Hl),il=n(l),r(g.$$.fragment,l),pl=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1mvdyro"&&(I.innerHTML=Yl),rl=n(l),r($.$$.fragment,l),ul=n(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ivyj94"&&(G.textContent=Sl),dl=n(l),r(v.$$.fragment,l),cl=n(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1mvdyro"&&(k.innerHTML=zl),jl=n(l),r(q.$$.fragment,l),ml=n(l),x=o(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-hxz5rj"&&(x.textContent=Nl),yl=n(l),E=o(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-op7a9q"&&(E.innerHTML=Xl),Ul=n(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ybdd87"&&(Z.innerHTML=Ll),Jl=n(l),r(B.$$.fragment,l),Tl=n(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1mvdyro"&&(_.innerHTML=Vl),wl=n(l),r(Q.$$.fragment,l),bl=n(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1v4lcjp"&&(W.innerHTML=Pl),hl=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1ufbi3q"&&(R.innerHTML=Dl),fl=n(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-18j6r1l"&&(F.innerHTML=Ol),Al=n(l),r(H.$$.fragment,l),Cl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Kl),gl=n(l),r(S.$$.fragment,l),Il=n(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-ymdrwo"&&(z.innerHTML=le),$l=n(l),r(N.$$.fragment,l),Gl=n(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1jx33x4"&&(X.textContent=ee),vl=n(l),r(L.$$.fragment,l),kl=n(l),U=o(l,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1ym6zda"&&(U.innerHTML=se),ql=n(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1wmw5cx"&&(V.innerHTML=ae),xl=n(l),r(P.$$.fragment,l),El=n(l),O=o(l,"P",{}),te(O).forEach(s),this.h()},h(){Bl(y,"name","hf:doc:metadata"),Bl(y,"content",ye),Bl(U,"class","flex justify-center")},m(l,e){ue(document.head,y),a(l,K,e),a(l,D,e),a(l,ll,e),u(J,l,e),a(l,el,e),u(T,l,e),a(l,sl,e),a(l,w,e),a(l,al,e),a(l,b,e),a(l,tl,e),u(h,l,e),a(l,nl,e),a(l,f,e),a(l,Ml,e),a(l,A,e),a(l,ol,e),a(l,C,e),a(l,il,e),u(g,l,e),a(l,pl,e),a(l,I,e),a(l,rl,e),u($,l,e),a(l,ul,e),a(l,G,e),a(l,dl,e),u(v,l,e),a(l,cl,e),a(l,k,e),a(l,jl,e),u(q,l,e),a(l,ml,e),a(l,x,e),a(l,yl,e),a(l,E,e),a(l,Ul,e),a(l,Z,e),a(l,Jl,e),u(B,l,e),a(l,Tl,e),a(l,_,e),a(l,wl,e),u(Q,l,e),a(l,bl,e),a(l,W,e),a(l,hl,e),a(l,R,e),a(l,fl,e),a(l,F,e),a(l,Al,e),u(H,l,e),a(l,Cl,e),a(l,Y,e),a(l,gl,e),u(S,l,e),a(l,Il,e),a(l,z,e),a(l,$l,e),u(N,l,e),a(l,Gl,e),a(l,X,e),a(l,vl,e),u(L,l,e),a(l,kl,e),a(l,U,e),a(l,ql,e),a(l,V,e),a(l,xl,e),u(P,l,e),a(l,El,e),a(l,O,e),Zl=!0},p:Me,i(l){Zl||(d(J.$$.fragment,l),d(T.$$.fragment,l),d(h.$$.fragment,l),d(g.$$.fragment,l),d($.$$.fragment,l),d(v.$$.fragment,l),d(q.$$.fragment,l),d(B.$$.fragment,l),d(Q.$$.fragment,l),d(H.$$.fragment,l),d(S.$$.fragment,l),d(N.$$.fragment,l),d(L.$$.fragment,l),d(P.$$.fragment,l),Zl=!0)},o(l){c(J.$$.fragment,l),c(T.$$.fragment,l),c(h.$$.fragment,l),c(g.$$.fragment,l),c($.$$.fragment,l),c(v.$$.fragment,l),c(q.$$.fragment,l),c(B.$$.fragment,l),c(Q.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(N.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),Zl=!1},d(l){l&&(s(K),s(D),s(ll),s(el),s(sl),s(w),s(al),s(b),s(tl),s(nl),s(f),s(Ml),s(A),s(ol),s(C),s(il),s(pl),s(I),s(rl),s(ul),s(G),s(dl),s(cl),s(k),s(jl),s(ml),s(x),s(yl),s(E),s(Ul),s(Z),s(Jl),s(Tl),s(_),s(wl),s(bl),s(W),s(hl),s(R),s(fl),s(F),s(Al),s(Cl),s(Y),s(gl),s(Il),s(z),s($l),s(Gl),s(X),s(vl),s(kl),s(U),s(ql),s(V),s(xl),s(El),s(O)),s(y),j(J,l),j(T,l),j(h,l),j(g,l),j($,l),j(v,l),j(q,l),j(B,l),j(Q,l),j(H,l),j(S,l),j(N,l),j(L,l),j(P,l)}}}const ye='{"title":"Cargar y explorar una base de datos de audio","local":"cargar-y-explorar-una-base-de-datos-de-audio","sections":[],"depth":1}';function Ue(_l){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class he extends ie{constructor(y){super(),pe(this,y,Ue,me,ne,{})}}export{he as component};
