# Unit 6. From text to speech 

In the previous unit, you learned how to use Transformers to convert spoken speech into text. Now let's flip the 
script and see how you can transform a given input text into an audio output that sounds like human speech.

The task we will study in this unit is called "Text-to-speech" (TTS). Models capable of converting text into audible 
human speech have a wide range of potential applications: 

* Assistive apps: think about tools that can leverage these models to enable visually-impaired people to access digital content through the medium of sound.
* Audiobook narration: converting written books into audio form makes literature more accessible to individuals who prefer to listen or have difficulty with reading.
* Virtual assistants: TTS models are a fundamental component of virtual assistants like Siri, Google Assistant, or Amazon Alexa. Once they have used a classification model to catch the wake word, and used ASR model to process your request, they can use a TTS model to respond to your inquiry.
* Entertainment, gaming and language learning: give voice to your NPC characters, narrate game events, or help language learners with examples of correct pronunciation and intonation of words and phrases.

These are just a few examples, and I am sure you can imagine many more! However, with so much power comes the responsibility, 
and it is important to highlight that TTS models have the potential to be used for malicious purposes.
For example, with sufficient voice samples, malicious actors could potentially create convincing fake audio recordings, leading to 
the unauthorized use of someone's voice for fraudulent purposes or manipulation. If you plan to collect data for fine-tuning 
your own systems, carefully consider privacy and informed consent. Voice data should be obtained with explicit consent 
from individuals, ensuring they understand the purpose, scope, and potential risks associated with their voice being used 
in a TTS system. Please use text-to-speech responsibly.

## What you'll learn and what you'll build

In this unit we will talk about: 

* [Datasets suitable for text-to-speech training](tts_datasets)
* [Pre-trained models for text-to-speech](pre-trained_models)
* [Fine-tuning SpeechT5 on a new language](fine-tuning)
* [Evaluating TTS models](evaluation)

