# Get ready to take the course

We hope that you are excited to get started with the course, and we have designed this page to make sure you have
everything you need to jump right in!

## Step 1. Sign up

To stay up to date with all the updates and special social events, sign up to the course.

[👉 SIGN UP](http://eepurl.com/insvcI)

## Step 2. Get a Hugging Face account

If you don't yet have one, create a Hugging Face account (it's free). You'll need it to complete hands-on tasks, to
receive your certificate of completion, to explore pre-trained models, to access datasets and more.

[👉 CREATE HUGGING FACE ACCOUNT](https://huggingface.co/join)

## Step 3. Brush up on fundamentals (if you need to)

We assume that you are familiar with deep learning basics, and have general familiarity with transformers. If you need
to brush up on your understanding of transformers, check out our [NLP Course](https://huggingface.co/course/chapter1/1).

## Step 4. Check your setup

To go through the course materials you will need:
- A computer with an internet connection
- [Google Colab](https://colab.research.google.com) for hands-on exercises. The free version is enough. If you have never used Google Colab before, check out this [official introduction notebook](https://colab.research.google.com/notebooks/intro.ipynb).

As an alternative to the free tier of Google Colab, you can use your own local setup, or Kaggle Notebooks. Kaggle Notebooks 
offer a fixed number of GPU hours and have similar functionality to Google Colab, however, there are differences when it 
comes to sharing your models on 🤗 Hub (e.g. for completing assignments). If you decide to use Kaggle Notebooks as your 
tool of choice, check out the [example Kaggle notebook](https://www.kaggle.com/code/michaelshekasta/test-notebook) created by 
[@michaelshekasta](https://github.com/michaelshekasta). This notebook illustrates how you can train and share your 
trained model on 🤗 Hub.

## Step 5. Join the community

Sign up to our Discord server, the place where you can exchange ideas with your classmates and reach out to us (the Hugging Face team).

[👉 JOIN THE COMMUNITY ON DISCORD](http://hf.co/join/discord)

To learn more about our community on Discord and how to make the most of it, check out the [next page](community).

