import{s as ms,a as ds,o as fs,n as ys}from"../chunks/scheduler.cd324960.js";import{S as gs,i as ws,e as i,s as n,c as r,h as Ts,a as o,d as s,b as l,f as St,g as c,j as p,k as U,l as Ms,m as a,n as h,t as u,o as m,p as d,q as Js,r as bs}from"../chunks/index.d5c3adcc.js";import{T as us}from"../chunks/Tip.889bec11.js";import{C as Us,H as ke,E as $s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d504834e.js";import{C as y}from"../chunks/CodeBlock.df8b7a6e.js";function js(je){let f,w=`Whisper can also be ‘tricked’ into translating from speech in any language X to any language Y. Simply set the task to
<code>&quot;transcribe&quot;</code> and the <code>&quot;language&quot;</code> to your target language in the generation key-word arguments,
e.g. for Spanish, one would set:`,M,J,$="<code>generate_kwargs={&quot;task&quot;: &quot;transcribe&quot;, &quot;language&quot;: &quot;es&quot;}</code>";return{c(){f=i("p"),f.innerHTML=w,M=n(),J=i("p"),J.innerHTML=$},l(g){f=o(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-vga0jc"&&(f.innerHTML=w),M=l(g),J=o(g,"P",{"data-svelte-h":!0}),p(J)!=="svelte-130lm1j"&&(J.innerHTML=$)},m(g,b){a(g,f,b),a(g,M,b),a(g,J,b)},p:ys,d(g){g&&(s(f),s(M),s(J))}}}function vs(je){let f;return{c(){f=Js(`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},l(w){f=bs(w,`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},m(w,M){a(w,f,M)},d(w){w&&s(f)}}}function ks(je){let f,w,M,J,$,g,b,Ze,x,Ct=`Speech-to-speech translation (STST or S2ST) is a relatively new spoken language processing task. It involves translating
speech from one langauge into speech in a <strong>different</strong> language:`,xe,j,It='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st.png" alt="Diagram of speech to speech translation"/>',Ge,G,Wt=`STST can be viewed as an extension of the traditional machine translation (MT) task: instead of translating <strong>text</strong> from one
language into another, we translate <strong>speech</strong> from one language into another. STST holds applications in the field of
multilingual communication, enabling speakers in different languages to communicate with one another through the medium
of speech.`,Se,S,Nt=`Suppose you want to communicate with another individual across a langauge barrier. Rather
than writing the information that you want to convey and then translating it to text in the target language, you
can speak it directly and have a STST system convert your spoken speech into the target langauge. The recipient can then
respond by speaking back at the STST system, and you can listen to their response. This is a more natural way of communicating
compared to text-based machine translation.`,Ce,C,_t=`In this chapter, we’ll explore a <em>cascaded</em> approach to STST, piecing together the knowledge you’ve acquired in Units
5 and 6 of the course. We’ll use a <em>speech translation (ST)</em> system to transcribe the source speech into text in the target
language, then <em>text-to-speech (TTS)</em> to generate speech in the target language from the translated text:`,Ie,v,Bt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st_cascaded.png" alt="Diagram of cascaded speech to speech translation"/>',We,I,Vt=`We could also have used a three stage approach, where first we use an automatic speech recognition (ASR) system to
transcribe the source speech into text in the same language, then machine translation to translate the transcribed text
into the target language, and finally text-to-speech to generate speech in the target language. However, adding more
components to the pipeline lends itself to <em>error propagation</em>, where the errors introduced in one system are compounded
as they flow through the remaining systems, and also increases latency, since inference has to be conducted for more models.`,Ne,W,Ht=`While this cascaded approach to STST is pretty straightforward, it results in very effective STST systems. The three-stage
cascaded system of ASR + MT + TTS was previously used to power many commercial STST products, including <a href="https://ai.googleblog.com/2019/05/introducing-translatotron-end-to-end.html" rel="nofollow">Google Translate</a>.
It’s also a very data and compute efficient way of developing a STST system, since existing speech recognition and
text-to-speech systems can be coupled together to yield a new STST model without any additional training.`,_e,N,Xt=`In the remainder of this Unit, we’ll focus on creating a STST system that translates speech from any language X to speech
in English. The methods covered can be extended to STST systems that translate from any language X to any
langauge Y, but we leave this as an extension to the reader and provide pointers where applicable. We further divide up the
task of STST into its two constituent components: ST and TTS. We’ll finish by piecing them together to build a Gradio
demo to showcase our system.`,Be,_,Ve,B,qt=`We’ll use the Whisper model for our speech translation system, since it’s capable of translating from over 96 languages
to English. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which
clocks in at 74M parameters. It’s by no means the most performant Whisper model, with the <a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">largest Whisper checkpoint</a>
being over 20x larger, but since we’re concatenating two auto-regressive systems together (ST + TTS), we want to ensure
each model can generate relatively quickly so that we get reasonable inference speed:`,He,V,Xe,H,Rt=`Great! To test our STST system, we’ll load an audio sample in a non-English language. Let’s load the first example of the
Italian (<code>it</code>) split of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset:`,qe,X,Re,q,Yt='To listen to this sample, we can either play it using the dataset viewer on the Hub: <a href="https://huggingface.co/datasets/facebook/voxpopuli/viewer/it/validation?row=0" rel="nofollow">facebook/voxpopuli/viewer</a>',Ye,R,Qt="Or playback using the ipynb audio feature:",Qe,Y,Fe,Q,Ft=`Now let’s define a function that takes this audio input and returns the translated text. You’ll remember that we have to
pass the generation key-word argument for the <code>&quot;task&quot;</code>, setting it to <code>&quot;translate&quot;</code> to ensure that Whisper performs
speech translation and not speech recognition:`,ze,F,Ee,k,Le,z,zt="Great! Let’s quickly check that we get a sensible result from the model:",Pe,E,Ae,L,Ke,P,Et="Alright! If we compare this to the source text:",De,A,Oe,K,et,D,Lt=`We see that the translation more or less lines up (you can double check this using Google Translate), barring a small
extra few words at the start of the transcription where the speaker was finishing off their previous sentence.`,tt,O,Pt=`With that, we’ve completed the first half of our cascaded STST pipeline, putting into practice the skills we gained in Unit 5
when we learnt how to use the Whisper model for speech recognition and translation. If you want a refresher on any of the
steps we covered, have a read through the section on <a href="../chapter5/asr_models">Pre-trained models for ASR</a> from Unit 5.`,st,ee,at,te,At=`The second half of our cascaded STST system involves mapping from English text to English speech. For this, we’ll use
the pre-trained <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a> model for English TTS. 🤗 Transformers currently doesn’t
have a TTS <code>pipeline</code>, so we’ll have to use the model directly ourselves. This is no biggie, you’re all experts on using
the model for inference following Unit 6!`,nt,se,Kt="First, let’s load the SpeechT5 processor, model and vocoder from the pre-trained checkpoint:",lt,ae,it,Z,ot,ne,Dt="As with the Whisper model, we’ll place the SpeechT5 model and vocoder on our GPU accelerator device if we have one:",pt,le,rt,ie,Ot="Great! Let’s load up the speaker embeddings:",ct,oe,ht,pe,es=`We can now write a function that takes a text prompt as input, and generates the corresponding speech. We’ll first pre-process
the text input using the SpeechT5 processor, tokenizing the text to get our input ids. We’ll then pass the input ids and
speaker embeddings to the SpeechT5 model, placing each on the accelerator device if available. Finally, we’ll return the
generated speech, bringing it back to the CPU so that we can play it back in our ipynb notebook:`,ut,re,mt,ce,ts="Let’s check it works with a dummy text input:",dt,he,ft,ue,ss="Sounds good! Now for the exciting part - piecing it all together.",yt,me,gt,de,as=`Before we create a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase our STST system, let’s first do a quick sanity check
to make sure we can concatenate the two models, putting an audio sample in and getting an audio sample out. We’ll do
this by concatenating the two functions we defined in the previous two sub-sections, such that we input the source audio
and retrieve the translated text, then synthesise the translated text to get the translated speech. Finally, we’ll convert
the synthesised speech to an <code>int16</code> array, which is the output audio file format expected by Gradio. To do this, we
first have to normalise the audio array by the dynamic range of the target dtype (<code>int16</code>), and then convert from the
default NumPy dtype (<code>float64</code>) to the target dtype (<code>int16</code>):`,wt,fe,Tt,ye,ns="Let’s check this concatenated function gives the expected result:",Mt,ge,Jt,we,ls=`Perfect! Now we’ll wrap this up into a nice Gradio demo so that we can record our source speech using a microphone input
or file input and playback the system’s prediction:`,bt,Te,Ut,Me,is="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",$t,T,os,jt,Je,ps=`You can <a href="https://huggingface.co/spaces/course-demos/speech-to-speech-translation?duplicate=true" rel="nofollow">duplicate</a> this demo and adapt
it to use a different Whisper checkpoint, a different TTS checkpoint, or relax the constraint of outputting English
speech and follow the tips provide for translating into a langauge of your choice!`,vt,be,kt,Ue,rs=`While the cascaded system is a compute and data efficient way of building a STST system, it suffers from the issues of
error propagation and additive latency described above. Recent works have explored a <em>direct</em> approach to STST, one that
does not predict an intermediate text output and instead maps directly from source speech to target speech. These systems
are also capable of retaining the speaking characteristics of the source speaker in the target speech (such a prosody,
pitch and intonation). If you’re interested in finding out more about these systems, check-out the resources listed in
the section on <a href="supplemental_reading">supplemental reading</a>.`,Zt,$e,xt,ve,Gt;return $=new Us({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new ke({props:{title:"Speech-to-speech translation",local:"speech-to-speech-translation",headingTag:"h1"}}),_=new ke({props:{title:"Speech translation",local:"speech-translation",headingTag:"h2"}}),V=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmYWNlYm9vayUyRnZveHBvcHVsaSUyMiUyQyUyMCUyMml0JTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;it&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),F=new y({props:{code:"ZGVmJTIwdHJhbnNsYXRlKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBwaXBlKGF1ZGlvJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNsYXRlJTIyJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">translate</span>(<span class="hljs-params">audio</span>):
    outputs = pipe(audio, max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})
    <span class="hljs-keyword">return</span> outputs[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),k=new us({props:{$$slots:{default:[js]},$$scope:{ctx:je}}}),E=new y({props:{code:"dHJhbnNsYXRlKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:'translate(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),L=new y({props:{code:"JyUyMHBzeWNob2xvZ2ljYWwlMjBhbmQlMjBzb2NpYWwuJTIwSSUyMHRoaW5rJTIwdGhhdCUyMGl0JTIwaXMlMjBhJTIwdmVyeSUyMGltcG9ydGFudCUyMHN0ZXAlMjBpbiUyMHRoZSUyMGNvbnN0cnVjdGlvbiUyMG9mJTIwYSUyMGp1cmlkaWNhbCUyMHNwYWNlJTIwb2YlMjBmcmVlZG9tJTJDJTIwY2lyY3VsYXRpb24lMjBhbmQlMjBwcm90ZWN0aW9uJTIwb2YlMjByaWdodHMuJw==",highlighted:'<span class="hljs-comment">&#x27; psychological and social. I think that it is a very important step in the construction of a juridical space of freedom, circulation and protection of rights.&#x27;</span>',wrap:!1}}),A=new y({props:{code:"c2FtcGxlJTVCJTIycmF3X3RleHQlMjIlNUQ=",highlighted:'sample[<span class="hljs-string">&quot;raw_text&quot;</span>]',wrap:!1}}),K=new y({props:{code:"J1BlbnNvJTIwY2hlJTIwcXVlc3RvJTIwc2lhJTIwdW4lMjBwYXNzbyUyMGluJTIwYXZhbnRpJTIwaW1wb3J0YW50ZSUyMG5lbGxhJTIwY29zdHJ1emlvbmUlMjBkaSUyMHVubyUyMHNwYXppbyUyMGdpdXJpZGljbyUyMGRpJTIwbGliZXJ0JUMzJUEwJTIwZGklMjBjaXJjb2xhemlvbmUlMjBlJTIwZGklMjBwcm90ZXppb25lJTIwZGVpJTIwZGlyaXR0aSUyMHBlciUyMGxlJTIwcGVyc29uZSUyMGluJTIwRXVyb3BhLic=",highlighted:'<span class="hljs-comment">&#x27;Penso che questo sia un passo in avanti importante nella costruzione di uno spazio giuridico di libertà di circolazione e di protezione dei diritti per le persone in Europa.&#x27;</span>',wrap:!1}}),ee=new ke({props:{title:"Text-to-speech",local:"text-to-speech",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiklMEF2b2NvZGVyJTIwJTNEJTIwU3BlZWNoVDVIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzcGVlY2h0NV9oaWZpZ2FuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)`,wrap:!1}}),Z=new us({props:{$$slots:{default:[vs]},$$scope:{ctx:je}}}),le=new y({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQXZvY29kZXIudG8oZGV2aWNlKQ==",highlighted:`model.to(device)
vocoder.to(device)`,wrap:!1}}),oe=new y({props:{code:"ZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),re=new y({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`,wrap:!1}}),he=new y({props:{code:"c3BlZWNoJTIwJTNEJTIwc3ludGhlc2lzZSglMjJIZXklMjB0aGVyZSElMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCElMjIpJTBBJTBBQXVkaW8oc3BlZWNoJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`speech = synthesise(<span class="hljs-string">&quot;Hey there! This is a test!&quot;</span>)

Audio(speech, rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),me=new ke({props:{title:"Creating a STST demo",local:"creating-a-stst-demo",headingTag:"h2"}}),fe=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2R0eXBlJTIwJTNEJTIwbnAuaW50MTYlMEFtYXhfcmFuZ2UlMjAlM0QlMjBucC5paW5mbyh0YXJnZXRfZHR5cGUpLm1heCUwQSUwQSUwQWRlZiUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNsYXRlZF90ZXh0JTIwJTNEJTIwdHJhbnNsYXRlKGF1ZGlvKSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHN5bnRoZXNpc2UodHJhbnNsYXRlZF90ZXh0KSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMChzeW50aGVzaXNlZF9zcGVlY2gubnVtcHkoKSUyMColMjBtYXhfcmFuZ2UpLmFzdHlwZShucC5pbnQxNiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxNjAwMCUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_dtype = np.int16
max_range = np.iinfo(target_dtype).<span class="hljs-built_in">max</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_speech_translation</span>(<span class="hljs-params">audio</span>):
    translated_text = translate(audio)
    synthesised_speech = synthesise(translated_text)
    synthesised_speech = (synthesised_speech.numpy() * max_range).astype(np.int16)
    <span class="hljs-keyword">return</span> <span class="hljs-number">16000</span>, synthesised_speech`,wrap:!1}}),ge=new y({props:{code:"c2FtcGxpbmdfcmF0ZSUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQpJTBBJTBBQXVkaW8oc3ludGhlc2lzZWRfc3BlZWNoJTJDJTIwcmF0ZSUzRHNhbXBsaW5nX3JhdGUp",highlighted:`sampling_rate, synthesised_speech = speech_to_speech_translation(sample[<span class="hljs-string">&quot;audio&quot;</span>])

Audio(synthesised_speech, rate=sampling_rate)`,wrap:!1}}),Te=new y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2xhdGUlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RzcGVlY2hfdG9fc3BlZWNoX3RyYW5zbGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8oc291cmNlJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQWZpbGVfdHJhbnNsYXRlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEc3BlZWNoX3RvX3NwZWVjaF90cmFuc2xhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuVGFiYmVkSW50ZXJmYWNlKCU1Qm1pY190cmFuc2xhdGUlMkMlMjBmaWxlX3RyYW5zbGF0ZSU1RCUyQyUyMCU1QiUyMk1pY3JvcGhvbmUlMjIlMkMlMjAlMjJBdWRpbyUyMEZpbGUlMjIlNUQpJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

file_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface([mic_translate, file_translate], [<span class="hljs-string">&quot;Microphone&quot;</span>, <span class="hljs-string">&quot;Audio File&quot;</span>])

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),be=new ke({props:{title:"Going forwards",local:"going-forwards",headingTag:"h2"}}),$e=new $s({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter7/speech-to-speech.mdx"}}),{c(){f=i("meta"),w=n(),M=i("p"),J=n(),r($.$$.fragment),g=n(),r(b.$$.fragment),Ze=n(),x=i("p"),x.innerHTML=Ct,xe=n(),j=i("div"),j.innerHTML=It,Ge=n(),G=i("p"),G.innerHTML=Wt,Se=n(),S=i("p"),S.textContent=Nt,Ce=n(),C=i("p"),C.innerHTML=_t,Ie=n(),v=i("div"),v.innerHTML=Bt,We=n(),I=i("p"),I.innerHTML=Vt,Ne=n(),W=i("p"),W.innerHTML=Ht,_e=n(),N=i("p"),N.textContent=Xt,Be=n(),r(_.$$.fragment),Ve=n(),B=i("p"),B.innerHTML=qt,He=n(),r(V.$$.fragment),Xe=n(),H=i("p"),H.innerHTML=Rt,qe=n(),r(X.$$.fragment),Re=n(),q=i("p"),q.innerHTML=Yt,Ye=n(),R=i("p"),R.textContent=Qt,Qe=n(),r(Y.$$.fragment),Fe=n(),Q=i("p"),Q.innerHTML=Ft,ze=n(),r(F.$$.fragment),Ee=n(),r(k.$$.fragment),Le=n(),z=i("p"),z.textContent=zt,Pe=n(),r(E.$$.fragment),Ae=n(),r(L.$$.fragment),Ke=n(),P=i("p"),P.textContent=Et,De=n(),r(A.$$.fragment),Oe=n(),r(K.$$.fragment),et=n(),D=i("p"),D.textContent=Lt,tt=n(),O=i("p"),O.innerHTML=Pt,st=n(),r(ee.$$.fragment),at=n(),te=i("p"),te.innerHTML=At,nt=n(),se=i("p"),se.textContent=Kt,lt=n(),r(ae.$$.fragment),it=n(),r(Z.$$.fragment),ot=n(),ne=i("p"),ne.textContent=Dt,pt=n(),r(le.$$.fragment),rt=n(),ie=i("p"),ie.textContent=Ot,ct=n(),r(oe.$$.fragment),ht=n(),pe=i("p"),pe.textContent=es,ut=n(),r(re.$$.fragment),mt=n(),ce=i("p"),ce.textContent=ts,dt=n(),r(he.$$.fragment),ft=n(),ue=i("p"),ue.textContent=ss,yt=n(),r(me.$$.fragment),gt=n(),de=i("p"),de.innerHTML=as,wt=n(),r(fe.$$.fragment),Tt=n(),ye=i("p"),ye.textContent=ns,Mt=n(),r(ge.$$.fragment),Jt=n(),we=i("p"),we.textContent=ls,bt=n(),r(Te.$$.fragment),Ut=n(),Me=i("p"),Me.textContent=is,$t=n(),T=i("iframe"),jt=n(),Je=i("p"),Je.innerHTML=ps,vt=n(),r(be.$$.fragment),kt=n(),Ue=i("p"),Ue.innerHTML=rs,Zt=n(),r($e.$$.fragment),xt=n(),ve=i("p"),this.h()},l(e){const t=Ts("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=l(e),M=o(e,"P",{}),St(M).forEach(s),J=l(e),c($.$$.fragment,e),g=l(e),c(b.$$.fragment,e),Ze=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-xrl39y"&&(x.innerHTML=Ct),xe=l(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-1q8w6r1"&&(j.innerHTML=It),Ge=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1r1gucv"&&(G.innerHTML=Wt),Se=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1g3p1ee"&&(S.textContent=Nt),Ce=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-16kqqhy"&&(C.innerHTML=_t),Ie=l(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-55g36w"&&(v.innerHTML=Bt),We=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-17ui3zo"&&(I.innerHTML=Vt),Ne=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-oqffa8"&&(W.innerHTML=Ht),_e=l(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1jnkkhd"&&(N.textContent=Xt),Be=l(e),c(_.$$.fragment,e),Ve=l(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1d2no8a"&&(B.innerHTML=qt),He=l(e),c(V.$$.fragment,e),Xe=l(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1s7hzub"&&(H.innerHTML=Rt),qe=l(e),c(X.$$.fragment,e),Re=l(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-veyz1i"&&(q.innerHTML=Yt),Ye=l(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-txz4z7"&&(R.textContent=Qt),Qe=l(e),c(Y.$$.fragment,e),Fe=l(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-uzvw8l"&&(Q.innerHTML=Ft),ze=l(e),c(F.$$.fragment,e),Ee=l(e),c(k.$$.fragment,e),Le=l(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-dz3cev"&&(z.textContent=zt),Pe=l(e),c(E.$$.fragment,e),Ae=l(e),c(L.$$.fragment,e),Ke=l(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1j8a6ju"&&(P.textContent=Et),De=l(e),c(A.$$.fragment,e),Oe=l(e),c(K.$$.fragment,e),et=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-wp88n3"&&(D.textContent=Lt),tt=l(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-k7dh1z"&&(O.innerHTML=Pt),st=l(e),c(ee.$$.fragment,e),at=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1xzib0a"&&(te.innerHTML=At),nt=l(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-d9cpp9"&&(se.textContent=Kt),lt=l(e),c(ae.$$.fragment,e),it=l(e),c(Z.$$.fragment,e),ot=l(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-2glor5"&&(ne.textContent=Dt),pt=l(e),c(le.$$.fragment,e),rt=l(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-f6jrhm"&&(ie.textContent=Ot),ct=l(e),c(oe.$$.fragment,e),ht=l(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1hvsx4q"&&(pe.textContent=es),ut=l(e),c(re.$$.fragment,e),mt=l(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-i24jqg"&&(ce.textContent=ts),dt=l(e),c(he.$$.fragment,e),ft=l(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-e3hzpi"&&(ue.textContent=ss),yt=l(e),c(me.$$.fragment,e),gt=l(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-17w2mjs"&&(de.innerHTML=as),wt=l(e),c(fe.$$.fragment,e),Tt=l(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1a1frzk"&&(ye.textContent=ns),Mt=l(e),c(ge.$$.fragment,e),Jt=l(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1f76kv1"&&(we.textContent=ls),bt=l(e),c(Te.$$.fragment,e),Ut=l(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-10sf4ix"&&(Me.textContent=is),$t=l(e),T=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),St(T).forEach(s),jt=l(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1arc8ys"&&(Je.innerHTML=ps),vt=l(e),c(be.$$.fragment,e),kt=l(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-9tvm6n"&&(Ue.innerHTML=rs),Zt=l(e),c($e.$$.fragment,e),xt=l(e),ve=o(e,"P",{}),St(ve).forEach(s),this.h()},h(){U(f,"name","hf:doc:metadata"),U(f,"content",Zs),U(j,"class","flex justify-center"),U(v,"class","flex justify-center"),ds(T.src,os="https://course-demos-speech-to-speech-translation.hf.space")||U(T,"src",os),U(T,"frameborder","0"),U(T,"height","450"),U(T,"title","Gradio app"),U(T,"class","container p-0 flex-grow space-iframe"),U(T,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),U(T,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Ms(document.head,f),a(e,w,t),a(e,M,t),a(e,J,t),h($,e,t),a(e,g,t),h(b,e,t),a(e,Ze,t),a(e,x,t),a(e,xe,t),a(e,j,t),a(e,Ge,t),a(e,G,t),a(e,Se,t),a(e,S,t),a(e,Ce,t),a(e,C,t),a(e,Ie,t),a(e,v,t),a(e,We,t),a(e,I,t),a(e,Ne,t),a(e,W,t),a(e,_e,t),a(e,N,t),a(e,Be,t),h(_,e,t),a(e,Ve,t),a(e,B,t),a(e,He,t),h(V,e,t),a(e,Xe,t),a(e,H,t),a(e,qe,t),h(X,e,t),a(e,Re,t),a(e,q,t),a(e,Ye,t),a(e,R,t),a(e,Qe,t),h(Y,e,t),a(e,Fe,t),a(e,Q,t),a(e,ze,t),h(F,e,t),a(e,Ee,t),h(k,e,t),a(e,Le,t),a(e,z,t),a(e,Pe,t),h(E,e,t),a(e,Ae,t),h(L,e,t),a(e,Ke,t),a(e,P,t),a(e,De,t),h(A,e,t),a(e,Oe,t),h(K,e,t),a(e,et,t),a(e,D,t),a(e,tt,t),a(e,O,t),a(e,st,t),h(ee,e,t),a(e,at,t),a(e,te,t),a(e,nt,t),a(e,se,t),a(e,lt,t),h(ae,e,t),a(e,it,t),h(Z,e,t),a(e,ot,t),a(e,ne,t),a(e,pt,t),h(le,e,t),a(e,rt,t),a(e,ie,t),a(e,ct,t),h(oe,e,t),a(e,ht,t),a(e,pe,t),a(e,ut,t),h(re,e,t),a(e,mt,t),a(e,ce,t),a(e,dt,t),h(he,e,t),a(e,ft,t),a(e,ue,t),a(e,yt,t),h(me,e,t),a(e,gt,t),a(e,de,t),a(e,wt,t),h(fe,e,t),a(e,Tt,t),a(e,ye,t),a(e,Mt,t),h(ge,e,t),a(e,Jt,t),a(e,we,t),a(e,bt,t),h(Te,e,t),a(e,Ut,t),a(e,Me,t),a(e,$t,t),a(e,T,t),a(e,jt,t),a(e,Je,t),a(e,vt,t),h(be,e,t),a(e,kt,t),a(e,Ue,t),a(e,Zt,t),h($e,e,t),a(e,xt,t),a(e,ve,t),Gt=!0},p(e,[t]){const cs={};t&2&&(cs.$$scope={dirty:t,ctx:e}),k.$set(cs);const hs={};t&2&&(hs.$$scope={dirty:t,ctx:e}),Z.$set(hs)},i(e){Gt||(u($.$$.fragment,e),u(b.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(k.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(Z.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u($e.$$.fragment,e),Gt=!0)},o(e){m($.$$.fragment,e),m(b.$$.fragment,e),m(_.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(k.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ae.$$.fragment,e),m(Z.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(be.$$.fragment,e),m($e.$$.fragment,e),Gt=!1},d(e){e&&(s(w),s(M),s(J),s(g),s(Ze),s(x),s(xe),s(j),s(Ge),s(G),s(Se),s(S),s(Ce),s(C),s(Ie),s(v),s(We),s(I),s(Ne),s(W),s(_e),s(N),s(Be),s(Ve),s(B),s(He),s(Xe),s(H),s(qe),s(Re),s(q),s(Ye),s(R),s(Qe),s(Fe),s(Q),s(ze),s(Ee),s(Le),s(z),s(Pe),s(Ae),s(Ke),s(P),s(De),s(Oe),s(et),s(D),s(tt),s(O),s(st),s(at),s(te),s(nt),s(se),s(lt),s(it),s(ot),s(ne),s(pt),s(rt),s(ie),s(ct),s(ht),s(pe),s(ut),s(mt),s(ce),s(dt),s(ft),s(ue),s(yt),s(gt),s(de),s(wt),s(Tt),s(ye),s(Mt),s(Jt),s(we),s(bt),s(Ut),s(Me),s($t),s(T),s(jt),s(Je),s(vt),s(kt),s(Ue),s(Zt),s(xt),s(ve)),s(f),d($,e),d(b,e),d(_,e),d(V,e),d(X,e),d(Y,e),d(F,e),d(k,e),d(E,e),d(L,e),d(A,e),d(K,e),d(ee,e),d(ae,e),d(Z,e),d(le,e),d(oe,e),d(re,e),d(he,e),d(me,e),d(fe,e),d(ge,e),d(Te,e),d(be,e),d($e,e)}}}const Zs='{"title":"Speech-to-speech translation","local":"speech-to-speech-translation","sections":[{"title":"Speech translation","local":"speech-translation","sections":[],"depth":2},{"title":"Text-to-speech","local":"text-to-speech","sections":[],"depth":2},{"title":"Creating a STST demo","local":"creating-a-stst-demo","sections":[],"depth":2},{"title":"Going forwards","local":"going-forwards","sections":[],"depth":2}],"depth":1}';function xs(je){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends gs{constructor(f){super(),ws(this,f,xs,ks,ms,{})}}export{Ns as component};
