import{s as $e,n as Ue,o as Ie}from"../chunks/scheduler.cd324960.js";import{S as Ce,i as qe,e as i,s as l,c as r,h as xe,a as o,d as s,b as n,f as ge,g as u,j as p,k as be,l as ke,m as a,n as c,t as m,o as d,p as f}from"../chunks/index.d5c3adcc.js";import{C as ve,H as _e,E as ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d504834e.js";import{C as E}from"../chunks/CodeBlock.df8b7a6e.js";function Ae(ue){let h,Q,G,F,y,B,M,L,T,ce=`Audio classification involves assigning one or more labels to an audio recording based on its content. The labels
could correspond to different sound categories, such as music, speech, or noise, or more specific categories like
bird song or car engine sounds.`,R,w,me=`Before diving into details on how the most popular audio transformers work, and before fine-tuning a custom model, let’s
see how you can use an off-the-shelf pre-trained model for audio classification with only a few lines of code with 🤗 Transformers.`,H,J,de=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,D,j,fe=`Just as before, let’s start by loading the <code>en-AU</code> subset of the data to try out the pipeline, and upsample it to 16kHz
sampling rate which is what most speech models require.`,S,g,P,b,he=`To classify an audio recording into a set of classes, we can use the <code>audio-classification</code> pipeline from 🤗 Transformers.
In our case, we need a model that’s been fine-tuned for intent classification, and specifically on
the MINDS-14 dataset. Luckily for us, the Hub has a model that does just that! Let’s load it by using the <code>pipeline()</code> function:`,V,$,X,U,ye=`This pipeline expects the audio data as a NumPy array. All the preprocessing of the raw audio data will be conveniently
handled for us by the pipeline. Let’s pick an example to try it out:`,Y,I,O,C,Me=`If you recall the structure of the dataset, the raw audio data is stored in a NumPy array under <code>[&quot;audio&quot;][&quot;array&quot;]</code>, let’s
pass it straight to the <code>classifier</code>:`,K,q,ee,x,Te="<strong>Output:</strong>",te,k,se,v,we=`The model is very confident that the caller intended to learn about paying their bill. Let’s see what the actual label for
this example is:`,ae,_,le,z,Je="<strong>Output:</strong>",ne,A,ie,W,je=`Hooray! The predicted label was correct! Here we were lucky to find a model that can classify the exact labels that we need.
A lot of the times, when dealing with a classification task, a pre-trained model’s set of classes is not exactly the same
as the classes you need the model to distinguish. In this case, you can fine-tune a pre-trained model to “calibrate” it to
your exact set of class labels. We’ll learn how to do this in the upcoming units. Now, let’s take a look at another very
common task in speech processing, <em>automatic speech recognition</em>.`,oe,N,pe,Z,re;return y=new ve({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new _e({props:{title:"Audio classification with a pipeline",local:"audio-classification-with-a-pipeline",headingTag:"h1"}}),g=new E({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLUFVJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),$=new E({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),I=new E({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RA==",highlighted:'example = minds[<span class="hljs-number">0</span>]',wrap:!1}}),q=new E({props:{code:"Y2xhc3NpZmllcihleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:'classifier(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])',wrap:!1}}),k=new E({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),_=new E({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),A=new E({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),N=new ze({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter2/audio_classification_pipeline.mdx"}}),{c(){h=i("meta"),Q=l(),G=i("p"),F=l(),r(y.$$.fragment),B=l(),r(M.$$.fragment),L=l(),T=i("p"),T.textContent=ce,R=l(),w=i("p"),w.textContent=me,H=l(),J=i("p"),J.innerHTML=de,D=l(),j=i("p"),j.innerHTML=fe,S=l(),r(g.$$.fragment),P=l(),b=i("p"),b.innerHTML=he,V=l(),r($.$$.fragment),X=l(),U=i("p"),U.textContent=ye,Y=l(),r(I.$$.fragment),O=l(),C=i("p"),C.innerHTML=Me,K=l(),r(q.$$.fragment),ee=l(),x=i("p"),x.innerHTML=Te,te=l(),r(k.$$.fragment),se=l(),v=i("p"),v.textContent=we,ae=l(),r(_.$$.fragment),le=l(),z=i("p"),z.innerHTML=Je,ne=l(),r(A.$$.fragment),ie=l(),W=i("p"),W.innerHTML=je,oe=l(),r(N.$$.fragment),pe=l(),Z=i("p"),this.h()},l(e){const t=xe("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(s),Q=n(e),G=o(e,"P",{}),ge(G).forEach(s),F=n(e),u(y.$$.fragment,e),B=n(e),u(M.$$.fragment,e),L=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-j9r3i6"&&(T.textContent=ce),R=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-dub6at"&&(w.textContent=me),H=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1jsn8wa"&&(J.innerHTML=de),D=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-15x65jw"&&(j.innerHTML=fe),S=n(e),u(g.$$.fragment,e),P=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1gi5ja6"&&(b.innerHTML=he),V=n(e),u($.$$.fragment,e),X=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-h7hari"&&(U.textContent=ye),Y=n(e),u(I.$$.fragment,e),O=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-nl73ko"&&(C.innerHTML=Me),K=n(e),u(q.$$.fragment,e),ee=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1mvdyro"&&(x.innerHTML=Te),te=n(e),u(k.$$.fragment,e),se=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1xhxyyp"&&(v.textContent=we),ae=n(e),u(_.$$.fragment,e),le=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1mvdyro"&&(z.innerHTML=Je),ne=n(e),u(A.$$.fragment,e),ie=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-66lxjm"&&(W.innerHTML=je),oe=n(e),u(N.$$.fragment,e),pe=n(e),Z=o(e,"P",{}),ge(Z).forEach(s),this.h()},h(){be(h,"name","hf:doc:metadata"),be(h,"content",We)},m(e,t){ke(document.head,h),a(e,Q,t),a(e,G,t),a(e,F,t),c(y,e,t),a(e,B,t),c(M,e,t),a(e,L,t),a(e,T,t),a(e,R,t),a(e,w,t),a(e,H,t),a(e,J,t),a(e,D,t),a(e,j,t),a(e,S,t),c(g,e,t),a(e,P,t),a(e,b,t),a(e,V,t),c($,e,t),a(e,X,t),a(e,U,t),a(e,Y,t),c(I,e,t),a(e,O,t),a(e,C,t),a(e,K,t),c(q,e,t),a(e,ee,t),a(e,x,t),a(e,te,t),c(k,e,t),a(e,se,t),a(e,v,t),a(e,ae,t),c(_,e,t),a(e,le,t),a(e,z,t),a(e,ne,t),c(A,e,t),a(e,ie,t),a(e,W,t),a(e,oe,t),c(N,e,t),a(e,pe,t),a(e,Z,t),re=!0},p:Ue,i(e){re||(m(y.$$.fragment,e),m(M.$$.fragment,e),m(g.$$.fragment,e),m($.$$.fragment,e),m(I.$$.fragment,e),m(q.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(N.$$.fragment,e),re=!0)},o(e){d(y.$$.fragment,e),d(M.$$.fragment,e),d(g.$$.fragment,e),d($.$$.fragment,e),d(I.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),re=!1},d(e){e&&(s(Q),s(G),s(F),s(B),s(L),s(T),s(R),s(w),s(H),s(J),s(D),s(j),s(S),s(P),s(b),s(V),s(X),s(U),s(Y),s(O),s(C),s(K),s(ee),s(x),s(te),s(se),s(v),s(ae),s(le),s(z),s(ne),s(ie),s(W),s(oe),s(pe),s(Z)),s(h),f(y,e),f(M,e),f(g,e),f($,e),f(I,e),f(q,e),f(k,e),f(_,e),f(A,e),f(N,e)}}}const We='{"title":"Audio classification with a pipeline","local":"audio-classification-with-a-pipeline","sections":[],"depth":1}';function Ne(ue){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fe extends Ce{constructor(h){super(),qe(this,h,Ne,Ae,$e,{})}}export{Fe as component};
