# Pipeline এর মাদ্ধমে Audio classification

audio classification হলো, একটি অডিও রেকর্ডিং-এর বিষয়বস্তুর উপর ভিত্তি করে অডিওর সাথে এক বা একাধিক label জড়িত করা।
এই label গুলো বিভিন্ন শব্দ বিভাগের সাথে মিল থাকতে পারে, যেমন সঙ্গীত, বক্তৃতা, বা শব্দ, বা আরও নির্দিষ্ট বিভাগ যেমন
পাখির গান বা গাড়ির ইঞ্জিনের শব্দ।

সর্বাধিক জনপ্রিয় audio transformers গুলো কীভাবে কাজ করে সে সম্পর্কে বিস্তারিত জানার আগে এবং একটি কাস্টম মডেল fine-tune করার আগে, আসুন দেখুন
কিভাবে আপনি 🤗 transformers সহ মাত্র কয়েক লাইন কোড সহ audio classification এর জন্য একটি অফ-দ্য-শেল্ফ pre-trained মডেল ব্যবহার করতে পারেন।

চলুন এগিয়ে যাই এবং [MINDS-14](https://huggingface.co/datasets/PolyAI/minds14) ডেটাসেট ব্যবহার করি যা আপনি আগের অধ্যায়ে অন্বেষণ করেছেন।
আপনি যদি মনে করেন, MINDS-14-এ কিছু লোকের ই-ব্যাঙ্কিং সিস্টেমের প্রশ্ন জিজ্ঞাসা করার রেকর্ডিং রয়েছে। তাছাড়াও এই ডাটাসেট এ ভাষা, উপভাষা, এবং প্রতিটি
রেকর্ডিংয়ের জন্য `intent_class` আছে। আমরা কলের উদ্দেশ্য দ্বারা রেকর্ডিংগুলোকে শ্রেণীবদ্ধ করতে পারি।

ঠিক আগের মতোই, আসুন pipeline টি চেষ্টা করার জন্য ডেটার `en-AU` উপসেট লোড করে শুরু করি এবং এটিকে 16kHz sampling rate-এ উন্নীত করি যা
বেশিরভাগ স্পিচ মডেলের প্রয়োজন।

```py
from datasets import load_dataset
from datasets import Audio

minds = load_dataset("PolyAI/minds14", name="en-AU", split="train")
minds = minds.cast_column("audio", Audio(sampling_rate=16_000))
```

একটি অডিও রেকর্ডিংকে ক্লাসের একটি সেটে শ্রেণীবদ্ধ করতে, আমরা 🤗 transformers থেকে `audio-classification` pipeline ব্যবহার করতে পারি। আমাদের
ক্ষেত্রে, আমাদের এমন একটি মডেল দরকার যা audio classification এর জন্য MINDS-14 ডেটাসেট এ train করা হয়েছে। সৌভাগ্যবশত আমাদের জন্য,
🤗 Hub এর এমন একটি মডেল রয়েছে যা ঠিক তাই করে! চলুন এটি লোড করি `pipeline()` ফাংশন ব্যবহার করে:

```py
from transformers import pipeline

classifier = pipeline(
    "audio-classification",
    model="anton-l/xtreme_s_xlsr_300m_minds14",
)
```

এই pipeline টি একটি NumPy অ্যারে হিসাবে অডিও ডেটাকে আশা করে ৷ আমাদের দ্বারা পরিচালিত pipeline দ্বারা কাঁচা অডিও ডেটার সমস্ত প্রিপ্রসেসিং সুবিধামত হবে ।
আসুন এটি চেষ্টা করার জন্য একটি উদাহরণ বেছে নেওয়া যাক:

```py
example = minds[0]
```

কাঁচা অডিও ডেটা একটি NumPy অ্যারেতে `["audio"]["array"]` এর অধীনে সংরক্ষিত হয়, আসুন এটিকে `classifier`-এ সরাসরি ব্যবহার করা যাক :

```py
classifier(example["audio"]["array"])
```

**Output:**
```out
[
    {"score": 0.9631525278091431, "label": "pay_bill"},
    {"score": 0.02819698303937912, "label": "freeze"},
    {"score": 0.0032787492964416742, "label": "card_issues"},
    {"score": 0.0019414445850998163, "label": "abroad"},
    {"score": 0.0008378693601116538, "label": "high_value_payment"},
]
```

মডেলটি খুব আত্মবিশ্বাসী, যে যিনি কল করেছেন তিনি তাদের বিল পরিশোধের বিষয়ে জানতে চেয়েছিলেন। এর প্রকৃত লেবেল কি জন্য দেখা যাক। এই উদাহরণ হল:

```py
id2label = minds.features["intent_class"].int2str
id2label(example["intent_class"])
```

**Output:**
```out
"pay_bill"
```

হুররে! মডেল দ্বারা পূর্বাভাসিত লেবেল সঠিক ছিল! এখানে আমরা এমন একটি মডেল খুঁজে পেয়ে ভাগ্যবান ছিলাম যা আমাদের প্রয়োজনীয় লেবেলগুলিকে শ্রেণীবদ্ধ করতে পারে।
অনেক সময়, একটি classification এর কাজ করার সময়, একটি pre-trained মডেলের ক্লাসের সেট ঠিক একই রকম হয় না।
সেই ক্ষেত্রে, আপনি একটি pre-trained মডেলকে "calibrate" করতে আপনার ক্লাস লেবেলের সঠিক সেট এ fine-tune করতে পারেন।
আমরা আসন্ন অধ্যায়গুলোতে এটি কীভাবে করতে হয় তা শিখব। এখন, এর আরেকটি খুব গুরুত্বপূর্ন টাস্ক, _automatic speech recognition_ কি করে করবো তা দেখা যাক ।

