# pipeline এর মাদ্ধমে Automatic speech recognition

Automatic Speech Recognition (ASR) হল একটি টাস্ক যার মধ্যে স্পিচ অডিও রেকর্ডিংকে টেক্সটে প্রতিলিপি করা হয়।
ভিডিওর জন্য caption তৈরি করা থেকে শুরু করে voice command system তৈরী করা পর্যন্ত এই টাস্কটিতে অনেকগুলি ব্যবহারিক অ্যাপ্লিকেশন রয়েছে ।
Siri এবং Alexa এর মত voice assistant তৈরির জন্য এই টাস্কটি ব্যবহার করা হয়।

এই বিভাগে, আমরা একজন ব্যক্তির একটি অডিও রেকর্ডিং প্রতিলিপি করতে `automatic-speech-recognition` পাইপলাইন ব্যবহার করব
আগের মতো একই MINDS-14 ডেটাসেট ব্যবহার করে বিল পরিশোধ করার বিষয়ে একটি প্রশ্ন জিজ্ঞাসা করবো।

শুরু করার জন্য, ডেটাসেট লোড করুন এবং [Pipeline এর মাদ্ধমে Audio classification](audio_classification_pipeline) এ বর্ণিত হিসাবে এটিকে 16kHz-এ sample করুন।

একটি অডিও রেকর্ডিং প্রতিলিপি করতে, আমরা 🤗 transformers থেকে `automatic-speech-recognition` pipeline ব্যবহার করতে পারি।

```py
from transformers import pipeline

asr = pipeline("automatic-speech-recognition")
```

এর পরে, আমরা ডেটাসেট থেকে একটি উদাহরণ নেব এবং এর কাঁচা ডেটা পাইপলাইনে প্রেরণ করব:

```py
example = minds[0]
asr(example["audio"]["array"])
```

**আউটপুট:**
```out
{"text": "I WOULD LIKE TO PAY MY ELECTRICITY BILL USING MY COD CAN YOU PLEASE ASSIST"}
```

আসুন এই আউটপুটটির সাথে এই উদাহরণের প্রকৃত ট্রান্সক্রিপশনের তুলনা করি:

```py
example["english_transcription"]
```

**আউটপুট:**
```out
"I would like to pay my electricity bill using my card can you please assist"
```

মডেলটি অডিও প্রতিলিপি তৈরী করাতে একটি চমত্কার ভাল কাজ করেছে বলে মনে হচ্ছে! শুধুমাত্র একটি শব্দ ভুল ("card") হয়েছে, যা অস্ট্রেলিয়ান স্পিকারের উচ্চারণ বিবেচনা করলে বেশ ভাল, যেখানে অক্ষর "r" প্রায়ই নীরব।

ডিফল্টরূপে, এই পাইপলাইনটি ইংরেজি ভাষার জন্য স্বয়ংক্রিয় বক্তৃতা শনাক্তকরণের জন্য প্রশিক্ষিত একটি মডেল ব্যবহার করে। আপনি যদি MINDS-14-এর অন্যান্য উপসেটগুলিকে ভিন্ন
ভাষায় প্রতিলিপি করার চেষ্টা করতে চান, তাহলে আপনি একটি pre-trained ASR মডেল খুঁজে পেতে পারেন [🤗 Hub এ](https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&language=fr&sort=downloads)।
আপনি প্রথমে টাস্ক, তারপর ভাষা দ্বারা মডেল তালিকা ফিল্টার করতে পারেন। একবার আপনি আপনার পছন্দের মডেলটি পেয়ে গেলে, এটির নাম pipeline এ `model` যুক্তি হিসাবে পাস করুন।

MINDS-14 এর জার্মান বিভাজনের জন্য এটি চেষ্টা করা যাক। "de-DE" উপসেট লোড করুন:

```py
from datasets import load_dataset
from datasets import Audio

minds = load_dataset("PolyAI/minds14", name="de-DE", split="train")
minds = minds.cast_column("audio", Audio(sampling_rate=16_000))
```

একটি উদাহরণ পান এবং ট্রান্সক্রিপশনটি কী হওয়া উচিত তা দেখুন:

```py
example = minds[0]
example["transcription"]
```

**আউটপুট:**
```out
"ich möchte gerne Geld auf mein Konto einzahlen"
```

🤗 Hub e জার্মান ভাষার জন্য একটি pre-trained ASR মডেল খুঁজুন, একটি pipeline তৈরী করুন এবং উদাহরণটি প্রতিলিপি করুন:

```py
from transformers import pipeline

asr = pipeline("automatic-speech-recognition", model="maxidl/wav2vec2-large-xlsr-german")
asr(example["audio"]["array"])
```

**আউটপুট:**
```out
{"text": "ich möchte gerne geld auf mein konto einzallen"}
```

সঠিক!

আপনার নিজের কাজ সমাধান করার সময়, একটি সাধারণ pipeline দিয়ে শুরু করতে পারেন যেমন আমরা এই অধ্যায়ে দেখিয়েছি। pipeline একটি মূল্যবান সাধনী যা বিভিন্ন সুবিধা প্রদান করে:
- একটি pre-trained মডেল বিদ্যমান থাকতে পারে যা ইতিমধ্যেই আপনার কাজটি সত্যিই ভালভাবে সমাধান করে, আপনার প্রচুর সময় বাঁচায়।
- pipeline() আপনার জন্য সমস্ত প্রাক/পরবর্তী প্রক্রিয়াকরণের যত্ন নেয়, তাই আপনাকে একটি মডেলের জন্য সঠিক বিন্যাস এর ডেটা পাওয়ার বিষয়ে চিন্তা করতে হবে না।
- যদি ফলাফলটি আদর্শ না হয়, তবে এটি আপনাকে ভবিষ্যতের fine tuning এর জন্য একটি দ্রুত বেসলাইন দেয়।
- একবার আপনি আপনার কাস্টম ডেটাতে একটি মডেল fine-tune করুন এবং এটি Hub এ শেয়ার করলে, সমগ্র সম্প্রদায় এটি দ্রুত ব্যবহার করতে সক্ষম হবে এবং অনায়াসে
`pipeline()` পদ্ধতির মাধ্যমে AI আরও সুলভ করে তুলবে।

