# অডিও ডেটা স্ট্রিমিং

অডিও ডেটাসেটগুলির মুখোমুখি হওয়া সবচেয়ে বড় চ্যালেঞ্জগুলির মধ্যে একটি হল তাদের নিছক আকার। এক মিনিটের অসংকুচিত সিডি-মানের অডিও (৪৪.১kHz, ১৬-বিট)
৫ MB এর একটু বেশি স্টোরেজ নেয়। সাধারণত, একটি অডিও ডেটাসেটে ঘণ্টার পর ঘণ্টা রেকর্ডিং থাকে।

পূর্ববর্তী বিভাগগুলিতে আমরা MINDS-14 অডিও ডেটাসেটের একটি খুব ছোট উপসেট ব্যবহার করেছি, তবে, সাধারণ অডিও ডেটাসেটগুলি অনেক বড়।
যেমন, [SpeechColab থেকে GigaSpeech](https://huggingface.co/datasets/speechcolab/gigaspeech) এর `xs` (সবচেয়ে ছোট) কনফিগারেশন
শুধুমাত্র ১০ ঘন্টা প্রশিক্ষণের ডেটা রয়েছে, কিন্তু ডাউনলোড এবং প্রস্তুতির জন্য ১৩GB স্টোরেজ স্পেস লাগে। কিন্তু আমরা যদি একটি আরো বোরো স্প্লিট এর উপর train করতে চাইবো?
একই ডেটাসেটের সম্পূর্ণ `xl` কনফিগারেশনে train এর জন্যে ১০,০০০ ঘন্টা অডিও ডাটা রয়েছে যার জন্যে ১TB-এর বেশি সঞ্চয়স্থানের প্রয়োজন।
আমাদের বেশিরভাগের জন্য, এটি হার্ড ড্রাইভএর ক্ষমতার বাইরে। তাহলে আমাদের কি অতিরিক্ত স্টোরেজ কিনতে হবে? অথবা কোন উপায় আছে যে আমরা এই
ডেটাসেটগুলিতে কোন ডিস্ক সীমাবদ্ধতা ছাড়াই train করতে পারি?

 🤗 ডেটাসেটগুলি স্ট্রিমিং মোড অফার করে উদ্ধারে আসে৷ স্ট্রিমিং আমাদেরকে ধীরে ধীরে ডেটা লোড করতে দেয়
আমরা ডেটাসেটের উপর পুনরাবৃত্তি করি। পুরো ডেটাসেট একবারে ডাউনলোড করার পরিবর্তে, আমরা একবারে একটি উদাহরণ ডেটাসেট লোড করি।
আমরা ডেটাসেটের উপর পুনরাবৃত্তি করি, যখন তাদের প্রয়োজন হয় তখন ফ্লাইতে উদাহরণগুলি লোড করা এবং প্রস্তুত করা। এই ভাবে, আমরা শুধুমাত্র সেই উদাহরণগুলিলোড করছি,
যেই উদাহরণগুলি ব্যবহার করছি অন্যগুলো নই! একবার আমরা একটি উদাহরণের নমুনা দিয়ে কাজ শেষ করার পরে, আমরা ডেটাসেটের উপর পুনরাবৃত্তি চালিয়ে যাই এবং
পরবর্তীটি লোড করি।

একবারে সম্পূর্ণ ডেটাসেট ডাউনলোড করার জন্য স্ট্রিমিং মোডের তিনটি প্রাথমিক সুবিধা রয়েছে:

* ডিস্ক স্পেস: উদাহরণগুলি মেমরিতে একের পর এক লোড হয় যখন আমরা ডেটাসেটের উপর পুনরাবৃত্তি করি। যেহেতু ডাটা ডাউনলোড হয় না
স্থানীয়ভাবে, কোন ডিস্ক স্থানের প্রয়োজনীয়তা নেই, তাই আপনি ইচ্ছামত আকারের ডেটাসেট ব্যবহার করতে পারেন।
* ডাউনলোড এবং প্রক্রিয়াকরণের সময়: অডিও ডেটাসেটগুলি বড় এবং ডাউনলোড এবং প্রক্রিয়া করার জন্য উল্লেখযোগ্য পরিমাণ সময় প্রয়োজন৷
স্ট্রিমিংয়ের সাথে, লোডিং এবং প্রসেসিং ফ্লাইতে সম্পন্ন করা হয়, যার অর্থ আপনি প্রথম যত তাড়াতাড়ি ডেটাসেট ব্যবহার করা শুরু করতে পারেন।
* সহজ পরীক্ষা: আপনার স্ক্রিপ্ট ছাড়াই কাজ করে কিনা তা পরীক্ষা করতে আপনি কয়েকটি উদাহরণের উপর পরীক্ষা করতে পারেন
সম্পূর্ণ ডেটাসেট ডাউনলোড না করেই ।

স্ট্রিমিং মোডে একটি সতর্কতা আছে। স্ট্রিমিং ছাড়াই একটি সম্পূর্ণ ডেটাসেট ডাউনলোড করার সময়, কাঁচা ডেটা এবং প্রক্রিয়াজাত উভয়ই
ডেটা স্থানীয়ভাবে ডিস্কে সংরক্ষণ করা হয়। যদি আমরা এই ডেটাসেটটি পুনরায় ব্যবহার করতে চাই, আমরা সরাসরি ডিস্ক থেকে প্রক্রিয়াকৃত ডেটা লোড করতে পারি,
ডাউনলোড এবং প্রক্রিয়াকরণের ধাপগুলি এড়িয়ে যাওয়া। ফলস্বরূপ, আমাদের শুধুমাত্র ডাউনলোড এবং প্রক্রিয়াকরণ করতে হবে
একবার, যার পরে আমরা প্রস্তুত ডেটা পুনরায় ব্যবহার করতে পারি।

স্ট্রিমিং মোডের সাথে, ডেটা ডিস্কে ডাউনলোড করা হয় না। সুতরাং, ডাউনলোড করা বা প্রি-প্রসেসড ডেটা ক্যাশ করা হয় না।
যদি আমরা ডেটাসেট পুনরায় ব্যবহার করতে চাই, তাহলে অডিও ফাইলগুলি লোড করা এবং প্রক্রিয়া করার ধাপগুলি পুনরাবৃত্তি করতে হবে।
এই কারণে, আপনি একাধিকবার ব্যবহার করতে পারেন এমন ডেটাসেটগুলিকে ডাউনলোড করার পরামর্শ দেওয়া হচ্ছে৷

আপনি কিভাবে স্ট্রিমিং মোড সক্ষম করতে পারেন? সহজ ! আপনি যখন আপনার ডেটাসেট লোড করবেন তখন শুধু `streaming=True` সেট করুন। বাকি সবকিছুর যত্ন আপনার জন্য নেওয়া হবে:

```py
gigaspeech = load_dataset("speechcolab/gigaspeech", "xs", streaming=True)
```

আমরা যেমন MINDS-14-এর ডাউনলোড করা উপসেটে প্রি-প্রসেসিং ধাপগুলি প্রয়োগ করেছি, আপনিও স্ট্রিমিং ডাটাসেট এ একই ধাপগুলি প্রয়োগ করতে পারেন।

একমাত্র পার্থক্য হল আপনি পাইথন ইন্ডেক্সিং (যেমন `gigaspeech["train"][sample_idx]`) ব্যবহার করে আর পৃথক নমুনা অ্যাক্সেস করতে পারবেন না।
পরিবর্তে, আপনাকে ডেটাসেটের উপর পুনরাবৃত্তি করতে হবে। একটি ডেটাসেট স্ট্রিম করার সময় আপনি কীভাবে একটি উদাহরণ অ্যাক্সেস করতে পারেন তা এখানে দেখানো হয়েছে:

```py
next(iter(gigaspeech["train"]))
```

**আউটপুট:**
```out
{
    "segment_id": "YOU0000000315_S0000660",
    "speaker": "N/A",
    "text": "AS THEY'RE LEAVING  CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY ",
    "audio": {
        "path": "xs_chunks_0000/YOU0000000315_S0000660.wav",
        "array": array(
            [0.0005188, 0.00085449, 0.00012207, ..., 0.00125122, 0.00076294, 0.00036621]
        ),
        "sampling_rate": 16000,
    },
    "begin_time": 2941.89,
    "end_time": 2945.07,
    "audio_id": "YOU0000000315",
    "title": "Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43",
    "url": "https://www.youtube.com/watch?v=zr2n1fLVasU",
    "source": 2,
    "category": 24,
    "original_full_path": "audio/youtube/P0004/YOU0000000315.opus",
}
```

আপনি যদি একটি বড় ডেটাসেট থেকে বেশ কয়েকটি উদাহরণের পূর্বরূপ দেখতে চান, তাহলে প্রথম n উপাদানগুলি পেতে `take()` ব্যবহার করুন। ধরা যাক গিগাস্পিচ
ডেটাসেটের থেকে প্রথম দুটি উদাহরণ নেওয়া হবে:

```py
gigaspeech_head = gigaspeech["train"].take(2)
list(gigaspeech_head)
```

**আউটপুট:**
```out
[
    {
        "segment_id": "YOU0000000315_S0000660",
        "speaker": "N/A",
        "text": "AS THEY'RE LEAVING  CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY ",
        "audio": {
            "path": "xs_chunks_0000/YOU0000000315_S0000660.wav",
            "array": array(
                [
                    0.0005188,
                    0.00085449,
                    0.00012207,
                    ...,
                    0.00125122,
                    0.00076294,
                    0.00036621,
                ]
            ),
            "sampling_rate": 16000,
        },
        "begin_time": 2941.89,
        "end_time": 2945.07,
        "audio_id": "YOU0000000315",
        "title": "Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43",
        "url": "https://www.youtube.com/watch?v=zr2n1fLVasU",
        "source": 2,
        "category": 24,
        "original_full_path": "audio/youtube/P0004/YOU0000000315.opus",
    },
    {
        "segment_id": "AUD0000001043_S0000775",
        "speaker": "N/A",
        "text": "SIX TOMATOES ",
        "audio": {
            "path": "xs_chunks_0000/AUD0000001043_S0000775.wav",
            "array": array(
                [
                    1.43432617e-03,
                    1.37329102e-03,
                    1.31225586e-03,
                    ...,
                    -6.10351562e-05,
                    -1.22070312e-04,
                    -1.83105469e-04,
                ]
            ),
            "sampling_rate": 16000,
        },
        "begin_time": 3673.96,
        "end_time": 3675.26,
        "audio_id": "AUD0000001043",
        "title": "Asteroid of Fear",
        "url": "http//www.archive.org/download/asteroid_of_fear_1012_librivox/asteroid_of_fear_1012_librivox_64kb_mp3.zip",
        "source": 0,
        "category": 28,
        "original_full_path": "audio/audiobook/P0011/AUD0000001043.opus",
    },
]
```

স্ট্রিমিং মোড আপনার গবেষণাকে পরবর্তী স্তরে নিয়ে যেতে পারে: শুধুমাত্র সবচেয়ে বড় ডেটাসেটগুলিই আপনার কাছে অ্যাক্সেসযোগ্য নয়, আপনি আপনার ডিস্ক স্পেস নিয়ে
চিন্তা না করেই সহজেই একাধিক ডেটাসেটের মাধ্যমে সিস্টেমের মূল্যায়ন করতে পারবেন। একটি একক ডেটাসেটে মূল্যায়ন করার থেকে বহু-ডেটাসেট মূল্যায়ন করা আরো
অনেক ভালো। উদাহরণ স্বরূপ - speech recognition system(c.f. End-to-end Speech Benchmark (ESB))।

