# কোর্সের উপাদান সম্পর্কে আপনার উপলব্ধি পরীক্ষা করুন

### ১. Sampling Rate কোন এককে পরিমাপ করা হয়?

### ২. একটি বড় অডিও ডেটাসেট স্ট্রিম করার সময়, আপনি কত তাড়াতাড়ি এটি ব্যবহার করা শুরু করতে পারেন?

### ৩. spectrogram কি ?

### ৪. Whisper দ্বারা প্রত্যাশিত লগ-মেল স্পেকট্রোগ্রামে, কাঁচা অডিও ডেটা রূপান্তর করার সবচেয়ে সহজ উপায় কী?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### ৫. আপনি কিভাবে 🤗 হাব থেকে একটি ডেটাসেট লোড করবেন?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### ৬. আপনার কাস্টম ডেটাসেটে ৩২ kHz sampling rate সহ উচ্চ-মানের অডিও রয়েছে৷ আপনি একটি speech recognition মডেলকে train করতে চান যা আশা করে যে অডিও উদাহরণগুলির একটি ১৬ খজ sampling rate থাকবে। তোমার কি করা উচিত?

### ৭. আপনি কিভাবে একটি মেশিন লার্নিং মডেল দ্বারা উত্পন্ন একটি spectrogram কে একটি waveform এ রূপান্তর করতে পারেন?

