# অডিও ডাটা প্রক্রিয়াকরণ

🤗 ডেটাসেটের সাথে একটি ডেটাসেট লোড করা মজার অর্ধেক। আপনি যদি এটি একটি মডেল train করার জন্য বা inference চালানোর জন্য ব্যবহার করার
পরিকল্পনা করেন, আপনাকে প্রথমে ডেটা প্রাক-প্রক্রিয়া করতে হবে। সাধারণভাবে, এটি নিম্নলিখিত পদক্ষেপগুলিকে অন্তর্ভুক্ত করবে:

* অডিও ডেটা resample করা
* ডেটাসেট ফিল্টার করা
* মডেলের প্রত্যাশিত ইনপুটে অডিও ডেটা রূপান্তর করা

## অডিও ডাটা কে Resample করা

`load_dataset` ফাংশনটি যেই sampling rate এর সাথে অডিও উদাহরণগুলি upload করা হয়েছিল সেই sampling rate এ সেই অডিও উদাহরণগুলিকে ডাউনলোড করে। এটি সর্বদা
আপনি যে মডেলকে train করার পরিকল্পনা করছেন বা inference জন্য ব্যবহার করছেন তার দ্বারা  প্রত্যাশিত sampling rate এর সমান নাও হতে পারে । যদি এর মধ্যে অমিল থাকে
তাহলে আপনাকে অডিও তাকে resample করতে হবে ।

উপলব্ধ প্রাক-প্রশিক্ষিত মডেলগুলির বেশিরভাগই ১৬ kHz এর নমুনা হারে অডিও ডেটাসেটে পূর্বপ্রশিক্ষিত হয়েছে।
যখন আমরা MINDS-14 ডেটাসেট অন্বেষণ করেছি, আপনি হয়তো লক্ষ্য করেছেন যে এটি ৮ kHz এ sample করা হয়েছে, যার মানে আমাদের resample করতে হবে।

এটি করতে, 🤗 ডেটাসেটের `cast_column` পদ্ধতি ব্যবহার করুন। এই অপারেশন জায়গায় অডিও পরিবর্তন করে না, বরং সংকেত
ডেটাসেটগুলি লোড করার সময় ফ্লাইতে অডিও উদাহরণগুলি পুনরায় নমুনা করতে। নিম্নলিখিত কোড স্যাম্পলিং সেট করবে
১৬ kHz পর্যন্ত হার:

```py
from datasets import Audio

minds = minds.cast_column("audio", Audio(sampling_rate=16_000))
```

MINDS-14 ডেটাসেটে প্রথম অডিও উদাহরণটি পুনরায় লোড করুন এবং এটি পছন্দসই `sampling rate`-এ পুনরায় নমুনা করা হয়েছে কিনা তা পরীক্ষা করুন:

```py
minds[0]
```

**আউটপুট:**
```out
{
    "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
    "audio": {
        "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
        "array": array(
            [
                2.0634243e-05,
                1.9437837e-04,
                2.2419340e-04,
                ...,
                9.3852862e-04,
                1.1302452e-03,
                7.1531429e-04,
            ],
            dtype=float32,
        ),
        "sampling_rate": 16000,
    },
    "transcription": "I would like to pay my electricity bill using my card can you please assist",
    "intent_class": 13,
}
```

আপনি লক্ষ্য করতে পারেন যে অ্যারের মানগুলিও এখন ভিন্ন। এর কারণ হল আমরা এখন এর জন্য amplitude মানগুলির দ্বিগুণ সংখ্যা পেয়েছি
প্রতিটি যে আমরা আগে ছিল.

💡 Resampling সম্পর্কে কিছু তথ্য: যদি একটি অডিও সিগন্যাল ৮ kHz এ নমুনা নেওয়া হয়, যাতে প্রতি সেকেন্ডে ৮০০০ নমুনা রিডিং হয়, আমরা জানি যে অডিওতে
৪ kHz এর বেশি ফ্রিকোয়েন্সি নেই, এটি Nyquist sampling theorem দ্বারা নিশ্চিত করা হয়। এই কারণে, আমরা নিশ্চিত হতে পারি যে স্যাম্পলিং পয়েন্টগুলির মধ্যে
সর্বদা মূল অবিচ্ছিন্ন সংকেত থাকে যা একটি মসৃণ বক্ররেখা তৈরি করে। upsampling করার মানে তখন, অতিরিক্ত নমুনার মান এই বক্ররেখা আনুমান করে গণনা করা।
এই মানগুলি আগে থেকে উপস্থিত যমুনার মান এর সাহায্যে গণনা করা হয়।  downsampling এর জন্যে আমরা প্রথমে যেকোনো ফ্রিকোয়েন্সি ফিল্টার আউট করি যা
Nyquist সীমার চেয়ে বেশি, তারপর নতুন নমুনা গণনা করি। অন্য কথায়, আপনি প্রতি দ্বিতীয় নমুনাকে ছুঁড়ে ফেলার মাধ্যমে ২x ফ্যাক্টর এ downsample করতে
পারবেন না - এটি সিগন্যালে বিকৃতি তৈরি করবে। resampling সঠিকভাবে করা কঠিন এবং ভাল-পরীক্ষিত লাইব্রেরি যেমন librosa বা 🤗 datasets এর উপর ছেড়ে দেওয়াই ভালো।

## ডেটাসেট ফিল্টার করা

কিছু মানদণ্ডের উপর ভিত্তি করে ডেটা ফিল্টার করা যেতে পারে। সাধারণ ক্ষেত্রে একটি অডিওর সময়কাল সীমিত।
উদাহরণস্বরূপ, একটি মডেল training এর সময় আমরা ২০ সেকেন্ডস এর বেশি যেকোন উদাহরণ ফিল্টার আউট করতে চাই আউট অফ মেমরির ত্রুটিগুলি রোধ করতে।

আমরা 🤗 ডেটাসেটের `filter` পদ্ধতি ব্যবহার করে এবং ফিল্টারিং লজিক সহ একটি ফাংশন পাস করে এটি করতে পারি। একটি ফাংশন লিখে শুরু করা যাক যা
নির্দেশ করে কোন উদাহরণ রাখতে হবে এবং কোনটি বাতিল করতে হবে। এই ফাংশন, `is_audio_length_in_range`, একটি নমুনা ২০ সেকেন্ডের চেয়ে ছোট হলে
`True` এবং ২০ সেকেন্ডের এর বেশি হলে `False` প্রদান করে।

```py
MAX_DURATION_IN_SECONDS = 20.0

def is_audio_length_in_range(input_length):
    return input_length 

এখন আপনি প্রি-প্রসেসিংয়ের পরে whisper মডেলের অডিও ইনপুটটি কেমন দেখায় তা দেখতে পারেন।

মডেলের বৈশিষ্ট্য এক্সট্র্যাক্টর ক্লাসটি মডেলটি প্রত্যাশা করে এমন ফর্ম্যাটে কাঁচা অডিও ডেটা রূপান্তর করার যত্ন নেয়। যাহোক,
অডিও জড়িত অনেক কাজ মাল্টিমোডাল, যেমন কন্ঠ সনান্তকরণ. এই ধরনের ক্ষেত্রে 🤗 ট্রান্সফরমারগুলিও মডেল-নির্দিষ্ট অফার করে
টেক্সট ইনপুট প্রক্রিয়া করার জন্য tokenizers. টোকেনাইজারগুলিতে গভীরভাবে ডুব দেওয়ার জন্য, অনুগ্রহ করে আমাদের [NLP কোর্স](https://huggingface.co/course/chapter2/4) দেখুন।

আপনি Whisper এবং অন্যান্য মাল্টিমডাল মডেলের জন্য আলাদাভাবে বৈশিষ্ট্য এক্সট্র্যাক্টর এবং টোকেনাইজার লোড করতে পারেন, অথবা আপনি প্রসেসর ক্লাস এর মাদ্ধমে উভয় লোড করতে পারেন।
জিনিসগুলিকে আরও সহজ করতে, একটি মডেলের ফিচার এক্সট্র্যাক্টর এবং প্রসেসর লোড করতে `AutoProcessor` ব্যবহার করুন
চেকপয়েন্ট, এই মত:

```py
from transformers import AutoProcessor

processor = AutoProcessor.from_pretrained("openai/whisper-small")
```

এখানে আমরা মৌলিক তথ্য প্রস্তুতির ধাপগুলি চিত্রিত করেছি। অবশ্যই, কাস্টম ডেটা আরও জটিল প্রিপ্রসেসিংয়ের প্রয়োজন হতে পারে।
এই ক্ষেত্রে, আপনি যেকোন ধরণের কাস্টম ডেটা ট্রান্সফরমেশন করার জন্য `prepare_dataset` ফাংশনটি প্রসারিত করতে পারেন। 🤗 আপনি যদি এটি একটি পাইথন
ফাংশন হিসাবে লিখতে পারেন, তাহলে আপনি এটি আপনার ডেটাসেটে প্রয়োগ করতে পারেন!

