import{s as Tt,o as Pt,n as Re}from"../chunks/scheduler.8c3d61f6.js";import{S as St,i as $t,g as l,s as i,r as f,A as kt,h as p,f as n,c as s,j,u as g,x as u,k as G,y as c,a as o,v as _,d as h,t as b,w}from"../chunks/index.da70eac4.js";import{T as Mt}from"../chunks/Tip.1d9b8c37.js";import{D as pe}from"../chunks/Docstring.6b390b9a.js";import{C as at}from"../chunks/CodeBlock.00a903b3.js";import{E as xt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as we,E as It}from"../chunks/EditOnGithub.1e64e623.js";function Jt($){let a,y='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=l("p"),a.innerHTML=y},l(d){a=p(d,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1wdzd23"&&(a.innerHTML=y)},m(d,m){o(d,a,m)},p:Re,d(d){d&&n(a)}}}function Ct($){let a,y='Make sure to pass the <code>variant</code> argument for downloaded checkpoints to use lower disk space. Set it to <code>&quot;fp16&quot;</code> for models with recommended dtype as <code>torch.float16</code>, and <code>&quot;bf16&quot;</code> for models with recommended dtype as <code>torch.bfloat16</code>. By default, <code>torch.float32</code> weights are downloaded, which use twice the amount of disk storage. Additionally, <code>torch.float32</code> weights can be downcasted on-the-fly by specifying the <code>torch_dtype</code> argument. Read about it in the <a href="https://huggingface.co/docs/diffusers/v0.31.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow">docs</a>.';return{c(){a=l("p"),a.innerHTML=y},l(d){a=p(d,"P",{"data-svelte-h":!0}),u(a)!=="svelte-1k3bkk9"&&(a.innerHTML=y)},m(d,m){o(d,a,m)},p:Re,d(d){d&&n(a)}}}function jt($){let a,y="Examples:",d,m,v;return m=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUudGV4dF9lbmNvZGVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjBwaXBlLnRyYW5zZm9ybWVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0QnYSUyMGN5YmVycHVuayUyMGNhdCUyMHdpdGglMjBhJTIwbmVvbiUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCUyMlNhbmElMjInKSU1QjAlNUQlMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>, torch_dtype=torch.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,d=i(),f(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),u(a)!=="svelte-kvfsh7"&&(a.textContent=y),d=s(r),g(m.$$.fragment,r)},m(r,M){o(r,a,M),o(r,d,M),_(m,r,M),v=!0},p:Re,i(r){v||(h(m.$$.fragment,r),v=!0)},o(r){b(m.$$.fragment,r),v=!1},d(r){r&&(n(a),n(d)),w(m,r)}}}function Gt($){let a,y="Examples:",d,m,v;return m=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBBR1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQQUdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIlMjJ0cmFuc2Zvcm1lcl9ibG9ja3MuOCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS50ZXh0X2VuY29kZXIudG8odG9yY2guYmZsb2F0MTYpJTBBcGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHBpcGUudHJhbnNmb3JtZXIudG8odG9yY2guYmZsb2F0MTYpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRCdhJTIwY3liZXJwdW5rJTIwY2F0JTIwd2l0aCUyMGElMjBuZW9uJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwJTIyU2FuYSUyMicpJTVCMCU1RCUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPAGPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;transformer_blocks.8&quot;</span>],
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,d=i(),f(m.$$.fragment)},l(r){a=p(r,"P",{"data-svelte-h":!0}),u(a)!=="svelte-kvfsh7"&&(a.textContent=y),d=s(r),g(m.$$.fragment,r)},m(r,M){o(r,a,M),o(r,d,M),_(m,r,M),v=!0},p:Re,i(r){v||(h(m.$$.fragment,r),v=!0)},o(r){b(m.$$.fragment,r),v=!1},d(r){r&&(n(a),n(d)),w(m,r)}}}function Ut($){let a,y,d,m,v,r,M,it='<a href="https://huggingface.co/papers/2410.10629" rel="nofollow">SANA: Efficient High-Resolution Image Synthesis with Linear Diffusion Transformers</a> from NVIDIA and MIT HAN Lab, by Enze Xie, Junsong Chen, Junyu Chen, Han Cai, Haotian Tang, Yujun Lin, Zhekai Zhang, Muyang Li, Ligeng Zhu, Yao Lu, Song Han.',ve,q,st="The abstract from the paper is:",ye,N,rt="<em>We introduce Sana, a text-to-image framework that can efficiently generate images up to 4096×4096 resolution. Sana can synthesize high-resolution, high-quality images with strong text-image alignment at a remarkably fast speed, deployable on laptop GPU. Core designs include: (1) Deep compression autoencoder: unlike traditional AEs, which compress images only 8×, we trained an AE that can compress images 32×, effectively reducing the number of latent tokens. (2) Linear DiT: we replace all vanilla attention in DiT with linear attention, which is more efficient at high resolutions without sacrificing quality. (3) Decoder-only text encoder: we replaced T5 with modern decoder-only small LLM as the text encoder and designed complex human instruction with in-context learning to enhance the image-text alignment. (4) Efficient training and sampling: we propose Flow-DPM-Solver to reduce sampling steps, with efficient caption labeling and selection to accelerate convergence. As a result, Sana-0.6B is very competitive with modern giant diffusion model (e.g. Flux-12B), being 20 times smaller and 100+ times faster in measured throughput. Moreover, Sana-0.6B can be deployed on a 16GB laptop GPU, taking less than 1 second to generate a 1024×1024 resolution image. Sana enables content creation at low cost. Code and model will be publicly released.</em>",Me,U,xe,F,lt='This pipeline was contributed by <a href="https://github.com/lawrence-cj" rel="nofollow">lawrence-cj</a> and <a href="https://github.com/chenjy2003" rel="nofollow">chenjy2003</a>. The original codebase can be found <a href="https://github.com/NVlabs/Sana" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/Efficient-Large-Model" rel="nofollow">hf.co/Efficient-Large-Model</a>.',Te,W,pt="Available models:",Pe,R,dt='<thead><tr><th align="center">Model</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr></tbody>',Se,H,ct='Refer to <a href="https://huggingface.co/collections/Efficient-Large-Model/sana-673efba2a57ed99843f11f9e" rel="nofollow">this</a> collection for more information.',$e,X,mt="Note: The recommended dtype mentioned is for the transformer weights. The text encoder and VAE weights must stay in <code>torch.bfloat16</code> or <code>torch.float32</code> for the model to work correctly. Please refer to the inference example below to see how to load the model with the recommended dtype.",ke,L,Ie,D,Je,z,ut="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Ce,Y,ft='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/pr_10011/en/api/pipelines/sana#diffusers.SanaPipeline">SanaPipeline</a> for inference with bitsandbytes.',je,V,Ge,Q,Ue,x,O,He,de,gt='Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>.',Xe,k,K,De,ce,_t="Function invoked when calling the pipeline for generation.",ze,A,Ye,Z,ee,Ve,me,ht="Encodes the prompt into text encoder hidden states.",Le,te,Ae,T,ne,Qe,ue,bt=`Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>. This pipeline
supports the use of <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/pag" rel="nofollow">Perturbed Attention Guidance
(PAG)</a>.`,Oe,I,oe,Ke,fe,wt="Function invoked when calling the pipeline for generation.",et,B,tt,E,ae,nt,ge,vt="Encodes the prompt into text encoder hidden states.",Ze,ie,Be,J,se,ot,_e,yt="Output class for Sana pipelines.",Ee,re,qe,be,Ne;return v=new we({props:{title:"SanaPipeline",local:"sanapipeline",headingTag:"h1"}}),U=new Mt({props:{$$slots:{default:[Jt]},$$scope:{ctx:$}}}),L=new Mt({props:{$$slots:{default:[Ct]},$$scope:{ctx:$}}}),D=new we({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),V=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBTYW5hVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU2FuYVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0ZXh0X2VuY29kZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzE2MDBNXzEwMjRweF9kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRyYW5zZm9ybWVyXzhiaXQlMjAlM0QlMjBTYW5hVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzE2MDBNXzEwMjRweF9kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTYW5hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfMTYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2Rlcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB0aW55JTIwYXN0cm9uYXV0JTIwaGF0Y2hpbmclMjBmcm9tJTIwYW4lMjBlZ2clMjBvbiUyMHRoZSUyMG1vb24lMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2FuYS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, SanaTransformer2DModel, SanaPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, AutoModelForCausalLM

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = SanaTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = SanaPipeline.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sana.png&quot;</span>)`,wrap:!1}}),Q=new we({props:{title:"SanaPipeline",local:"diffusers.SanaPipeline",headingTag:"h2"}}),O=new pe({props:{name:"class diffusers.SanaPipeline",anchor:"diffusers.SanaPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": AutoModelForCausalLM"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/sana/pipeline_sana.py#L145"}}),K=new pe({props:{name:"__call__",anchor:"diffusers.SanaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`}],parametersDescription:[{anchor:"diffusers.SanaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10011/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SanaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>300</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/sana/pipeline_sana.py#L600",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10011/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10011/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new xt({props:{anchor:"diffusers.SanaPipeline.__call__.example",$$slots:{default:[jt]},$$scope:{ctx:$}}}),ee=new pe({props:{name:"encode_prompt",anchor:"diffusers.SanaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.SanaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/sana/pipeline_sana.py#L178"}}),te=new we({props:{title:"SanaPAGPipeline",local:"diffusers.SanaPAGPipeline",headingTag:"h2"}}),ne=new pe({props:{name:"class diffusers.SanaPAGPipeline",anchor:"diffusers.SanaPAGPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": AutoModelForCausalLM"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"pag_applied_layers",val:": typing.Union[str, typing.List[str]] = 'transformer_blocks.0'"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L136"}}),oe=new pe({props:{name:"__call__",anchor:"diffusers.SanaPAGPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10011/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPAGPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L578",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10011/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10011/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),B=new xt({props:{anchor:"diffusers.SanaPAGPipeline.__call__.example",$$slots:{default:[Gt]},$$scope:{ctx:$}}}),ae=new pe({props:{name:"encode_prompt",anchor:"diffusers.SanaPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L173"}}),ie=new we({props:{title:"SanaPipelineOutput",local:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",headingTag:"h2"}}),se=new pe({props:{name:"class diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/sana/pipeline_output.py#L10"}}),re=new It({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/sana.md"}}),{c(){a=l("meta"),y=i(),d=l("p"),m=i(),f(v.$$.fragment),r=i(),M=l("p"),M.innerHTML=it,ve=i(),q=l("p"),q.textContent=st,ye=i(),N=l("p"),N.innerHTML=rt,Me=i(),f(U.$$.fragment),xe=i(),F=l("p"),F.innerHTML=lt,Te=i(),W=l("p"),W.textContent=pt,Pe=i(),R=l("table"),R.innerHTML=dt,Se=i(),H=l("p"),H.innerHTML=ct,$e=i(),X=l("p"),X.innerHTML=mt,ke=i(),f(L.$$.fragment),Ie=i(),f(D.$$.fragment),Je=i(),z=l("p"),z.textContent=ut,Ce=i(),Y=l("p"),Y.innerHTML=ft,je=i(),f(V.$$.fragment),Ge=i(),f(Q.$$.fragment),Ue=i(),x=l("div"),f(O.$$.fragment),He=i(),de=l("p"),de.innerHTML=gt,Xe=i(),k=l("div"),f(K.$$.fragment),De=i(),ce=l("p"),ce.textContent=_t,ze=i(),f(A.$$.fragment),Ye=i(),Z=l("div"),f(ee.$$.fragment),Ve=i(),me=l("p"),me.textContent=ht,Le=i(),f(te.$$.fragment),Ae=i(),T=l("div"),f(ne.$$.fragment),Qe=i(),ue=l("p"),ue.innerHTML=bt,Oe=i(),I=l("div"),f(oe.$$.fragment),Ke=i(),fe=l("p"),fe.textContent=wt,et=i(),f(B.$$.fragment),tt=i(),E=l("div"),f(ae.$$.fragment),nt=i(),ge=l("p"),ge.textContent=vt,Ze=i(),f(ie.$$.fragment),Be=i(),J=l("div"),f(se.$$.fragment),ot=i(),_e=l("p"),_e.textContent=yt,Ee=i(),f(re.$$.fragment),qe=i(),be=l("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),y=s(e),d=p(e,"P",{}),j(d).forEach(n),m=s(e),g(v.$$.fragment,e),r=s(e),M=p(e,"P",{"data-svelte-h":!0}),u(M)!=="svelte-h8aibn"&&(M.innerHTML=it),ve=s(e),q=p(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1cwsb16"&&(q.textContent=st),ye=s(e),N=p(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1uh3w7a"&&(N.innerHTML=rt),Me=s(e),g(U.$$.fragment,e),xe=s(e),F=p(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1eg28j8"&&(F.innerHTML=lt),Te=s(e),W=p(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1bob28v"&&(W.textContent=pt),Pe=s(e),R=p(e,"TABLE",{"data-svelte-h":!0}),u(R)!=="svelte-dcodwq"&&(R.innerHTML=dt),Se=s(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1swlfqd"&&(H.innerHTML=ct),$e=s(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-okwwje"&&(X.innerHTML=mt),ke=s(e),g(L.$$.fragment,e),Ie=s(e),g(D.$$.fragment,e),Je=s(e),z=p(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1ou2pxc"&&(z.textContent=ut),Ce=s(e),Y=p(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1dg8qli"&&(Y.innerHTML=ft),je=s(e),g(V.$$.fragment,e),Ge=s(e),g(Q.$$.fragment,e),Ue=s(e),x=p(e,"DIV",{class:!0});var P=j(x);g(O.$$.fragment,P),He=s(P),de=p(P,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1ot17tf"&&(de.innerHTML=gt),Xe=s(P),k=p(P,"DIV",{class:!0});var C=j(k);g(K.$$.fragment,C),De=s(C),ce=p(C,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-v78lg8"&&(ce.textContent=_t),ze=s(C),g(A.$$.fragment,C),C.forEach(n),Ye=s(P),Z=p(P,"DIV",{class:!0});var le=j(Z);g(ee.$$.fragment,le),Ve=s(le),me=p(le,"P",{"data-svelte-h":!0}),u(me)!=="svelte-16q0ax1"&&(me.textContent=ht),le.forEach(n),P.forEach(n),Le=s(e),g(te.$$.fragment,e),Ae=s(e),T=p(e,"DIV",{class:!0});var S=j(T);g(ne.$$.fragment,S),Qe=s(S),ue=p(S,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-vrq74s"&&(ue.innerHTML=bt),Oe=s(S),I=p(S,"DIV",{class:!0});var he=j(I);g(oe.$$.fragment,he),Ke=s(he),fe=p(he,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-v78lg8"&&(fe.textContent=wt),et=s(he),g(B.$$.fragment,he),he.forEach(n),tt=s(S),E=p(S,"DIV",{class:!0});var Fe=j(E);g(ae.$$.fragment,Fe),nt=s(Fe),ge=p(Fe,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-16q0ax1"&&(ge.textContent=vt),Fe.forEach(n),S.forEach(n),Ze=s(e),g(ie.$$.fragment,e),Be=s(e),J=p(e,"DIV",{class:!0});var We=j(J);g(se.$$.fragment,We),ot=s(We),_e=p(We,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1h3n85u"&&(_e.textContent=yt),We.forEach(n),Ee=s(e),g(re.$$.fragment,e),qe=s(e),be=p(e,"P",{}),j(be).forEach(n),this.h()},h(){G(a,"name","hf:doc:metadata"),G(a,"content",Lt),G(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,a),o(e,y,t),o(e,d,t),o(e,m,t),_(v,e,t),o(e,r,t),o(e,M,t),o(e,ve,t),o(e,q,t),o(e,ye,t),o(e,N,t),o(e,Me,t),_(U,e,t),o(e,xe,t),o(e,F,t),o(e,Te,t),o(e,W,t),o(e,Pe,t),o(e,R,t),o(e,Se,t),o(e,H,t),o(e,$e,t),o(e,X,t),o(e,ke,t),_(L,e,t),o(e,Ie,t),_(D,e,t),o(e,Je,t),o(e,z,t),o(e,Ce,t),o(e,Y,t),o(e,je,t),_(V,e,t),o(e,Ge,t),_(Q,e,t),o(e,Ue,t),o(e,x,t),_(O,x,null),c(x,He),c(x,de),c(x,Xe),c(x,k),_(K,k,null),c(k,De),c(k,ce),c(k,ze),_(A,k,null),c(x,Ye),c(x,Z),_(ee,Z,null),c(Z,Ve),c(Z,me),o(e,Le,t),_(te,e,t),o(e,Ae,t),o(e,T,t),_(ne,T,null),c(T,Qe),c(T,ue),c(T,Oe),c(T,I),_(oe,I,null),c(I,Ke),c(I,fe),c(I,et),_(B,I,null),c(T,tt),c(T,E),_(ae,E,null),c(E,nt),c(E,ge),o(e,Ze,t),_(ie,e,t),o(e,Be,t),o(e,J,t),_(se,J,null),c(J,ot),c(J,_e),o(e,Ee,t),_(re,e,t),o(e,qe,t),o(e,be,t),Ne=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),U.$set(P);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),L.$set(C);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),A.$set(le);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),B.$set(S)},i(e){Ne||(h(v.$$.fragment,e),h(U.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(A.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(B.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),Ne=!0)},o(e){b(v.$$.fragment,e),b(U.$$.fragment,e),b(L.$$.fragment,e),b(D.$$.fragment,e),b(V.$$.fragment,e),b(Q.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(A.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(B.$$.fragment,e),b(ae.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),b(re.$$.fragment,e),Ne=!1},d(e){e&&(n(y),n(d),n(m),n(r),n(M),n(ve),n(q),n(ye),n(N),n(Me),n(xe),n(F),n(Te),n(W),n(Pe),n(R),n(Se),n(H),n($e),n(X),n(ke),n(Ie),n(Je),n(z),n(Ce),n(Y),n(je),n(Ge),n(Ue),n(x),n(Le),n(Ae),n(T),n(Ze),n(Be),n(J),n(Ee),n(qe),n(be)),n(a),w(v,e),w(U,e),w(L,e),w(D,e),w(V,e),w(Q,e),w(O),w(K),w(A),w(ee),w(te,e),w(ne),w(oe),w(B),w(ae),w(ie,e),w(se),w(re,e)}}}const Lt='{"title":"SanaPipeline","local":"sanapipeline","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"SanaPipeline","local":"diffusers.SanaPipeline","sections":[],"depth":2},{"title":"SanaPAGPipeline","local":"diffusers.SanaPAGPipeline","sections":[],"depth":2},{"title":"SanaPipelineOutput","local":"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput","sections":[],"depth":2}],"depth":1}';function At($){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends St{constructor(a){super(),$t(this,a,At,Ut,Tt,{})}}export{Rt as component};
