import{s as kl,f as Zl,o as xl,n as Gl}from"../chunks/scheduler.f6319a2a.js";import{S as Bl,i as Wl,g as a,s,r as u,A as Rl,h as i,f as l,c as n,j as _l,u as d,x as r,k as At,y as Vl,a as o,v as h,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as Hl}from"../chunks/Tip.3d397a88.js";import{C as b}from"../chunks/CodeBlock.97b48fd2.js";import{D as Ql}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as w,E as El}from"../chunks/EditOnGithub.006048dd.js";function Nl(Ie){let p,f='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=f},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=f)},m(y,g){o(y,p,g)},p:Gl,d(y){y&&l(p)}}}function Al(Ie){let p,f="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=f},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=f)},m(y,g){o(y,p,g)},p:Gl,d(y){y&&l(p)}}}function Sl(Ie){let p,f,y,g,J,Ge,j,ke,v,St="Here, we’re going to see advanced tool usage.",xe,T,Be,C,Ft='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',We,$,Re,I,qt="A tool is mostly a function that an LLM can use in an agentic system.",Ve,Z,Lt="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Qe,_,Xt="So it cannot be only a function. It should be a class.",Ee,H,Yt="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",Ne,G,zt="Here’s how it looks:",Ae,k,Se,x,Pt='The custom tool subclasses <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Fe,B,Dt='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',qe,W,Kt="And that’s all it needs to be used in an agent!",Le,R,Ot='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Xe,V,el='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Ye,Q,ze,E,tl='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Pe,N,De,A,ll="For the push to Hub to work, your tool will need to respect some rules:",Ke,S,ol='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Oe,F,sl='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',et,q,nl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',tt,L,al=`Then you can load the tool with <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,lt,X,ot,Y,st,z,il='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',nt,P,rl='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',at,D,pl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',it,K,rt,O,ul="And voilà, here’s your image! 🏖️",pt,Ze,dl,ut,ee,hl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",dt,te,ht,le,mt,_e,ml,ct,oe,cl="How cool is this? 🤩",Mt,se,yt,ne,Ml=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,bt,ae,yl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ft,ie,wt,re,gt,pe,bl="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",Tt,ue,fl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",Ut,de,Jt,he,wl="Now we can leverage the new tool:",jt,me,vt,U,Ct,ce,$t,Me,gl='You can leverage tool collections by using <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',It,ye,Zt,be,Tl=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,_t,fe,Ht,we,Ul="To speed up the start, tools are loaded only if called by the agent.",Gt,ge,kt,Te,Jl='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',xt,Ue,jl='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1077/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Bt,Je,vl="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Wt,je,Rt,ve,Cl="For SSE-based MCP servers, simply pass a dict with parameters to <code>mcp.client.sse.sse_client</code>:",Vt,Ce,Qt,$e,Et,He,Nt;return J=new w({props:{title:"Tools",local:"tools",headingTag:"h1"}}),j=new Ql({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),T=new Hl({props:{warning:!1,$$slots:{default:[Nl]},$$scope:{ctx:Ie}}}),$=new w({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),k=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),Q=new w({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),N=new b({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),X=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new w({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),K=new b({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),te=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),le=new b({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),se=new w({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ie=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),re=new w({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),de=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEFhZ2VudC50b29scyU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wubmFtZSU1RCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),me=new b({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new Hl({props:{warning:!1,$$slots:{default:[Al]},$$scope:{ctx:Ie}}}),ce=new w({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),ye=new w({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),fe=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ge=new w({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),je=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ce=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),$e=new El({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=a("meta"),f=s(),y=a("p"),g=s(),u(J.$$.fragment),Ge=s(),u(j.$$.fragment),ke=s(),v=a("p"),v.textContent=St,xe=s(),u(T.$$.fragment),Be=s(),C=a("ul"),C.innerHTML=Ft,We=s(),u($.$$.fragment),Re=s(),I=a("p"),I.textContent=qt,Ve=s(),Z=a("p"),Z.textContent=Lt,Qe=s(),_=a("p"),_.textContent=Xt,Ee=s(),H=a("p"),H.textContent=Yt,Ne=s(),G=a("p"),G.textContent=zt,Ae=s(),u(k.$$.fragment),Se=s(),x=a("p"),x.innerHTML=Pt,Fe=s(),B=a("ul"),B.innerHTML=Dt,qe=s(),W=a("p"),W.textContent=Kt,Le=s(),R=a("p"),R.innerHTML=Ot,Xe=s(),V=a("p"),V.innerHTML=el,Ye=s(),u(Q.$$.fragment),ze=s(),E=a("p"),E.innerHTML=tl,Pe=s(),u(N.$$.fragment),De=s(),A=a("p"),A.textContent=ll,Ke=s(),S=a("ul"),S.innerHTML=ol,Oe=s(),F=a("p"),F.innerHTML=sl,et=s(),q=a("p"),q.innerHTML=nl,tt=s(),L=a("p"),L.innerHTML=al,lt=s(),u(X.$$.fragment),ot=s(),u(Y.$$.fragment),st=s(),z=a("p"),z.innerHTML=il,nt=s(),P=a("p"),P.innerHTML=rl,at=s(),D=a("p"),D.innerHTML=pl,it=s(),u(K.$$.fragment),rt=s(),O=a("p"),O.textContent=ul,pt=s(),Ze=a("img"),ut=s(),ee=a("p"),ee.innerHTML=hl,dt=s(),u(te.$$.fragment),ht=s(),u(le.$$.fragment),mt=s(),_e=a("img"),ct=s(),oe=a("p"),oe.textContent=cl,Mt=s(),u(se.$$.fragment),yt=s(),ne=a("p"),ne.innerHTML=Ml,bt=s(),ae=a("p"),ae.innerHTML=yl,ft=s(),u(ie.$$.fragment),wt=s(),u(re.$$.fragment),gt=s(),pe=a("p"),pe.innerHTML=bl,Tt=s(),ue=a("p"),ue.innerHTML=fl,Ut=s(),u(de.$$.fragment),Jt=s(),he=a("p"),he.textContent=wl,jt=s(),u(me.$$.fragment),vt=s(),u(U.$$.fragment),Ct=s(),u(ce.$$.fragment),$t=s(),Me=a("p"),Me.innerHTML=gl,It=s(),u(ye.$$.fragment),Zt=s(),be=a("p"),be.textContent=Tl,_t=s(),u(fe.$$.fragment),Ht=s(),we=a("p"),we.textContent=Ul,Gt=s(),u(ge.$$.fragment),kt=s(),Te=a("p"),Te.innerHTML=Jl,xt=s(),Ue=a("p"),Ue.innerHTML=jl,Bt=s(),Je=a("p"),Je.innerHTML=vl,Wt=s(),u(je.$$.fragment),Rt=s(),ve=a("p"),ve.innerHTML=Cl,Vt=s(),u(Ce.$$.fragment),Qt=s(),u($e.$$.fragment),Et=s(),He=a("p"),this.h()},l(e){const t=Rl("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),f=n(e),y=i(e,"P",{}),_l(y).forEach(l),g=n(e),d(J.$$.fragment,e),Ge=n(e),d(j.$$.fragment,e),ke=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8951oz"&&(v.textContent=St),xe=n(e),d(T.$$.fragment,e),Be=n(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=Ft),We=n(e),d($.$$.fragment,e),Re=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-50z9h0"&&(I.textContent=qt),Ve=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1llqfcr"&&(Z.textContent=Lt),Qe=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-eilpgu"&&(_.textContent=Xt),Ee=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-suz7fy"&&(H.textContent=Yt),Ne=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x18ywb"&&(G.textContent=zt),Ae=n(e),d(k.$$.fragment,e),Se=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-fr191i"&&(x.innerHTML=Pt),Fe=n(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-xqgwuf"&&(B.innerHTML=Dt),qe=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-220ayw"&&(W.textContent=Kt),Le=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-156tkim"&&(R.innerHTML=Ot),Xe=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-r10mcc"&&(V.innerHTML=el),Ye=n(e),d(Q.$$.fragment,e),ze=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ocq6ye"&&(E.innerHTML=tl),Pe=n(e),d(N.$$.fragment,e),De=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-hoocvd"&&(A.textContent=ll),Ke=n(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-q5pwqt"&&(S.innerHTML=ol),Oe=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-4n5s3c"&&(F.innerHTML=sl),et=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1knl8v8"&&(q.innerHTML=nl),tt=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1uh4x2g"&&(L.innerHTML=al),lt=n(e),d(X.$$.fragment,e),ot=n(e),d(Y.$$.fragment,e),st=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1vnmi08"&&(z.innerHTML=il),nt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1xkj0c9"&&(P.innerHTML=rl),at=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1gucs20"&&(D.innerHTML=pl),it=n(e),d(K.$$.fragment,e),rt=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-sgspwr"&&(O.textContent=ul),pt=n(e),Ze=i(e,"IMG",{src:!0}),ut=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1qp1ya7"&&(ee.innerHTML=hl),dt=n(e),d(te.$$.fragment,e),ht=n(e),d(le.$$.fragment,e),mt=n(e),_e=i(e,"IMG",{src:!0}),ct=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-i5dtbz"&&(oe.textContent=cl),Mt=n(e),d(se.$$.fragment,e),yt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1rq40pf"&&(ne.innerHTML=Ml),bt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1g7jkvd"&&(ae.innerHTML=yl),ft=n(e),d(ie.$$.fragment,e),wt=n(e),d(re.$$.fragment,e),gt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-69p3x"&&(pe.innerHTML=bl),Tt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ocb8u2"&&(ue.innerHTML=fl),Ut=n(e),d(de.$$.fragment,e),Jt=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-o3ledg"&&(he.textContent=wl),jt=n(e),d(me.$$.fragment,e),vt=n(e),d(U.$$.fragment,e),Ct=n(e),d(ce.$$.fragment,e),$t=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-60txdz"&&(Me.innerHTML=gl),It=n(e),d(ye.$$.fragment,e),Zt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-qubpc6"&&(be.textContent=Tl),_t=n(e),d(fe.$$.fragment,e),Ht=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-6r1jgt"&&(we.textContent=Ul),Gt=n(e),d(ge.$$.fragment,e),kt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1q39vf"&&(Te.innerHTML=Jl),xt=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1v78z1"&&(Ue.innerHTML=jl),Bt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-s0gh2b"&&(Je.innerHTML=vl),Wt=n(e),d(je.$$.fragment,e),Rt=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1skatdh"&&(ve.innerHTML=Cl),Vt=n(e),d(Ce.$$.fragment,e),Qt=n(e),d($e.$$.fragment,e),Et=n(e),He=i(e,"P",{}),_l(He).forEach(l),this.h()},h(){At(p,"name","hf:doc:metadata"),At(p,"content",Fl),Zl(Ze.src,dl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||At(Ze,"src",dl),Zl(_e.src,ml="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||At(_e,"src",ml)},m(e,t){Vl(document.head,p),o(e,f,t),o(e,y,t),o(e,g,t),h(J,e,t),o(e,Ge,t),h(j,e,t),o(e,ke,t),o(e,v,t),o(e,xe,t),h(T,e,t),o(e,Be,t),o(e,C,t),o(e,We,t),h($,e,t),o(e,Re,t),o(e,I,t),o(e,Ve,t),o(e,Z,t),o(e,Qe,t),o(e,_,t),o(e,Ee,t),o(e,H,t),o(e,Ne,t),o(e,G,t),o(e,Ae,t),h(k,e,t),o(e,Se,t),o(e,x,t),o(e,Fe,t),o(e,B,t),o(e,qe,t),o(e,W,t),o(e,Le,t),o(e,R,t),o(e,Xe,t),o(e,V,t),o(e,Ye,t),h(Q,e,t),o(e,ze,t),o(e,E,t),o(e,Pe,t),h(N,e,t),o(e,De,t),o(e,A,t),o(e,Ke,t),o(e,S,t),o(e,Oe,t),o(e,F,t),o(e,et,t),o(e,q,t),o(e,tt,t),o(e,L,t),o(e,lt,t),h(X,e,t),o(e,ot,t),h(Y,e,t),o(e,st,t),o(e,z,t),o(e,nt,t),o(e,P,t),o(e,at,t),o(e,D,t),o(e,it,t),h(K,e,t),o(e,rt,t),o(e,O,t),o(e,pt,t),o(e,Ze,t),o(e,ut,t),o(e,ee,t),o(e,dt,t),h(te,e,t),o(e,ht,t),h(le,e,t),o(e,mt,t),o(e,_e,t),o(e,ct,t),o(e,oe,t),o(e,Mt,t),h(se,e,t),o(e,yt,t),o(e,ne,t),o(e,bt,t),o(e,ae,t),o(e,ft,t),h(ie,e,t),o(e,wt,t),h(re,e,t),o(e,gt,t),o(e,pe,t),o(e,Tt,t),o(e,ue,t),o(e,Ut,t),h(de,e,t),o(e,Jt,t),o(e,he,t),o(e,jt,t),h(me,e,t),o(e,vt,t),h(U,e,t),o(e,Ct,t),h(ce,e,t),o(e,$t,t),o(e,Me,t),o(e,It,t),h(ye,e,t),o(e,Zt,t),o(e,be,t),o(e,_t,t),h(fe,e,t),o(e,Ht,t),o(e,we,t),o(e,Gt,t),h(ge,e,t),o(e,kt,t),o(e,Te,t),o(e,xt,t),o(e,Ue,t),o(e,Bt,t),o(e,Je,t),o(e,Wt,t),h(je,e,t),o(e,Rt,t),o(e,ve,t),o(e,Vt,t),h(Ce,e,t),o(e,Qt,t),h($e,e,t),o(e,Et,t),o(e,He,t),Nt=!0},p(e,[t]){const $l={};t&2&&($l.$$scope={dirty:t,ctx:e}),T.$set($l);const Il={};t&2&&(Il.$$scope={dirty:t,ctx:e}),U.$set(Il)},i(e){Nt||(m(J.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(U.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(je.$$.fragment,e),m(Ce.$$.fragment,e),m($e.$$.fragment,e),Nt=!0)},o(e){c(J.$$.fragment,e),c(j.$$.fragment,e),c(T.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(U.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),Nt=!1},d(e){e&&(l(f),l(y),l(g),l(Ge),l(ke),l(v),l(xe),l(Be),l(C),l(We),l(Re),l(I),l(Ve),l(Z),l(Qe),l(_),l(Ee),l(H),l(Ne),l(G),l(Ae),l(Se),l(x),l(Fe),l(B),l(qe),l(W),l(Le),l(R),l(Xe),l(V),l(Ye),l(ze),l(E),l(Pe),l(De),l(A),l(Ke),l(S),l(Oe),l(F),l(et),l(q),l(tt),l(L),l(lt),l(ot),l(st),l(z),l(nt),l(P),l(at),l(D),l(it),l(rt),l(O),l(pt),l(Ze),l(ut),l(ee),l(dt),l(ht),l(mt),l(_e),l(ct),l(oe),l(Mt),l(yt),l(ne),l(bt),l(ae),l(ft),l(wt),l(gt),l(pe),l(Tt),l(ue),l(Ut),l(Jt),l(he),l(jt),l(vt),l(Ct),l($t),l(Me),l(It),l(Zt),l(be),l(_t),l(Ht),l(we),l(Gt),l(kt),l(Te),l(xt),l(Ue),l(Bt),l(Je),l(Wt),l(Rt),l(ve),l(Vt),l(Qt),l(Et),l(He)),l(p),M(J,e),M(j,e),M(T,e),M($,e),M(k,e),M(Q,e),M(N,e),M(X,e),M(Y,e),M(K,e),M(te,e),M(le,e),M(se,e),M(ie,e),M(re,e),M(de,e),M(me,e),M(U,e),M(ce,e),M(ye,e),M(fe,e),M(ge,e),M(je,e),M(Ce,e),M($e,e)}}}const Fl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3}],"depth":1}';function ql(Ie){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Bl{constructor(p){super(),Wl(this,p,ql,Sl,kl,{})}}export{Kl as component};
