import{s as ll,n as sl,o as tl}from"../chunks/scheduler.b108d059.js";import{S as al,i as nl,g as i,s as a,r as m,A as il,h as o,f as s,c as n,j as Oe,u as p,x as r,k as el,y as ol,a as t,v as M,d as u,t as c,w as y}from"../chunks/index.008de539.js";import{C as xe}from"../chunks/CodeBlock.3968c746.js";import{H as j,E as rl}from"../chunks/EditOnGithub.d1c48e3d.js";function ml(Se){let h,D,R,K,U,O,b,Ie="This page explains how scores are normalized on the Open LLM Leaderboard for the six presented benchmarks. We can categorize all tasks into those with subtasks, those without subtasks, and generative evaluation.",ee,f,le,d,Ne="Normalization is the process of adjusting values measured on different scales to a common scale, making it possible to compare scores across different tasks. For the Open LLM Leaderboard, we normalize scores to:",se,w,Qe="<li>Account for the varying difficulty and random guess baselines of different tasks.</li> <li>Provide a consistent scale (0-100) for all tasks, enabling fair comparisons.</li> <li>Ensure that improvements over random guessing are appropriately reflected in the scores.</li>",te,J,ae,C,Ee="The basic normalization process involves two steps:",ne,T,We="<li>Subtracting the random baseline score (lower bound).</li> <li>Scaling the result to a range of 0-100.</li>",ie,v,Ge="We use the following normalization function:",oe,z,re,g,me,$,Ze="For tasks without subtasks (e.g., GPQA, MMLU-PRO), the normalization process is straightforward:",pe,_,Be="<li>Determine the lower bound (random guess baseline).</li> <li>Apply the normalization function.</li> <li>Scale to a percentage.</li>",Me,k,ue,A,Xe="GPQA has 4 <code>num_choices</code>, so the lower bound is 0.25 (1/<code>num_choices</code> = 1/4 = 0.25).",ce,x,ye,S,he,I,qe="For tasks with subtasks (e.g., MUSR, BBH), we follow these steps:",je,N,Ye="<li>Calculate the lower bound for each subtask.</li> <li>Normalize each subtask score.</li> <li>Average the normalized subtask scores.</li>",Ue,Q,be,E,Ve="MUSR has three subtasks with different numbers of choices:",fe,W,Fe="<li>MUSR murder mysteries, num_choices = 2, lower_bound = 0.5</li> <li>MUSR object placement, num_choices = 5, lower_bound = 0.2</li> <li>MUSR team allocation, num_choices = 3, lower_bound = 0.33</li>",de,G,we,Z,Je,B,Le="Generative evaluations like MATH and IFEval require a different approach:",Ce,X,He="<li><strong>MATH:</strong> Uses exact match accuracy. The lower bound is effectively 0, as random guessing is unlikely to produce a correct answer.</li> <li><strong>IFEval:</strong><ul><li>For instance-level evaluation (<code>ifeval_inst</code>), we use strict accuracy.</li> <li>For prompt-level evaluation (<code>ifeval_prompt</code>), we also use strict accuracy.</li> <li>The lower bound for both is 0, as random generation is unlikely to produce correct answers.</li></ul></li>",Te,q,Re="For these tasks, the normalization process in the code is as follows:",ve,Y,Pe="This approach ensures that even for generative tasks, we can provide normalized scores that are comparable across different evaluations.",ze,V,ge,F,De='For more detailed information and examples, please refer to our <a href="https://huggingface.co/spaces/open-llm-leaderboard/blog" rel="nofollow">blog post</a> on scores normalization.',$e,L,Ke='If you have any questions or need clarification, please start a new discussion on <a href="https://huggingface.co/spaces/open-llm-leaderboard/open_llm_leaderboard/discussions" rel="nofollow">the Leaderboard page</a>.',_e,H,ke,P,Ae;return U=new j({props:{title:"Scores Normalization",local:"scores-normalization",headingTag:"h1"}}),f=new j({props:{title:"What is Normalization?",local:"what-is-normalization",headingTag:"h2"}}),J=new j({props:{title:"General Normalization Process",local:"general-normalization-process",headingTag:"h2"}}),z=new xe({props:{code:"ZGVmJTIwbm9ybWFsaXplX3dpdGhpbl9yYW5nZSh2YWx1ZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCh2YWx1ZSUyMC0lMjBsb3dlcl9ib3VuZCklMjAlMkYlMjAoaGlnaGVyX2JvdW5kJTIwLSUyMGxvd2VyX2JvdW5kKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">normalize_within_range</span>(<span class="hljs-params">value, lower_bound, higher_bound</span>):
    <span class="hljs-keyword">return</span> (value - lower_bound) / (higher_bound - lower_bound)`,wrap:!1}}),g=new j({props:{title:"Normalizing Tasks without Subtasks",local:"normalizing-tasks-without-subtasks",headingTag:"h2"}}),k=new j({props:{title:"Example: Normalizing GPQA Scores",local:"example-normalizing-gpqa-scores",headingTag:"h3"}}),x=new xe({props:{code:"cmF3X3Njb3JlJTIwJTNEJTIwMC42JTIwJTIwJTIzJTIwRXhhbXBsZSUyMHJhdyUyMHNjb3JlJTBBbG93ZXJfYm91bmQlMjAlM0QlMjAwLjI1JTBBaGlnaGVyX2JvdW5kJTIwJTNEJTIwMS4wJTBBJTBBaWYlMjByYXdfc2NvcmUlMjAlM0MlMjBsb3dlcl9ib3VuZCUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKHJhd19zY29yZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUyMColMjAxMDAlMEElMEFwcmludChmJTIyTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMCU3Qm5vcm1hbGl6ZWRfc2NvcmUlM0EuMmYlN0QlMjIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMDQ2LjY3",highlighted:`raw_score = <span class="hljs-number">0.6</span>  <span class="hljs-comment"># Example raw score</span>
lower_bound = <span class="hljs-number">0.25</span>
higher_bound = <span class="hljs-number">1.0</span>

<span class="hljs-keyword">if</span> raw_score &lt; lower_bound:
    normalized_score = <span class="hljs-number">0</span>
<span class="hljs-keyword">else</span>:
    normalized_score = normalize_within_range(raw_score, lower_bound, higher_bound) * <span class="hljs-number">100</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Normalized GPQA score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-comment"># Output: Normalized GPQA score: 46.67</span>`,wrap:!1}}),S=new j({props:{title:"Normalizing Tasks with Subtasks",local:"normalizing-tasks-with-subtasks",headingTag:"h2"}}),Q=new j({props:{title:"Example: Normalizing MUSR Scores",local:"example-normalizing-musr-scores",headingTag:"h3"}}),G=new xe({props:{code:"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",highlighted:`subtasks = [
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;murder_mysteries&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.5</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;object_placement&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.4</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.2</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;team_allocation&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.6</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.333</span>}
]

normalized_scores = []

<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    <span class="hljs-keyword">if</span> subtask[<span class="hljs-string">&quot;raw_score&quot;</span>] &lt; subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>]:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            subtask[<span class="hljs-string">&quot;raw_score&quot;</span>], 
            subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>], 
            <span class="hljs-number">1.0</span>
        ) * <span class="hljs-number">100</span>
    normalized_scores.append(normalized_score)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{subtask[<span class="hljs-string">&#x27;name&#x27;</span>]}</span> normalized score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

overall_normalized_score = <span class="hljs-built_in">sum</span>(normalized_scores) / <span class="hljs-built_in">len</span>(normalized_scores)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Overall normalized MUSR score: <span class="hljs-subst">{overall_normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># murder_mysteries normalized score: 40.00</span>
<span class="hljs-comment"># object_placement normalized score: 25.00</span>
<span class="hljs-comment"># team_allocation normalized score: 40.00</span>
<span class="hljs-comment"># Overall normalized MUSR score: 35.00</span>`,wrap:!1}}),Z=new j({props:{title:"Generative Evaluations",local:"generative-evaluations",headingTag:"h2"}}),V=new j({props:{title:"Further Information",local:"further-information",headingTag:"h2"}}),H=new rl({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/normalization.md"}}),{c(){h=i("meta"),D=a(),R=i("p"),K=a(),m(U.$$.fragment),O=a(),b=i("p"),b.textContent=Ie,ee=a(),m(f.$$.fragment),le=a(),d=i("p"),d.textContent=Ne,se=a(),w=i("ol"),w.innerHTML=Qe,te=a(),m(J.$$.fragment),ae=a(),C=i("p"),C.textContent=Ee,ne=a(),T=i("ol"),T.innerHTML=We,ie=a(),v=i("p"),v.textContent=Ge,oe=a(),m(z.$$.fragment),re=a(),m(g.$$.fragment),me=a(),$=i("p"),$.textContent=Ze,pe=a(),_=i("ul"),_.innerHTML=Be,Me=a(),m(k.$$.fragment),ue=a(),A=i("p"),A.innerHTML=Xe,ce=a(),m(x.$$.fragment),ye=a(),m(S.$$.fragment),he=a(),I=i("p"),I.textContent=qe,je=a(),N=i("ul"),N.innerHTML=Ye,Ue=a(),m(Q.$$.fragment),be=a(),E=i("p"),E.textContent=Ve,fe=a(),W=i("ul"),W.innerHTML=Fe,de=a(),m(G.$$.fragment),we=a(),m(Z.$$.fragment),Je=a(),B=i("p"),B.textContent=Le,Ce=a(),X=i("ol"),X.innerHTML=He,Te=a(),q=i("p"),q.textContent=Re,ve=a(),Y=i("p"),Y.textContent=Pe,ze=a(),m(V.$$.fragment),ge=a(),F=i("p"),F.innerHTML=De,$e=a(),L=i("p"),L.innerHTML=Ke,_e=a(),m(H.$$.fragment),ke=a(),P=i("p"),this.h()},l(e){const l=il("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(s),D=n(e),R=o(e,"P",{}),Oe(R).forEach(s),K=n(e),p(U.$$.fragment,e),O=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1o7378m"&&(b.textContent=Ie),ee=n(e),p(f.$$.fragment,e),le=n(e),d=o(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1g21ee8"&&(d.textContent=Ne),se=n(e),w=o(e,"OL",{"data-svelte-h":!0}),r(w)!=="svelte-zj6h40"&&(w.innerHTML=Qe),te=n(e),p(J.$$.fragment,e),ae=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1homifm"&&(C.textContent=Ee),ne=n(e),T=o(e,"OL",{"data-svelte-h":!0}),r(T)!=="svelte-1noqtti"&&(T.innerHTML=We),ie=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-uv3qwg"&&(v.textContent=Ge),oe=n(e),p(z.$$.fragment,e),re=n(e),p(g.$$.fragment,e),me=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-ukmwwm"&&($.textContent=Ze),pe=n(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-199eldc"&&(_.innerHTML=Be),Me=n(e),p(k.$$.fragment,e),ue=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1n8wkts"&&(A.innerHTML=Xe),ce=n(e),p(x.$$.fragment,e),ye=n(e),p(S.$$.fragment,e),he=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3f8l62"&&(I.textContent=qe),je=n(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-cnj190"&&(N.innerHTML=Ye),Ue=n(e),p(Q.$$.fragment,e),be=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hgykxj"&&(E.textContent=Ve),fe=n(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-2hbeeh"&&(W.innerHTML=Fe),de=n(e),p(G.$$.fragment,e),we=n(e),p(Z.$$.fragment,e),Je=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1yp6rl7"&&(B.textContent=Le),Ce=n(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-1lwzczp"&&(X.innerHTML=He),Te=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1lm3jm4"&&(q.textContent=Re),ve=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1k8dio0"&&(Y.textContent=Pe),ze=n(e),p(V.$$.fragment,e),ge=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-12yyx1q"&&(F.innerHTML=De),$e=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n94pcj"&&(L.innerHTML=Ke),_e=n(e),p(H.$$.fragment,e),ke=n(e),P=o(e,"P",{}),Oe(P).forEach(s),this.h()},h(){el(h,"name","hf:doc:metadata"),el(h,"content",pl)},m(e,l){ol(document.head,h),t(e,D,l),t(e,R,l),t(e,K,l),M(U,e,l),t(e,O,l),t(e,b,l),t(e,ee,l),M(f,e,l),t(e,le,l),t(e,d,l),t(e,se,l),t(e,w,l),t(e,te,l),M(J,e,l),t(e,ae,l),t(e,C,l),t(e,ne,l),t(e,T,l),t(e,ie,l),t(e,v,l),t(e,oe,l),M(z,e,l),t(e,re,l),M(g,e,l),t(e,me,l),t(e,$,l),t(e,pe,l),t(e,_,l),t(e,Me,l),M(k,e,l),t(e,ue,l),t(e,A,l),t(e,ce,l),M(x,e,l),t(e,ye,l),M(S,e,l),t(e,he,l),t(e,I,l),t(e,je,l),t(e,N,l),t(e,Ue,l),M(Q,e,l),t(e,be,l),t(e,E,l),t(e,fe,l),t(e,W,l),t(e,de,l),M(G,e,l),t(e,we,l),M(Z,e,l),t(e,Je,l),t(e,B,l),t(e,Ce,l),t(e,X,l),t(e,Te,l),t(e,q,l),t(e,ve,l),t(e,Y,l),t(e,ze,l),M(V,e,l),t(e,ge,l),t(e,F,l),t(e,$e,l),t(e,L,l),t(e,_e,l),M(H,e,l),t(e,ke,l),t(e,P,l),Ae=!0},p:sl,i(e){Ae||(u(U.$$.fragment,e),u(f.$$.fragment,e),u(J.$$.fragment,e),u(z.$$.fragment,e),u(g.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),u(Q.$$.fragment,e),u(G.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),Ae=!0)},o(e){c(U.$$.fragment,e),c(f.$$.fragment,e),c(J.$$.fragment,e),c(z.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(G.$$.fragment,e),c(Z.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),Ae=!1},d(e){e&&(s(D),s(R),s(K),s(O),s(b),s(ee),s(le),s(d),s(se),s(w),s(te),s(ae),s(C),s(ne),s(T),s(ie),s(v),s(oe),s(re),s(me),s($),s(pe),s(_),s(Me),s(ue),s(A),s(ce),s(ye),s(he),s(I),s(je),s(N),s(Ue),s(be),s(E),s(fe),s(W),s(de),s(we),s(Je),s(B),s(Ce),s(X),s(Te),s(q),s(ve),s(Y),s(ze),s(ge),s(F),s($e),s(L),s(_e),s(ke),s(P)),s(h),y(U,e),y(f,e),y(J,e),y(z,e),y(g,e),y(k,e),y(x,e),y(S,e),y(Q,e),y(G,e),y(Z,e),y(V,e),y(H,e)}}}const pl='{"title":"Scores Normalization","local":"scores-normalization","sections":[{"title":"What is Normalization?","local":"what-is-normalization","sections":[],"depth":2},{"title":"General Normalization Process","local":"general-normalization-process","sections":[],"depth":2},{"title":"Normalizing Tasks without Subtasks","local":"normalizing-tasks-without-subtasks","sections":[{"title":"Example: Normalizing GPQA Scores","local":"example-normalizing-gpqa-scores","sections":[],"depth":3}],"depth":2},{"title":"Normalizing Tasks with Subtasks","local":"normalizing-tasks-with-subtasks","sections":[{"title":"Example: Normalizing MUSR Scores","local":"example-normalizing-musr-scores","sections":[],"depth":3}],"depth":2},{"title":"Generative Evaluations","local":"generative-evaluations","sections":[],"depth":2},{"title":"Further Information","local":"further-information","sections":[],"depth":2}],"depth":1}';function Ml(Se){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends al{constructor(h){super(),nl(this,h,Ml,ml,ll,{})}}export{jl as component};
