import{s as Es,n as vs,o as Ss}from"../chunks/scheduler.7bc62968.js";import{S as Vs,i as Fs,g as p,s as t,r as o,A as Ys,h as i,f as a,c as n,j as Ws,u as c,x as u,k as Ns,y as Hs,a as e,v as h,d as M,t as y,w as J}from"../chunks/index.66556066.js";import{C as z}from"../chunks/CodeBlock.a759539a.js";import{H as r,E as _s}from"../chunks/EditOnGithub.46ca76a5.js";function Xs(js){let T,L,_,q,w,x,d,gs="Official utilities to use the Hugging Face Hub API.",A,m,P,U,D,j,K,g,O,f,ss,b,fs='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',ls,I,bs='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',as,Z,es,C,ts,B,Is='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ns,k,Zs="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ps,G,is,$,Cs='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',os,R,cs,Q,Bs='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',hs,W,Ms,N,ks="Note that the cache directory is created and used only by the Python and Rust libraries. Downloading files using the <code>@huggingface/hub</code> package won’t use the cache directory.",ys,E,Js,v,Gs="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",us,S,$s="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",Ts,V,Rs="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",rs,F,ws,Y,Qs="<li><code>@huggingface/tasks</code> : Typings only</li>",ds,H,ms,X,Us;return w=new r({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),m=new r({props:{title:"Install",local:"install",headingTag:"h2"}}),U=new z({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),j=new r({props:{title:"Deno",local:"deno",headingTag:"h3"}}),g=new z({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),f=new r({props:{title:"Usage",local:"usage",headingTag:"h2"}}),Z=new z({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI, modelInfo, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> <span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),C=new r({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),G=new z({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),R=new r({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),W=new z({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),E=new r({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),F=new r({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),H=new _s({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){T=p("meta"),L=t(),_=p("p"),q=t(),o(w.$$.fragment),x=t(),d=p("p"),d.textContent=gs,A=t(),o(m.$$.fragment),P=t(),o(U.$$.fragment),D=t(),o(j.$$.fragment),K=t(),o(g.$$.fragment),O=t(),o(f.$$.fragment),ss=t(),b=p("p"),b.innerHTML=fs,ls=t(),I=p("p"),I.innerHTML=bs,as=t(),o(Z.$$.fragment),es=t(),o(C.$$.fragment),ts=t(),B=p("p"),B.innerHTML=Is,ns=t(),k=p("p"),k.textContent=Zs,ps=t(),o(G.$$.fragment),is=t(),$=p("p"),$.innerHTML=Cs,os=t(),o(R.$$.fragment),cs=t(),Q=p("p"),Q.innerHTML=Bs,hs=t(),o(W.$$.fragment),Ms=t(),N=p("p"),N.innerHTML=ks,ys=t(),o(E.$$.fragment),Js=t(),v=p("p"),v.innerHTML=Gs,us=t(),S=p("p"),S.innerHTML=$s,Ts=t(),V=p("p"),V.innerHTML=Rs,rs=t(),o(F.$$.fragment),ws=t(),Y=p("ul"),Y.innerHTML=Qs,ds=t(),o(H.$$.fragment),ms=t(),X=p("p"),this.h()},l(s){const l=Ys("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(a),L=n(s),_=i(s,"P",{}),Ws(_).forEach(a),q=n(s),c(w.$$.fragment,s),x=n(s),d=i(s,"P",{"data-svelte-h":!0}),u(d)!=="svelte-a2asrt"&&(d.textContent=gs),A=n(s),c(m.$$.fragment,s),P=n(s),c(U.$$.fragment,s),D=n(s),c(j.$$.fragment,s),K=n(s),c(g.$$.fragment,s),O=n(s),c(f.$$.fragment,s),ss=n(s),b=i(s,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1nqczoz"&&(b.innerHTML=fs),ls=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6ptpin"&&(I.innerHTML=bs),as=n(s),c(Z.$$.fragment,s),es=n(s),c(C.$$.fragment,s),ts=n(s),B=i(s,"P",{"data-svelte-h":!0}),u(B)!=="svelte-bfok93"&&(B.innerHTML=Is),ns=n(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1az135e"&&(k.textContent=Zs),ps=n(s),c(G.$$.fragment,s),is=n(s),$=i(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-1qsa6tj"&&($.innerHTML=Cs),os=n(s),c(R.$$.fragment,s),cs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-8xjlck"&&(Q.innerHTML=Bs),hs=n(s),c(W.$$.fragment,s),Ms=n(s),N=i(s,"P",{"data-svelte-h":!0}),u(N)!=="svelte-tt42mo"&&(N.innerHTML=ks),ys=n(s),c(E.$$.fragment,s),Js=n(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1gspubq"&&(v.innerHTML=Gs),us=n(s),S=i(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-em0etc"&&(S.innerHTML=$s),Ts=n(s),V=i(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-lja874"&&(V.innerHTML=Rs),rs=n(s),c(F.$$.fragment,s),ws=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),u(Y)!=="svelte-mopwlb"&&(Y.innerHTML=Qs),ds=n(s),c(H.$$.fragment,s),ms=n(s),X=i(s,"P",{}),Ws(X).forEach(a),this.h()},h(){Ns(T,"name","hf:doc:metadata"),Ns(T,"content",zs)},m(s,l){Hs(document.head,T),e(s,L,l),e(s,_,l),e(s,q,l),h(w,s,l),e(s,x,l),e(s,d,l),e(s,A,l),h(m,s,l),e(s,P,l),h(U,s,l),e(s,D,l),h(j,s,l),e(s,K,l),h(g,s,l),e(s,O,l),h(f,s,l),e(s,ss,l),e(s,b,l),e(s,ls,l),e(s,I,l),e(s,as,l),h(Z,s,l),e(s,es,l),h(C,s,l),e(s,ts,l),e(s,B,l),e(s,ns,l),e(s,k,l),e(s,ps,l),h(G,s,l),e(s,is,l),e(s,$,l),e(s,os,l),h(R,s,l),e(s,cs,l),e(s,Q,l),e(s,hs,l),h(W,s,l),e(s,Ms,l),e(s,N,l),e(s,ys,l),h(E,s,l),e(s,Js,l),e(s,v,l),e(s,us,l),e(s,S,l),e(s,Ts,l),e(s,V,l),e(s,rs,l),h(F,s,l),e(s,ws,l),e(s,Y,l),e(s,ds,l),h(H,s,l),e(s,ms,l),e(s,X,l),Us=!0},p:vs,i(s){Us||(M(w.$$.fragment,s),M(m.$$.fragment,s),M(U.$$.fragment,s),M(j.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(Z.$$.fragment,s),M(C.$$.fragment,s),M(G.$$.fragment,s),M(R.$$.fragment,s),M(W.$$.fragment,s),M(E.$$.fragment,s),M(F.$$.fragment,s),M(H.$$.fragment,s),Us=!0)},o(s){y(w.$$.fragment,s),y(m.$$.fragment,s),y(U.$$.fragment,s),y(j.$$.fragment,s),y(g.$$.fragment,s),y(f.$$.fragment,s),y(Z.$$.fragment,s),y(C.$$.fragment,s),y(G.$$.fragment,s),y(R.$$.fragment,s),y(W.$$.fragment,s),y(E.$$.fragment,s),y(F.$$.fragment,s),y(H.$$.fragment,s),Us=!1},d(s){s&&(a(L),a(_),a(q),a(x),a(d),a(A),a(P),a(D),a(K),a(O),a(ss),a(b),a(ls),a(I),a(as),a(es),a(ts),a(B),a(ns),a(k),a(ps),a(is),a($),a(os),a(cs),a(Q),a(hs),a(Ms),a(N),a(ys),a(Js),a(v),a(us),a(S),a(Ts),a(V),a(rs),a(ws),a(Y),a(ds),a(ms),a(X)),a(T),J(w,s),J(m,s),J(U,s),J(j,s),J(g,s),J(f,s),J(Z,s),J(C,s),J(G,s),J(R,s),J(W,s),J(E,s),J(F,s),J(H,s)}}}const zs='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Ls(js){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Vs{constructor(T){super(),Fs(this,T,Ls,Xs,Es,{})}}export{Ds as component};
