import{s as Qs,n as vs,o as Vs}from"../chunks/scheduler.7bc62968.js";import{S as Xs,i as Ys,g as p,s as t,r as o,A as As,h as i,f as a,c as n,j as Ns,u as c,x as r,k as Rs,y as Hs,a as e,v as M,d as h,t as u,w as j}from"../chunks/index.66556066.js";import{C as S}from"../chunks/CodeBlock.a759539a.js";import{H as J,E as _s}from"../chunks/EditOnGithub.46ca76a5.js";function Fs(gs){let y,q,_,z,d,L,w,Us="Official utilities to use the Hugging Face Hub API.",x,m,P,T,D,g,K,U,O,f,ss,b,fs='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',ls,I,bs='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',as,Z,es,k,ts,B,Is='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ns,C,Zs="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ps,G,is,$,ks='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',os,E,cs,W,Bs='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',Ms,N,hs,R,Cs="Note that the cache directory is created and used only by the Python and Rust libraries. Downloading files using the <code>@huggingface/hub</code> package won’t use the cache directory.",us,Q,js,v,Gs="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",rs,V,$s="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",ys,X,Es="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",Js,Y,ds,A,Ws="<li><code>@huggingface/tasks</code> : Typings only</li>",ws,H,ms,F,Ts;return d=new J({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),m=new J({props:{title:"Install",local:"install",headingTag:"h2"}}),T=new S({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),g=new J({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new S({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),f=new J({props:{title:"Usage",local:"usage",headingTag:"h2"}}),Z=new S({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),k=new J({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),G=new S({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),E=new J({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),N=new S({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),Q=new J({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),Y=new J({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),H=new _s({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){y=p("meta"),q=t(),_=p("p"),z=t(),o(d.$$.fragment),L=t(),w=p("p"),w.textContent=Us,x=t(),o(m.$$.fragment),P=t(),o(T.$$.fragment),D=t(),o(g.$$.fragment),K=t(),o(U.$$.fragment),O=t(),o(f.$$.fragment),ss=t(),b=p("p"),b.innerHTML=fs,ls=t(),I=p("p"),I.innerHTML=bs,as=t(),o(Z.$$.fragment),es=t(),o(k.$$.fragment),ts=t(),B=p("p"),B.innerHTML=Is,ns=t(),C=p("p"),C.textContent=Zs,ps=t(),o(G.$$.fragment),is=t(),$=p("p"),$.innerHTML=ks,os=t(),o(E.$$.fragment),cs=t(),W=p("p"),W.innerHTML=Bs,Ms=t(),o(N.$$.fragment),hs=t(),R=p("p"),R.innerHTML=Cs,us=t(),o(Q.$$.fragment),js=t(),v=p("p"),v.innerHTML=Gs,rs=t(),V=p("p"),V.innerHTML=$s,ys=t(),X=p("p"),X.innerHTML=Es,Js=t(),o(Y.$$.fragment),ds=t(),A=p("ul"),A.innerHTML=Ws,ws=t(),o(H.$$.fragment),ms=t(),F=p("p"),this.h()},l(s){const l=As("svelte-u9bgzb",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(a),q=n(s),_=i(s,"P",{}),Ns(_).forEach(a),z=n(s),c(d.$$.fragment,s),L=n(s),w=i(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-a2asrt"&&(w.textContent=Us),x=n(s),c(m.$$.fragment,s),P=n(s),c(T.$$.fragment,s),D=n(s),c(g.$$.fragment,s),K=n(s),c(U.$$.fragment,s),O=n(s),c(f.$$.fragment,s),ss=n(s),b=i(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1nqczoz"&&(b.innerHTML=fs),ls=n(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-6ptpin"&&(I.innerHTML=bs),as=n(s),c(Z.$$.fragment,s),es=n(s),c(k.$$.fragment,s),ts=n(s),B=i(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-bfok93"&&(B.innerHTML=Is),ns=n(s),C=i(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1az135e"&&(C.textContent=Zs),ps=n(s),c(G.$$.fragment,s),is=n(s),$=i(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1qsa6tj"&&($.innerHTML=ks),os=n(s),c(E.$$.fragment,s),cs=n(s),W=i(s,"P",{"data-svelte-h":!0}),r(W)!=="svelte-8xjlck"&&(W.innerHTML=Bs),Ms=n(s),c(N.$$.fragment,s),hs=n(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tt42mo"&&(R.innerHTML=Cs),us=n(s),c(Q.$$.fragment,s),js=n(s),v=i(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gspubq"&&(v.innerHTML=Gs),rs=n(s),V=i(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-em0etc"&&(V.innerHTML=$s),ys=n(s),X=i(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-lja874"&&(X.innerHTML=Es),Js=n(s),c(Y.$$.fragment,s),ds=n(s),A=i(s,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-mopwlb"&&(A.innerHTML=Ws),ws=n(s),c(H.$$.fragment,s),ms=n(s),F=i(s,"P",{}),Ns(F).forEach(a),this.h()},h(){Rs(y,"name","hf:doc:metadata"),Rs(y,"content",Ss)},m(s,l){Hs(document.head,y),e(s,q,l),e(s,_,l),e(s,z,l),M(d,s,l),e(s,L,l),e(s,w,l),e(s,x,l),M(m,s,l),e(s,P,l),M(T,s,l),e(s,D,l),M(g,s,l),e(s,K,l),M(U,s,l),e(s,O,l),M(f,s,l),e(s,ss,l),e(s,b,l),e(s,ls,l),e(s,I,l),e(s,as,l),M(Z,s,l),e(s,es,l),M(k,s,l),e(s,ts,l),e(s,B,l),e(s,ns,l),e(s,C,l),e(s,ps,l),M(G,s,l),e(s,is,l),e(s,$,l),e(s,os,l),M(E,s,l),e(s,cs,l),e(s,W,l),e(s,Ms,l),M(N,s,l),e(s,hs,l),e(s,R,l),e(s,us,l),M(Q,s,l),e(s,js,l),e(s,v,l),e(s,rs,l),e(s,V,l),e(s,ys,l),e(s,X,l),e(s,Js,l),M(Y,s,l),e(s,ds,l),e(s,A,l),e(s,ws,l),M(H,s,l),e(s,ms,l),e(s,F,l),Ts=!0},p:vs,i(s){Ts||(h(d.$$.fragment,s),h(m.$$.fragment,s),h(T.$$.fragment,s),h(g.$$.fragment,s),h(U.$$.fragment,s),h(f.$$.fragment,s),h(Z.$$.fragment,s),h(k.$$.fragment,s),h(G.$$.fragment,s),h(E.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(H.$$.fragment,s),Ts=!0)},o(s){u(d.$$.fragment,s),u(m.$$.fragment,s),u(T.$$.fragment,s),u(g.$$.fragment,s),u(U.$$.fragment,s),u(f.$$.fragment,s),u(Z.$$.fragment,s),u(k.$$.fragment,s),u(G.$$.fragment,s),u(E.$$.fragment,s),u(N.$$.fragment,s),u(Q.$$.fragment,s),u(Y.$$.fragment,s),u(H.$$.fragment,s),Ts=!1},d(s){s&&(a(q),a(_),a(z),a(L),a(w),a(x),a(P),a(D),a(K),a(O),a(ss),a(b),a(ls),a(I),a(as),a(es),a(ts),a(B),a(ns),a(C),a(ps),a(is),a($),a(os),a(cs),a(W),a(Ms),a(hs),a(R),a(us),a(js),a(v),a(rs),a(V),a(ys),a(X),a(Js),a(ds),a(A),a(ws),a(ms),a(F)),a(y),j(d,s),j(m,s),j(T,s),j(g,s),j(U,s),j(f,s),j(Z,s),j(k,s),j(G,s),j(E,s),j(N,s),j(Q,s),j(Y,s),j(H,s)}}}const Ss='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function qs(gs){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Xs{constructor(y){super(),Ys(this,y,qs,Fs,Qs,{})}}export{Ds as component};
