import{s as Rt,f as nt,n as Vt,o as Wt}from"../chunks/scheduler.37c15a92.js";import{S as Qt,i as St,g as o,s as n,r as d,A as zt,h as i,f as s,c as a,j as pe,u as M,x as r,k as u,y as Nt,a as l,v as y,d as f,t as T,w as h}from"../chunks/index.2bf4358c.js";import{C as at}from"../chunks/CodeBlock.4e987730.js";import{C as Xt}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as ie,E as Yt}from"../chunks/index.b8688d36.js";function Pt(ot){let w,ce,re,me,j,de,J,Me,b,it="Dans cette section, nous allons examiner de plus près la classe <code>Interface</code>, et comprendre les principaux paramètres utilisés pour en créer une.",ye,v,fe,U,rt="Vous remarquerez que la classe <code>Interface</code> a 3 paramètres obligatoires :",Te,I,ut="<code>Interface(fn, inputs, outputs, ...)</code>",he,C,pt="Ces paramètres sont :",we,g,ct="<li><code>fn</code>: la fonction de prédiction qui est enveloppée par l’interface <em>Gradio</em>. Cette fonction peut prendre un ou plusieurs paramètres et retourner une ou plusieurs valeurs.</li> <li><code>inputs</code>: le(s) type(s) de composant(s) d’entrée. <em>Gradio</em> fournit de nombreux composants préconstruits tels que<code>&quot;image&quot;</code> ou <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: le(s) type(s) de composant(s) de sortie. Encore une fois, <em>Gradio</em> fournit de nombreux composants pré-construits, par ex. <code>&quot;image&quot;</code> ou <code>&quot;label&quot;</code>.</li>",je,q,mt='Pour une liste complète des composants, <a href="https://gradio.app/docs" rel="nofollow">jetez un coup d’œil à la documentation de <em>Gradio</em></a>. Chaque composant préconstruit peut être personnalisé en instanciant la classe correspondant au composant.',Je,x,dt='Par exemple, comme nous l’avons vu dans la <a href="/course/fr/chapter9/2">section précédente</a>, au lieu de passer le paramètre <code>inputs</code> par <code>&quot;textbox&quot;</code>, vous pouvez passer un composant <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> pour créer une zone de texte avec 7 lignes et un label.',be,k,Mt="Voyons un autre exemple, cette fois avec un composant <code>Audio</code>.",ve,A,Ue,$,yt=`Comme mentionné précédemment, <em>Gradio</em> fournit de nombreuses entrées et sorties différentes.
Construisons donc une <code>Interface</code> qui fonctionne avec l’audio.`,Ie,G,ft="Dans cet exemple, nous allons construire une fonction audio-vers-audio qui prend un fichier audio et l’inverse simplement.",Ce,B,Tt="Nous utiliserons comme entrée le composant <code>Audio</code>. Lorsque vous utilisez le composant <code>Audio</code>, vous pouvez spécifier si vous voulez que la <code>source</code> de l’audio soit un fichier que l’utilisateur télécharge ou un microphone avec lequel l’utilisateur enregistre sa voix. Dans ce cas, nous allons choisir un microphone. Juste pour le plaisir, nous allons ajouter une étiquette à notre <code>Audio</code> qui dit « <em>Speak here…</em> » (Parler ici).",ge,E,ht="De plus, nous aimerions recevoir l’audio sous la forme d’un tableau numpy afin de pouvoir facilement l’inverser. Nous allons donc définir le <code>&quot;type&quot;</code> comme étant <code>&quot;numpy&quot;</code>, ce qui permet de passer les données d’entrée comme un <em>tuple</em> de (<code>sample_rate</code>, <code>data</code>) dans notre fonction.",qe,_,wt=`Nous utiliserons également le composant de sortie <code>Audio</code> qui peut automatiquement rendre un <em>tuple</em> avec un taux d’échantillonnage et un tableau numpy de données comme un fichier audio lisible.
Dans ce cas, nous n’avons pas besoin de faire de personnalisation, donc nous utiliserons le raccourci de la chaîne <code>&quot;audio&quot;</code>.`,xe,Z,ke,H,jt='Le code ci-dessus produira une interface comme celle qui suit (si votre navigateur ne vous demande pas l’autorisation pour accéder au microphone, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">ouvrez la démo dans un onglet séparé</a>).',Ae,p,Jt,$e,L,bt="Vous devriez maintenant être capable d’enregistrer votre voix et de vous entendre parler à l’envers. Effrayant 👻 !",Ge,R,Be,V,vt=`Imaginons que nous ayons une fonction plus compliquée, avec plusieurs entrées et sorties.
Dans l’exemple ci-dessous, nous avons une fonction qui prend un index de liste déroulante, une valeur de curseur et un nombre, et renvoie un échantillon audio d’une tonalité musicale.`,Ee,W,Ut="Regardez comment nous passons une liste de composants d’entrée et de sortie, et voyez si vous pouvez suivre ce qui se passe.",_e,Q,It="La clé ici est que lorsque vous passez :",Ze,S,Ct="<li>une liste de composants d’entrée, chaque composant correspond à un paramètre dans l’ordre.</li> <li>une liste de composants de sortie, chaque composant correspond à une valeur retournée.</li>",He,z,gt="L’extrait de code ci-dessous montre comment trois composants d’entrée correspondent aux trois arguments de la fonction <code>generate_tone()</code> :",Le,N,Re,c,qt,Ve,X,We,Y,xt="Jusqu’à présent, nous avons utilisé la méthode <code>launch()</code> pour lancer l’interface, mais nous n’avons pas vraiment discuté de ce qu’elle fait.",Qe,P,kt="Par défaut, la méthode <code>launch()</code> lancera la démo dans un serveur web qui tourne localement. Si vous exécutez votre code dans un <em>notebook</em> Jupyter ou Colab, <em>Gradio</em> va intégrer l’interface graphique de la démo dans le <em>notebook</em> afin que vous puissiez l’utiliser facilement.",Se,F,At="Vous pouvez personnaliser le comportement de <code>launch()</code> à travers différents paramètres :",ze,D,$t="<li><code>inline</code> : si vous voulez afficher l’interface en ligne sur les <em>notebooks</em> Python.</li> <li><code>inbrowser</code> : pour lancer automatiquement l’interface dans un nouvel onglet du navigateur par défaut.</li> <li><code>share</code> : si vous voulez créer un lien public partageable depuis votre ordinateur pour l’interface. Un peu comme un lien Google Drive !</li>",Ne,K,Gt="Nous couvrirons le paramètre <code>share</code> plus en détail dans la section suivante !",Xe,O,Ye,ee,Bt=`Construisons une interface qui vous permette de faire la démonstration d’un modèle de <strong>reconnaissance vocale</strong>.
Pour rendre la chose intéressante, nous accepterons <em>soit</em> une entrée micro, soit un fichier téléchargé.`,Pe,te,Et=`Comme d’habitude, nous allons charger notre modèle de reconnaissance vocale en utilisant la fonction <code>pipeline()</code> de 🤗 <em>Transformers</em>.
Si vous avez besoin d’un rafraîchissement rapide, vous pouvez revenir à <a href="/course/fr/chapter1/3">cette section du chapitre 1</a>. Ensuite, nous allons implémenter une fonction <code>transcribe_audio()</code> qui traite l’audio et retourne la transcription (en anglais). Enfin, nous allons envelopper cette fonction dans une <code>Interface</code> avec les composants <code>Audio</code> pour les entrées et juste le texte pour la sortie. Au total, le code de cette application est le suivant :`,Fe,se,De,le,_t='Si votre navigateur ne vous demande pas l’autorisation pour accéder au microphone, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">ouvrez la démo dans un onglet séparé</a>.',Ke,m,Zt,Oe,ne,Ht="Voilà, c’est fait ! Vous pouvez maintenant utiliser cette interface pour transcrire de l’audio. Remarquez ici qu’en passant le paramètre <code>optional</code> à <code>True</code>, nous permettons à l’utilisateur de soit fournir un microphone ou un fichier audio (ou aucun des deux, mais cela retournera un message d’erreur).",et,ae,Lt="Continuez pour voir comment partager votre interface avec d’autres !",tt,oe,st,ue,lt;return j=new ie({props:{title:"Comprendre la classe <i> Interface </i>",local:"comprendre-la-classe-i-interface-i",headingTag:"h1"}}),J=new Xt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter9/section3.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter9/section3.ipynb"}]}}),v=new ie({props:{title:"Comment créer une interface",local:"comment-créer-une-interface",headingTag:"h2"}}),A=new ie({props:{title:"Un exemple simple avec audio",local:"un-exemple-simple-avec-audio",headingTag:"h2"}}),Z=new at({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),R=new ie({props:{title:"Gérer les entrées et sorties multiples",local:"gérer-les-entrées-et-sorties-multiples",headingTag:"h2"}}),N=new at({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),X=new ie({props:{title:"La méthode launch()",local:"la-méthode-launch",headingTag:"h3"}}),O=new ie({props:{title:"✏️ Appliquons ça !",local:"-appliquons-ça-",headingTag:"h2"}}),se=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),oe=new Yt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter9/3.mdx"}}),{c(){w=o("meta"),ce=n(),re=o("p"),me=n(),d(j.$$.fragment),de=n(),d(J.$$.fragment),Me=n(),b=o("p"),b.innerHTML=it,ye=n(),d(v.$$.fragment),fe=n(),U=o("p"),U.innerHTML=rt,Te=n(),I=o("p"),I.innerHTML=ut,he=n(),C=o("p"),C.textContent=pt,we=n(),g=o("ul"),g.innerHTML=ct,je=n(),q=o("p"),q.innerHTML=mt,Je=n(),x=o("p"),x.innerHTML=dt,be=n(),k=o("p"),k.innerHTML=Mt,ve=n(),d(A.$$.fragment),Ue=n(),$=o("p"),$.innerHTML=yt,Ie=n(),G=o("p"),G.textContent=ft,Ce=n(),B=o("p"),B.innerHTML=Tt,ge=n(),E=o("p"),E.innerHTML=ht,qe=n(),_=o("p"),_.innerHTML=wt,xe=n(),d(Z.$$.fragment),ke=n(),H=o("p"),H.innerHTML=jt,Ae=n(),p=o("iframe"),$e=n(),L=o("p"),L.textContent=bt,Ge=n(),d(R.$$.fragment),Be=n(),V=o("p"),V.textContent=vt,Ee=n(),W=o("p"),W.textContent=Ut,_e=n(),Q=o("p"),Q.textContent=It,Ze=n(),S=o("ul"),S.innerHTML=Ct,He=n(),z=o("p"),z.innerHTML=gt,Le=n(),d(N.$$.fragment),Re=n(),c=o("iframe"),Ve=n(),d(X.$$.fragment),We=n(),Y=o("p"),Y.innerHTML=xt,Qe=n(),P=o("p"),P.innerHTML=kt,Se=n(),F=o("p"),F.innerHTML=At,ze=n(),D=o("ul"),D.innerHTML=$t,Ne=n(),K=o("p"),K.innerHTML=Gt,Xe=n(),d(O.$$.fragment),Ye=n(),ee=o("p"),ee.innerHTML=Bt,Pe=n(),te=o("p"),te.innerHTML=Et,Fe=n(),d(se.$$.fragment),De=n(),le=o("p"),le.innerHTML=_t,Ke=n(),m=o("iframe"),Oe=n(),ne=o("p"),ne.innerHTML=Ht,et=n(),ae=o("p"),ae.textContent=Lt,tt=n(),d(oe.$$.fragment),st=n(),ue=o("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),ce=a(e),re=i(e,"P",{}),pe(re).forEach(s),me=a(e),M(j.$$.fragment,e),de=a(e),M(J.$$.fragment,e),Me=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-pnhlej"&&(b.innerHTML=it),ye=a(e),M(v.$$.fragment,e),fe=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-i8pl6i"&&(U.innerHTML=rt),Te=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5xxju6"&&(I.innerHTML=ut),he=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1go2sl4"&&(C.textContent=pt),we=a(e),g=i(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-jfynuh"&&(g.innerHTML=ct),je=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-s6boen"&&(q.innerHTML=mt),Je=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-op7vtp"&&(x.innerHTML=dt),be=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1e28b11"&&(k.innerHTML=Mt),ve=a(e),M(A.$$.fragment,e),Ue=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1b5p006"&&($.innerHTML=yt),Ie=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-13jci01"&&(G.textContent=ft),Ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1r7h0mb"&&(B.innerHTML=Tt),ge=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ke7a4j"&&(E.innerHTML=ht),qe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-elipx6"&&(_.innerHTML=wt),xe=a(e),M(Z.$$.fragment,e),ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-bdrl7v"&&(H.innerHTML=jt),Ae=a(e),p=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(p).forEach(s),$e=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1pkferk"&&(L.textContent=bt),Ge=a(e),M(R.$$.fragment,e),Be=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-15yf0pp"&&(V.textContent=vt),Ee=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1qox5wf"&&(W.textContent=Ut),_e=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1buha6f"&&(Q.textContent=It),Ze=a(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1u77mhf"&&(S.innerHTML=Ct),He=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1y8qj54"&&(z.innerHTML=gt),Le=a(e),M(N.$$.fragment,e),Re=a(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(c).forEach(s),Ve=a(e),M(X.$$.fragment,e),We=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-8ys7zg"&&(Y.innerHTML=xt),Qe=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-h5bu5b"&&(P.innerHTML=kt),Se=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1n3rxi3"&&(F.innerHTML=At),ze=a(e),D=i(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-fqr9m7"&&(D.innerHTML=$t),Ne=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1egkbda"&&(K.innerHTML=Gt),Xe=a(e),M(O.$$.fragment,e),Ye=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-89td6r"&&(ee.innerHTML=Bt),Pe=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1x985e1"&&(te.innerHTML=Et),Fe=a(e),M(se.$$.fragment,e),De=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-14izswp"&&(le.innerHTML=_t),Ke=a(e),m=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(m).forEach(s),Oe=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1b6901k"&&(ne.innerHTML=Ht),et=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-rm725e"&&(ae.textContent=Lt),tt=a(e),M(oe.$$.fragment,e),st=a(e),ue=i(e,"P",{}),pe(ue).forEach(s),this.h()},h(){u(w,"name","hf:doc:metadata"),u(w,"content",Ft),nt(p.src,Jt="https://course-demos-audio-reverse.hf.space")||u(p,"src",Jt),u(p,"frameborder","0"),u(p,"height","250"),u(p,"title","Gradio app"),u(p,"class","container p-0 flex-grow space-iframe"),u(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),nt(c.src,qt="https://course-demos-generate-tone.hf.space")||u(c,"src",qt),u(c,"frameborder","0"),u(c,"height","450"),u(c,"title","Gradio app"),u(c,"class","container p-0 flex-grow space-iframe"),u(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),nt(m.src,Zt="https://course-demos-asr.hf.space")||u(m,"src",Zt),u(m,"frameborder","0"),u(m,"height","550"),u(m,"title","Gradio app"),u(m,"class","container p-0 flex-grow space-iframe"),u(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Nt(document.head,w),l(e,ce,t),l(e,re,t),l(e,me,t),y(j,e,t),l(e,de,t),y(J,e,t),l(e,Me,t),l(e,b,t),l(e,ye,t),y(v,e,t),l(e,fe,t),l(e,U,t),l(e,Te,t),l(e,I,t),l(e,he,t),l(e,C,t),l(e,we,t),l(e,g,t),l(e,je,t),l(e,q,t),l(e,Je,t),l(e,x,t),l(e,be,t),l(e,k,t),l(e,ve,t),y(A,e,t),l(e,Ue,t),l(e,$,t),l(e,Ie,t),l(e,G,t),l(e,Ce,t),l(e,B,t),l(e,ge,t),l(e,E,t),l(e,qe,t),l(e,_,t),l(e,xe,t),y(Z,e,t),l(e,ke,t),l(e,H,t),l(e,Ae,t),l(e,p,t),l(e,$e,t),l(e,L,t),l(e,Ge,t),y(R,e,t),l(e,Be,t),l(e,V,t),l(e,Ee,t),l(e,W,t),l(e,_e,t),l(e,Q,t),l(e,Ze,t),l(e,S,t),l(e,He,t),l(e,z,t),l(e,Le,t),y(N,e,t),l(e,Re,t),l(e,c,t),l(e,Ve,t),y(X,e,t),l(e,We,t),l(e,Y,t),l(e,Qe,t),l(e,P,t),l(e,Se,t),l(e,F,t),l(e,ze,t),l(e,D,t),l(e,Ne,t),l(e,K,t),l(e,Xe,t),y(O,e,t),l(e,Ye,t),l(e,ee,t),l(e,Pe,t),l(e,te,t),l(e,Fe,t),y(se,e,t),l(e,De,t),l(e,le,t),l(e,Ke,t),l(e,m,t),l(e,Oe,t),l(e,ne,t),l(e,et,t),l(e,ae,t),l(e,tt,t),y(oe,e,t),l(e,st,t),l(e,ue,t),lt=!0},p:Vt,i(e){lt||(f(j.$$.fragment,e),f(J.$$.fragment,e),f(v.$$.fragment,e),f(A.$$.fragment,e),f(Z.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(X.$$.fragment,e),f(O.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),lt=!0)},o(e){T(j.$$.fragment,e),T(J.$$.fragment,e),T(v.$$.fragment,e),T(A.$$.fragment,e),T(Z.$$.fragment,e),T(R.$$.fragment,e),T(N.$$.fragment,e),T(X.$$.fragment,e),T(O.$$.fragment,e),T(se.$$.fragment,e),T(oe.$$.fragment,e),lt=!1},d(e){e&&(s(ce),s(re),s(me),s(de),s(Me),s(b),s(ye),s(fe),s(U),s(Te),s(I),s(he),s(C),s(we),s(g),s(je),s(q),s(Je),s(x),s(be),s(k),s(ve),s(Ue),s($),s(Ie),s(G),s(Ce),s(B),s(ge),s(E),s(qe),s(_),s(xe),s(ke),s(H),s(Ae),s(p),s($e),s(L),s(Ge),s(Be),s(V),s(Ee),s(W),s(_e),s(Q),s(Ze),s(S),s(He),s(z),s(Le),s(Re),s(c),s(Ve),s(We),s(Y),s(Qe),s(P),s(Se),s(F),s(ze),s(D),s(Ne),s(K),s(Xe),s(Ye),s(ee),s(Pe),s(te),s(Fe),s(De),s(le),s(Ke),s(m),s(Oe),s(ne),s(et),s(ae),s(tt),s(st),s(ue)),s(w),h(j,e),h(J,e),h(v,e),h(A,e),h(Z,e),h(R,e),h(N,e),h(X,e),h(O,e),h(se,e),h(oe,e)}}}const Ft='{"title":"Comprendre la classe <i> Interface </i>","local":"comprendre-la-classe-i-interface-i","sections":[{"title":"Comment créer une interface","local":"comment-créer-une-interface","sections":[],"depth":2},{"title":"Un exemple simple avec audio","local":"un-exemple-simple-avec-audio","sections":[],"depth":2},{"title":"Gérer les entrées et sorties multiples","local":"gérer-les-entrées-et-sorties-multiples","sections":[{"title":"La méthode launch()","local":"la-méthode-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Appliquons ça !","local":"-appliquons-ça-","sections":[],"depth":2}],"depth":1}';function Dt(ot){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Qt{constructor(w){super(),St(this,w,Dt,Pt,Rt,{})}}export{ls as component};
