import{s as Se,o as We,n as Ce}from"../chunks/scheduler.25b97de1.js";import{S as Be,i as Ne,g as m,s as l,r as _,A as Ze,h,f as s,c,j as le,u as b,x as $,k as ce,y as f,a as d,v as y,d as M,t as T,w}from"../chunks/index.d9030fc9.js";import{T as Je}from"../chunks/Tip.baa67368.js";import{D as Te}from"../chunks/Docstring.ffac8efa.js";import{C as Ie}from"../chunks/CodeBlock.e6cd0d95.js";import{F as Ee,M as Re}from"../chunks/Markdown.7217f838.js";import{E as Ge}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ge,E as Ae}from"../chunks/EditOnGithub.91d95064.js";function Ve(P){let o,u="Phi-3.5-MoE-instruct has been integrated in the development version (4.44.2.dev) of <code>transformers</code>. Until the official version is released through <code>pip</code>, ensure that you are doing the following:",t,r,v="<li>When loading the model, ensure that <code>trust_remote_code=True</code> is passed as an argument of the <code>from_pretrained()</code> function.</li>",a,k,Y="The current <code>transformers</code> version can be verified with: <code>pip list | grep transformers</code>.",j,N,K="Examples of required packages:",C,x,F;return x=new Ie({props:{code:"Zmxhc2hfYXR0biUzRCUzRDIuNS44JTBBdG9yY2glM0QlM0QyLjMuMSUwQWFjY2VsZXJhdGUlM0QlM0QwLjMxLjAlMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQzLjA=",highlighted:`<span class="hljs-attribute">flash_attn</span>==<span class="hljs-number">2</span>.<span class="hljs-number">5</span>.<span class="hljs-number">8</span>
<span class="hljs-attribute">torch</span>==<span class="hljs-number">2</span>.<span class="hljs-number">3</span>.<span class="hljs-number">1</span>
<span class="hljs-attribute">accelerate</span>==<span class="hljs-number">0</span>.<span class="hljs-number">31</span>.<span class="hljs-number">0</span>
<span class="hljs-attribute">transformers</span>==<span class="hljs-number">4</span>.<span class="hljs-number">43</span>.<span class="hljs-number">0</span>`,wrap:!1}}),{c(){o=m("p"),o.innerHTML=u,t=l(),r=m("ul"),r.innerHTML=v,a=l(),k=m("p"),k.innerHTML=Y,j=l(),N=m("p"),N.textContent=K,C=l(),_(x.$$.fragment)},l(p){o=h(p,"P",{"data-svelte-h":!0}),$(o)!=="svelte-16ml7y6"&&(o.innerHTML=u),t=c(p),r=h(p,"UL",{"data-svelte-h":!0}),$(r)!=="svelte-b3j7h0"&&(r.innerHTML=v),a=c(p),k=h(p,"P",{"data-svelte-h":!0}),$(k)!=="svelte-pmzjti"&&(k.innerHTML=Y),j=c(p),N=h(p,"P",{"data-svelte-h":!0}),$(N)!=="svelte-1njcx0o"&&(N.textContent=K),C=c(p),b(x.$$.fragment,p)},m(p,I){d(p,o,I),d(p,t,I),d(p,r,I),d(p,a,I),d(p,k,I),d(p,j,I),d(p,N,I),d(p,C,I),y(x,p,I),F=!0},p:Ce,i(p){F||(M(x.$$.fragment,p),F=!0)},o(p){T(x.$$.fragment,p),F=!1},d(p){p&&(s(o),s(t),s(r),s(a),s(k),s(j),s(N),s(C)),w(x,p)}}}function He(P){let o,u="Example:",t,r,v;return r=new Ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaW1vZU1vZGVsJTJDJTIwUGhpbW9lQ29uZmlnJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBoaS0zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBoaW1vZUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMuNS1Nb0UtaW5zdHJ1Y3QlMjIpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFBoaW1vZU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhimoeModel, PhimoeConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Phi-3 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PhimoeConfig.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=u,t=l(),_(r.$$.fragment)},l(a){o=h(a,"P",{"data-svelte-h":!0}),$(o)!=="svelte-11lpom8"&&(o.textContent=u),t=c(a),b(r.$$.fragment,a)},m(a,k){d(a,o,k),d(a,t,k),y(r,a,k),v=!0},p:Ce,i(a){v||(M(r.$$.fragment,a),v=!0)},o(a){T(r.$$.fragment,a),v=!1},d(a){a&&(s(o),s(t)),w(r,a)}}}function Oe(P){let o,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=u},l(t){o=h(t,"P",{"data-svelte-h":!0}),$(o)!=="svelte-fincs2"&&(o.innerHTML=u)},m(t,r){d(t,o,r)},p:Ce,d(t){t&&s(o)}}}function Qe(P){let o,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=u},l(t){o=h(t,"P",{"data-svelte-h":!0}),$(o)!=="svelte-fincs2"&&(o.innerHTML=u)},m(t,r){d(t,o,r)},p:Ce,d(t){t&&s(o)}}}function Xe(P){let o,u="Example:",t,r,v;return r=new Ie({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGltb2VGb3JDYXVzYWxMTSUwQW1vZGVsJTIwJTNEJTIwUGhpbW9lRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhimoeForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=u,t=l(),_(r.$$.fragment)},l(a){o=h(a,"P",{"data-svelte-h":!0}),$(o)!=="svelte-11lpom8"&&(o.textContent=u),t=c(a),b(r.$$.fragment,a)},m(a,k){d(a,o,k),d(a,t,k),y(r,a,k),v=!0},p:Ce,i(a){v||(M(r.$$.fragment,a),v=!0)},o(a){T(r.$$.fragment,a),v=!1},d(a){a&&(s(o),s(t)),w(r,a)}}}function De(P){let o,u=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,t,r,v=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){o=m("p"),o.innerHTML=u,t=l(),r=m("p"),r.innerHTML=v},l(a){o=h(a,"P",{"data-svelte-h":!0}),$(o)!=="svelte-1c5u34l"&&(o.innerHTML=u),t=c(a),r=h(a,"P",{"data-svelte-h":!0}),$(r)!=="svelte-fvlq1g"&&(r.innerHTML=v)},m(a,k){d(a,o,k),d(a,t,k),d(a,r,k)},p:Ce,d(a){a&&(s(o),s(t),s(r))}}}function Ye(P){let o,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=u},l(t){o=h(t,"P",{"data-svelte-h":!0}),$(o)!=="svelte-fincs2"&&(o.innerHTML=u)},m(t,r){d(t,o,r)},p:Ce,d(t){t&&s(o)}}}function Ke(P){let o,u,t,r,v,a,k=`The bare Phimoe Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)
This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Y,j,N="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>PhimoeDecoderLayer</code>",K,C,x,F,p,I='The <a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a> forward method, overrides the <code>__call__</code> special method.',ee,oe,pe,q,we,L,G,_e,U,ie,be,B,ve='The <a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeForCausalLM">PhimoeForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',H,Z,te,E,ne,S,J,se,de,me="Generates sequences of token ids for models with a language modeling head.",Pe,O,R,Q,A,z,W,ye,X,ke=`The Phimoe Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeForSequenceClassification">PhimoeForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.
Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,e,i,D=`This model inherits from <a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)
This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xe,V,$e,Fe,Ue,qe='The <a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeForSequenceClassification">PhimoeForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Le,Me,ze;return o=new ge({props:{title:"PhimoeModel",local:"transformers.PhimoeModel",headingTag:"h2"}}),r=new Te({props:{name:"class transformers.PhimoeModel",anchor:"transformers.PhimoeModel",parameters:[{name:"config",val:": PhimoeConfig"}],parametersDescription:[{anchor:"transformers.PhimoeModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeConfig">PhimoeConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PhimoeModel.config",description:"<strong>config</strong> &#x2014; PhimoeConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1003"}}),x=new Te({props:{name:"forward",anchor:"transformers.PhimoeModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.PhimoeModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhimoeModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhimoeModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.PhimoeModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhimoeModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1037"}}),oe=new Je({props:{$$slots:{default:[Oe]},$$scope:{ctx:P}}}),q=new ge({props:{title:"PhimoeForCausalLM",local:"transformers.PhimoeForCausalLM",headingTag:"h2"}}),G=new Te({props:{name:"class transformers.PhimoeForCausalLM",anchor:"transformers.PhimoeForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1324"}}),ie=new Te({props:{name:"forward",anchor:"transformers.PhimoeForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"num_logits_to_keep",val:": int = 0"},{name:"**loss_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhimoeForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhimoeForCausalLM.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.PhimoeForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhimoeForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PhimoeForCausalLM.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1362",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeConfig"
>PhimoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>aux_loss</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, returned when <code>labels</code> is provided) — aux_loss for the sparse modules.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new Je({props:{$$slots:{default:[Qe]},$$scope:{ctx:P}}}),E=new Ge({props:{anchor:"transformers.PhimoeForCausalLM.forward.example",$$slots:{default:[Xe]},$$scope:{ctx:P}}}),J=new Te({props:{name:"generate",anchor:"transformers.PhimoeForCausalLM.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Optional[typing.Callable[[int, torch.Tensor], typing.List[int]]] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForCausalLM.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.PhimoeForCausalLM.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.PhimoeForCausalLM.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.PhimoeForCausalLM.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.PhimoeForCausalLM.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.PhimoeForCausalLM.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.PhimoeForCausalLM.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.PhimoeForCausalLM.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.PhimoeForCausalLM.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.PhimoeForCausalLM.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.PhimoeForCausalLM.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/generation/utils.py#L1905",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),O=new Je({props:{warning:!0,$$slots:{default:[De]},$$scope:{ctx:P}}}),Q=new ge({props:{title:"PhimoeForSequenceClassification",local:"transformers.PhimoeForSequenceClassification",headingTag:"h2"}}),W=new Te({props:{name:"class transformers.PhimoeForSequenceClassification",anchor:"transformers.PhimoeForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeConfig">PhimoeConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1516"}}),$e=new Te({props:{name:"forward",anchor:"transformers.PhimoeForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PhimoeForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhimoeForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhimoeForSequenceClassification.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.PhimoeForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhimoeForSequenceClassification.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PhimoeForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/modeling_phimoe.py#L1547"}}),Me=new Je({props:{$$slots:{default:[Ye]},$$scope:{ctx:P}}}),{c(){_(o.$$.fragment),u=l(),t=m("div"),_(r.$$.fragment),v=l(),a=m("p"),a.innerHTML=k,Y=l(),j=m("p"),j.innerHTML=N,K=l(),C=m("div"),_(x.$$.fragment),F=l(),p=m("p"),p.innerHTML=I,ee=l(),_(oe.$$.fragment),pe=l(),_(q.$$.fragment),we=l(),L=m("div"),_(G.$$.fragment),_e=l(),U=m("div"),_(ie.$$.fragment),be=l(),B=m("p"),B.innerHTML=ve,H=l(),_(Z.$$.fragment),te=l(),_(E.$$.fragment),ne=l(),S=m("div"),_(J.$$.fragment),se=l(),de=m("p"),de.textContent=me,Pe=l(),_(O.$$.fragment),R=l(),_(Q.$$.fragment),A=l(),z=m("div"),_(W.$$.fragment),ye=l(),X=m("p"),X.innerHTML=ke,e=l(),i=m("p"),i.innerHTML=D,xe=l(),V=m("div"),_($e.$$.fragment),Fe=l(),Ue=m("p"),Ue.innerHTML=qe,Le=l(),_(Me.$$.fragment),this.h()},l(n){b(o.$$.fragment,n),u=c(n),t=h(n,"DIV",{class:!0});var g=le(t);b(r.$$.fragment,g),v=c(g),a=h(g,"P",{"data-svelte-h":!0}),$(a)!=="svelte-1tgiujq"&&(a.innerHTML=k),Y=c(g),j=h(g,"P",{"data-svelte-h":!0}),$(j)!=="svelte-omwne1"&&(j.innerHTML=N),K=c(g),C=h(g,"DIV",{class:!0});var he=le(C);b(x.$$.fragment,he),F=c(he),p=h(he,"P",{"data-svelte-h":!0}),$(p)!=="svelte-18ydfzq"&&(p.innerHTML=I),ee=c(he),b(oe.$$.fragment,he),he.forEach(s),g.forEach(s),pe=c(n),b(q.$$.fragment,n),we=c(n),L=h(n,"DIV",{class:!0});var ue=le(L);b(G.$$.fragment,ue),_e=c(ue),U=h(ue,"DIV",{class:!0});var ae=le(U);b(ie.$$.fragment,ae),be=c(ae),B=h(ae,"P",{"data-svelte-h":!0}),$(B)!=="svelte-j2weje"&&(B.innerHTML=ve),H=c(ae),b(Z.$$.fragment,ae),te=c(ae),b(E.$$.fragment,ae),ae.forEach(s),ne=c(ue),S=h(ue,"DIV",{class:!0});var fe=le(S);b(J.$$.fragment,fe),se=c(fe),de=h(fe,"P",{"data-svelte-h":!0}),$(de)!=="svelte-s5ko3x"&&(de.textContent=me),Pe=c(fe),b(O.$$.fragment,fe),fe.forEach(s),ue.forEach(s),R=c(n),b(Q.$$.fragment,n),A=c(n),z=h(n,"DIV",{class:!0});var re=le(z);b(W.$$.fragment,re),ye=c(re),X=h(re,"P",{"data-svelte-h":!0}),$(X)!=="svelte-fdv3r1"&&(X.innerHTML=ke),e=c(re),i=h(re,"P",{"data-svelte-h":!0}),$(i)!=="svelte-1i9dsra"&&(i.innerHTML=D),xe=c(re),V=h(re,"DIV",{class:!0});var je=le(V);b($e.$$.fragment,je),Fe=c(je),Ue=h(je,"P",{"data-svelte-h":!0}),$(Ue)!=="svelte-1264rre"&&(Ue.innerHTML=qe),Le=c(je),b(Me.$$.fragment,je),je.forEach(s),re.forEach(s),this.h()},h(){ce(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(n,g){y(o,n,g),d(n,u,g),d(n,t,g),y(r,t,null),f(t,v),f(t,a),f(t,Y),f(t,j),f(t,K),f(t,C),y(x,C,null),f(C,F),f(C,p),f(C,ee),y(oe,C,null),d(n,pe,g),y(q,n,g),d(n,we,g),d(n,L,g),y(G,L,null),f(L,_e),f(L,U),y(ie,U,null),f(U,be),f(U,B),f(U,H),y(Z,U,null),f(U,te),y(E,U,null),f(L,ne),f(L,S),y(J,S,null),f(S,se),f(S,de),f(S,Pe),y(O,S,null),d(n,R,g),y(Q,n,g),d(n,A,g),d(n,z,g),y(W,z,null),f(z,ye),f(z,X),f(z,e),f(z,i),f(z,xe),f(z,V),y($e,V,null),f(V,Fe),f(V,Ue),f(V,Le),y(Me,V,null),ze=!0},p(n,g){const he={};g&2&&(he.$$scope={dirty:g,ctx:n}),oe.$set(he);const ue={};g&2&&(ue.$$scope={dirty:g,ctx:n}),Z.$set(ue);const ae={};g&2&&(ae.$$scope={dirty:g,ctx:n}),E.$set(ae);const fe={};g&2&&(fe.$$scope={dirty:g,ctx:n}),O.$set(fe);const re={};g&2&&(re.$$scope={dirty:g,ctx:n}),Me.$set(re)},i(n){ze||(M(o.$$.fragment,n),M(r.$$.fragment,n),M(x.$$.fragment,n),M(oe.$$.fragment,n),M(q.$$.fragment,n),M(G.$$.fragment,n),M(ie.$$.fragment,n),M(Z.$$.fragment,n),M(E.$$.fragment,n),M(J.$$.fragment,n),M(O.$$.fragment,n),M(Q.$$.fragment,n),M(W.$$.fragment,n),M($e.$$.fragment,n),M(Me.$$.fragment,n),ze=!0)},o(n){T(o.$$.fragment,n),T(r.$$.fragment,n),T(x.$$.fragment,n),T(oe.$$.fragment,n),T(q.$$.fragment,n),T(G.$$.fragment,n),T(ie.$$.fragment,n),T(Z.$$.fragment,n),T(E.$$.fragment,n),T(J.$$.fragment,n),T(O.$$.fragment,n),T(Q.$$.fragment,n),T(W.$$.fragment,n),T($e.$$.fragment,n),T(Me.$$.fragment,n),ze=!1},d(n){n&&(s(u),s(t),s(pe),s(we),s(L),s(R),s(A),s(z)),w(o,n),w(r),w(x),w(oe),w(q,n),w(G),w(ie),w(Z),w(E),w(J),w(O),w(Q,n),w(W),w($e),w(Me)}}}function eo(P){let o,u;return o=new Re({props:{$$slots:{default:[Ke]},$$scope:{ctx:P}}}),{c(){_(o.$$.fragment)},l(t){b(o.$$.fragment,t)},m(t,r){y(o,t,r),u=!0},p(t,r){const v={};r&2&&(v.$$scope={dirty:r,ctx:t}),o.$set(v)},i(t){u||(M(o.$$.fragment,t),u=!0)},o(t){T(o.$$.fragment,t),u=!1},d(t){w(o,t)}}}function oo(P){let o,u,t,r,v,a,k,Y,j,N='The PhiMoE model was proposed in <a href="https://arxiv.org/abs/2404.14219" rel="nofollow">Phi-3 Technical Report: A Highly Capable Language Model Locally on Your Phone</a> by Microsoft.',K,C,x,F,p="The abstract from the Phi-3 paper is the following:",I,ee,oe="We introduce phi-3-mini, a 3.8 billion parameter language model trained on 3.3 trillion tokens, whose overall performance, as measured by both academic benchmarks and internal testing, rivals that of models such as Mixtral 8x7B and GPT-3.5 (e.g., phi-3-mini achieves 69% on MMLU and 8.38 on MT-bench), despite being small enough to be deployed on a phone. Our training dataset is a scaled-up version of the one used for phi-2, composed of heavily filtered publicly available web data and synthetic data. The model is also further aligned for robustness, safety, and chat format. We also provide parameter-scaling results with a 7B, 14B models trained for 4.8T tokens, called phi-3-small, phi-3-medium, both significantly more capable than phi-3-mini (e.g., respectively 75%, 78% on MMLU, and 8.7, 8.9 on MT-bench). To enhance multilingual, multimodal, and long-context capabilities, we introduce three models in the phi-3.5 series: phi-3.5-mini, phi-3.5-MoE, and phi-3.5-Vision. The phi-3.5-MoE, a 16 x 3.8B MoE model with 6.6 billion active parameters, achieves superior performance in language reasoning, math, and code tasks compared to other open-source models of similar scale, such as Llama 3.1 and the Mixtral series, and on par with Gemini-1.5-Flash and GPT-4o-mini. Meanwhile, phi-3.5-Vision, a 4.2 billion parameter model derived from phi-3.5-mini, excels in reasoning tasks and is adept at handling both single-image and text prompts, as well as multi-image and text prompts.",pe,q,we='The original code for PhiMoE can be found <a href="https://huggingface.co/microsoft/Phi-3.5-MoE-instruct" rel="nofollow">here</a>.',L,G,_e,U,ie='<li>This model is very similar to <code>Mixtral</code> with the main difference of <code>Phi3LongRoPEScaledRotaryEmbedding</code>, where they are used to extend the context of the rotary embeddings. The query, key and values are fused, and the MLP’s up and gate projection layers are also fused.</li> <li>The tokenizer used for this model is identical to the <a href="/docs/transformers/pr_29886/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a>, with the exception of additional tokens.</li>',be,B,ve,H,Z,te,E,ne,S,J,se,de,me,Pe=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a>. It is used to instantiate a Phi-moe
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/microsoft/Phi-3.5-MoE-instruct" rel="nofollow">microsoft/Phi-3.5-MoE-instruct</a>.
Configuration objects inherit from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,O,R,Q,A,z,W,ye,X,ke;return v=new ge({props:{title:"PhiMoE",local:"phimoe",headingTag:"h1"}}),k=new ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new ge({props:{title:"Summary",local:"summary",headingTag:"h3"}}),G=new ge({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),B=new ge({props:{title:"How to use PhiMoE",local:"how-to-use-phimoe",headingTag:"h2"}}),H=new Je({props:{warning:!0,$$slots:{default:[Ve]},$$scope:{ctx:P}}}),te=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline 

torch.random.manual_seed(<span class="hljs-number">0</span>) 

model = AutoModelForCausalLM.from_pretrained( 
    <span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>,  
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>,  
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,  
    trust_remote_code=<span class="hljs-literal">True</span>,  
) 

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>) 

messages = [ 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful AI assistant.&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you provide ways to eat combinations of bananas and dragonfruits?&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Sure! Here are some ways to eat bananas and dragonfruits together: 1. Banana and dragonfruit smoothie: Blend bananas and dragonfruits together with some milk and honey. 2. Banana and dragonfruit salad: Mix sliced bananas and dragonfruits together with some lemon juice and honey.&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What about solving an 2x + 3 = 7 equation?&quot;</span>}, 
] 

pipe = pipeline( 
    <span class="hljs-string">&quot;text-generation&quot;</span>, 
    model=model, 
    tokenizer=tokenizer, 
) 

generation_args = { 
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">500</span>, 
    <span class="hljs-string">&quot;return_full_text&quot;</span>: <span class="hljs-literal">False</span>, 
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.0</span>, 
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">False</span>, 
} 

output = pipe(messages, **generation_args) 
<span class="hljs-built_in">print</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>])`,wrap:!1}}),ne=new ge({props:{title:"PhimoeConfig",local:"transformers.PhimoeConfig",headingTag:"h2"}}),se=new Te({props:{name:"class transformers.PhimoeConfig",anchor:"transformers.PhimoeConfig",parameters:[{name:"vocab_size",val:" = 32064"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 6400"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 8"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 131072"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 1000000.0"},{name:"rope_scaling",val:" = None"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"num_experts_per_tok",val:" = 2"},{name:"num_local_experts",val:" = 16"},{name:"output_router_logits",val:" = False"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"router_jitter_noise",val:" = 0.01"},{name:"input_jitter_noise",val:" = 0.0"},{name:"attention_bias",val:" = False"},{name:"lm_head_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32064) &#x2014;
Vocabulary size of the Phimoe model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_29886/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a>`,name:"vocab_size"},{anchor:"transformers.PhimoeConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PhimoeConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6400) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PhimoeConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.PhimoeConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PhimoeConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>8</code>.`,name:"num_key_value_heads"},{anchor:"transformers.PhimoeConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PhimoeConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4096*32</code>) &#x2014;
The maximum sequence length that this model might ever be used with. Mixtral&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.PhimoeConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PhimoeConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.PhimoeConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.PhimoeConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.PhimoeConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.PhimoeConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.PhimoeConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.PhimoeConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PhimoeConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The scaling strategy for the RoPE embeddings. If <code>None</code>, no scaling is applied. If a dictionary, it must
contain the following keys: <code>type</code>, <code>short_factor</code>, <code>long_factor</code>, <code>short_mscale</code>, <code>long_mscale</code> and
<code>original_max_position_embeddings</code>. The <code>type</code> must be <code>longrope</code>, the <code>short_mscale</code> and <code>long_scale</code> must
be numbers, the <code>short_factor</code> and <code>long_factor</code> must be lists of numbers with the same length as half of
the attention head size and the <code>original_max_position_embeddings</code> must be an integer.`,name:"rope_scaling"},{anchor:"transformers.PhimoeConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>262144</code>.`,name:"sliding_window"},{anchor:"transformers.PhimoeConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PhimoeConfig.num_experts_per_tok",description:`<strong>num_experts_per_tok</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of experts to root per-token, can be also interpreted as the <code>top-p</code> routing
parameter`,name:"num_experts_per_tok"},{anchor:"transformers.PhimoeConfig.num_local_experts",description:`<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of experts per Sparse MLP layer.`,name:"num_local_experts"},{anchor:"transformers.PhimoeConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the router logits should be returned by the model. Enabeling this will also
allow the model to output the auxiliary loss. See <a href>here</a> for more details`,name:"output_router_logits"},{anchor:"transformers.PhimoeConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.PhimoeConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"},{anchor:"transformers.PhimoeConfig.input_jitter_noise",description:"<strong>input_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014; Input jitter noise",name:"input_jitter_noise"},{anchor:"transformers.PhimoeConfig.attention_bias",description:"<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Attention bias",name:"attention_bias"},{anchor:"transformers.PhimoeConfig.lm_head_bias",description:"<strong>lm_head_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; LM head bias",name:"lm_head_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/phimoe/configuration_phimoe.py#L26"}}),R=new Ge({props:{anchor:"transformers.PhimoeConfig.example",$$slots:{default:[He]},$$scope:{ctx:P}}}),A=new Ee({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[eo]},$$scope:{ctx:P}}}),W=new Ae({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/phimoe.md"}}),{c(){o=m("meta"),u=l(),t=m("p"),r=l(),_(v.$$.fragment),a=l(),_(k.$$.fragment),Y=l(),j=m("p"),j.innerHTML=N,K=l(),_(C.$$.fragment),x=l(),F=m("p"),F.textContent=p,I=l(),ee=m("p"),ee.textContent=oe,pe=l(),q=m("p"),q.innerHTML=we,L=l(),_(G.$$.fragment),_e=l(),U=m("ul"),U.innerHTML=ie,be=l(),_(B.$$.fragment),ve=l(),_(H.$$.fragment),Z=l(),_(te.$$.fragment),E=l(),_(ne.$$.fragment),S=l(),J=m("div"),_(se.$$.fragment),de=l(),me=m("p"),me.innerHTML=Pe,O=l(),_(R.$$.fragment),Q=l(),_(A.$$.fragment),z=l(),_(W.$$.fragment),ye=l(),X=m("p"),this.h()},l(e){const i=Ze("svelte-u9bgzb",document.head);o=h(i,"META",{name:!0,content:!0}),i.forEach(s),u=c(e),t=h(e,"P",{}),le(t).forEach(s),r=c(e),b(v.$$.fragment,e),a=c(e),b(k.$$.fragment,e),Y=c(e),j=h(e,"P",{"data-svelte-h":!0}),$(j)!=="svelte-w1paw9"&&(j.innerHTML=N),K=c(e),b(C.$$.fragment,e),x=c(e),F=h(e,"P",{"data-svelte-h":!0}),$(F)!=="svelte-1iah8ch"&&(F.textContent=p),I=c(e),ee=h(e,"P",{"data-svelte-h":!0}),$(ee)!=="svelte-dp2ft6"&&(ee.textContent=oe),pe=c(e),q=h(e,"P",{"data-svelte-h":!0}),$(q)!=="svelte-weehy4"&&(q.innerHTML=we),L=c(e),b(G.$$.fragment,e),_e=c(e),U=h(e,"UL",{"data-svelte-h":!0}),$(U)!=="svelte-1wagp5y"&&(U.innerHTML=ie),be=c(e),b(B.$$.fragment,e),ve=c(e),b(H.$$.fragment,e),Z=c(e),b(te.$$.fragment,e),E=c(e),b(ne.$$.fragment,e),S=c(e),J=h(e,"DIV",{class:!0});var D=le(J);b(se.$$.fragment,D),de=c(D),me=h(D,"P",{"data-svelte-h":!0}),$(me)!=="svelte-1bmvij5"&&(me.innerHTML=Pe),O=c(D),b(R.$$.fragment,D),D.forEach(s),Q=c(e),b(A.$$.fragment,e),z=c(e),b(W.$$.fragment,e),ye=c(e),X=h(e,"P",{}),le(X).forEach(s),this.h()},h(){ce(o,"name","hf:doc:metadata"),ce(o,"content",to),ce(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){f(document.head,o),d(e,u,i),d(e,t,i),d(e,r,i),y(v,e,i),d(e,a,i),y(k,e,i),d(e,Y,i),d(e,j,i),d(e,K,i),y(C,e,i),d(e,x,i),d(e,F,i),d(e,I,i),d(e,ee,i),d(e,pe,i),d(e,q,i),d(e,L,i),y(G,e,i),d(e,_e,i),d(e,U,i),d(e,be,i),y(B,e,i),d(e,ve,i),y(H,e,i),d(e,Z,i),y(te,e,i),d(e,E,i),y(ne,e,i),d(e,S,i),d(e,J,i),y(se,J,null),f(J,de),f(J,me),f(J,O),y(R,J,null),d(e,Q,i),y(A,e,i),d(e,z,i),y(W,e,i),d(e,ye,i),d(e,X,i),ke=!0},p(e,[i]){const D={};i&2&&(D.$$scope={dirty:i,ctx:e}),H.$set(D);const xe={};i&2&&(xe.$$scope={dirty:i,ctx:e}),R.$set(xe);const V={};i&2&&(V.$$scope={dirty:i,ctx:e}),A.$set(V)},i(e){ke||(M(v.$$.fragment,e),M(k.$$.fragment,e),M(C.$$.fragment,e),M(G.$$.fragment,e),M(B.$$.fragment,e),M(H.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(R.$$.fragment,e),M(A.$$.fragment,e),M(W.$$.fragment,e),ke=!0)},o(e){T(v.$$.fragment,e),T(k.$$.fragment,e),T(C.$$.fragment,e),T(G.$$.fragment,e),T(B.$$.fragment,e),T(H.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),T(se.$$.fragment,e),T(R.$$.fragment,e),T(A.$$.fragment,e),T(W.$$.fragment,e),ke=!1},d(e){e&&(s(u),s(t),s(r),s(a),s(Y),s(j),s(K),s(x),s(F),s(I),s(ee),s(pe),s(q),s(L),s(_e),s(U),s(be),s(ve),s(Z),s(E),s(S),s(J),s(Q),s(z),s(ye),s(X)),s(o),w(v,e),w(k,e),w(C,e),w(G,e),w(B,e),w(H,e),w(te,e),w(ne,e),w(se),w(R),w(A,e),w(W,e)}}}const to='{"title":"PhiMoE","local":"phimoe","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"How to use PhiMoE","local":"how-to-use-phimoe","sections":[],"depth":2},{"title":"PhimoeConfig","local":"transformers.PhimoeConfig","sections":[],"depth":2},{"title":"PhimoeModel","local":"transformers.PhimoeModel","sections":[],"depth":2},{"title":"PhimoeForCausalLM","local":"transformers.PhimoeForCausalLM","sections":[],"depth":2},{"title":"PhimoeForSequenceClassification","local":"transformers.PhimoeForSequenceClassification","sections":[],"depth":2}],"depth":1}';function no(P){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ho extends Be{constructor(o){super(),Ne(this,o,no,oo,Se,{})}}export{ho as component};
