import{s as ma,n as ra,o as ca}from"../chunks/scheduler.7da89386.js";import{S as ua,i as ya,g as i,s as e,r as C,A as Ma,h as p,f as n,c as l,j as ia,u as Z,x as m,k as pa,y as da,a as s,v as R,d as B,t as I,w as v}from"../chunks/index.0b7befd3.js";import{C as oa}from"../chunks/CodeBlock.ce33a881.js";import{H as O}from"../chunks/Heading.8a936589.js";function ha(P){let o,G,w,W,r,_,c,L='Ryzen AI IPU best performances are achieved using <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">quantized models</a>. There are two different ways to quantize models for Ryzen AI IPU:',X,u,D='<li>through <a href="https://ryzenai.docs.amd.com/en/latest/vai_quant/vai_q_onnx.html" rel="nofollow">Vitis AI Quantizer</a>, used in Optimum’s <a href="/docs/optimum.amd/pr_149/en/ryzenai/package_reference/quantization#optimum.amd.ryzenai.RyzenAIOnnxQuantizer">RyzenAIOnnxQuantizer</a>, which is designed for ONNX model quantization. Currently supports quantising <a href="https://github.com/huggingface/pytorch-image-models" rel="nofollow">timm</a> models using dynamic and static quantization methods.</li> <li>through <a href="https://github.com/Xilinx/brevitas" rel="nofollow">Brevitas</a> library, used in Optimum’s <a href="/docs/optimum.amd/pr_149/en/brevitas/api_reference#optimum.amd.BrevitasQuantizer">BrevitasQuantizer</a>. Brevitas allows to quantize directly PyTorch models, which may be optionally exported to ONNX. This is recommended to quantize other models.</li>',Q,y,q,M,K='🤗 Optimum AMD provides a Ryzen AI Quantizer that enables you to apply quantization on many models hosted on the Hugging Face Hub using the <a href="https://ryzenai.docs.amd.com/en/latest/vai_quant/vai_q_onnx.html" rel="nofollow">AMD Vitis AI Quantizer</a>.',F,d,aa="RyzenAI Quantizer provides an easy-to-use Post Training Quantization (PTQ) flow on the pre-trained model saved in the ONNX format. It generates a quantized ONNX model ready to be deployed with the Ryzen AI.",x,h,ta="The Quantizer supports various configuration and functions to quantize models targeting for deployment on IPU_CNN, IPU_Transformer and CPU.",H,U,na='The <a href="/docs/optimum.amd/pr_149/en/ryzenai/package_reference/quantization#optimum.amd.ryzenai.RyzenAIOnnxQuantizer">RyzenAIOnnxQuantizer</a> can be initialized using the <code>from_pretrained</code> method, either from a local model folder or a model hosted on Hugging Face Hub:',S,g,Y,j,sa='Below you will find an easy end-to-end example on how to quantize a VGG model from <a href="https://huggingface.co/docs/timm/index" rel="nofollow">Timm</a> library.',E,f,ea='<li>To begin, export the VGG model to ONNX using <a href="https://huggingface.co/docs/optimum/main/en/exporters/onnx/overview" rel="nofollow">Optimum Exporters</a>. Ensure static shapes are specified for inference.</li> <li>Create a preprocessing function to handle specific image format conversions and apply necessary transformations to prepare the input for the model.</li> <li>Initialize the RyzenAI quantizer (RyzenAIOnnxQuantizer) and configure the quantization settings using AutoQuantizationConfig. The recommended quantization configuration for CNN models to be deployed on the IPU is loaded using <code>ipu_cnn_config</code>.</li> <li>Obtain a calibration dataset using the quantizer’s <code>get_calibration_dataset</code> method. This dataset is crucial for computing quantization parameters during the quantization process.</li> <li>Run the quantizer with the specified quantization configuration and calibration data. The quantization parameters computed during this process are embedded as constants in the quantized model.</li> <li>The resulting quantized model is saved in the specified quantization directory.</li>',N,J,k,z,V,b,la="Coming soon.",A,T,$;return r=new O({props:{title:"Quantization for Ryzen AI",local:"quantization-for-ryzen-ai",headingTag:"h1"}}),y=new O({props:{title:"Quantization using RyzenAIOnnxQuantizer",local:"quantization-using-ryzenaionnxquantizer",headingTag:"h2"}}),g=new oa({props:{code:"ZnJvbSUyMG9wdGltdW0uYW1kLnJ5emVuYWklMjBpbXBvcnQlMjBSeXplbkFJT25ueFF1YW50aXplciUwQSUwQXF1YW50aXplciUyMCUzRCUyMFJ5emVuQUlPbm54UXVhbnRpemVyLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZtb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> RyzenAIOnnxQuantizer

<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = RyzenAIOnnxQuantizer.from_pretrained(<span class="hljs-string">&quot;path/to/model&quot;</span>)`,wrap:!1}}),J=new oa({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> AutoQuantizationConfig, RyzenAIOnnxQuantizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> main_export
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define paths for exporting ONNX model and saving quantized model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>export_dir = <span class="hljs-string">&quot;/path/to/vgg_onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_dir = <span class="hljs-string">&quot;/path/to/vgg_onnx_quantized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Specify the model ID from Timm</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;timm/vgg11.tv_in1k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 1: Export the model to ONNX format using Optimum Exporters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>main_export(
<span class="hljs-meta">... </span>    model_name_or_path=model_id,
<span class="hljs-meta">... </span>    output=export_dir,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;image-classification&quot;</span>,
<span class="hljs-meta">... </span>    opset=<span class="hljs-number">13</span>,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    no_dynamic_axes=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 2: Preprocess configuration and data transformations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PretrainedConfig.from_pretrained(export_dir)
<span class="hljs-meta">&gt;&gt;&gt; </span>data_config = timm.data.resolve_data_config(pretrained_cfg=config.pretrained_cfg)
<span class="hljs-meta">&gt;&gt;&gt; </span>transforms = timm.data.create_transform(**data_config, is_training=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, transforms</span>):
<span class="hljs-meta">... </span>    image = ex[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> image.mode == <span class="hljs-string">&quot;L&quot;</span>:
<span class="hljs-meta">... </span>      <span class="hljs-comment"># Convert greyscale to RGB if needed</span>
<span class="hljs-meta">... </span>      <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;WARNING: converting greyscale to RGB&quot;</span>)
<span class="hljs-meta">... </span>      image = image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">... </span>    pixel_values = transforms(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 3: Initialize the RyzenAIOnnxQuantizer with the exported model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = RyzenAIOnnxQuantizer.from_pretrained(export_dir)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 4: Load recommended quantization config for model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = AutoQuantizationConfig.ipu_cnn_config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 5: Obtain a calibration dataset for computing quantization parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;imagenet-1k&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, transforms=transforms),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_batch=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    streaming=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Step 6: Run the quantizer with the specified configuration and calibration data</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(
<span class="hljs-meta">... </span>    quantization_config=quantization_config,
<span class="hljs-meta">... </span>    dataset=train_calibration_dataset,
<span class="hljs-meta">... </span>    save_dir=quantization_dir
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new O({props:{title:"Quantization using BrevitasQuantizer",local:"quantization-using-brevitasquantizer",headingTag:"h2"}}),{c(){o=i("meta"),G=e(),w=i("p"),W=e(),C(r.$$.fragment),_=e(),c=i("p"),c.innerHTML=L,X=e(),u=i("ul"),u.innerHTML=D,Q=e(),C(y.$$.fragment),q=e(),M=i("p"),M.innerHTML=K,F=e(),d=i("p"),d.textContent=aa,x=e(),h=i("p"),h.textContent=ta,H=e(),U=i("p"),U.innerHTML=na,S=e(),C(g.$$.fragment),Y=e(),j=i("p"),j.innerHTML=sa,E=e(),f=i("ul"),f.innerHTML=ea,N=e(),C(J.$$.fragment),k=e(),C(z.$$.fragment),V=e(),b=i("p"),b.textContent=la,A=e(),T=i("p"),this.h()},l(a){const t=Ma("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(n),G=l(a),w=p(a,"P",{}),ia(w).forEach(n),W=l(a),Z(r.$$.fragment,a),_=l(a),c=p(a,"P",{"data-svelte-h":!0}),m(c)!=="svelte-5xzzhi"&&(c.innerHTML=L),X=l(a),u=p(a,"UL",{"data-svelte-h":!0}),m(u)!=="svelte-tkqyww"&&(u.innerHTML=D),Q=l(a),Z(y.$$.fragment,a),q=l(a),M=p(a,"P",{"data-svelte-h":!0}),m(M)!=="svelte-inoi3o"&&(M.innerHTML=K),F=l(a),d=p(a,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1o37di3"&&(d.textContent=aa),x=l(a),h=p(a,"P",{"data-svelte-h":!0}),m(h)!=="svelte-95l5v6"&&(h.textContent=ta),H=l(a),U=p(a,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1o26jq3"&&(U.innerHTML=na),S=l(a),Z(g.$$.fragment,a),Y=l(a),j=p(a,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1an02sb"&&(j.innerHTML=sa),E=l(a),f=p(a,"UL",{"data-svelte-h":!0}),m(f)!=="svelte-noakiu"&&(f.innerHTML=ea),N=l(a),Z(J.$$.fragment,a),k=l(a),Z(z.$$.fragment,a),V=l(a),b=p(a,"P",{"data-svelte-h":!0}),m(b)!=="svelte-tiqdrw"&&(b.textContent=la),A=l(a),T=p(a,"P",{}),ia(T).forEach(n),this.h()},h(){pa(o,"name","hf:doc:metadata"),pa(o,"content",Ua)},m(a,t){da(document.head,o),s(a,G,t),s(a,w,t),s(a,W,t),R(r,a,t),s(a,_,t),s(a,c,t),s(a,X,t),s(a,u,t),s(a,Q,t),R(y,a,t),s(a,q,t),s(a,M,t),s(a,F,t),s(a,d,t),s(a,x,t),s(a,h,t),s(a,H,t),s(a,U,t),s(a,S,t),R(g,a,t),s(a,Y,t),s(a,j,t),s(a,E,t),s(a,f,t),s(a,N,t),R(J,a,t),s(a,k,t),R(z,a,t),s(a,V,t),s(a,b,t),s(a,A,t),s(a,T,t),$=!0},p:ra,i(a){$||(B(r.$$.fragment,a),B(y.$$.fragment,a),B(g.$$.fragment,a),B(J.$$.fragment,a),B(z.$$.fragment,a),$=!0)},o(a){I(r.$$.fragment,a),I(y.$$.fragment,a),I(g.$$.fragment,a),I(J.$$.fragment,a),I(z.$$.fragment,a),$=!1},d(a){a&&(n(G),n(w),n(W),n(_),n(c),n(X),n(u),n(Q),n(q),n(M),n(F),n(d),n(x),n(h),n(H),n(U),n(S),n(Y),n(j),n(E),n(f),n(N),n(k),n(V),n(b),n(A),n(T)),n(o),v(r,a),v(y,a),v(g,a),v(J,a),v(z,a)}}}const Ua='{"title":"Quantization for Ryzen AI","local":"quantization-for-ryzen-ai","sections":[{"title":"Quantization using RyzenAIOnnxQuantizer","local":"quantization-using-ryzenaionnxquantizer","sections":[],"depth":2},{"title":"Quantization using BrevitasQuantizer","local":"quantization-using-brevitasquantizer","sections":[],"depth":2}],"depth":1}';function ga(P){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends ua{constructor(o){super(),ya(this,o,ga,ha,ma,{})}}export{ba as component};
