import{s as tt,n as at,o as Mt}from"../chunks/scheduler.6062bdaf.js";import{S as nt,i as Jt,g as n,s as a,r as U,A as it,h as J,f as s,c as M,j as st,u as p,x as i,k as Js,y as Ut,a as t,v as T,d as c,t as j,w as o}from"../chunks/index.4bca734e.js";import{C as d}from"../chunks/CodeBlock.fa01571c.js";import{H as h,E as pt}from"../chunks/EditOnGithub.74ab2baa.js";function Tt(is){let r,Wl,Hl,vl,y,Fl,u,Us='Hugging Face Hub는 커뮤니티와 모델을 공유하는 것을 쉽게 만들어줍니다. 이는 오픈소스 생태계의 <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">수십 가지 라이브러리</a>를 지원합니다. 저희는 항상 협업적인 머신 러닝을 발전시키기 위해 이 라이브러리를 확대하고자 노력하고 있습니다. <code>huggingface_hub</code> 라이브러리는 어떤 Python 스크립트든지 쉽게 파일을 업로드하고 가져올 수 있는 중요한 역할을 합니다.',$l,I,ps="라이브러리를 Hub와 통합하는 네 가지 주요 방법이 있습니다:",Nl,b,Ts='<li><strong>Hub에 업로드하기</strong>: 모델을 Hub에 업로드하는 메소드를 구현합니다. 이에는 모델 가중치뿐만 아니라 <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">모델 카드</a> 및 모델 실행에 필요한 다른 관련 정보나 데이터(예: 훈련 로그)가 포함됩니다. 이 메소드는 일반적으로 <code>push_to_hub()</code>라고 합니다.</li> <li><strong>Hub에서 다운로드하기</strong>: Hub에서 모델을 가져오는 메소드를 구현합니다. 이 메소드는 모델 구성/가중치를 다운로드하고 모델을 가져와야 합니다. 이 메소드는 일반적으로 <code>from_pretrained</code> 또는 <code>load_from_hub()</code>라고 합니다.</li> <li><strong>추론 API</strong>: 라이브러리에서 지원하는 모델에 대해 무료로 추론을 실행할 수 있도록 당사 서버를 사용합니다.</li> <li><strong>위젯</strong>: Hub의 모델 랜딩 페이지에 위젯을 표시합니다. 이를 통해 사용자들은 브라우저에서 빠르게 모델을 시도할 수 있습니다.</li>',Yl,C,cs="이 가이드에서는 앞의 두 가지 주제에 중점을 둘 것입니다. 우리는 라이브러리를 통합하는 데 사용할 수 있는 두 가지 주요 방법을 소개하고 각각의 장단점을 설명할 것입니다. 두 가지 중 어떤 것을 선택할지에 대한 도움이 되도록 끝 부분에 내용이 요약되어 있습니다. 이는 단지 가이드라는 것을 명심하고 상황에 맞게 적응시킬 수 있는 가이드라는 점을 유념하십시오.",Sl,f,js='추론 및 위젯에 관심이 있는 경우 <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">이 가이드</a>를 참조할 수 있습니다. 양쪽 모두에서 라이브러리를 Hub와 통합하고 <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">문서</a>에 목록에 게시하고자 하는 경우에는 언제든지 연락하실 수 있습니다.',Dl,g,Xl,_,os='라이브러리를 Hub에 통합하는 첫 번째 접근 방법은 실제로 <code>push_to_hub</code> 및 <code>from_pretrained</code> 메소드를 직접 구현하는 것입니다. 이를 통해 업로드/다운로드할 파일 및 입력을 처리하는 방법에 대한 완전한 유연성을 제공받을 수 있습니다. 이를 위해 <a href="./upload">파일 업로드</a> 및 <a href="./download">파일 다운로드</a> 가이드를 참조하여 자세히 알아볼 수 있습니다. 예를 들어 FastAI 통합이 구현된 방법을 보면 됩니다 (<a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a> 및 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>를 참조).',zl,A,hs="라이브러리마다 구현 방식은 다를 수 있지만, 워크플로우는 일반적으로 비슷합니다.",Ll,E,Ol,V,ds="일반적으로 <code>from_pretrained</code> 메소드는 다음과 같은 형태를 가집니다:",ql,k,Pl,Q,Kl,B,rs="<code>push_to_hub</code> 메소드는 종종 리포지토리 생성, 모델 카드 생성 및 가중치 저장을 처리하기 위해 조금 더 복잡한 접근 방식이 필요합니다. 일반적으로 모든 이러한 파일을 임시 폴더에 저장한 다음 업로드하고 나중에 삭제하는 방식이 흔히 사용됩니다.",le,Z,ee,R,ms='물론 이는 단순한 예시에 불과합니다. 더 복잡한 조작(원격 파일 삭제, 가중치를 실시간으로 업로드, 로컬로 가중치를 유지 등)에 관심이 있다면 <a href="./upload">파일 업로드</a> 가이드를 참조해 주세요.',se,x,te,H,ws="이러한 방식은 유연성을 가지고 있지만, 유지보수 측면에서 일부 단점을 가지고 있습니다. Hugging Face 사용자들은 <code>huggingface_hub</code>와 함께 작업할 때 추가 기능에 익숙합니다. 예를 들어, Hub에서 파일을 로드할 때 다음과 같은 매개변수를 제공하는 것이 일반적입니다:",ae,G,ys="<li><code>token</code>: 개인 리포지토리에서 다운로드하기 위한 토큰</li> <li><code>revision</code>: 특정 브랜치에서 다운로드하기 위한 리비전</li> <li><code>cache_dir</code>: 특정 디렉터리에 파일을 캐시하기 위한 디렉터리</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: 캐시를 재사용할 것인지 여부를 결정하는 매개변수</li> <li><code>proxies</code>: HTTP 세션 구성</li>",Me,W,us="모델을 푸시할 때는 유사한 매개변수가 지원됩니다:",ne,v,Is="<li><code>commit_message</code>: 사용자 정의 커밋 메시지</li> <li><code>private</code>: 개인 리포지토리를 만들어야 할 경우</li> <li><code>create_pr</code>: <code>main</code>에 푸시하는 대신 PR을 만드는 경우</li> <li><code>branch</code>: <code>main</code> 브랜치 대신 브랜치에 푸시하는 경우</li> <li><code>allow_patterns/ignore_patterns</code>: 업로드할 파일을 필터링하는 매개변수</li> <li><code>token</code></li> <li>…</li>",Je,F,bs="이러한 매개변수는 위에서 본 구현에 추가하여 <code>huggingface_hub</code> 메소드로 전달할 수 있습니다. 그러나 매개변수가 변경되거나 새로운 기능이 추가되는 경우에는 패키지를 업데이트해야 합니다. 이러한 매개변수를 지원하는 것은 유지 관리할 문서가 더 많아진다는 것을 의미합니다. 이러한 제한 사항을 완화할 수 있는 방법을 보려면 다음 섹션인 <strong>클래스 상속</strong>으로 이동해 보겠습니다.",ie,$,Ue,N,Cs="위에서 보았듯이 Hub와 통합하기 위해 라이브러리에 포함해야 할 주요 메소드는 파일을 업로드 (<code>push_to_hub</code>) 와 파일 다운로드 (<code>from_pretrained</code>)입니다. 이러한 메소드를 직접 구현할 수 있지만, 이에는 몇 가지 주의할 점이 있습니다. 이를 해결하기 위해 <code>huggingface_hub</code>은 클래스 상속을 사용하는 도구를 제공합니다. 이 도구가 어떻게 작동하는지 살펴보겠습니다!",pe,Y,fs='많은 경우에 라이브러리는 이미 Python 클래스를 사용하여 모델을 구현합니다. 이 클래스에는 모델의 속성 및 로드, 실행, 훈련 및 평가하는 메소드가 포함되어 있습니다. 접근 방식은 믹스인을 사용하여 이 클래스를 확장하여 업로드 및 다운로드 기능을 포함하는 것입니다. <a href="https://stackoverflow.com/a/547714" rel="nofollow">믹스인(Mixin)</a>은 기존 클래스에 여러 상속을 통해 특정 기능을 확장하기 위해 설계된 클래스입니다. <code>huggingface_hub</code>은 자체 믹스인인 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>을 제공합니다. 여기서 핵심은 동작과 이를 사용자 정의하는 방법을 이해하는 것입니다.',Te,S,gs='<a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> 클래스는 세 개의 <em>공개</em> 메소드(<code>push_to_hub</code>, <code>save_pretrained</code>, <code>from_pretrained</code>)를 구현합니다. 이 메소드들은 사용자가 라이브러리를 사용하여 모델을 로드/저장할 때 호출하는 메소드입니다. 또한 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>은 두 개의 <em>비공개</em> 메소드(<code>_save_pretrained</code> 및 <code>_from_pretrained</code>)를 정의합니다. 라이브러리를 통합하려면 이 메소드들을 구현해야 합니다. :',ce,D,_s='<li>모델 클래스를 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>에서 상속합니다.</li> <li>비공개 메소드를 구현합니다:<ul><li><a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: 디렉터리 경로를 입력으로 받아 모델을 해당 디렉터리에 저장하는 메소드입니다. 이 메소드에는 모델 카드, 모델 가중치, 구성 파일, 훈련 로그 및 그림 등 해당 모델에 대한 모든 관련 정보를 저장하기 위한 로직을 작성해야 합니다. <a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">모델 카드</a>는 모델을 설명하는 데 특히 중요합니다. 더 자세한 내용은 <a href="./model-cards">구현 가이드</a>를 확인하세요.</li> <li><a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <code>model_id</code>를 입력으로 받아 인스턴스화된 모델을 반환하는 <strong>클래스 메소드</strong>입니다. 이 메소드는 관련 파일을 다운로드하고 가져와야 합니다.</li></ul></li> <li>완료했습니다!</li>',je,X,As='<a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>의 장점은 파일의 직렬화/로드에만 신경을 쓰면 되기 때문에 즉시 사용할 수 있다는 것입니다. 리포지토리 생성, 커밋, PR 또는 리비전과 같은 사항에 대해 걱정할 필요가 없습니다. <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>은 또한 공개 메소드가 문서화되고 타입에 주석이 달려있는지를 확인하며, Hub 모델의 다운로드 수를 볼 수 있도록 합니다. 이 모든 것은 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>에 의해 처리되며 사용자에게 제공됩니다.',oe,z,he,L,Es='위에서 언급한 내용의 좋은 예시는 Pytorch 프레임워크를 통합한 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>입니다. 바로 사용 가능할 수 있는 메소드입니다.',de,O,re,q,Vs="다음은 Hub에서 PyTorch 모델을 로드/저장하는 방법입니다:",me,P,we,K,ye,ll,ks='실제 구현은 매우 간단합니다. 전체 구현은 <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">여기</a>에서 찾을 수 있습니다.',ue,el,Qs="<li>클래스를 <code>ModelHubMixin</code>으로부터 상속하세요:</li>",Ie,sl,be,m,Bs="<li><code>_save_pretrained</code> 메소드를 구현하세요:</li>",Ce,tl,fe,w,Zs="<li><code>_from_pretrained</code> 메소드를 구현하세요:</li>",ge,al,_e,Ml,Rs="이게 전부입니다! 이제 라이브러리를 통해 Hub로부터 파일을 업로드하고 다운로드할 수 있습니다.",Ae,nl,Ee,Jl,xs='위의 섹션에서는 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>이 어떻게 작동하는지 간단히 살펴보았습니다. 이번 섹션에서는 Hugging Face Hub와 라이브러리 통합을 개선하기 위한 더 고급 기능 중 일부를 살펴보겠습니다.',Ve,il,ke,Ul,Hs='<a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>은 모델 카드를 자동으로 생성합니다. 모델 카드는 모델과 함께 제공되는 중요한 정보를 제공하는 파일입니다. 모델 카드는 추가 메타데이터가 포함된 간단한 Markdown 파일입니다. 모델 카드는 발견 가능성, 재현성 및 공유를 위해 중요합니다! 더 자세한 내용은 <a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">모델 카드 가이드</a>를 확인하세요.',Qe,pl,Gs='모델 카드를 반자동으로 생성하는 것은 라이브러리로 푸시된 모든 모델이 <code>library_name</code>, <code>tags</code>, <code>license</code>, <code>pipeline_tag</code> 등과 같은 공통 메타데이터를 공유하도록 하는 좋은 방법입니다. 이를 통해 모든 모델이 Hub에서 쉽게 검색 가능하게 되고, Hub에 접속한 사용자에게 일부 리소스 링크를 제공합니다. <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>을 상속할 때 메타데이터를 직접 정의할 수 있습니다:',Be,Tl,Ze,cl,Ws='기본적으로는 제공된 정보로 일반적인 모델 카드가 생성됩니다(예: <a href="https://huggingface.co/pyp1/VoiceCraft_giga830M" rel="nofollow">pyp1/VoiceCraft_giga830M</a>). 그러나 사용자 정의 모델 카드 템플릿을 정의할 수도 있습니다!',Re,jl,vs='이 예에서는 <code>VoiceCraft</code> 클래스로 푸시된 모든 모델에 자동으로 인용 부분과 라이선스 세부 정보가 포함됩니다. 모델 카드 템플릿을 정의하는 방법에 대한 자세한 내용은 <a href="./model-cards">모델 카드 가이드</a>를 참조하세요.',xe,ol,He,hl,Fs="마지막으로, 모델 카드 생성 프로세스를 동적 값으로 확장하려면 <code>generate_model_card()</code> 메소드를 재정의할 수 있습니다:",Ge,dl,We,rl,ve,ml,$s='<a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>은 모델 구성을 처리합니다. 모델을 인스턴스화할 때 입력 값들을 자동으로 확인하고 이를 <code>config.json</code> 파일에 직렬화합니다. 이렇게 함으로써 두 가지 이점이 제공됩니다:',Fe,wl,Ns="<li>사용자는 정확히 동일한 매개변수로 모델을 다시 가져올 수 있습니다.</li> <li><code>config.json</code> 파일이 자동으로 생성되면 Hub에서 분석이 가능해집니다(즉, “다운로드” 횟수가 기록됩니다).</li>",$e,yl,Ys="하지만 이것이 실제로 어떻게 작동하는 걸까요? 사용자 관점에서 프로세스가 가능한 매끄럽도록 하기 위해 여러 규칙이 존재합니다:",Ne,ul,Ss="<li>만약 <code>__init__</code> 메소드가 <code>config</code> 입력을 기대한다면, 이는 자동으로 <code>config.json</code>으로 저장됩니다.</li> <li>만약 <code>config</code> 입력 매개변수에 데이터 클래스 유형(예: <code>config: Optional[MyConfigClass] = None</code>)의 어노테이션이 있다면, config 값은 올바르게 역직렬화됩니다.</li> <li>초기화할 때 전달된 모든 값들도 구성 파일에 저장됩니다. 이는 <code>config</code> 입력을 기대하지 않더라도 이점을 얻을 수 있다는 것을 의미합니다.</li>",Ye,Il,Ds="예시:",Se,bl,De,Cl,Xs='그러나 값이 JSON으로 직렬화될 수 없는 경우, 기본적으로 구성 파일을 저장할 때 해당 값은 무시됩니다. 그러나 경우에 따라 라이브러리가 이미 직렬화할 수 없는 사용자 정의 객체를 예상하고 있고 해당 유형을 업데이트하고 싶지 않은 경우가 있습니다. 그렇다면 <a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>을 상속할 때 어떤 유형에 대한 사용자 지정 인코더/디코더를 전달할 수 있습니다. 이는 조금 더 많은 작업이 필요하지만 내부 로직을 변경하지 않고도 라이브러리를 Hub에 통합할 수 있도록 보장합니다.',Xe,fl,zs="여기서 <code>argparse.Namespace</code> 구성을 입력으로 받는 클래스의 구체적인 예가 있습니다:",ze,gl,Le,_l,Ls="한 가지 해결책은 <code>__init__</code> 시그니처를 <code>def __init__(self, pattern: str, hidden_size: int)</code>로 업데이트하고 클래스를 인스턴스화하는 모든 스니펫을 업데이트하는 것입니다. 이 방법은 유효한 방법이지만, 라이브러리를 사용하는 하위 응용 프로그램을 망가뜨릴 수 있습니다.",Oe,Al,Os="다른 해결책은 <code>argparse.Namespace</code>를 사전으로 변환하는 간단한 인코더/디코더를 제공하는 것입니다.",qe,El,Pe,Vl,qs="위의 코드 스니펫에서는 클래스의 내부 로직과 <code>__init__</code> 시그니처가 변경되지 않았습니다. 이는 기존의 모든 코드 스니펫이 여전히 작동한다는 것을 의미합니다. 이를 달성하기 위해 다음 과정을 수행하면 됩니다:",Ke,kl,Ps="<li>믹스인(<code>PytorchModelHubMixin</code>)으로부터 상속합니다.</li> <li>상속 시 <code>coders</code> 매개변수를 전달합니다. 이는 키가 처리하려는 사용자 지정 유형이고, 값은 튜플 <code>(인코더, 디코더)</code>입니다.<ul><li>인코더는 지정된 유형의 객체를 입력으로 받아서 jsonable 값으로 반환합니다. 이는 <code>save_pretrained</code>로 모델을 저장할 때 사용됩니다.</li> <li>디코더는 원시 데이터(일반적으로 딕셔너리 타입)를 입력으로 받아서 초기 객체를 재구성합니다. 이는 <code>from_pretrained</code>로 모델을 로드할 때 사용됩니다.</li> <li><code>__init__</code> 시그니처에 유형 주석을 추가합니다. 이는 믹스인에게 클래스가 기대하는 유형과, 따라서 어떤 디코더를 사용해야 하는지를 알려주는 데 중요합니다.</li></ul></li>",ls,Ql,Ks="위의 예제는 간단한 예시이기 때문에 인코더/디코더 함수는 견고하지 않습니다. 구체적인 구현을 위해서는 코너 케이스를 적절하게 처리해야 할 것입니다.",es,Bl,ss,Zl,lt="두 가지 접근 방법에 대한 장단점을 간단히 정리해보겠습니다. 아래 표는 단순히 예시일 뿐입니다. 각자 다른 프레임워크에는 고려해야 할 특정 사항이 있을 수 있습니다. 이 가이드는 통합을 다루는 아이디어와 지침을 제공하기 위한 것입니다. 언제든지 궁금한 점이 있으면 문의해 주세요!",ts,Rl,et='<thead><tr><th align="center">통합</th> <th align="center">helpers 사용 시</th> <th align="center"><a href="/docs/huggingface_hub/pr_2391/ko/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> 사용 시</th></tr></thead> <tbody><tr><td align="center">사용자 경험</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">유연성</td> <td align="center">매우 유연합니다.<br/>구현을 완전히 제어합니다.</td> <td align="center">유연성이 떨어집니다.<br/>프레임워크에는 모델 클래스가 있어야 합니다.</td></tr> <tr><td align="center">유지 관리</td> <td align="center">구성 및 새로운 기능에 대한 지원을 추가하기 위한 유지 관리가 더 필요합니다. 사용자가 보고한 문제를 해결해야할 수도 있습니다.</td> <td align="center">Hub와의 대부분의 상호 작용이 <code>huggingface_hub</code>에서 구현되므로 유지 관리가 줄어듭니다.</td></tr> <tr><td align="center">문서화 / 타입 주석</td> <td align="center">수동으로 작성해야 합니다.</td> <td align="center"><code>huggingface_hub</code>에서 부분적으로 처리됩니다.</td></tr> <tr><td align="center">다운로드 횟수 표시기</td> <td align="center">수동으로 처리해야 합니다.</td> <td align="center">클래스에 <code>config</code> 속성이 있다면 기본적으로 활성화됩니다.</td></tr> <tr><td align="center">모델 카드</td> <td align="center">수동으로 처리해야 합니다.</td> <td align="center">library_name, tags 등을 활용하여 기본적으로 생성됩니다.</td></tr></tbody>',as,xl,Ms,Gl,ns;return y=new h({props:{title:"Hub와 어떤 머신 러닝 프레임워크든 통합",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),g=new h({props:{title:"유연한 접근 방식: 도우미(helper)",local:"a-flexible-approach-helpers",headingTag:"h2"}}),E=new h({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),k=new d({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBIdWIlRUIlQTElOUMlRUIlQjYlODAlRUQlODQlQjAlMjAlRUIlQUElQTglRUIlOEQlQjglRUMlOUQlODQlMjAlRUIlOEIlQTQlRUMlOUElQjQlRUIlQTElOUMlRUIlOTMlOUMlMEElMjAlMjAlMjBjYWNoZWRfbW9kZWwlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBmaWxlbmFtZSUzRCUyMm1vZGVsLnBrbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMmZhc3RhaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfdmVyc2lvbiUzRGdldF9mYXN0YWlfdmVyc2lvbigpJTJDJTBBJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMyUyMCVFQiVBQSVBOCVFQiU4RCVCOCUyMCVFQSVCMCU4MCVFQyVBMCVCOCVFQyU5OCVBNCVFQSVCOCVCMCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvYWRfbW9kZWwoY2FjaGVkX21vZGVsKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Hub로부터 모델을 다운로드</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># 모델 가져오기</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),Q=new h({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),Z=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># 해당 리포지토리가 아직 없다면 리포지토리를 생성하고 관련된 리포지토리 ID를 가져옵니다.</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># 모든 파일을 임시 디렉토리에 저장하고 이를 단일 커밋으로 푸시합니다.</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># 가중치 저장</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># model card 생성</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># 로그 저장</span>
      <span class="hljs-comment"># 설정 저장</span>
      <span class="hljs-comment"># 평가 지표를 저장</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Hub에 푸시</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),x=new h({props:{title:"제한 사항",local:"limitations",headingTag:"h3"}}),$=new h({props:{title:"더욱 복잡한 접근법: 클래스 상속",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),z=new h({props:{title:"자세한 예시: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),O=new h({props:{title:"어떻게 사용하나요?",local:"how-to-use-it",headingTag:"h4"}}),P=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-comment"># PyTorch 모델을 여러분이 흔히 사용하는 방식과 완전히 동일하게 정의하세요.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin, <span class="hljs-comment"># 다중 상속</span>
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;keras&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ 모델 카드를 생성하는 데 선택적인 메타데이터입니다.</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># 1. 모델 생성</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># 설정은 입력 및 기본값을 기반으로 자동으로 생성됩니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># 2. (선택사항) 모델을 로컬 디렉터리에 저장합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. 모델 가중치를 Hub에 푸시합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Hub로부터 모델을 초기화합니다. =&gt; 이때 설정은 보존됩니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># 모델 카드가 올바르게 작성되었습니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;keras&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;keras-nlp&quot;</span>`,wrap:!1}}),K=new h({props:{title:"구현",local:"implementation",headingTag:"h4"}}),sl=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),tl=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJQeVRvcmNoJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlEJTk4JTIwJUVBJUIwJTgwJUVDJUE0JTkxJUVDJUI5JTk4JUVCJUE1JUJDJTIwJUVCJUExJTlDJUVDJUJCJUFDJTIwJUVCJTk0JTk0JUVCJUEwJTg5JUVEJTg0JUIwJUVCJUE2JUFDJUVDJTk3JTkwJTIwJUVDJUEwJTgwJUVDJTlFJUE1JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWxfYXNfc2FmZXRlbnNvcihzZWxmLm1vZHVsZSUyQyUyMHN0cihzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMFNBRkVURU5TT1JTX1NJTkdMRV9GSUxFKSklMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;PyTorch 모델의 가중치를 로컬 디렉터리에 저장합니다.&quot;&quot;&quot;</span>
        save_model_as_safetensor(self.module, <span class="hljs-built_in">str</span>(save_directory / SAFETENSORS_SINGLE_FILE))
`,wrap:!1}}),al=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># 반드시 클래스 메소드여야 합니다!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># 추가 인자</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># 추가 인자</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;PyTorch의 사전 학습된 가중치와 모델을 반환합니다.&quot;&quot;&quot;</span>
        model = cls(**model_kwargs)
        <span class="hljs-keyword">if</span> os.path.isdir(model_id):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
            model_file = os.path.join(model_id, SAFETENSORS_SINGLE_FILE)
            <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)

         model_file = hf_hub_download(
            repo_id=model_id,
            filename=SAFETENSORS_SINGLE_FILE,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
            )
         <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)`,wrap:!1}}),nl=new h({props:{title:"고급 사용법",local:"advanced-usage",headingTag:"h3"}}),il=new h({props:{title:"모델 카드",local:"model-card",headingTag:"h4"}}),Tl=new d({props:{code:"Y2xhc3MlMjBVbmlEZXB0aFYxKCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTBBJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIydW5pZGVwdGglMjIlMkMlMEElMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmxwaWNjaW5lbGxpLWV0aCUyRlVuaURlcHRoJTIyJTJDJTBBJTIwJTIwJTIwZG9jc191cmwlM0QuLi4lMkMlMEElMjAlMjAlMjBwaXBlbGluZV90YWclM0QlMjJkZXB0aC1lc3RpbWF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwbGljZW5zZSUzRCUyMmNjLWJ5LW5jLTQuMCUyMiUyQyUwQSUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJtb25vY3VsYXItbWV0cmljLWRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjAlMjJhcnhpdiUzQTEyMzQuNTY3ODklMjIlNUQlMEEpJTNBJTBBJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;unidepth&quot;</span>,
   repo_url=<span class="hljs-string">&quot;https://github.com/lpiccinelli-eth/UniDepth&quot;</span>,
   docs_url=...,
   pipeline_tag=<span class="hljs-string">&quot;depth-estimation&quot;</span>,
   license=<span class="hljs-string">&quot;cc-by-nc-4.0&quot;</span>,
   tags=[<span class="hljs-string">&quot;monocular-metric-depth-estimation&quot;</span>, <span class="hljs-string">&quot;arxiv:1234.56789&quot;</span>]
):
   ...`,wrap:!1}}),ol=new d({props:{code:"TU9ERUxfQ0FSRF9URU1QTEFURSUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQSUyMyUyMEZvciUyMHJlZmVyZW5jZSUyMG9uJTIwbW9kZWwlMjBjYXJkJTIwbWV0YWRhdGElMkMlMjBzZWUlMjB0aGUlMjBzcGVjJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWItZG9jcyUyRmJsb2IlMkZtYWluJTJGbW9kZWxjYXJkLm1kJTNGcGxhaW4lM0QxJTBBJTIzJTIwRG9jJTIwJTJGJTIwZ3VpZGUlM0ElMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRmh1YiUyRm1vZGVsLWNhcmRzJTBBJTdCJTdCJTIwY2FyZF9kYXRhJTIwJTdEJTdEJTBBLS0tJTBBJTBBVGhpcyUyMGlzJTIwYSUyMFZvaWNlQ3JhZnQlMjBtb2RlbC4lMjBGb3IlMjBtb3JlJTIwZGV0YWlscyUyQyUyMHBsZWFzZSUyMGNoZWNrJTIwb3V0JTIwdGhlJTIwb2ZmaWNpYWwlMjBHaXRodWIlMjByZXBvJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFzb25wcHklMkZWb2ljZUNyYWZ0LiUyMFRoaXMlMjBtb2RlbCUyMGlzJTIwc2hhcmVkJTIwdW5kZXIlMjBhJTIwQXR0cmlidXRpb24tTm9uQ29tbWVyY2lhbC1TaGFyZUFsaWtlJTIwNC4wJTIwSW50ZXJuYXRpb25hbCUyMGxpY2Vuc2UuJTBBJTBBJTIzJTIzJTIwQ2l0YXRpb24lMEElMEElNDBhcnRpY2xlJTdCcGVuZzIwMjR2b2ljZWNyYWZ0JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCUGVuZyUyQyUyMFB1eXVhbiUyMGFuZCUyMEh1YW5nJTJDJTIwUG8tWWFvJTIwYW5kJTIwTGklMkMlMjBEYW5pZWwlMjBhbmQlMjBNb2hhbWVkJTJDJTIwQWJkZWxyYWhtYW4lMjBhbmQlMjBIYXJ3YXRoJTJDJTIwRGF2aWQlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QlZvaWNlQ3JhZnQlM0ElMjBaZXJvLVNob3QlMjBTcGVlY2glMjBFZGl0aW5nJTIwYW5kJTIwVGV4dC10by1TcGVlY2glMjBpbiUyMHRoZSUyMFdpbGQlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAyNCU3RCUyQyUwQSU3RCUwQSUyMiUyMiUyMiUwQSUwQWNsYXNzJTIwVm9pY2VDcmFmdCglMEElMjAlMjAlMjBubi5Nb2R1bGUlMkMlMEElMjAlMjAlMjBQeVRvcmNoTW9kZWxIdWJNaXhpbiUyQyUwQSUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnZvaWNlY3JhZnQlMjIlMkMlMEElMjAlMjAlMjBtb2RlbF9jYXJkX3RlbXBsYXRlJTNETU9ERUxfQ0FSRF9URU1QTEFURSUyQyUwQSUyMCUyMCUyMC4uLiUwQSklM0ElMEElMjAlMjAlMjAuLi4=",highlighted:`MODEL_CARD_TEMPLATE = <span class="hljs-string">&quot;&quot;&quot;
---
# For reference on model card metadata, see the spec: https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1
# Doc / guide: https://huggingface.co/docs/hub/model-cards
{{ card_data }}
---

This is a VoiceCraft model. For more details, please check out the official Github repo: https://github.com/jasonppy/VoiceCraft. This model is shared under a Attribution-NonCommercial-ShareAlike 4.0 International license.

## Citation

@article{peng2024voicecraft,
  author    = {Peng, Puyuan and Huang, Po-Yao and Li, Daniel and Mohamed, Abdelrahman and Harwath, David},
  title     = {VoiceCraft: Zero-Shot Speech Editing and Text-to-Speech in the Wild},
  journal   = {arXiv},
  year      = {2024},
}
&quot;&quot;&quot;</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;voicecraft&quot;</span>,
   model_card_template=MODEL_CARD_TEMPLATE,
   ...
):
   ...`,wrap:!1}}),dl=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTBBJTBBY2xhc3MlMjBVbmlEZXB0aFYxKG5uLk1vZHVsZSUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCguLi4pJTBBJTBBJTIwJTIwJTIwZGVmJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChzZWxmJTJDJTIwKmFyZ3MlMkMlMjAqKmt3YXJncyklMjAtJTNFJTIwTW9kZWxDYXJkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FyZCUyMCUzRCUyMHN1cGVyKCkuZ2VuZXJhdGVfbW9kZWxfY2FyZCgqYXJncyUyQyUyMCoqa3dhcmdzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQuZGF0YS5tZXRyaWNzJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwJUVCJUE5JTk0JUVEJTgzJTgwJUVCJThEJUIwJUVDJTlEJUI0JUVEJTg0JUIwJUVDJTk3JTkwJTIwJUVCJUE5JTk0JUVEJThBJUI4JUVCJUE2JUFEJTIwJUVDJUI2JTk0JUVBJUIwJTgwJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FyZC50ZXh0JTIwJTJCJTNEJTIwLi4uJTIwJTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVDJUI5JUI0JUVCJTkzJTlDJUVDJTk3JTkwJTIwJUVDJTg0JUI5JUVDJTg1JTk4JTIwJUVDJUI2JTk0JUVBJUIwJTgwJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FyZA==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, PyTorchModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(nn.Module, PyTorchModelHubMixin, ...):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_model_card</span>(<span class="hljs-params">self, *args, **kwargs</span>) -&gt; ModelCard:
      card = <span class="hljs-built_in">super</span>().generate_model_card(*args, **kwargs)
      card.data.metrics = ...  <span class="hljs-comment"># 메타데이터에 메트릭 추가</span>
      card.text += ... <span class="hljs-comment"># 모델 카드에 섹션 추가</span>
      <span class="hljs-keyword">return</span> card`,wrap:!1}}),rl=new h({props:{title:"구성",local:"config",headingTag:"h4"}}),bl=new d({props:{code:"Y2xhc3MlMjBNeU1vZGVsKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwZGVmJTIwX19pbml0X18odmFsdWUlM0ElMjBzdHIlMkMlMjBzaXplJTNBJTIwaW50JTIwJTNEJTIwMyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnZhbHVlJTIwJTNEJTIwdmFsdWUlMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNpemUlMjAlM0QlMjBzaXplJTBBJTBBJTIwJTIwJTIwKC4uLiklMjAlMjMlMjBfc2F2ZV9wcmV0cmFpbmVkJTIwJTJGJTIwX2Zyb21fcHJldHJhaW5lZCUyMCVFQSVCNSVBQyVFRCU5OCU4NCUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbCh2YWx1ZSUzRCUyMm15X3ZhbHVlJTIyKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4pJTBBJTBBJTIzJTIwY29uZmlnLmpzb24lMjAlRUQlOEMlOEMlRUMlOUQlQkMlRUMlOTclOTAlRUIlOEElOTQlMjAlRUMlQTAlODQlRUIlOEIlQUMlRUIlOTAlOUMlMjAlRUElQjAlOTIlRUElQjMlQkMlMjAlRUElQjglQjAlRUIlQjMlQjglMjAlRUElQjAlOTIlRUMlOUQlQjQlMjAlRUIlQUElQTglRUIlOTElOTAlMjAlRUQlOEYlQUMlRUQlOTUlQTglRUIlOTAlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTdCJTIydmFsdWUlMjIlM0ElMjAlMjJteV92YWx1ZSUyMiUyQyUyMCUyMnNpemUlMjIlM0ElMjAzJTdE",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">value: <span class="hljs-built_in">str</span>, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span></span>):
      self.value = value
      self.size = size

   (...) <span class="hljs-comment"># _save_pretrained / _from_pretrained 구현</span>

model = MyModel(value=<span class="hljs-string">&quot;my_value&quot;</span>)
model.save_pretrained(...)

<span class="hljs-comment"># config.json 파일에는 전달된 값과 기본 값이 모두 포함됩니다.</span>
{<span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;my_value&quot;</span>, <span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">3</span>}`,wrap:!1}}),gl=new d({props:{code:"Y2xhc3MlMjBWb2ljZUNyYWZ0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args</span>):
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),El=new d({props:{code:"ZnJvbSUyMGFyZ3BhcnNlJTIwaW1wb3J0JTIwTmFtZXNwYWNlJTBBJTBBY2xhc3MlMjBWb2ljZUNyYWZ0KCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwJTIwJTIzJTIwJUVCJUFGJUI5JUVDJThBJUE0JUVDJTlEJUI4JUVDJTlEJTg0JTIwJUVDJTgzJTgxJUVDJTg2JThEJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMGNvZGVycyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyME5hbWVzcGFjZSUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwdmFycyh4KSUyQyUyMCUyMCUyMyUyMEVuY29kZXIlM0ElMjAlNjBOYW1lc3BhY2UlNjAlRUIlQTUlQkMlMjAlRUMlOUMlQTAlRUQlOUElQTglRUQlOTUlOUMlMjBKU09OJTIwJUVEJTk4JTk1JUVEJTgzJTlDJUVCJUExJTlDJTIwJUVCJUIzJTgwJUVEJTk5JTk4JUVEJTk1JTk4JUVCJThBJTk0JTIwJUVCJUIwJUE5JUVCJUIyJTk1JUVDJTlEJTgwJTIwJUVCJUFDJUI0JUVDJTk3JTg3JUVDJTlEJUI4JUVBJUIwJTgwJUVDJTlBJTk0JTNGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFtYmRhJTIwZGF0YSUzQSUyME5hbWVzcGFjZSgqKmRhdGEpJTJDJTIwJTIwJTIzJTIwRGVjb2RlciUzQSUyMCVFQiU5NCU5NSVFQyU4NSU5NCVFQiU4NCU4OCVFQiVBNiVBQyVFQyU5NyU5MCVFQyU4NCU5QyUyME5hbWVzcGFjZSVFQiVBNSVCQyUyMCVFQyU5RSVBQyVFQSVCNSVBQyVFQyU4NCVCMSVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQiVCMCVBOSVFQiVCMiU5NSVFQyU5RCU4MCUyMCVFQiVBQyVCNCVFQyU5NyU4NyVFQyU5RCVCOCVFQSVCMCU4MCVFQyU5QSU5NCUzRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlN0QlMEEpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGFyZ3MlM0ElMjBOYW1lc3BhY2UpJTNBJTIwJTIzJTIwJTYwYXJncyU2MCVFQyU5NyU5MCUyMCVFQyVBMyVCQyVFQyU4NCU5RCVFQyU5RCU4NCUyMCVFQiU4QiVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">from</span> argparse <span class="hljs-keyword">import</span> Namespace

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,  <span class="hljs-comment"># 믹스인을 상속합니다.</span>
   coders={
      Namespace: (
         <span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">vars</span>(x),  <span class="hljs-comment"># Encoder: \`Namespace\`를 유효한 JSON 형태로 변환하는 방법은 무엇인가요?</span>
         <span class="hljs-keyword">lambda</span> data: Namespace(**data),  <span class="hljs-comment"># Decoder: 딕셔너리에서 Namespace를 재구성하는 방법은 무엇인가요?</span>
      )
   }
):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args: Namespace</span>): <span class="hljs-comment"># \`args\`에 주석을 답니다.</span>
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),Bl=new h({props:{title:"빠른 비교",local:"quick-comparison",headingTag:"h2"}}),xl=new pt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/guides/integrations.md"}}),{c(){r=n("meta"),Wl=a(),Hl=n("p"),vl=a(),U(y.$$.fragment),Fl=a(),u=n("p"),u.innerHTML=Us,$l=a(),I=n("p"),I.textContent=ps,Nl=a(),b=n("ol"),b.innerHTML=Ts,Yl=a(),C=n("p"),C.textContent=cs,Sl=a(),f=n("p"),f.innerHTML=js,Dl=a(),U(g.$$.fragment),Xl=a(),_=n("p"),_.innerHTML=os,zl=a(),A=n("p"),A.textContent=hs,Ll=a(),U(E.$$.fragment),Ol=a(),V=n("p"),V.innerHTML=ds,ql=a(),U(k.$$.fragment),Pl=a(),U(Q.$$.fragment),Kl=a(),B=n("p"),B.innerHTML=rs,le=a(),U(Z.$$.fragment),ee=a(),R=n("p"),R.innerHTML=ms,se=a(),U(x.$$.fragment),te=a(),H=n("p"),H.innerHTML=ws,ae=a(),G=n("ul"),G.innerHTML=ys,Me=a(),W=n("p"),W.textContent=us,ne=a(),v=n("ul"),v.innerHTML=Is,Je=a(),F=n("p"),F.innerHTML=bs,ie=a(),U($.$$.fragment),Ue=a(),N=n("p"),N.innerHTML=Cs,pe=a(),Y=n("p"),Y.innerHTML=fs,Te=a(),S=n("p"),S.innerHTML=gs,ce=a(),D=n("ol"),D.innerHTML=_s,je=a(),X=n("p"),X.innerHTML=As,oe=a(),U(z.$$.fragment),he=a(),L=n("p"),L.innerHTML=Es,de=a(),U(O.$$.fragment),re=a(),q=n("p"),q.textContent=Vs,me=a(),U(P.$$.fragment),we=a(),U(K.$$.fragment),ye=a(),ll=n("p"),ll.innerHTML=ks,ue=a(),el=n("ol"),el.innerHTML=Qs,Ie=a(),U(sl.$$.fragment),be=a(),m=n("ol"),m.innerHTML=Bs,Ce=a(),U(tl.$$.fragment),fe=a(),w=n("ol"),w.innerHTML=Zs,ge=a(),U(al.$$.fragment),_e=a(),Ml=n("p"),Ml.textContent=Rs,Ae=a(),U(nl.$$.fragment),Ee=a(),Jl=n("p"),Jl.innerHTML=xs,Ve=a(),U(il.$$.fragment),ke=a(),Ul=n("p"),Ul.innerHTML=Hs,Qe=a(),pl=n("p"),pl.innerHTML=Gs,Be=a(),U(Tl.$$.fragment),Ze=a(),cl=n("p"),cl.innerHTML=Ws,Re=a(),jl=n("p"),jl.innerHTML=vs,xe=a(),U(ol.$$.fragment),He=a(),hl=n("p"),hl.innerHTML=Fs,Ge=a(),U(dl.$$.fragment),We=a(),U(rl.$$.fragment),ve=a(),ml=n("p"),ml.innerHTML=$s,Fe=a(),wl=n("ol"),wl.innerHTML=Ns,$e=a(),yl=n("p"),yl.textContent=Ys,Ne=a(),ul=n("ul"),ul.innerHTML=Ss,Ye=a(),Il=n("p"),Il.textContent=Ds,Se=a(),U(bl.$$.fragment),De=a(),Cl=n("p"),Cl.innerHTML=Xs,Xe=a(),fl=n("p"),fl.innerHTML=zs,ze=a(),U(gl.$$.fragment),Le=a(),_l=n("p"),_l.innerHTML=Ls,Oe=a(),Al=n("p"),Al.innerHTML=Os,qe=a(),U(El.$$.fragment),Pe=a(),Vl=n("p"),Vl.innerHTML=qs,Ke=a(),kl=n("ol"),kl.innerHTML=Ps,ls=a(),Ql=n("p"),Ql.textContent=Ks,es=a(),U(Bl.$$.fragment),ss=a(),Zl=n("p"),Zl.textContent=lt,ts=a(),Rl=n("table"),Rl.innerHTML=et,as=a(),U(xl.$$.fragment),Ms=a(),Gl=n("p"),this.h()},l(l){const e=it("svelte-u9bgzb",document.head);r=J(e,"META",{name:!0,content:!0}),e.forEach(s),Wl=M(l),Hl=J(l,"P",{}),st(Hl).forEach(s),vl=M(l),p(y.$$.fragment,l),Fl=M(l),u=J(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-kpdhh9"&&(u.innerHTML=Us),$l=M(l),I=J(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-dd17aw"&&(I.textContent=ps),Nl=M(l),b=J(l,"OL",{"data-svelte-h":!0}),i(b)!=="svelte-63hzai"&&(b.innerHTML=Ts),Yl=M(l),C=J(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1dzsptn"&&(C.textContent=cs),Sl=M(l),f=J(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-x5a9qo"&&(f.innerHTML=js),Dl=M(l),p(g.$$.fragment,l),Xl=M(l),_=J(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ga453m"&&(_.innerHTML=os),zl=M(l),A=J(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-u6tezb"&&(A.textContent=hs),Ll=M(l),p(E.$$.fragment,l),Ol=M(l),V=J(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-s9khbo"&&(V.innerHTML=ds),ql=M(l),p(k.$$.fragment,l),Pl=M(l),p(Q.$$.fragment,l),Kl=M(l),B=J(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1ow5q1r"&&(B.innerHTML=rs),le=M(l),p(Z.$$.fragment,l),ee=M(l),R=J(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1kj8dwl"&&(R.innerHTML=ms),se=M(l),p(x.$$.fragment,l),te=M(l),H=J(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1aczd25"&&(H.innerHTML=ws),ae=M(l),G=J(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-s4gw14"&&(G.innerHTML=ys),Me=M(l),W=J(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1d69wwb"&&(W.textContent=us),ne=M(l),v=J(l,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-1s12qdb"&&(v.innerHTML=Is),Je=M(l),F=J(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-uyr1qn"&&(F.innerHTML=bs),ie=M(l),p($.$$.fragment,l),Ue=M(l),N=J(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1qrmixw"&&(N.innerHTML=Cs),pe=M(l),Y=J(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-hi5exq"&&(Y.innerHTML=fs),Te=M(l),S=J(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1rh652p"&&(S.innerHTML=gs),ce=M(l),D=J(l,"OL",{"data-svelte-h":!0}),i(D)!=="svelte-1wlh5yr"&&(D.innerHTML=_s),je=M(l),X=J(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1ov3098"&&(X.innerHTML=As),oe=M(l),p(z.$$.fragment,l),he=M(l),L=J(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-21sbrb"&&(L.innerHTML=Es),de=M(l),p(O.$$.fragment,l),re=M(l),q=J(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-qw3191"&&(q.textContent=Vs),me=M(l),p(P.$$.fragment,l),we=M(l),p(K.$$.fragment,l),ye=M(l),ll=J(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1mj21jf"&&(ll.innerHTML=ks),ue=M(l),el=J(l,"OL",{"data-svelte-h":!0}),i(el)!=="svelte-1bzaux3"&&(el.innerHTML=Qs),Ie=M(l),p(sl.$$.fragment,l),be=M(l),m=J(l,"OL",{start:!0,"data-svelte-h":!0}),i(m)!=="svelte-1awrrl0"&&(m.innerHTML=Bs),Ce=M(l),p(tl.$$.fragment,l),fe=M(l),w=J(l,"OL",{start:!0,"data-svelte-h":!0}),i(w)!=="svelte-do6xpe"&&(w.innerHTML=Zs),ge=M(l),p(al.$$.fragment,l),_e=M(l),Ml=J(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-jxjuew"&&(Ml.textContent=Rs),Ae=M(l),p(nl.$$.fragment,l),Ee=M(l),Jl=J(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1dhzc96"&&(Jl.innerHTML=xs),Ve=M(l),p(il.$$.fragment,l),ke=M(l),Ul=J(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-lzimr2"&&(Ul.innerHTML=Hs),Qe=M(l),pl=J(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-w8mqv5"&&(pl.innerHTML=Gs),Be=M(l),p(Tl.$$.fragment,l),Ze=M(l),cl=J(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1405hjl"&&(cl.innerHTML=Ws),Re=M(l),jl=J(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-dp82ut"&&(jl.innerHTML=vs),xe=M(l),p(ol.$$.fragment,l),He=M(l),hl=J(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-b88p8t"&&(hl.innerHTML=Fs),Ge=M(l),p(dl.$$.fragment,l),We=M(l),p(rl.$$.fragment,l),ve=M(l),ml=J(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1x3bh2b"&&(ml.innerHTML=$s),Fe=M(l),wl=J(l,"OL",{"data-svelte-h":!0}),i(wl)!=="svelte-129pt2n"&&(wl.innerHTML=Ns),$e=M(l),yl=J(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1xm33x1"&&(yl.textContent=Ys),Ne=M(l),ul=J(l,"UL",{"data-svelte-h":!0}),i(ul)!=="svelte-217leq"&&(ul.innerHTML=Ss),Ye=M(l),Il=J(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-dyo5xu"&&(Il.textContent=Ds),Se=M(l),p(bl.$$.fragment,l),De=M(l),Cl=J(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-tsqe2x"&&(Cl.innerHTML=Xs),Xe=M(l),fl=J(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-pskjbf"&&(fl.innerHTML=zs),ze=M(l),p(gl.$$.fragment,l),Le=M(l),_l=J(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-h497zb"&&(_l.innerHTML=Ls),Oe=M(l),Al=J(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-mflaxo"&&(Al.innerHTML=Os),qe=M(l),p(El.$$.fragment,l),Pe=M(l),Vl=J(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-1lpr072"&&(Vl.innerHTML=qs),Ke=M(l),kl=J(l,"OL",{"data-svelte-h":!0}),i(kl)!=="svelte-1u7ar34"&&(kl.innerHTML=Ps),ls=M(l),Ql=J(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-8dfagu"&&(Ql.textContent=Ks),es=M(l),p(Bl.$$.fragment,l),ss=M(l),Zl=J(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-17m8u6l"&&(Zl.textContent=lt),ts=M(l),Rl=J(l,"TABLE",{"data-svelte-h":!0}),i(Rl)!=="svelte-1yd66vn"&&(Rl.innerHTML=et),as=M(l),p(xl.$$.fragment,l),Ms=M(l),Gl=J(l,"P",{}),st(Gl).forEach(s),this.h()},h(){Js(r,"name","hf:doc:metadata"),Js(r,"content",ct),Js(m,"start","2"),Js(w,"start","3")},m(l,e){Ut(document.head,r),t(l,Wl,e),t(l,Hl,e),t(l,vl,e),T(y,l,e),t(l,Fl,e),t(l,u,e),t(l,$l,e),t(l,I,e),t(l,Nl,e),t(l,b,e),t(l,Yl,e),t(l,C,e),t(l,Sl,e),t(l,f,e),t(l,Dl,e),T(g,l,e),t(l,Xl,e),t(l,_,e),t(l,zl,e),t(l,A,e),t(l,Ll,e),T(E,l,e),t(l,Ol,e),t(l,V,e),t(l,ql,e),T(k,l,e),t(l,Pl,e),T(Q,l,e),t(l,Kl,e),t(l,B,e),t(l,le,e),T(Z,l,e),t(l,ee,e),t(l,R,e),t(l,se,e),T(x,l,e),t(l,te,e),t(l,H,e),t(l,ae,e),t(l,G,e),t(l,Me,e),t(l,W,e),t(l,ne,e),t(l,v,e),t(l,Je,e),t(l,F,e),t(l,ie,e),T($,l,e),t(l,Ue,e),t(l,N,e),t(l,pe,e),t(l,Y,e),t(l,Te,e),t(l,S,e),t(l,ce,e),t(l,D,e),t(l,je,e),t(l,X,e),t(l,oe,e),T(z,l,e),t(l,he,e),t(l,L,e),t(l,de,e),T(O,l,e),t(l,re,e),t(l,q,e),t(l,me,e),T(P,l,e),t(l,we,e),T(K,l,e),t(l,ye,e),t(l,ll,e),t(l,ue,e),t(l,el,e),t(l,Ie,e),T(sl,l,e),t(l,be,e),t(l,m,e),t(l,Ce,e),T(tl,l,e),t(l,fe,e),t(l,w,e),t(l,ge,e),T(al,l,e),t(l,_e,e),t(l,Ml,e),t(l,Ae,e),T(nl,l,e),t(l,Ee,e),t(l,Jl,e),t(l,Ve,e),T(il,l,e),t(l,ke,e),t(l,Ul,e),t(l,Qe,e),t(l,pl,e),t(l,Be,e),T(Tl,l,e),t(l,Ze,e),t(l,cl,e),t(l,Re,e),t(l,jl,e),t(l,xe,e),T(ol,l,e),t(l,He,e),t(l,hl,e),t(l,Ge,e),T(dl,l,e),t(l,We,e),T(rl,l,e),t(l,ve,e),t(l,ml,e),t(l,Fe,e),t(l,wl,e),t(l,$e,e),t(l,yl,e),t(l,Ne,e),t(l,ul,e),t(l,Ye,e),t(l,Il,e),t(l,Se,e),T(bl,l,e),t(l,De,e),t(l,Cl,e),t(l,Xe,e),t(l,fl,e),t(l,ze,e),T(gl,l,e),t(l,Le,e),t(l,_l,e),t(l,Oe,e),t(l,Al,e),t(l,qe,e),T(El,l,e),t(l,Pe,e),t(l,Vl,e),t(l,Ke,e),t(l,kl,e),t(l,ls,e),t(l,Ql,e),t(l,es,e),T(Bl,l,e),t(l,ss,e),t(l,Zl,e),t(l,ts,e),t(l,Rl,e),t(l,as,e),T(xl,l,e),t(l,Ms,e),t(l,Gl,e),ns=!0},p:at,i(l){ns||(c(y.$$.fragment,l),c(g.$$.fragment,l),c(E.$$.fragment,l),c(k.$$.fragment,l),c(Q.$$.fragment,l),c(Z.$$.fragment,l),c(x.$$.fragment,l),c($.$$.fragment,l),c(z.$$.fragment,l),c(O.$$.fragment,l),c(P.$$.fragment,l),c(K.$$.fragment,l),c(sl.$$.fragment,l),c(tl.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(il.$$.fragment,l),c(Tl.$$.fragment,l),c(ol.$$.fragment,l),c(dl.$$.fragment,l),c(rl.$$.fragment,l),c(bl.$$.fragment,l),c(gl.$$.fragment,l),c(El.$$.fragment,l),c(Bl.$$.fragment,l),c(xl.$$.fragment,l),ns=!0)},o(l){j(y.$$.fragment,l),j(g.$$.fragment,l),j(E.$$.fragment,l),j(k.$$.fragment,l),j(Q.$$.fragment,l),j(Z.$$.fragment,l),j(x.$$.fragment,l),j($.$$.fragment,l),j(z.$$.fragment,l),j(O.$$.fragment,l),j(P.$$.fragment,l),j(K.$$.fragment,l),j(sl.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(nl.$$.fragment,l),j(il.$$.fragment,l),j(Tl.$$.fragment,l),j(ol.$$.fragment,l),j(dl.$$.fragment,l),j(rl.$$.fragment,l),j(bl.$$.fragment,l),j(gl.$$.fragment,l),j(El.$$.fragment,l),j(Bl.$$.fragment,l),j(xl.$$.fragment,l),ns=!1},d(l){l&&(s(Wl),s(Hl),s(vl),s(Fl),s(u),s($l),s(I),s(Nl),s(b),s(Yl),s(C),s(Sl),s(f),s(Dl),s(Xl),s(_),s(zl),s(A),s(Ll),s(Ol),s(V),s(ql),s(Pl),s(Kl),s(B),s(le),s(ee),s(R),s(se),s(te),s(H),s(ae),s(G),s(Me),s(W),s(ne),s(v),s(Je),s(F),s(ie),s(Ue),s(N),s(pe),s(Y),s(Te),s(S),s(ce),s(D),s(je),s(X),s(oe),s(he),s(L),s(de),s(re),s(q),s(me),s(we),s(ye),s(ll),s(ue),s(el),s(Ie),s(be),s(m),s(Ce),s(fe),s(w),s(ge),s(_e),s(Ml),s(Ae),s(Ee),s(Jl),s(Ve),s(ke),s(Ul),s(Qe),s(pl),s(Be),s(Ze),s(cl),s(Re),s(jl),s(xe),s(He),s(hl),s(Ge),s(We),s(ve),s(ml),s(Fe),s(wl),s($e),s(yl),s(Ne),s(ul),s(Ye),s(Il),s(Se),s(De),s(Cl),s(Xe),s(fl),s(ze),s(Le),s(_l),s(Oe),s(Al),s(qe),s(Pe),s(Vl),s(Ke),s(kl),s(ls),s(Ql),s(es),s(ss),s(Zl),s(ts),s(Rl),s(as),s(Ms),s(Gl)),s(r),o(y,l),o(g,l),o(E,l),o(k,l),o(Q,l),o(Z,l),o(x,l),o($,l),o(z,l),o(O,l),o(P,l),o(K,l),o(sl,l),o(tl,l),o(al,l),o(nl,l),o(il,l),o(Tl,l),o(ol,l),o(dl,l),o(rl,l),o(bl,l),o(gl,l),o(El,l),o(Bl,l),o(xl,l)}}}const ct='{"title":"Hub와 어떤 머신 러닝 프레임워크든 통합","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"유연한 접근 방식: 도우미(helper)","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"제한 사항","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"더욱 복잡한 접근법: 클래스 상속","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"자세한 예시: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"어떻게 사용하나요?","local":"how-to-use-it","sections":[],"depth":4},{"title":"구현","local":"implementation","sections":[],"depth":4}],"depth":3},{"title":"고급 사용법","local":"advanced-usage","sections":[{"title":"모델 카드","local":"model-card","sections":[],"depth":4},{"title":"구성","local":"config","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"빠른 비교","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function jt(is){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends nt{constructor(r){super(),Jt(this,r,jt,Tt,tt,{})}}export{mt as component};
