import{s as jt,n as wt,o as mt}from"../chunks/scheduler.f6319a2a.js";import{S as bt,i as dt,g as M,s as n,r as p,A as ht,h as o,f as s,c as a,j as ct,u as y,x as i,k as Tt,y as It,a as e,v as U,d as u,t as r,w as J}from"../chunks/index.85aa684c.js";import{C as c}from"../chunks/CodeBlock.97b48fd2.js";import{D as Ct}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as Vl,E as gt}from"../chunks/EditOnGithub.006048dd.js";function Bt(Hl){let T,el,tl,nl,j,al,w,Ml,m,Yl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",ol,b,Fl="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",il,d,zl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",pl,h,Ll="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",yl,I,Dl="Let’s build this agent! 💪",Ul,C,Pl="Run the line below to install required dependencies:",ul,g,rl,B,Kl=`To call the HF Inference API, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,Jl,f,cl,Q,Ol="Then, we setup the SQL environment:",Tl,q,jl,v,wl,W,lt="Now let’s make our SQL table retrievable by a tool.",ml,Z,tt="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",bl,S,dl,_,hl,k,st='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',Il,A,et="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",Cl,G,gl,N,nt="Now let us create an agent that leverages this tool.",Bl,R,at="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",fl,E,Mt="The model is the LLM that powers the agent system. <code>HfApiModel</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",Ql,X,ql,x,vl,$,ot="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Wl,V,it="So let’s make a second table recording the names of waiters for each receipt_id!",Zl,H,Sl,Y,pt="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",_l,F,kl,z,yt='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',Al,L,Gl,D,Ut="It directly works! The setup was surprisingly simple, wasn’t it?",Nl,P,ut="This example is done! We’ve touched upon these concepts:",Rl,K,rt="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",El,O,Jt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Xl,ll,xl,sl,$l;return j=new Vl({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),w=new Ct({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),g=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHl0aG9uLWRvdGVudiUyMHNxbGFsY2hlbXklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents python-dotenv sqlalchemy --upgrade -q",wrap:!1}}),f=new c({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),q=new c({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBZGVmJTIwaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwdGFibGUlMkMlMjBlbmdpbmUlM0RlbmdpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwcm93JTIwaW4lMjByb3dzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RtdCUyMCUzRCUyMGluc2VydCh0YWJsZSkudmFsdWVzKCoqcm93KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBlbmdpbmUuYmVnaW4oKSUyMGFzJTIwY29ubmVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbm5lY3Rpb24uZXhlY3V0ZShzdG10KSUwQSUwQXRhYmxlX25hbWUlMjAlM0QlMjAlMjJyZWNlaXB0cyUyMiUwQXJlY2VpcHRzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyY3VzdG9tZXJfbmFtZSUyMiUyQyUyMFN0cmluZygxNiklMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnByaWNlJTIyJTJDJTIwRmxvYXQpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnRpcCUyMiUyQyUyMEZsb2F0KSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFpbnNlcnRfcm93c19pbnRvX3RhYmxlKHJvd3MlMkMlMjByZWNlaXB0cyk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">insert_rows_into_table</span>(<span class="hljs-params">rows, table, engine=engine</span>):
    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
        stmt = insert(table).values(**row)
        <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
            connection.execute(stmt)

table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
insert_rows_into_table(rows, receipts)`,wrap:!1}}),v=new Vl({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),S=new c({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),_=new c({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),G=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),X=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzcWxfZW5naW5lJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RIZkFwaU1vZGVsKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),x=new Vl({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),H=new c({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEF3YWl0ZXJzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyd2FpdGVyX25hbWUlMjIlMkMlMjBTdHJpbmcoMTYpJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJDb3JleSUyMEpvaG5zb24lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMiUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWljaGFlbCUyMFdhdHRzJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDMlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjA0JTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTdEJTJDJTBBJTVEJTBBaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwd2FpdGVycyk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
waiters = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
insert_rows_into_table(rows, waiters)`,wrap:!1}}),F=new c({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),L=new c({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),ll=new gt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.mdx"}}),{c(){T=M("meta"),el=n(),tl=M("p"),nl=n(),p(j.$$.fragment),al=n(),p(w.$$.fragment),Ml=n(),m=M("p"),m.innerHTML=Yl,ol=n(),b=M("blockquote"),b.innerHTML=Fl,il=n(),d=M("p"),d.textContent=zl,pl=n(),h=M("p"),h.textContent=Ll,yl=n(),I=M("p"),I.textContent=Dl,Ul=n(),C=M("p"),C.textContent=Pl,ul=n(),p(g.$$.fragment),rl=n(),B=M("p"),B.innerHTML=Kl,Jl=n(),p(f.$$.fragment),cl=n(),Q=M("p"),Q.textContent=Ol,Tl=n(),p(q.$$.fragment),jl=n(),p(v.$$.fragment),wl=n(),W=M("p"),W.textContent=lt,ml=n(),Z=M("p"),Z.textContent=tt,bl=n(),p(S.$$.fragment),dl=n(),p(_.$$.fragment),hl=n(),k=M("p"),k.innerHTML=st,Il=n(),A=M("ul"),A.innerHTML=et,Cl=n(),p(G.$$.fragment),gl=n(),N=M("p"),N.textContent=nt,Bl=n(),R=M("p"),R.innerHTML=at,fl=n(),E=M("p"),E.innerHTML=Mt,Ql=n(),p(X.$$.fragment),ql=n(),p(x.$$.fragment),vl=n(),$=M("p"),$.textContent=ot,Wl=n(),V=M("p"),V.textContent=it,Zl=n(),p(H.$$.fragment),Sl=n(),Y=M("p"),Y.innerHTML=pt,_l=n(),p(F.$$.fragment),kl=n(),z=M("p"),z.innerHTML=yt,Al=n(),p(L.$$.fragment),Gl=n(),D=M("p"),D.textContent=Ut,Nl=n(),P=M("p"),P.textContent=ut,Rl=n(),K=M("ul"),K.innerHTML=rt,El=n(),O=M("p"),O.textContent=Jt,Xl=n(),p(ll.$$.fragment),xl=n(),sl=M("p"),this.h()},l(l){const t=ht("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),el=a(l),tl=o(l,"P",{}),ct(tl).forEach(s),nl=a(l),y(j.$$.fragment,l),al=a(l),y(w.$$.fragment,l),Ml=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1rrh2b0"&&(m.innerHTML=Yl),ol=a(l),b=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-1yhwgse"&&(b.innerHTML=Fl),il=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1hw7g6s"&&(d.textContent=zl),pl=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-i6rawm"&&(h.textContent=Ll),yl=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1tzrwc8"&&(I.textContent=Dl),Ul=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-16cuoal"&&(C.textContent=Pl),ul=a(l),y(g.$$.fragment,l),rl=a(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1gx6n4r"&&(B.innerHTML=Kl),Jl=a(l),y(f.$$.fragment,l),cl=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-64yurm"&&(Q.textContent=Ol),Tl=a(l),y(q.$$.fragment,l),jl=a(l),y(v.$$.fragment,l),wl=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-fdu5cw"&&(W.textContent=lt),ml=a(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-groxlc"&&(Z.textContent=tt),bl=a(l),y(S.$$.fragment,l),dl=a(l),y(_.$$.fragment,l),hl=a(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1snt6vj"&&(k.innerHTML=st),Il=a(l),A=o(l,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-idbd3h"&&(A.innerHTML=et),Cl=a(l),y(G.$$.fragment,l),gl=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1t4r7cu"&&(N.textContent=nt),Bl=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-sv1k2f"&&(R.innerHTML=at),fl=a(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1krfyi9"&&(E.innerHTML=Mt),Ql=a(l),y(X.$$.fragment,l),ql=a(l),y(x.$$.fragment,l),vl=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-nr3fl7"&&($.textContent=ot),Wl=a(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1ru0803"&&(V.textContent=it),Zl=a(l),y(H.$$.fragment,l),Sl=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-l5upel"&&(Y.innerHTML=pt),_l=a(l),y(F.$$.fragment,l),kl=a(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1uns4lf"&&(z.innerHTML=yt),Al=a(l),y(L.$$.fragment,l),Gl=a(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1umn140"&&(D.textContent=Ut),Nl=a(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13g6phr"&&(P.textContent=ut),Rl=a(l),K=o(l,"UL",{"data-svelte-h":!0}),i(K)!=="svelte-1pz5sot"&&(K.innerHTML=rt),El=a(l),O=o(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-bt1f1w"&&(O.textContent=Jt),Xl=a(l),y(ll.$$.fragment,l),xl=a(l),sl=o(l,"P",{}),ct(sl).forEach(s),this.h()},h(){Tt(T,"name","hf:doc:metadata"),Tt(T,"content",ft)},m(l,t){It(document.head,T),e(l,el,t),e(l,tl,t),e(l,nl,t),U(j,l,t),e(l,al,t),U(w,l,t),e(l,Ml,t),e(l,m,t),e(l,ol,t),e(l,b,t),e(l,il,t),e(l,d,t),e(l,pl,t),e(l,h,t),e(l,yl,t),e(l,I,t),e(l,Ul,t),e(l,C,t),e(l,ul,t),U(g,l,t),e(l,rl,t),e(l,B,t),e(l,Jl,t),U(f,l,t),e(l,cl,t),e(l,Q,t),e(l,Tl,t),U(q,l,t),e(l,jl,t),U(v,l,t),e(l,wl,t),e(l,W,t),e(l,ml,t),e(l,Z,t),e(l,bl,t),U(S,l,t),e(l,dl,t),U(_,l,t),e(l,hl,t),e(l,k,t),e(l,Il,t),e(l,A,t),e(l,Cl,t),U(G,l,t),e(l,gl,t),e(l,N,t),e(l,Bl,t),e(l,R,t),e(l,fl,t),e(l,E,t),e(l,Ql,t),U(X,l,t),e(l,ql,t),U(x,l,t),e(l,vl,t),e(l,$,t),e(l,Wl,t),e(l,V,t),e(l,Zl,t),U(H,l,t),e(l,Sl,t),e(l,Y,t),e(l,_l,t),U(F,l,t),e(l,kl,t),e(l,z,t),e(l,Al,t),U(L,l,t),e(l,Gl,t),e(l,D,t),e(l,Nl,t),e(l,P,t),e(l,Rl,t),e(l,K,t),e(l,El,t),e(l,O,t),e(l,Xl,t),U(ll,l,t),e(l,xl,t),e(l,sl,t),$l=!0},p:wt,i(l){$l||(u(j.$$.fragment,l),u(w.$$.fragment,l),u(g.$$.fragment,l),u(f.$$.fragment,l),u(q.$$.fragment,l),u(v.$$.fragment,l),u(S.$$.fragment,l),u(_.$$.fragment,l),u(G.$$.fragment,l),u(X.$$.fragment,l),u(x.$$.fragment,l),u(H.$$.fragment,l),u(F.$$.fragment,l),u(L.$$.fragment,l),u(ll.$$.fragment,l),$l=!0)},o(l){r(j.$$.fragment,l),r(w.$$.fragment,l),r(g.$$.fragment,l),r(f.$$.fragment,l),r(q.$$.fragment,l),r(v.$$.fragment,l),r(S.$$.fragment,l),r(_.$$.fragment,l),r(G.$$.fragment,l),r(X.$$.fragment,l),r(x.$$.fragment,l),r(H.$$.fragment,l),r(F.$$.fragment,l),r(L.$$.fragment,l),r(ll.$$.fragment,l),$l=!1},d(l){l&&(s(el),s(tl),s(nl),s(al),s(Ml),s(m),s(ol),s(b),s(il),s(d),s(pl),s(h),s(yl),s(I),s(Ul),s(C),s(ul),s(rl),s(B),s(Jl),s(cl),s(Q),s(Tl),s(jl),s(wl),s(W),s(ml),s(Z),s(bl),s(dl),s(hl),s(k),s(Il),s(A),s(Cl),s(gl),s(N),s(Bl),s(R),s(fl),s(E),s(Ql),s(ql),s(vl),s($),s(Wl),s(V),s(Zl),s(Sl),s(Y),s(_l),s(kl),s(z),s(Al),s(Gl),s(D),s(Nl),s(P),s(Rl),s(K),s(El),s(O),s(Xl),s(xl),s(sl)),s(T),J(j,l),J(w,l),J(g,l),J(f,l),J(q,l),J(v,l),J(S,l),J(_,l),J(G,l),J(X,l),J(x,l),J(H,l),J(F,l),J(L,l),J(ll,l)}}}const ft='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function Qt(Hl){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends bt{constructor(T){super(),dt(this,T,Qt,Bt,jt,{})}}export{_t as component};
