import{s as rr,n as ar,o as or}from"../chunks/scheduler.85c25b89.js";import{S as sr,i as lr,g as s,s as a,r as c,A as ir,h as l,f as n,c as o,j as w,u as m,x as d,k as b,l as dr,y as i,a as r,v as h,d as g,t as u,w as f}from"../chunks/index.c9bcf812.js";import{D as y}from"../chunks/Docstring.46c9d080.js";import{C as v}from"../chunks/CodeBlock.94efc595.js";import{H as Z,E as pr}from"../chunks/EditOnGithub.ec73e7c7.js";function cr(Mn){let _,Qe,Ee,Se,B,De,q,vn='TRL supports the <a href="https://arxiv.org/abs/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',Ye,L,Jn='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',Ke,H,et,G,Pn="Fine-tuning a language model via PPO consists of roughly three steps:",tt,W,$n="<li><strong>Rollout</strong>: The language model generates a response or continuation based on query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",nt,V,In="This process is illustrated in the sketch below:",rt,J,xn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png" width="800"/> <p style="text-align: center;"><b>Figure:</b> Sketch of the workflow.</p>',at,R,ot,A,Un="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",st,N,jn="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",lt,E,Cn='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',it,X,dt,Q,kn="Resulting in the following subset of the dataset:",pt,S,ct,D,mt,Y,zn='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',ht,K,gt,ee,Fn="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",ut,te,ft,ne,On="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",Tt,re,wt,ae,Zn="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",bt,oe,yt,se,Bn="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",_t,le,Mt,ie,qn="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",vt,de,Jt,pe,Pt,ce,Ln="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",$t,me,Hn='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',It,he,xt,ge,Gn="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",Ut,ue,jt,fe,Ct,Te,Wn="While training and evaluating we log the following metrics:",kt,we,Vn="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",zt,be,Ft,p,ye,Dt,Fe,Rn=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Yt,P,_e,Kt,Oe,An="Calculate model outputs in multiple batches.",en,$,Me,tn,Ze,Nn="Compute per token rewards from scores and KL-penalty.",nn,I,ve,rn,Be,En="Creates and saves a model card for a TRL model.",an,x,Je,on,qe,Xn="Gather stats from all processes. Useful in the context of distributed training.",sn,U,Pe,ln,Le,Qn=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,dn,j,$e,pn,He,Sn="A function that logs all the training stats. Call it at the end of each epoch.",cn,C,Ie,mn,Ge,Dn="Calculate policy and value losses.",hn,k,xe,gn,We,Yn="Prepare the dataloader for training.",un,z,Ue,fn,Ve,Kn="Record training step statistics.",Tn,F,je,wn,Re,er="Run a PPO optimisation step given a list of queries, model responses, and rewards.",bn,O,Ce,yn,Ae,tr="Train one PPO minibatch",Ot,M,ke,_n,Ne,nr="Configuration class for PPOTrainer",Zt,ze,Bt,Xe,qt;return B=new Z({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),H=new Z({props:{title:"How PPO works",local:"how-ppo-works",headingTag:"h2"}}),R=new Z({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),X=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),S=new v({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),D=new Z({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),K=new Z({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),te=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),re=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),oe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),le=new v({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),de=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    dataset=dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),pe=new Z({props:{title:"Starting the training loop",local:"starting-the-training-loop",headingTag:"h3"}}),he=new v({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),ue=new v({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBJTBBZXBvY2hzJTIwJTNEJTIwMTAlMEFmb3IlMjBlcG9jaCUyMGluJTIwdHFkbShyYW5nZShlcG9jaHMpJTJDJTIwJTIyZXBvY2glM0ElMjAlMjIpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRxZG0ocHBvX3RyYWluZXIuZGF0YWxvYWRlciklM0ElMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV90ZW5zb3JzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjMlMjMlMjBHZXQlMjByZXNwb25zZSUyMGZyb20lMjBTRlRNb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbnNvcnMlMjAlM0QlMjBwcG9fdHJhaW5lci5nZW5lcmF0ZShxdWVyeV90ZW5zb3JzJTJDJTIwKipnZW5lcmF0aW9uX2t3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLmRlY29kZShyLnNxdWVlemUoKSklMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZV90ZW5zb3JzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwQ29tcHV0ZSUyMHJld2FyZCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwcmV3YXJkX21vZGVsKHRleHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMSU1RCU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMG91dHB1dCUyMGluJTIwcGlwZV9vdXRwdXRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwUnVuJTIwUFBPJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRzJTIwJTNEJTIwcHBvX3RyYWluZXIuc3RlcChxdWVyeV90ZW5zb3JzJTJDJTIwcmVzcG9uc2VfdGVuc29ycyUyQyUyMHJld2FyZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHBvX3RyYWluZXIubG9nX3N0YXRzKHN0YXRzJTJDJTIwYmF0Y2glMkMlMjByZXdhcmRzKSUwQSUwQSUyMyUyMyUyMyUyMyUyMFNhdmUlMjBtb2RlbCUwQXBwb190cmFpbmVyLnNhdmVfcHJldHJhaW5lZCglMjJteV9wcG9fbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm


epochs = <span class="hljs-number">10</span>
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(epochs), <span class="hljs-string">&quot;epoch: &quot;</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tqdm(ppo_trainer.dataloader): 
        query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
    
        <span class="hljs-comment">#### Get response from SFTModel</span>
        response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
        batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]
    
        <span class="hljs-comment">#### Compute reward score</span>
        texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
        pipe_outputs = reward_model(texts)
        rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]
    
        <span class="hljs-comment">#### Run PPO step</span>
        stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
        ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_pretrained(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),fe=new Z({props:{title:"Logging",local:"logging",headingTag:"h2"}}),be=new Z({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ye=new y({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"},{name:"training_data_collator",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L114"}}),_e=new y({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Me=new y({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ve=new y({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1411"}}),Je=new y({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Pe=new y({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L455",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),$e=new y({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1338"}}),Ie=new y({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1185"}}),xe=new y({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L400",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Ue=new y({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),je=new y({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ce=new y({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_trainer.py#L1057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),ke=new y({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/vr_1794/trl/trainer/ppo_config.py#L34"}}),ze=new pr({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/ppo_trainer.mdx"}}),{c(){_=s("meta"),Qe=a(),Ee=s("p"),Se=a(),c(B.$$.fragment),De=a(),q=s("p"),q.innerHTML=vn,Ye=a(),L=s("p"),L.innerHTML=Jn,Ke=a(),c(H.$$.fragment),et=a(),G=s("p"),G.textContent=Pn,tt=a(),W=s("ol"),W.innerHTML=$n,nt=a(),V=s("p"),V.textContent=In,rt=a(),J=s("div"),J.innerHTML=xn,at=a(),c(R.$$.fragment),ot=a(),A=s("p"),A.innerHTML=Un,st=a(),N=s("p"),N.innerHTML=jn,lt=a(),E=s("p"),E.innerHTML=Cn,it=a(),c(X.$$.fragment),dt=a(),Q=s("p"),Q.textContent=kn,pt=a(),c(S.$$.fragment),ct=a(),c(D.$$.fragment),mt=a(),Y=s("p"),Y.innerHTML=zn,ht=a(),c(K.$$.fragment),gt=a(),ee=s("p"),ee.innerHTML=Fn,ut=a(),c(te.$$.fragment),ft=a(),ne=s("p"),ne.textContent=On,Tt=a(),c(re.$$.fragment),wt=a(),ae=s("p"),ae.innerHTML=Zn,bt=a(),c(oe.$$.fragment),yt=a(),se=s("p"),se.innerHTML=Bn,_t=a(),c(le.$$.fragment),Mt=a(),ie=s("p"),ie.innerHTML=qn,vt=a(),c(de.$$.fragment),Jt=a(),c(pe.$$.fragment),Pt=a(),ce=s("p"),ce.innerHTML=Ln,$t=a(),me=s("p"),me.innerHTML=Hn,It=a(),c(he.$$.fragment),xt=a(),ge=s("p"),ge.innerHTML=Gn,Ut=a(),c(ue.$$.fragment),jt=a(),c(fe.$$.fragment),Ct=a(),Te=s("p"),Te.textContent=Wn,kt=a(),we=s("ul"),we.innerHTML=Vn,zt=a(),c(be.$$.fragment),Ft=a(),p=s("div"),c(ye.$$.fragment),Dt=a(),Fe=s("p"),Fe.innerHTML=Rn,Yt=a(),P=s("div"),c(_e.$$.fragment),Kt=a(),Oe=s("p"),Oe.textContent=An,en=a(),$=s("div"),c(Me.$$.fragment),tn=a(),Ze=s("p"),Ze.textContent=Nn,nn=a(),I=s("div"),c(ve.$$.fragment),rn=a(),Be=s("p"),Be.textContent=En,an=a(),x=s("div"),c(Je.$$.fragment),on=a(),qe=s("p"),qe.textContent=Xn,sn=a(),U=s("div"),c(Pe.$$.fragment),ln=a(),Le=s("p"),Le.innerHTML=Qn,dn=a(),j=s("div"),c($e.$$.fragment),pn=a(),He=s("p"),He.textContent=Sn,cn=a(),C=s("div"),c(Ie.$$.fragment),mn=a(),Ge=s("p"),Ge.textContent=Dn,hn=a(),k=s("div"),c(xe.$$.fragment),gn=a(),We=s("p"),We.textContent=Yn,un=a(),z=s("div"),c(Ue.$$.fragment),fn=a(),Ve=s("p"),Ve.textContent=Kn,Tn=a(),F=s("div"),c(je.$$.fragment),wn=a(),Re=s("p"),Re.textContent=er,bn=a(),O=s("div"),c(Ce.$$.fragment),yn=a(),Ae=s("p"),Ae.textContent=tr,Ot=a(),M=s("div"),c(ke.$$.fragment),_n=a(),Ne=s("p"),Ne.textContent=nr,Zt=a(),c(ze.$$.fragment),Bt=a(),Xe=s("p"),this.h()},l(e){const t=ir("svelte-u9bgzb",document.head);_=l(t,"META",{name:!0,content:!0}),t.forEach(n),Qe=o(e),Ee=l(e,"P",{}),w(Ee).forEach(n),Se=o(e),m(B.$$.fragment,e),De=o(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1ulw62x"&&(q.innerHTML=vn),Ye=o(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1c2evbn"&&(L.innerHTML=Jn),Ke=o(e),m(H.$$.fragment,e),et=o(e),G=l(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-79li59"&&(G.textContent=Pn),tt=o(e),W=l(e,"OL",{"data-svelte-h":!0}),d(W)!=="svelte-19gvbbs"&&(W.innerHTML=$n),nt=o(e),V=l(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-11407q1"&&(V.textContent=In),rt=o(e),J=l(e,"DIV",{style:!0,"data-svelte-h":!0}),d(J)!=="svelte-7jo56"&&(J.innerHTML=xn),at=o(e),m(R.$$.fragment,e),ot=o(e),A=l(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-r47fon"&&(A.innerHTML=Un),st=o(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-nw9p0e"&&(N.innerHTML=jn),lt=o(e),E=l(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-ew3j45"&&(E.innerHTML=Cn),it=o(e),m(X.$$.fragment,e),dt=o(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1lutirw"&&(Q.textContent=kn),pt=o(e),m(S.$$.fragment,e),ct=o(e),m(D.$$.fragment,e),mt=o(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-kuth75"&&(Y.innerHTML=zn),ht=o(e),m(K.$$.fragment,e),gt=o(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-15i9f61"&&(ee.innerHTML=Fn),ut=o(e),m(te.$$.fragment,e),ft=o(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-ft92fq"&&(ne.textContent=On),Tt=o(e),m(re.$$.fragment,e),wt=o(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-5saaij"&&(ae.innerHTML=Zn),bt=o(e),m(oe.$$.fragment,e),yt=o(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1tdshp6"&&(se.innerHTML=Bn),_t=o(e),m(le.$$.fragment,e),Mt=o(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1dqo05b"&&(ie.innerHTML=qn),vt=o(e),m(de.$$.fragment,e),Jt=o(e),m(pe.$$.fragment,e),Pt=o(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1gfcgdl"&&(ce.innerHTML=Ln),$t=o(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-xqje4x"&&(me.innerHTML=Hn),It=o(e),m(he.$$.fragment,e),xt=o(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-jd50df"&&(ge.innerHTML=Gn),Ut=o(e),m(ue.$$.fragment,e),jt=o(e),m(fe.$$.fragment,e),Ct=o(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1jybr47"&&(Te.textContent=Wn),kt=o(e),we=l(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-1qs2o7q"&&(we.innerHTML=Vn),zt=o(e),m(be.$$.fragment,e),Ft=o(e),p=l(e,"DIV",{class:!0});var T=w(p);m(ye.$$.fragment,T),Dt=o(T),Fe=l(T,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-hys9rl"&&(Fe.innerHTML=Rn),Yt=o(T),P=l(T,"DIV",{class:!0});var Lt=w(P);m(_e.$$.fragment,Lt),Kt=o(Lt),Oe=l(Lt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-185nst0"&&(Oe.textContent=An),Lt.forEach(n),en=o(T),$=l(T,"DIV",{class:!0});var Ht=w($);m(Me.$$.fragment,Ht),tn=o(Ht),Ze=l(Ht,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-3nt516"&&(Ze.textContent=Nn),Ht.forEach(n),nn=o(T),I=l(T,"DIV",{class:!0});var Gt=w(I);m(ve.$$.fragment,Gt),rn=o(Gt),Be=l(Gt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-3jfrz9"&&(Be.textContent=En),Gt.forEach(n),an=o(T),x=l(T,"DIV",{class:!0});var Wt=w(x);m(Je.$$.fragment,Wt),on=o(Wt),qe=l(Wt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-lcc1u3"&&(qe.textContent=Xn),Wt.forEach(n),sn=o(T),U=l(T,"DIV",{class:!0});var Vt=w(U);m(Pe.$$.fragment,Vt),ln=o(Vt),Le=l(Vt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1gqqzmu"&&(Le.innerHTML=Qn),Vt.forEach(n),dn=o(T),j=l(T,"DIV",{class:!0});var Rt=w(j);m($e.$$.fragment,Rt),pn=o(Rt),He=l(Rt,"P",{"data-svelte-h":!0}),d(He)!=="svelte-ffqz5"&&(He.textContent=Sn),Rt.forEach(n),cn=o(T),C=l(T,"DIV",{class:!0});var At=w(C);m(Ie.$$.fragment,At),mn=o(At),Ge=l(At,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-febvhf"&&(Ge.textContent=Dn),At.forEach(n),hn=o(T),k=l(T,"DIV",{class:!0});var Nt=w(k);m(xe.$$.fragment,Nt),gn=o(Nt),We=l(Nt,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1hbodkw"&&(We.textContent=Yn),Nt.forEach(n),un=o(T),z=l(T,"DIV",{class:!0});var Et=w(z);m(Ue.$$.fragment,Et),fn=o(Et),Ve=l(Et,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1hfgx92"&&(Ve.textContent=Kn),Et.forEach(n),Tn=o(T),F=l(T,"DIV",{class:!0});var Xt=w(F);m(je.$$.fragment,Xt),wn=o(Xt),Re=l(Xt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-yrsdu6"&&(Re.textContent=er),Xt.forEach(n),bn=o(T),O=l(T,"DIV",{class:!0});var Qt=w(O);m(Ce.$$.fragment,Qt),yn=o(Qt),Ae=l(Qt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-3k7k5e"&&(Ae.textContent=tr),Qt.forEach(n),T.forEach(n),Ot=o(e),M=l(e,"DIV",{class:!0});var St=w(M);m(ke.$$.fragment,St),_n=o(St),Ne=l(St,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-aondqr"&&(Ne.textContent=nr),St.forEach(n),Zt=o(e),m(ze.$$.fragment,e),Bt=o(e),Xe=l(e,"P",{}),w(Xe).forEach(n),this.h()},h(){b(_,"name","hf:doc:metadata"),b(_,"content",mr),dr(J,"text-align","center"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,_),r(e,Qe,t),r(e,Ee,t),r(e,Se,t),h(B,e,t),r(e,De,t),r(e,q,t),r(e,Ye,t),r(e,L,t),r(e,Ke,t),h(H,e,t),r(e,et,t),r(e,G,t),r(e,tt,t),r(e,W,t),r(e,nt,t),r(e,V,t),r(e,rt,t),r(e,J,t),r(e,at,t),h(R,e,t),r(e,ot,t),r(e,A,t),r(e,st,t),r(e,N,t),r(e,lt,t),r(e,E,t),r(e,it,t),h(X,e,t),r(e,dt,t),r(e,Q,t),r(e,pt,t),h(S,e,t),r(e,ct,t),h(D,e,t),r(e,mt,t),r(e,Y,t),r(e,ht,t),h(K,e,t),r(e,gt,t),r(e,ee,t),r(e,ut,t),h(te,e,t),r(e,ft,t),r(e,ne,t),r(e,Tt,t),h(re,e,t),r(e,wt,t),r(e,ae,t),r(e,bt,t),h(oe,e,t),r(e,yt,t),r(e,se,t),r(e,_t,t),h(le,e,t),r(e,Mt,t),r(e,ie,t),r(e,vt,t),h(de,e,t),r(e,Jt,t),h(pe,e,t),r(e,Pt,t),r(e,ce,t),r(e,$t,t),r(e,me,t),r(e,It,t),h(he,e,t),r(e,xt,t),r(e,ge,t),r(e,Ut,t),h(ue,e,t),r(e,jt,t),h(fe,e,t),r(e,Ct,t),r(e,Te,t),r(e,kt,t),r(e,we,t),r(e,zt,t),h(be,e,t),r(e,Ft,t),r(e,p,t),h(ye,p,null),i(p,Dt),i(p,Fe),i(p,Yt),i(p,P),h(_e,P,null),i(P,Kt),i(P,Oe),i(p,en),i(p,$),h(Me,$,null),i($,tn),i($,Ze),i(p,nn),i(p,I),h(ve,I,null),i(I,rn),i(I,Be),i(p,an),i(p,x),h(Je,x,null),i(x,on),i(x,qe),i(p,sn),i(p,U),h(Pe,U,null),i(U,ln),i(U,Le),i(p,dn),i(p,j),h($e,j,null),i(j,pn),i(j,He),i(p,cn),i(p,C),h(Ie,C,null),i(C,mn),i(C,Ge),i(p,hn),i(p,k),h(xe,k,null),i(k,gn),i(k,We),i(p,un),i(p,z),h(Ue,z,null),i(z,fn),i(z,Ve),i(p,Tn),i(p,F),h(je,F,null),i(F,wn),i(F,Re),i(p,bn),i(p,O),h(Ce,O,null),i(O,yn),i(O,Ae),r(e,Ot,t),r(e,M,t),h(ke,M,null),i(M,_n),i(M,Ne),r(e,Zt,t),h(ze,e,t),r(e,Bt,t),r(e,Xe,t),qt=!0},p:ar,i(e){qt||(g(B.$$.fragment,e),g(H.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(re.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(_e.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g($e.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(ze.$$.fragment,e),qt=!0)},o(e){u(B.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(Me.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(Pe.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(ze.$$.fragment,e),qt=!1},d(e){e&&(n(Qe),n(Ee),n(Se),n(De),n(q),n(Ye),n(L),n(Ke),n(et),n(G),n(tt),n(W),n(nt),n(V),n(rt),n(J),n(at),n(ot),n(A),n(st),n(N),n(lt),n(E),n(it),n(dt),n(Q),n(pt),n(ct),n(mt),n(Y),n(ht),n(gt),n(ee),n(ut),n(ft),n(ne),n(Tt),n(wt),n(ae),n(bt),n(yt),n(se),n(_t),n(Mt),n(ie),n(vt),n(Jt),n(Pt),n(ce),n($t),n(me),n(It),n(xt),n(ge),n(Ut),n(jt),n(Ct),n(Te),n(kt),n(we),n(zt),n(Ft),n(p),n(Ot),n(M),n(Zt),n(Bt),n(Xe)),n(_),f(B,e),f(H,e),f(R,e),f(X,e),f(S,e),f(D,e),f(K,e),f(te,e),f(re,e),f(oe,e),f(le,e),f(de,e),f(pe,e),f(he,e),f(ue,e),f(fe,e),f(be,e),f(ye),f(_e),f(Me),f(ve),f(Je),f(Pe),f($e),f(Ie),f(xe),f(Ue),f(je),f(Ce),f(ke),f(ze,e)}}}const mr='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"How PPO works","local":"how-ppo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3},{"title":"Starting the training loop","local":"starting-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2}],"depth":1}';function hr(Mn){return or(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class br extends sr{constructor(_){super(),lr(this,_,hr,cr,rr,{})}}export{br as component};
