import{s as yt,o as xt,n as oe}from"../chunks/scheduler.6062bdaf.js";import{S as Jt,i as zt,g as d,s as i,r as m,A as It,h,f as a,c as o,j as ne,u as f,x as w,k as ie,y as c,a as r,v as g,d as u,t as $,w as b}from"../chunks/index.4bca734e.js";import{T as we}from"../chunks/Tip.b9ac1f03.js";import{D as Te}from"../chunks/Docstring.d7918b6d.js";import{C as jt}from"../chunks/CodeBlock.fa01571c.js";import{E as Mt}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as S,E as Gt}from"../chunks/EditOnGithub.74ab2baa.js";function Bt(j){let t,_=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=_},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-16sq104"&&(t.innerHTML=_)},m(n,p){r(n,t,p)},p:oe,d(n){n&&a(t)}}}function At(j){let t,_="Example:",n,p,T;return p=new jt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNhdmVfdG9yY2hfc3RhdGVfZGljdCUwQW1vZGVsJTIwJTNEJTIwLi4uJTIwJTIzJTIwQSUyMFB5VG9yY2glMjBtb2RlbCUwQSUwQXN0YXRlX2RpY3QlMjAlM0QlMjBtb2RlbF90b19zYXZlLnN0YXRlX2RpY3QoKSUwQXNhdmVfdG9yY2hfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> save_torch_state_dict
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ... <span class="hljs-comment"># A PyTorch model</span>

<span class="hljs-comment"># Save state dict to &quot;path/to/folder&quot;. The model will be split into shards of 5GB each and saved as safetensors.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = model_to_save.state_dict()
<span class="hljs-meta">&gt;&gt;&gt; </span>save_torch_state_dict(state_dict, <span class="hljs-string">&quot;path/to/folder&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=_,n=i(),m(p.$$.fragment)},l(l){t=h(l,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=_),n=o(l),f(p.$$.fragment,l)},m(l,y){r(l,t,y),r(l,n,y),g(p,l,y),T=!0},p:oe,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){$(p.$$.fragment,l),T=!1},d(l){l&&(a(t),a(n)),b(p,l)}}}function kt(j){let t,_=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=_},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-16sq104"&&(t.innerHTML=_)},m(n,p){r(n,t,p)},p:oe,d(n){n&&a(t)}}}function Ct(j){let t,_=`To save a model state dictionary to the disk, see <a href="/docs/huggingface_hub/pr_2342/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a>. This helper uses
<code>split_torch_state_dict_into_shards</code> under the hood.`;return{c(){t=d("p"),t.innerHTML=_},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-19g502j"&&(t.innerHTML=_)},m(n,p){r(n,t,p)},p:oe,d(n){n&&a(t)}}}function Zt(j){let t,_=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=_},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-16sq104"&&(t.innerHTML=_)},m(n,p){r(n,t,p)},p:oe,d(n){n&&a(t)}}}function Rt(j){let t,_="Example:",n,p,T;return p=new jt({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwc2F2ZV9maWxlJTIwYXMlMjBzYWZlX3NhdmVfZmlsZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBzcGxpdF90b3JjaF9zdGF0ZV9kaWN0X2ludG9fc2hhcmRzJTBBJTBBZGVmJTIwc2F2ZV9zdGF0ZV9kaWN0KHN0YXRlX2RpY3QlM0ElMjBEaWN0JTVCc3RyJTJDJTIwdG9yY2guVGVuc29yJTVEJTJDJTIwc2F2ZV9kaXJlY3RvcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9zcGxpdCUyMCUzRCUyMHNwbGl0X3RvcmNoX3N0YXRlX2RpY3RfaW50b19zaGFyZHMoc3RhdGVfZGljdCklMEElMjAlMjAlMjAlMjBmb3IlMjBmaWxlbmFtZSUyQyUyMHRlbnNvcnMlMjBpbiUyMHN0YXRlX2RpY3Rfc3BsaXQuZmlsZW5hbWVfdG9fdGVuc29ycy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMjAlM0QlMjAlN0J0ZW5zb3IlM0ElMjBzdGF0ZV9kaWN0JTVCdGVuc29yJTVEJTIwZm9yJTIwdGVuc29yJTIwaW4lMjB0ZW5zb3JzJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FmZV9zYXZlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjBmaWxlbmFtZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMmZvcm1hdCUyMiUzQSUyMCUyMnB0JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGVfZGljdF9zcGxpdC5pc19zaGFyZGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRhZGF0YSUyMiUzQSUyMHN0YXRlX2RpY3Rfc3BsaXQubWV0YWRhdGElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHRfbWFwJTIyJTNBJTIwc3RhdGVfZGljdF9zcGxpdC50ZW5zb3JfdG9fZmlsZW5hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycy5pbmRleC5qc29uJTIyKSUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKGluZGV4JTJDJTIwaW5kZW50JTNEMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> save_file <span class="hljs-keyword">as</span> safe_save_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> split_torch_state_dict_into_shards

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_state_dict</span>(<span class="hljs-params">state_dict: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor], save_directory: <span class="hljs-built_in">str</span></span>):
<span class="hljs-meta">... </span>    state_dict_split = split_torch_state_dict_into_shards(state_dict)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> filename, tensors <span class="hljs-keyword">in</span> state_dict_split.filename_to_tensors.items():
<span class="hljs-meta">... </span>        shard = {tensor: state_dict[tensor] <span class="hljs-keyword">for</span> tensor <span class="hljs-keyword">in</span> tensors}
<span class="hljs-meta">... </span>        safe_save_file(
<span class="hljs-meta">... </span>            shard,
<span class="hljs-meta">... </span>            os.path.join(save_directory, filename),
<span class="hljs-meta">... </span>            metadata={<span class="hljs-string">&quot;format&quot;</span>: <span class="hljs-string">&quot;pt&quot;</span>},
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> state_dict_split.is_sharded:
<span class="hljs-meta">... </span>        index = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;metadata&quot;</span>: state_dict_split.metadata,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;weight_map&quot;</span>: state_dict_split.tensor_to_filename,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(os.path.join(save_directory, <span class="hljs-string">&quot;model.safetensors.index.json&quot;</span>), <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps(index, indent=<span class="hljs-number">2</span>))`,wrap:!1}}),{c(){t=d("p"),t.textContent=_,n=i(),m(p.$$.fragment)},l(l){t=h(l,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=_),n=o(l),f(p.$$.fragment,l)},m(l,y){r(l,t,y),r(l,n,y),g(p,l,y),T=!0},p:oe,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){$(p.$$.fragment,l),T=!1},d(l){l&&(a(t),a(n)),b(p,l)}}}function Ht(j){let t,_=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=_},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-16sq104"&&(t.innerHTML=_)},m(n,p){r(n,t,p)},p:oe,d(n){n&&a(t)}}}function Lt(j){let t,_,n,p,T,l,y,it="<code>huggingface_hub</code> contains helpers to help ML libraries serialize models weights in a standardized way. This part of the lib is still under development and will be improved in future releases. The goal is to harmonize how weights are serialized on the Hub, both to remove code duplication across libraries and to foster conventions on the Hub.",ve,D,Me,E,ot='The main helper of the <code>serialization</code> module takes a state dictionary as input (e.g. a mapping between layer names and related tensors), splits it into several shards while creating a proper index in the process and save everything to disk. At the moment, only <code>torch</code> tensors are supported. Under the hood, it delegates the logic to split the state dictionary to <a href="/docs/huggingface_hub/pr_2342/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a>.',je,v,W,Ve,re,rt="Save a model state dictionary to the disk.",Se,le,lt=`The model state dictionary is split into shards so that each shard is smaller than a given size. The shards are
saved in the <code>save_directory</code> with the given <code>filename_pattern</code>. If the model is too big to fit in a single shard,
an index file is saved in the <code>save_directory</code> to indicate where each tensor is saved. This helper uses
<a href="/docs/huggingface_hub/pr_2342/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. If <code>safe_serialization</code> is <code>True</code>, the shards are saved as
safetensors (the default). Otherwise, the shards are saved as pickle.`,De,ce,ct="Before saving the model, the <code>save_directory</code> is cleaned from any previous shard files.",Ee,C,We,Z,ye,q,xe,X,dt="The <code>serialization</code> module also contains low-level helpers to split a state dictionary into several shards, while creating a proper index in the process. These helpers are available for <code>torch</code> and <code>tensorflow</code> tensors and are designed to be easily extended to any other ML frameworks.",Je,P,ze,z,N,qe,de,ht="Split a model state dictionary in shards so that each shard is smaller than a given size.",Xe,he,pt=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,Pe,R,Ie,Y,Ge,M,F,Ne,pe,_t="Split a model state dictionary in shards so that each shard is smaller than a given size.",Ye,_e,mt=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,Fe,H,Qe,L,Ke,U,Be,Q,Ae,K,ft='This is the underlying factory from which each framework-specific helper is derived. In practice, you are not expected to use this factory directly except if you need to adapt it to a framework that is not yet supported. If that is the case, please let us know by <a href="https://github.com/huggingface/huggingface_hub/issues/new" rel="nofollow">opening a new issue</a> on the <code>huggingface_hub</code> repo.',ke,I,O,Oe,me,gt="Split a model state dictionary in shards so that each shard is smaller than a given size.",et,fe,ut=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,tt,V,Ce,ee,Ze,te,Re,G,se,st,ge,$t="Return unique identifier to a tensor storage.",at,ue,bt=`Multiple different tensors can share the same underlying storage. For
example, “meta” tensors all share the same storage, and thus their identifier will all be equal. This identifier is
guaranteed to be unique and constant for this tensor’s storage during its lifetime. Two tensor storages with
non-overlapping lifetimes may have the same id.`,nt,$e,wt='Taken from <a href="https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278" rel="nofollow">https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278</a>.',He,ae,Le,be,Ue;return T=new S({props:{title:"Serialization",local:"serialization",headingTag:"h1"}}),D=new S({props:{title:"Save torch state dict",local:"huggingface_hub.save_torch_state_dict",headingTag:"h2"}}),W=new Te({props:{name:"huggingface_hub.save_torch_state_dict",anchor:"huggingface_hub.save_torch_state_dict",parameters:[{name:"state_dict",val:": Dict"},{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"filename_pattern",val:": Optional = None"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.save_torch_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.save_torch_state_dict.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The directory in which the model will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.save_torch_state_dict.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to save as safetensors, which is the default behavior. If <code>False</code>, the shards are saved as pickle.
Safe serialization is recommended for security reasons. Saving as pickle is deprecated and will be removed
in a future version.`,name:"safe_serialization"},{anchor:"huggingface_hub.save_torch_state_dict.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code> or <code>pytorch_model{suffix}.bin</code> depending on <code>safe_serialization</code>
parameter.`,name:"filename_pattern"},{anchor:"huggingface_hub.save_torch_state_dict.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2342/src/huggingface_hub/serialization/_torch.py#L110"}}),C=new we({props:{warning:!0,$$slots:{default:[Bt]},$$scope:{ctx:j}}}),Z=new Mt({props:{anchor:"huggingface_hub.save_torch_state_dict.example",$$slots:{default:[At]},$$scope:{ctx:j}}}),q=new S({props:{title:"Split state dict into shards",local:"split-state-dict-into-shards",headingTag:"h2"}}),P=new S({props:{title:"split_tf_state_dict_into_shards",local:"huggingface_hub.split_tf_state_dict_into_shards",headingTag:"h3"}}),N=new Te({props:{name:"huggingface_hub.split_tf_state_dict_into_shards",anchor:"huggingface_hub.split_tf_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'tf_model{suffix}.h5'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_tf_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;tf_model{suffix}.h5&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2342/src/huggingface_hub/serialization/_tensorflow.py#L28",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),R=new we({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:j}}}),Y=new S({props:{title:"split_torch_state_dict_into_shards",local:"huggingface_hub.split_torch_state_dict_into_shards",headingTag:"h3"}}),F=new Te({props:{name:"huggingface_hub.split_torch_state_dict_into_shards",anchor:"huggingface_hub.split_torch_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'model{suffix}.safetensors'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_torch_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2342/src/huggingface_hub/serialization/_torch.py#L34",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),H=new we({props:{$$slots:{default:[Ct]},$$scope:{ctx:j}}}),L=new we({props:{warning:!0,$$slots:{default:[Zt]},$$scope:{ctx:j}}}),U=new Mt({props:{anchor:"huggingface_hub.split_torch_state_dict_into_shards.example",$$slots:{default:[Rt]},$$scope:{ctx:j}}}),Q=new S({props:{title:"split_state_dict_into_shards_factory",local:"huggingface_hub.split_state_dict_into_shards_factory",headingTag:"h3"}}),O=new Te({props:{name:"huggingface_hub.split_state_dict_into_shards_factory",anchor:"huggingface_hub.split_state_dict_into_shards_factory",parameters:[{name:"state_dict",val:": Dict"},{name:"get_tensor_size",val:": Callable"},{name:"filename_pattern",val:": str"},{name:"get_storage_id",val:": Callable = <function <lambda> at 0x7faf0997c790>"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_state_dict_into_shards_factory.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_tensor_size",description:`<strong>get_tensor_size</strong> (<code>Callable[[Tensor], int]</code>) &#x2014;
A function that returns the size of a tensor in bytes.`,name:"get_tensor_size"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_storage_id",description:`<strong>get_storage_id</strong> (<code>Callable[[Tensor], Optional[Any]]</code>, <em>optional</em>) &#x2014;
A function that returns a unique identifier to a tensor storage. Multiple different tensors can share the
same underlying storage. This identifier is guaranteed to be unique and constant for this tensor&#x2019;s storage
during its lifetime. Two tensor storages with non-overlapping lifetimes may have the same id.`,name:"get_storage_id"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>`,name:"filename_pattern"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2342/src/huggingface_hub/serialization/_base.py#L49",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),V=new we({props:{warning:!0,$$slots:{default:[Ht]},$$scope:{ctx:j}}}),ee=new S({props:{title:"Helpers",local:"helpers",headingTag:"h2"}}),te=new S({props:{title:"get_torch_storage_id",local:"huggingface_hub.get_torch_storage_id",headingTag:"h3"}}),se=new Te({props:{name:"huggingface_hub.get_torch_storage_id",anchor:"huggingface_hub.get_torch_storage_id",parameters:[{name:"tensor",val:": torch.Tensor"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2342/src/huggingface_hub/serialization/_torch.py#L229"}}),ae=new Gt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/serialization.md"}}),{c(){t=d("meta"),_=i(),n=d("p"),p=i(),m(T.$$.fragment),l=i(),y=d("p"),y.innerHTML=it,ve=i(),m(D.$$.fragment),Me=i(),E=d("p"),E.innerHTML=ot,je=i(),v=d("div"),m(W.$$.fragment),Ve=i(),re=d("p"),re.textContent=rt,Se=i(),le=d("p"),le.innerHTML=lt,De=i(),ce=d("p"),ce.innerHTML=ct,Ee=i(),m(C.$$.fragment),We=i(),m(Z.$$.fragment),ye=i(),m(q.$$.fragment),xe=i(),X=d("p"),X.innerHTML=dt,Je=i(),m(P.$$.fragment),ze=i(),z=d("div"),m(N.$$.fragment),qe=i(),de=d("p"),de.textContent=ht,Xe=i(),he=d("p"),he.innerHTML=pt,Pe=i(),m(R.$$.fragment),Ie=i(),m(Y.$$.fragment),Ge=i(),M=d("div"),m(F.$$.fragment),Ne=i(),pe=d("p"),pe.textContent=_t,Ye=i(),_e=d("p"),_e.innerHTML=mt,Fe=i(),m(H.$$.fragment),Qe=i(),m(L.$$.fragment),Ke=i(),m(U.$$.fragment),Be=i(),m(Q.$$.fragment),Ae=i(),K=d("p"),K.innerHTML=ft,ke=i(),I=d("div"),m(O.$$.fragment),Oe=i(),me=d("p"),me.textContent=gt,et=i(),fe=d("p"),fe.innerHTML=ut,tt=i(),m(V.$$.fragment),Ce=i(),m(ee.$$.fragment),Ze=i(),m(te.$$.fragment),Re=i(),G=d("div"),m(se.$$.fragment),st=i(),ge=d("p"),ge.textContent=$t,at=i(),ue=d("p"),ue.textContent=bt,nt=i(),$e=d("p"),$e.innerHTML=wt,He=i(),m(ae.$$.fragment),Le=i(),be=d("p"),this.h()},l(e){const s=It("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(a),_=o(e),n=h(e,"P",{}),ne(n).forEach(a),p=o(e),f(T.$$.fragment,e),l=o(e),y=h(e,"P",{"data-svelte-h":!0}),w(y)!=="svelte-pikz64"&&(y.innerHTML=it),ve=o(e),f(D.$$.fragment,e),Me=o(e),E=h(e,"P",{"data-svelte-h":!0}),w(E)!=="svelte-1hb2kyd"&&(E.innerHTML=ot),je=o(e),v=h(e,"DIV",{class:!0});var x=ne(v);f(W.$$.fragment,x),Ve=o(x),re=h(x,"P",{"data-svelte-h":!0}),w(re)!=="svelte-aqdfv7"&&(re.textContent=rt),Se=o(x),le=h(x,"P",{"data-svelte-h":!0}),w(le)!=="svelte-u4hxl6"&&(le.innerHTML=lt),De=o(x),ce=h(x,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-zotpm4"&&(ce.innerHTML=ct),Ee=o(x),f(C.$$.fragment,x),We=o(x),f(Z.$$.fragment,x),x.forEach(a),ye=o(e),f(q.$$.fragment,e),xe=o(e),X=h(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1jvx2r9"&&(X.innerHTML=dt),Je=o(e),f(P.$$.fragment,e),ze=o(e),z=h(e,"DIV",{class:!0});var B=ne(z);f(N.$$.fragment,B),qe=o(B),de=h(B,"P",{"data-svelte-h":!0}),w(de)!=="svelte-1q1pe7b"&&(de.textContent=ht),Xe=o(B),he=h(B,"P",{"data-svelte-h":!0}),w(he)!=="svelte-17rio2z"&&(he.innerHTML=pt),Pe=o(B),f(R.$$.fragment,B),B.forEach(a),Ie=o(e),f(Y.$$.fragment,e),Ge=o(e),M=h(e,"DIV",{class:!0});var J=ne(M);f(F.$$.fragment,J),Ne=o(J),pe=h(J,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-1q1pe7b"&&(pe.textContent=_t),Ye=o(J),_e=h(J,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-17rio2z"&&(_e.innerHTML=mt),Fe=o(J),f(H.$$.fragment,J),Qe=o(J),f(L.$$.fragment,J),Ke=o(J),f(U.$$.fragment,J),J.forEach(a),Be=o(e),f(Q.$$.fragment,e),Ae=o(e),K=h(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1hva642"&&(K.innerHTML=ft),ke=o(e),I=h(e,"DIV",{class:!0});var A=ne(I);f(O.$$.fragment,A),Oe=o(A),me=h(A,"P",{"data-svelte-h":!0}),w(me)!=="svelte-1q1pe7b"&&(me.textContent=gt),et=o(A),fe=h(A,"P",{"data-svelte-h":!0}),w(fe)!=="svelte-17rio2z"&&(fe.innerHTML=ut),tt=o(A),f(V.$$.fragment,A),A.forEach(a),Ce=o(e),f(ee.$$.fragment,e),Ze=o(e),f(te.$$.fragment,e),Re=o(e),G=h(e,"DIV",{class:!0});var k=ne(G);f(se.$$.fragment,k),st=o(k),ge=h(k,"P",{"data-svelte-h":!0}),w(ge)!=="svelte-lfv2l4"&&(ge.textContent=$t),at=o(k),ue=h(k,"P",{"data-svelte-h":!0}),w(ue)!=="svelte-4klsmr"&&(ue.textContent=bt),nt=o(k),$e=h(k,"P",{"data-svelte-h":!0}),w($e)!=="svelte-akggeo"&&($e.innerHTML=wt),k.forEach(a),He=o(e),f(ae.$$.fragment,e),Le=o(e),be=h(e,"P",{}),ne(be).forEach(a),this.h()},h(){ie(t,"name","hf:doc:metadata"),ie(t,"content",Ut),ie(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ie(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ie(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ie(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ie(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){c(document.head,t),r(e,_,s),r(e,n,s),r(e,p,s),g(T,e,s),r(e,l,s),r(e,y,s),r(e,ve,s),g(D,e,s),r(e,Me,s),r(e,E,s),r(e,je,s),r(e,v,s),g(W,v,null),c(v,Ve),c(v,re),c(v,Se),c(v,le),c(v,De),c(v,ce),c(v,Ee),g(C,v,null),c(v,We),g(Z,v,null),r(e,ye,s),g(q,e,s),r(e,xe,s),r(e,X,s),r(e,Je,s),g(P,e,s),r(e,ze,s),r(e,z,s),g(N,z,null),c(z,qe),c(z,de),c(z,Xe),c(z,he),c(z,Pe),g(R,z,null),r(e,Ie,s),g(Y,e,s),r(e,Ge,s),r(e,M,s),g(F,M,null),c(M,Ne),c(M,pe),c(M,Ye),c(M,_e),c(M,Fe),g(H,M,null),c(M,Qe),g(L,M,null),c(M,Ke),g(U,M,null),r(e,Be,s),g(Q,e,s),r(e,Ae,s),r(e,K,s),r(e,ke,s),r(e,I,s),g(O,I,null),c(I,Oe),c(I,me),c(I,et),c(I,fe),c(I,tt),g(V,I,null),r(e,Ce,s),g(ee,e,s),r(e,Ze,s),g(te,e,s),r(e,Re,s),r(e,G,s),g(se,G,null),c(G,st),c(G,ge),c(G,at),c(G,ue),c(G,nt),c(G,$e),r(e,He,s),g(ae,e,s),r(e,Le,s),r(e,be,s),Ue=!0},p(e,[s]){const x={};s&2&&(x.$$scope={dirty:s,ctx:e}),C.$set(x);const B={};s&2&&(B.$$scope={dirty:s,ctx:e}),Z.$set(B);const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),R.$set(J);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),H.$set(A);const k={};s&2&&(k.$$scope={dirty:s,ctx:e}),L.$set(k);const Tt={};s&2&&(Tt.$$scope={dirty:s,ctx:e}),U.$set(Tt);const vt={};s&2&&(vt.$$scope={dirty:s,ctx:e}),V.$set(vt)},i(e){Ue||(u(T.$$.fragment,e),u(D.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(V.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),Ue=!0)},o(e){$(T.$$.fragment,e),$(D.$$.fragment,e),$(W.$$.fragment,e),$(C.$$.fragment,e),$(Z.$$.fragment,e),$(q.$$.fragment,e),$(P.$$.fragment,e),$(N.$$.fragment,e),$(R.$$.fragment,e),$(Y.$$.fragment,e),$(F.$$.fragment,e),$(H.$$.fragment,e),$(L.$$.fragment,e),$(U.$$.fragment,e),$(Q.$$.fragment,e),$(O.$$.fragment,e),$(V.$$.fragment,e),$(ee.$$.fragment,e),$(te.$$.fragment,e),$(se.$$.fragment,e),$(ae.$$.fragment,e),Ue=!1},d(e){e&&(a(_),a(n),a(p),a(l),a(y),a(ve),a(Me),a(E),a(je),a(v),a(ye),a(xe),a(X),a(Je),a(ze),a(z),a(Ie),a(Ge),a(M),a(Be),a(Ae),a(K),a(ke),a(I),a(Ce),a(Ze),a(Re),a(G),a(He),a(Le),a(be)),a(t),b(T,e),b(D,e),b(W),b(C),b(Z),b(q,e),b(P,e),b(N),b(R),b(Y,e),b(F),b(H),b(L),b(U),b(Q,e),b(O),b(V),b(ee,e),b(te,e),b(se),b(ae,e)}}}const Ut='{"title":"Serialization","local":"serialization","sections":[{"title":"Save torch state dict","local":"huggingface_hub.save_torch_state_dict","sections":[],"depth":2},{"title":"Split state dict into shards","local":"split-state-dict-into-shards","sections":[{"title":"split_tf_state_dict_into_shards","local":"huggingface_hub.split_tf_state_dict_into_shards","sections":[],"depth":3},{"title":"split_torch_state_dict_into_shards","local":"huggingface_hub.split_torch_state_dict_into_shards","sections":[],"depth":3},{"title":"split_state_dict_into_shards_factory","local":"huggingface_hub.split_state_dict_into_shards_factory","sections":[],"depth":3}],"depth":2},{"title":"Helpers","local":"helpers","sections":[{"title":"get_torch_storage_id","local":"huggingface_hub.get_torch_storage_id","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vt(j){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Jt{constructor(t){super(),zt(this,t,Vt,Lt,yt,{})}}export{Nt as component};
