import{s as pe,f as Me,n as ye,o as ie}from"../chunks/scheduler.889ebb13.js";import{S as oe,i as me,g as a,s as n,r as i,A as je,h as p,f as e,c as M,j as ae,u as o,x as y,k as jl,y as Ue,a as s,v as m,d as j,t as U,w as r}from"../chunks/index.ca18042b.js";import{C as ut}from"../chunks/CodeBlock.1db71023.js";import{H as cl,E as re}from"../chunks/EditOnGithub.b0b59db6.js";function ce(Tt){let c,wl,Ul,ul,w,Tl,u,Jt="在上一节中，我们学习了如何使用 Python 代码从头开始创建智能体，并且我们<strong>看到了这个过程是多么繁琐</strong>。幸运的是，许多智能体库通过<strong>为你处理大量繁重的工作</strong>来简化这项工作。",Jl,T,bt="在本教程中，<strong>你将创建你的第一个智能体</strong>，它能够执行图像生成、网络搜索、时区检查等更多操作！",bl,J,Ct="你还将把你的智能体<strong>发布到 Hugging Face Space 上，以便与朋友和同事分享</strong>。",Cl,b,dt="让我们开始吧！",dl,C,hl,d,ht,Bl,h,Bt="为了创建这个智能体，我们将使用 <code>smolagents</code>，这是一个<strong>提供轻松开发智能体框架的库</strong>。",fl,B,ft="这个轻量级库设计简洁，但它抽象了构建智能体的许多复杂性，使你能够专注于设计智能体的行为。",Il,f,It='我们将在下一个单元中深入了解 smolagents。同时，你也可以查看这篇<a href="https://huggingface.co/blog/smolagents" target="_blank">博客文章</a>或该库的<a href="https://github.com/huggingface/smolagents" target="_blank">GitHub 仓库</a>。',Zl,I,Zt="简而言之，<code>smolagents</code> 是一个专注于 <strong>codeAgent</strong> 的库，codeAgent 是一种通过代码块执行<strong>“操作”</strong>，然后通过执行代码<strong>“观察”</strong>结果的智能体。",gl,Z,gt="以下是我们将构建的一个示例！",vl,g,vt="我们为我们的智能体提供了一个<strong>图像生成工具</strong>，并要求它生成一张猫的图片。",Wl,v,Wt="<code>smolagents</code> 中的智能体将具有<strong>与我们之前构建的自定义智能体相同的行为</strong>：它将<strong>以循环的方式思考、行动和观察</strong>，直到得出最终答案：",Al,W,At='<a href="https://www.youtube.com/watch?v=PQDKcWiuln4" rel="nofollow">智能体流程</a>',El,A,Et="很令人兴奋，对吧？",Hl,E,Gl,H,Ht='首先，复制这个 Space：<a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',_l,G,Gt='<p>感谢 <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> 提供的这个模板！🙌</p>',Ql,_,_t="复制这个 Space 意味着<strong>在你的个人资料中创建一个本地副本</strong>：",Rl,Q,Qt,Xl,R,Rt='在整个课程中，你唯一需要修改的文件是当前不完整的<strong>“app.py”</strong>。你可以在这里查看<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">模板中的原始文件</a>。要找到你的文件，请进入你复制的 Space，然后点击 <code>Files</code> 选项卡，再在目录列表中点击 <code>app.py</code>。',xl,X,Xt="让我们一起分解代码：",kl,x,xt="<li>文件开头是一些简单但必要的库导入</li>",Sl,k,zl,S,kt="正如之前所述，我们将直接使用 <strong>smolagents</strong> 中的 <strong>CodeAgent</strong> 类。",Nl,z,Fl,N,St='现在让我们来了解一下工具！如果你需要回顾一下工具的相关内容，请随时回到课程的<a href="tools">工具</a>部分。',Vl,F,$l,V,zt="这些工具是我们在这个部分鼓励你构建的东西！我们给你两个例子：",Ll,$,Nt="<li>一个<strong>不工作的虚拟工具</strong>，你可以修改它来制作一些有用的东西。</li> <li>一个<strong>实际工作的工具</strong>，它可以获取世界某地的当前时间。</li>",Yl,L,Ft="要定义你的工具，重要的是：",ql,Y,Vt="<li>为你的函数提供输入和输出类型，例如 <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>格式良好的文档字符串</strong>。<code>smolagents</code> 期望所有参数在文档字符串中都有<strong>文字描述</strong>。</li>",Pl,q,Kl,P,$t='它使用 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> 作为 LLM 引擎。这是一个非常强大的模型，我们将通过无服务器 API 访问它。',Dl,K,Ol,D,Lt="这个智能体仍在使用我们在前面部分中看到的<code>InferenceClient</code>，它位于<strong>HfApiModel</strong>类的背后！",lt,O,Yt="当我们介绍 Unit 2 中的框架时，我们会给出更深入的例子。目前，你需要专注于通过智能体的<code>tools</code>参数<strong>向工具列表中添加新工具</strong>。",tt,ll,qt="例如，你可以使用代码第一行导入的<code>DuckDuckGoSearchTool</code>，或者你可以检查稍后从 Hub 加载的<code>image_generation_tool</code>。",et,tl,Pt="<strong>添加工具将赋予你的智能体新的能力</strong>，在这里尝试发挥创意吧！",st,el,Kt="完整的”app.py”：",nt,sl,Mt,nl,Dt="你的<strong>目标</strong>是熟悉 Space 和智能体。",at,Ml,Ot="目前，模板中的智能体<strong>没有使用任何工具，所以尝试为它提供一些预制的工具，甚至自己动手制作一些新工具！</strong>",pt,al,le="我们非常期待在 Discord 频道 <strong>#agents-course-showcase</strong> 中看到你的精彩智能体成果！",yt,it,ot,pl,te="恭喜你，你已经构建了你的第一个智能体！不要犹豫，与你的朋友和同事分享吧。",mt,yl,ee="由于这是你的第一次尝试，如果有点小问题或速度有点慢，这是完全正常的。在未来的单元中，我们将学习如何构建更好的智能体。",jt,il,se="最好的学习方法是尝试，所以不要犹豫，去更新它，添加更多工具，尝试使用另一个模型，等等。",Ut,ol,ne="在下一节中，你将完成最后的测验并获得证书！",rt,ml,ct,rl,wt;return w=new cl({props:{title:"使用 smolagents 创建我们的第一个智能体",local:"使用-smolagents-创建我们的第一个智能体",headingTag:"h1"}}),C=new cl({props:{title:"什么是 smolagents？",local:"什么是-smolagents",headingTag:"h2"}}),E=new cl({props:{title:"让我们来构建我们的智能体！",local:"让我们来构建我们的智能体",headingTag:"h2"}}),k=new ut({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),z=new cl({props:{title:"Tool（工具）",local:"tool工具",headingTag:"h3"}}),F=new ut({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),q=new cl({props:{title:"The Agent（智能体）",local:"the-agent智能体",headingTag:"h3"}}),K=new ut({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsX2Fuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),sl=new ut({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),ml=new re({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/tutorial.mdx"}}),{c(){c=a("meta"),wl=n(),Ul=a("p"),ul=n(),i(w.$$.fragment),Tl=n(),u=a("p"),u.innerHTML=Jt,Jl=n(),T=a("p"),T.innerHTML=bt,bl=n(),J=a("p"),J.innerHTML=Ct,Cl=n(),b=a("p"),b.textContent=dt,dl=n(),i(C.$$.fragment),hl=n(),d=a("img"),Bl=n(),h=a("p"),h.innerHTML=Bt,fl=n(),B=a("p"),B.textContent=ft,Il=n(),f=a("p"),f.innerHTML=It,Zl=n(),I=a("p"),I.innerHTML=Zt,gl=n(),Z=a("p"),Z.textContent=gt,vl=n(),g=a("p"),g.innerHTML=vt,Wl=n(),v=a("p"),v.innerHTML=Wt,Al=n(),W=a("p"),W.innerHTML=At,El=n(),A=a("p"),A.textContent=Et,Hl=n(),i(E.$$.fragment),Gl=n(),H=a("p"),H.innerHTML=Ht,_l=n(),G=a("blockquote"),G.innerHTML=Gt,Ql=n(),_=a("p"),_.innerHTML=_t,Rl=n(),Q=a("img"),Xl=n(),R=a("p"),R.innerHTML=Rt,xl=n(),X=a("p"),X.textContent=Xt,kl=n(),x=a("ul"),x.innerHTML=xt,Sl=n(),i(k.$$.fragment),zl=n(),S=a("p"),S.innerHTML=kt,Nl=n(),i(z.$$.fragment),Fl=n(),N=a("p"),N.innerHTML=St,Vl=n(),i(F.$$.fragment),$l=n(),V=a("p"),V.textContent=zt,Ll=n(),$=a("ol"),$.innerHTML=Nt,Yl=n(),L=a("p"),L.textContent=Ft,ql=n(),Y=a("ol"),Y.innerHTML=Vt,Pl=n(),i(q.$$.fragment),Kl=n(),P=a("p"),P.innerHTML=$t,Dl=n(),i(K.$$.fragment),Ol=n(),D=a("p"),D.innerHTML=Lt,lt=n(),O=a("p"),O.innerHTML=Yt,tt=n(),ll=a("p"),ll.innerHTML=qt,et=n(),tl=a("p"),tl.innerHTML=Pt,st=n(),el=a("p"),el.textContent=Kt,nt=n(),i(sl.$$.fragment),Mt=n(),nl=a("p"),nl.innerHTML=Dt,at=n(),Ml=a("p"),Ml.innerHTML=Ot,pt=n(),al=a("p"),al.innerHTML=le,yt=n(),it=a("hr"),ot=n(),pl=a("p"),pl.textContent=te,mt=n(),yl=a("p"),yl.textContent=ee,jt=n(),il=a("p"),il.textContent=se,Ut=n(),ol=a("p"),ol.textContent=ne,rt=n(),i(ml.$$.fragment),ct=n(),rl=a("p"),this.h()},l(l){const t=je("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(e),wl=M(l),Ul=p(l,"P",{}),ae(Ul).forEach(e),ul=M(l),o(w.$$.fragment,l),Tl=M(l),u=p(l,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1ujhsd9"&&(u.innerHTML=Jt),Jl=M(l),T=p(l,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1fz25zu"&&(T.innerHTML=bt),bl=M(l),J=p(l,"P",{"data-svelte-h":!0}),y(J)!=="svelte-vbbf2l"&&(J.innerHTML=Ct),Cl=M(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-izpy37"&&(b.textContent=dt),dl=M(l),o(C.$$.fragment,l),hl=M(l),d=p(l,"IMG",{src:!0,alt:!0}),Bl=M(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1p4ogmz"&&(h.innerHTML=Bt),fl=M(l),B=p(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1rnyukb"&&(B.textContent=ft),Il=M(l),f=p(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-eka5kk"&&(f.innerHTML=It),Zl=M(l),I=p(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1terpmt"&&(I.innerHTML=Zt),gl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-teea68"&&(Z.textContent=gt),vl=M(l),g=p(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1rvw3dn"&&(g.innerHTML=vt),Wl=M(l),v=p(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-k9hzof"&&(v.innerHTML=Wt),Al=M(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1wjb8et"&&(W.innerHTML=At),El=M(l),A=p(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-zp6tm6"&&(A.textContent=Et),Hl=M(l),o(E.$$.fragment,l),Gl=M(l),H=p(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1ga3nhy"&&(H.innerHTML=Ht),_l=M(l),G=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),y(G)!=="svelte-1szeww4"&&(G.innerHTML=Gt),Ql=M(l),_=p(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1lf9he9"&&(_.innerHTML=_t),Rl=M(l),Q=p(l,"IMG",{src:!0,alt:!0}),Xl=M(l),R=p(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1rvndzh"&&(R.innerHTML=Rt),xl=M(l),X=p(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-qzw9ae"&&(X.textContent=Xt),kl=M(l),x=p(l,"UL",{"data-svelte-h":!0}),y(x)!=="svelte-7zqdyp"&&(x.innerHTML=xt),Sl=M(l),o(k.$$.fragment,l),zl=M(l),S=p(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-193ax9h"&&(S.innerHTML=kt),Nl=M(l),o(z.$$.fragment,l),Fl=M(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1y6flx0"&&(N.innerHTML=St),Vl=M(l),o(F.$$.fragment,l),$l=M(l),V=p(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-txzape"&&(V.textContent=zt),Ll=M(l),$=p(l,"OL",{"data-svelte-h":!0}),y($)!=="svelte-1nki85t"&&($.innerHTML=Nt),Yl=M(l),L=p(l,"P",{"data-svelte-h":!0}),y(L)!=="svelte-e5waqh"&&(L.textContent=Ft),ql=M(l),Y=p(l,"OL",{"data-svelte-h":!0}),y(Y)!=="svelte-3glxb2"&&(Y.innerHTML=Vt),Pl=M(l),o(q.$$.fragment,l),Kl=M(l),P=p(l,"P",{"data-svelte-h":!0}),y(P)!=="svelte-15wg5ed"&&(P.innerHTML=$t),Dl=M(l),o(K.$$.fragment,l),Ol=M(l),D=p(l,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1ecqmc8"&&(D.innerHTML=Lt),lt=M(l),O=p(l,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1trmkgr"&&(O.innerHTML=Yt),tt=M(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1r29o7"&&(ll.innerHTML=qt),et=M(l),tl=p(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-1ex3pg"&&(tl.innerHTML=Pt),st=M(l),el=p(l,"P",{"data-svelte-h":!0}),y(el)!=="svelte-1islpf0"&&(el.textContent=Kt),nt=M(l),o(sl.$$.fragment,l),Mt=M(l),nl=p(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-1mbhzkl"&&(nl.innerHTML=Dt),at=M(l),Ml=p(l,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-1scg4wp"&&(Ml.innerHTML=Ot),pt=M(l),al=p(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-o093cv"&&(al.innerHTML=le),yt=M(l),it=p(l,"HR",{}),ot=M(l),pl=p(l,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-r2adc4"&&(pl.textContent=te),mt=M(l),yl=p(l,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-1eae468"&&(yl.textContent=ee),jt=M(l),il=p(l,"P",{"data-svelte-h":!0}),y(il)!=="svelte-1vfq4lx"&&(il.textContent=se),Ut=M(l),ol=p(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-o18u8f"&&(ol.textContent=ne),rt=M(l),o(ml.$$.fragment,l),ct=M(l),rl=p(l,"P",{}),ae(rl).forEach(e),this.h()},h(){jl(c,"name","hf:doc:metadata"),jl(c,"content",we),Me(d.src,ht="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||jl(d,"src",ht),jl(d,"alt","smolagents"),Me(Q.src,Qt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||jl(Q,"src",Qt),jl(Q,"alt","复制")},m(l,t){Ue(document.head,c),s(l,wl,t),s(l,Ul,t),s(l,ul,t),m(w,l,t),s(l,Tl,t),s(l,u,t),s(l,Jl,t),s(l,T,t),s(l,bl,t),s(l,J,t),s(l,Cl,t),s(l,b,t),s(l,dl,t),m(C,l,t),s(l,hl,t),s(l,d,t),s(l,Bl,t),s(l,h,t),s(l,fl,t),s(l,B,t),s(l,Il,t),s(l,f,t),s(l,Zl,t),s(l,I,t),s(l,gl,t),s(l,Z,t),s(l,vl,t),s(l,g,t),s(l,Wl,t),s(l,v,t),s(l,Al,t),s(l,W,t),s(l,El,t),s(l,A,t),s(l,Hl,t),m(E,l,t),s(l,Gl,t),s(l,H,t),s(l,_l,t),s(l,G,t),s(l,Ql,t),s(l,_,t),s(l,Rl,t),s(l,Q,t),s(l,Xl,t),s(l,R,t),s(l,xl,t),s(l,X,t),s(l,kl,t),s(l,x,t),s(l,Sl,t),m(k,l,t),s(l,zl,t),s(l,S,t),s(l,Nl,t),m(z,l,t),s(l,Fl,t),s(l,N,t),s(l,Vl,t),m(F,l,t),s(l,$l,t),s(l,V,t),s(l,Ll,t),s(l,$,t),s(l,Yl,t),s(l,L,t),s(l,ql,t),s(l,Y,t),s(l,Pl,t),m(q,l,t),s(l,Kl,t),s(l,P,t),s(l,Dl,t),m(K,l,t),s(l,Ol,t),s(l,D,t),s(l,lt,t),s(l,O,t),s(l,tt,t),s(l,ll,t),s(l,et,t),s(l,tl,t),s(l,st,t),s(l,el,t),s(l,nt,t),m(sl,l,t),s(l,Mt,t),s(l,nl,t),s(l,at,t),s(l,Ml,t),s(l,pt,t),s(l,al,t),s(l,yt,t),s(l,it,t),s(l,ot,t),s(l,pl,t),s(l,mt,t),s(l,yl,t),s(l,jt,t),s(l,il,t),s(l,Ut,t),s(l,ol,t),s(l,rt,t),m(ml,l,t),s(l,ct,t),s(l,rl,t),wt=!0},p:ye,i(l){wt||(j(w.$$.fragment,l),j(C.$$.fragment,l),j(E.$$.fragment,l),j(k.$$.fragment,l),j(z.$$.fragment,l),j(F.$$.fragment,l),j(q.$$.fragment,l),j(K.$$.fragment,l),j(sl.$$.fragment,l),j(ml.$$.fragment,l),wt=!0)},o(l){U(w.$$.fragment,l),U(C.$$.fragment,l),U(E.$$.fragment,l),U(k.$$.fragment,l),U(z.$$.fragment,l),U(F.$$.fragment,l),U(q.$$.fragment,l),U(K.$$.fragment,l),U(sl.$$.fragment,l),U(ml.$$.fragment,l),wt=!1},d(l){l&&(e(wl),e(Ul),e(ul),e(Tl),e(u),e(Jl),e(T),e(bl),e(J),e(Cl),e(b),e(dl),e(hl),e(d),e(Bl),e(h),e(fl),e(B),e(Il),e(f),e(Zl),e(I),e(gl),e(Z),e(vl),e(g),e(Wl),e(v),e(Al),e(W),e(El),e(A),e(Hl),e(Gl),e(H),e(_l),e(G),e(Ql),e(_),e(Rl),e(Q),e(Xl),e(R),e(xl),e(X),e(kl),e(x),e(Sl),e(zl),e(S),e(Nl),e(Fl),e(N),e(Vl),e($l),e(V),e(Ll),e($),e(Yl),e(L),e(ql),e(Y),e(Pl),e(Kl),e(P),e(Dl),e(Ol),e(D),e(lt),e(O),e(tt),e(ll),e(et),e(tl),e(st),e(el),e(nt),e(Mt),e(nl),e(at),e(Ml),e(pt),e(al),e(yt),e(it),e(ot),e(pl),e(mt),e(yl),e(jt),e(il),e(Ut),e(ol),e(rt),e(ct),e(rl)),e(c),r(w,l),r(C,l),r(E,l),r(k,l),r(z,l),r(F,l),r(q,l),r(K,l),r(sl,l),r(ml,l)}}}const we='{"title":"使用 smolagents 创建我们的第一个智能体","local":"使用-smolagents-创建我们的第一个智能体","sections":[{"title":"什么是 smolagents？","local":"什么是-smolagents","sections":[],"depth":2},{"title":"让我们来构建我们的智能体！","local":"让我们来构建我们的智能体","sections":[{"title":"Tool（工具）","local":"tool工具","sections":[],"depth":3},{"title":"The Agent（智能体）","local":"the-agent智能体","sections":[],"depth":3}],"depth":2}],"depth":1}';function ue(Tt){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class de extends oe{constructor(c){super(),me(this,c,ue,ce,pe,{})}}export{de as component};
