import{s as Wt,o as Rt,n as Ie}from"../chunks/scheduler.8c3d61f6.js";import{S as Xt,i as vt,g as p,s as a,r as f,A as Et,h as y,f as s,c as i,j as Ct,u as J,x as c,k as gt,y as Ft,a as n,v as u,d as M,t as T,w as b}from"../chunks/index.da70eac4.js";import{T as mt}from"../chunks/Tip.1d9b8c37.js";import{C as E}from"../chunks/CodeBlock.00a903b3.js";import{H as z,E as $t}from"../chunks/EditOnGithub.1e64e623.js";import{H as kt,a as _t}from"../chunks/HfOption.c1483eb1.js";function Gt(F){let o,Z="Quantizing a model in 8-bit halves the memory-usage:",r,w,d=`As <code>bitsandbytes</code> is supported in both <code>transformers</code> and <code>diffusers</code> we can quantize both the
<code>FluxTransformer2DModel</code> and <code>T5EncoderModel</code>.`,U,h,v,I,G=`By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>.
You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:`,V,C,W,g,N="Let’s generate an image using our quantized models.",R,_,$,B,q='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png" alt="8 bit image"/>',k,j,Q=`Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.
The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights.
You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.`,X;return h=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_8bit=True,
)

transformer_8bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)</span>`,wrap:!1}}),C=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_8bit=True,
)

transformer_8bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)</span>`,wrap:!1}}),_=new E({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9rd2FyZ3MlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEElMEFpbWFnZS5yZXNpemUoKDIyNCUyQyUyMDIyNCkp",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=&quot;</span>auto<span class="hljs-string">&quot;,
)

pipe_kwargs = {
    &quot;</span>prompt<span class="hljs-string">&quot;: &quot;</span>A cat holding a sign that says hello world<span class="hljs-string">&quot;,
    &quot;</span>height<span class="hljs-string">&quot;: 1024,
    &quot;</span>width<span class="hljs-string">&quot;: 1024,
    &quot;</span>guidance_scale<span class="hljs-string">&quot;: 3.5,
    &quot;</span>num_inference_steps<span class="hljs-string">&quot;: 50,
    &quot;</span>max_sequence_length<span class="hljs-string">&quot;: 512,
}

image = pipe(
    generator=torch.Generator(&quot;</span>cp<span class="hljs-string">u&quot;).manual_seed(0),
    **pipe_kwargs,
).images[0]

image.resize((224, 224))</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=Z,r=a(),w=p("p"),w.innerHTML=d,U=a(),f(h.$$.fragment),v=a(),I=p("p"),I.innerHTML=G,V=a(),f(C.$$.fragment),W=a(),g=p("p"),g.textContent=N,R=a(),f(_.$$.fragment),$=a(),B=p("p"),B.innerHTML=q,k=a(),j=p("p"),j.innerHTML=Q},l(l){o=y(l,"P",{"data-svelte-h":!0}),c(o)!=="svelte-4djpqq"&&(o.textContent=Z),r=i(l),w=y(l,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1hnraos"&&(w.innerHTML=d),U=i(l),J(h.$$.fragment,l),v=i(l),I=y(l,"P",{"data-svelte-h":!0}),c(I)!=="svelte-8rk7w0"&&(I.innerHTML=G),V=i(l),J(C.$$.fragment,l),W=i(l),g=y(l,"P",{"data-svelte-h":!0}),c(g)!=="svelte-2bde4h"&&(g.textContent=N),R=i(l),J(_.$$.fragment,l),$=i(l),B=y(l,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1ocjh1t"&&(B.innerHTML=q),k=i(l),j=y(l,"P",{"data-svelte-h":!0}),c(j)!=="svelte-kh50ee"&&(j.innerHTML=Q)},m(l,m){n(l,o,m),n(l,r,m),n(l,w,m),n(l,U,m),u(h,l,m),n(l,v,m),n(l,I,m),n(l,V,m),u(C,l,m),n(l,W,m),n(l,g,m),n(l,R,m),u(_,l,m),n(l,$,m),n(l,B,m),n(l,k,m),n(l,j,m),X=!0},p:Ie,i(l){X||(M(h.$$.fragment,l),M(C.$$.fragment,l),M(_.$$.fragment,l),X=!0)},o(l){T(h.$$.fragment,l),T(C.$$.fragment,l),T(_.$$.fragment,l),X=!1},d(l){l&&(s(o),s(r),s(w),s(U),s(v),s(I),s(V),s(W),s(g),s(R),s($),s(B),s(k),s(j)),b(h,l),b(C,l),b(_,l)}}}function Vt(F){let o,Z="Quantizing a model in 4-bit reduces your memory-usage by 4x:",r,w,d=`As <code>bitsandbytes</code> is supported in both <code>transformers</code> and <code>diffusers</code> we can quantize both the
<code>FluxTransformer2DModel</code> and <code>T5EncoderModel</code>.`,U,h,v,I,G=`By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>.
You can change the data type of these modules with the <code>torch_dtype</code> parameter if you want:`,V,C,W,g,N="Let’s generate an image using our quantized models.",R,_,$,B,q='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png" alt="4 bit image"/>',k,j,Q=`Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.
The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights.
You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.`,X;return h=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=True,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)</span>`,wrap:!1}}),C=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=True,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)</span>`,wrap:!1}}),_=new E({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9rd2FyZ3MlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEElMEFpbWFnZS5yZXNpemUoKDIyNCUyQyUyMDIyNCkp",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=&quot;</span>auto<span class="hljs-string">&quot;,
)

pipe_kwargs = {
    &quot;</span>prompt<span class="hljs-string">&quot;: &quot;</span>A cat holding a sign that says hello world<span class="hljs-string">&quot;,
    &quot;</span>height<span class="hljs-string">&quot;: 1024,
    &quot;</span>width<span class="hljs-string">&quot;: 1024,
    &quot;</span>guidance_scale<span class="hljs-string">&quot;: 3.5,
    &quot;</span>num_inference_steps<span class="hljs-string">&quot;: 50,
    &quot;</span>max_sequence_length<span class="hljs-string">&quot;: 512,
}

image = pipe(
    generator=torch.Generator(&quot;</span>cp<span class="hljs-string">u&quot;).manual_seed(0),
    **pipe_kwargs,
).images[0]

image.resize((224, 224))</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=Z,r=a(),w=p("p"),w.innerHTML=d,U=a(),f(h.$$.fragment),v=a(),I=p("p"),I.innerHTML=G,V=a(),f(C.$$.fragment),W=a(),g=p("p"),g.textContent=N,R=a(),f(_.$$.fragment),$=a(),B=p("p"),B.innerHTML=q,k=a(),j=p("p"),j.innerHTML=Q},l(l){o=y(l,"P",{"data-svelte-h":!0}),c(o)!=="svelte-i07c71"&&(o.textContent=Z),r=i(l),w=y(l,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1hnraos"&&(w.innerHTML=d),U=i(l),J(h.$$.fragment,l),v=i(l),I=y(l,"P",{"data-svelte-h":!0}),c(I)!=="svelte-8rk7w0"&&(I.innerHTML=G),V=i(l),J(C.$$.fragment,l),W=i(l),g=y(l,"P",{"data-svelte-h":!0}),c(g)!=="svelte-2bde4h"&&(g.textContent=N),R=i(l),J(_.$$.fragment,l),$=i(l),B=y(l,"P",{"data-svelte-h":!0}),c(B)!=="svelte-q5jk5l"&&(B.innerHTML=q),k=i(l),j=y(l,"P",{"data-svelte-h":!0}),c(j)!=="svelte-6zq57e"&&(j.innerHTML=Q)},m(l,m){n(l,o,m),n(l,r,m),n(l,w,m),n(l,U,m),u(h,l,m),n(l,v,m),n(l,I,m),n(l,V,m),u(C,l,m),n(l,W,m),n(l,g,m),n(l,R,m),u(_,l,m),n(l,$,m),n(l,B,m),n(l,k,m),n(l,j,m),X=!0},p:Ie,i(l){X||(M(h.$$.fragment,l),M(C.$$.fragment,l),M(_.$$.fragment,l),X=!0)},o(l){T(h.$$.fragment,l),T(C.$$.fragment,l),T(_.$$.fragment,l),X=!1},d(l){l&&(s(o),s(r),s(w),s(U),s(v),s(I),s(V),s(W),s(g),s(R),s($),s(B),s(k),s(j)),b(h,l),b(C,l),b(_,l)}}}function Nt(F){let o,Z,r,w;return o=new _t({props:{id:"bnb",option:"8-bit",$$slots:{default:[Gt]},$$scope:{ctx:F}}}),r=new _t({props:{id:"bnb",option:"4-bit",$$slots:{default:[Vt]},$$scope:{ctx:F}}}),{c(){f(o.$$.fragment),Z=a(),f(r.$$.fragment)},l(d){J(o.$$.fragment,d),Z=i(d),J(r.$$.fragment,d)},m(d,U){u(o,d,U),n(d,Z,U),u(r,d,U),w=!0},p(d,U){const h={};U&2&&(h.$$scope={dirty:U,ctx:d}),o.$set(h);const v={};U&2&&(v.$$scope={dirty:U,ctx:d}),r.$set(v)},i(d){w||(M(o.$$.fragment,d),M(r.$$.fragment,d),w=!0)},o(d){T(o.$$.fragment,d),T(r.$$.fragment,d),w=!1},d(d){d&&s(Z),b(o,d),b(r,d)}}}function Qt(F){let o,Z="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){o=p("p"),o.innerHTML=Z},l(r){o=y(r,"P",{"data-svelte-h":!0}),c(o)!=="svelte-of9sym"&&(o.innerHTML=Z)},m(r,w){n(r,o,w)},p:Ie,d(r){r&&s(o)}}}function zt(F){let o,Z='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){o=p("p"),o.innerHTML=Z},l(r){o=y(r,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1bb05fp"&&(o.innerHTML=Z)},m(r,w){n(r,o,w)},p:Ie,d(r){r&&s(o)}}}function qt(F){let o,Z='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){o=p("p"),o.innerHTML=Z},l(r){o=y(r,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kpdzjq"&&(o.innerHTML=Z)},m(r,w){n(r,o,w)},p:Ie,d(r){r&&s(o)}}}function Yt(F){let o,Z,r,w,d,U,h,v=`<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing
a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8,
converts the non-outlier values back to fp16, and then adds them together to return the weights in
fp16. This reduces the degradative effect outlier values have on a model’s performance.`,I,G,V=`4-bit quantization compresses a model even further, and it is commonly used with
<a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.`,C,W,g=`We’ll work with the
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev model</a>,
demonstrating how quantization can help you run it on less than 16GB of VRAM—even on a free Google
Colab instance.`,N,R,_='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',$,B,q="To use bitsandbytes, make sure you have the following libraries installed:",k,j,Q,X,l=`Now you can quantize a model by passing a <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>.
This works for any model in any modality, as long as it supports loading with
<a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.`,m,Y,Ce,x,ge,S,pt="Check your memory footprint with the <code>get_memory_footprint</code> method:",_e,D,We,L,yt=`Quantized models can be loaded from the <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to
specify the <code>quantization_config</code> parameters:`,Re,P,Xe,K,ve,H,Ee,O,dt=`This section explores some of the specific features of 8-bit models, such as outlier thresholds and
skipping module conversion.`,Fe,ee,$e,te,ct=`An “outlier” is a hidden state value greater than a certain threshold, and these values are computed
in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be
very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5,
but beyond that, there is a significant performance penalty. A good default threshold value is 6,
but a lower threshold may be needed for more unstable models (small models or finetuning).`,ke,se,ft=`To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code>
parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:`,Ge,le,Ve,ne,Ne,ae,Jt=`For some models, you don’t need to quantize every module to 8-bit which can actually cause instability.
For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>,
the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:`,Qe,ie,ze,oe,qe,A,Ye,re,ut=`This section explores some of the specific features of 4-bit models, such as changing the compute
data type, using the Normal Float 4 (NF4) data type, and using nested quantization.`,xe,me,He,pe,Mt=`To speedup computation, you can change the data type from float32 (the default value) to bf16 using
the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:`,Ae,ye,Se,de,De,ce,Tt=`NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for
weights initialized from a normal distribution. You should use NF4 for training 4-bit base models.
This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:`,Le,fe,Pe,Je,bt=`For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to
remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and
<code>torch_dtype</code> values.`,Ke,ue,Oe,Me,wt=`Nested quantization is a technique that can save additional memory at no additional performance cost.
This feature performs a second quantization of the already quantized weights to save an additional
0.4 bits/parameter.`,et,Te,tt,be,st,we,ht=`Once quantized, you can dequantize the model to the original precision but this might result in a
small quality loss of the model. Make sure you have enough GPU RAM to fit the dequantized model.`,lt,he,nt,Ze,at,Ue,Zt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://gist.github.com/sayakpaul/05afd428bc089b47af7c016e42004527" rel="nofollow">Training</a></li>',it,Be,ot,je,rt;return d=new z({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),j=new E({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),Y=new kt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Nt]},$$scope:{ctx:F}}}),x=new mt({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:F}}}),D=new E({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),P=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZmbHV4LjEtZGV2LW5mNC1wa2clMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),K=new z({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),H=new mt({props:{$$slots:{default:[zt]},$$scope:{ctx:F}}}),ee=new z({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),le=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ne=new z({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ie=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),oe=new z({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),A=new mt({props:{$$slots:{default:[qt]},$$scope:{ctx:F}}}),me=new z({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),ye=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),de=new z({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),fe=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBKSUwQSUwQXRyYW5zZm9ybWVyXzRiaXQlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=True,
    bnb_4bit_quant_type=&quot;</span>nf4<span class="hljs-string">&quot;,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)</span>`,wrap:!1}}),ue=new z({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),Te=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=True,
    bnb_4bit_use_double_quant=True,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)</span>`,wrap:!1}}),be=new z({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),he=new E({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0LmRlcXVhbnRpemUoKSUwQXRyYW5zZm9ybWVyXzRiaXQuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev,
    subfolder=&quot;</span>text_encoder_2<span class="hljs-string">&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=True,
    bnb_4bit_use_double_quant=True,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;</span>black-forest-labs/FLUX<span class="hljs-number">.1</span>-dev<span class="hljs-string">&quot;,
    subfolder=&quot;</span>transforme<span class="hljs-string">r&quot;,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()</span>`,wrap:!1}}),Ze=new z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Be=new $t({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=p("meta"),Z=a(),r=p("p"),w=a(),f(d.$$.fragment),U=a(),h=p("p"),h.innerHTML=v,I=a(),G=p("p"),G.innerHTML=V,C=a(),W=p("p"),W.innerHTML=g,N=a(),R=p("p"),R.innerHTML=_,$=a(),B=p("p"),B.textContent=q,k=a(),f(j.$$.fragment),Q=a(),X=p("p"),X.innerHTML=l,m=a(),f(Y.$$.fragment),Ce=a(),f(x.$$.fragment),ge=a(),S=p("p"),S.innerHTML=pt,_e=a(),f(D.$$.fragment),We=a(),L=p("p"),L.innerHTML=yt,Re=a(),f(P.$$.fragment),Xe=a(),f(K.$$.fragment),ve=a(),f(H.$$.fragment),Ee=a(),O=p("p"),O.textContent=dt,Fe=a(),f(ee.$$.fragment),$e=a(),te=p("p"),te.textContent=ct,ke=a(),se=p("p"),se.innerHTML=ft,Ge=a(),f(le.$$.fragment),Ve=a(),f(ne.$$.fragment),Ne=a(),ae=p("p"),ae.innerHTML=Jt,Qe=a(),f(ie.$$.fragment),ze=a(),f(oe.$$.fragment),qe=a(),f(A.$$.fragment),Ye=a(),re=p("p"),re.textContent=ut,xe=a(),f(me.$$.fragment),He=a(),pe=p("p"),pe.innerHTML=Mt,Ae=a(),f(ye.$$.fragment),Se=a(),f(de.$$.fragment),De=a(),ce=p("p"),ce.innerHTML=Tt,Le=a(),f(fe.$$.fragment),Pe=a(),Je=p("p"),Je.innerHTML=bt,Ke=a(),f(ue.$$.fragment),Oe=a(),Me=p("p"),Me.textContent=wt,et=a(),f(Te.$$.fragment),tt=a(),f(be.$$.fragment),st=a(),we=p("p"),we.textContent=ht,lt=a(),f(he.$$.fragment),nt=a(),f(Ze.$$.fragment),at=a(),Ue=p("ul"),Ue.innerHTML=Zt,it=a(),f(Be.$$.fragment),ot=a(),je=p("p"),this.h()},l(e){const t=Et("svelte-u9bgzb",document.head);o=y(t,"META",{name:!0,content:!0}),t.forEach(s),Z=i(e),r=y(e,"P",{}),Ct(r).forEach(s),w=i(e),J(d.$$.fragment,e),U=i(e),h=y(e,"P",{"data-svelte-h":!0}),c(h)!=="svelte-9iu2px"&&(h.innerHTML=v),I=i(e),G=y(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-s74kvx"&&(G.innerHTML=V),C=i(e),W=y(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1pfg8nh"&&(W.innerHTML=g),N=i(e),R=y(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-ryfe7d"&&(R.innerHTML=_),$=i(e),B=y(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-gf36q7"&&(B.textContent=q),k=i(e),J(j.$$.fragment,e),Q=i(e),X=y(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1wjujhr"&&(X.innerHTML=l),m=i(e),J(Y.$$.fragment,e),Ce=i(e),J(x.$$.fragment,e),ge=i(e),S=y(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-139tok6"&&(S.innerHTML=pt),_e=i(e),J(D.$$.fragment,e),We=i(e),L=y(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1j1q7u3"&&(L.innerHTML=yt),Re=i(e),J(P.$$.fragment,e),Xe=i(e),J(K.$$.fragment,e),ve=i(e),J(H.$$.fragment,e),Ee=i(e),O=y(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-rptgqk"&&(O.textContent=dt),Fe=i(e),J(ee.$$.fragment,e),$e=i(e),te=y(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-da0i5h"&&(te.textContent=ct),ke=i(e),se=y(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-4ebsi9"&&(se.innerHTML=ft),Ge=i(e),J(le.$$.fragment,e),Ve=i(e),J(ne.$$.fragment,e),Ne=i(e),ae=y(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-14ra3du"&&(ae.innerHTML=Jt),Qe=i(e),J(ie.$$.fragment,e),ze=i(e),J(oe.$$.fragment,e),qe=i(e),J(A.$$.fragment,e),Ye=i(e),re=y(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-e57g91"&&(re.textContent=ut),xe=i(e),J(me.$$.fragment,e),He=i(e),pe=y(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-n8pvoc"&&(pe.innerHTML=Mt),Ae=i(e),J(ye.$$.fragment,e),Se=i(e),J(de.$$.fragment,e),De=i(e),ce=y(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1230s3e"&&(ce.innerHTML=Tt),Le=i(e),J(fe.$$.fragment,e),Pe=i(e),Je=y(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1m2nvbx"&&(Je.innerHTML=bt),Ke=i(e),J(ue.$$.fragment,e),Oe=i(e),Me=y(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1um8heb"&&(Me.textContent=wt),et=i(e),J(Te.$$.fragment,e),tt=i(e),J(be.$$.fragment,e),st=i(e),we=y(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-rcjebb"&&(we.textContent=ht),lt=i(e),J(he.$$.fragment,e),nt=i(e),J(Ze.$$.fragment,e),at=i(e),Ue=y(e,"UL",{"data-svelte-h":!0}),c(Ue)!=="svelte-vejlmz"&&(Ue.innerHTML=Zt),it=i(e),J(Be.$$.fragment,e),ot=i(e),je=y(e,"P",{}),Ct(je).forEach(s),this.h()},h(){gt(o,"name","hf:doc:metadata"),gt(o,"content",xt)},m(e,t){Ft(document.head,o),n(e,Z,t),n(e,r,t),n(e,w,t),u(d,e,t),n(e,U,t),n(e,h,t),n(e,I,t),n(e,G,t),n(e,C,t),n(e,W,t),n(e,N,t),n(e,R,t),n(e,$,t),n(e,B,t),n(e,k,t),u(j,e,t),n(e,Q,t),n(e,X,t),n(e,m,t),u(Y,e,t),n(e,Ce,t),u(x,e,t),n(e,ge,t),n(e,S,t),n(e,_e,t),u(D,e,t),n(e,We,t),n(e,L,t),n(e,Re,t),u(P,e,t),n(e,Xe,t),u(K,e,t),n(e,ve,t),u(H,e,t),n(e,Ee,t),n(e,O,t),n(e,Fe,t),u(ee,e,t),n(e,$e,t),n(e,te,t),n(e,ke,t),n(e,se,t),n(e,Ge,t),u(le,e,t),n(e,Ve,t),u(ne,e,t),n(e,Ne,t),n(e,ae,t),n(e,Qe,t),u(ie,e,t),n(e,ze,t),u(oe,e,t),n(e,qe,t),u(A,e,t),n(e,Ye,t),n(e,re,t),n(e,xe,t),u(me,e,t),n(e,He,t),n(e,pe,t),n(e,Ae,t),u(ye,e,t),n(e,Se,t),u(de,e,t),n(e,De,t),n(e,ce,t),n(e,Le,t),u(fe,e,t),n(e,Pe,t),n(e,Je,t),n(e,Ke,t),u(ue,e,t),n(e,Oe,t),n(e,Me,t),n(e,et,t),u(Te,e,t),n(e,tt,t),u(be,e,t),n(e,st,t),n(e,we,t),n(e,lt,t),u(he,e,t),n(e,nt,t),u(Ze,e,t),n(e,at,t),n(e,Ue,t),n(e,it,t),u(Be,e,t),n(e,ot,t),n(e,je,t),rt=!0},p(e,[t]){const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),Y.$set(Ut);const Bt={};t&2&&(Bt.$$scope={dirty:t,ctx:e}),x.$set(Bt);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),H.$set(jt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),A.$set(It)},i(e){rt||(M(d.$$.fragment,e),M(j.$$.fragment,e),M(Y.$$.fragment,e),M(x.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(H.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(A.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(de.$$.fragment,e),M(fe.$$.fragment,e),M(ue.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(he.$$.fragment,e),M(Ze.$$.fragment,e),M(Be.$$.fragment,e),rt=!0)},o(e){T(d.$$.fragment,e),T(j.$$.fragment,e),T(Y.$$.fragment,e),T(x.$$.fragment,e),T(D.$$.fragment,e),T(P.$$.fragment,e),T(K.$$.fragment,e),T(H.$$.fragment,e),T(ee.$$.fragment,e),T(le.$$.fragment,e),T(ne.$$.fragment,e),T(ie.$$.fragment,e),T(oe.$$.fragment,e),T(A.$$.fragment,e),T(me.$$.fragment,e),T(ye.$$.fragment,e),T(de.$$.fragment,e),T(fe.$$.fragment,e),T(ue.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(he.$$.fragment,e),T(Ze.$$.fragment,e),T(Be.$$.fragment,e),rt=!1},d(e){e&&(s(Z),s(r),s(w),s(U),s(h),s(I),s(G),s(C),s(W),s(N),s(R),s($),s(B),s(k),s(Q),s(X),s(m),s(Ce),s(ge),s(S),s(_e),s(We),s(L),s(Re),s(Xe),s(ve),s(Ee),s(O),s(Fe),s($e),s(te),s(ke),s(se),s(Ge),s(Ve),s(Ne),s(ae),s(Qe),s(ze),s(qe),s(Ye),s(re),s(xe),s(He),s(pe),s(Ae),s(Se),s(De),s(ce),s(Le),s(Pe),s(Je),s(Ke),s(Oe),s(Me),s(et),s(tt),s(st),s(we),s(lt),s(nt),s(at),s(Ue),s(it),s(ot),s(je)),s(o),b(d,e),b(j,e),b(Y,e),b(x,e),b(D,e),b(P,e),b(K,e),b(H,e),b(ee,e),b(le,e),b(ne,e),b(ie,e),b(oe,e),b(A,e),b(me,e),b(ye,e),b(de,e),b(fe,e),b(ue,e),b(Te,e),b(be,e),b(he,e),b(Ze,e),b(Be,e)}}}const xt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ht(F){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Xt{constructor(o){super(),vt(this,o,Ht,Yt,Wt,{})}}export{Ot as component};
