import{s as ga,o as _a,n as ar}from"../chunks/scheduler.9991993c.js";import{S as va,i as xa,g as n,s as o,r as p,A as $a,h as l,f as t,c as a,j as $,u as f,x as c,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as uo}from"../chunks/Tip.9de92fc6.js";import{D as M}from"../chunks/Docstring.0d7e3ebb.js";import{C as lr}from"../chunks/CodeBlock.e11cba92.js";import{E as ho}from"../chunks/ExampleCodeBlock.46b9776a.js";import{H as pe,E as ba}from"../chunks/EditOnGithub.84ab7f0e.js";function ya(J){let d,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_29693/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_29693/zh/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11xdja3"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:ar,d(v){v&&t(d)}}}function Ma(J){let d,T="Examples:",v,x,C;return x=new lr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=o(),p(x.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,d,I),i(m,v,I),u(x,m,I),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(d),t(v)),_(x,m)}}}function wa(J){let d,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=n("p"),d.textContent=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-15rpg4"&&(d.textContent=T)},m(v,x){i(v,d,x)},p:ar,d(v){v&&t(d)}}}function Ta(J){let d,T=`This class method is simply calling <a href="/docs/transformers/pr_29693/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_29693/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-gtdh0u"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:ar,d(v){v&&t(d)}}}function Ca(J){let d,T="Examples:",v,x,C;return x=new lr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=o(),p(x.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,d,I),i(m,v,I),u(x,m,I),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(d),t(v)),_(x,m)}}}function Pa(J){let d,T="Example:",v,x,C;return x=new lr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=o(),p(x.$$.fragment)},l(m){d=l(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11lpom8"&&(d.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,d,I),i(m,v,I),u(x,m,I),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(d),t(v)),_(x,m)}}}function Ia(J){let d,T,v,x,C,m,I,go="在 Transformers 库中，processors可以有两种不同的含义：",ir,fe,_o='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',cr,ue,dr,he,vo="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",mr,ge,xo="这些processors继承自以下实现保存和加载功能的基类：",pr,y,_e,ps,Tt,$o="This is a mixin used to provide saving/loading functionality for all processor classes.",fs,S,ve,us,Ct,bo=`Similar to the <code>apply_chat_template</code> method on tokenizers, this method applies a Jinja template to input
conversations to turn them into a single tokenizable string.`,hs,D,xe,gs,Pt,yo="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",_s,Z,$e,vs,It,Mo="Instantiate a processor associated with a pretrained model.",xs,G,$s,R,be,bs,kt,wo=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,ys,z,ye,Ms,Xt,To="Upload the processor files to the 🤗 Model Hub.",ws,W,Ts,V,Me,Cs,Jt,Co=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Ps,Q,Is,q,we,ks,jt,Po=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Xs,Y,Js,A,Te,js,Ut,Io="Serializes this instance to a Python dictionary.",Us,O,Ce,Ls,Lt,ko="Save this instance to a JSON file.",Zs,K,Pe,zs,Zt,Xo="Serializes this instance to a JSON string.",fr,Ie,ur,ke,Jo='所有processor都遵循与 <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',hr,P,Xe,Vs,zt,jo="Base class for data converters for sequence classification data sets.",qs,ee,Je,Es,Vt,Uo='Gets a collection of <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Hs,te,je,Ns,qt,Lo="Gets an example from a dict with tensorflow tensors.",Fs,re,Ue,Bs,Et,Zo="Gets the list of labels for this data set.",Ss,se,Le,Ds,Ht,zo='Gets a collection of <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Gs,oe,Ze,Rs,Nt,Vo='Gets a collection of <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Ws,ae,ze,Qs,Ft,qo=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,gr,j,Ve,Ys,Bt,Eo="A single training/test example for simple sequence classification.",As,ne,qe,Os,St,Ho="Serializes this instance to a JSON string.",_r,U,Ee,Ks,Dt,No="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",eo,le,He,to,Gt,Fo="Serializes this instance to a JSON string.",vr,Ne,xr,Fe,Bo='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',$r,Be,So="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",br,Se,Do="这些processor是：",yr,De,Go="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",Mr,Ge,Ro='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/pr_29693/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',wr,N,Re,ro,Rt,Wo="Loads a data file into a list of <code>InputFeatures</code>",Tr,We,Cr,Qe,Qo='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',Pr,Ye,Yo='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',Ir,Ae,Ao="该库提供了加载XNLI数据的processor：",kr,Oe,Oo="<li><code>~data.processors.utils.XnliProcessor</code></li>",Xr,Ke,Ko="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",Jr,et,ea='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',jr,tt,Ur,rt,ta='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',Lr,st,ra="该库为两个版本各自提供了一个processor：",Zr,ot,zr,at,sa="这两个processor是：",Vr,nt,oa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",qr,lt,aa="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",Er,X,it,so,Wt,na=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,oo,ie,ct,ao,Qt,la="Returns the evaluation example from the data directory.",no,E,dt,lo,Yt,ia="Creates a list of <code>SquadExample</code> using a TFDS dataset.",io,ce,co,de,mt,mo,At,ca="Returns the training examples from the data directory.",Hr,pt,da="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",Nr,L,ft,po,Ot,ma=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,fo,me,Fr,ut,pa="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",Br,ht,Sr,gt,fa="以下是使用processor以及使用数据文件的转换方法的示例：",Dr,_t,Gr,vt,ua="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Rr,xt,Wr,$t,ha='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Qr,bt,Yr,nr,Ar;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L312"}}),ve=new M({props:{name:"apply_chat_template",anchor:"transformers.ProcessorMixin.apply_chat_template",parameters:[{name:"conversation",val:": List"},{name:"chat_template",val:": Optional = None"},{name:"tokenize",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.apply_chat_template.conversation",description:`<strong>conversation</strong> (<code>List[Dict, str, str]</code>) &#x2014;
The conversation to format.`,name:"conversation"},{anchor:"transformers.ProcessorMixin.apply_chat_template.chat_template",description:`<strong>chat_template</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The Jinja template to use for formatting the conversation. If not provided, the default chat template
is used.`,name:"chat_template"},{anchor:"transformers.ProcessorMixin.apply_chat_template.tokenize",description:`<strong>tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tokenize the output or not.
**kwargs &#x2014;
Additional keyword arguments`,name:"tokenize"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L890"}}),xe=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),$e=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_29693/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_29693/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L777"}}),G=new uo({props:{$$slots:{default:[ya]},$$scope:{ctx:J}}}),be=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L517",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),ye=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/utils/hub.py#L809"}}),W=new ho({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Ma]},$$scope:{ctx:J}}}),Me=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L841"}}),Q=new uo({props:{warning:!0,$$slots:{default:[wa]},$$scope:{ctx:J}}}),we=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_29693/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L428"}}),Y=new uo({props:{$$slots:{default:[Ta]},$$scope:{ctx:J}}}),Te=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ce=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L412"}}),Pe=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/processing_utils.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ie=new pe({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Xe=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L80"}}),Je=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L97"}}),je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L83"}}),Ue=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L105"}}),Le=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L101"}}),Ze=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L93"}}),ze=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L109"}}),Ve=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L29"}}),qe=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L49"}}),Ee=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L54"}}),He=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/utils.py#L75"}}),Ne=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Re=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),tt=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),ot=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),it=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/squad.py#L541"}}),ct=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),ce=new ho({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[Ca]},$$scope:{ctx:J}}}),mt=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/squad.py#L607"}}),ft=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/vr_29693/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new ho({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[Pa]},$$scope:{ctx:J}}}),ht=new pe({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),_t=new lr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),xt=new lr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),bt=new ba({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/main_classes/processors.md"}}),{c(){d=n("meta"),T=o(),v=n("p"),x=o(),p(C.$$.fragment),m=o(),I=n("p"),I.textContent=go,ir=o(),fe=n("ul"),fe.innerHTML=_o,cr=o(),p(ue.$$.fragment),dr=o(),he=n("p"),he.textContent=vo,mr=o(),ge=n("p"),ge.textContent=xo,pr=o(),y=n("div"),p(_e.$$.fragment),ps=o(),Tt=n("p"),Tt.textContent=$o,fs=o(),S=n("div"),p(ve.$$.fragment),us=o(),Ct=n("p"),Ct.innerHTML=bo,hs=o(),D=n("div"),p(xe.$$.fragment),gs=o(),Pt=n("p"),Pt.innerHTML=yo,_s=o(),Z=n("div"),p($e.$$.fragment),vs=o(),It=n("p"),It.textContent=Mo,xs=o(),p(G.$$.fragment),$s=o(),R=n("div"),p(be.$$.fragment),bs=o(),kt=n("p"),kt.innerHTML=wo,ys=o(),z=n("div"),p(ye.$$.fragment),Ms=o(),Xt=n("p"),Xt.textContent=To,ws=o(),p(W.$$.fragment),Ts=o(),V=n("div"),p(Me.$$.fragment),Cs=o(),Jt=n("p"),Jt.innerHTML=Co,Ps=o(),p(Q.$$.fragment),Is=o(),q=n("div"),p(we.$$.fragment),ks=o(),jt=n("p"),jt.innerHTML=Po,Xs=o(),p(Y.$$.fragment),Js=o(),A=n("div"),p(Te.$$.fragment),js=o(),Ut=n("p"),Ut.textContent=Io,Us=o(),O=n("div"),p(Ce.$$.fragment),Ls=o(),Lt=n("p"),Lt.textContent=ko,Zs=o(),K=n("div"),p(Pe.$$.fragment),zs=o(),Zt=n("p"),Zt.textContent=Xo,fr=o(),p(Ie.$$.fragment),ur=o(),ke=n("p"),ke.innerHTML=Jo,hr=o(),P=n("div"),p(Xe.$$.fragment),Vs=o(),zt=n("p"),zt.textContent=jo,qs=o(),ee=n("div"),p(Je.$$.fragment),Es=o(),Vt=n("p"),Vt.innerHTML=Uo,Hs=o(),te=n("div"),p(je.$$.fragment),Ns=o(),qt=n("p"),qt.textContent=Lo,Fs=o(),re=n("div"),p(Ue.$$.fragment),Bs=o(),Et=n("p"),Et.textContent=Zo,Ss=o(),se=n("div"),p(Le.$$.fragment),Ds=o(),Ht=n("p"),Ht.innerHTML=zo,Gs=o(),oe=n("div"),p(Ze.$$.fragment),Rs=o(),Nt=n("p"),Nt.innerHTML=Vo,Ws=o(),ae=n("div"),p(ze.$$.fragment),Qs=o(),Ft=n("p"),Ft.textContent=qo,gr=o(),j=n("div"),p(Ve.$$.fragment),Ys=o(),Bt=n("p"),Bt.textContent=Eo,As=o(),ne=n("div"),p(qe.$$.fragment),Os=o(),St=n("p"),St.textContent=Ho,_r=o(),U=n("div"),p(Ee.$$.fragment),Ks=o(),Dt=n("p"),Dt.textContent=No,eo=o(),le=n("div"),p(He.$$.fragment),to=o(),Gt=n("p"),Gt.textContent=Fo,vr=o(),p(Ne.$$.fragment),xr=o(),Fe=n("p"),Fe.innerHTML=Bo,$r=o(),Be=n("p"),Be.textContent=So,br=o(),Se=n("p"),Se.textContent=Do,yr=o(),De=n("ul"),De.innerHTML=Go,Mr=o(),Ge=n("p"),Ge.innerHTML=Ro,wr=o(),N=n("div"),p(Re.$$.fragment),ro=o(),Rt=n("p"),Rt.innerHTML=Wo,Tr=o(),p(We.$$.fragment),Cr=o(),Qe=n("p"),Qe.innerHTML=Qo,Pr=o(),Ye=n("p"),Ye.innerHTML=Yo,Ir=o(),Ae=n("p"),Ae.textContent=Ao,kr=o(),Oe=n("ul"),Oe.innerHTML=Oo,Xr=o(),Ke=n("p"),Ke.textContent=Ko,Jr=o(),et=n("p"),et.innerHTML=ea,jr=o(),p(tt.$$.fragment),Ur=o(),rt=n("p"),rt.innerHTML=ta,Lr=o(),st=n("p"),st.textContent=ra,Zr=o(),p(ot.$$.fragment),zr=o(),at=n("p"),at.textContent=sa,Vr=o(),nt=n("ul"),nt.innerHTML=oa,qr=o(),lt=n("p"),lt.innerHTML=aa,Er=o(),X=n("div"),p(it.$$.fragment),so=o(),Wt=n("p"),Wt.textContent=na,oo=o(),ie=n("div"),p(ct.$$.fragment),ao=o(),Qt=n("p"),Qt.textContent=la,no=o(),E=n("div"),p(dt.$$.fragment),lo=o(),Yt=n("p"),Yt.innerHTML=ia,io=o(),p(ce.$$.fragment),co=o(),de=n("div"),p(mt.$$.fragment),mo=o(),At=n("p"),At.textContent=ca,Hr=o(),pt=n("p"),pt.innerHTML=da,Nr=o(),L=n("div"),p(ft.$$.fragment),po=o(),Ot=n("p"),Ot.textContent=ma,fo=o(),p(me.$$.fragment),Fr=o(),ut=n("p"),ut.textContent=pa,Br=o(),p(ht.$$.fragment),Sr=o(),gt=n("p"),gt.textContent=fa,Dr=o(),p(_t.$$.fragment),Gr=o(),vt=n("p"),vt.innerHTML=ua,Rr=o(),p(xt.$$.fragment),Wr=o(),$t=n("p"),$t.innerHTML=ha,Qr=o(),p(bt.$$.fragment),Yr=o(),nr=n("p"),this.h()},l(e){const r=$a("svelte-u9bgzb",document.head);d=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=l(e,"P",{}),$(v).forEach(t),x=a(e),f(C.$$.fragment,e),m=a(e),I=l(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1fd9lf0"&&(I.textContent=go),ir=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),c(fe)!=="svelte-rmvfpp"&&(fe.innerHTML=_o),cr=a(e),f(ue.$$.fragment,e),dr=a(e),he=l(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-ctzpmo"&&(he.textContent=vo),mr=a(e),ge=l(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-9fh2y4"&&(ge.textContent=xo),pr=a(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ps=a(w),Tt=l(w,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1s4wckx"&&(Tt.textContent=$o),fs=a(w),S=l(w,"DIV",{class:!0});var yt=$(S);f(ve.$$.fragment,yt),us=a(yt),Ct=l(yt,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-10dqwuv"&&(Ct.innerHTML=bo),yt.forEach(t),hs=a(w),D=l(w,"DIV",{class:!0});var Mt=$(D);f(xe.$$.fragment,Mt),gs=a(Mt),Pt=l(Mt,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-1i2d3vx"&&(Pt.innerHTML=yo),Mt.forEach(t),_s=a(w),Z=l(w,"DIV",{class:!0});var F=$(Z);f($e.$$.fragment,F),vs=a(F),It=l(F,"P",{"data-svelte-h":!0}),c(It)!=="svelte-1cj8dcb"&&(It.textContent=Mo),xs=a(F),f(G.$$.fragment,F),F.forEach(t),$s=a(w),R=l(w,"DIV",{class:!0});var wt=$(R);f(be.$$.fragment,wt),bs=a(wt),kt=l(wt,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-hsvutq"&&(kt.innerHTML=wo),wt.forEach(t),ys=a(w),z=l(w,"DIV",{class:!0});var B=$(z);f(ye.$$.fragment,B),Ms=a(B),Xt=l(B,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1cwsjho"&&(Xt.textContent=To),ws=a(B),f(W.$$.fragment,B),B.forEach(t),Ts=a(w),V=l(w,"DIV",{class:!0});var Kt=$(V);f(Me.$$.fragment,Kt),Cs=a(Kt),Jt=l(Kt,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-hhsvto"&&(Jt.innerHTML=Co),Ps=a(Kt),f(Q.$$.fragment,Kt),Kt.forEach(t),Is=a(w),q=l(w,"DIV",{class:!0});var er=$(q);f(we.$$.fragment,er),ks=a(er),jt=l(er,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-n63m6d"&&(jt.innerHTML=Po),Xs=a(er),f(Y.$$.fragment,er),er.forEach(t),Js=a(w),A=l(w,"DIV",{class:!0});var Or=$(A);f(Te.$$.fragment,Or),js=a(Or),Ut=l(Or,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1ww3wqq"&&(Ut.textContent=Io),Or.forEach(t),Us=a(w),O=l(w,"DIV",{class:!0});var Kr=$(O);f(Ce.$$.fragment,Kr),Ls=a(Kr),Lt=l(Kr,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1g70y32"&&(Lt.textContent=ko),Kr.forEach(t),Zs=a(w),K=l(w,"DIV",{class:!0});var es=$(K);f(Pe.$$.fragment,es),zs=a(es),Zt=l(es,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-5ayq1f"&&(Zt.textContent=Xo),es.forEach(t),w.forEach(t),fr=a(e),f(Ie.$$.fragment,e),ur=a(e),ke=l(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1jooc9u"&&(ke.innerHTML=Jo),hr=a(e),P=l(e,"DIV",{class:!0});var k=$(P);f(Xe.$$.fragment,k),Vs=a(k),zt=l(k,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-1bsw04k"&&(zt.textContent=jo),qs=a(k),ee=l(k,"DIV",{class:!0});var ts=$(ee);f(Je.$$.fragment,ts),Es=a(ts),Vt=l(ts,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-1uk59k6"&&(Vt.innerHTML=Uo),ts.forEach(t),Hs=a(k),te=l(k,"DIV",{class:!0});var rs=$(te);f(je.$$.fragment,rs),Ns=a(rs),qt=l(rs,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-pplryq"&&(qt.textContent=Lo),rs.forEach(t),Fs=a(k),re=l(k,"DIV",{class:!0});var ss=$(re);f(Ue.$$.fragment,ss),Bs=a(ss),Et=l(ss,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-3oqyjr"&&(Et.textContent=Zo),ss.forEach(t),Ss=a(k),se=l(k,"DIV",{class:!0});var os=$(se);f(Le.$$.fragment,os),Ds=a(os),Ht=l(os,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-hfjcj9"&&(Ht.innerHTML=zo),os.forEach(t),Gs=a(k),oe=l(k,"DIV",{class:!0});var as=$(oe);f(Ze.$$.fragment,as),Rs=a(as),Nt=l(as,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-zqjj9v"&&(Nt.innerHTML=Vo),as.forEach(t),Ws=a(k),ae=l(k,"DIV",{class:!0});var ns=$(ae);f(ze.$$.fragment,ns),Qs=a(ns),Ft=l(ns,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1jevh15"&&(Ft.textContent=qo),ns.forEach(t),k.forEach(t),gr=a(e),j=l(e,"DIV",{class:!0});var tr=$(j);f(Ve.$$.fragment,tr),Ys=a(tr),Bt=l(tr,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-vkt0pi"&&(Bt.textContent=Eo),As=a(tr),ne=l(tr,"DIV",{class:!0});var ls=$(ne);f(qe.$$.fragment,ls),Os=a(ls),St=l(ls,"P",{"data-svelte-h":!0}),c(St)!=="svelte-5ayq1f"&&(St.textContent=Ho),ls.forEach(t),tr.forEach(t),_r=a(e),U=l(e,"DIV",{class:!0});var rr=$(U);f(Ee.$$.fragment,rr),Ks=a(rr),Dt=l(rr,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-168wf64"&&(Dt.textContent=No),eo=a(rr),le=l(rr,"DIV",{class:!0});var is=$(le);f(He.$$.fragment,is),to=a(is),Gt=l(is,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-5ayq1f"&&(Gt.textContent=Fo),is.forEach(t),rr.forEach(t),vr=a(e),f(Ne.$$.fragment,e),xr=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-pf4p60"&&(Fe.innerHTML=Bo),$r=a(e),Be=l(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-17867sm"&&(Be.textContent=So),br=a(e),Se=l(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-190jb0p"&&(Se.textContent=Do),yr=a(e),De=l(e,"UL",{"data-svelte-h":!0}),c(De)!=="svelte-my8qym"&&(De.innerHTML=Go),Mr=a(e),Ge=l(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-111jd8w"&&(Ge.innerHTML=Ro),wr=a(e),N=l(e,"DIV",{class:!0});var cs=$(N);f(Re.$$.fragment,cs),ro=a(cs),Rt=l(cs,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-5lvrve"&&(Rt.innerHTML=Wo),cs.forEach(t),Tr=a(e),f(We.$$.fragment,e),Cr=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-143feg"&&(Qe.innerHTML=Qo),Pr=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-1y5f8bi"&&(Ye.innerHTML=Yo),Ir=a(e),Ae=l(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-1n6xg4v"&&(Ae.textContent=Ao),kr=a(e),Oe=l(e,"UL",{"data-svelte-h":!0}),c(Oe)!=="svelte-1e2xq99"&&(Oe.innerHTML=Oo),Xr=a(e),Ke=l(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-1514ut0"&&(Ke.textContent=Ko),Jr=a(e),et=l(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-18t4sjl"&&(et.innerHTML=ea),jr=a(e),f(tt.$$.fragment,e),Ur=a(e),rt=l(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-1cqsmed"&&(rt.innerHTML=ta),Lr=a(e),st=l(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1hd0jdd"&&(st.textContent=ra),Zr=a(e),f(ot.$$.fragment,e),zr=a(e),at=l(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-utkcp6"&&(at.textContent=sa),Vr=a(e),nt=l(e,"UL",{"data-svelte-h":!0}),c(nt)!=="svelte-1qiv3qf"&&(nt.innerHTML=oa),qr=a(e),lt=l(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-165sa1k"&&(lt.innerHTML=aa),Er=a(e),X=l(e,"DIV",{class:!0});var H=$(X);f(it.$$.fragment,H),so=a(H),Wt=l(H,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-173gxyd"&&(Wt.textContent=na),oo=a(H),ie=l(H,"DIV",{class:!0});var ds=$(ie);f(ct.$$.fragment,ds),ao=a(ds),Qt=l(ds,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-wmaktk"&&(Qt.textContent=la),ds.forEach(t),no=a(H),E=l(H,"DIV",{class:!0});var sr=$(E);f(dt.$$.fragment,sr),lo=a(sr),Yt=l(sr,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-11nqnea"&&(Yt.innerHTML=ia),io=a(sr),f(ce.$$.fragment,sr),sr.forEach(t),co=a(H),de=l(H,"DIV",{class:!0});var ms=$(de);f(mt.$$.fragment,ms),mo=a(ms),At=l(ms,"P",{"data-svelte-h":!0}),c(At)!=="svelte-d5zv1x"&&(At.textContent=ca),ms.forEach(t),H.forEach(t),Hr=a(e),pt=l(e,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-7uap0d"&&(pt.innerHTML=da),Nr=a(e),L=l(e,"DIV",{class:!0});var or=$(L);f(ft.$$.fragment,or),po=a(or),Ot=l(or,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-169nh0g"&&(Ot.textContent=ma),fo=a(or),f(me.$$.fragment,or),or.forEach(t),Fr=a(e),ut=l(e,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1dp3thd"&&(ut.textContent=pa),Br=a(e),f(ht.$$.fragment,e),Sr=a(e),gt=l(e,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-1tuty7g"&&(gt.textContent=fa),Dr=a(e),f(_t.$$.fragment,e),Gr=a(e),vt=l(e,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1klp1tb"&&(vt.innerHTML=ua),Rr=a(e),f(xt.$$.fragment,e),Wr=a(e),$t=l(e,"P",{"data-svelte-h":!0}),c($t)!=="svelte-1mzejoo"&&($t.innerHTML=ha),Qr=a(e),f(bt.$$.fragment,e),Yr=a(e),nr=l(e,"P",{}),$(nr).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",ka),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,d),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,I,r),i(e,ir,r),i(e,fe,r),i(e,cr,r),u(ue,e,r),i(e,dr,r),i(e,he,r),i(e,mr,r),i(e,ge,r),i(e,pr,r),i(e,y,r),u(_e,y,null),s(y,ps),s(y,Tt),s(y,fs),s(y,S),u(ve,S,null),s(S,us),s(S,Ct),s(y,hs),s(y,D),u(xe,D,null),s(D,gs),s(D,Pt),s(y,_s),s(y,Z),u($e,Z,null),s(Z,vs),s(Z,It),s(Z,xs),u(G,Z,null),s(y,$s),s(y,R),u(be,R,null),s(R,bs),s(R,kt),s(y,ys),s(y,z),u(ye,z,null),s(z,Ms),s(z,Xt),s(z,ws),u(W,z,null),s(y,Ts),s(y,V),u(Me,V,null),s(V,Cs),s(V,Jt),s(V,Ps),u(Q,V,null),s(y,Is),s(y,q),u(we,q,null),s(q,ks),s(q,jt),s(q,Xs),u(Y,q,null),s(y,Js),s(y,A),u(Te,A,null),s(A,js),s(A,Ut),s(y,Us),s(y,O),u(Ce,O,null),s(O,Ls),s(O,Lt),s(y,Zs),s(y,K),u(Pe,K,null),s(K,zs),s(K,Zt),i(e,fr,r),u(Ie,e,r),i(e,ur,r),i(e,ke,r),i(e,hr,r),i(e,P,r),u(Xe,P,null),s(P,Vs),s(P,zt),s(P,qs),s(P,ee),u(Je,ee,null),s(ee,Es),s(ee,Vt),s(P,Hs),s(P,te),u(je,te,null),s(te,Ns),s(te,qt),s(P,Fs),s(P,re),u(Ue,re,null),s(re,Bs),s(re,Et),s(P,Ss),s(P,se),u(Le,se,null),s(se,Ds),s(se,Ht),s(P,Gs),s(P,oe),u(Ze,oe,null),s(oe,Rs),s(oe,Nt),s(P,Ws),s(P,ae),u(ze,ae,null),s(ae,Qs),s(ae,Ft),i(e,gr,r),i(e,j,r),u(Ve,j,null),s(j,Ys),s(j,Bt),s(j,As),s(j,ne),u(qe,ne,null),s(ne,Os),s(ne,St),i(e,_r,r),i(e,U,r),u(Ee,U,null),s(U,Ks),s(U,Dt),s(U,eo),s(U,le),u(He,le,null),s(le,to),s(le,Gt),i(e,vr,r),u(Ne,e,r),i(e,xr,r),i(e,Fe,r),i(e,$r,r),i(e,Be,r),i(e,br,r),i(e,Se,r),i(e,yr,r),i(e,De,r),i(e,Mr,r),i(e,Ge,r),i(e,wr,r),i(e,N,r),u(Re,N,null),s(N,ro),s(N,Rt),i(e,Tr,r),u(We,e,r),i(e,Cr,r),i(e,Qe,r),i(e,Pr,r),i(e,Ye,r),i(e,Ir,r),i(e,Ae,r),i(e,kr,r),i(e,Oe,r),i(e,Xr,r),i(e,Ke,r),i(e,Jr,r),i(e,et,r),i(e,jr,r),u(tt,e,r),i(e,Ur,r),i(e,rt,r),i(e,Lr,r),i(e,st,r),i(e,Zr,r),u(ot,e,r),i(e,zr,r),i(e,at,r),i(e,Vr,r),i(e,nt,r),i(e,qr,r),i(e,lt,r),i(e,Er,r),i(e,X,r),u(it,X,null),s(X,so),s(X,Wt),s(X,oo),s(X,ie),u(ct,ie,null),s(ie,ao),s(ie,Qt),s(X,no),s(X,E),u(dt,E,null),s(E,lo),s(E,Yt),s(E,io),u(ce,E,null),s(X,co),s(X,de),u(mt,de,null),s(de,mo),s(de,At),i(e,Hr,r),i(e,pt,r),i(e,Nr,r),i(e,L,r),u(ft,L,null),s(L,po),s(L,Ot),s(L,fo),u(me,L,null),i(e,Fr,r),i(e,ut,r),i(e,Br,r),u(ht,e,r),i(e,Sr,r),i(e,gt,r),i(e,Dr,r),u(_t,e,r),i(e,Gr,r),i(e,vt,r),i(e,Rr,r),u(xt,e,r),i(e,Wr,r),i(e,$t,r),i(e,Qr,r),u(bt,e,r),i(e,Yr,r),i(e,nr,r),Ar=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),W.$set(yt);const Mt={};r&2&&(Mt.$$scope={dirty:r,ctx:e}),Q.$set(Mt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),Y.$set(F);const wt={};r&2&&(wt.$$scope={dirty:r,ctx:e}),ce.$set(wt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),me.$set(B)},i(e){Ar||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(G.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(W.$$.fragment,e),h(Me.$$.fragment,e),h(Q.$$.fragment,e),h(we.$$.fragment,e),h(Y.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Le.$$.fragment,e),h(Ze.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(it.$$.fragment,e),h(ct.$$.fragment,e),h(dt.$$.fragment,e),h(ce.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(me.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h(bt.$$.fragment,e),Ar=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(G.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(W.$$.fragment,e),g(Me.$$.fragment,e),g(Q.$$.fragment,e),g(we.$$.fragment,e),g(Y.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(Xe.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(Le.$$.fragment,e),g(Ze.$$.fragment,e),g(ze.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ne.$$.fragment,e),g(Re.$$.fragment,e),g(We.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(it.$$.fragment,e),g(ct.$$.fragment,e),g(dt.$$.fragment,e),g(ce.$$.fragment,e),g(mt.$$.fragment,e),g(ft.$$.fragment,e),g(me.$$.fragment,e),g(ht.$$.fragment,e),g(_t.$$.fragment,e),g(xt.$$.fragment,e),g(bt.$$.fragment,e),Ar=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(I),t(ir),t(fe),t(cr),t(dr),t(he),t(mr),t(ge),t(pr),t(y),t(fr),t(ur),t(ke),t(hr),t(P),t(gr),t(j),t(_r),t(U),t(vr),t(xr),t(Fe),t($r),t(Be),t(br),t(Se),t(yr),t(De),t(Mr),t(Ge),t(wr),t(N),t(Tr),t(Cr),t(Qe),t(Pr),t(Ye),t(Ir),t(Ae),t(kr),t(Oe),t(Xr),t(Ke),t(Jr),t(et),t(jr),t(Ur),t(rt),t(Lr),t(st),t(Zr),t(zr),t(at),t(Vr),t(nt),t(qr),t(lt),t(Er),t(X),t(Hr),t(pt),t(Nr),t(L),t(Fr),t(ut),t(Br),t(Sr),t(gt),t(Dr),t(Gr),t(vt),t(Rr),t(Wr),t($t),t(Qr),t(Yr),t(nr)),t(d),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_($e),_(G),_(be),_(ye),_(W),_(Me),_(Q),_(we),_(Y),_(Te),_(Ce),_(Pe),_(Ie,e),_(Xe),_(Je),_(je),_(Ue),_(Le),_(Ze),_(ze),_(Ve),_(qe),_(Ee),_(He),_(Ne,e),_(Re),_(We,e),_(tt,e),_(ot,e),_(it),_(ct),_(dt),_(ce),_(mt),_(ft),_(me),_(ht,e),_(_t,e),_(xt,e),_(bt,e)}}}const ka='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xa(J){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends va{constructor(d){super(),xa(this,d,Xa,Ia,ga,{})}}export{qa as component};
