import{s as ys,o as ws,n as Ts}from"../chunks/scheduler.7da89386.js";import{S as Js,i as Zs,g as i,s as n,r as p,A as Us,h as o,f as l,c as a,j as fs,u as m,x as M,k as vl,y as Ws,a as s,v as d,d as r,t as c,w as u}from"../chunks/index.20910acc.js";import{T as gs}from"../chunks/Tip.53e22153.js";import{C as h}from"../chunks/CodeBlock.cde23137.js";import{H as b,E as js}from"../chunks/EditOnGithub.ba36cbd0.js";function Gs(Ae){let f,J="If not specified, <code>load_in_8bit</code> will be set to <code>True</code> by default when models larger than 1 billion parameters are exported to the OpenVINO format (with <code>export=True</code>). You can disable it with <code>load_in_8bit=False</code>.";return{c(){f=i("p"),f.innerHTML=J},l(y){f=o(y,"P",{"data-svelte-h":!0}),M(f)!=="svelte-pe94ru"&&(f.innerHTML=J)},m(y,Oe){s(y,f,Oe)},p:Ts,d(y){y&&l(f)}}}function vs(Ae){let f,J,y,Oe,Z,Pe,U,Vl='Optimum Intel can be used to load optimized models from the <a href="https://huggingface.co/models?library=openvino&amp;sort=downloads" rel="nofollow">Hub</a> and create pipelines to run inference with OpenVINO Runtime on a variety of Intel processors (<a href="https://docs.openvino.ai/2024/about-openvino/compatibility-and-support/supported-devices.html" rel="nofollow">see</a> the full list of supported devices)',Ke,W,et,g,Bl='Once <a href="export">your model was exported</a>, you can load it by replacing the <code>AutoModelForXxx</code> class with the corresponding <code>OVModelForXxx</code> class.',tt,j,lt,G,Il='See the <a href="reference">reference documentation</a> for more information about parameters, and examples for different tasks.',st,v,$l="As shown in the table below, each task is associated with a class enabling to automatically load your model.",nt,V,Xl="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-classification</code></td> <td><code>OVModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>OVModelForTokenClassification</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>OVModelForQuestionAnswering</code></td></tr> <tr><td><code>audio-classification</code></td> <td><code>OVModelForAudioClassification</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>OVModelForImageClassification</code></td></tr> <tr><td><code>feature-extraction</code></td> <td><code>OVModelForFeatureExtraction</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>OVModelForMaskedLM</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>OVModelForImageClassification</code></td></tr> <tr><td><code>audio-classification</code></td> <td><code>OVModelForAudioClassification</code></td></tr> <tr><td><code>text-generation-with-past</code></td> <td><code>OVModelForCausalLM</code></td></tr> <tr><td><code>text2text-generation-with-past</code></td> <td><code>OVModelForSeq2SeqLM</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>OVModelForSpeechSeq2Seq</code></td></tr> <tr><td><code>image-to-text</code></td> <td><code>OVModelForVision2Seq</code></td></tr></tbody>",at,B,it,I,xl="You can also apply fp16, 8-bit or 4-bit weight compression on the Linear, Convolutional and Embedding layers when loading your model to reduce the memory footprint and inference latency.",ot,$,kl='For more information on the quantization parameters checkout the <a href="optimziation#weight-only-quantization">documentation</a>.',pt,w,mt,X,Cl='It’s also possible to apply quantization on both weights and activations using the <code>OVQuantizer</code>, more information in the <a href="optimization#static-quantization">documentation</a>.',dt,x,rt,k,_l="By default, <code>OVModelForXxx</code> support dynamic shapes, enabling inputs of every shapes. To speed up inference, static shapes can be enabled by giving the desired inputs shapes.",ct,C,ut,_,Rl="When fixing the shapes with the <code>reshape()</code> method, inference cannot be performed with an input of a different shape. When instantiating your pipeline, you can specify the maximum total input sequence length after tokenization in order for shorter sequences to be padded and for longer sequences to be truncated.",Mt,R,ht,F,bt,S,Fl="By default the model will be compiled when instantiating our <code>OVModel</code>. In the case where the model is reshaped or placed to another device, the model will need to be recompiled again, which will happen by default before the first inference (thus inflating the latency of the first inference). To avoid an unnecessary compilation, you can disable the first compilation by setting <code>compile=False</code>. The model can be compiled before the first inference with <code>model.compile()</code>.",ft,Q,yt,N,Sl='To run inference on Intel integrated or discrete GPU, use <code>.to(&quot;gpu&quot;)</code>. On GPU, models run in FP16 precision by default. (See <a href="https://docs.openvino.ai/2024/get-started/configurations/configurations-intel-gpu.html" rel="nofollow">OpenVINO documentation</a> about installing drivers for GPU inference).',wt,H,Tt,z,Jt,E,Ql="It is possible to pass an <code>ov_config</code> parameter to <code>from_pretrained()</code> with custom OpenVINO configuration values. This can be used for example to enable full precision inference on devices where FP16 or BF16 inference precision is used by default.",Zt,Y,Ut,q,Nl='Optimum Intel leverages OpenVINO’s model caching to speed up model compiling on GPU. By default a <code>model_cache</code> directory is created in the model’s directory in the <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/manage-cache" rel="nofollow">Hugging Face Hub cache</a>. To override this, use the ov_config parameter and set <code>CACHE_DIR</code> to a different value. To disable model caching on GPU, set <code>CACHE_DIR</code> to an empty string.',Wt,L,gt,O,jt,D,Hl=`Sequence-to-sequence (Seq2Seq) models, that generate a new sequence from an input, can also be used when running inference with OpenVINO. When Seq2Seq models are exported to the OpenVINO IR, they are decomposed into two parts : the encoder and the “decoder” (which actually consists of the decoder with the language modeling head), that are later combined during inference.
To speed up sequential decoding, a cache with pre-computed key/values hidden-states will be used by default. An additional model component will be exported: the “decoder” with pre-computed key/values as one of its inputs.  This specific export comes from the fact that during the first pass, the decoder has no pre-computed key/values hidden-states, while during the rest of the generation past key/values will be used to speed up sequential decoding. To disable this cache, set <code>use_cache=False</code> in the <code>from_pretrained()</code> method.`,Gt,A,zl="Here is an example on how you can run inference for a translation task using a T5 model and then export it to OpenVINO IR:",vt,P,Vt,K,Bt,ee,El="Make sure you have 🤗 Diffusers installed. To install <code>diffusers</code>:",It,te,$t,le,Xt,se,Yl=`Stable Diffusion models can also be used when running inference with OpenVINO. When Stable Diffusion models
are exported to the OpenVINO format, they are decomposed into different components that are later combined during inference:`,xt,ne,ql="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",kt,ae,Ll="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionImg2ImgPipeline</code></td></tr> <tr><td><code>inpaint</code></td> <td><code>OVStableDiffusionInpaintPipeline</code></td></tr></tbody>",Ct,ie,_t,oe,Ol="Here is an example of how you can load an OpenVINO Stable Diffusion model and run inference using OpenVINO Runtime:",Rt,pe,Ft,me,Dl="To load your PyTorch model and convert it to OpenVINO on the fly, you can set <code>export=True</code>.",St,de,Qt,re,Al="To further speed up inference, the model can be statically reshaped :",Nt,ce,Ht,ue,Pl="In case you want to change any parameters such as the outputs height or width, you’ll need to statically reshape your model once again.",zt,T,Kl='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/stable_diffusion_v1_5_sail_boat_rembrandt.png"/>',Et,Me,Yt,he,es="Here is an example of how you can load an OpenVINO Stable Diffusion model with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:",qt,be,ts="First, you can run original pipeline without textual inversion",Lt,fe,Ot,ye,ls='Then, you can load <a href="https://huggingface.co/sd-concepts-library/cat-toy" rel="nofollow">sd-concepts-library/cat-toy</a> textual inversion embedding and run pipeline with same prompt again',Dt,we,At,Te,ss="The left image shows the generation result of original stable diffusion v1.5, the right image shows the generation result of stable diffusion v1.5 with textual inversion.",Pt,Je,ns='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_without_textual_inversion.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_with_textual_inversion.png"/></td></tr></tbody>',Kt,Ze,el,Ue,tl,We,ll,ge,as="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionXLPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionXLImg2ImgPipeline</code></td></tr></tbody>",sl,je,nl,Ge,is='Here is an example of how you can load a SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using OpenVINO Runtime:',al,ve,il,Ve,os='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich_2.png"/></td></tr></tbody>',ol,Be,pl,Ie,ps='Here is an example of how you can load an SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:',ml,$e,ms="First, you can run original pipeline without textual inversion",dl,Xe,rl,xe,ds='Then, you can load <a href="https://civitai.com/models/3036/charturner-character-turnaround-helper-for-15-and-21" rel="nofollow">charturnerv2</a> textual inversion embedding and run pipeline with same prompt again',cl,ke,ul,Ce,rs='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/sdxl_without_textual_inversion.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/sdxl_with_textual_inversion.png"/></td></tr></tbody>',Ml,_e,hl,Re,cs="Here is an example of how you can load a PyTorch SDXL model, convert it to OpenVINO on-the-fly and run inference using OpenVINO Runtime for <em>image-to-image</em>:",bl,Fe,fl,Se,yl,Qe,us='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',wl,Ne,Tl,He,Jl,ze,Ms="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVLatentConsistencyModelPipeline</code></td></tr></tbody>",Zl,Ee,Ul,Ye,hs='Here is an example of how you can load a Latent Consistency Models (LCMs) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using OpenVINO :',Wl,qe,gl,Le,jl,De,Gl;return Z=new b({props:{title:"Inference",local:"inference",headingTag:"h1"}}),W=new b({props:{title:"Transformers models",local:"transformers-models",headingTag:"h2"}}),j=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUyQiUyMGZyb20lMjBvcHRpbXVtLmludGVsJTIwaW1wb3J0JTIwT1ZNb2RlbEZvckNhdXNhbExNJTBBJTIwJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQSUwQSUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwJTIyaGVsZW5haSUyRmdwdDItb3YlMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwaXBlKCUyMkhlJ3MlMjBhJTIwZHJlYWRmdWwlMjBtYWdpY2lhbiUyMGFuZCUyMik=",highlighted:`<span class="hljs-deletion">- from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+ from optimum.intel import OVModelForCausalLM</span>
  from transformers import AutoTokenizer, pipeline

  model_id = &quot;helenai/gpt2-ov&quot;
<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = OVModelForCausalLM.from_pretrained(model_id)</span>
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  pipe = pipeline(&quot;text-generation&quot;, model=model, tokenizer=tokenizer)
  results = pipe(&quot;He&#x27;s a dreadful magician and&quot;)`,wrap:!1}}),B=new b({props:{title:"Weight-only quantization",local:"weight-only-quantization",headingTag:"h3"}}),w=new gs({props:{warning:!0,$$slots:{default:[Gs]},$$scope:{ctx:Ae}}}),x=new b({props:{title:"Static shape",local:"static-shape",headingTag:"h3"}}),C=new h({props:{code:"JTIzJTIwRml4JTIwdGhlJTIwYmF0Y2glMjBzaXplJTIwdG8lMjAxJTIwYW5kJTIwdGhlJTIwc2VxdWVuY2UlMjBsZW5ndGglMjB0byUyMDklMEFtb2RlbC5yZXNoYXBlKDElMkMlMjA5KSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBbW9kZWwuY29tcGlsZSgp",highlighted:`<span class="hljs-comment"># Fix the batch size to 1 and the sequence length to 9</span>
model.reshape(<span class="hljs-number">1</span>, <span class="hljs-number">9</span>)
<span class="hljs-comment"># Compile the model before the first inference</span>
model.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),R=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBldmFsdWF0ZSUyMGltcG9ydCUyMGV2YWx1YXRvciUwQWZyb20lMjBvcHRpbXVtLmludGVsJTIwaW1wb3J0JTIwT1ZNb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtY2FzZWQtZGlzdGlsbGVkLXNxdWFkJTIyJTBBbW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEFtb2RlbC5yZXNoYXBlKDElMkMlMjAzODQpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNxdWFkJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKS5zZWxlY3QocmFuZ2UoNTApKSUwQXRhc2tfZXZhbHVhdG9yJTIwJTNEJTIwZXZhbHVhdG9yKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiklMEFxYV9waXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuJTNEMzg0JTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSklMEFtZXRyaWMlMjAlM0QlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKG1vZGVsX29yX3BpcGVsaW5lJTNEcWFfcGlwZSUyQyUyMGRhdGElM0RldmFsX2RhdGFzZXQlMkMlMjBtZXRyaWMlM0QlMjJzcXVhZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForQuestionAnswering

model_id = <span class="hljs-string">&quot;distilbert-base-cased-distilled-squad&quot;</span>
model = OVModelForQuestionAnswering.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
model.reshape(<span class="hljs-number">1</span>, <span class="hljs-number">384</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)
eval_dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>))
task_evaluator = evaluator(<span class="hljs-string">&quot;question-answering&quot;</span>)
qa_pipe = pipeline(
    <span class="hljs-string">&quot;question-answering&quot;</span>,
    model=model,
    tokenizer=tokenizer,
    max_seq_len=<span class="hljs-number">384</span>,
    padding=<span class="hljs-string">&quot;max_length&quot;</span>,
    truncation=<span class="hljs-literal">True</span>,
)
metric = task_evaluator.compute(model_or_pipeline=qa_pipe, data=eval_dataset, metric=<span class="hljs-string">&quot;squad&quot;</span>)`,wrap:!1}}),F=new b({props:{title:"Compilation",local:"compilation",headingTag:"h3"}}),Q=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjBkaXNhYmxlJTIwdGhlJTIwbW9kZWwlMjBjb21waWxhdGlvbiUwQW1vZGVsJTIwJTNEJTIwT1ZNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEElMjMlMjBSZXNoYXBlJTIwdG8lMjBhJTIwc3RhdGljJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvZiUyMDEyOCUwQW1vZGVsLnJlc2hhcGUoMSUyQzEyOCklMEElMjMlMjBDb21waWxlJTIwdGhlJTIwbW9kZWwlMjBiZWZvcmUlMjB0aGUlMjBmaXJzdCUyMGluZmVyZW5jZSUwQW1vZGVsLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForSequenceClassification

model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-comment"># Load the model and disable the model compilation</span>
model = OVModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
<span class="hljs-comment"># Reshape to a static sequence length of 128</span>
model.reshape(<span class="hljs-number">1</span>,<span class="hljs-number">128</span>)
<span class="hljs-comment"># Compile the model before the first inference</span>
model.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),H=new h({props:{code:"JTIzJTIwU3RhdGljJTIwc2hhcGVzJTIwc3BlZWQlMjB1cCUyMGluZmVyZW5jZSUwQW1vZGVsLnJlc2hhcGUoMSUyQyUyMDkpJTBBbW9kZWwudG8oJTIyZ3B1JTIyKSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBbW9kZWwuY29tcGlsZSgp",highlighted:`<span class="hljs-comment"># Static shapes speed up inference</span>
model.reshape(<span class="hljs-number">1</span>, <span class="hljs-number">9</span>)
model.to(<span class="hljs-string">&quot;gpu&quot;</span>)
<span class="hljs-comment"># Compile the model before the first inference</span>
model.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),z=new b({props:{title:"Configuration",local:"configuration",headingTag:"h3"}}),Y=new h({props:{code:"bW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBvdl9jb25maWclM0QlN0IlMjJJTkZFUkVOQ0VfUFJFQ0lTSU9OX0hJTlQlMjIlM0ElMjJmMzIlMjIlN0Qp",highlighted:'model = OVModelForSequenceClassification.from_pretrained(model_id, ov_config={<span class="hljs-string">&quot;INFERENCE_PRECISION_HINT&quot;</span>:<span class="hljs-string">&quot;f32&quot;</span>})',wrap:!1}}),L=new h({props:{code:"bW9kZWwlMjAlM0QlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2UlM0QlMjJHUFUlMjIlMkMlMjBvdl9jb25maWclM0QlN0IlMjJQRVJGT1JNQU5DRV9ISU5UJTIyJTNBJTIwJTIyTEFURU5DWSUyMiUyQyUyMCUyMkNBQ0hFX0RJUiUyMiUzQSUyMiUyMiU3RCk=",highlighted:'model = OVModelForSequenceClassification.from_pretrained(model_id, device=<span class="hljs-string">&quot;GPU&quot;</span>, ov_config={<span class="hljs-string">&quot;PERFORMANCE_HINT&quot;</span>: <span class="hljs-string">&quot;LATENCY&quot;</span>, <span class="hljs-string">&quot;CACHE_DIR&quot;</span>:<span class="hljs-string">&quot;&quot;</span>})',wrap:!1}}),O=new b({props:{title:"Sequence-to-sequence models",local:"sequence-to-sequence-models",headingTag:"h3"}}),P=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLmludGVsJTIwaW1wb3J0JTIwT1ZNb2RlbEZvclNlcTJTZXFMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEFtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEF0cmFuc2xhdGlvbl9waXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIydHJhbnNsYXRpb25fZW5fdG9fZnIlMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXRleHQlMjAlM0QlMjAlMjJIZSUyMG5ldmVyJTIwd2VudCUyMG91dCUyMHdpdGhvdXQlMjBhJTIwYm9vayUyMHVuZGVyJTIwaGlzJTIwYXJtJTJDJTIwYW5kJTIwaGUlMjBvZnRlbiUyMGNhbWUlMjBiYWNrJTIwd2l0aCUyMHR3by4lMjIlMEFyZXN1bHQlMjAlM0QlMjB0cmFuc2xhdGlvbl9waXBlKHRleHQpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMGV4cG9ydGVkJTIwbW9kZWwlMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMm9wZW52aW5vX3Q1JTIyJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBJTBBJTVCJTdCJ3RyYW5zbGF0aW9uX3RleHQnJTNBJTIwJTIySWwlMjBuJ2VzdCUyMGphbWFpcyUyMHNvcnRpJTIwc2FucyUyMHVuJTIwbGl2cmUlMjBzb3VzJTIwc29uJTIwYnJhcyUyQyUyMGV0JTIwaWwlMjBlc3QlMjBzb3V2ZW50JTIwcmV2ZW51JTIwYXZlYyUyMGRldXguJTIyJTdEJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVModelForSeq2SeqLM

model_id = <span class="hljs-string">&quot;t5-small&quot;</span>
model = OVModelForSeq2SeqLM.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)
translation_pipe = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer)
text = <span class="hljs-string">&quot;He never went out without a book under his arm, and he often came back with two.&quot;</span>
result = translation_pipe(text)

<span class="hljs-comment"># Save the exported model</span>
save_directory = <span class="hljs-string">&quot;openvino_t5&quot;</span>
model.save_pretrained(save_directory)
tokenizer.save_pretrained(save_directory)

[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Il n&#x27;est jamais sorti sans un livre sous son bras, et il est souvent revenu avec deux.&quot;</span>}]`,wrap:!1}}),K=new b({props:{title:"Diffusers models",local:"diffusers-models",headingTag:"h2"}}),te=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0lNUJkaWZmdXNlcnMlNUQ=",highlighted:"pip install optimum[diffusers]",wrap:!1}}),le=new b({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h3"}}),ie=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h4"}}),pe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwaXBlbGluZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwUmVtYnJhbmR0JTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
images = pipeline(prompt).images`,wrap:!1}}),de=new h({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwZXhwb3J0ZWQlMjBtb2RlbCUwQXBpcGVsaW5lLnNhdmVfcHJldHJhaW5lZCglMjJvcGVudmluby1zZC12MS01JTIyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Don&#x27;t forget to save the exported model</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-v1-5&quot;</span>)`,wrap:!1}}),ce=new h({props:{code:"JTIzJTIwRGVmaW5lJTIwdGhlJTIwc2hhcGVzJTIwcmVsYXRlZCUyMHRvJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwZGVzaXJlZCUyMG91dHB1dHMlMEFiYXRjaF9zaXplJTIwJTNEJTIwMSUwQW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMCUzRCUyMDElMEFoZWlnaHQlMjAlM0QlMjA1MTIlMEF3aWR0aCUyMCUzRCUyMDUxMiUwQSUwQSUyMyUyMFN0YXRpY2FsbHklMjByZXNoYXBlJTIwdGhlJTIwbW9kZWwlMEFwaXBlbGluZS5yZXNoYXBlKGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwaGVpZ2h0JTNEaGVpZ2h0JTJDJTIwd2lkdGglM0R3aWR0aCUyQyUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCklMEElMjMlMjBDb21waWxlJTIwdGhlJTIwbW9kZWwlMjBiZWZvcmUlMjB0aGUlMjBmaXJzdCUyMGluZmVyZW5jZSUwQXBpcGVsaW5lLmNvbXBpbGUoKSUwQSUwQSUyMyUyMFJ1biUyMGluZmVyZW5jZSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGhlaWdodCUzRGhlaWdodCUyQyUyMHdpZHRoJTNEd2lkdGglMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzX3Blcl9wcm9tcHQpLmltYWdlcw==",highlighted:`<span class="hljs-comment"># Define the shapes related to the inputs and desired outputs</span>
batch_size = <span class="hljs-number">1</span>
num_images_per_prompt = <span class="hljs-number">1</span>
height = <span class="hljs-number">512</span>
width = <span class="hljs-number">512</span>

<span class="hljs-comment"># Statically reshape the model</span>
pipeline.reshape(batch_size=batch_size, height=height, width=width, num_images_per_prompt=num_images_per_prompt)
<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Run inference</span>
images = pipeline(prompt, height=height, width=width, num_images_per_prompt=num_images_per_prompt).images`,wrap:!1}}),Me=new b({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h4"}}),fe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMGJhY2stcGFjayUyMiUwQSUyMyUyMFNldCUyMGElMjByYW5kb20lMjBzZWVkJTIwZm9yJTIwYmV0dGVyJTIwY29tcGFyaXNvbiUwQW5wLnJhbmRvbS5zZWVkKDQyKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFwaXBlbGluZS5jb21waWxlKCklMEFpbWFnZTElMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZTEuc2F2ZSglMjJzdGFibGVfZGlmZnVzaW9uX3YxXzVfd2l0aG91dF90ZXh0dWFsX2ludmVyc2lvbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; back-pack&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">42</span>)

pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
pipeline.<span class="hljs-built_in">compile</span>()
image1 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),we=new h({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmNsZWFyX3JlcXVlc3RzKCklMEElMEElMjMlMjBMb2FkJTIwdGV4dHVhbCUyMGludmVyc2lvbiUyMGludG8lMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIlMkMlMjAlMjIlM0NjYXQtdG95JTNFJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBaW1hZ2UyJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc3RhYmxlX2RpZmZ1c2lvbl92MV81X3dpdGhfdGV4dHVhbF9pbnZlcnNpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
pipeline.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>, <span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()
image2 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),Ze=new b({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h4"}}),Ue=new h({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjc1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>
image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),We=new b({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h3"}}),je=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h4"}}),ve=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWJhc2UlMjAlM0QlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnRyYWluJTIwc3RhdGlvbiUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJ0cmFpbl9zdGF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = OVStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;train station by Caspar David Friedrich&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;train_station.png&quot;</span>)`,wrap:!1}}),Be=new b({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h4"}}),Xe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMGJlYXV0aWZ1bCUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjByZWQlMjBqYWNrZXQlMjBhbmQlMjBibGFjayUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUyMyUyMFNldCUyMGElMjByYW5kb20lMjBzZWVkJTIwZm9yJTIwYmV0dGVyJTIwY29tcGFyaXNvbiUwQW5wLnJhbmRvbS5zZWVkKDExMiklMEElMEFiYXNlJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzREZhbHNlJTJDJTIwY29tcGlsZSUzREZhbHNlKSUwQWJhc2UuY29tcGlsZSgpJTBBaW1hZ2UxJTIwJTNEJTIwYmFzZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZTEuc2F2ZSglMjJzZHhsX3dpdGhvdXRfdGV4dHVhbF9pbnZlcnNpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a beautiful woman wearing a red jacket and black shirt, best quality, intricate details.&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">112</span>)

base = OVStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
base.<span class="hljs-built_in">compile</span>()
image1 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;sdxl_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),ke=new h({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQWJhc2UuY2xlYXJfcmVxdWVzdHMoKSUwQSUwQSUyMyUyMExvYWQlMjB0ZXh0dWFsJTIwaW52ZXJzaW9uJTIwaW50byUyMHN0YWJsZSUyMGRpZmZ1c2lvbiUyMHBpcGVsaW5lJTBBYmFzZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIlMkMlMjAlMjJjaGFydHVybmVydjIlMjIpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYmVmb3JlJTIwdGhlJTIwZmlyc3QlMjBpbmZlcmVuY2UlMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMiUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc2R4bF93aXRoX3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMiklMEElMEFUaGUlMjBsZWZ0JTIwaW1hZ2UlMjBzaG93cyUyMHRoZSUyMGdlbmVyYXRpb24lMjByZXN1bHQlMjBvZiUyMHRoZSUyMG9yaWdpbmFsJTIwU0RYTCUyMGJhc2UlMjAxLjAlMkMlMjB0aGUlMjByaWdodCUyMGltYWdlJTIwc2hvd3MlMjB0aGUlMjBnZW5lcmF0aW9uJTIwcmVzdWx0JTIwb2YlMjBTRFhMJTIwYmFzZSUyMDEuMCUyMHdpdGglMjB0ZXh0dWFsJTIwaW52ZXJzaW9uLg==",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
base.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
base.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, <span class="hljs-string">&quot;charturnerv2&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
base.<span class="hljs-built_in">compile</span>()
image2 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;sdxl_with_textual_inversion.png&quot;</span>)

The left image shows the generation result of the original SDXL base <span class="hljs-number">1.0</span>, the right image shows the generation result of SDXL base <span class="hljs-number">1.0</span> <span class="hljs-keyword">with</span> textual inversion.`,wrap:!1}}),_e=new b({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h4"}}),Fe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRm9wdGltdW0lMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaW50ZWwlMkZvcGVudmlubyUyRnNkX3hsJTJGY2FzdGxlX2ZyaWVkcmljaC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJtZWRpZXZhbCUyMGNhc3RsZSUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMjMlMjBEb24ndCUyMGZvcmdldCUyMHRvJTIwc2F2ZSUyMHlvdXIlMjBPcGVuVklOTyUyMG1vZGVsJTIwc28lMjB0aGF0JTIweW91JTIwY2FuJTIwbG9hZCUyMGl0JTIwd2l0aG91dCUyMGV4cG9ydGluZyUyMGl0JTIwd2l0aCUyMCU2MGV4cG9ydCUzRFRydWUlNjAlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyb3BlbnZpbm8tc2QteGwtcmVmaW5lci0xLjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Don&#x27;t forget to save your OpenVINO model so that you can load it without exporting it with \`export=True\`</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-xl-refiner-1.0&quot;</span>)`,wrap:!1}}),Se=new b({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h4"}}),Ne=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFyZWZpbmVyJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),He=new b({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h3"}}),Ee=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h4"}}),qe=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyU2ltaWFuTHVvJTJGTENNX0RyZWFtc2hhcGVyX3Y3JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwTGVvbmFyZG8lMjBkYSUyMFZpbmNpJTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = OVLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),Le=new js({props:{source:"https://github.com/huggingface/optimum-intel/blob/main/docs/source/openvino/inference.mdx"}}),{c(){f=i("meta"),J=n(),y=i("p"),Oe=n(),p(Z.$$.fragment),Pe=n(),U=i("p"),U.innerHTML=Vl,Ke=n(),p(W.$$.fragment),et=n(),g=i("p"),g.innerHTML=Bl,tt=n(),p(j.$$.fragment),lt=n(),G=i("p"),G.innerHTML=Il,st=n(),v=i("p"),v.textContent=$l,nt=n(),V=i("table"),V.innerHTML=Xl,at=n(),p(B.$$.fragment),it=n(),I=i("p"),I.textContent=xl,ot=n(),$=i("p"),$.innerHTML=kl,pt=n(),p(w.$$.fragment),mt=n(),X=i("p"),X.innerHTML=Cl,dt=n(),p(x.$$.fragment),rt=n(),k=i("p"),k.innerHTML=_l,ct=n(),p(C.$$.fragment),ut=n(),_=i("p"),_.innerHTML=Rl,Mt=n(),p(R.$$.fragment),ht=n(),p(F.$$.fragment),bt=n(),S=i("p"),S.innerHTML=Fl,ft=n(),p(Q.$$.fragment),yt=n(),N=i("p"),N.innerHTML=Sl,wt=n(),p(H.$$.fragment),Tt=n(),p(z.$$.fragment),Jt=n(),E=i("p"),E.innerHTML=Ql,Zt=n(),p(Y.$$.fragment),Ut=n(),q=i("p"),q.innerHTML=Nl,Wt=n(),p(L.$$.fragment),gt=n(),p(O.$$.fragment),jt=n(),D=i("p"),D.innerHTML=Hl,Gt=n(),A=i("p"),A.textContent=zl,vt=n(),p(P.$$.fragment),Vt=n(),p(K.$$.fragment),Bt=n(),ee=i("p"),ee.innerHTML=El,It=n(),p(te.$$.fragment),$t=n(),p(le.$$.fragment),Xt=n(),se=i("p"),se.textContent=Yl,xt=n(),ne=i("ul"),ne.innerHTML=ql,kt=n(),ae=i("table"),ae.innerHTML=Ll,Ct=n(),p(ie.$$.fragment),_t=n(),oe=i("p"),oe.textContent=Ol,Rt=n(),p(pe.$$.fragment),Ft=n(),me=i("p"),me.innerHTML=Dl,St=n(),p(de.$$.fragment),Qt=n(),re=i("p"),re.textContent=Al,Nt=n(),p(ce.$$.fragment),Ht=n(),ue=i("p"),ue.textContent=Pl,zt=n(),T=i("div"),T.innerHTML=Kl,Et=n(),p(Me.$$.fragment),Yt=n(),he=i("p"),he.textContent=es,qt=n(),be=i("p"),be.textContent=ts,Lt=n(),p(fe.$$.fragment),Ot=n(),ye=i("p"),ye.innerHTML=ls,Dt=n(),p(we.$$.fragment),At=n(),Te=i("p"),Te.textContent=ss,Pt=n(),Je=i("table"),Je.innerHTML=ns,Kt=n(),p(Ze.$$.fragment),el=n(),p(Ue.$$.fragment),tl=n(),p(We.$$.fragment),ll=n(),ge=i("table"),ge.innerHTML=as,sl=n(),p(je.$$.fragment),nl=n(),Ge=i("p"),Ge.innerHTML=is,al=n(),p(ve.$$.fragment),il=n(),Ve=i("table"),Ve.innerHTML=os,ol=n(),p(Be.$$.fragment),pl=n(),Ie=i("p"),Ie.innerHTML=ps,ml=n(),$e=i("p"),$e.textContent=ms,dl=n(),p(Xe.$$.fragment),rl=n(),xe=i("p"),xe.innerHTML=ds,cl=n(),p(ke.$$.fragment),ul=n(),Ce=i("table"),Ce.innerHTML=rs,Ml=n(),p(_e.$$.fragment),hl=n(),Re=i("p"),Re.innerHTML=cs,bl=n(),p(Fe.$$.fragment),fl=n(),p(Se.$$.fragment),yl=n(),Qe=i("p"),Qe.innerHTML=us,wl=n(),p(Ne.$$.fragment),Tl=n(),p(He.$$.fragment),Jl=n(),ze=i("table"),ze.innerHTML=Ms,Zl=n(),p(Ee.$$.fragment),Ul=n(),Ye=i("p"),Ye.innerHTML=hs,Wl=n(),p(qe.$$.fragment),gl=n(),p(Le.$$.fragment),jl=n(),De=i("p"),this.h()},l(e){const t=Us("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),y=o(e,"P",{}),fs(y).forEach(l),Oe=a(e),m(Z.$$.fragment,e),Pe=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-s56qxg"&&(U.innerHTML=Vl),Ke=a(e),m(W.$$.fragment,e),et=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-465xmt"&&(g.innerHTML=Bl),tt=a(e),m(j.$$.fragment,e),lt=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1lj5vxe"&&(G.innerHTML=Il),st=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-sgii55"&&(v.textContent=$l),nt=a(e),V=o(e,"TABLE",{"data-svelte-h":!0}),M(V)!=="svelte-1ddx7ih"&&(V.innerHTML=Xl),at=a(e),m(B.$$.fragment,e),it=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-o2k584"&&(I.textContent=xl),ot=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1r1zzgo"&&($.innerHTML=kl),pt=a(e),m(w.$$.fragment,e),mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-dusq8s"&&(X.innerHTML=Cl),dt=a(e),m(x.$$.fragment,e),rt=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1vr3ldi"&&(k.innerHTML=_l),ct=a(e),m(C.$$.fragment,e),ut=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-z7xu55"&&(_.innerHTML=Rl),Mt=a(e),m(R.$$.fragment,e),ht=a(e),m(F.$$.fragment,e),bt=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-geu9q7"&&(S.innerHTML=Fl),ft=a(e),m(Q.$$.fragment,e),yt=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-8mr2tm"&&(N.innerHTML=Sl),wt=a(e),m(H.$$.fragment,e),Tt=a(e),m(z.$$.fragment,e),Jt=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1y8mt3r"&&(E.innerHTML=Ql),Zt=a(e),m(Y.$$.fragment,e),Ut=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-o5dvd1"&&(q.innerHTML=Nl),Wt=a(e),m(L.$$.fragment,e),gt=a(e),m(O.$$.fragment,e),jt=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-mzdej7"&&(D.innerHTML=Hl),Gt=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-12z8wpx"&&(A.textContent=zl),vt=a(e),m(P.$$.fragment,e),Vt=a(e),m(K.$$.fragment,e),Bt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1pfcfts"&&(ee.innerHTML=El),It=a(e),m(te.$$.fragment,e),$t=a(e),m(le.$$.fragment,e),Xt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1isd6gx"&&(se.textContent=Yl),xt=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-bu3ryq"&&(ne.innerHTML=ql),kt=a(e),ae=o(e,"TABLE",{"data-svelte-h":!0}),M(ae)!=="svelte-9sg8v5"&&(ae.innerHTML=Ll),Ct=a(e),m(ie.$$.fragment,e),_t=a(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-t90xds"&&(oe.textContent=Ol),Rt=a(e),m(pe.$$.fragment,e),Ft=a(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1870w60"&&(me.innerHTML=Dl),St=a(e),m(de.$$.fragment,e),Qt=a(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-f1ib2z"&&(re.textContent=Al),Nt=a(e),m(ce.$$.fragment,e),Ht=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-k76x21"&&(ue.textContent=Pl),zt=a(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-1bbei4i"&&(T.innerHTML=Kl),Et=a(e),m(Me.$$.fragment,e),Yt=a(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-gj1zll"&&(he.textContent=es),qt=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1ephhdh"&&(be.textContent=ts),Lt=a(e),m(fe.$$.fragment,e),Ot=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-j9a9m8"&&(ye.innerHTML=ls),Dt=a(e),m(we.$$.fragment,e),At=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1ohkhi8"&&(Te.textContent=ss),Pt=a(e),Je=o(e,"TABLE",{"data-svelte-h":!0}),M(Je)!=="svelte-1sy4xw8"&&(Je.innerHTML=ns),Kt=a(e),m(Ze.$$.fragment,e),el=a(e),m(Ue.$$.fragment,e),tl=a(e),m(We.$$.fragment,e),ll=a(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),M(ge)!=="svelte-o49bnr"&&(ge.innerHTML=as),sl=a(e),m(je.$$.fragment,e),nl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1kedcjk"&&(Ge.innerHTML=is),al=a(e),m(ve.$$.fragment,e),il=a(e),Ve=o(e,"TABLE",{"data-svelte-h":!0}),M(Ve)!=="svelte-35z5uj"&&(Ve.innerHTML=os),ol=a(e),m(Be.$$.fragment,e),pl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1rl3w3v"&&(Ie.innerHTML=ps),ml=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1ephhdh"&&($e.textContent=ms),dl=a(e),m(Xe.$$.fragment,e),rl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-197o8c3"&&(xe.innerHTML=ds),cl=a(e),m(ke.$$.fragment,e),ul=a(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),M(Ce)!=="svelte-lejey6"&&(Ce.innerHTML=rs),Ml=a(e),m(_e.$$.fragment,e),hl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1g03pef"&&(Re.innerHTML=cs),bl=a(e),m(Fe.$$.fragment,e),fl=a(e),m(Se.$$.fragment,e),yl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1lzmdpv"&&(Qe.innerHTML=us),wl=a(e),m(Ne.$$.fragment,e),Tl=a(e),m(He.$$.fragment,e),Jl=a(e),ze=o(e,"TABLE",{"data-svelte-h":!0}),M(ze)!=="svelte-veyn1t"&&(ze.innerHTML=Ms),Zl=a(e),m(Ee.$$.fragment,e),Ul=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-v0a5r2"&&(Ye.innerHTML=hs),Wl=a(e),m(qe.$$.fragment,e),gl=a(e),m(Le.$$.fragment,e),jl=a(e),De=o(e,"P",{}),fs(De).forEach(l),this.h()},h(){vl(f,"name","hf:doc:metadata"),vl(f,"content",Vs),vl(T,"class","flex justify-center")},m(e,t){Ws(document.head,f),s(e,J,t),s(e,y,t),s(e,Oe,t),d(Z,e,t),s(e,Pe,t),s(e,U,t),s(e,Ke,t),d(W,e,t),s(e,et,t),s(e,g,t),s(e,tt,t),d(j,e,t),s(e,lt,t),s(e,G,t),s(e,st,t),s(e,v,t),s(e,nt,t),s(e,V,t),s(e,at,t),d(B,e,t),s(e,it,t),s(e,I,t),s(e,ot,t),s(e,$,t),s(e,pt,t),d(w,e,t),s(e,mt,t),s(e,X,t),s(e,dt,t),d(x,e,t),s(e,rt,t),s(e,k,t),s(e,ct,t),d(C,e,t),s(e,ut,t),s(e,_,t),s(e,Mt,t),d(R,e,t),s(e,ht,t),d(F,e,t),s(e,bt,t),s(e,S,t),s(e,ft,t),d(Q,e,t),s(e,yt,t),s(e,N,t),s(e,wt,t),d(H,e,t),s(e,Tt,t),d(z,e,t),s(e,Jt,t),s(e,E,t),s(e,Zt,t),d(Y,e,t),s(e,Ut,t),s(e,q,t),s(e,Wt,t),d(L,e,t),s(e,gt,t),d(O,e,t),s(e,jt,t),s(e,D,t),s(e,Gt,t),s(e,A,t),s(e,vt,t),d(P,e,t),s(e,Vt,t),d(K,e,t),s(e,Bt,t),s(e,ee,t),s(e,It,t),d(te,e,t),s(e,$t,t),d(le,e,t),s(e,Xt,t),s(e,se,t),s(e,xt,t),s(e,ne,t),s(e,kt,t),s(e,ae,t),s(e,Ct,t),d(ie,e,t),s(e,_t,t),s(e,oe,t),s(e,Rt,t),d(pe,e,t),s(e,Ft,t),s(e,me,t),s(e,St,t),d(de,e,t),s(e,Qt,t),s(e,re,t),s(e,Nt,t),d(ce,e,t),s(e,Ht,t),s(e,ue,t),s(e,zt,t),s(e,T,t),s(e,Et,t),d(Me,e,t),s(e,Yt,t),s(e,he,t),s(e,qt,t),s(e,be,t),s(e,Lt,t),d(fe,e,t),s(e,Ot,t),s(e,ye,t),s(e,Dt,t),d(we,e,t),s(e,At,t),s(e,Te,t),s(e,Pt,t),s(e,Je,t),s(e,Kt,t),d(Ze,e,t),s(e,el,t),d(Ue,e,t),s(e,tl,t),d(We,e,t),s(e,ll,t),s(e,ge,t),s(e,sl,t),d(je,e,t),s(e,nl,t),s(e,Ge,t),s(e,al,t),d(ve,e,t),s(e,il,t),s(e,Ve,t),s(e,ol,t),d(Be,e,t),s(e,pl,t),s(e,Ie,t),s(e,ml,t),s(e,$e,t),s(e,dl,t),d(Xe,e,t),s(e,rl,t),s(e,xe,t),s(e,cl,t),d(ke,e,t),s(e,ul,t),s(e,Ce,t),s(e,Ml,t),d(_e,e,t),s(e,hl,t),s(e,Re,t),s(e,bl,t),d(Fe,e,t),s(e,fl,t),d(Se,e,t),s(e,yl,t),s(e,Qe,t),s(e,wl,t),d(Ne,e,t),s(e,Tl,t),d(He,e,t),s(e,Jl,t),s(e,ze,t),s(e,Zl,t),d(Ee,e,t),s(e,Ul,t),s(e,Ye,t),s(e,Wl,t),d(qe,e,t),s(e,gl,t),d(Le,e,t),s(e,jl,t),s(e,De,t),Gl=!0},p(e,[t]){const bs={};t&2&&(bs.$$scope={dirty:t,ctx:e}),w.$set(bs)},i(e){Gl||(r(Z.$$.fragment,e),r(W.$$.fragment,e),r(j.$$.fragment,e),r(B.$$.fragment,e),r(w.$$.fragment,e),r(x.$$.fragment,e),r(C.$$.fragment,e),r(R.$$.fragment,e),r(F.$$.fragment,e),r(Q.$$.fragment,e),r(H.$$.fragment,e),r(z.$$.fragment,e),r(Y.$$.fragment,e),r(L.$$.fragment,e),r(O.$$.fragment,e),r(P.$$.fragment,e),r(K.$$.fragment,e),r(te.$$.fragment,e),r(le.$$.fragment,e),r(ie.$$.fragment,e),r(pe.$$.fragment,e),r(de.$$.fragment,e),r(ce.$$.fragment,e),r(Me.$$.fragment,e),r(fe.$$.fragment,e),r(we.$$.fragment,e),r(Ze.$$.fragment,e),r(Ue.$$.fragment,e),r(We.$$.fragment,e),r(je.$$.fragment,e),r(ve.$$.fragment,e),r(Be.$$.fragment,e),r(Xe.$$.fragment,e),r(ke.$$.fragment,e),r(_e.$$.fragment,e),r(Fe.$$.fragment,e),r(Se.$$.fragment,e),r(Ne.$$.fragment,e),r(He.$$.fragment,e),r(Ee.$$.fragment,e),r(qe.$$.fragment,e),r(Le.$$.fragment,e),Gl=!0)},o(e){c(Z.$$.fragment,e),c(W.$$.fragment,e),c(j.$$.fragment,e),c(B.$$.fragment,e),c(w.$$.fragment,e),c(x.$$.fragment,e),c(C.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(O.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(fe.$$.fragment,e),c(we.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(We.$$.fragment,e),c(je.$$.fragment,e),c(ve.$$.fragment,e),c(Be.$$.fragment,e),c(Xe.$$.fragment,e),c(ke.$$.fragment,e),c(_e.$$.fragment,e),c(Fe.$$.fragment,e),c(Se.$$.fragment,e),c(Ne.$$.fragment,e),c(He.$$.fragment,e),c(Ee.$$.fragment,e),c(qe.$$.fragment,e),c(Le.$$.fragment,e),Gl=!1},d(e){e&&(l(J),l(y),l(Oe),l(Pe),l(U),l(Ke),l(et),l(g),l(tt),l(lt),l(G),l(st),l(v),l(nt),l(V),l(at),l(it),l(I),l(ot),l($),l(pt),l(mt),l(X),l(dt),l(rt),l(k),l(ct),l(ut),l(_),l(Mt),l(ht),l(bt),l(S),l(ft),l(yt),l(N),l(wt),l(Tt),l(Jt),l(E),l(Zt),l(Ut),l(q),l(Wt),l(gt),l(jt),l(D),l(Gt),l(A),l(vt),l(Vt),l(Bt),l(ee),l(It),l($t),l(Xt),l(se),l(xt),l(ne),l(kt),l(ae),l(Ct),l(_t),l(oe),l(Rt),l(Ft),l(me),l(St),l(Qt),l(re),l(Nt),l(Ht),l(ue),l(zt),l(T),l(Et),l(Yt),l(he),l(qt),l(be),l(Lt),l(Ot),l(ye),l(Dt),l(At),l(Te),l(Pt),l(Je),l(Kt),l(el),l(tl),l(ll),l(ge),l(sl),l(nl),l(Ge),l(al),l(il),l(Ve),l(ol),l(pl),l(Ie),l(ml),l($e),l(dl),l(rl),l(xe),l(cl),l(ul),l(Ce),l(Ml),l(hl),l(Re),l(bl),l(fl),l(yl),l(Qe),l(wl),l(Tl),l(Jl),l(ze),l(Zl),l(Ul),l(Ye),l(Wl),l(gl),l(jl),l(De)),l(f),u(Z,e),u(W,e),u(j,e),u(B,e),u(w,e),u(x,e),u(C,e),u(R,e),u(F,e),u(Q,e),u(H,e),u(z,e),u(Y,e),u(L,e),u(O,e),u(P,e),u(K,e),u(te,e),u(le,e),u(ie,e),u(pe,e),u(de,e),u(ce,e),u(Me,e),u(fe,e),u(we,e),u(Ze,e),u(Ue,e),u(We,e),u(je,e),u(ve,e),u(Be,e),u(Xe,e),u(ke,e),u(_e,e),u(Fe,e),u(Se,e),u(Ne,e),u(He,e),u(Ee,e),u(qe,e),u(Le,e)}}}const Vs='{"title":"Inference","local":"inference","sections":[{"title":"Transformers models","local":"transformers-models","sections":[{"title":"Weight-only quantization","local":"weight-only-quantization","sections":[],"depth":3},{"title":"Static shape","local":"static-shape","sections":[],"depth":3},{"title":"Compilation","local":"compilation","sections":[],"depth":3},{"title":"Configuration","local":"configuration","sections":[],"depth":3},{"title":"Sequence-to-sequence models","local":"sequence-to-sequence-models","sections":[],"depth":3}],"depth":2},{"title":"Diffusers models","local":"diffusers-models","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":4},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":4},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":4}],"depth":3},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":4},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":4},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":4},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":4}],"depth":3},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Bs(Ae){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends Js{constructor(f){super(),Zs(this,f,Bs,vs,ys,{})}}export{Cs as component};
