import{s as ga,o as _a,n as ar}from"../chunks/scheduler.25b97de1.js";import{S as va,i as xa,g as n,s as o,r as p,A as ba,h as l,f as t,c as a,j as b,u as f,x as d,k as $,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as uo}from"../chunks/Tip.baa67368.js";import{D as M}from"../chunks/Docstring.e257edda.js";import{C as lr}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ho}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as pe,E as $a}from"../chunks/EditOnGithub.91d95064.js";function ya(L){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_28196/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_28196/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1xx9vef"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ma(L){let c,T="Examples:",v,x,C;return x=new lr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function wa(L){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=n("p"),c.textContent=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ta(L){let c,T=`This class method is simply calling <a href="/docs/transformers/pr_28196/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_28196/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-asx3z6"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ca(L){let c,T="Examples:",v,x,C;return x=new lr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function Pa(L){let c,T="Example:",v,x,C;return x=new lr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function ka(L){let c,T,v,x,C,m,k,go="Processors can mean two different things in the Transformers library:",ir,fe,_o=`<li>the objects that pre-process inputs for multi-modal models such as <a href="../model_doc/wav2vec2">Wav2Vec2</a> (speech and text)
or <a href="../model_doc/clip">CLIP</a> (text and vision)</li> <li>deprecated objects that were used in older versions of the library to preprocess data for GLUE or SQUAD.</li>`,dr,ue,cr,he,vo=`Any multi-modal model will require an object to encode or decode the data that groups several modalities (among text,
vision and audio). This is handled by objects called processors, which group together two or more processing objects
such as tokenizers (for the text modality), image processors (for vision) and feature extractors (for audio).`,mr,ge,xo="Those processors inherit from the following base class that implements the saving and loading functionality:",pr,y,_e,ps,Tt,bo="This is a mixin used to provide saving/loading functionality for all processor classes.",fs,D,ve,us,Ct,$o=`Similar to the <code>apply_chat_template</code> method on tokenizers, this method applies a Jinja template to input
conversations to turn them into a single tokenizable string.`,hs,S,xe,gs,Pt,yo="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",_s,Z,be,vs,kt,Mo="Instantiate a processor associated with a pretrained model.",xs,G,bs,R,$e,$s,It,wo=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,ys,q,ye,Ms,Xt,To="Upload the processor files to the 🤗 Model Hub.",ws,W,Ts,V,Me,Cs,Lt,Co=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Ps,Q,ks,z,we,Is,Jt,Po=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Xs,A,Ls,Y,Te,Js,Ut,ko="Serializes this instance to a Python dictionary.",Us,O,Ce,js,jt,Io="Save this instance to a JSON file.",Zs,K,Pe,qs,Zt,Xo="Serializes this instance to a JSON string.",fr,ke,ur,Ie,Lo=`All processors follow the same architecture which is that of the
<a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.DataProcessor">DataProcessor</a>. The processor returns a list of
<a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a>. These
<a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a> can be converted to
<a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputFeatures">InputFeatures</a> in order to be fed to the model.`,hr,P,Xe,Vs,qt,Jo="Base class for data converters for sequence classification data sets.",zs,ee,Le,Es,Vt,Uo='Gets a collection of <a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Hs,te,Je,Ns,zt,jo="Gets an example from a dict with tensorflow tensors.",Fs,re,Ue,Bs,Et,Zo="Gets the list of labels for this data set.",Ds,se,je,Ss,Ht,qo='Gets a collection of <a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Gs,oe,Ze,Rs,Nt,Vo='Gets a collection of <a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Ws,ae,qe,Qs,Ft,zo=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,gr,J,Ve,As,Bt,Eo="A single training/test example for simple sequence classification.",Ys,ne,ze,Os,Dt,Ho="Serializes this instance to a JSON string.",_r,U,Ee,Ks,St,No="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",eo,le,He,to,Gt,Fo="Serializes this instance to a JSON string.",vr,Ne,xr,Fe,Bo=`<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> is a benchmark that evaluates the
performance of models across a diverse set of existing NLU tasks. It was released together with the paper <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
multi-task benchmark and analysis platform for natural language understanding</a>`,br,Be,Do=`This library hosts a total of 10 processors for the following tasks: MRPC, MNLI, MNLI (mismatched), CoLA, SST2, STSB,
QQP, QNLI, RTE and WNLI.`,$r,De,So="Those processors are:",yr,Se,Go="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",Mr,Ge,Ro=`Additionally, the following method can be used to load values from a data file and convert them to a list of
<a href="/docs/transformers/pr_28196/en/main_classes/processors#transformers.InputExample">InputExample</a>.`,wr,N,Re,ro,Rt,Wo="Loads a data file into a list of <code>InputFeatures</code>",Tr,We,Cr,Qe,Qo=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">The Cross-Lingual NLI Corpus (XNLI)</a> is a benchmark that evaluates the
quality of cross-lingual text representations. XNLI is crowd-sourced dataset based on <a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>: pairs of text are labeled with textual entailment annotations for 15
different languages (including both high-resource language such as English and low-resource languages such as Swahili).`,Pr,Ae,Ao='It was released together with the paper <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a>',kr,Ye,Yo="This library hosts the processor to load the XNLI data:",Ir,Oe,Oo="<li><code>~data.processors.utils.XnliProcessor</code></li>",Xr,Ke,Ko="Please note that since the gold labels are available on the test set, evaluation is performed on the test set.",Lr,et,ea='An example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> script.',Jr,tt,Ur,rt,ta=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> is a benchmark that
evaluates the performance of models on question answering. Two versions are available, v1.1 and v2.0. The first version
(v1.1) was released together with the paper <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a>. The second version (v2.0) was released alongside the paper <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t
Know: Unanswerable Questions for SQuAD</a>.`,jr,st,ra="This library hosts a processor for each of the two versions:",Zr,ot,qr,at,sa="Those processors are:",Vr,nt,oa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",zr,lt,aa="They both inherit from the abstract class <code>~data.processors.utils.SquadProcessor</code>",Er,X,it,so,Wt,na=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,oo,ie,dt,ao,Qt,la="Returns the evaluation example from the data directory.",no,E,ct,lo,At,ia="Creates a list of <code>SquadExample</code> using a TFDS dataset.",io,de,co,ce,mt,mo,Yt,da="Returns the training examples from the data directory.",Hr,pt,ca=`Additionally, the following method can be used to convert SQuAD examples into
<code>~data.processors.utils.SquadFeatures</code> that can be used as model inputs.`,Nr,j,ft,po,Ot,ma=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,fo,me,Fr,ut,pa=`These processors as well as the aforementioned method can be used with files containing the data as well as with the
<em>tensorflow_datasets</em> package. Examples are given below.`,Br,ht,Dr,gt,fa="Here is an example using the processors as well as the conversion method using data files:",Sr,_t,Gr,vt,ua="Using <em>tensorflow_datasets</em> is as easy as using a data file:",Rr,xt,Wr,bt,ha='Another example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> script.',Qr,$t,Ar,nr,Yr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L312"}}),ve=new M({props:{name:"apply_chat_template",anchor:"transformers.ProcessorMixin.apply_chat_template",parameters:[{name:"conversation",val:": List"},{name:"chat_template",val:": Optional = None"},{name:"tokenize",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.apply_chat_template.conversation",description:`<strong>conversation</strong> (<code>List[Dict, str, str]</code>) &#x2014;
The conversation to format.`,name:"conversation"},{anchor:"transformers.ProcessorMixin.apply_chat_template.chat_template",description:`<strong>chat_template</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The Jinja template to use for formatting the conversation. If not provided, the default chat template
is used.`,name:"chat_template"},{anchor:"transformers.ProcessorMixin.apply_chat_template.tokenize",description:`<strong>tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tokenize the output or not.
**kwargs &#x2014;
Additional keyword arguments`,name:"tokenize"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L890"}}),xe=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),be=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_28196/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_28196/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L777"}}),G=new uo({props:{$$slots:{default:[ya]},$$scope:{ctx:L}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L517",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),ye=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/utils/hub.py#L809"}}),W=new ho({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Ma]},$$scope:{ctx:L}}}),Me=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L841"}}),Q=new uo({props:{warning:!0,$$slots:{default:[wa]},$$scope:{ctx:L}}}),we=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_28196/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L428"}}),A=new uo({props:{$$slots:{default:[Ta]},$$scope:{ctx:L}}}),Te=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ce=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L412"}}),Pe=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/processing_utils.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ke=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Xe=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L80"}}),Le=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L83"}}),Ue=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L105"}}),je=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L101"}}),Ze=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L93"}}),qe=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L109"}}),Ve=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L29"}}),ze=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L49"}}),Ee=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L54"}}),He=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/utils.py#L75"}}),Ne=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Re=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),tt=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),ot=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),it=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/squad.py#L541"}}),dt=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/squad.py#L629"}}),ct=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new ho({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[Ca]},$$scope:{ctx:L}}}),mt=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/squad.py#L607"}}),ft=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/vr_28196/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new ho({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[Pa]},$$scope:{ctx:L}}}),ht=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),_t=new lr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),xt=new lr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),$t=new $a({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/processors.md"}}),{c(){c=n("meta"),T=o(),v=n("p"),x=o(),p(C.$$.fragment),m=o(),k=n("p"),k.textContent=go,ir=o(),fe=n("ul"),fe.innerHTML=_o,dr=o(),p(ue.$$.fragment),cr=o(),he=n("p"),he.textContent=vo,mr=o(),ge=n("p"),ge.textContent=xo,pr=o(),y=n("div"),p(_e.$$.fragment),ps=o(),Tt=n("p"),Tt.textContent=bo,fs=o(),D=n("div"),p(ve.$$.fragment),us=o(),Ct=n("p"),Ct.innerHTML=$o,hs=o(),S=n("div"),p(xe.$$.fragment),gs=o(),Pt=n("p"),Pt.innerHTML=yo,_s=o(),Z=n("div"),p(be.$$.fragment),vs=o(),kt=n("p"),kt.textContent=Mo,xs=o(),p(G.$$.fragment),bs=o(),R=n("div"),p($e.$$.fragment),$s=o(),It=n("p"),It.innerHTML=wo,ys=o(),q=n("div"),p(ye.$$.fragment),Ms=o(),Xt=n("p"),Xt.textContent=To,ws=o(),p(W.$$.fragment),Ts=o(),V=n("div"),p(Me.$$.fragment),Cs=o(),Lt=n("p"),Lt.innerHTML=Co,Ps=o(),p(Q.$$.fragment),ks=o(),z=n("div"),p(we.$$.fragment),Is=o(),Jt=n("p"),Jt.innerHTML=Po,Xs=o(),p(A.$$.fragment),Ls=o(),Y=n("div"),p(Te.$$.fragment),Js=o(),Ut=n("p"),Ut.textContent=ko,Us=o(),O=n("div"),p(Ce.$$.fragment),js=o(),jt=n("p"),jt.textContent=Io,Zs=o(),K=n("div"),p(Pe.$$.fragment),qs=o(),Zt=n("p"),Zt.textContent=Xo,fr=o(),p(ke.$$.fragment),ur=o(),Ie=n("p"),Ie.innerHTML=Lo,hr=o(),P=n("div"),p(Xe.$$.fragment),Vs=o(),qt=n("p"),qt.textContent=Jo,zs=o(),ee=n("div"),p(Le.$$.fragment),Es=o(),Vt=n("p"),Vt.innerHTML=Uo,Hs=o(),te=n("div"),p(Je.$$.fragment),Ns=o(),zt=n("p"),zt.textContent=jo,Fs=o(),re=n("div"),p(Ue.$$.fragment),Bs=o(),Et=n("p"),Et.textContent=Zo,Ds=o(),se=n("div"),p(je.$$.fragment),Ss=o(),Ht=n("p"),Ht.innerHTML=qo,Gs=o(),oe=n("div"),p(Ze.$$.fragment),Rs=o(),Nt=n("p"),Nt.innerHTML=Vo,Ws=o(),ae=n("div"),p(qe.$$.fragment),Qs=o(),Ft=n("p"),Ft.textContent=zo,gr=o(),J=n("div"),p(Ve.$$.fragment),As=o(),Bt=n("p"),Bt.textContent=Eo,Ys=o(),ne=n("div"),p(ze.$$.fragment),Os=o(),Dt=n("p"),Dt.textContent=Ho,_r=o(),U=n("div"),p(Ee.$$.fragment),Ks=o(),St=n("p"),St.textContent=No,eo=o(),le=n("div"),p(He.$$.fragment),to=o(),Gt=n("p"),Gt.textContent=Fo,vr=o(),p(Ne.$$.fragment),xr=o(),Fe=n("p"),Fe.innerHTML=Bo,br=o(),Be=n("p"),Be.textContent=Do,$r=o(),De=n("p"),De.textContent=So,yr=o(),Se=n("ul"),Se.innerHTML=Go,Mr=o(),Ge=n("p"),Ge.innerHTML=Ro,wr=o(),N=n("div"),p(Re.$$.fragment),ro=o(),Rt=n("p"),Rt.innerHTML=Wo,Tr=o(),p(We.$$.fragment),Cr=o(),Qe=n("p"),Qe.innerHTML=Qo,Pr=o(),Ae=n("p"),Ae.innerHTML=Ao,kr=o(),Ye=n("p"),Ye.textContent=Yo,Ir=o(),Oe=n("ul"),Oe.innerHTML=Oo,Xr=o(),Ke=n("p"),Ke.textContent=Ko,Lr=o(),et=n("p"),et.innerHTML=ea,Jr=o(),p(tt.$$.fragment),Ur=o(),rt=n("p"),rt.innerHTML=ta,jr=o(),st=n("p"),st.textContent=ra,Zr=o(),p(ot.$$.fragment),qr=o(),at=n("p"),at.textContent=sa,Vr=o(),nt=n("ul"),nt.innerHTML=oa,zr=o(),lt=n("p"),lt.innerHTML=aa,Er=o(),X=n("div"),p(it.$$.fragment),so=o(),Wt=n("p"),Wt.textContent=na,oo=o(),ie=n("div"),p(dt.$$.fragment),ao=o(),Qt=n("p"),Qt.textContent=la,no=o(),E=n("div"),p(ct.$$.fragment),lo=o(),At=n("p"),At.innerHTML=ia,io=o(),p(de.$$.fragment),co=o(),ce=n("div"),p(mt.$$.fragment),mo=o(),Yt=n("p"),Yt.textContent=da,Hr=o(),pt=n("p"),pt.innerHTML=ca,Nr=o(),j=n("div"),p(ft.$$.fragment),po=o(),Ot=n("p"),Ot.textContent=ma,fo=o(),p(me.$$.fragment),Fr=o(),ut=n("p"),ut.innerHTML=pa,Br=o(),p(ht.$$.fragment),Dr=o(),gt=n("p"),gt.textContent=fa,Sr=o(),p(_t.$$.fragment),Gr=o(),vt=n("p"),vt.innerHTML=ua,Rr=o(),p(xt.$$.fragment),Wr=o(),bt=n("p"),bt.innerHTML=ha,Qr=o(),p($t.$$.fragment),Ar=o(),nr=n("p"),this.h()},l(e){const r=ba("svelte-u9bgzb",document.head);c=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=l(e,"P",{}),b(v).forEach(t),x=a(e),f(C.$$.fragment,e),m=a(e),k=l(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-8nvl5z"&&(k.textContent=go),ir=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1r5mt3j"&&(fe.innerHTML=_o),dr=a(e),f(ue.$$.fragment,e),cr=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-16hpp4n"&&(he.textContent=vo),mr=a(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-x3ucqc"&&(ge.textContent=xo),pr=a(e),y=l(e,"DIV",{class:!0});var w=b(y);f(_e.$$.fragment,w),ps=a(w),Tt=l(w,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1s4wckx"&&(Tt.textContent=bo),fs=a(w),D=l(w,"DIV",{class:!0});var yt=b(D);f(ve.$$.fragment,yt),us=a(yt),Ct=l(yt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-10dqwuv"&&(Ct.innerHTML=$o),yt.forEach(t),hs=a(w),S=l(w,"DIV",{class:!0});var Mt=b(S);f(xe.$$.fragment,Mt),gs=a(Mt),Pt=l(Mt,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1i2d3vx"&&(Pt.innerHTML=yo),Mt.forEach(t),_s=a(w),Z=l(w,"DIV",{class:!0});var F=b(Z);f(be.$$.fragment,F),vs=a(F),kt=l(F,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1cj8dcb"&&(kt.textContent=Mo),xs=a(F),f(G.$$.fragment,F),F.forEach(t),bs=a(w),R=l(w,"DIV",{class:!0});var wt=b(R);f($e.$$.fragment,wt),$s=a(wt),It=l(wt,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hsvutq"&&(It.innerHTML=wo),wt.forEach(t),ys=a(w),q=l(w,"DIV",{class:!0});var B=b(q);f(ye.$$.fragment,B),Ms=a(B),Xt=l(B,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1cwsjho"&&(Xt.textContent=To),ws=a(B),f(W.$$.fragment,B),B.forEach(t),Ts=a(w),V=l(w,"DIV",{class:!0});var Kt=b(V);f(Me.$$.fragment,Kt),Cs=a(Kt),Lt=l(Kt,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-hhsvto"&&(Lt.innerHTML=Co),Ps=a(Kt),f(Q.$$.fragment,Kt),Kt.forEach(t),ks=a(w),z=l(w,"DIV",{class:!0});var er=b(z);f(we.$$.fragment,er),Is=a(er),Jt=l(er,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-11l8x79"&&(Jt.innerHTML=Po),Xs=a(er),f(A.$$.fragment,er),er.forEach(t),Ls=a(w),Y=l(w,"DIV",{class:!0});var Or=b(Y);f(Te.$$.fragment,Or),Js=a(Or),Ut=l(Or,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1ww3wqq"&&(Ut.textContent=ko),Or.forEach(t),Us=a(w),O=l(w,"DIV",{class:!0});var Kr=b(O);f(Ce.$$.fragment,Kr),js=a(Kr),jt=l(Kr,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1g70y32"&&(jt.textContent=Io),Kr.forEach(t),Zs=a(w),K=l(w,"DIV",{class:!0});var es=b(K);f(Pe.$$.fragment,es),qs=a(es),Zt=l(es,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-5ayq1f"&&(Zt.textContent=Xo),es.forEach(t),w.forEach(t),fr=a(e),f(ke.$$.fragment,e),ur=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1b8i5tx"&&(Ie.innerHTML=Lo),hr=a(e),P=l(e,"DIV",{class:!0});var I=b(P);f(Xe.$$.fragment,I),Vs=a(I),qt=l(I,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1bsw04k"&&(qt.textContent=Jo),zs=a(I),ee=l(I,"DIV",{class:!0});var ts=b(ee);f(Le.$$.fragment,ts),Es=a(ts),Vt=l(ts,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-7p3yoq"&&(Vt.innerHTML=Uo),ts.forEach(t),Hs=a(I),te=l(I,"DIV",{class:!0});var rs=b(te);f(Je.$$.fragment,rs),Ns=a(rs),zt=l(rs,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-pplryq"&&(zt.textContent=jo),rs.forEach(t),Fs=a(I),re=l(I,"DIV",{class:!0});var ss=b(re);f(Ue.$$.fragment,ss),Bs=a(ss),Et=l(ss,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-3oqyjr"&&(Et.textContent=Zo),ss.forEach(t),Ds=a(I),se=l(I,"DIV",{class:!0});var os=b(se);f(je.$$.fragment,os),Ss=a(os),Ht=l(os,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-16rnl5"&&(Ht.innerHTML=qo),os.forEach(t),Gs=a(I),oe=l(I,"DIV",{class:!0});var as=b(oe);f(Ze.$$.fragment,as),Rs=a(as),Nt=l(as,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-190a39f"&&(Nt.innerHTML=Vo),as.forEach(t),Ws=a(I),ae=l(I,"DIV",{class:!0});var ns=b(ae);f(qe.$$.fragment,ns),Qs=a(ns),Ft=l(ns,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1jevh15"&&(Ft.textContent=zo),ns.forEach(t),I.forEach(t),gr=a(e),J=l(e,"DIV",{class:!0});var tr=b(J);f(Ve.$$.fragment,tr),As=a(tr),Bt=l(tr,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-vkt0pi"&&(Bt.textContent=Eo),Ys=a(tr),ne=l(tr,"DIV",{class:!0});var ls=b(ne);f(ze.$$.fragment,ls),Os=a(ls),Dt=l(ls,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-5ayq1f"&&(Dt.textContent=Ho),ls.forEach(t),tr.forEach(t),_r=a(e),U=l(e,"DIV",{class:!0});var rr=b(U);f(Ee.$$.fragment,rr),Ks=a(rr),St=l(rr,"P",{"data-svelte-h":!0}),d(St)!=="svelte-168wf64"&&(St.textContent=No),eo=a(rr),le=l(rr,"DIV",{class:!0});var is=b(le);f(He.$$.fragment,is),to=a(is),Gt=l(is,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-5ayq1f"&&(Gt.textContent=Fo),is.forEach(t),rr.forEach(t),vr=a(e),f(Ne.$$.fragment,e),xr=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-pgkk87"&&(Fe.innerHTML=Bo),br=a(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1iz8kjk"&&(Be.textContent=Do),$r=a(e),De=l(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-ejlsq2"&&(De.textContent=So),yr=a(e),Se=l(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-my8qym"&&(Se.innerHTML=Go),Mr=a(e),Ge=l(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-m96k2a"&&(Ge.innerHTML=Ro),wr=a(e),N=l(e,"DIV",{class:!0});var ds=b(N);f(Re.$$.fragment,ds),ro=a(ds),Rt=l(ds,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-5lvrve"&&(Rt.innerHTML=Wo),ds.forEach(t),Tr=a(e),f(We.$$.fragment,e),Cr=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-9mlx1z"&&(Qe.innerHTML=Qo),Pr=a(e),Ae=l(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1qabksm"&&(Ae.innerHTML=Ao),kr=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-uho2qa"&&(Ye.textContent=Yo),Ir=a(e),Oe=l(e,"UL",{"data-svelte-h":!0}),d(Oe)!=="svelte-1e2xq99"&&(Oe.innerHTML=Oo),Xr=a(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-sz5yy2"&&(Ke.textContent=Ko),Lr=a(e),et=l(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1mss3di"&&(et.innerHTML=ea),Jr=a(e),f(tt.$$.fragment,e),Ur=a(e),rt=l(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1i4abtq"&&(rt.innerHTML=ta),jr=a(e),st=l(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-zxdzom"&&(st.textContent=ra),Zr=a(e),f(ot.$$.fragment,e),qr=a(e),at=l(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-ejlsq2"&&(at.textContent=sa),Vr=a(e),nt=l(e,"UL",{"data-svelte-h":!0}),d(nt)!=="svelte-1qiv3qf"&&(nt.innerHTML=oa),zr=a(e),lt=l(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1r22nj6"&&(lt.innerHTML=aa),Er=a(e),X=l(e,"DIV",{class:!0});var H=b(X);f(it.$$.fragment,H),so=a(H),Wt=l(H,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-173gxyd"&&(Wt.textContent=na),oo=a(H),ie=l(H,"DIV",{class:!0});var cs=b(ie);f(dt.$$.fragment,cs),ao=a(cs),Qt=l(cs,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-wmaktk"&&(Qt.textContent=la),cs.forEach(t),no=a(H),E=l(H,"DIV",{class:!0});var sr=b(E);f(ct.$$.fragment,sr),lo=a(sr),At=l(sr,"P",{"data-svelte-h":!0}),d(At)!=="svelte-11nqnea"&&(At.innerHTML=ia),io=a(sr),f(de.$$.fragment,sr),sr.forEach(t),co=a(H),ce=l(H,"DIV",{class:!0});var ms=b(ce);f(mt.$$.fragment,ms),mo=a(ms),Yt=l(ms,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-d5zv1x"&&(Yt.textContent=da),ms.forEach(t),H.forEach(t),Hr=a(e),pt=l(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-12wzh89"&&(pt.innerHTML=ca),Nr=a(e),j=l(e,"DIV",{class:!0});var or=b(j);f(ft.$$.fragment,or),po=a(or),Ot=l(or,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-169nh0g"&&(Ot.textContent=ma),fo=a(or),f(me.$$.fragment,or),or.forEach(t),Fr=a(e),ut=l(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-2mj9lk"&&(ut.innerHTML=pa),Br=a(e),f(ht.$$.fragment,e),Dr=a(e),gt=l(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1q119ra"&&(gt.textContent=fa),Sr=a(e),f(_t.$$.fragment,e),Gr=a(e),vt=l(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-9ecb4t"&&(vt.innerHTML=ua),Rr=a(e),f(xt.$$.fragment,e),Wr=a(e),bt=l(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-8lr0dh"&&(bt.innerHTML=ha),Qr=a(e),f($t.$$.fragment,e),Ar=a(e),nr=l(e,"P",{}),b(nr).forEach(t),this.h()},h(){$(c,"name","hf:doc:metadata"),$(c,"content",Ia),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,c),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,k,r),i(e,ir,r),i(e,fe,r),i(e,dr,r),u(ue,e,r),i(e,cr,r),i(e,he,r),i(e,mr,r),i(e,ge,r),i(e,pr,r),i(e,y,r),u(_e,y,null),s(y,ps),s(y,Tt),s(y,fs),s(y,D),u(ve,D,null),s(D,us),s(D,Ct),s(y,hs),s(y,S),u(xe,S,null),s(S,gs),s(S,Pt),s(y,_s),s(y,Z),u(be,Z,null),s(Z,vs),s(Z,kt),s(Z,xs),u(G,Z,null),s(y,bs),s(y,R),u($e,R,null),s(R,$s),s(R,It),s(y,ys),s(y,q),u(ye,q,null),s(q,Ms),s(q,Xt),s(q,ws),u(W,q,null),s(y,Ts),s(y,V),u(Me,V,null),s(V,Cs),s(V,Lt),s(V,Ps),u(Q,V,null),s(y,ks),s(y,z),u(we,z,null),s(z,Is),s(z,Jt),s(z,Xs),u(A,z,null),s(y,Ls),s(y,Y),u(Te,Y,null),s(Y,Js),s(Y,Ut),s(y,Us),s(y,O),u(Ce,O,null),s(O,js),s(O,jt),s(y,Zs),s(y,K),u(Pe,K,null),s(K,qs),s(K,Zt),i(e,fr,r),u(ke,e,r),i(e,ur,r),i(e,Ie,r),i(e,hr,r),i(e,P,r),u(Xe,P,null),s(P,Vs),s(P,qt),s(P,zs),s(P,ee),u(Le,ee,null),s(ee,Es),s(ee,Vt),s(P,Hs),s(P,te),u(Je,te,null),s(te,Ns),s(te,zt),s(P,Fs),s(P,re),u(Ue,re,null),s(re,Bs),s(re,Et),s(P,Ds),s(P,se),u(je,se,null),s(se,Ss),s(se,Ht),s(P,Gs),s(P,oe),u(Ze,oe,null),s(oe,Rs),s(oe,Nt),s(P,Ws),s(P,ae),u(qe,ae,null),s(ae,Qs),s(ae,Ft),i(e,gr,r),i(e,J,r),u(Ve,J,null),s(J,As),s(J,Bt),s(J,Ys),s(J,ne),u(ze,ne,null),s(ne,Os),s(ne,Dt),i(e,_r,r),i(e,U,r),u(Ee,U,null),s(U,Ks),s(U,St),s(U,eo),s(U,le),u(He,le,null),s(le,to),s(le,Gt),i(e,vr,r),u(Ne,e,r),i(e,xr,r),i(e,Fe,r),i(e,br,r),i(e,Be,r),i(e,$r,r),i(e,De,r),i(e,yr,r),i(e,Se,r),i(e,Mr,r),i(e,Ge,r),i(e,wr,r),i(e,N,r),u(Re,N,null),s(N,ro),s(N,Rt),i(e,Tr,r),u(We,e,r),i(e,Cr,r),i(e,Qe,r),i(e,Pr,r),i(e,Ae,r),i(e,kr,r),i(e,Ye,r),i(e,Ir,r),i(e,Oe,r),i(e,Xr,r),i(e,Ke,r),i(e,Lr,r),i(e,et,r),i(e,Jr,r),u(tt,e,r),i(e,Ur,r),i(e,rt,r),i(e,jr,r),i(e,st,r),i(e,Zr,r),u(ot,e,r),i(e,qr,r),i(e,at,r),i(e,Vr,r),i(e,nt,r),i(e,zr,r),i(e,lt,r),i(e,Er,r),i(e,X,r),u(it,X,null),s(X,so),s(X,Wt),s(X,oo),s(X,ie),u(dt,ie,null),s(ie,ao),s(ie,Qt),s(X,no),s(X,E),u(ct,E,null),s(E,lo),s(E,At),s(E,io),u(de,E,null),s(X,co),s(X,ce),u(mt,ce,null),s(ce,mo),s(ce,Yt),i(e,Hr,r),i(e,pt,r),i(e,Nr,r),i(e,j,r),u(ft,j,null),s(j,po),s(j,Ot),s(j,fo),u(me,j,null),i(e,Fr,r),i(e,ut,r),i(e,Br,r),u(ht,e,r),i(e,Dr,r),i(e,gt,r),i(e,Sr,r),u(_t,e,r),i(e,Gr,r),i(e,vt,r),i(e,Rr,r),u(xt,e,r),i(e,Wr,r),i(e,bt,r),i(e,Qr,r),u($t,e,r),i(e,Ar,r),i(e,nr,r),Yr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),W.$set(yt);const Mt={};r&2&&(Mt.$$scope={dirty:r,ctx:e}),Q.$set(Mt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),A.$set(F);const wt={};r&2&&(wt.$$scope={dirty:r,ctx:e}),de.$set(wt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),me.$set(B)},i(e){Yr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(be.$$.fragment,e),h(G.$$.fragment,e),h($e.$$.fragment,e),h(ye.$$.fragment,e),h(W.$$.fragment,e),h(Me.$$.fragment,e),h(Q.$$.fragment,e),h(we.$$.fragment,e),h(A.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Le.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(de.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(me.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),Yr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(be.$$.fragment,e),g(G.$$.fragment,e),g($e.$$.fragment,e),g(ye.$$.fragment,e),g(W.$$.fragment,e),g(Me.$$.fragment,e),g(Q.$$.fragment,e),g(we.$$.fragment,e),g(A.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Le.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ne.$$.fragment,e),g(Re.$$.fragment,e),g(We.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(de.$$.fragment,e),g(mt.$$.fragment,e),g(ft.$$.fragment,e),g(me.$$.fragment,e),g(ht.$$.fragment,e),g(_t.$$.fragment,e),g(xt.$$.fragment,e),g($t.$$.fragment,e),Yr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(k),t(ir),t(fe),t(dr),t(cr),t(he),t(mr),t(ge),t(pr),t(y),t(fr),t(ur),t(Ie),t(hr),t(P),t(gr),t(J),t(_r),t(U),t(vr),t(xr),t(Fe),t(br),t(Be),t($r),t(De),t(yr),t(Se),t(Mr),t(Ge),t(wr),t(N),t(Tr),t(Cr),t(Qe),t(Pr),t(Ae),t(kr),t(Ye),t(Ir),t(Oe),t(Xr),t(Ke),t(Lr),t(et),t(Jr),t(Ur),t(rt),t(jr),t(st),t(Zr),t(qr),t(at),t(Vr),t(nt),t(zr),t(lt),t(Er),t(X),t(Hr),t(pt),t(Nr),t(j),t(Fr),t(ut),t(Br),t(Dr),t(gt),t(Sr),t(Gr),t(vt),t(Rr),t(Wr),t(bt),t(Qr),t(Ar),t(nr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(be),_(G),_($e),_(ye),_(W),_(Me),_(Q),_(we),_(A),_(Te),_(Ce),_(Pe),_(ke,e),_(Xe),_(Le),_(Je),_(Ue),_(je),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He),_(Ne,e),_(Re),_(We,e),_(tt,e),_(ot,e),_(it),_(dt),_(ct),_(de),_(mt),_(ft),_(me),_(ht,e),_(_t,e),_(xt,e),_($t,e)}}}const Ia='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xa(L){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends va{constructor(c){super(),xa(this,c,Xa,ka,ga,{})}}export{za as component};
