import{s as Ls,o as Ys,n as zs}from"../chunks/scheduler.889ebb13.js";import{S as Ps,i as Ks,g as o,s as n,r as M,m as Jt,A as Ds,h as p,f as e,c as a,j as ds,u,x as i,n as ft,k as Tt,y as ys,a as l,v as m,d,t as y,w as h}from"../chunks/index.ca18042b.js";import{T as Ns}from"../chunks/Tip.b8116e3c.js";import{C as g}from"../chunks/CodeBlock.1db71023.js";import{H as I}from"../chunks/Heading.3daa581c.js";import{E as Os}from"../chunks/EditOnGithub.2e95618d.js";function te(yt){let r,c,f="this notebook",j;return{c(){r=Jt("You can follow the code in "),c=o("a"),c.textContent=f,j=Jt(" that you can run using Google Colab."),this.h()},l(w){r=ft(w,"You can follow the code in "),c=p(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(c)!=="svelte-1g92vyy"&&(c.textContent=f),j=ft(w," that you can run using Google Colab."),this.h()},h(){Tt(c,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb"),Tt(c,"target","_blank")},m(w,J){l(w,r,J),l(w,c,J),l(w,j,J)},p:zs,d(w){w&&(e(r),e(c),e(j))}}}function se(yt){let r,c,f="the LlamaIndex documentation",j;return{c(){r=Jt("There are some more complex nuances to workflows, which you can learn about in "),c=o("a"),c.textContent=f,j=Jt("."),this.h()},l(w){r=ft(w,"There are some more complex nuances to workflows, which you can learn about in "),c=p(w,"A",{href:!0,"data-svelte-h":!0}),i(c)!=="svelte-3nnrtm"&&(c.textContent=f),j=ft(w,"."),this.h()},h(){Tt(c,"href","https://docs.llamaindex.ai/en/stable/understanding/workflows/")},m(w,J){l(w,r,J),l(w,c,J),l(w,j,J)},p:zs,d(w){w&&(e(r),e(c),e(j))}}}function ee(yt){let r,c,f,j,w,J,k,hs="A workflow in LlamaIndex provides a structured way to organize your code into sequential and manageable steps.",Ut,C,js=`Such a workflow is created by defining <code>Steps</code> which are triggered by <code>Events</code>, and themselves emit <code>Events</code> to trigger further steps.
Let’s take a look at Alfred showing a LlamaIndex workflow for a RAG task.`,bt,B,Js='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',gt,v,fs="<strong>Workflows offer several key benefits:</strong>",It,Z,Ts="<li>Clear organization of code into discrete steps</li> <li>Event-driven architecture for flexible control flow</li> <li>Type-safe communication between steps</li> <li>Built-in state management</li> <li>Support for both simple and complex agent interactions</li>",kt,G,Us="As you might have guessed, <strong>workflows strike a great balance between the autonomy of agents while maintaining control over the overall workflow.</strong>",Ct,_,bs="So, let’s learn how to create a workflow ourselves!",Bt,x,vt,T,Zt,$,Gt,U,ht,gs="Install the Workflow package",ms,E,_t,W,Is=`We can create a single-step workflow by defining a class that inherits from <code>Workflow</code> and decorating your functions with <code>@step</code>.
We will also need to add <code>StartEvent</code> and <code>StopEvent</code>, which are special events that are used to indicate the start and end of the workflow.`,xt,V,$t,A,ks="As you can see, we can now run the workflow by calling <code>w.run()</code>.",Et,Q,Wt,S,Cs=`To connect multiple steps, we <strong>create custom events that carry data between steps.</strong>
To do so, we need to add an <code>Event</code> that is passed between the steps and transfers the output of the first step to the second step.`,Vt,H,At,X,Bs="The type hinting is important here, as it ensures that the workflow is executed correctly. Let’s complicate things a bit more!",Qt,F,St,R,vs="The type hinting is the most powerful part of workflows because it allows us to create branches, loops, and joins to facilitate more complex workflows.",Ht,q,Zs=`Let’s show an example of <strong>creating a loop</strong> by using the union operator <code>|</code>.
In the example below, we see that the <code>LoopEvent</code> is taken as input for the step and can also be returned as output.`,Xt,N,Ft,z,Rt,L,Gs="We can also draw workflows. Let’s use the <code>draw_all_possible_flows</code> function to draw the workflow. This stores the workflow in an HTML file.",qt,Y,Nt,P,_s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',zt,K,xs="There is one last cool trick that we will cover in the course, which is the ability to add state to the workflow.",Lt,D,Yt,O,$s=`State management is useful when you want to keep track of the state of the workflow, so that every step has access to the same state.
We can do this by using the <code>Context</code> type hint on top of a parameter in the step function.`,Pt,tt,Kt,st,Es="Great! Now you know how to create basic workflows in LlamaIndex!",Dt,b,Ot,et,Ws="However, there is another way to create workflows, which relies on the <code>AgentWorkflow</code> class. Let’s take a look at how we can use this to create a multi-agent workflow.",ts,lt,ss,nt,Vs=`Instead of manual workflow creation, we can use the <strong><code>AgentWorkflow</code> class to create a multi-agent workflow</strong>.
The <code>AgentWorkflow</code> uses Workflow Agents to allow you to create a system of one or more agents that can collaborate and hand off tasks to each other based on their specialized capabilities.
This enables building complex agent systems where different agents handle different aspects of a task.
Instead of importing classes from <code>llama_index.core.agent</code>, we will import the agent classes from <code>llama_index.core.agent.workflow</code>.
One agent must be designated as the root agent in the <code>AgentWorkflow</code> constructor.
When a user message comes in, it is first routed to the root agent.`,es,at,As="Each agent can then:",ls,ot,Qs="<li>Handle the request directly using their tools</li> <li>Handoff to another agent better suited for the task</li> <li>Return a response to the user</li>",ns,pt,Ss="Let’s see how to create a multi-agent workflow.",as,it,os,wt,Hs=`Agent tools can also modify the workflow state we mentioned earlier. Before starting the workflow, we can provide an initial state dict that will be available to all agents.
The state is stored in the state key of the workflow context. It will be injected into the state_prompt which augments each new user message.`,ps,ct,Xs="Let’s inject a counter to count function calls by modifying the previous example:",is,rt,ws,Mt,Fs="Congratulations! You have now mastered the basics of Agents in LlamaIndex! 🎉",cs,ut,Rs="Let’s continue with one final quiz to solidify your knowledge! 🚀",rs,mt,Ms,jt,us;return w=new I({props:{title:"Creating agentic workflows in LlamaIndex",local:"creating-agentic-workflows-in-llamaindex",headingTag:"h1"}}),x=new I({props:{title:"Creating Workflows",local:"creating-workflows",headingTag:"h2"}}),T=new Ns({props:{$$slots:{default:[te]},$$scope:{ctx:yt}}}),$=new I({props:{title:"Basic Workflow Creation",local:"basic-workflow-creation",headingTag:"h3"}}),E=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),V=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),Q=new I({props:{title:"Connecting Multiple Steps",local:"connecting-multiple-steps",headingTag:"h3"}}),H=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),F=new I({props:{title:"Loops and Branches",local:"loops-and-branches",headingTag:"h3"}}),N=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent | LoopEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),z=new I({props:{title:"Drawing Workflows",local:"drawing-workflows",headingTag:"h3"}}),Y=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),D=new I({props:{title:"State Management",local:"state-management",headingTag:"h3"}}),tt=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9yZSUyMGluJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMGF3YWl0JTIwY3R4LnNldCglMjJxdWVyeSUyMiUyQyUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBkbyUyMHNvbWV0aGluZyUyMHdpdGglMjBjb250ZXh0JTIwYW5kJTIwZXZlbnQlMEElMjAlMjAlMjAlMjB2YWwlMjAlM0QlMjAuLi4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjByZXRyaWV2ZSUyMGZyb20lMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwcXVlcnklMjAlM0QlMjBhd2FpdCUyMGN0eC5nZXQoJTIycXVlcnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># store in context</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># do something with context and event</span>
    val = ...

    <span class="hljs-comment"># retrieve from context</span>
    query = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=result)`,wrap:!1}}),b=new Ns({props:{$$slots:{default:[se]},$$scope:{ctx:yt}}}),lt=new I({props:{title:"Automating workflows with Multi-Agent Workflows",local:"automating-workflows-with-multi-agent-workflows",headingTag:"h2"}}),it=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># we can pass functions directly without FunctionTool -- the fn/docstring are parsed for the name/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Create the workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),rt=new g({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># run the workflow with context</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># pull out and inspect the state</span>
state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),mt=new Os({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/workflows.mdx"}}),{c(){r=o("meta"),c=n(),f=o("p"),j=n(),M(w.$$.fragment),J=n(),k=o("p"),k.textContent=hs,Ut=n(),C=o("p"),C.innerHTML=js,bt=n(),B=o("p"),B.innerHTML=Js,gt=n(),v=o("p"),v.innerHTML=fs,It=n(),Z=o("ul"),Z.innerHTML=Ts,kt=n(),G=o("p"),G.innerHTML=Us,Ct=n(),_=o("p"),_.textContent=bs,Bt=n(),M(x.$$.fragment),vt=n(),M(T.$$.fragment),Zt=n(),M($.$$.fragment),Gt=n(),U=o("details"),ht=o("summary"),ht.textContent=gs,ms=Jt(`
As introduced in the [section on the LlamaHub](llama-hub.mdx), we can install the Workflow package with the following command:

	`),M(E.$$.fragment),_t=n(),W=o("p"),W.innerHTML=Is,xt=n(),M(V.$$.fragment),$t=n(),A=o("p"),A.innerHTML=ks,Et=n(),M(Q.$$.fragment),Wt=n(),S=o("p"),S.innerHTML=Cs,Vt=n(),M(H.$$.fragment),At=n(),X=o("p"),X.textContent=Bs,Qt=n(),M(F.$$.fragment),St=n(),R=o("p"),R.textContent=vs,Ht=n(),q=o("p"),q.innerHTML=Zs,Xt=n(),M(N.$$.fragment),Ft=n(),M(z.$$.fragment),Rt=n(),L=o("p"),L.innerHTML=Gs,qt=n(),M(Y.$$.fragment),Nt=n(),P=o("p"),P.innerHTML=_s,zt=n(),K=o("p"),K.textContent=xs,Lt=n(),M(D.$$.fragment),Yt=n(),O=o("p"),O.innerHTML=$s,Pt=n(),M(tt.$$.fragment),Kt=n(),st=o("p"),st.textContent=Es,Dt=n(),M(b.$$.fragment),Ot=n(),et=o("p"),et.innerHTML=Ws,ts=n(),M(lt.$$.fragment),ss=n(),nt=o("p"),nt.innerHTML=Vs,es=n(),at=o("p"),at.textContent=As,ls=n(),ot=o("ul"),ot.innerHTML=Qs,ns=n(),pt=o("p"),pt.textContent=Ss,as=n(),M(it.$$.fragment),os=n(),wt=o("p"),wt.textContent=Hs,ps=n(),ct=o("p"),ct.textContent=Xs,is=n(),M(rt.$$.fragment),ws=n(),Mt=o("p"),Mt.textContent=Fs,cs=n(),ut=o("p"),ut.textContent=Rs,rs=n(),M(mt.$$.fragment),Ms=n(),jt=o("p"),this.h()},l(t){const s=Ds("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(e),c=a(t),f=p(t,"P",{}),ds(f).forEach(e),j=a(t),u(w.$$.fragment,t),J=a(t),k=p(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1kssncf"&&(k.textContent=hs),Ut=a(t),C=p(t,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1ogtysv"&&(C.innerHTML=js),bt=a(t),B=p(t,"P",{"data-svelte-h":!0}),i(B)!=="svelte-whmuha"&&(B.innerHTML=Js),gt=a(t),v=p(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1ff8id8"&&(v.innerHTML=fs),It=a(t),Z=p(t,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-14kaj17"&&(Z.innerHTML=Ts),kt=a(t),G=p(t,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1cddxrt"&&(G.innerHTML=Us),Ct=a(t),_=p(t,"P",{"data-svelte-h":!0}),i(_)!=="svelte-i0dazf"&&(_.textContent=bs),Bt=a(t),u(x.$$.fragment,t),vt=a(t),u(T.$$.fragment,t),Zt=a(t),u($.$$.fragment,t),Gt=a(t),U=p(t,"DETAILS",{});var dt=ds(U);ht=p(dt,"SUMMARY",{"data-svelte-h":!0}),i(ht)!=="svelte-1vs5sev"&&(ht.textContent=gs),ms=ft(dt,`
As introduced in the [section on the LlamaHub](llama-hub.mdx), we can install the Workflow package with the following command:

	`),u(E.$$.fragment,dt),dt.forEach(e),_t=a(t),W=p(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1wc9dhn"&&(W.innerHTML=Is),xt=a(t),u(V.$$.fragment,t),$t=a(t),A=p(t,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1x5qg2q"&&(A.innerHTML=ks),Et=a(t),u(Q.$$.fragment,t),Wt=a(t),S=p(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1gl1q10"&&(S.innerHTML=Cs),Vt=a(t),u(H.$$.fragment,t),At=a(t),X=p(t,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1ssz2vu"&&(X.textContent=Bs),Qt=a(t),u(F.$$.fragment,t),St=a(t),R=p(t,"P",{"data-svelte-h":!0}),i(R)!=="svelte-7kgjbz"&&(R.textContent=vs),Ht=a(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-19z56vc"&&(q.innerHTML=Zs),Xt=a(t),u(N.$$.fragment,t),Ft=a(t),u(z.$$.fragment,t),Rt=a(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-gq4idr"&&(L.innerHTML=Gs),qt=a(t),u(Y.$$.fragment,t),Nt=a(t),P=p(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1j5vf43"&&(P.innerHTML=_s),zt=a(t),K=p(t,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1nn9pf"&&(K.textContent=xs),Lt=a(t),u(D.$$.fragment,t),Yt=a(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1a42m1e"&&(O.innerHTML=$s),Pt=a(t),u(tt.$$.fragment,t),Kt=a(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-ayh2hg"&&(st.textContent=Es),Dt=a(t),u(b.$$.fragment,t),Ot=a(t),et=p(t,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1f8yr21"&&(et.innerHTML=Ws),ts=a(t),u(lt.$$.fragment,t),ss=a(t),nt=p(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-64dk7s"&&(nt.innerHTML=Vs),es=a(t),at=p(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-1b9i7pj"&&(at.textContent=As),ls=a(t),ot=p(t,"UL",{"data-svelte-h":!0}),i(ot)!=="svelte-bg3pcb"&&(ot.innerHTML=Qs),ns=a(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-193z3j0"&&(pt.textContent=Ss),as=a(t),u(it.$$.fragment,t),os=a(t),wt=p(t,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-y63ydc"&&(wt.textContent=Hs),ps=a(t),ct=p(t,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-k4pfxh"&&(ct.textContent=Xs),is=a(t),u(rt.$$.fragment,t),ws=a(t),Mt=p(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-1rveoqn"&&(Mt.textContent=Fs),cs=a(t),ut=p(t,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-u1alm2"&&(ut.textContent=Rs),rs=a(t),u(mt.$$.fragment,t),Ms=a(t),jt=p(t,"P",{}),ds(jt).forEach(e),this.h()},h(){Tt(r,"name","hf:doc:metadata"),Tt(r,"content",le)},m(t,s){ys(document.head,r),l(t,c,s),l(t,f,s),l(t,j,s),m(w,t,s),l(t,J,s),l(t,k,s),l(t,Ut,s),l(t,C,s),l(t,bt,s),l(t,B,s),l(t,gt,s),l(t,v,s),l(t,It,s),l(t,Z,s),l(t,kt,s),l(t,G,s),l(t,Ct,s),l(t,_,s),l(t,Bt,s),m(x,t,s),l(t,vt,s),m(T,t,s),l(t,Zt,s),m($,t,s),l(t,Gt,s),l(t,U,s),ys(U,ht),ys(U,ms),m(E,U,null),l(t,_t,s),l(t,W,s),l(t,xt,s),m(V,t,s),l(t,$t,s),l(t,A,s),l(t,Et,s),m(Q,t,s),l(t,Wt,s),l(t,S,s),l(t,Vt,s),m(H,t,s),l(t,At,s),l(t,X,s),l(t,Qt,s),m(F,t,s),l(t,St,s),l(t,R,s),l(t,Ht,s),l(t,q,s),l(t,Xt,s),m(N,t,s),l(t,Ft,s),m(z,t,s),l(t,Rt,s),l(t,L,s),l(t,qt,s),m(Y,t,s),l(t,Nt,s),l(t,P,s),l(t,zt,s),l(t,K,s),l(t,Lt,s),m(D,t,s),l(t,Yt,s),l(t,O,s),l(t,Pt,s),m(tt,t,s),l(t,Kt,s),l(t,st,s),l(t,Dt,s),m(b,t,s),l(t,Ot,s),l(t,et,s),l(t,ts,s),m(lt,t,s),l(t,ss,s),l(t,nt,s),l(t,es,s),l(t,at,s),l(t,ls,s),l(t,ot,s),l(t,ns,s),l(t,pt,s),l(t,as,s),m(it,t,s),l(t,os,s),l(t,wt,s),l(t,ps,s),l(t,ct,s),l(t,is,s),m(rt,t,s),l(t,ws,s),l(t,Mt,s),l(t,cs,s),l(t,ut,s),l(t,rs,s),m(mt,t,s),l(t,Ms,s),l(t,jt,s),us=!0},p(t,[s]){const dt={};s&2&&(dt.$$scope={dirty:s,ctx:t}),T.$set(dt);const qs={};s&2&&(qs.$$scope={dirty:s,ctx:t}),b.$set(qs)},i(t){us||(d(w.$$.fragment,t),d(x.$$.fragment,t),d(T.$$.fragment,t),d($.$$.fragment,t),d(E.$$.fragment,t),d(V.$$.fragment,t),d(Q.$$.fragment,t),d(H.$$.fragment,t),d(F.$$.fragment,t),d(N.$$.fragment,t),d(z.$$.fragment,t),d(Y.$$.fragment,t),d(D.$$.fragment,t),d(tt.$$.fragment,t),d(b.$$.fragment,t),d(lt.$$.fragment,t),d(it.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),us=!0)},o(t){y(w.$$.fragment,t),y(x.$$.fragment,t),y(T.$$.fragment,t),y($.$$.fragment,t),y(E.$$.fragment,t),y(V.$$.fragment,t),y(Q.$$.fragment,t),y(H.$$.fragment,t),y(F.$$.fragment,t),y(N.$$.fragment,t),y(z.$$.fragment,t),y(Y.$$.fragment,t),y(D.$$.fragment,t),y(tt.$$.fragment,t),y(b.$$.fragment,t),y(lt.$$.fragment,t),y(it.$$.fragment,t),y(rt.$$.fragment,t),y(mt.$$.fragment,t),us=!1},d(t){t&&(e(c),e(f),e(j),e(J),e(k),e(Ut),e(C),e(bt),e(B),e(gt),e(v),e(It),e(Z),e(kt),e(G),e(Ct),e(_),e(Bt),e(vt),e(Zt),e(Gt),e(U),e(_t),e(W),e(xt),e($t),e(A),e(Et),e(Wt),e(S),e(Vt),e(At),e(X),e(Qt),e(St),e(R),e(Ht),e(q),e(Xt),e(Ft),e(Rt),e(L),e(qt),e(Nt),e(P),e(zt),e(K),e(Lt),e(Yt),e(O),e(Pt),e(Kt),e(st),e(Dt),e(Ot),e(et),e(ts),e(ss),e(nt),e(es),e(at),e(ls),e(ot),e(ns),e(pt),e(as),e(os),e(wt),e(ps),e(ct),e(is),e(ws),e(Mt),e(cs),e(ut),e(rs),e(Ms),e(jt)),e(r),h(w,t),h(x,t),h(T,t),h($,t),h(E),h(V,t),h(Q,t),h(H,t),h(F,t),h(N,t),h(z,t),h(Y,t),h(D,t),h(tt,t),h(b,t),h(lt,t),h(it,t),h(rt,t),h(mt,t)}}}const le='{"title":"Creating agentic workflows in LlamaIndex","local":"creating-agentic-workflows-in-llamaindex","sections":[{"title":"Creating Workflows","local":"creating-workflows","sections":[{"title":"Basic Workflow Creation","local":"basic-workflow-creation","sections":[],"depth":3},{"title":"Connecting Multiple Steps","local":"connecting-multiple-steps","sections":[],"depth":3},{"title":"Loops and Branches","local":"loops-and-branches","sections":[],"depth":3},{"title":"Drawing Workflows","local":"drawing-workflows","sections":[],"depth":3},{"title":"State Management","local":"state-management","sections":[],"depth":3}],"depth":2},{"title":"Automating workflows with Multi-Agent Workflows","local":"automating-workflows-with-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function ne(yt){return Ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class re extends Ps{constructor(r){super(),Ks(this,r,ne,ee,Ls,{})}}export{re as component};
