import{s as Pt,o as Jt,n as Be}from"../chunks/scheduler.25b97de1.js";import{S as Ft,i as Rt,g as c,s as r,r as g,A as Nt,h as m,f as o,c as i,j as F,u as f,x as v,k as R,y as p,a,v as h,d as u,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Ut}from"../chunks/Tip.baa67368.js";import{D as he}from"../chunks/Docstring.e257edda.js";import{C as gt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as pt}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Wt}from"../chunks/PipelineTag.5f100392.js";import{H as S,E as Zt}from"../chunks/EditOnGithub.91d95064.js";function kt(C){let s,$="Example:",l,d,y;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdENvbmZpZyUyQyUyMEJpdE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJpVCUyMGJpdC01MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCaXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwYml0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBCaXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitConfig, BitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BiT bit-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the bit-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,l=r(),g(d.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),v(s)!=="svelte-11lpom8"&&(s.textContent=$),l=i(n),f(d.$$.fragment,n)},m(n,T){a(n,s,T),a(n,l,T),h(d,n,T),y=!0},p:Be,i(n){y||(u(d.$$.fragment,n),y=!0)},o(n){_(d.$$.fragment,n),y=!1},d(n){n&&(o(s),o(l)),b(d,n)}}}function Et(C){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=$},l(l){s=m(l,"P",{"data-svelte-h":!0}),v(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(l,d){a(l,s,d)},p:Be,d(l){l&&o(s)}}}function qt(C){let s,$="Example:",l,d,y;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJpdE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZiaXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGYml0LTUwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/bit-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitModel.from_pretrained(<span class="hljs-string">&quot;google/bit-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,l=r(),g(d.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),v(s)!=="svelte-11lpom8"&&(s.textContent=$),l=i(n),f(d.$$.fragment,n)},m(n,T){a(n,s,T),a(n,l,T),h(d,n,T),y=!0},p:Be,i(n){y||(u(d.$$.fragment,n),y=!0)},o(n){_(d.$$.fragment,n),y=!1},d(n){n&&(o(s),o(l)),b(d,n)}}}function Lt(C){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=c("p"),s.innerHTML=$},l(l){s=m(l,"P",{"data-svelte-h":!0}),v(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(l,d){a(l,s,d)},p:Be,d(l){l&&o(s)}}}function Gt(C){let s,$="Example:",l,d,y;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJpdEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmJpdC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEJpdEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmJpdC01MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/bit-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/bit-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tiger cat`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,l=r(),g(d.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),v(s)!=="svelte-11lpom8"&&(s.textContent=$),l=i(n),f(d.$$.fragment,n)},m(n,T){a(n,s,T),a(n,l,T),h(d,n,T),y=!0},p:Be,i(n){y||(u(d.$$.fragment,n),y=!0)},o(n){_(d.$$.fragment,n),y=!1},d(n){n&&(o(s),o(l)),b(d,n)}}}function St(C){let s,$,l,d,y,n,T,xe,H,ft=`The BiT model was proposed in <a href="https://arxiv.org/abs/1912.11370" rel="nofollow">Big Transfer (BiT): General Visual Representation Learning</a> by Alexander Kolesnikov, Lucas Beyer, Xiaohua Zhai, Joan Puigcerver, Jessica Yung, Sylvain Gelly, Neil Houlsby.
BiT is a simple recipe for scaling up pre-training of <a href="resnet">ResNet</a>-like architectures (specifically, ResNetv2). The method results in significant improvements for transfer learning.`,Ie,X,ht="The abstract from the paper is the following:",je,V,ut="<em>Transfer of pre-trained representations improves sample efficiency and simplifies hyperparameter tuning when training deep neural networks for vision. We revisit the paradigm of pre-training on large supervised datasets and fine-tuning the model on a target task. We scale up pre-training, and propose a simple recipe that we call Big Transfer (BiT). By combining a few carefully selected components, and transferring using a simple heuristic, we achieve strong performance on over 20 datasets. BiT performs well across a surprisingly wide range of data regimes — from 1 example per class to 1M total examples. BiT achieves 87.5% top-1 accuracy on ILSVRC-2012, 99.4% on CIFAR-10, and 76.3% on the 19 task Visual Task Adaptation Benchmark (VTAB). On small datasets, BiT attains 76.8% on ILSVRC-2012 with 10 examples per class, and 97.0% on CIFAR-10 with 10 examples per class. We conduct detailed analysis of the main components that lead to high transfer performance.</em>",ze,A,_t=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/big_transfer" rel="nofollow">here</a>.`,Ue,Q,Pe,Y,bt=`<li>BiT models are equivalent to ResNetv2 in terms of architecture, except that: 1) all batch normalization layers are replaced by <a href="https://arxiv.org/abs/1803.08494" rel="nofollow">group normalization</a>,
2) <a href="https://arxiv.org/abs/1903.10520" rel="nofollow">weight standardization</a> is used for convolutional layers. The authors show that the combination of both is useful for training with large batch sizes, and has a significant
impact on transfer learning.</li>`,Je,D,Fe,O,yt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BiT.",Re,K,Ne,ee,vt='<li><a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',We,te,$t="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ze,oe,ke,w,se,Qe,ue,Tt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitModel">BitModel</a>. It is used to instantiate an BiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the BiT
<a href="https://huggingface.co/google/bit-50" rel="nofollow">google/bit-50</a> architecture.`,Ye,_e,wt=`Configuration objects inherit from <a href="/docs/transformers/pr_27412/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_27412/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,De,N,Ee,ne,qe,I,ae,Oe,be,Mt="Constructs a BiT image processor.",Ke,W,re,et,ye,Ct="Preprocess an image or batch of images.",Le,ie,Ge,j,le,tt,ve,Bt=`The bare BiT model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ot,B,de,st,$e,xt='The <a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitModel">BitModel</a> forward method, overrides the <code>__call__</code> special method.',nt,Z,at,k,Se,ce,He,M,me,rt,Te,It=`BiT Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,it,we,jt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,lt,x,pe,dt,Me,zt='The <a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',ct,E,mt,q,Xe,ge,Ve,Ce,Ae;return y=new S({props:{title:"Big Transfer (BiT)",local:"big-transfer-bit",headingTag:"h1"}}),T=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new S({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),D=new S({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new Wt({props:{pipeline:"image-classification"}}),oe=new S({props:{title:"BitConfig",local:"transformers.BitConfig",headingTag:"h2"}}),se=new he({props:{name:"class transformers.BitConfig",anchor:"transformers.BitConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"embedding_size",val:" = 64"},{name:"hidden_sizes",val:" = [256, 512, 1024, 2048]"},{name:"depths",val:" = [3, 4, 6, 3]"},{name:"layer_type",val:" = 'preactivation'"},{name:"hidden_act",val:" = 'relu'"},{name:"global_padding",val:" = None"},{name:"num_groups",val:" = 32"},{name:"drop_path_rate",val:" = 0.0"},{name:"embedding_dynamic_padding",val:" = False"},{name:"output_stride",val:" = 32"},{name:"width_factor",val:" = 1"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.BitConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality (hidden size) for the embedding layer.`,name:"embedding_size"},{anchor:"transformers.BitConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 512, 1024, 2048]</code>) &#x2014;
Dimensionality (hidden size) at each stage.`,name:"hidden_sizes"},{anchor:"transformers.BitConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 4, 6, 3]</code>) &#x2014;
Depth (number of layers) for each stage.`,name:"depths"},{anchor:"transformers.BitConfig.layer_type",description:`<strong>layer_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;preactivation&quot;</code>) &#x2014;
The layer to use, it can be either <code>&quot;preactivation&quot;</code> or <code>&quot;bottleneck&quot;</code>.`,name:"layer_type"},{anchor:"transformers.BitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code>
are supported.`,name:"hidden_act"},{anchor:"transformers.BitConfig.global_padding",description:`<strong>global_padding</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Padding strategy to use for the convolutional layers. Can be either <code>&quot;valid&quot;</code>, <code>&quot;same&quot;</code>, or <code>None</code>.`,name:"global_padding"},{anchor:"transformers.BitConfig.num_groups",description:`<strong>num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of groups used for the <code>BitGroupNormActivation</code> layers.`,name:"num_groups"},{anchor:"transformers.BitConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The drop path rate for the stochastic depth.`,name:"drop_path_rate"},{anchor:"transformers.BitConfig.embedding_dynamic_padding",description:`<strong>embedding_dynamic_padding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to make use of dynamic padding for the embedding layer.`,name:"embedding_dynamic_padding"},{anchor:"transformers.BitConfig.output_stride",description:`<strong>output_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The output stride of the model.`,name:"output_stride"},{anchor:"transformers.BitConfig.width_factor",description:`<strong>width_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The width factor for the model.`,name:"width_factor"},{anchor:"transformers.BitConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.BitConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/configuration_bit.py#L25"}}),N=new pt({props:{anchor:"transformers.BitConfig.example",$$slots:{default:[kt]},$$scope:{ctx:C}}}),ne=new S({props:{title:"BitImageProcessor",local:"transformers.BitImageProcessor",headingTag:"h2"}}),ae=new he({props:{name:"class transformers.BitImageProcessor",anchor:"transformers.BitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.BitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.BitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.BitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.BitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.BitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.BitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.BitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.BitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.BitImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/image_processing_bit.py#L52"}}),re=new he({props:{name:"preprocess",anchor:"transformers.BitImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.BitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.BitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.BitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.BitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.BitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.BitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.BitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.BitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.BitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.BitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.BitImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.BitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.BitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.BitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/image_processing_bit.py#L193"}}),ie=new S({props:{title:"BitModel",local:"transformers.BitModel",headingTag:"h2"}}),le=new he({props:{name:"class transformers.BitModel",anchor:"transformers.BitModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitConfig">BitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27412/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/modeling_bit.py#L693"}}),de=new he({props:{name:"forward",anchor:"transformers.BitModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_27412/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_27412/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">BitImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.BitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27412/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/modeling_bit.py#L715",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitConfig"
>BitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new Ut({props:{$$slots:{default:[Et]},$$scope:{ctx:C}}}),k=new pt({props:{anchor:"transformers.BitModel.forward.example",$$slots:{default:[qt]},$$scope:{ctx:C}}}),ce=new S({props:{title:"BitForImageClassification",local:"transformers.BitForImageClassification",headingTag:"h2"}}),me=new he({props:{name:"class transformers.BitForImageClassification",anchor:"transformers.BitForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitConfig">BitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_27412/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/modeling_bit.py#L753"}}),pe=new he({props:{name:"forward",anchor:"transformers.BitForImageClassification.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BitForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_27412/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_27412/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">BitImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.BitForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27412/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BitForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_27412/src/transformers/models/bit/modeling_bit.py#L773",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27412/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_27412/en/model_doc/bit#transformers.BitConfig"
>BitConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27412/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ut({props:{$$slots:{default:[Lt]},$$scope:{ctx:C}}}),q=new pt({props:{anchor:"transformers.BitForImageClassification.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:C}}}),ge=new Zt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/bit.md"}}),{c(){s=c("meta"),$=r(),l=c("p"),d=r(),g(y.$$.fragment),n=r(),g(T.$$.fragment),xe=r(),H=c("p"),H.innerHTML=ft,Ie=r(),X=c("p"),X.textContent=ht,je=r(),V=c("p"),V.innerHTML=ut,ze=r(),A=c("p"),A.innerHTML=_t,Ue=r(),g(Q.$$.fragment),Pe=r(),Y=c("ul"),Y.innerHTML=bt,Je=r(),g(D.$$.fragment),Fe=r(),O=c("p"),O.textContent=yt,Re=r(),g(K.$$.fragment),Ne=r(),ee=c("ul"),ee.innerHTML=vt,We=r(),te=c("p"),te.textContent=$t,Ze=r(),g(oe.$$.fragment),ke=r(),w=c("div"),g(se.$$.fragment),Qe=r(),ue=c("p"),ue.innerHTML=Tt,Ye=r(),_e=c("p"),_e.innerHTML=wt,De=r(),g(N.$$.fragment),Ee=r(),g(ne.$$.fragment),qe=r(),I=c("div"),g(ae.$$.fragment),Oe=r(),be=c("p"),be.textContent=Mt,Ke=r(),W=c("div"),g(re.$$.fragment),et=r(),ye=c("p"),ye.textContent=Ct,Le=r(),g(ie.$$.fragment),Ge=r(),j=c("div"),g(le.$$.fragment),tt=r(),ve=c("p"),ve.innerHTML=Bt,ot=r(),B=c("div"),g(de.$$.fragment),st=r(),$e=c("p"),$e.innerHTML=xt,nt=r(),g(Z.$$.fragment),at=r(),g(k.$$.fragment),Se=r(),g(ce.$$.fragment),He=r(),M=c("div"),g(me.$$.fragment),rt=r(),Te=c("p"),Te.textContent=It,it=r(),we=c("p"),we.innerHTML=jt,lt=r(),x=c("div"),g(pe.$$.fragment),dt=r(),Me=c("p"),Me.innerHTML=zt,ct=r(),g(E.$$.fragment),mt=r(),g(q.$$.fragment),Xe=r(),g(ge.$$.fragment),Ve=r(),Ce=c("p"),this.h()},l(e){const t=Nt("svelte-u9bgzb",document.head);s=m(t,"META",{name:!0,content:!0}),t.forEach(o),$=i(e),l=m(e,"P",{}),F(l).forEach(o),d=i(e),f(y.$$.fragment,e),n=i(e),f(T.$$.fragment,e),xe=i(e),H=m(e,"P",{"data-svelte-h":!0}),v(H)!=="svelte-2l65fw"&&(H.innerHTML=ft),Ie=i(e),X=m(e,"P",{"data-svelte-h":!0}),v(X)!=="svelte-vfdo9a"&&(X.textContent=ht),je=i(e),V=m(e,"P",{"data-svelte-h":!0}),v(V)!=="svelte-ea79tk"&&(V.innerHTML=ut),ze=i(e),A=m(e,"P",{"data-svelte-h":!0}),v(A)!=="svelte-114mxy8"&&(A.innerHTML=_t),Ue=i(e),f(Q.$$.fragment,e),Pe=i(e),Y=m(e,"UL",{"data-svelte-h":!0}),v(Y)!=="svelte-7gnaj2"&&(Y.innerHTML=bt),Je=i(e),f(D.$$.fragment,e),Fe=i(e),O=m(e,"P",{"data-svelte-h":!0}),v(O)!=="svelte-jm9112"&&(O.textContent=yt),Re=i(e),f(K.$$.fragment,e),Ne=i(e),ee=m(e,"UL",{"data-svelte-h":!0}),v(ee)!=="svelte-31m4ti"&&(ee.innerHTML=vt),We=i(e),te=m(e,"P",{"data-svelte-h":!0}),v(te)!=="svelte-1xesile"&&(te.textContent=$t),Ze=i(e),f(oe.$$.fragment,e),ke=i(e),w=m(e,"DIV",{class:!0});var z=F(w);f(se.$$.fragment,z),Qe=i(z),ue=m(z,"P",{"data-svelte-h":!0}),v(ue)!=="svelte-7jlhns"&&(ue.innerHTML=Tt),Ye=i(z),_e=m(z,"P",{"data-svelte-h":!0}),v(_e)!=="svelte-1ujzu5z"&&(_e.innerHTML=wt),De=i(z),f(N.$$.fragment,z),z.forEach(o),Ee=i(e),f(ne.$$.fragment,e),qe=i(e),I=m(e,"DIV",{class:!0});var P=F(I);f(ae.$$.fragment,P),Oe=i(P),be=m(P,"P",{"data-svelte-h":!0}),v(be)!=="svelte-zncq1j"&&(be.textContent=Mt),Ke=i(P),W=m(P,"DIV",{class:!0});var fe=F(W);f(re.$$.fragment,fe),et=i(fe),ye=m(fe,"P",{"data-svelte-h":!0}),v(ye)!=="svelte-1x3yxsa"&&(ye.textContent=Ct),fe.forEach(o),P.forEach(o),Le=i(e),f(ie.$$.fragment,e),Ge=i(e),j=m(e,"DIV",{class:!0});var J=F(j);f(le.$$.fragment,J),tt=i(J),ve=m(J,"P",{"data-svelte-h":!0}),v(ve)!=="svelte-1fxsgvt"&&(ve.innerHTML=Bt),ot=i(J),B=m(J,"DIV",{class:!0});var U=F(B);f(de.$$.fragment,U),st=i(U),$e=m(U,"P",{"data-svelte-h":!0}),v($e)!=="svelte-101d8oi"&&($e.innerHTML=xt),nt=i(U),f(Z.$$.fragment,U),at=i(U),f(k.$$.fragment,U),U.forEach(o),J.forEach(o),Se=i(e),f(ce.$$.fragment,e),He=i(e),M=m(e,"DIV",{class:!0});var L=F(M);f(me.$$.fragment,L),rt=i(L),Te=m(L,"P",{"data-svelte-h":!0}),v(Te)!=="svelte-a01xtz"&&(Te.textContent=It),it=i(L),we=m(L,"P",{"data-svelte-h":!0}),v(we)!=="svelte-1gjh92c"&&(we.innerHTML=jt),lt=i(L),x=m(L,"DIV",{class:!0});var G=F(x);f(pe.$$.fragment,G),dt=i(G),Me=m(G,"P",{"data-svelte-h":!0}),v(Me)!=="svelte-7dk8qa"&&(Me.innerHTML=zt),ct=i(G),f(E.$$.fragment,G),mt=i(G),f(q.$$.fragment,G),G.forEach(o),L.forEach(o),Xe=i(e),f(ge.$$.fragment,e),Ve=i(e),Ce=m(e,"P",{}),F(Ce).forEach(o),this.h()},h(){R(s,"name","hf:doc:metadata"),R(s,"content",Ht),R(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,s),a(e,$,t),a(e,l,t),a(e,d,t),h(y,e,t),a(e,n,t),h(T,e,t),a(e,xe,t),a(e,H,t),a(e,Ie,t),a(e,X,t),a(e,je,t),a(e,V,t),a(e,ze,t),a(e,A,t),a(e,Ue,t),h(Q,e,t),a(e,Pe,t),a(e,Y,t),a(e,Je,t),h(D,e,t),a(e,Fe,t),a(e,O,t),a(e,Re,t),h(K,e,t),a(e,Ne,t),a(e,ee,t),a(e,We,t),a(e,te,t),a(e,Ze,t),h(oe,e,t),a(e,ke,t),a(e,w,t),h(se,w,null),p(w,Qe),p(w,ue),p(w,Ye),p(w,_e),p(w,De),h(N,w,null),a(e,Ee,t),h(ne,e,t),a(e,qe,t),a(e,I,t),h(ae,I,null),p(I,Oe),p(I,be),p(I,Ke),p(I,W),h(re,W,null),p(W,et),p(W,ye),a(e,Le,t),h(ie,e,t),a(e,Ge,t),a(e,j,t),h(le,j,null),p(j,tt),p(j,ve),p(j,ot),p(j,B),h(de,B,null),p(B,st),p(B,$e),p(B,nt),h(Z,B,null),p(B,at),h(k,B,null),a(e,Se,t),h(ce,e,t),a(e,He,t),a(e,M,t),h(me,M,null),p(M,rt),p(M,Te),p(M,it),p(M,we),p(M,lt),p(M,x),h(pe,x,null),p(x,dt),p(x,Me),p(x,ct),h(E,x,null),p(x,mt),h(q,x,null),a(e,Xe,t),h(ge,e,t),a(e,Ve,t),a(e,Ce,t),Ae=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),N.$set(z);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),Z.$set(P);const fe={};t&2&&(fe.$$scope={dirty:t,ctx:e}),k.$set(fe);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),E.$set(J);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),q.$set(U)},i(e){Ae||(u(y.$$.fragment,e),u(T.$$.fragment,e),u(Q.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(N.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(ge.$$.fragment,e),Ae=!0)},o(e){_(y.$$.fragment,e),_(T.$$.fragment,e),_(Q.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(N.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(Z.$$.fragment,e),_(k.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(E.$$.fragment,e),_(q.$$.fragment,e),_(ge.$$.fragment,e),Ae=!1},d(e){e&&(o($),o(l),o(d),o(n),o(xe),o(H),o(Ie),o(X),o(je),o(V),o(ze),o(A),o(Ue),o(Pe),o(Y),o(Je),o(Fe),o(O),o(Re),o(Ne),o(ee),o(We),o(te),o(Ze),o(ke),o(w),o(Ee),o(qe),o(I),o(Le),o(Ge),o(j),o(Se),o(He),o(M),o(Xe),o(Ve),o(Ce)),o(s),b(y,e),b(T,e),b(Q,e),b(D,e),b(K,e),b(oe,e),b(se),b(N),b(ne,e),b(ae),b(re),b(ie,e),b(le),b(de),b(Z),b(k),b(ce,e),b(me),b(pe),b(E),b(q),b(ge,e)}}}const Ht='{"title":"Big Transfer (BiT)","local":"big-transfer-bit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BitConfig","local":"transformers.BitConfig","sections":[],"depth":2},{"title":"BitImageProcessor","local":"transformers.BitImageProcessor","sections":[],"depth":2},{"title":"BitModel","local":"transformers.BitModel","sections":[],"depth":2},{"title":"BitForImageClassification","local":"transformers.BitForImageClassification","sections":[],"depth":2}],"depth":1}';function Xt(C){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class to extends Ft{constructor(s){super(),Rt(this,s,Xt,St,Pt,{})}}export{to as component};
