import{s as se,f as Ul,n as ne,o as ae}from"../chunks/scheduler.f6b352c8.js";import{S as Me,i as ie,g as M,s as n,r as y,A as oe,h as i,f as e,c as a,j as wl,u as m,x as o,k as r,y as pe,a as s,v as c,d as j,t as u,w as U}from"../chunks/index.7f38e934.js";import{C as jt}from"../chunks/CodeBlock.2a338b68.js";import{H as ut}from"../chunks/Heading.333929c4.js";import{E as re}from"../chunks/EditOnGithub.c3245a01.js";function ye(hl){let w,Ut,mt,wt,h,ht,d,dl="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",dt,b,bl="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more !",bt,T,Tl="You will also publish you argent <strong>on a Hugging Face Spaces so you can share it with friends and colleagues</strong>.",Tt,J,Jl="Let’s get started!",Jt,C,Ct,g,Cl,gt,f,gl="To make this Agent, we’re going to use a library called <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",ft,v,fl="This lightweight library abstracts away much of the complexity of building an Agent we saw in the last section, allowing you to focus on designing your agent’s behavior.",vt,Z,vl='We’re going to get deeper into SmolAgents in the next Unit, but if you’re interested you can check this <a href="https://huggingface.co/blog/smolagents" rel="nofollow">blog</a>.',Zt,A,Zl="In short, SmolAgents is a library that focuses on <strong>codeAgent</strong>, a kind of agent that perform <strong>“Action”</strong> throught code blocks and then <strong>“Observe”</strong> the result by executing that code.",At,I,Al="Here is an example of what we’ll build !",It,B,Il="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",Bt,W,Bl="The agent inside smolagents is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer :",Wt,p,Wl,Et,E,El="Exciting right ?",Gt,G,Ht,H,Gl='To start, duplicate this space : <a href="https://huggingface.co/spaces/agents-course/First_agent_template" rel="nofollow">https://huggingface.co/spaces/agents-course/First_agent_template</a>',kt,k,Hl='<p>Thanks to <a href="https://huggingface.co/spaces/m-ric/agent" rel="nofollow">Aymeric</a> for this template!</p>',xt,x,kl="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",Qt,Q,xl,_t,_,Ql="Throughtout this lesson, the only file you will need to modify is the currently incomplete ”<strong>app.py</strong>”",Rt,R,_l="Let’s break it down together:",St,S,Rl="<li>Here are some simple but necessary library imports</li>",zt,z,Xt,X,Sl="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Nt,N,Vt,V,zl="Now let’s get into the tools ! If you want a refresher about tools, don’t hesitate to go back to the Tool section of the course.",Ft,F,$t,$,Xl="The Tools are what we are encouraging you to build in this section! We give you two examples:",Yt,Y,Nl="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",Lt,L,Vl="To define your tool it is important to :",qt,q,Fl="<li>Provide input and output types for your function here <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",Pt,P,Kt,K,Dt,D,$l="This Agent still use the <code>InferenceClient</code> we saw in earlier lessons behind this <strong>HfApiModel</strong> class !",Ot,O,Yl="We will give more in-depth examples when we will present the framework in Unit 2, but the import here is <strong>to add the list of tools</strong> to the the <strong>tools</strong> parameter of your Agent.",tl,tt,ll,lt,Ll="<strong>Adding or removing some tools will get your agent new capacities</strong>, hence be creative here !",el,et,ql="The complete “app.py” :",sl,st,nl,nt,Pl="Your <strong>Objective</strong> is now to get familiar with the Space and the Agent.",al,at,Kl="Currently the agent in the template <strong>does not have tools loaded, so try to provide it some of the pre-made ones or even make some new tools yourselves</strong>!",Ml,Mt,Dl="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong> !",il,ol,pl,it,Ol="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",rl,ot,te="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",yl,pt,le="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model etc.",ml,rt,ee="In the next section, you’re going to fill the final Quiz and get your certificate!",cl,yt,jl,ct,ul;return h=new ut({props:{title:"Let’s Create Our First Agent Using Smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),C=new ut({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),G=new ut({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),z=new jt({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkNEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkNsb2FkX3Rvb2wlMkN0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent,DuckDuckGoSearchTool, HfApiModel,load_tool,tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),N=new ut({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),F=new jt({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment">#it&#x27;s import to specify the return type</span>
    <span class="hljs-comment">#Keep this format for the description / args / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),P=new ut({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),K=new jt({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBbWF4X3Rva2VucyUzRDIwOTYlMkMlMEF0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQW1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEFjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsJTIwYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment">## add your tools here (don&#x27;t remove final answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),tt=new jt({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkNEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkNsb2FkX3Rvb2wlMkN0b29sJTIw",highlighted:'<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent,DuckDuckGoSearchTool, HfApiModel,load_tool,tool ',wrap:!1}}),st=new jt({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkNEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkNsb2FkX3Rvb2wlMkN0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbCUwQSUwQWZyb20lMjBHcmFkaW9fVUklMjBpbXBvcnQlMjBHcmFkaW9VSSUwQSUwQSUyMyUyMEJlbG93JTIwaXMlMjBhbiUyMGV4YW1wbGUlMjBvZiUyMGElMjB0b29sJTIwdGhhdCUyMGRvZXMlMjBub3RoaW5nLiUyMEFtYXplJTIwdXMlMjB3aXRoJTIweW91ciUyMGNyZWF0aXZpdHklMjAhJTBBJTQwdG9vbCUwQWRlZiUyMG15X2N1c3RvbV90b29sKGFyZzElM0FzdHIlMkMlMjBhcmcyJTNBaW50KS0lM0UlMjBzdHIlM0ElMjAlMjNpdCdzJTIwaW1wb3J0JTIwdG8lMjBzcGVjaWZ5JTIwdGhlJTIwcmV0dXJuJTIwdHlwZSUwQSUyMCUyMCUyMCUyMCUyM0tlZXAlMjB0aGlzJTIwZm9ybWF0JTIwZm9yJTIwdGhlJTIwZGVzY3JpcHRpb24lMjAlMkYlMjBhcmdzJTIwJTJGJTIwYXJncyUyMGRlc2NyaXB0aW9uJTIwYnV0JTIwZmVlbCUyMGZyZWUlMjB0byUyMG1vZGlmeSUyMHRoZSUyMHRvb2wlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBJTIwdG9vbCUyMHRoYXQlMjBkb2VzJTIwbm90aGluZyUyMHlldCUyMCUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmcxJTNBJTIwdGhlJTIwZmlyc3QlMjBhcmd1bWVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZzIlM0ElMjB0aGUlMjBzZWNvbmQlMjBhcmd1bWVudCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMldoYXQlMjBtYWdpYyUyMHdpbGwlMjB5b3UlMjBidWlsZCUyMCUzRiUyMiUwQSUwQSU0MHRvb2wlMEFkZWYlMjBnZXRfY3VycmVudF90aW1lX2luX3RpbWV6b25lKHRpbWV6b25lJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBJTIwdG9vbCUyMHRoYXQlMjBmZXRjaGVzJTIwdGhlJTIwY3VycmVudCUyMGxvY2FsJTIwdGltZSUyMGluJTIwYSUyMHNwZWNpZmllZCUyMHRpbWV6b25lLiUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aW1lem9uZSUzQSUyMEElMjBzdHJpbmclMjByZXByZXNlbnRpbmclMjBhJTIwdmFsaWQlMjB0aW1lem9uZSUyMChlLmcuJTJDJTIwJ0FtZXJpY2ElMkZOZXdfWW9yaycpLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMHRpbWV6b25lJTIwb2JqZWN0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHolMjAlM0QlMjBweXR6LnRpbWV6b25lKHRpbWV6b25lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMGN1cnJlbnQlMjB0aW1lJTIwaW4lMjB0aGF0JTIwdGltZXpvbmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhbF90aW1lJTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KHR6KS5zdHJmdGltZSglMjIlMjVZLSUyNW0tJTI1ZCUyMCUyNUglM0ElMjVNJTNBJTI1UyUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyVGhlJTIwY3VycmVudCUyMGxvY2FsJTIwdGltZSUyMGluJTIwJTdCdGltZXpvbmUlN0QlMjBpcyUzQSUyMCU3QmxvY2FsX3RpbWUlN0QlMjIlMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlMjBmZXRjaGluZyUyMHRpbWUlMjBmb3IlMjB0aW1lem9uZSUyMCclN0J0aW1lem9uZSU3RCclM0ElMjAlN0JzdHIoZSklN0QlMjIlMEElMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBGaW5hbEFuc3dlclRvb2woKSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCglMEFtYXhfdG9rZW5zJTNEMjA5NiUyQyUwQXRlbXBlcmF0dXJlJTNEMC41JTJDJTBBbW9kZWxfaWQlM0QnUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JyUyQyUwQWN1c3RvbV9yb2xlX2NvbnZlcnNpb25zJTNETm9uZSUyQyUwQSklMEElMEElMEElMjMlMjBJbXBvcnQlMjB0b29sJTIwZnJvbSUyMEh1YiUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMjJhZ2VudHMtY291cnNlJTJGdGV4dC10by1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEElMEF3aXRoJTIwb3BlbiglMjJwcm9tcHRzLnlhbWwlMjIlMkMlMjAncicpJTIwYXMlMjBzdHJlYW0lM0ElMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTIwJTNEJTIweWFtbC5zYWZlX2xvYWQoc3RyZWFtKSUwQSUyMCUyMCUyMCUyMCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMyUyMyUyMGFkZCUyMHlvdXIlMjB0b29scyUyMGhlcmUlMjAoZG9uJ3QlMjByZW1vdmUlMjBmaW5hbCUyMGFuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent,DuckDuckGoSearchTool, HfApiModel,load_tool,tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment">#it&#x27;s import to specify the return type</span>
    <span class="hljs-comment">#Keep this format for the description / args / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment">## add your tools here (don&#x27;t remove final answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),yt=new re({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){w=M("meta"),Ut=n(),mt=M("p"),wt=n(),y(h.$$.fragment),ht=n(),d=M("p"),d.innerHTML=dl,dt=n(),b=M("p"),b.innerHTML=bl,bt=n(),T=M("p"),T.innerHTML=Tl,Tt=n(),J=M("p"),J.textContent=Jl,Jt=n(),y(C.$$.fragment),Ct=n(),g=M("img"),gt=n(),f=M("p"),f.innerHTML=gl,ft=n(),v=M("p"),v.textContent=fl,vt=n(),Z=M("p"),Z.innerHTML=vl,Zt=n(),A=M("p"),A.innerHTML=Zl,At=n(),I=M("p"),I.textContent=Al,It=n(),B=M("p"),B.innerHTML=Il,Bt=n(),W=M("p"),W.innerHTML=Bl,Wt=n(),p=M("iframe"),Et=n(),E=M("p"),E.textContent=El,Gt=n(),y(G.$$.fragment),Ht=n(),H=M("p"),H.innerHTML=Gl,kt=n(),k=M("blockquote"),k.innerHTML=Hl,xt=n(),x=M("p"),x.innerHTML=kl,Qt=n(),Q=M("img"),_t=n(),_=M("p"),_.innerHTML=Ql,Rt=n(),R=M("p"),R.textContent=_l,St=n(),S=M("ul"),S.innerHTML=Rl,zt=n(),y(z.$$.fragment),Xt=n(),X=M("p"),X.innerHTML=Sl,Nt=n(),y(N.$$.fragment),Vt=n(),V=M("p"),V.textContent=zl,Ft=n(),y(F.$$.fragment),$t=n(),$=M("p"),$.textContent=Xl,Yt=n(),Y=M("ol"),Y.innerHTML=Nl,Lt=n(),L=M("p"),L.textContent=Vl,qt=n(),q=M("ol"),q.innerHTML=Fl,Pt=n(),y(P.$$.fragment),Kt=n(),y(K.$$.fragment),Dt=n(),D=M("p"),D.innerHTML=$l,Ot=n(),O=M("p"),O.innerHTML=Yl,tl=n(),y(tt.$$.fragment),ll=n(),lt=M("p"),lt.innerHTML=Ll,el=n(),et=M("p"),et.textContent=ql,sl=n(),y(st.$$.fragment),nl=n(),nt=M("p"),nt.innerHTML=Pl,al=n(),at=M("p"),at.innerHTML=Kl,Ml=n(),Mt=M("p"),Mt.innerHTML=Dl,il=n(),ol=M("hr"),pl=n(),it=M("p"),it.textContent=Ol,rl=n(),ot=M("p"),ot.textContent=te,yl=n(),pt=M("p"),pt.textContent=le,ml=n(),rt=M("p"),rt.textContent=ee,cl=n(),y(yt.$$.fragment),jl=n(),ct=M("p"),this.h()},l(t){const l=oe("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(e),Ut=a(t),mt=i(t,"P",{}),wl(mt).forEach(e),wt=a(t),m(h.$$.fragment,t),ht=a(t),d=i(t,"P",{"data-svelte-h":!0}),o(d)!=="svelte-gmmoh4"&&(d.innerHTML=dl),dt=a(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1chdxkk"&&(b.innerHTML=bl),bt=a(t),T=i(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1l7if5e"&&(T.innerHTML=Tl),Tt=a(t),J=i(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-4b3xjd"&&(J.textContent=Jl),Jt=a(t),m(C.$$.fragment,t),Ct=a(t),g=i(t,"IMG",{src:!0,alt:!0}),gt=a(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-xkn4l5"&&(f.innerHTML=gl),ft=a(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1x2xqyg"&&(v.textContent=fl),vt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-z7gkwa"&&(Z.innerHTML=vl),Zt=a(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-16f0j5z"&&(A.innerHTML=Zl),At=a(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1bdn3zi"&&(I.textContent=Al),It=a(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1kwa3nr"&&(B.innerHTML=Il),Bt=a(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1lszyrr"&&(W.innerHTML=Bl),Wt=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),wl(p).forEach(e),Et=a(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-e1p5jm"&&(E.textContent=El),Gt=a(t),m(G.$$.fragment,t),Ht=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1hvefb7"&&(H.innerHTML=Gl),kt=a(t),k=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(k)!=="svelte-1gaz95e"&&(k.innerHTML=Hl),xt=a(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-xpoxi8"&&(x.innerHTML=kl),Qt=a(t),Q=i(t,"IMG",{src:!0,alt:!0}),_t=a(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-yl9rb2"&&(_.innerHTML=Ql),Rt=a(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-e2l5fd"&&(R.textContent=_l),St=a(t),S=i(t,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-averza"&&(S.innerHTML=Rl),zt=a(t),m(z.$$.fragment,t),Xt=a(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-eq9rdr"&&(X.innerHTML=Sl),Nt=a(t),m(N.$$.fragment,t),Vt=a(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-wsijq4"&&(V.textContent=zl),Ft=a(t),m(F.$$.fragment,t),$t=a(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-qrpozm"&&($.textContent=Xl),Yt=a(t),Y=i(t,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-12muy28"&&(Y.innerHTML=Nl),Lt=a(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-32cy6b"&&(L.textContent=Vl),qt=a(t),q=i(t,"OL",{"data-svelte-h":!0}),o(q)!=="svelte-1hsnp3"&&(q.innerHTML=Fl),Pt=a(t),m(P.$$.fragment,t),Kt=a(t),m(K.$$.fragment,t),Dt=a(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-9wldmw"&&(D.innerHTML=$l),Ot=a(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1gvbsrx"&&(O.innerHTML=Yl),tl=a(t),m(tt.$$.fragment,t),ll=a(t),lt=i(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-p75tc3"&&(lt.innerHTML=Ll),el=a(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-cl26yj"&&(et.textContent=ql),sl=a(t),m(st.$$.fragment,t),nl=a(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1g57zf3"&&(nt.innerHTML=Pl),al=a(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-pmskmd"&&(at.innerHTML=Kl),Ml=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1sh5zm4"&&(Mt.innerHTML=Dl),il=a(t),ol=i(t,"HR",{}),pl=a(t),it=i(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1vcdjz4"&&(it.textContent=Ol),rl=a(t),ot=i(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-10mjkny"&&(ot.textContent=te),yl=a(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-19g8fwd"&&(pt.textContent=le),ml=a(t),rt=i(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1s9m3df"&&(rt.textContent=ee),cl=a(t),m(yt.$$.fragment,t),jl=a(t),ct=i(t,"P",{}),wl(ct).forEach(e),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",me),Ul(g.src,Cl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(g,"src",Cl),r(g,"alt","Smolagents"),r(p,"width","560"),r(p,"height","315"),Ul(p.src,Wl="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",Wl),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",Ul(Q.src,xl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(Q,"src",xl),r(Q,"alt","Duplicate")},m(t,l){pe(document.head,w),s(t,Ut,l),s(t,mt,l),s(t,wt,l),c(h,t,l),s(t,ht,l),s(t,d,l),s(t,dt,l),s(t,b,l),s(t,bt,l),s(t,T,l),s(t,Tt,l),s(t,J,l),s(t,Jt,l),c(C,t,l),s(t,Ct,l),s(t,g,l),s(t,gt,l),s(t,f,l),s(t,ft,l),s(t,v,l),s(t,vt,l),s(t,Z,l),s(t,Zt,l),s(t,A,l),s(t,At,l),s(t,I,l),s(t,It,l),s(t,B,l),s(t,Bt,l),s(t,W,l),s(t,Wt,l),s(t,p,l),s(t,Et,l),s(t,E,l),s(t,Gt,l),c(G,t,l),s(t,Ht,l),s(t,H,l),s(t,kt,l),s(t,k,l),s(t,xt,l),s(t,x,l),s(t,Qt,l),s(t,Q,l),s(t,_t,l),s(t,_,l),s(t,Rt,l),s(t,R,l),s(t,St,l),s(t,S,l),s(t,zt,l),c(z,t,l),s(t,Xt,l),s(t,X,l),s(t,Nt,l),c(N,t,l),s(t,Vt,l),s(t,V,l),s(t,Ft,l),c(F,t,l),s(t,$t,l),s(t,$,l),s(t,Yt,l),s(t,Y,l),s(t,Lt,l),s(t,L,l),s(t,qt,l),s(t,q,l),s(t,Pt,l),c(P,t,l),s(t,Kt,l),c(K,t,l),s(t,Dt,l),s(t,D,l),s(t,Ot,l),s(t,O,l),s(t,tl,l),c(tt,t,l),s(t,ll,l),s(t,lt,l),s(t,el,l),s(t,et,l),s(t,sl,l),c(st,t,l),s(t,nl,l),s(t,nt,l),s(t,al,l),s(t,at,l),s(t,Ml,l),s(t,Mt,l),s(t,il,l),s(t,ol,l),s(t,pl,l),s(t,it,l),s(t,rl,l),s(t,ot,l),s(t,yl,l),s(t,pt,l),s(t,ml,l),s(t,rt,l),s(t,cl,l),c(yt,t,l),s(t,jl,l),s(t,ct,l),ul=!0},p:ne,i(t){ul||(j(h.$$.fragment,t),j(C.$$.fragment,t),j(G.$$.fragment,t),j(z.$$.fragment,t),j(N.$$.fragment,t),j(F.$$.fragment,t),j(P.$$.fragment,t),j(K.$$.fragment,t),j(tt.$$.fragment,t),j(st.$$.fragment,t),j(yt.$$.fragment,t),ul=!0)},o(t){u(h.$$.fragment,t),u(C.$$.fragment,t),u(G.$$.fragment,t),u(z.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(st.$$.fragment,t),u(yt.$$.fragment,t),ul=!1},d(t){t&&(e(Ut),e(mt),e(wt),e(ht),e(d),e(dt),e(b),e(bt),e(T),e(Tt),e(J),e(Jt),e(Ct),e(g),e(gt),e(f),e(ft),e(v),e(vt),e(Z),e(Zt),e(A),e(At),e(I),e(It),e(B),e(Bt),e(W),e(Wt),e(p),e(Et),e(E),e(Gt),e(Ht),e(H),e(kt),e(k),e(xt),e(x),e(Qt),e(Q),e(_t),e(_),e(Rt),e(R),e(St),e(S),e(zt),e(Xt),e(X),e(Nt),e(Vt),e(V),e(Ft),e($t),e($),e(Yt),e(Y),e(Lt),e(L),e(qt),e(q),e(Pt),e(Kt),e(Dt),e(D),e(Ot),e(O),e(tl),e(ll),e(lt),e(el),e(et),e(sl),e(nl),e(nt),e(al),e(at),e(Ml),e(Mt),e(il),e(ol),e(pl),e(it),e(rl),e(ot),e(yl),e(pt),e(ml),e(rt),e(cl),e(jl),e(ct)),e(w),U(h,t),U(C,t),U(G,t),U(z,t),U(N,t),U(F,t),U(P,t),U(K,t),U(tt,t),U(st,t),U(yt,t)}}}const me='{"title":"Let’s Create Our First Agent Using Smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3}],"depth":2}],"depth":1}';function ce(hl){return ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class de extends Me{constructor(w){super(),ie(this,w,ce,ye,se,{})}}export{de as component};
