import{s as Ws,f as Rs,n as As,o as Fs}from"../chunks/scheduler.f6b352c8.js";import{S as Vs,i as Qs,g as i,s as n,r as h,A as Ls,h as p,f as s,c as a,j as Oe,u,x as o,k as ze,y as De,a as l,v as r,d as c,t as M,w}from"../chunks/index.7f38e934.js";import{C as y}from"../chunks/CodeBlock.2a338b68.js";import{H as Ke}from"../chunks/Heading.333929c4.js";import{E as Ss}from"../chunks/EditOnGithub.c3245a01.js";function Hs(ts){let j,vt,Ct,xt,d,Xt,T,es,Zt,J,ss="This course is framework agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",qt,f,ls="Also, we want students to be able to use the concepts they learn in this course in their own projects, in any framework.",Yt,b,ns="Therefore, for this Unit 1, we will use a dummy agent library and simple severless API, which will be our LLM engine.",Nt,g,as="In reality, you would not use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",Et,U,is="But, after this section, you’ll <strong>create a simple Agent</strong> using <code>smolagents</code>",Wt,B,ps="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Rt,$,os="To keep things simple we will use a simple Python function as a Tool and Agent.",At,I,hs="We will use built in python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Ft,_,us='You can find the notebook <a href="https://colab.research.google.com/drive/1MmVo8V9bLkgcVA1RB5LZtX_lO8y_HBxm?usp=sharing" rel="nofollow">here</a>. If you <strong>want to run the code</strong>.',Vt,k,Qt,C,rs="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to test some models. This uses shared endpoints between multiple users to compute some requests. This is convenient to test some models.",Lt,G,St,v,Ht,x,cs="output:",zt,X,Pt,Z,Ms="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong> and this does not happen here because <strong>we forgot to add the special tokens of this model</strong>.",Ot,q,ws='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and now produces the expected EOS.',Dt,Y,Kt,N,ys="output:",te,E,ee,W,js="Manually adding special tokens is equivalent to using the “chat” method:",se,R,le,A,ms="output:",ne,F,ae,V,ds="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models but since this notebook is only educationnal, we will keep using the “text_generation” method to understand the details.",ie,Q,pe,L,Ts="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",oe,S,Js="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",he,H,fs="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",ue,z,re,P,bs="Since we are running the “text_generation”, we need to add the right special tokens.",ce,O,Me,D,gs="This is equivalent to the following code that happens inside the chat method :",we,K,ye,tt,Us="The prompt now is :",je,et,me,st,Bs="Let’s decode!",de,lt,Te,nt,$s="output:",Je,at,fe,it,Is=`{
“action”: “get_weather”,
“action”: {“location”: “London”}
}`,be,pt,ge,ot,_s="Do you see the issue?",Ue,m,kt,ks=`The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Obersavation” so that we don’t hallucinate the actual function response`,Pe,ht,Be,ut,Cs="print(output)",$e,rt,Ie,ct,Gs="Action:",_e,Mt,ke,wt,vs=`Thought: I will check the weather in London.
Observation:`,Ce,yt,Ge,jt,xs="output:",ve,mt,xe,dt,Xs="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume the generation.",Xe,Tt,Ze,Jt,Zs="Here is the new prompt:",qe,ft,Ye,bt,qs=`{
“action”: “get_weather”,
“action”: {“location”: {“type”: “string”, “value”: “London”}
}`,Ne,gt,Ee,Ut,Ys="output:",We,Bt,Re,Ae,Fe,$t,Ns="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",Ve,It,Es="Now, we’re ready <strong>to create our first real Agent</strong> using <code>smolagents</code> library.",Qe,_t,Le,Gt,Se;return d=new Ke({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),k=new Ke({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),G=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyQyUyMHRoaXMlMjBjYW4lMjBiZSUyMHNldCUyMGluJTIwdGhlJTIwJTIyc2V0dGluZ3MlMjIlMjB0YWIlMjB1bmRlciUyMCUyMnNlY3JldCUyMi4lMjBNYWtlJTIwc3VyZSUyMHRvJTIwY2FsbCUyMGl0JTIwJTIySEZfVE9LRU4lMjIlMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlM0QlMjJoZl94eHh4eHh4eHh4eHh4eCUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTNCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token, this can be set in the &quot;settings&quot; tab under &quot;secret&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)`,wrap:!1}}),v=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBmcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of france is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new y({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Y=new y({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwZnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of france is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),E=new y({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),R=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwZnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKQ==",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of france is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)`,wrap:!1}}),F=new y({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),Q=new Ke({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),z=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have a \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> a \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

Youb must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new y({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new y({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),et=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

Youb must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new y({props:{code:"QWN0aW9uJTNB",highlighted:'<span class="hljs-symbol">Action:</span>',wrap:!1}}),pt=new y({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0ElMjBUaGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwaXMlMjBtb3N0bHklMjBjbG91ZHklMjB3aXRoJTIwYSUyMGhpZ2glMjBvZiUyMDEyJUMyJUIwQyUyMGFuZCUyMGElMjBsb3clMjBvZiUyMDglQzIlQjBDLg==",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ht=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),rt=new y({props:{code:"b3V0cHV0JTNB",highlighted:'<span class="hljs-symbol">output:</span>',wrap:!1}}),Mt=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;London&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),yt=new y({props:{code:"TXVjaCUyMEJldHRlciElMjAlMEFMZXQncyUyMG5vdyUyMGNyZWF0ZSUyMGElMjBkdW1teSUyMGdldCUyMHdlYXRoZXIlMjBmdW5jdGlvbi4lMjAlMjBJbiUyMGElMjByZWFsJTIwc2l0dWF0aW9uJTJDJTIweW91JTIwY291bGQlMjBjYWxsJTIwYW5kJTIwQVBJLiUwQSUwQSU2MCU2MCU2MHB5dGhvbiUwQSUyM0R1bW15JTIwZnVuY3Rpb24lMEFkZWYlMjBnZXRfd2VhdGhlcihsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIydGhlJTIwd2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4lMjAlNUNuJTIyJTBBJTBBZ2V0X3dlYXRoZXIoJ0xvbmRvbicp",highlighted:`Much Better! 
<span class="hljs-keyword">Let</span><span class="hljs-comment">&#x27;s now create a dummy get weather function.  In a real situation, you could call and API.</span>

\`\`\`python
#Dummy <span class="hljs-keyword">function</span>
def get_weather(location):
    <span class="hljs-keyword">return</span> f<span class="hljs-string">&quot;the weather in {location} is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-comment">&#x27;London&#x27;)</span>`,wrap:!1}}),mt=new y({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),Tt=new y({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),ft=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

Youb must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:`,wrap:!1}}),gt=new y({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0F0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4lMjA=",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation:the weather in London is sunny with low temperatures. `,wrap:!1}}),Bt=new y({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),_t=new Ss({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),vt=n(),Ct=i("p"),xt=n(),h(d.$$.fragment),Xt=n(),T=i("img"),Zt=n(),J=i("p"),J.innerHTML=ss,qt=n(),f=i("p"),f.textContent=ls,Yt=n(),b=i("p"),b.textContent=ns,Nt=n(),g=i("p"),g.innerHTML=as,Et=n(),U=i("p"),U.innerHTML=is,Wt=n(),B=i("p"),B.innerHTML=ps,Rt=n(),$=i("p"),$.textContent=os,At=n(),I=i("p"),I.innerHTML=hs,Ft=n(),_=i("p"),_.innerHTML=us,Vt=n(),h(k.$$.fragment),Qt=n(),C=i("p"),C.textContent=rs,Lt=n(),h(G.$$.fragment),St=n(),h(v.$$.fragment),Ht=n(),x=i("p"),x.textContent=cs,zt=n(),h(X.$$.fragment),Pt=n(),Z=i("p"),Z.innerHTML=Ms,Ot=n(),q=i("p"),q.innerHTML=ws,Dt=n(),h(Y.$$.fragment),Kt=n(),N=i("p"),N.textContent=ys,te=n(),h(E.$$.fragment),ee=n(),W=i("p"),W.textContent=js,se=n(),h(R.$$.fragment),le=n(),A=i("p"),A.textContent=ms,ne=n(),h(F.$$.fragment),ae=n(),V=i("p"),V.textContent=ds,ie=n(),h(Q.$$.fragment),pe=n(),L=i("p"),L.textContent=Ts,oe=n(),S=i("p"),S.textContent=Js,he=n(),H=i("ol"),H.innerHTML=fs,ue=n(),h(z.$$.fragment),re=n(),P=i("p"),P.textContent=bs,ce=n(),h(O.$$.fragment),Me=n(),D=i("p"),D.textContent=gs,we=n(),h(K.$$.fragment),ye=n(),tt=i("p"),tt.textContent=Us,je=n(),h(et.$$.fragment),me=n(),st=i("p"),st.textContent=Bs,de=n(),h(lt.$$.fragment),Te=n(),nt=i("p"),nt.textContent=$s,Je=n(),h(at.$$.fragment),fe=n(),it=i("p"),it.textContent=Is,be=n(),h(pt.$$.fragment),ge=n(),ot=i("p"),ot.textContent=_s,Ue=n(),m=i("blockquote"),kt=i("p"),kt.textContent=ks,Pe=n(),h(ht.$$.fragment),Be=n(),ut=i("p"),ut.textContent=Cs,$e=n(),h(rt.$$.fragment),Ie=n(),ct=i("p"),ct.textContent=Gs,_e=n(),h(Mt.$$.fragment),ke=n(),wt=i("p"),wt.textContent=vs,Ce=n(),h(yt.$$.fragment),Ge=n(),jt=i("p"),jt.textContent=xs,ve=n(),h(mt.$$.fragment),xe=n(),dt=i("p"),dt.textContent=Xs,Xe=n(),h(Tt.$$.fragment),Ze=n(),Jt=i("p"),Jt.textContent=Zs,qe=n(),h(ft.$$.fragment),Ye=n(),bt=i("p"),bt.textContent=qs,Ne=n(),h(gt.$$.fragment),Ee=n(),Ut=i("p"),Ut.textContent=Ys,We=n(),h(Bt.$$.fragment),Re=n(),Ae=i("hr"),Fe=n(),$t=i("p"),$t.innerHTML=Ns,Ve=n(),It=i("p"),It.innerHTML=Es,Qe=n(),h(_t.$$.fragment),Le=n(),Gt=i("p"),this.h()},l(t){const e=Ls("svelte-u9bgzb",document.head);j=p(e,"META",{name:!0,content:!0}),e.forEach(s),vt=a(t),Ct=p(t,"P",{}),Oe(Ct).forEach(s),xt=a(t),u(d.$$.fragment,t),Xt=a(t),T=p(t,"IMG",{src:!0,alt:!0}),Zt=a(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-8i1n71"&&(J.innerHTML=ss),qt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1pws4bx"&&(f.textContent=ls),Yt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ojgbiq"&&(b.textContent=ns),Nt=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-10n19id"&&(g.innerHTML=as),Et=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1oqu5up"&&(U.innerHTML=is),Wt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9snja6"&&(B.innerHTML=ps),Rt=a(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-scmak8"&&($.textContent=os),At=a(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-lkrnwe"&&(I.innerHTML=hs),Ft=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1iabpjr"&&(_.innerHTML=us),Vt=a(t),u(k.$$.fragment,t),Qt=a(t),C=p(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-wxu6gb"&&(C.textContent=rs),Lt=a(t),u(G.$$.fragment,t),St=a(t),u(v.$$.fragment,t),Ht=a(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wueeet"&&(x.textContent=cs),zt=a(t),u(X.$$.fragment,t),Pt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-zazh8y"&&(Z.innerHTML=Ms),Ot=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-16kvwh4"&&(q.innerHTML=ws),Dt=a(t),u(Y.$$.fragment,t),Kt=a(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wueeet"&&(N.textContent=ys),te=a(t),u(E.$$.fragment,t),ee=a(t),W=p(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-15c2891"&&(W.textContent=js),se=a(t),u(R.$$.fragment,t),le=a(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1wueeet"&&(A.textContent=ms),ne=a(t),u(F.$$.fragment,t),ae=a(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-13hfgx0"&&(V.textContent=ds),ie=a(t),u(Q.$$.fragment,t),pe=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-xr84ar"&&(L.textContent=Ts),oe=a(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1m7y210"&&(S.textContent=Js),he=a(t),H=p(t,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-27sevg"&&(H.innerHTML=fs),ue=a(t),u(z.$$.fragment,t),re=a(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-160hwoz"&&(P.textContent=bs),ce=a(t),u(O.$$.fragment,t),Me=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1bxqlg8"&&(D.textContent=gs),we=a(t),u(K.$$.fragment,t),ye=a(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-u9o4sn"&&(tt.textContent=Us),je=a(t),u(et.$$.fragment,t),me=a(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-18yryy0"&&(st.textContent=Bs),de=a(t),u(lt.$$.fragment,t),Te=a(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1wueeet"&&(nt.textContent=$s),Je=a(t),u(at.$$.fragment,t),fe=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1u60rex"&&(it.textContent=Is),be=a(t),u(pt.$$.fragment,t),ge=a(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-azbr52"&&(ot.textContent=_s),Ue=a(t),m=p(t,"BLOCKQUOTE",{});var He=Oe(m);kt=p(He,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-3uylx8"&&(kt.textContent=ks),Pe=a(He),u(ht.$$.fragment,He),He.forEach(s),Be=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1yqfqub"&&(ut.textContent=Cs),$e=a(t),u(rt.$$.fragment,t),Ie=a(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-ui9i8k"&&(ct.textContent=Gs),_e=a(t),u(Mt.$$.fragment,t),ke=a(t),wt=p(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1s2rtg2"&&(wt.textContent=vs),Ce=a(t),u(yt.$$.fragment,t),Ge=a(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1wueeet"&&(jt.textContent=xs),ve=a(t),u(mt.$$.fragment,t),xe=a(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-rlft3m"&&(dt.textContent=Xs),Xe=a(t),u(Tt.$$.fragment,t),Ze=a(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-smcbfz"&&(Jt.textContent=Zs),qe=a(t),u(ft.$$.fragment,t),Ye=a(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1i7u2e4"&&(bt.textContent=qs),Ne=a(t),u(gt.$$.fragment,t),Ee=a(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1wueeet"&&(Ut.textContent=Ys),We=a(t),u(Bt.$$.fragment,t),Re=a(t),Ae=p(t,"HR",{}),Fe=a(t),$t=p(t,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1qq5buo"&&($t.innerHTML=Ns),Ve=a(t),It=p(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1j0vk39"&&(It.innerHTML=Es),Qe=a(t),u(_t.$$.fragment,t),Le=a(t),Gt=p(t,"P",{}),Oe(Gt).forEach(s),this.h()},h(){ze(j,"name","hf:doc:metadata"),ze(j,"content",zs),Rs(T.src,es="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||ze(T,"src",es),ze(T,"alt","Unit 1 planning")},m(t,e){De(document.head,j),l(t,vt,e),l(t,Ct,e),l(t,xt,e),r(d,t,e),l(t,Xt,e),l(t,T,e),l(t,Zt,e),l(t,J,e),l(t,qt,e),l(t,f,e),l(t,Yt,e),l(t,b,e),l(t,Nt,e),l(t,g,e),l(t,Et,e),l(t,U,e),l(t,Wt,e),l(t,B,e),l(t,Rt,e),l(t,$,e),l(t,At,e),l(t,I,e),l(t,Ft,e),l(t,_,e),l(t,Vt,e),r(k,t,e),l(t,Qt,e),l(t,C,e),l(t,Lt,e),r(G,t,e),l(t,St,e),r(v,t,e),l(t,Ht,e),l(t,x,e),l(t,zt,e),r(X,t,e),l(t,Pt,e),l(t,Z,e),l(t,Ot,e),l(t,q,e),l(t,Dt,e),r(Y,t,e),l(t,Kt,e),l(t,N,e),l(t,te,e),r(E,t,e),l(t,ee,e),l(t,W,e),l(t,se,e),r(R,t,e),l(t,le,e),l(t,A,e),l(t,ne,e),r(F,t,e),l(t,ae,e),l(t,V,e),l(t,ie,e),r(Q,t,e),l(t,pe,e),l(t,L,e),l(t,oe,e),l(t,S,e),l(t,he,e),l(t,H,e),l(t,ue,e),r(z,t,e),l(t,re,e),l(t,P,e),l(t,ce,e),r(O,t,e),l(t,Me,e),l(t,D,e),l(t,we,e),r(K,t,e),l(t,ye,e),l(t,tt,e),l(t,je,e),r(et,t,e),l(t,me,e),l(t,st,e),l(t,de,e),r(lt,t,e),l(t,Te,e),l(t,nt,e),l(t,Je,e),r(at,t,e),l(t,fe,e),l(t,it,e),l(t,be,e),r(pt,t,e),l(t,ge,e),l(t,ot,e),l(t,Ue,e),l(t,m,e),De(m,kt),De(m,Pe),r(ht,m,null),l(t,Be,e),l(t,ut,e),l(t,$e,e),r(rt,t,e),l(t,Ie,e),l(t,ct,e),l(t,_e,e),r(Mt,t,e),l(t,ke,e),l(t,wt,e),l(t,Ce,e),r(yt,t,e),l(t,Ge,e),l(t,jt,e),l(t,ve,e),r(mt,t,e),l(t,xe,e),l(t,dt,e),l(t,Xe,e),r(Tt,t,e),l(t,Ze,e),l(t,Jt,e),l(t,qe,e),r(ft,t,e),l(t,Ye,e),l(t,bt,e),l(t,Ne,e),r(gt,t,e),l(t,Ee,e),l(t,Ut,e),l(t,We,e),r(Bt,t,e),l(t,Re,e),l(t,Ae,e),l(t,Fe,e),l(t,$t,e),l(t,Ve,e),l(t,It,e),l(t,Qe,e),r(_t,t,e),l(t,Le,e),l(t,Gt,e),Se=!0},p:As,i(t){Se||(c(d.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(Y.$$.fragment,t),c(E.$$.fragment,t),c(R.$$.fragment,t),c(F.$$.fragment,t),c(Q.$$.fragment,t),c(z.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(Mt.$$.fragment,t),c(yt.$$.fragment,t),c(mt.$$.fragment,t),c(Tt.$$.fragment,t),c(ft.$$.fragment,t),c(gt.$$.fragment,t),c(Bt.$$.fragment,t),c(_t.$$.fragment,t),Se=!0)},o(t){M(d.$$.fragment,t),M(k.$$.fragment,t),M(G.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(E.$$.fragment,t),M(R.$$.fragment,t),M(F.$$.fragment,t),M(Q.$$.fragment,t),M(z.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(et.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(yt.$$.fragment,t),M(mt.$$.fragment,t),M(Tt.$$.fragment,t),M(ft.$$.fragment,t),M(gt.$$.fragment,t),M(Bt.$$.fragment,t),M(_t.$$.fragment,t),Se=!1},d(t){t&&(s(vt),s(Ct),s(xt),s(Xt),s(T),s(Zt),s(J),s(qt),s(f),s(Yt),s(b),s(Nt),s(g),s(Et),s(U),s(Wt),s(B),s(Rt),s($),s(At),s(I),s(Ft),s(_),s(Vt),s(Qt),s(C),s(Lt),s(St),s(Ht),s(x),s(zt),s(Pt),s(Z),s(Ot),s(q),s(Dt),s(Kt),s(N),s(te),s(ee),s(W),s(se),s(le),s(A),s(ne),s(ae),s(V),s(ie),s(pe),s(L),s(oe),s(S),s(he),s(H),s(ue),s(re),s(P),s(ce),s(Me),s(D),s(we),s(ye),s(tt),s(je),s(me),s(st),s(de),s(Te),s(nt),s(Je),s(fe),s(it),s(be),s(ge),s(ot),s(Ue),s(m),s(Be),s(ut),s($e),s(Ie),s(ct),s(_e),s(ke),s(wt),s(Ce),s(Ge),s(jt),s(ve),s(xe),s(dt),s(Xe),s(Ze),s(Jt),s(qe),s(Ye),s(bt),s(Ne),s(Ee),s(Ut),s(We),s(Re),s(Ae),s(Fe),s($t),s(Ve),s(It),s(Qe),s(Le),s(Gt)),s(j),w(d,t),w(k,t),w(G,t),w(v,t),w(X,t),w(Y,t),w(E,t),w(R,t),w(F,t),w(Q,t),w(z,t),w(O,t),w(K,t),w(et,t),w(lt,t),w(at,t),w(pt,t),w(ht),w(rt,t),w(Mt,t),w(yt,t),w(mt,t),w(Tt,t),w(ft,t),w(gt,t),w(Bt,t),w(_t,t)}}}const zs='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function Ps(ts){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Vs{constructor(j){super(),Qs(this,j,Ps,Hs,Ws,{})}}export{sl as component};
