import{s as Pt,f as Jt,n as Kt,o as Dt}from"../chunks/scheduler.f6b352c8.js";import{S as Ot,i as te,g as i,s as a,r as X,A as ee,h as o,f as l,c as n,j as Tt,u as S,x as M,k as r,y as le,a as s,v as F,d as N,t as z,w as V}from"../chunks/index.7f38e934.js";import{C as se}from"../chunks/CodeBlock.2a338b68.js";import{H as vt}from"../chunks/Heading.333929c4.js";import{E as ae}from"../chunks/EditOnGithub.c3245a01.js";function ne(It){let y,Y,H,$,m,L,c,Bt="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",q,u,Zt="In this tutorial, you’ll create your very first Agent—capable of performing JOFFREY—and publish it on Hugging Face Spaces so you can share it with friends and colleagues.",P,j,At="Let’s get started!",K,U,D,h,Et,O,w,Wt="To make this Agent, we’re going to use a library called <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",tt,d,Gt="This lightweight library abstracts away much of the complexity of building an Agent we saw in the last section, allowing you to focus on designing your agent’s behavior",et,b,xt='We’re going to get deeper into SmolAgents in the next Unit, but if you’re interested you can check this <a href="https://huggingface.co/blog/smolagents" rel="nofollow">blog</a>.',lt,f,st,g,_t='To start, duplicate this space : <a href="https://huggingface.co/spaces/agents-course/First_agent_template" rel="nofollow">https://huggingface.co/spaces/agents-course/First_agent_template</a>',at,C,Qt="Duplicating this space means creating a local copy on your own profile:",nt,J,kt,it,T,Ht="The only file that you will have to modify is the incomplete ”<strong>app.py</strong>”",ot,v,Mt,I,Rt="The agent inside smolagents is going to have the same behaviours as the custom one we built previously. it’s going to think, act and observe in cycle until it reaches a final answer :",pt,B,Xt="Here is an example by providing an <strong>Image generation tool</strong> to the agent and asking it to generate an image of a cat :",rt,p,St,yt,Z,Ft="Your <strong>Objective</strong> is now to get familiar with the space and the agent. Currently the agent in the template does not have tools loaded, so try to provide it some of the pre-made ones or even make some new tools yourselves !",mt,A,Nt="We gave you an example of a custom tool that computes the current time in a different timezone but many tools are possible.",ct,E,zt="We are eagerly waiting for your amazing agents output in the discord channel #agents-course-showcase !",ut,jt,Ut,W,Vt="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",ht,G,Yt="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",wt,x,$t="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model etc.",dt,_,Lt="In the next section, you’re going to fill the final Quiz and get your certificate!",bt,Q,qt="—>",ft,k,gt,R,Ct;return m=new vt({props:{title:"Let’s Create Our First Agent Using Smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),U=new vt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),f=new vt({props:{title:"Let’s build",local:"lets-build",headingTag:"h2"}}),v=new se({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent,DuckDuckGoSearchTool, HfApiModel,load_tool,tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment">#it&#x27;s import to specify the return type</span>
    <span class="hljs-comment">#Keep this format for the description / args / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment">## add your tools here (don&#x27;t remove final answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),k=new ae({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){y=i("meta"),Y=a(),H=i("p"),$=a(),X(m.$$.fragment),L=a(),c=i("p"),c.innerHTML=Bt,q=a(),u=i("p"),u.textContent=Zt,P=a(),j=i("p"),j.textContent=At,K=a(),X(U.$$.fragment),D=a(),h=i("img"),O=a(),w=i("p"),w.innerHTML=Wt,tt=a(),d=i("p"),d.textContent=Gt,et=a(),b=i("p"),b.innerHTML=xt,lt=a(),X(f.$$.fragment),st=a(),g=i("p"),g.innerHTML=_t,at=a(),C=i("p"),C.textContent=Qt,nt=a(),J=i("img"),it=a(),T=i("p"),T.innerHTML=Ht,ot=a(),X(v.$$.fragment),Mt=a(),I=i("p"),I.textContent=Rt,pt=a(),B=i("p"),B.innerHTML=Xt,rt=a(),p=i("iframe"),yt=a(),Z=i("p"),Z.innerHTML=Ft,mt=a(),A=i("p"),A.textContent=Nt,ct=a(),E=i("p"),E.textContent=zt,ut=a(),jt=i("hr"),Ut=a(),W=i("p"),W.textContent=Vt,ht=a(),G=i("p"),G.textContent=Yt,wt=a(),x=i("p"),x.textContent=$t,dt=a(),_=i("p"),_.textContent=Lt,bt=a(),Q=i("p"),Q.textContent=qt,ft=a(),X(k.$$.fragment),gt=a(),R=i("p"),this.h()},l(t){const e=ee("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(l),Y=n(t),H=o(t,"P",{}),Tt(H).forEach(l),$=n(t),S(m.$$.fragment,t),L=n(t),c=o(t,"P",{"data-svelte-h":!0}),M(c)!=="svelte-nvcz0f"&&(c.innerHTML=Bt),q=n(t),u=o(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-kupy8u"&&(u.textContent=Zt),P=n(t),j=o(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-4b3xjd"&&(j.textContent=At),K=n(t),S(U.$$.fragment,t),D=n(t),h=o(t,"IMG",{src:!0,alt:!0}),O=n(t),w=o(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-xkn4l5"&&(w.innerHTML=Wt),tt=n(t),d=o(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-s6mslq"&&(d.textContent=Gt),et=n(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-z7gkwa"&&(b.innerHTML=xt),lt=n(t),S(f.$$.fragment,t),st=n(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1hvefb7"&&(g.innerHTML=_t),at=n(t),C=o(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1xyc4gz"&&(C.textContent=Qt),nt=n(t),J=o(t,"IMG",{src:!0,alt:!0}),it=n(t),T=o(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-127igce"&&(T.innerHTML=Ht),ot=n(t),S(v.$$.fragment,t),Mt=n(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-e0rc56"&&(I.textContent=Rt),pt=n(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-12jk07r"&&(B.innerHTML=Xt),rt=n(t),p=o(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Tt(p).forEach(l),yt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-6b23en"&&(Z.innerHTML=Ft),mt=n(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-utblbc"&&(A.textContent=Nt),ct=n(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-2ffdm9"&&(E.textContent=zt),ut=n(t),jt=o(t,"HR",{}),Ut=n(t),W=o(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1vcdjz4"&&(W.textContent=Vt),ht=n(t),G=o(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-10mjkny"&&(G.textContent=Yt),wt=n(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-19g8fwd"&&(x.textContent=$t),dt=n(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1s9m3df"&&(_.textContent=Lt),bt=n(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-e7l3py"&&(Q.textContent=qt),ft=n(t),S(k.$$.fragment,t),gt=n(t),R=o(t,"P",{}),Tt(R).forEach(l),this.h()},h(){r(y,"name","hf:doc:metadata"),r(y,"content",ie),Jt(h.src,Et="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(h,"src",Et),r(h,"alt","Smolagents"),Jt(J.src,kt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(J,"src",kt),r(J,"alt","Duplicate"),r(p,"width","560"),r(p,"height","315"),Jt(p.src,St="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",St),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen=""},m(t,e){le(document.head,y),s(t,Y,e),s(t,H,e),s(t,$,e),F(m,t,e),s(t,L,e),s(t,c,e),s(t,q,e),s(t,u,e),s(t,P,e),s(t,j,e),s(t,K,e),F(U,t,e),s(t,D,e),s(t,h,e),s(t,O,e),s(t,w,e),s(t,tt,e),s(t,d,e),s(t,et,e),s(t,b,e),s(t,lt,e),F(f,t,e),s(t,st,e),s(t,g,e),s(t,at,e),s(t,C,e),s(t,nt,e),s(t,J,e),s(t,it,e),s(t,T,e),s(t,ot,e),F(v,t,e),s(t,Mt,e),s(t,I,e),s(t,pt,e),s(t,B,e),s(t,rt,e),s(t,p,e),s(t,yt,e),s(t,Z,e),s(t,mt,e),s(t,A,e),s(t,ct,e),s(t,E,e),s(t,ut,e),s(t,jt,e),s(t,Ut,e),s(t,W,e),s(t,ht,e),s(t,G,e),s(t,wt,e),s(t,x,e),s(t,dt,e),s(t,_,e),s(t,bt,e),s(t,Q,e),s(t,ft,e),F(k,t,e),s(t,gt,e),s(t,R,e),Ct=!0},p:Kt,i(t){Ct||(N(m.$$.fragment,t),N(U.$$.fragment,t),N(f.$$.fragment,t),N(v.$$.fragment,t),N(k.$$.fragment,t),Ct=!0)},o(t){z(m.$$.fragment,t),z(U.$$.fragment,t),z(f.$$.fragment,t),z(v.$$.fragment,t),z(k.$$.fragment,t),Ct=!1},d(t){t&&(l(Y),l(H),l($),l(L),l(c),l(q),l(u),l(P),l(j),l(K),l(D),l(h),l(O),l(w),l(tt),l(d),l(et),l(b),l(lt),l(st),l(g),l(at),l(C),l(nt),l(J),l(it),l(T),l(ot),l(Mt),l(I),l(pt),l(B),l(rt),l(p),l(yt),l(Z),l(mt),l(A),l(ct),l(E),l(ut),l(jt),l(Ut),l(W),l(ht),l(G),l(wt),l(x),l(dt),l(_),l(bt),l(Q),l(ft),l(gt),l(R)),l(y),V(m,t),V(U,t),V(f,t),V(v,t),V(k,t)}}}const ie='{"title":"Let’s Create Our First Agent Using Smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build","local":"lets-build","sections":[],"depth":2}],"depth":1}';function oe(It){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ce extends Ot{constructor(y){super(),te(this,y,oe,ne,Pt,{})}}export{ce as component};
