import{s as Al,f as xe,n as gl,o as vl}from"../chunks/scheduler.f6b352c8.js";import{S as Bl,i as _l,g as i,s as n,r as T,A as xl,h as M,f as l,c as a,j as Ge,u as p,x as o,k as J,y as We,a as s,v as w,d as u,t as y,w as r}from"../chunks/index.7f38e934.js";import{C as It}from"../chunks/CodeBlock.2a338b68.js";import{H as ht}from"../chunks/Heading.333929c4.js";import{E as Hl}from"../chunks/EditOnGithub.c3245a01.js";function Gl(Re){let c,ft,Ct,bt,U,At,j,Ze,gt,I,$e="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>.",vt,C,Le="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",Bt,d,Se="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",_t,h,xt,f,ke="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>",Ht,b,Ee="Here are some commonly used tools in AI agents :",Gt,A,Ye="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",Wt,g,Xe="Those are only examples, as you can in fact create a tool for any use case!",Rt,v,ze="A good tool should be something that <strong>complements the power of an LLM</strong>.",Zt,B,Qe="For instance if you need to perform calculus, giving a <strong>calculator tool</strong> to your LLM will provide better result than relying on the native capacities of the model.",$t,_,Ve="Furthermore, <strong>LLM predict the completion of a prompt based on their training data</strong>. Which means that it’s internal knowledge only includes events prior to their training. Therefore, agents need access to up to date data through tools.",Lt,x,qe="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",St,H,Fe,kt,G,Ne="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",Et,W,Yt,R,Pe="The answer may seem overwhelming, but we provide textual descriptions of tools available for the model to use in the system prompt.",Xt,Z,Ke="Here is dummy example:",zt,$,De,Qt,L,Oe="The key here is to ensure the most accurate textual description of:",Vt,S,tl="<li><strong>What does this tool do?</strong></li> <li><strong>What inputs does it expect?</strong></li>",qt,k,el="If that seems too theoretical, let’s understand it through a concrete example:",Ft,E,ll="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",Nt,Y,Pt,X,sl="This is the Python implementation of the tool we just discussed.",Kt,z,nl="It may seem complicated, but it’s not. We simply define a <strong><code>Tool</code></strong> class that includes:",Dt,Q,al="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>input_arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function directly when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",Ot,V,il="Now let’s create a Tool.",te,q,Ml="<p>For those interested, here’s the code to declare a Tool using a decorator.</p>",ee,m,jt,ol="decorator code",He,F,le,N,Tl=`One of the most common tools in agents is a <strong>calculator</strong> tool.<br/>
Here, we present a simplified version that only multiplies two integers.`,se,P,ne,K,pl="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",ae,D,ie,O,wl="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",Me,tt,ul=`We have provided a textual description of this function as a <strong>docstring</strong>,<br/>
so let’s see what it looks like as a <strong>textual description</strong>!`,oe,et,yl="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",Te,lt,pe,st,rl="Outputs the following text :",we,nt,ue,at,Jl="Based on this Textual description, the LLM knows that it it can call the LLM  <code>calculator(a, b)</code>.",ye,it,cl="Let’s just <strong>sanity check</strong> the tool is properly working outside of an agent",re,Mt,Je,ot,ml="Output :",ce,Tt,me,pt,Ul="We can see that the function is working and our implementation allows the Agent knows its available tools based on the textual description.",Ue,wt,jl="In the Action section, we will learn more about how an Agent can *<em>Call</em> this tool.",je,ut,Il="The description is <strong>injected</strong> in the system prompt. Taking the same dummy example, here is how it would look after replacing the parameters:",Ie,yt,Cl,Ce,de,he,rt,dl="Tools play a crucial role in enhancing the capabilities of AI agents.",fe,Jt,hl="To summarize, we learned:",be,ct,fl="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",Ae,mt,bl="Now, we can move on to the Agent Workflow where you’ll see how an Agent observes, thinks, and acts <strong>bringing together everything we’ve covered so far</strong> and setting the stage for creating your own fully functional AI Agent.",ge,Ut,ve,dt,Be;return U=new ht({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),h=new ht({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),W=new ht({props:{title:"How do we give tools to an LLM ?",local:"how-do-we-give-tools-to-an-llm-",headingTag:"h2"}}),Y=new It({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).
    
    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool, 
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),F=new It({props:{code:"ZGVmJTIwdG9vbChmdW5jKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEElMjBkZWNvcmF0b3IlMjB0aGF0JTIwY3JlYXRlcyUyMGElMjBUb29sJTIwaW5zdGFuY2UlMjBmcm9tJTIwdGhlJTIwZ2l2ZW4lMjBmdW5jdGlvbi4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjBmdW5jdGlvbiUyMHNpZ25hdHVyZSUwQSUyMCUyMCUyMCUyMHNpZ25hdHVyZSUyMCUzRCUyMGluc3BlY3Quc2lnbmF0dXJlKGZ1bmMpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXh0cmFjdCUyMChwYXJhbV9uYW1lJTJDJTIwcGFyYW1fYW5ub3RhdGlvbiklMjBwYWlycyUyMGZvciUyMGlucHV0cyUwQSUyMCUyMCUyMCUyMGFyZ3VtZW50cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBzaWduYXR1cmUucGFyYW1ldGVycy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFubm90YXRpb25fbmFtZSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXJhbS5hbm5vdGF0aW9uLl9fbmFtZV9fJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBoYXNhdHRyKHBhcmFtLmFubm90YXRpb24lMkMlMjAnX19uYW1lX18nKSUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlMjBzdHIocGFyYW0uYW5ub3RhdGlvbiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJndW1lbnRzLmFwcGVuZCgocGFyYW0ubmFtZSUyQyUyMGFubm90YXRpb25fbmFtZSkpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGV0ZXJtaW5lJTIwdGhlJTIwcmV0dXJuJTIwYW5ub3RhdGlvbiUwQSUyMCUyMCUyMCUyMHJldHVybl9hbm5vdGF0aW9uJTIwJTNEJTIwc2lnbmF0dXJlLnJldHVybl9hbm5vdGF0aW9uJTBBJTIwJTIwJTIwJTIwaWYlMjByZXR1cm5fYW5ub3RhdGlvbiUyMGlzJTIwaW5zcGVjdC5fZW1wdHklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwJTIyTm8lMjByZXR1cm4lMjBhbm5vdGF0aW9uJTIyJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuX2Fubm90YXRpb24uX19uYW1lX18lMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGhhc2F0dHIocmV0dXJuX2Fubm90YXRpb24lMkMlMjAnX19uYW1lX18nKSUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlMjBzdHIocmV0dXJuX2Fubm90YXRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGZ1bmN0aW9uJ3MlMjBkb2NzdHJpbmclMjBhcyUyMHRoZSUyMGRlc2NyaXB0aW9uJTIwKGRlZmF1bHQlMjBpZiUyME5vbmUpJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjBmdW5jLl9fZG9jX18lMjBvciUyMCUyMk5vJTIwZGVzY3JpcHRpb24lMjBwcm92aWRlZC4lMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBmdW5jdGlvbiUyMG5hbWUlMjBiZWNvbWVzJTIwdGhlJTIwVG9vbCUyMG5hbWUlMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwZnVuYy5fX25hbWVfXyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFJldHVybiUyMGElMjBuZXclMjBUb29sJTIwaW5zdGFuY2UlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBUb29sKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0RuYW1lJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0RkZXNjcmlwdGlvbiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZ1bmMlM0RmdW5jJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJndW1lbnRzJTNEYXJndW1lbnRzJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUzRG91dHB1dHMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__
    
    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),P=new ht({props:{title:"Function Inputs",local:"function-inputs",headingTag:"h4"}}),D=new ht({props:{title:"Returns",local:"returns",headingTag:"h4"}}),lt=new It({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),nt=new It({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, Description: Multiply two integers., Arguments: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, Outputs: <span class="hljs-built_in">int</span>',wrap:!1}}),Mt=new It({props:{code:"cmVzdWx0JTIwJTNEJTIwY2FsY3VsYXRvcig1JTJDJTIwNiklMEFwcmludChmJTIyQ2FsbCUyMHJlc3VsdCUzQSUyMCU3QnJlc3VsdCU3RCUyMik=",highlighted:`result = calculator(<span class="hljs-number">5</span>, <span class="hljs-number">6</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Call result: <span class="hljs-subst">{result}</span>&quot;</span>)`,wrap:!1}}),Tt=new It({props:{code:"Q2FsbCUyMHJlc3VsdCUzQSUyMDMw",highlighted:'Call result: <span class="hljs-number">30</span>',wrap:!1}}),Ut=new Hl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){c=i("meta"),ft=n(),Ct=i("p"),bt=n(),T(U.$$.fragment),At=n(),j=i("img"),gt=n(),I=i("p"),I.innerHTML=$e,vt=n(),C=i("p"),C.textContent=Le,Bt=n(),d=i("p"),d.textContent=Se,_t=n(),T(h.$$.fragment),xt=n(),f=i("p"),f.innerHTML=ke,Ht=n(),b=i("p"),b.textContent=Ee,Gt=n(),A=i("table"),A.innerHTML=Ye,Wt=n(),g=i("p"),g.textContent=Xe,Rt=n(),v=i("p"),v.innerHTML=ze,Zt=n(),B=i("p"),B.innerHTML=Qe,$t=n(),_=i("p"),_.innerHTML=Ve,Lt=n(),x=i("p"),x.textContent=qe,St=n(),H=i("img"),kt=n(),G=i("ul"),G.innerHTML=Ne,Et=n(),T(W.$$.fragment),Yt=n(),R=i("p"),R.textContent=Pe,Xt=n(),Z=i("p"),Z.textContent=Ke,zt=n(),$=i("img"),Qt=n(),L=i("p"),L.textContent=Oe,Vt=n(),S=i("ol"),S.innerHTML=tl,qt=n(),k=i("p"),k.textContent=el,Ft=n(),E=i("blockquote"),E.innerHTML=ll,Nt=n(),T(Y.$$.fragment),Pt=n(),X=i("p"),X.textContent=sl,Kt=n(),z=i("p"),z.innerHTML=nl,Dt=n(),Q=i("ul"),Q.innerHTML=al,Ot=n(),V=i("p"),V.textContent=il,te=n(),q=i("blockquote"),q.innerHTML=Ml,ee=n(),m=i("details"),jt=i("summary"),jt.textContent=ol,He=n(),T(F.$$.fragment),le=n(),N=i("p"),N.innerHTML=Tl,se=n(),T(P.$$.fragment),ne=n(),K=i("ul"),K.innerHTML=pl,ae=n(),T(D.$$.fragment),ie=n(),O=i("ul"),O.innerHTML=wl,Me=n(),tt=i("p"),tt.innerHTML=ul,oe=n(),et=i("blockquote"),et.innerHTML=yl,Te=n(),T(lt.$$.fragment),pe=n(),st=i("p"),st.textContent=rl,we=n(),T(nt.$$.fragment),ue=n(),at=i("p"),at.innerHTML=Jl,ye=n(),it=i("p"),it.innerHTML=cl,re=n(),T(Mt.$$.fragment),Je=n(),ot=i("p"),ot.textContent=ml,ce=n(),T(Tt.$$.fragment),me=n(),pt=i("p"),pt.textContent=Ul,Ue=n(),wt=i("p"),wt.innerHTML=jl,je=n(),ut=i("p"),ut.innerHTML=Il,Ie=n(),yt=i("img"),Ce=n(),de=i("hr"),he=n(),rt=i("p"),rt.textContent=dl,fe=n(),Jt=i("p"),Jt.textContent=hl,be=n(),ct=i("ul"),ct.innerHTML=fl,Ae=n(),mt=i("p"),mt.innerHTML=bl,ge=n(),T(Ut.$$.fragment),ve=n(),dt=i("p"),this.h()},l(t){const e=xl("svelte-u9bgzb",document.head);c=M(e,"META",{name:!0,content:!0}),e.forEach(l),ft=a(t),Ct=M(t,"P",{}),Ge(Ct).forEach(l),bt=a(t),p(U.$$.fragment,t),At=a(t),j=M(t,"IMG",{src:!0,alt:!0}),gt=a(t),I=M(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-mw6rya"&&(I.innerHTML=$e),vt=a(t),C=M(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ox1lcz"&&(C.textContent=Le),Bt=a(t),d=M(t,"P",{"data-svelte-h":!0}),o(d)!=="svelte-g748wk"&&(d.textContent=Se),_t=a(t),p(h.$$.fragment,t),xt=a(t),f=M(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1dqb7wc"&&(f.innerHTML=ke),Ht=a(t),b=M(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1uce65n"&&(b.textContent=Ee),Gt=a(t),A=M(t,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-1r7ovsn"&&(A.innerHTML=Ye),Wt=a(t),g=M(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1fuccdy"&&(g.textContent=Xe),Rt=a(t),v=M(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1eopnbk"&&(v.innerHTML=ze),Zt=a(t),B=M(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-mv31ek"&&(B.innerHTML=Qe),$t=a(t),_=M(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-uqfvj3"&&(_.innerHTML=Ve),Lt=a(t),x=M(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-mz2far"&&(x.textContent=qe),St=a(t),H=M(t,"IMG",{src:!0,alt:!0}),kt=a(t),G=M(t,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-gj3em1"&&(G.innerHTML=Ne),Et=a(t),p(W.$$.fragment,t),Yt=a(t),R=M(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-11fbq7u"&&(R.textContent=Pe),Xt=a(t),Z=M(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-192no9a"&&(Z.textContent=Ke),zt=a(t),$=M(t,"IMG",{src:!0,alt:!0}),Qt=a(t),L=M(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-hzqqir"&&(L.textContent=Oe),Vt=a(t),S=M(t,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-zvbc7g"&&(S.innerHTML=tl),qt=a(t),k=M(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1kzyblc"&&(k.textContent=el),Ft=a(t),E=M(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(E)!=="svelte-17jlnyo"&&(E.innerHTML=ll),Nt=a(t),p(Y.$$.fragment,t),Pt=a(t),X=M(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wy1oxs"&&(X.textContent=sl),Kt=a(t),z=M(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1oph47g"&&(z.innerHTML=nl),Dt=a(t),Q=M(t,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-b50bmq"&&(Q.innerHTML=al),Ot=a(t),V=M(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1ludbas"&&(V.textContent=il),te=a(t),q=M(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(q)!=="svelte-a9uftq"&&(q.innerHTML=Ml),ee=a(t),m=M(t,"DETAILS",{});var _e=Ge(m);jt=M(_e,"SUMMARY",{"data-svelte-h":!0}),o(jt)!=="svelte-14wmf42"&&(jt.textContent=ol),He=a(_e),p(F.$$.fragment,_e),_e.forEach(l),le=a(t),N=M(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-15781vi"&&(N.innerHTML=Tl),se=a(t),p(P.$$.fragment,t),ne=a(t),K=M(t,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-1rtfde7"&&(K.innerHTML=pl),ae=a(t),p(D.$$.fragment,t),ie=a(t),O=M(t,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-l1z4i7"&&(O.innerHTML=wl),Me=a(t),tt=M(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1nj6s01"&&(tt.innerHTML=ul),oe=a(t),et=M(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(et)!=="svelte-jn5onw"&&(et.innerHTML=yl),Te=a(t),p(lt.$$.fragment,t),pe=a(t),st=M(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-4wqwjx"&&(st.textContent=rl),we=a(t),p(nt.$$.fragment,t),ue=a(t),at=M(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-37efgl"&&(at.innerHTML=Jl),ye=a(t),it=M(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-yqvjut"&&(it.innerHTML=cl),re=a(t),p(Mt.$$.fragment,t),Je=a(t),ot=M(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1we6hr1"&&(ot.textContent=ml),ce=a(t),p(Tt.$$.fragment,t),me=a(t),pt=M(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1mj2fht"&&(pt.textContent=Ul),Ue=a(t),wt=M(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-11lrbso"&&(wt.innerHTML=jl),je=a(t),ut=M(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1kzks19"&&(ut.innerHTML=Il),Ie=a(t),yt=M(t,"IMG",{src:!0,alt:!0}),Ce=a(t),de=M(t,"HR",{}),he=a(t),rt=M(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1snnjrz"&&(rt.textContent=dl),fe=a(t),Jt=M(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1mncb1b"&&(Jt.textContent=hl),be=a(t),ct=M(t,"UL",{"data-svelte-h":!0}),o(ct)!=="svelte-1lbaznq"&&(ct.innerHTML=fl),Ae=a(t),mt=M(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1a430ig"&&(mt.innerHTML=bl),ge=a(t),p(Ut.$$.fragment,t),ve=a(t),dt=M(t,"P",{}),Ge(dt).forEach(l),this.h()},h(){J(c,"name","hf:doc:metadata"),J(c,"content",Wl),xe(j.src,Ze="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||J(j,"src",Ze),J(j,"alt","Unit 1 planning"),xe(H.src,Fe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||J(H,"src",Fe),J(H,"alt","Weather"),xe($.src,De="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||J($,"src",De),J($,"alt","System prompt for tools"),xe(yt.src,Cl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||J(yt,"src",Cl),J(yt,"alt","System prompt for tools")},m(t,e){We(document.head,c),s(t,ft,e),s(t,Ct,e),s(t,bt,e),w(U,t,e),s(t,At,e),s(t,j,e),s(t,gt,e),s(t,I,e),s(t,vt,e),s(t,C,e),s(t,Bt,e),s(t,d,e),s(t,_t,e),w(h,t,e),s(t,xt,e),s(t,f,e),s(t,Ht,e),s(t,b,e),s(t,Gt,e),s(t,A,e),s(t,Wt,e),s(t,g,e),s(t,Rt,e),s(t,v,e),s(t,Zt,e),s(t,B,e),s(t,$t,e),s(t,_,e),s(t,Lt,e),s(t,x,e),s(t,St,e),s(t,H,e),s(t,kt,e),s(t,G,e),s(t,Et,e),w(W,t,e),s(t,Yt,e),s(t,R,e),s(t,Xt,e),s(t,Z,e),s(t,zt,e),s(t,$,e),s(t,Qt,e),s(t,L,e),s(t,Vt,e),s(t,S,e),s(t,qt,e),s(t,k,e),s(t,Ft,e),s(t,E,e),s(t,Nt,e),w(Y,t,e),s(t,Pt,e),s(t,X,e),s(t,Kt,e),s(t,z,e),s(t,Dt,e),s(t,Q,e),s(t,Ot,e),s(t,V,e),s(t,te,e),s(t,q,e),s(t,ee,e),s(t,m,e),We(m,jt),We(m,He),w(F,m,null),s(t,le,e),s(t,N,e),s(t,se,e),w(P,t,e),s(t,ne,e),s(t,K,e),s(t,ae,e),w(D,t,e),s(t,ie,e),s(t,O,e),s(t,Me,e),s(t,tt,e),s(t,oe,e),s(t,et,e),s(t,Te,e),w(lt,t,e),s(t,pe,e),s(t,st,e),s(t,we,e),w(nt,t,e),s(t,ue,e),s(t,at,e),s(t,ye,e),s(t,it,e),s(t,re,e),w(Mt,t,e),s(t,Je,e),s(t,ot,e),s(t,ce,e),w(Tt,t,e),s(t,me,e),s(t,pt,e),s(t,Ue,e),s(t,wt,e),s(t,je,e),s(t,ut,e),s(t,Ie,e),s(t,yt,e),s(t,Ce,e),s(t,de,e),s(t,he,e),s(t,rt,e),s(t,fe,e),s(t,Jt,e),s(t,be,e),s(t,ct,e),s(t,Ae,e),s(t,mt,e),s(t,ge,e),w(Ut,t,e),s(t,ve,e),s(t,dt,e),Be=!0},p:gl,i(t){Be||(u(U.$$.fragment,t),u(h.$$.fragment,t),u(W.$$.fragment,t),u(Y.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(lt.$$.fragment,t),u(nt.$$.fragment,t),u(Mt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ut.$$.fragment,t),Be=!0)},o(t){y(U.$$.fragment,t),y(h.$$.fragment,t),y(W.$$.fragment,t),y(Y.$$.fragment,t),y(F.$$.fragment,t),y(P.$$.fragment,t),y(D.$$.fragment,t),y(lt.$$.fragment,t),y(nt.$$.fragment,t),y(Mt.$$.fragment,t),y(Tt.$$.fragment,t),y(Ut.$$.fragment,t),Be=!1},d(t){t&&(l(ft),l(Ct),l(bt),l(At),l(j),l(gt),l(I),l(vt),l(C),l(Bt),l(d),l(_t),l(xt),l(f),l(Ht),l(b),l(Gt),l(A),l(Wt),l(g),l(Rt),l(v),l(Zt),l(B),l($t),l(_),l(Lt),l(x),l(St),l(H),l(kt),l(G),l(Et),l(Yt),l(R),l(Xt),l(Z),l(zt),l($),l(Qt),l(L),l(Vt),l(S),l(qt),l(k),l(Ft),l(E),l(Nt),l(Pt),l(X),l(Kt),l(z),l(Dt),l(Q),l(Ot),l(V),l(te),l(q),l(ee),l(m),l(le),l(N),l(se),l(ne),l(K),l(ae),l(ie),l(O),l(Me),l(tt),l(oe),l(et),l(Te),l(pe),l(st),l(we),l(ue),l(at),l(ye),l(it),l(re),l(Je),l(ot),l(ce),l(me),l(pt),l(Ue),l(wt),l(je),l(ut),l(Ie),l(yt),l(Ce),l(de),l(he),l(rt),l(fe),l(Jt),l(be),l(ct),l(Ae),l(mt),l(ge),l(ve),l(dt)),l(c),r(U,t),r(h,t),r(W,t),r(Y,t),r(F),r(P,t),r(D,t),r(lt,t),r(nt,t),r(Mt,t),r(Tt,t),r(Ut,t)}}}const Wl='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do we give tools to an LLM ?","local":"how-do-we-give-tools-to-an-llm-","sections":[{"title":"Function Inputs","local":"function-inputs","sections":[],"depth":4},{"title":"Returns","local":"returns","sections":[],"depth":4}],"depth":2}],"depth":1}';function Rl(Re){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Bl{constructor(c){super(),_l(this,c,Rl,Gl,Al,{})}}export{El as component};
