import{s as Rt,f as iM,n as Ct,o as Qt}from"../chunks/scheduler.f6b352c8.js";import{S as Et,i as At,g as U,s as e,r as A,A as nt,h as R,f as t,c as D,j as yM,u as n,x as C,k as E,y as jt,a as s,v as j,d as a,t as V,w as J}from"../chunks/index.7f38e934.js";import{C as pM}from"../chunks/CodeBlock.3ee8293b.js";import{H as Vl,E as at}from"../chunks/index.1338b5b2.js";function Vt(wM){let p,Jl,jl,pl,i,il,y,oM="В прошлом разделе мы узнали, как можно создавать агентов с нуля, используя код на Python, и <strong>увидели, насколько утомительным может быть этот процесс</strong>. К счастью, многие библиотеки Агентов упрощают эту работу, <strong>выполняя большую часть тяжелой работы за вас</strong>.",yl,w,kM="В этом уроке <strong>вы создадите своего первого агента</strong>, способного выполнять такие действия, как генерация изображений, веб-поиск, проверка часового пояса и многое другое!",wl,o,IM="Вы также опубликуете своего агента <strong>в пространстве Hugging Face Space, чтобы вы могли поделиться им с друзьями и коллегами</strong>.",ol,k,mM="Давайте начнем!",kl,I,Il,m,rM,ml,r,TM="Для создания этого агента мы будем использовать библиотеку <code>smolagents</code>, которая <strong>предоставляет основу для разработки агентов с легкостью</strong>.",rl,T,cM="Эта легковесная библиотека создана для простоты, но она абстрагирует большую часть сложности создания агента, позволяя вам сосредоточиться на разработке поведения агента.",Tl,c,SM='В следующем разделе мы углубимся в изучение smolagents. А пока вы можете ознакомиться с этой <a href="https://huggingface.co/blog/smolagents" target="_blank">статьей в блоге</a> или с <a href="https://github.com/huggingface/smolagents" target="_blank">репозиторием библиотеки на GitHub</a>.',cl,S,uM="Вкратце, <code>smolagents</code> - это библиотека, ориентированная на <strong>Агентов кода</strong>, вид агента, который выполняет <strong>“Действия”</strong> через блоки кода, а затем <strong>“Наблюдает”</strong> за результатами, выполняя код.",Sl,u,OM="Вот пример того, что мы будем создавать!",ul,O,gM="Мы предоставили нашему агенту <strong>Инструмент генерации изображений</strong> и попросили его сгенерировать изображение кошки.",Ol,g,bM="Агент внутри <code>smolagents</code> будет иметь <strong>такое же поведение, как и пользовательский агент, который мы построили ранее</strong>: он будет <strong>думать, действовать и наблюдать в цикле</strong>, пока не придет к окончательному ответу:",gl,Q,hM,bl,b,dM="Захватывающе, правда?",hl,h,dl,d,fM='Для начала продублируйте это пространство (Space): <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',fl,f,xM='<p>Спасибо <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> за этот шаблон! 🙌</p>',xl,x,BM="Дублирование этого пространства означает <strong>создание локальной копии в вашем собственном профиле</strong>:",Bl,B,vM,vl,v,_M='На протяжении всего этого урока единственным файлом, который вам придется изменить, будет (на данный момент неполный) <strong>“app.py »</strong>. Здесь вы можете увидеть <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">оригинал в шаблоне</a>. Чтобы найти свой, зайдите в свою копию пространства, затем перейдите на вкладку <code>Files</code>, а затем на <code>app.py</code> в списке каталогов.',_l,_,NM="Давайте разберем код вместе:",Nl,N,HM="<li>Файл начинается с простого, но необходимого импорта библиотек</li>",Hl,H,Wl,W,WM="Как уже говорилось ранее, мы будем напрямую использовать класс <strong>CodeAgent</strong> из <strong>smolagents</strong>.",Zl,Z,zl,z,ZM='Теперь перейдем к инструментам! Если вы хотите узнать больше об инструментах, не стесняйтесь вернуться к разделу курса <a href="tools">Инструменты</a>.',Gl,G,Yl,Y,zM="Инструменты - это то, что мы призываем вас создать в этом разделе! Мы приводим два примера:",Fl,F,GM="<li><strong>нерабочий фиктивный инструмент</strong>, который вы можете модифицировать, чтобы сделать что-то полезное.</li> <li><strong>действительно работающий инструмент</strong>, который получает текущее время в любой точке мира.</li>",Xl,X,YM="Чтобы определить свой инструмент, необходимо:",$l,$,FM="<li>Предоставить входной и выходной типы для вашей функции, как в <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>Написать хорошо отформатированную строку документации</strong>. <code>smolagents</code> ожидает, что все аргументы будут иметь <strong>текстовое описание в строке документации</strong>.</li>",Ll,L,ql,q,XM='Он использует <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> в качестве движка LLM. Это очень способная модель, к которой мы будем обращаться через бессерверный API.',Pl,P,Kl,K,$M="Этот агент по-прежнему использует <code>InferenceClient</code>, который мы видели в предыдущем разделе за классом <strong>HfApiModel</strong>!",lM,ll,LM="Мы приведем более подробные примеры, когда будем представлять фреймворк в разделе 2. Пока же вам нужно сосредоточиться на <strong>добавлении новых инструментов в список инструментов</strong> с помощью параметра <code>tools</code> вашего Агента.",MM,Ml,qM="Например, вы можете использовать <code>DuckDuckGoSearchTool</code>, который был импортирован в первой строке кода, или вы можете изучить <code>image_generation_tool</code>, который загружается из Hub позже в коде.",tM,tl,PM="<strong>Добавление инструментов даст вашему агенту новые возможности</strong>, попробуйте проявить творческий подход!",sM,sl,KM="Полная версия “app.py”:",eM,el,DM,Dl,lt="Ваша <strong>Цель</strong> - познакомиться с Пространством и Агентом.",UM,Ul,Mt="В настоящее время агент в шаблоне <strong>не использует никаких инструментов, поэтому постарайтесь снабдить его некоторыми из готовых инструментов или даже сделать новые инструменты самостоятельно!</strong>.",RM,Rl,tt="Мы с нетерпением ждем ваших потрясающих выводов агентов в канале discord <strong>#agents-course-showcase</strong>!",CM,QM,EM,Cl,st="Поздравляем, вы создали своего первого агента! Не стесняйтесь поделиться им со своими друзьями и коллегами.",AM,Ql,et="Поскольку это ваша первая попытка, совершенно нормально, если он будет немного глючным или медленным. В следующих разделах мы узнаем, как создавать еще более совершенных агентов.",nM,El,Dt="Лучший способ научиться - это попробовать, поэтому не стесняйтесь обновлять его, добавлять новые инструменты, пробовать с другой моделью и т. д.",jM,Al,Ut="В следующем разделе вы пройдете финальный тест и получите сертификат!",aM,nl,VM,al,JM;return i=new Vl({props:{title:"Давайте создадим нашего первого агента с помощью smolagents",local:"давайте-создадим-нашего-первого-агента-с-помощью-smolagents",headingTag:"h1"}}),I=new Vl({props:{title:"Что такое smolagents?",local:"что-такое-smolagents",headingTag:"h2"}}),h=new Vl({props:{title:"Давайте создадим нашего агента!",local:"давайте-создадим-нашего-агента",headingTag:"h2"}}),H=new pM({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),Z=new Vl({props:{title:"Инструменты",local:"инструменты",headingTag:"h3"}}),G=new pM({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># важно указать возвращаемый тип</span>
    <span class="hljs-comment"># Сохраните этот формат для описания инструмента / описания аргументов, но не стесняйтесь модифицировать инструмент</span>
    <span class="hljs-string">&quot;&quot;&quot;Инструмент, который пока ничего не делает
    Аргументы:
        arg1: первый аргумент
        arg2: второй аргумент
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Какую магию вы будете создавать?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Инструмент для получения текущего местного времени в указанном часовом поясе.
    Аргменты:
        timezone: Строка, представляющая действительный часовой пояс (например, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Создание объекта timezone</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Получение текущего времени в заданном часовом поясе</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Текущее местное время в <span class="hljs-subst">{timezone}</span> составляет: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Ошибка получения времени для часового пояса &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),L=new Vl({props:{title:"Агент",local:"агент",headingTag:"h3"}}),P=new pM({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjAlRDAlQTElRDAlQkUlRDAlQjclRDAlQjQlRDAlQjAlRDAlQjUlRDAlQkMlMjAlRDAlQkQlRDAlQjAlRDElODglMjAlRDAlOUElRDAlQkUlRDAlQjQlRDAlQkUlRDAlQjIlRDElOEIlRDAlQjklMjAlRDAlOTAlRDAlQjMlRDAlQjUlRDAlQkQlRDElODIlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJmaW5hbF9hbnN3ZXIlNUQlMkMlMjAlMjMlMjAlRDAlQjQlRDAlQkUlRDAlQjElRDAlQjAlRDAlQjIlRDElOEMlRDElODIlRDAlQjUlMjAlRDElODElRDElOEUlRDAlQjQlRDAlQjAlMjAlRDElODElRDAlQjIlRDAlQkUlRDAlQjglMjAlRDAlQjglRDAlQkQlRDElODElRDElODIlRDElODAlRDElODMlRDAlQkMlRDAlQjUlRDAlQkQlRDElODIlRDElOEIlMjAoJUQwJUJEJUQwJUI1JTIwJUQxJTgzJUQwJUI0JUQwJUIwJUQwJUJCJUQxJThGJUQwJUI5JUQxJTgyJUQwJUI1JTIwZmluYWxfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Создаем наш Кодовый Агент</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># добавьте сюда свои инструменты (не удаляйте final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),el=new pM({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Ниже приведен пример инструмента, который ничего не делает. Удивите нас своей креативностью!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># важно указать возвращаемый тип</span>
    <span class="hljs-comment"># Сохраните этот формат для описания инструмента / описания аргументов, но не стесняйтесь модифицировать инструмент</span>
    <span class="hljs-string">&quot;&quot;&quot;Инструмент, который пока ничего не делает
    Аргументы:
        arg1: первый аргумент
        arg2: второй аргумент
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Какую магию вы будете создавать?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Инструмент для получения текущего местного времени в указанном часовом поясе.
    Аргменты:
        timezone: Строка, представляющая действительный часовой пояс (например, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Создание объекта timezone</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Получение текущего времени в заданном часовом поясе</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Текущее местное время в <span class="hljs-subst">{timezone}</span> составляет: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Ошибка получения времени для часового пояса &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Импорт инструмента из Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># добавьте сюда свои инструменты (не удаляйте final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),nl=new at({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/tutorial.mdx"}}),{c(){p=U("meta"),Jl=e(),jl=U("p"),pl=e(),A(i.$$.fragment),il=e(),y=U("p"),y.innerHTML=oM,yl=e(),w=U("p"),w.innerHTML=kM,wl=e(),o=U("p"),o.innerHTML=IM,ol=e(),k=U("p"),k.textContent=mM,kl=e(),A(I.$$.fragment),Il=e(),m=U("img"),ml=e(),r=U("p"),r.innerHTML=TM,rl=e(),T=U("p"),T.textContent=cM,Tl=e(),c=U("p"),c.innerHTML=SM,cl=e(),S=U("p"),S.innerHTML=uM,Sl=e(),u=U("p"),u.textContent=OM,ul=e(),O=U("p"),O.innerHTML=gM,Ol=e(),g=U("p"),g.innerHTML=bM,gl=e(),Q=U("iframe"),bl=e(),b=U("p"),b.textContent=dM,hl=e(),A(h.$$.fragment),dl=e(),d=U("p"),d.innerHTML=fM,fl=e(),f=U("blockquote"),f.innerHTML=xM,xl=e(),x=U("p"),x.innerHTML=BM,Bl=e(),B=U("img"),vl=e(),v=U("p"),v.innerHTML=_M,_l=e(),_=U("p"),_.textContent=NM,Nl=e(),N=U("ul"),N.innerHTML=HM,Hl=e(),A(H.$$.fragment),Wl=e(),W=U("p"),W.innerHTML=WM,Zl=e(),A(Z.$$.fragment),zl=e(),z=U("p"),z.innerHTML=ZM,Gl=e(),A(G.$$.fragment),Yl=e(),Y=U("p"),Y.textContent=zM,Fl=e(),F=U("ol"),F.innerHTML=GM,Xl=e(),X=U("p"),X.textContent=YM,$l=e(),$=U("ol"),$.innerHTML=FM,Ll=e(),A(L.$$.fragment),ql=e(),q=U("p"),q.innerHTML=XM,Pl=e(),A(P.$$.fragment),Kl=e(),K=U("p"),K.innerHTML=$M,lM=e(),ll=U("p"),ll.innerHTML=LM,MM=e(),Ml=U("p"),Ml.innerHTML=qM,tM=e(),tl=U("p"),tl.innerHTML=PM,sM=e(),sl=U("p"),sl.textContent=KM,eM=e(),A(el.$$.fragment),DM=e(),Dl=U("p"),Dl.innerHTML=lt,UM=e(),Ul=U("p"),Ul.innerHTML=Mt,RM=e(),Rl=U("p"),Rl.innerHTML=tt,CM=e(),QM=U("hr"),EM=e(),Cl=U("p"),Cl.textContent=st,AM=e(),Ql=U("p"),Ql.textContent=et,nM=e(),El=U("p"),El.textContent=Dt,jM=e(),Al=U("p"),Al.textContent=Ut,aM=e(),A(nl.$$.fragment),VM=e(),al=U("p"),this.h()},l(l){const M=nt("svelte-u9bgzb",document.head);p=R(M,"META",{name:!0,content:!0}),M.forEach(t),Jl=D(l),jl=R(l,"P",{}),yM(jl).forEach(t),pl=D(l),n(i.$$.fragment,l),il=D(l),y=R(l,"P",{"data-svelte-h":!0}),C(y)!=="svelte-13cghrt"&&(y.innerHTML=oM),yl=D(l),w=R(l,"P",{"data-svelte-h":!0}),C(w)!=="svelte-5gu2f"&&(w.innerHTML=kM),wl=D(l),o=R(l,"P",{"data-svelte-h":!0}),C(o)!=="svelte-y2uq6w"&&(o.innerHTML=IM),ol=D(l),k=R(l,"P",{"data-svelte-h":!0}),C(k)!=="svelte-1s3q477"&&(k.textContent=mM),kl=D(l),n(I.$$.fragment,l),Il=D(l),m=R(l,"IMG",{src:!0,alt:!0}),ml=D(l),r=R(l,"P",{"data-svelte-h":!0}),C(r)!=="svelte-1oe96a3"&&(r.innerHTML=TM),rl=D(l),T=R(l,"P",{"data-svelte-h":!0}),C(T)!=="svelte-xmzozo"&&(T.textContent=cM),Tl=D(l),c=R(l,"P",{"data-svelte-h":!0}),C(c)!=="svelte-qkt2tx"&&(c.innerHTML=SM),cl=D(l),S=R(l,"P",{"data-svelte-h":!0}),C(S)!=="svelte-1c60q2l"&&(S.innerHTML=uM),Sl=D(l),u=R(l,"P",{"data-svelte-h":!0}),C(u)!=="svelte-1yzzdiv"&&(u.textContent=OM),ul=D(l),O=R(l,"P",{"data-svelte-h":!0}),C(O)!=="svelte-1xhi54d"&&(O.innerHTML=gM),Ol=D(l),g=R(l,"P",{"data-svelte-h":!0}),C(g)!=="svelte-1l9vn1"&&(g.innerHTML=bM),gl=D(l),Q=R(l,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),yM(Q).forEach(t),bl=D(l),b=R(l,"P",{"data-svelte-h":!0}),C(b)!=="svelte-1l679en"&&(b.textContent=dM),hl=D(l),n(h.$$.fragment,l),dl=D(l),d=R(l,"P",{"data-svelte-h":!0}),C(d)!=="svelte-1x7ip0e"&&(d.innerHTML=fM),fl=D(l),f=R(l,"BLOCKQUOTE",{"data-svelte-h":!0}),C(f)!=="svelte-vr0uy0"&&(f.innerHTML=xM),xl=D(l),x=R(l,"P",{"data-svelte-h":!0}),C(x)!=="svelte-8cez41"&&(x.innerHTML=BM),Bl=D(l),B=R(l,"IMG",{src:!0,alt:!0}),vl=D(l),v=R(l,"P",{"data-svelte-h":!0}),C(v)!=="svelte-1x9v6km"&&(v.innerHTML=_M),_l=D(l),_=R(l,"P",{"data-svelte-h":!0}),C(_)!=="svelte-1r17c4f"&&(_.textContent=NM),Nl=D(l),N=R(l,"UL",{"data-svelte-h":!0}),C(N)!=="svelte-1gloaak"&&(N.innerHTML=HM),Hl=D(l),n(H.$$.fragment,l),Wl=D(l),W=R(l,"P",{"data-svelte-h":!0}),C(W)!=="svelte-ht95kn"&&(W.innerHTML=WM),Zl=D(l),n(Z.$$.fragment,l),zl=D(l),z=R(l,"P",{"data-svelte-h":!0}),C(z)!=="svelte-1bmgy8u"&&(z.innerHTML=ZM),Gl=D(l),n(G.$$.fragment,l),Yl=D(l),Y=R(l,"P",{"data-svelte-h":!0}),C(Y)!=="svelte-1904qqr"&&(Y.textContent=zM),Fl=D(l),F=R(l,"OL",{"data-svelte-h":!0}),C(F)!=="svelte-w2qog7"&&(F.innerHTML=GM),Xl=D(l),X=R(l,"P",{"data-svelte-h":!0}),C(X)!=="svelte-shhtj2"&&(X.textContent=YM),$l=D(l),$=R(l,"OL",{"data-svelte-h":!0}),C($)!=="svelte-fevusz"&&($.innerHTML=FM),Ll=D(l),n(L.$$.fragment,l),ql=D(l),q=R(l,"P",{"data-svelte-h":!0}),C(q)!=="svelte-1bwakwg"&&(q.innerHTML=XM),Pl=D(l),n(P.$$.fragment,l),Kl=D(l),K=R(l,"P",{"data-svelte-h":!0}),C(K)!=="svelte-k0g7ji"&&(K.innerHTML=$M),lM=D(l),ll=R(l,"P",{"data-svelte-h":!0}),C(ll)!=="svelte-15kq4xi"&&(ll.innerHTML=LM),MM=D(l),Ml=R(l,"P",{"data-svelte-h":!0}),C(Ml)!=="svelte-1ac67pm"&&(Ml.innerHTML=qM),tM=D(l),tl=R(l,"P",{"data-svelte-h":!0}),C(tl)!=="svelte-1cgtb5z"&&(tl.innerHTML=PM),sM=D(l),sl=R(l,"P",{"data-svelte-h":!0}),C(sl)!=="svelte-1ads84"&&(sl.textContent=KM),eM=D(l),n(el.$$.fragment,l),DM=D(l),Dl=R(l,"P",{"data-svelte-h":!0}),C(Dl)!=="svelte-6hqmll"&&(Dl.innerHTML=lt),UM=D(l),Ul=R(l,"P",{"data-svelte-h":!0}),C(Ul)!=="svelte-ueil6z"&&(Ul.innerHTML=Mt),RM=D(l),Rl=R(l,"P",{"data-svelte-h":!0}),C(Rl)!=="svelte-1ket0yy"&&(Rl.innerHTML=tt),CM=D(l),QM=R(l,"HR",{}),EM=D(l),Cl=R(l,"P",{"data-svelte-h":!0}),C(Cl)!=="svelte-10851b7"&&(Cl.textContent=st),AM=D(l),Ql=R(l,"P",{"data-svelte-h":!0}),C(Ql)!=="svelte-172vnxc"&&(Ql.textContent=et),nM=D(l),El=R(l,"P",{"data-svelte-h":!0}),C(El)!=="svelte-bubc2z"&&(El.textContent=Dt),jM=D(l),Al=R(l,"P",{"data-svelte-h":!0}),C(Al)!=="svelte-u6mr6m"&&(Al.textContent=Ut),aM=D(l),n(nl.$$.fragment,l),VM=D(l),al=R(l,"P",{}),yM(al).forEach(t),this.h()},h(){E(p,"name","hf:doc:metadata"),E(p,"content",Jt),iM(m.src,rM="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||E(m,"src",rM),E(m,"alt","smolagents"),E(Q,"width","560"),E(Q,"height","315"),iM(Q.src,hM="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||E(Q,"src",hM),E(Q,"title","Видеоплеер YouTube"),E(Q,"frameborder","0"),E(Q,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),E(Q,"referrerpolicy","strict-origin-when-cross-origin"),Q.allowFullscreen="",iM(B.src,vM="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||E(B,"src",vM),E(B,"alt","Дубликат")},m(l,M){jt(document.head,p),s(l,Jl,M),s(l,jl,M),s(l,pl,M),j(i,l,M),s(l,il,M),s(l,y,M),s(l,yl,M),s(l,w,M),s(l,wl,M),s(l,o,M),s(l,ol,M),s(l,k,M),s(l,kl,M),j(I,l,M),s(l,Il,M),s(l,m,M),s(l,ml,M),s(l,r,M),s(l,rl,M),s(l,T,M),s(l,Tl,M),s(l,c,M),s(l,cl,M),s(l,S,M),s(l,Sl,M),s(l,u,M),s(l,ul,M),s(l,O,M),s(l,Ol,M),s(l,g,M),s(l,gl,M),s(l,Q,M),s(l,bl,M),s(l,b,M),s(l,hl,M),j(h,l,M),s(l,dl,M),s(l,d,M),s(l,fl,M),s(l,f,M),s(l,xl,M),s(l,x,M),s(l,Bl,M),s(l,B,M),s(l,vl,M),s(l,v,M),s(l,_l,M),s(l,_,M),s(l,Nl,M),s(l,N,M),s(l,Hl,M),j(H,l,M),s(l,Wl,M),s(l,W,M),s(l,Zl,M),j(Z,l,M),s(l,zl,M),s(l,z,M),s(l,Gl,M),j(G,l,M),s(l,Yl,M),s(l,Y,M),s(l,Fl,M),s(l,F,M),s(l,Xl,M),s(l,X,M),s(l,$l,M),s(l,$,M),s(l,Ll,M),j(L,l,M),s(l,ql,M),s(l,q,M),s(l,Pl,M),j(P,l,M),s(l,Kl,M),s(l,K,M),s(l,lM,M),s(l,ll,M),s(l,MM,M),s(l,Ml,M),s(l,tM,M),s(l,tl,M),s(l,sM,M),s(l,sl,M),s(l,eM,M),j(el,l,M),s(l,DM,M),s(l,Dl,M),s(l,UM,M),s(l,Ul,M),s(l,RM,M),s(l,Rl,M),s(l,CM,M),s(l,QM,M),s(l,EM,M),s(l,Cl,M),s(l,AM,M),s(l,Ql,M),s(l,nM,M),s(l,El,M),s(l,jM,M),s(l,Al,M),s(l,aM,M),j(nl,l,M),s(l,VM,M),s(l,al,M),JM=!0},p:Ct,i(l){JM||(a(i.$$.fragment,l),a(I.$$.fragment,l),a(h.$$.fragment,l),a(H.$$.fragment,l),a(Z.$$.fragment,l),a(G.$$.fragment,l),a(L.$$.fragment,l),a(P.$$.fragment,l),a(el.$$.fragment,l),a(nl.$$.fragment,l),JM=!0)},o(l){V(i.$$.fragment,l),V(I.$$.fragment,l),V(h.$$.fragment,l),V(H.$$.fragment,l),V(Z.$$.fragment,l),V(G.$$.fragment,l),V(L.$$.fragment,l),V(P.$$.fragment,l),V(el.$$.fragment,l),V(nl.$$.fragment,l),JM=!1},d(l){l&&(t(Jl),t(jl),t(pl),t(il),t(y),t(yl),t(w),t(wl),t(o),t(ol),t(k),t(kl),t(Il),t(m),t(ml),t(r),t(rl),t(T),t(Tl),t(c),t(cl),t(S),t(Sl),t(u),t(ul),t(O),t(Ol),t(g),t(gl),t(Q),t(bl),t(b),t(hl),t(dl),t(d),t(fl),t(f),t(xl),t(x),t(Bl),t(B),t(vl),t(v),t(_l),t(_),t(Nl),t(N),t(Hl),t(Wl),t(W),t(Zl),t(zl),t(z),t(Gl),t(Yl),t(Y),t(Fl),t(F),t(Xl),t(X),t($l),t($),t(Ll),t(ql),t(q),t(Pl),t(Kl),t(K),t(lM),t(ll),t(MM),t(Ml),t(tM),t(tl),t(sM),t(sl),t(eM),t(DM),t(Dl),t(UM),t(Ul),t(RM),t(Rl),t(CM),t(QM),t(EM),t(Cl),t(AM),t(Ql),t(nM),t(El),t(jM),t(Al),t(aM),t(VM),t(al)),t(p),J(i,l),J(I,l),J(h,l),J(H,l),J(Z,l),J(G,l),J(L,l),J(P,l),J(el,l),J(nl,l)}}}const Jt='{"title":"Давайте создадим нашего первого агента с помощью smolagents","local":"давайте-создадим-нашего-первого-агента-с-помощью-smolagents","sections":[{"title":"Что такое smolagents?","local":"что-такое-smolagents","sections":[],"depth":2},{"title":"Давайте создадим нашего агента!","local":"давайте-создадим-нашего-агента","sections":[{"title":"Инструменты","local":"инструменты","sections":[],"depth":3},{"title":"Агент","local":"агент","sections":[],"depth":3}],"depth":2}],"depth":1}';function pt(wM){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends Et{constructor(p){super(),At(this,p,pt,Vt,Rt,{})}}export{kt as component};
