import{s as Kt,f as Dt,o as Pt,n as R}from"../chunks/scheduler.25b97de1.js";import{S as Ot,i as el,g as h,s as c,r as J,A as tl,h as y,f as s,c as d,j as Jt,u as T,x as f,k as _e,y as ll,a as n,v as w,d as b,t as U,w as j}from"../chunks/index.d9030fc9.js";import{T as N}from"../chunks/Tip.baa67368.js";import{C as X}from"../chunks/CodeBlock.e6cd0d95.js";import{H as P,E as sl}from"../chunks/EditOnGithub.91d95064.js";import{H as Tt,a as Ie}from"../chunks/HfOption.1e589c90.js";function al(g){let t,p='Hugging Face also provides <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a library dedicated to deploying and serving highly optimized LLMs for inference. It includes deployment-oriented optimization features not included in Transformers, such as continuous batching for increasing throughput and tensor parallelism for multi-GPU inference.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-utq275"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function nl(g){let t,p='Currently, only <a href="./model_doc/llama2">Llama</a> and a few other models support static kv-cache and <code>torch.compile</code>. Check <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">this issue</a> for a live model compatibility list.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1cpz1yf"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function ol(g){let t,p='Regardless of the strategy used with <code>torch.compile</code>, you can avoid shape-related recompilations if you left-pad your LLM inputs to a limited set of values. The <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a> is your friend!';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1m3bnto"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function il(g){let t,p='For a more advanced usage of the static cache, such as multi-turn conversations, we recommend instantiating and manipulating the cache object outside <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. See the advanced usage tab.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-hhuz7"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function rl(g){let t,p='For this example, let’s use the <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> model. All we need to do is to:',l,o,i="<li>Access the model’s <code>generation_config</code> attribute and set the <code>cache_implementation</code> to “static”;</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li>",r,u,v="And that’s it!",k,G,$,Z,I="Under the hood, <code>generate</code> will attempt to reuse the same cache object, removing the need for re-compilation at each call. Avoiding re-compilation is critical to get the most out of <code>torch.compile</code>, and you should be aware of the following:",F,C,V="<li>If the batch size changes or the maximum output length increases between calls, the cache will have to be reinitialized, triggering a new compilation;</li> <li>The first couple of calls of the compiled function are slower, as the function is being compiled.</li>",z,B,W;return G=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),B=new N({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:g}}}),{c(){t=h("p"),t.innerHTML=p,l=c(),o=h("ol"),o.innerHTML=i,r=c(),u=h("p"),u.textContent=v,k=c(),J(G.$$.fragment),$=c(),Z=h("p"),Z.innerHTML=I,F=c(),C=h("ol"),C.innerHTML=V,z=c(),J(B.$$.fragment)},l(M){t=y(M,"P",{"data-svelte-h":!0}),f(t)!=="svelte-oys3sj"&&(t.innerHTML=p),l=d(M),o=y(M,"OL",{"data-svelte-h":!0}),f(o)!=="svelte-1fw1ivc"&&(o.innerHTML=i),r=d(M),u=y(M,"P",{"data-svelte-h":!0}),f(u)!=="svelte-9wooxy"&&(u.textContent=v),k=d(M),T(G.$$.fragment,M),$=d(M),Z=y(M,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-yth3sl"&&(Z.innerHTML=I),F=d(M),C=y(M,"OL",{"data-svelte-h":!0}),f(C)!=="svelte-u5kopl"&&(C.innerHTML=V),z=d(M),T(B.$$.fragment,M)},m(M,m){n(M,t,m),n(M,l,m),n(M,o,m),n(M,r,m),n(M,u,m),n(M,k,m),w(G,M,m),n(M,$,m),n(M,Z,m),n(M,F,m),n(M,C,m),n(M,z,m),w(B,M,m),W=!0},p(M,m){const _={};m&2&&(_.$$scope={dirty:m,ctx:M}),B.$set(_)},i(M){W||(b(G.$$.fragment,M),b(B.$$.fragment,M),W=!0)},o(M){U(G.$$.fragment,M),U(B.$$.fragment,M),W=!1},d(M){M&&(s(t),s(l),s(o),s(r),s(u),s(k),s($),s(Z),s(F),s(C),s(z)),j(G,M),j(B,M)}}}function pl(g){let t,p='If you want to reuse the same <a href="/docs/transformers/pr_30962/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object on a new prompt, be sure to reset its contents with the <code>.reset()</code> method between calls';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1wz8mlh"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function cl(g){let t,p='A <a href="/docs/transformers/pr_30962/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can be passed to the model’s <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> under the <code>past_key_values</code> argument. The object will retain the cache contents, so you can pass it to a new <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> call to continue generation, like you would do with a dynamic cache.',l,o,i,r,u,v,k='If you want to go further down a level, the <a href="/docs/transformers/pr_30962/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can also be passed to the model’s forward pass under the same <code>past_key_values</code> argument. Using this strategy, you can write your own function to decode the next token given the current token and position and cache position of previously generated tokens.',G,$,Z,I,F="There are a few important things you must do to enable static kv-cache and <code>torch.compile</code> with the <code>StaticCache</code> method:",C,V,z='<li>Initialize the <a href="/docs/transformers/pr_30962/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> instance before using the model for inference. There you can configure parameters like the maximum batch size and sequence length.</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li> <li>Set <code>enable_math=True</code> in the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</li>',B,W,M;return o=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    max_batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># If you plan to reuse the cache, make sure the cache length is large enough for all cases</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># pass in the generated text and the same cache object to continue generation from where it left off. Optionally, in a</span>
<span class="hljs-comment"># multi-turn conversation, append the new user input to the generated text.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),r=new N({props:{warning:!1,$$slots:{default:[pl]},$$scope:{ctx:g}}}),$=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),W=new X({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, max_batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),J(o.$$.fragment),i=c(),J(r.$$.fragment),u=c(),v=h("p"),v.innerHTML=k,G=c(),J($.$$.fragment),Z=c(),I=h("p"),I.innerHTML=F,C=c(),V=h("ol"),V.innerHTML=z,B=c(),J(W.$$.fragment)},l(m){t=y(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-l6suix"&&(t.innerHTML=p),l=d(m),T(o.$$.fragment,m),i=d(m),T(r.$$.fragment,m),u=d(m),v=y(m,"P",{"data-svelte-h":!0}),f(v)!=="svelte-be0lff"&&(v.innerHTML=k),G=d(m),T($.$$.fragment,m),Z=d(m),I=y(m,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1haj213"&&(I.innerHTML=F),C=d(m),V=y(m,"OL",{"data-svelte-h":!0}),f(V)!=="svelte-bsije6"&&(V.innerHTML=z),B=d(m),T(W.$$.fragment,m)},m(m,_){n(m,t,_),n(m,l,_),w(o,m,_),n(m,i,_),w(r,m,_),n(m,u,_),n(m,v,_),n(m,G,_),w($,m,_),n(m,Z,_),n(m,I,_),n(m,C,_),n(m,V,_),n(m,B,_),w(W,m,_),M=!0},p(m,_){const H={};_&2&&(H.$$scope={dirty:_,ctx:m}),r.$set(H)},i(m){M||(b(o.$$.fragment,m),b(r.$$.fragment,m),b($.$$.fragment,m),b(W.$$.fragment,m),M=!0)},o(m){U(o.$$.fragment,m),U(r.$$.fragment,m),U($.$$.fragment,m),U(W.$$.fragment,m),M=!1},d(m){m&&(s(t),s(l),s(i),s(u),s(v),s(G),s(Z),s(I),s(C),s(V),s(B)),j(o,m),j(r,m),j($,m),j(W,m)}}}function dl(g){let t,p="Compiling the entire <code>generate</code> function, in terms of code, is even simpler than in the basic usage: call <code>torch.compile</code> on <code>generate</code> to compile the entire function. No need to specify the use of the static cache: although it is compatible, dynamic cache (default) was faster in our benchmarks.",l,o,i,r,u="As a result, we compile not only the model forward pass, but also all input preparation, logit processor operations, and so on. The result should be a slightly <code>generate</code> call, compared to the basic usage example, and the compiled graph may be better suited to more exotic hardware devices or use cases. However, there are severe drawbacks in using this approach:",v,k,G="<li>Compilation is much slower;</li> <li>All parameterization of <code>generate</code> must be done through <code>generation_config</code>;</li> <li>Many warnings and exceptions are suppressed — we suggest testing with its uncompiled form first;</li> <li>Although we are working on it, it is heavily feature restricted (for instance, at the time of writing, generation does not stop if an EOS token is selected).</li>",$;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),J(o.$$.fragment),i=c(),r=h("p"),r.innerHTML=u,v=c(),k=h("ol"),k.innerHTML=G},l(Z){t=y(Z,"P",{"data-svelte-h":!0}),f(t)!=="svelte-5smhof"&&(t.innerHTML=p),l=d(Z),T(o.$$.fragment,Z),i=d(Z),r=y(Z,"P",{"data-svelte-h":!0}),f(r)!=="svelte-1sxxqo6"&&(r.innerHTML=u),v=d(Z),k=y(Z,"OL",{"data-svelte-h":!0}),f(k)!=="svelte-tj5w3v"&&(k.innerHTML=G)},m(Z,I){n(Z,t,I),n(Z,l,I),w(o,Z,I),n(Z,i,I),n(Z,r,I),n(Z,v,I),n(Z,k,I),$=!0},p:R,i(Z){$||(b(o.$$.fragment,Z),$=!0)},o(Z){U(o.$$.fragment,Z),$=!1},d(Z){Z&&(s(t),s(l),s(i),s(r),s(v),s(k)),j(o,Z)}}}function ml(g){let t,p,l,o,i,r;return t=new Ie({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[rl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[cl]},$$scope:{ctx:g}}}),i=new Ie({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[dl]},$$scope:{ctx:g}}}),{c(){J(t.$$.fragment),p=c(),J(l.$$.fragment),o=c(),J(i.$$.fragment)},l(u){T(t.$$.fragment,u),p=d(u),T(l.$$.fragment,u),o=d(u),T(i.$$.fragment,u)},m(u,v){w(t,u,v),n(u,p,v),w(l,u,v),n(u,o,v),w(i,u,v),r=!0},p(u,v){const k={};v&2&&(k.$$scope={dirty:v,ctx:u}),t.$set(k);const G={};v&2&&(G.$$scope={dirty:v,ctx:u}),l.$set(G);const $={};v&2&&($.$$scope={dirty:v,ctx:u}),i.$set($)},i(u){r||(b(t.$$.fragment,u),b(l.$$.fragment,u),b(i.$$.fragment,u),r=!0)},o(u){U(t.$$.fragment,u),U(l.$$.fragment,u),U(i.$$.fragment,u),r=!1},d(u){u&&(s(p),s(o)),j(t,u),j(l,u),j(i,u)}}}function ul(g){let t,p='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-112w74b"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function Ml(g){let t,p="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it also doesn’t support batched inputs.";return{c(){t=h("p"),t.textContent=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-eq929k"&&(t.textContent=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function hl(g){let t,p;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){T(t.$$.fragment,l)},m(l,o){w(t,l,o),p=!0},p:R,i(l){p||(b(t.$$.fragment,l),p=!0)},o(l){U(t.$$.fragment,l),p=!1},d(l){j(t,l)}}}function yl(g){let t,p='For speculative sampling decoding, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method in addition to the assistant model.',l,o,i;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),J(o.$$.fragment)},l(r){t=y(r,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1oovo7b"&&(t.innerHTML=p),l=d(r),T(o.$$.fragment,r)},m(r,u){n(r,t,u),n(r,l,u),w(o,r,u),i=!0},p:R,i(r){i||(b(o.$$.fragment,r),i=!0)},o(r){U(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function fl(g){let t,p,l,o;return t=new Ie({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[hl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[yl]},$$scope:{ctx:g}}}),{c(){J(t.$$.fragment),p=c(),J(l.$$.fragment)},l(i){T(t.$$.fragment,i),p=d(i),T(l.$$.fragment,i)},m(i,r){w(t,i,r),n(i,p,r),w(l,i,r),o=!0},p(i,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:i}),t.$set(u);const v={};r&2&&(v.$$scope={dirty:r,ctx:i}),l.$set(v)},i(i){o||(b(t.$$.fragment,i),b(l.$$.fragment,i),o=!0)},o(i){U(t.$$.fragment,i),U(l.$$.fragment,i),o=!1},d(i){i&&s(p),j(t,i),j(l,i)}}}function Jl(g){let t,p;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){T(t.$$.fragment,l)},m(l,o){w(t,l,o),p=!0},p:R,i(l){p||(b(t.$$.fragment,l),p=!0)},o(l){U(t.$$.fragment,l),p=!1},d(l){j(t,l)}}}function Tl(g){let t,p='For prompt lookup decoding with sampling, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',l,o,i;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),J(o.$$.fragment)},l(r){t=y(r,"P",{"data-svelte-h":!0}),f(t)!=="svelte-oqoyfo"&&(t.innerHTML=p),l=d(r),T(o.$$.fragment,r)},m(r,u){n(r,t,u),n(r,l,u),w(o,r,u),i=!0},p:R,i(r){i||(b(o.$$.fragment,r),i=!0)},o(r){U(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function wl(g){let t,p,l,o;return t=new Ie({props:{id:"pld",option:"greedy decoding",$$slots:{default:[Jl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"pld",option:"sampling",$$slots:{default:[Tl]},$$scope:{ctx:g}}}),{c(){J(t.$$.fragment),p=c(),J(l.$$.fragment)},l(i){T(t.$$.fragment,i),p=d(i),T(l.$$.fragment,i)},m(i,r){w(t,i,r),n(i,p,r),w(l,i,r),o=!0},p(i,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:i}),t.$set(u);const v={};r&2&&(v.$$scope={dirty:r,ctx:i}),l.$set(v)},i(i){o||(b(t.$$.fragment,i),b(l.$$.fragment,i),o=!0)},o(i){U(t.$$.fragment,i),U(l.$$.fragment,i),o=!1},d(i){i&&s(p),j(t,i),j(l,i)}}}function bl(g){let t,p="SDPA supports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=h("p"),t.textContent=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-12yxz1f"&&(t.textContent=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function Ul(g){let t,p='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1b7gbou"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:R,d(l){l&&s(t)}}}function jl(g){let t,p,l,o,i,r,u,v="Large language models (LLMs) have pushed text generation applications, such as chat and code completion models, to the next level by producing text that displays a high level of understanding and fluency. But what makes LLMs so powerful - namely their size - also presents challenges for inference.",k,G,$="Basic inference is slow because LLMs have to be called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer for the LLM to process. LLMs also have billions of parameters, making it a challenge to store and handle all those weights in memory.",Z,I,F="This guide will show you how to use the optimization techniques available in Transformers to accelerate LLM inference.",C,V,z,B,W,M,m="During decoding, a LLM computes the key-value (kv) values for each input token and since it is autoregressive, it computes the same kv values each time because the generated output becomes part of the input now. This is not very efficient because you’re recomputing the same kv values each time.",_,H,wt='To optimize this, you can use a kv-cache to store the past keys and values instead of recomputing them each time. However, since the kv-cache grows with each generation step and is dynamic, it prevents you from taking advantage of <a href="./perf_torch_compile"><code>torch.compile</code></a>, a powerful optimization tool that fuses PyTorch code into fast and optimized kernels.',$e,O,bt="The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value which allows you to combine it with <code>torch.compile</code> for up to a 4x speed up. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware.",Be,Q,Ve,ee,Ut="There are three flavors of static kv-cache usage, depending on the complexity of your task:",Ce,te,jt="<li>Basic usage: simply set a flag in <code>generation_config</code> (recommended);</li> <li>Advanced usage: handle a cache object for multi-turn generation or a custom generation loop;</li> <li>Advanced usage: compile the entire <code>generate</code> function into a single graph, if having a single graph is relevant for you.</li>",We,le,gt="Select the correct tab below for further instructions on each of these flavors.",Re,x,Xe,E,ze,se,Fe,S,He,ae,Zt="Another issue with autoregression is that for each input token you need to load the model weights each time during the forward pass. This is slow and cumbersome for LLMs which have billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger LLM in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",Ye,ne,vt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",Ne,L,Qe,oe,Gt='Enable speculative decoding by loading an assistant model and passing it to the <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',xe,q,Ee,ie,Se,re,It="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",Le,pe,_t='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <code>prompt_lookup_num_tokens</code> parameter. Then you can pass this parameter to the <a href="/docs/transformers/pr_30962/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',qe,A,Ae,ce,Ke,de,kt="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations and can accelerate inference.",De,me,Pe,ue,$t='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',Oe,Me,Bt='To use FlashAttention-2, set <code>attn_implementation=&quot;flash_attention_2&quot;</code> in the <a href="/docs/transformers/pr_30962/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method.',et,he,tt,ye,lt,fe,Vt="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",st,K,at,Je,Ct='Use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to explicitly enable or disable any of the three attention algorithms. For example, set <code>enable_flash=True</code> to enable FlashAttention.',nt,Te,ot,we,it,be,Wt="Quantization reduces the size of the LLM weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by your GPUs memory. If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can incur a small latency cost (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",rt,D,pt,Ue,Rt='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating how much memory it costs to load <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',ct,Y,Xt,dt,je,zt='To load Mistral-7B-v0.1 in half-precision, set the <code>torch_dtype</code> parameter in the <a href="/docs/transformers/pr_30962/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',mt,ge,ut,Ze,Ft='To load a quantized model (8-bit or 4-bit) for inference, try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <code>load_in_4bit</code> or <code>load_in_8bit</code> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',Mt,ve,ht,Ge,yt,ke,ft;return i=new P({props:{title:"LLM inference optimization",local:"llm-inference-optimization",headingTag:"h1"}}),V=new N({props:{warning:!1,$$slots:{default:[al]},$$scope:{ctx:g}}}),B=new P({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),Q=new N({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:g}}}),x=new N({props:{warning:!1,$$slots:{default:[ol]},$$scope:{ctx:g}}}),E=new Tt({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[ml]},$$scope:{ctx:g}}}),se=new P({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h2"}}),S=new N({props:{warning:!1,$$slots:{default:[ul]},$$scope:{ctx:g}}}),L=new N({props:{warning:!0,$$slots:{default:[Ml]},$$scope:{ctx:g}}}),q=new Tt({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[fl]},$$scope:{ctx:g}}}),ie=new P({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),A=new Tt({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[wl]},$$scope:{ctx:g}}}),ce=new P({props:{title:"Attention optimizations",local:"attention-optimizations",headingTag:"h2"}}),me=new P({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),he=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),ye=new P({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),K=new N({props:{warning:!1,$$slots:{default:[bl]},$$scope:{ctx:g}}}),Te=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),we=new P({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),D=new N({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:g}}}),ge=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),ve=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Ge=new sl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=h("meta"),p=c(),l=h("p"),o=c(),J(i.$$.fragment),r=c(),u=h("p"),u.textContent=v,k=c(),G=h("p"),G.textContent=$,Z=c(),I=h("p"),I.textContent=F,C=c(),J(V.$$.fragment),z=c(),J(B.$$.fragment),W=c(),M=h("p"),M.textContent=m,_=c(),H=h("p"),H.innerHTML=wt,$e=c(),O=h("p"),O.innerHTML=bt,Be=c(),J(Q.$$.fragment),Ve=c(),ee=h("p"),ee.textContent=Ut,Ce=c(),te=h("ol"),te.innerHTML=jt,We=c(),le=h("p"),le.textContent=gt,Re=c(),J(x.$$.fragment),Xe=c(),J(E.$$.fragment),ze=c(),J(se.$$.fragment),Fe=c(),J(S.$$.fragment),He=c(),ae=h("p"),ae.textContent=Zt,Ye=c(),ne=h("p"),ne.textContent=vt,Ne=c(),J(L.$$.fragment),Qe=c(),oe=h("p"),oe.innerHTML=Gt,xe=c(),J(q.$$.fragment),Ee=c(),J(ie.$$.fragment),Se=c(),re=h("p"),re.textContent=It,Le=c(),pe=h("p"),pe.innerHTML=_t,qe=c(),J(A.$$.fragment),Ae=c(),J(ce.$$.fragment),Ke=c(),de=h("p"),de.textContent=kt,De=c(),J(me.$$.fragment),Pe=c(),ue=h("p"),ue.innerHTML=$t,Oe=c(),Me=h("p"),Me.innerHTML=Bt,et=c(),J(he.$$.fragment),tt=c(),J(ye.$$.fragment),lt=c(),fe=h("p"),fe.textContent=Vt,st=c(),J(K.$$.fragment),at=c(),Je=h("p"),Je.innerHTML=Ct,nt=c(),J(Te.$$.fragment),ot=c(),J(we.$$.fragment),it=c(),be=h("p"),be.textContent=Wt,rt=c(),J(D.$$.fragment),pt=c(),Ue=h("p"),Ue.innerHTML=Rt,ct=c(),Y=h("iframe"),dt=c(),je=h("p"),je.innerHTML=zt,mt=c(),J(ge.$$.fragment),ut=c(),Ze=h("p"),Ze.innerHTML=Ft,Mt=c(),J(ve.$$.fragment),ht=c(),J(Ge.$$.fragment),yt=c(),ke=h("p"),this.h()},l(e){const a=tl("svelte-u9bgzb",document.head);t=y(a,"META",{name:!0,content:!0}),a.forEach(s),p=d(e),l=y(e,"P",{}),Jt(l).forEach(s),o=d(e),T(i.$$.fragment,e),r=d(e),u=y(e,"P",{"data-svelte-h":!0}),f(u)!=="svelte-1kjw8nj"&&(u.textContent=v),k=d(e),G=y(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1l3iyos"&&(G.textContent=$),Z=d(e),I=y(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1wb7yan"&&(I.textContent=F),C=d(e),T(V.$$.fragment,e),z=d(e),T(B.$$.fragment,e),W=d(e),M=y(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-bq37ce"&&(M.textContent=m),_=d(e),H=y(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1cg6awh"&&(H.innerHTML=wt),$e=d(e),O=y(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-jt9td8"&&(O.innerHTML=bt),Be=d(e),T(Q.$$.fragment,e),Ve=d(e),ee=y(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1439wi2"&&(ee.textContent=Ut),Ce=d(e),te=y(e,"OL",{"data-svelte-h":!0}),f(te)!=="svelte-165n3j5"&&(te.innerHTML=jt),We=d(e),le=y(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-etip6m"&&(le.textContent=gt),Re=d(e),T(x.$$.fragment,e),Xe=d(e),T(E.$$.fragment,e),ze=d(e),T(se.$$.fragment,e),Fe=d(e),T(S.$$.fragment,e),He=d(e),ae=y(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-18z9bzk"&&(ae.textContent=Zt),Ye=d(e),ne=y(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1nm1j4o"&&(ne.textContent=vt),Ne=d(e),T(L.$$.fragment,e),Qe=d(e),oe=y(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-1y4yshh"&&(oe.innerHTML=Gt),xe=d(e),T(q.$$.fragment,e),Ee=d(e),T(ie.$$.fragment,e),Se=d(e),re=y(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-123yl06"&&(re.textContent=It),Le=d(e),pe=y(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-15lluye"&&(pe.innerHTML=_t),qe=d(e),T(A.$$.fragment,e),Ae=d(e),T(ce.$$.fragment,e),Ke=d(e),de=y(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-zxt0p7"&&(de.textContent=kt),De=d(e),T(me.$$.fragment,e),Pe=d(e),ue=y(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-pa091d"&&(ue.innerHTML=$t),Oe=d(e),Me=y(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-ur7qqw"&&(Me.innerHTML=Bt),et=d(e),T(he.$$.fragment,e),tt=d(e),T(ye.$$.fragment,e),lt=d(e),fe=y(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-16n93px"&&(fe.textContent=Vt),st=d(e),T(K.$$.fragment,e),at=d(e),Je=y(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-cbkj1o"&&(Je.innerHTML=Ct),nt=d(e),T(Te.$$.fragment,e),ot=d(e),T(we.$$.fragment,e),it=d(e),be=y(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-x4c749"&&(be.textContent=Wt),rt=d(e),T(D.$$.fragment,e),pt=d(e),Ue=y(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1i2aaqz"&&(Ue.innerHTML=Rt),ct=d(e),Y=y(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Jt(Y).forEach(s),dt=d(e),je=y(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-1fg10gb"&&(je.innerHTML=zt),mt=d(e),T(ge.$$.fragment,e),ut=d(e),Ze=y(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-a32zwr"&&(Ze.innerHTML=Ft),Mt=d(e),T(ve.$$.fragment,e),ht=d(e),T(Ge.$$.fragment,e),yt=d(e),ke=y(e,"P",{}),Jt(ke).forEach(s),this.h()},h(){_e(t,"name","hf:doc:metadata"),_e(t,"content",gl),Dt(Y.src,Xt="https://hf-accelerate-model-memory-usage.hf.space")||_e(Y,"src",Xt),_e(Y,"frameborder","0"),_e(Y,"width","850"),_e(Y,"height","450")},m(e,a){ll(document.head,t),n(e,p,a),n(e,l,a),n(e,o,a),w(i,e,a),n(e,r,a),n(e,u,a),n(e,k,a),n(e,G,a),n(e,Z,a),n(e,I,a),n(e,C,a),w(V,e,a),n(e,z,a),w(B,e,a),n(e,W,a),n(e,M,a),n(e,_,a),n(e,H,a),n(e,$e,a),n(e,O,a),n(e,Be,a),w(Q,e,a),n(e,Ve,a),n(e,ee,a),n(e,Ce,a),n(e,te,a),n(e,We,a),n(e,le,a),n(e,Re,a),w(x,e,a),n(e,Xe,a),w(E,e,a),n(e,ze,a),w(se,e,a),n(e,Fe,a),w(S,e,a),n(e,He,a),n(e,ae,a),n(e,Ye,a),n(e,ne,a),n(e,Ne,a),w(L,e,a),n(e,Qe,a),n(e,oe,a),n(e,xe,a),w(q,e,a),n(e,Ee,a),w(ie,e,a),n(e,Se,a),n(e,re,a),n(e,Le,a),n(e,pe,a),n(e,qe,a),w(A,e,a),n(e,Ae,a),w(ce,e,a),n(e,Ke,a),n(e,de,a),n(e,De,a),w(me,e,a),n(e,Pe,a),n(e,ue,a),n(e,Oe,a),n(e,Me,a),n(e,et,a),w(he,e,a),n(e,tt,a),w(ye,e,a),n(e,lt,a),n(e,fe,a),n(e,st,a),w(K,e,a),n(e,at,a),n(e,Je,a),n(e,nt,a),w(Te,e,a),n(e,ot,a),w(we,e,a),n(e,it,a),n(e,be,a),n(e,rt,a),w(D,e,a),n(e,pt,a),n(e,Ue,a),n(e,ct,a),n(e,Y,a),n(e,dt,a),n(e,je,a),n(e,mt,a),w(ge,e,a),n(e,ut,a),n(e,Ze,a),n(e,Mt,a),w(ve,e,a),n(e,ht,a),w(Ge,e,a),n(e,yt,a),n(e,ke,a),ft=!0},p(e,[a]){const Ht={};a&2&&(Ht.$$scope={dirty:a,ctx:e}),V.$set(Ht);const Yt={};a&2&&(Yt.$$scope={dirty:a,ctx:e}),Q.$set(Yt);const Nt={};a&2&&(Nt.$$scope={dirty:a,ctx:e}),x.$set(Nt);const Qt={};a&2&&(Qt.$$scope={dirty:a,ctx:e}),E.$set(Qt);const xt={};a&2&&(xt.$$scope={dirty:a,ctx:e}),S.$set(xt);const Et={};a&2&&(Et.$$scope={dirty:a,ctx:e}),L.$set(Et);const St={};a&2&&(St.$$scope={dirty:a,ctx:e}),q.$set(St);const Lt={};a&2&&(Lt.$$scope={dirty:a,ctx:e}),A.$set(Lt);const qt={};a&2&&(qt.$$scope={dirty:a,ctx:e}),K.$set(qt);const At={};a&2&&(At.$$scope={dirty:a,ctx:e}),D.$set(At)},i(e){ft||(b(i.$$.fragment,e),b(V.$$.fragment,e),b(B.$$.fragment,e),b(Q.$$.fragment,e),b(x.$$.fragment,e),b(E.$$.fragment,e),b(se.$$.fragment,e),b(S.$$.fragment,e),b(L.$$.fragment,e),b(q.$$.fragment,e),b(ie.$$.fragment,e),b(A.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(he.$$.fragment,e),b(ye.$$.fragment,e),b(K.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(D.$$.fragment,e),b(ge.$$.fragment,e),b(ve.$$.fragment,e),b(Ge.$$.fragment,e),ft=!0)},o(e){U(i.$$.fragment,e),U(V.$$.fragment,e),U(B.$$.fragment,e),U(Q.$$.fragment,e),U(x.$$.fragment,e),U(E.$$.fragment,e),U(se.$$.fragment,e),U(S.$$.fragment,e),U(L.$$.fragment,e),U(q.$$.fragment,e),U(ie.$$.fragment,e),U(A.$$.fragment,e),U(ce.$$.fragment,e),U(me.$$.fragment,e),U(he.$$.fragment,e),U(ye.$$.fragment,e),U(K.$$.fragment,e),U(Te.$$.fragment,e),U(we.$$.fragment,e),U(D.$$.fragment,e),U(ge.$$.fragment,e),U(ve.$$.fragment,e),U(Ge.$$.fragment,e),ft=!1},d(e){e&&(s(p),s(l),s(o),s(r),s(u),s(k),s(G),s(Z),s(I),s(C),s(z),s(W),s(M),s(_),s(H),s($e),s(O),s(Be),s(Ve),s(ee),s(Ce),s(te),s(We),s(le),s(Re),s(Xe),s(ze),s(Fe),s(He),s(ae),s(Ye),s(ne),s(Ne),s(Qe),s(oe),s(xe),s(Ee),s(Se),s(re),s(Le),s(pe),s(qe),s(Ae),s(Ke),s(de),s(De),s(Pe),s(ue),s(Oe),s(Me),s(et),s(tt),s(lt),s(fe),s(st),s(at),s(Je),s(nt),s(ot),s(it),s(be),s(rt),s(pt),s(Ue),s(ct),s(Y),s(dt),s(je),s(mt),s(ut),s(Ze),s(Mt),s(ht),s(yt),s(ke)),s(t),j(i,e),j(V,e),j(B,e),j(Q,e),j(x,e),j(E,e),j(se,e),j(S,e),j(L,e),j(q,e),j(ie,e),j(A,e),j(ce,e),j(me,e),j(he,e),j(ye,e),j(K,e),j(Te,e),j(we,e),j(D,e),j(ge,e),j(ve,e),j(Ge,e)}}}const gl='{"title":"LLM inference optimization","local":"llm-inference-optimization","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Speculative decoding","local":"speculative-decoding","sections":[{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention optimizations","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Zl(g){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends Ot{constructor(t){super(),el(this,t,Zl,jl,Kt,{})}}export{Bl as component};
