import{s as ht,o as ft,n as te}from"../chunks/scheduler.25b97de1.js";import{S as gt,i as _t,g as m,s as r,r as b,A as Tt,h as u,f as a,c as l,j as Te,u as y,x as T,k as pe,y as d,a as c,v as M,d as k,t as w,w as v}from"../chunks/index.d9030fc9.js";import{T as st}from"../chunks/Tip.baa67368.js";import{D as Je}from"../chunks/Docstring.e257edda.js";import{C as tt}from"../chunks/CodeBlock.e6cd0d95.js";import{F as bt,M as ut}from"../chunks/Markdown.7217f838.js";import{E as et}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Qe,E as yt}from"../chunks/EditOnGithub.91d95064.js";function Mt(C){let e,p="Examples:",t,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENUUkxDb25maWclMkMlMjBDVFJMTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ1RSTCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwQ1RSTENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDVFJMTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CTRLConfig, CTRLModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CTRL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CTRLConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-kvfsh7"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function kt(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function wt(C){let e,p="Example:",t,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDVFJMTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyT3BpbmlvbiUyME15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFhc3NlcnQlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIwJTJDJTIwMCU1RC5pdGVtKCklMjBpbiUyMHRva2VuaXplci5jb250cm9sX2NvZGVzLnZhbHVlcygpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, <span class="hljs-number">1280</span>]`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-11lpom8"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function vt(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function $t(C){let e,p="Example:",t,o,g;return o=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxMTUhlYWRNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTExNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyV2lraXBlZGlhJTIwVGhlJTIwbGxhbWElMjBpcyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBYXNzZXJ0JTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDAlNUQuaXRlbSgpJTIwaW4lMjB0b2tlbml6ZXIuY29udHJvbF9jb2Rlcy52YWx1ZXMoKSUwQSUwQXNlcXVlbmNlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFzZXF1ZW5jZXMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHNlcXVlbmNlX2lkcyklMEFzZXF1ZW5jZXMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBcm91bmQob3V0cHV0cy5sb3NzLml0ZW0oKSUyQyUyMDIpJTBBJTBBbGlzdChvdXRwdXRzLmxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLLMHeadModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Wikipedia The llama is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = tokenizer.batch_decode(sequence_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences
[<span class="hljs-string">&#x27;Wikipedia The llama is a member of the family Bovidae. It is native to the Andes of Peru,&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">9.21</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(outputs.logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, <span class="hljs-number">246534</span>]`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-11lpom8"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function Ct(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function Lt(C){let e,p="Example of single-label classification:",t,o,g;return o=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBJTIzJTIwQ1RSTCUyMHdhcyUyMHRyYWluZWQlMjB3aXRoJTIwY29udHJvbCUyMGNvZGVzJTIwYXMlMjB0aGUlMjBmaXJzdCUyMHRva2VuJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk9waW5pb24lMjBNeSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBYXNzZXJ0JTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDAlNUQuaXRlbSgpJTIwaW4lMjB0b2tlbml6ZXIuY29udHJvbF9jb2Rlcy52YWx1ZXMoKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_0&#x27;</span>`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-ykxpe4"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function jt(C){let e,p;return e=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyklMEElMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.93</span>`,wrap:!1}}),{c(){b(e.$$.fragment)},l(t){y(e.$$.fragment,t)},m(t,o){M(e,t,o),p=!0},p:te,i(t){p||(k(e.$$.fragment,t),p=!0)},o(t){w(e.$$.fragment,t),p=!1},d(t){v(e,t)}}}function Rt(C){let e,p="Example of multi-label classification:",t,o,g;return o=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiUwQSklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyT3BpbmlvbiUyME15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFhc3NlcnQlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIwJTJDJTIwMCU1RC5pdGVtKCklMjBpbiUyMHRva2VuaXplci5jb250cm9sX2NvZGVzLnZhbHVlcygpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_0&#x27;</span>`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-1l8e32d"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function xt(C){let e,p;return e=new tt({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyJTJDJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMpJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5vbmVfaG90KHRvcmNoLnRlbnNvciglNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKS50byglMEElMjAlMjAlMjAlMjB0b3JjaC5mbG9hdCUwQSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.nn.functional.one_hot(torch.tensor([predicted_class_id]), num_classes=num_labels).to(
<span class="hljs-meta">... </span>    torch.<span class="hljs-built_in">float</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){b(e.$$.fragment)},l(t){y(e.$$.fragment,t)},m(t,o){M(e,t,o),p=!0},p:te,i(t){p||(k(e.$$.fragment,t),p=!0)},o(t){w(e.$$.fragment,t),p=!1},d(t){v(e,t)}}}function Jt(C){let e,p,t,o,g,n,_="The bare CTRL Model transformer outputting raw hidden-states without any specific head on top.",ne,F,x=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,J,z=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Q,i,R,O,X,ot='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> forward method, overrides the <code>__call__</code> special method.',we,oe,nt,G,be,A,me,H,ue,N,se,Fe=`The CTRL Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Xe,ze,Ie=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ve,S,Ue=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,We,E,Ne,ye,he,de='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',$e,D,Ce,ae,Ge,U,Me,q,re,qe,Le,I=`The CTRL Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do. Since it does classification on the last token, it requires to know the position of the last
token. If a <code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in
each row. If no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot
guess the padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last
value in each row of the batch).`,He,Be,ke=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ze,je,ce=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oe,W,le,Pe,Re,s='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$,Z,P,Se,at,fe,rt,V,Ae,Ye,De;return e=new Qe({props:{title:"CTRLModel",local:"transformers.CTRLModel",headingTag:"h2"}}),o=new Je({props:{name:"class transformers.CTRLModel",anchor:"transformers.CTRLModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L310"}}),R=new Je({props:{name:"forward",anchor:"transformers.CTRLModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CTRLModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new st({props:{$$slots:{default:[kt]},$$scope:{ctx:C}}}),G=new et({props:{anchor:"transformers.CTRLModel.forward.example",$$slots:{default:[wt]},$$scope:{ctx:C}}}),A=new Qe({props:{title:"CTRLLMHeadModel",local:"transformers.CTRLLMHeadModel",headingTag:"h2"}}),ue=new Je({props:{name:"class transformers.CTRLLMHeadModel",anchor:"transformers.CTRLLMHeadModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L499"}}),Ne=new Je({props:{name:"forward",anchor:"transformers.CTRLLMHeadModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CTRLLMHeadModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLLMHeadModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLLMHeadModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLLMHeadModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLLMHeadModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLLMHeadModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLLMHeadModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLLMHeadModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CTRLLMHeadModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L539",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new st({props:{$$slots:{default:[vt]},$$scope:{ctx:C}}}),ae=new et({props:{anchor:"transformers.CTRLLMHeadModel.forward.example",$$slots:{default:[$t]},$$scope:{ctx:C}}}),U=new Qe({props:{title:"CTRLForSequenceClassification",local:"transformers.CTRLForSequenceClassification",headingTag:"h2"}}),re=new Je({props:{name:"class transformers.CTRLForSequenceClassification",anchor:"transformers.CTRLForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L645"}}),le=new Je({props:{name:"forward",anchor:"transformers.CTRLForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CTRLForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CTRLForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_ctrl.py#L667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new st({props:{$$slots:{default:[Ct]},$$scope:{ctx:C}}}),Se=new et({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example",$$slots:{default:[Lt]},$$scope:{ctx:C}}}),fe=new et({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-2",$$slots:{default:[jt]},$$scope:{ctx:C}}}),V=new et({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-3",$$slots:{default:[Rt]},$$scope:{ctx:C}}}),Ye=new et({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-4",$$slots:{default:[xt]},$$scope:{ctx:C}}}),{c(){b(e.$$.fragment),p=r(),t=m("div"),b(o.$$.fragment),g=r(),n=m("p"),n.textContent=_,ne=r(),F=m("p"),F.innerHTML=x,Y=r(),J=m("p"),J.innerHTML=z,Q=r(),i=m("div"),b(R.$$.fragment),O=r(),X=m("p"),X.innerHTML=ot,we=r(),b(oe.$$.fragment),nt=r(),b(G.$$.fragment),be=r(),b(A.$$.fragment),me=r(),H=m("div"),b(ue.$$.fragment),N=r(),se=m("p"),se.textContent=Fe,Xe=r(),ze=m("p"),ze.innerHTML=Ie,ve=r(),S=m("p"),S.innerHTML=Ue,We=r(),E=m("div"),b(Ne.$$.fragment),ye=r(),he=m("p"),he.innerHTML=de,$e=r(),b(D.$$.fragment),Ce=r(),b(ae.$$.fragment),Ge=r(),b(U.$$.fragment),Me=r(),q=m("div"),b(re.$$.fragment),qe=r(),Le=m("p"),Le.innerHTML=I,He=r(),Be=m("p"),Be.innerHTML=ke,Ze=r(),je=m("p"),je.innerHTML=ce,Oe=r(),W=m("div"),b(le.$$.fragment),Pe=r(),Re=m("p"),Re.innerHTML=s,$=r(),b(Z.$$.fragment),P=r(),b(Se.$$.fragment),at=r(),b(fe.$$.fragment),rt=r(),b(V.$$.fragment),Ae=r(),b(Ye.$$.fragment),this.h()},l(f){y(e.$$.fragment,f),p=l(f),t=u(f,"DIV",{class:!0});var j=Te(t);y(o.$$.fragment,j),g=l(j),n=u(j,"P",{"data-svelte-h":!0}),T(n)!=="svelte-418ah6"&&(n.textContent=_),ne=l(j),F=u(j,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1mute7d"&&(F.innerHTML=x),Y=l(j),J=u(j,"P",{"data-svelte-h":!0}),T(J)!=="svelte-hswkmf"&&(J.innerHTML=z),Q=l(j),i=u(j,"DIV",{class:!0});var K=Te(i);y(R.$$.fragment,K),O=l(K),X=u(K,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1pjr613"&&(X.innerHTML=ot),we=l(K),y(oe.$$.fragment,K),nt=l(K),y(G.$$.fragment,K),K.forEach(a),j.forEach(a),be=l(f),y(A.$$.fragment,f),me=l(f),H=u(f,"DIV",{class:!0});var ge=Te(H);y(ue.$$.fragment,ge),N=l(ge),se=u(ge,"P",{"data-svelte-h":!0}),T(se)!=="svelte-ej2g0g"&&(se.textContent=Fe),Xe=l(ge),ze=u(ge,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-1mute7d"&&(ze.innerHTML=Ie),ve=l(ge),S=u(ge,"P",{"data-svelte-h":!0}),T(S)!=="svelte-hswkmf"&&(S.innerHTML=Ue),We=l(ge),E=u(ge,"DIV",{class:!0});var ee=Te(E);y(Ne.$$.fragment,ee),ye=l(ee),he=u(ee,"P",{"data-svelte-h":!0}),T(he)!=="svelte-1mo3kj7"&&(he.innerHTML=de),$e=l(ee),y(D.$$.fragment,ee),Ce=l(ee),y(ae.$$.fragment,ee),ee.forEach(a),ge.forEach(a),Ge=l(f),y(U.$$.fragment,f),Me=l(f),q=u(f,"DIV",{class:!0});var _e=Te(q);y(re.$$.fragment,_e),qe=l(_e),Le=u(_e,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-7291fv"&&(Le.innerHTML=I),He=l(_e),Be=u(_e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-1mute7d"&&(Be.innerHTML=ke),Ze=l(_e),je=u(_e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-hswkmf"&&(je.innerHTML=ce),Oe=l(_e),W=u(_e,"DIV",{class:!0});var B=Te(W);y(le.$$.fragment,B),Pe=l(B),Re=u(B,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1we20jb"&&(Re.innerHTML=s),$=l(B),y(Z.$$.fragment,B),P=l(B),y(Se.$$.fragment,B),at=l(B),y(fe.$$.fragment,B),rt=l(B),y(V.$$.fragment,B),Ae=l(B),y(Ye.$$.fragment,B),B.forEach(a),_e.forEach(a),this.h()},h(){pe(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(f,j){M(e,f,j),c(f,p,j),c(f,t,j),M(o,t,null),d(t,g),d(t,n),d(t,ne),d(t,F),d(t,Y),d(t,J),d(t,Q),d(t,i),M(R,i,null),d(i,O),d(i,X),d(i,we),M(oe,i,null),d(i,nt),M(G,i,null),c(f,be,j),M(A,f,j),c(f,me,j),c(f,H,j),M(ue,H,null),d(H,N),d(H,se),d(H,Xe),d(H,ze),d(H,ve),d(H,S),d(H,We),d(H,E),M(Ne,E,null),d(E,ye),d(E,he),d(E,$e),M(D,E,null),d(E,Ce),M(ae,E,null),c(f,Ge,j),M(U,f,j),c(f,Me,j),c(f,q,j),M(re,q,null),d(q,qe),d(q,Le),d(q,He),d(q,Be),d(q,Ze),d(q,je),d(q,Oe),d(q,W),M(le,W,null),d(W,Pe),d(W,Re),d(W,$),M(Z,W,null),d(W,P),M(Se,W,null),d(W,at),M(fe,W,null),d(W,rt),M(V,W,null),d(W,Ae),M(Ye,W,null),De=!0},p(f,j){const K={};j&2&&(K.$$scope={dirty:j,ctx:f}),oe.$set(K);const ge={};j&2&&(ge.$$scope={dirty:j,ctx:f}),G.$set(ge);const ee={};j&2&&(ee.$$scope={dirty:j,ctx:f}),D.$set(ee);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:f}),ae.$set(_e);const B={};j&2&&(B.$$scope={dirty:j,ctx:f}),Z.$set(B);const lt={};j&2&&(lt.$$scope={dirty:j,ctx:f}),Se.$set(lt);const h={};j&2&&(h.$$scope={dirty:j,ctx:f}),fe.$set(h);const L={};j&2&&(L.$$scope={dirty:j,ctx:f}),V.$set(L);const Ve={};j&2&&(Ve.$$scope={dirty:j,ctx:f}),Ye.$set(Ve)},i(f){De||(k(e.$$.fragment,f),k(o.$$.fragment,f),k(R.$$.fragment,f),k(oe.$$.fragment,f),k(G.$$.fragment,f),k(A.$$.fragment,f),k(ue.$$.fragment,f),k(Ne.$$.fragment,f),k(D.$$.fragment,f),k(ae.$$.fragment,f),k(U.$$.fragment,f),k(re.$$.fragment,f),k(le.$$.fragment,f),k(Z.$$.fragment,f),k(Se.$$.fragment,f),k(fe.$$.fragment,f),k(V.$$.fragment,f),k(Ye.$$.fragment,f),De=!0)},o(f){w(e.$$.fragment,f),w(o.$$.fragment,f),w(R.$$.fragment,f),w(oe.$$.fragment,f),w(G.$$.fragment,f),w(A.$$.fragment,f),w(ue.$$.fragment,f),w(Ne.$$.fragment,f),w(D.$$.fragment,f),w(ae.$$.fragment,f),w(U.$$.fragment,f),w(re.$$.fragment,f),w(le.$$.fragment,f),w(Z.$$.fragment,f),w(Se.$$.fragment,f),w(fe.$$.fragment,f),w(V.$$.fragment,f),w(Ye.$$.fragment,f),De=!1},d(f){f&&(a(p),a(t),a(be),a(me),a(H),a(Ge),a(Me),a(q)),v(e,f),v(o),v(R),v(oe),v(G),v(A,f),v(ue),v(Ne),v(D),v(ae),v(U,f),v(re),v(le),v(Z),v(Se),v(fe),v(V),v(Ye)}}}function Ft(C){let e,p;return e=new ut({props:{$$slots:{default:[Jt]},$$scope:{ctx:C}}}),{c(){b(e.$$.fragment)},l(t){y(e.$$.fragment,t)},m(t,o){M(e,t,o),p=!0},p(t,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:t}),e.$set(g)},i(t){p||(k(e.$$.fragment,t),p=!0)},o(t){w(e.$$.fragment,t),p=!1},d(t){v(e,t)}}}function zt(C){let e,p="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,_,ne=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,x,Y=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,J,z,Q=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=m("p"),e.innerHTML=p,t=r(),o=m("ul"),o.innerHTML=g,n=r(),_=m("p"),_.innerHTML=ne,F=r(),x=m("ul"),x.innerHTML=Y,J=r(),z=m("p"),z.innerHTML=Q},l(i){e=u(i,"P",{"data-svelte-h":!0}),T(e)!=="svelte-1ajbfxg"&&(e.innerHTML=p),t=l(i),o=u(i,"UL",{"data-svelte-h":!0}),T(o)!=="svelte-qm1t26"&&(o.innerHTML=g),n=l(i),_=u(i,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1v9qsc5"&&(_.innerHTML=ne),F=l(i),x=u(i,"UL",{"data-svelte-h":!0}),T(x)!=="svelte-15scerc"&&(x.innerHTML=Y),J=l(i),z=u(i,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1an3odd"&&(z.innerHTML=Q)},m(i,R){c(i,e,R),c(i,t,R),c(i,o,R),c(i,n,R),c(i,_,R),c(i,F,R),c(i,x,R),c(i,J,R),c(i,z,R)},p:te,d(i){i&&(a(e),a(t),a(o),a(n),a(_),a(F),a(x),a(J),a(z))}}}function It(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function Ut(C){let e,p="Example:",t,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxNb2RlbCUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkNUUkxNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-11lpom8"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function Wt(C){let e,p="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,_,ne=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,x,Y=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,J,z,Q=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=m("p"),e.innerHTML=p,t=r(),o=m("ul"),o.innerHTML=g,n=r(),_=m("p"),_.innerHTML=ne,F=r(),x=m("ul"),x.innerHTML=Y,J=r(),z=m("p"),z.innerHTML=Q},l(i){e=u(i,"P",{"data-svelte-h":!0}),T(e)!=="svelte-1ajbfxg"&&(e.innerHTML=p),t=l(i),o=u(i,"UL",{"data-svelte-h":!0}),T(o)!=="svelte-qm1t26"&&(o.innerHTML=g),n=l(i),_=u(i,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1v9qsc5"&&(_.innerHTML=ne),F=l(i),x=u(i,"UL",{"data-svelte-h":!0}),T(x)!=="svelte-15scerc"&&(x.innerHTML=Y),J=l(i),z=u(i,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1an3odd"&&(z.innerHTML=Q)},m(i,R){c(i,e,R),c(i,t,R),c(i,o,R),c(i,n,R),c(i,_,R),c(i,F,R),c(i,x,R),c(i,J,R),c(i,z,R)},p:te,d(i){i&&(a(e),a(t),a(o),a(n),a(_),a(F),a(x),a(J),a(z))}}}function Nt(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function qt(C){let e,p="Example:",t,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxMTUhlYWRNb2RlbCUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkNUUkxMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLLMHeadModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLLMHeadModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-11lpom8"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function Ht(C){let e,p="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",t,o,g="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,_,ne=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,x,Y=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,J,z,Q=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=m("p"),e.innerHTML=p,t=r(),o=m("ul"),o.innerHTML=g,n=r(),_=m("p"),_.innerHTML=ne,F=r(),x=m("ul"),x.innerHTML=Y,J=r(),z=m("p"),z.innerHTML=Q},l(i){e=u(i,"P",{"data-svelte-h":!0}),T(e)!=="svelte-1ajbfxg"&&(e.innerHTML=p),t=l(i),o=u(i,"UL",{"data-svelte-h":!0}),T(o)!=="svelte-qm1t26"&&(o.innerHTML=g),n=l(i),_=u(i,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1v9qsc5"&&(_.innerHTML=ne),F=l(i),x=u(i,"UL",{"data-svelte-h":!0}),T(x)!=="svelte-15scerc"&&(x.innerHTML=Y),J=l(i),z=u(i,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1an3odd"&&(z.innerHTML=Q)},m(i,R){c(i,e,R),c(i,t,R),c(i,o,R),c(i,n,R),c(i,_,R),c(i,F,R),c(i,x,R),c(i,J,R),c(i,z,R)},p:te,d(i){i&&(a(e),a(t),a(o),a(n),a(_),a(F),a(x),a(J),a(z))}}}function Bt(C){let e,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=m("p"),e.innerHTML=p},l(t){e=u(t,"P",{"data-svelte-h":!0}),T(e)!=="svelte-fincs2"&&(e.innerHTML=p)},m(t,o){c(t,e,o)},p:te,d(t){t&&a(e)}}}function Zt(C){let e,p="Example:",t,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQ1RSTEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){e=m("p"),e.textContent=p,t=r(),b(o.$$.fragment)},l(n){e=u(n,"P",{"data-svelte-h":!0}),T(e)!=="svelte-11lpom8"&&(e.textContent=p),t=l(n),y(o.$$.fragment,n)},m(n,_){c(n,e,_),c(n,t,_),M(o,n,_),g=!0},p:te,i(n){g||(k(o.$$.fragment,n),g=!0)},o(n){w(o.$$.fragment,n),g=!1},d(n){n&&(a(e),a(t)),v(o,n)}}}function St(C){let e,p;return e=new tt({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwVEZDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyklMEElMEFsYWJlbHMlMjAlM0QlMjB0Zi5jb25zdGFudCgxKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on `num_labels` classes, you can pass `num_labels=num_labels` to `.from_pretrained(...)`</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)\n<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)\n\n<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.constant(<span class="hljs-number">1</span>)\n<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss',wrap:!1}}),{c(){b(e.$$.fragment)},l(t){y(e.$$.fragment,t)},m(t,o){M(e,t,o),p=!0},p:te,i(t){p||(k(e.$$.fragment,t),p=!0)},o(t){w(e.$$.fragment,t),p=!1},d(t){v(e,t)}}}function Vt(C){let e,p,t,o,g,n,_="The bare CTRL Model transformer outputting raw hidden-states without any specific head on top.",ne,F,x=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,J,z=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Q,i,R,O,X,ot,we,oe='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> forward method, overrides the <code>__call__</code> special method.',nt,G,be,A,me,H,ue,N,se,Fe,Xe,ze=`The CTRL Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Ie,ve,S=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ue,We,E=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Ne,ye,he,de,$e,D,Ce,ae='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Ge,U,Me,q,re,qe,Le,I,He,Be,ke,Ze="The CTRL Model transformer with a sequence classification head on top (linear layer).",je,ce,Oe=`<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1, GPT-2) do.`,W,le,Pe=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Re,s,$=`This model inherits from <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Z,P,Se=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,at,fe,rt,V,Ae,Ye,De,f='The <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',j,K,ge,ee,_e,B,lt;return e=new Qe({props:{title:"TFCTRLModel",local:"transformers.TFCTRLModel",headingTag:"h2"}}),o=new Je({props:{name:"class transformers.TFCTRLModel",anchor:"transformers.TFCTRLModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L578"}}),i=new st({props:{$$slots:{default:[zt]},$$scope:{ctx:C}}}),X=new Je({props:{name:"call",anchor:"transformers.TFCTRLModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLModel.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLModel.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L587",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),G=new st({props:{$$slots:{default:[It]},$$scope:{ctx:C}}}),A=new et({props:{anchor:"transformers.TFCTRLModel.call.example",$$slots:{default:[Ut]},$$scope:{ctx:C}}}),H=new Qe({props:{title:"TFCTRLLMHeadModel",local:"transformers.TFCTRLLMHeadModel",headingTag:"h2"}}),se=new Je({props:{name:"class transformers.TFCTRLLMHeadModel",anchor:"transformers.TFCTRLLMHeadModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L656"}}),ye=new st({props:{$$slots:{default:[Wt]},$$scope:{ctx:C}}}),$e=new Je({props:{name:"call",anchor:"transformers.TFCTRLLMHeadModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLLMHeadModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLLMHeadModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLLMHeadModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLLMHeadModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLLMHeadModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLLMHeadModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLLMHeadModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLLMHeadModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLLMHeadModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFCTRLLMHeadModel.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L715",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),U=new st({props:{$$slots:{default:[Nt]},$$scope:{ctx:C}}}),q=new et({props:{anchor:"transformers.TFCTRLLMHeadModel.call.example",$$slots:{default:[qt]},$$scope:{ctx:C}}}),qe=new Qe({props:{title:"TFCTRLForSequenceClassification",local:"transformers.TFCTRLForSequenceClassification",headingTag:"h2"}}),He=new Je({props:{name:"class transformers.TFCTRLForSequenceClassification",anchor:"transformers.TFCTRLForSequenceClassification",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L792"}}),fe=new st({props:{$$slots:{default:[Ht]},$$scope:{ctx:C}}}),Ae=new Je({props:{name:"call",anchor:"transformers.TFCTRLForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLForSequenceClassification.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFCTRLForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/modeling_tf_ctrl.py#L828",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),K=new st({props:{$$slots:{default:[Bt]},$$scope:{ctx:C}}}),ee=new et({props:{anchor:"transformers.TFCTRLForSequenceClassification.call.example",$$slots:{default:[Zt]},$$scope:{ctx:C}}}),B=new et({props:{anchor:"transformers.TFCTRLForSequenceClassification.call.example-2",$$slots:{default:[St]},$$scope:{ctx:C}}}),{c(){b(e.$$.fragment),p=r(),t=m("div"),b(o.$$.fragment),g=r(),n=m("p"),n.textContent=_,ne=r(),F=m("p"),F.innerHTML=x,Y=r(),J=m("p"),J.innerHTML=z,Q=r(),b(i.$$.fragment),R=r(),O=m("div"),b(X.$$.fragment),ot=r(),we=m("p"),we.innerHTML=oe,nt=r(),b(G.$$.fragment),be=r(),b(A.$$.fragment),me=r(),b(H.$$.fragment),ue=r(),N=m("div"),b(se.$$.fragment),Fe=r(),Xe=m("p"),Xe.textContent=ze,Ie=r(),ve=m("p"),ve.innerHTML=S,Ue=r(),We=m("p"),We.innerHTML=E,Ne=r(),b(ye.$$.fragment),he=r(),de=m("div"),b($e.$$.fragment),D=r(),Ce=m("p"),Ce.innerHTML=ae,Ge=r(),b(U.$$.fragment),Me=r(),b(q.$$.fragment),re=r(),b(qe.$$.fragment),Le=r(),I=m("div"),b(He.$$.fragment),Be=r(),ke=m("p"),ke.textContent=Ze,je=r(),ce=m("p"),ce.innerHTML=Oe,W=r(),le=m("p"),le.innerHTML=Pe,Re=r(),s=m("p"),s.innerHTML=$,Z=r(),P=m("p"),P.innerHTML=Se,at=r(),b(fe.$$.fragment),rt=r(),V=m("div"),b(Ae.$$.fragment),Ye=r(),De=m("p"),De.innerHTML=f,j=r(),b(K.$$.fragment),ge=r(),b(ee.$$.fragment),_e=r(),b(B.$$.fragment),this.h()},l(h){y(e.$$.fragment,h),p=l(h),t=u(h,"DIV",{class:!0});var L=Te(t);y(o.$$.fragment,L),g=l(L),n=u(L,"P",{"data-svelte-h":!0}),T(n)!=="svelte-418ah6"&&(n.textContent=_),ne=l(L),F=u(L,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1gr3lah"&&(F.innerHTML=x),Y=l(L),J=u(L,"P",{"data-svelte-h":!0}),T(J)!=="svelte-1be7e3c"&&(J.innerHTML=z),Q=l(L),y(i.$$.fragment,L),R=l(L),O=u(L,"DIV",{class:!0});var Ve=Te(O);y(X.$$.fragment,Ve),ot=l(Ve),we=u(Ve,"P",{"data-svelte-h":!0}),T(we)!=="svelte-kmmhan"&&(we.innerHTML=oe),nt=l(Ve),y(G.$$.fragment,Ve),be=l(Ve),y(A.$$.fragment,Ve),Ve.forEach(a),L.forEach(a),me=l(h),y(H.$$.fragment,h),ue=l(h),N=u(h,"DIV",{class:!0});var xe=Te(N);y(se.$$.fragment,xe),Fe=l(xe),Xe=u(xe,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-ej2g0g"&&(Xe.textContent=ze),Ie=l(xe),ve=u(xe,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-1gr3lah"&&(ve.innerHTML=S),Ue=l(xe),We=u(xe,"P",{"data-svelte-h":!0}),T(We)!=="svelte-1be7e3c"&&(We.innerHTML=E),Ne=l(xe),y(ye.$$.fragment,xe),he=l(xe),de=u(xe,"DIV",{class:!0});var Ke=Te(de);y($e.$$.fragment,Ke),D=l(Ke),Ce=u(Ke,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-zs5h4n"&&(Ce.innerHTML=ae),Ge=l(Ke),y(U.$$.fragment,Ke),Me=l(Ke),y(q.$$.fragment,Ke),Ke.forEach(a),xe.forEach(a),re=l(h),y(qe.$$.fragment,h),Le=l(h),I=u(h,"DIV",{class:!0});var ie=Te(I);y(He.$$.fragment,ie),Be=l(ie),ke=u(ie,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-1f84wtp"&&(ke.textContent=Ze),je=l(ie),ce=u(ie,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-qpiqld"&&(ce.innerHTML=Oe),W=l(ie),le=u(ie,"P",{"data-svelte-h":!0}),T(le)!=="svelte-10ugs3m"&&(le.innerHTML=Pe),Re=l(ie),s=u(ie,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1gr3lah"&&(s.innerHTML=$),Z=l(ie),P=u(ie,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1be7e3c"&&(P.innerHTML=Se),at=l(ie),y(fe.$$.fragment,ie),rt=l(ie),V=u(ie,"DIV",{class:!0});var Ee=Te(V);y(Ae.$$.fragment,Ee),Ye=l(Ee),De=u(Ee,"P",{"data-svelte-h":!0}),T(De)!=="svelte-1065zez"&&(De.innerHTML=f),j=l(Ee),y(K.$$.fragment,Ee),ge=l(Ee),y(ee.$$.fragment,Ee),_e=l(Ee),y(B.$$.fragment,Ee),Ee.forEach(a),ie.forEach(a),this.h()},h(){pe(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(h,L){M(e,h,L),c(h,p,L),c(h,t,L),M(o,t,null),d(t,g),d(t,n),d(t,ne),d(t,F),d(t,Y),d(t,J),d(t,Q),M(i,t,null),d(t,R),d(t,O),M(X,O,null),d(O,ot),d(O,we),d(O,nt),M(G,O,null),d(O,be),M(A,O,null),c(h,me,L),M(H,h,L),c(h,ue,L),c(h,N,L),M(se,N,null),d(N,Fe),d(N,Xe),d(N,Ie),d(N,ve),d(N,Ue),d(N,We),d(N,Ne),M(ye,N,null),d(N,he),d(N,de),M($e,de,null),d(de,D),d(de,Ce),d(de,Ge),M(U,de,null),d(de,Me),M(q,de,null),c(h,re,L),M(qe,h,L),c(h,Le,L),c(h,I,L),M(He,I,null),d(I,Be),d(I,ke),d(I,je),d(I,ce),d(I,W),d(I,le),d(I,Re),d(I,s),d(I,Z),d(I,P),d(I,at),M(fe,I,null),d(I,rt),d(I,V),M(Ae,V,null),d(V,Ye),d(V,De),d(V,j),M(K,V,null),d(V,ge),M(ee,V,null),d(V,_e),M(B,V,null),lt=!0},p(h,L){const Ve={};L&2&&(Ve.$$scope={dirty:L,ctx:h}),i.$set(Ve);const xe={};L&2&&(xe.$$scope={dirty:L,ctx:h}),G.$set(xe);const Ke={};L&2&&(Ke.$$scope={dirty:L,ctx:h}),A.$set(Ke);const ie={};L&2&&(ie.$$scope={dirty:L,ctx:h}),ye.$set(ie);const Ee={};L&2&&(Ee.$$scope={dirty:L,ctx:h}),U.$set(Ee);const it={};L&2&&(it.$$scope={dirty:L,ctx:h}),q.$set(it);const dt={};L&2&&(dt.$$scope={dirty:L,ctx:h}),fe.$set(dt);const ct={};L&2&&(ct.$$scope={dirty:L,ctx:h}),K.$set(ct);const pt={};L&2&&(pt.$$scope={dirty:L,ctx:h}),ee.$set(pt);const mt={};L&2&&(mt.$$scope={dirty:L,ctx:h}),B.$set(mt)},i(h){lt||(k(e.$$.fragment,h),k(o.$$.fragment,h),k(i.$$.fragment,h),k(X.$$.fragment,h),k(G.$$.fragment,h),k(A.$$.fragment,h),k(H.$$.fragment,h),k(se.$$.fragment,h),k(ye.$$.fragment,h),k($e.$$.fragment,h),k(U.$$.fragment,h),k(q.$$.fragment,h),k(qe.$$.fragment,h),k(He.$$.fragment,h),k(fe.$$.fragment,h),k(Ae.$$.fragment,h),k(K.$$.fragment,h),k(ee.$$.fragment,h),k(B.$$.fragment,h),lt=!0)},o(h){w(e.$$.fragment,h),w(o.$$.fragment,h),w(i.$$.fragment,h),w(X.$$.fragment,h),w(G.$$.fragment,h),w(A.$$.fragment,h),w(H.$$.fragment,h),w(se.$$.fragment,h),w(ye.$$.fragment,h),w($e.$$.fragment,h),w(U.$$.fragment,h),w(q.$$.fragment,h),w(qe.$$.fragment,h),w(He.$$.fragment,h),w(fe.$$.fragment,h),w(Ae.$$.fragment,h),w(K.$$.fragment,h),w(ee.$$.fragment,h),w(B.$$.fragment,h),lt=!1},d(h){h&&(a(p),a(t),a(me),a(ue),a(N),a(re),a(Le),a(I)),v(e,h),v(o),v(i),v(X),v(G),v(A),v(H,h),v(se),v(ye),v($e),v(U),v(q),v(qe,h),v(He),v(fe),v(Ae),v(K),v(ee),v(B)}}}function Xt(C){let e,p;return e=new ut({props:{$$slots:{default:[Vt]},$$scope:{ctx:C}}}),{c(){b(e.$$.fragment)},l(t){y(e.$$.fragment,t)},m(t,o){M(e,t,o),p=!0},p(t,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:t}),e.$set(g)},i(t){p||(k(e.$$.fragment,t),p=!0)},o(t){w(e.$$.fragment,t),p=!1},d(t){v(e,t)}}}function Gt(C){let e,p,t,o,g,n,_,ne='<a href="https://huggingface.co/models?filter=ctrl"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-ctrl-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/tiny-ctrl"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',F,x,Y,J,z=`CTRL model was proposed in <a href="https://arxiv.org/abs/1909.05858" rel="nofollow">CTRL: A Conditional Transformer Language Model for Controllable Generation</a> by Nitish Shirish Keskar<em>, Bryan McCann</em>, Lav R. Varshney, Caiming Xiong and
Richard Socher. It’s a causal (unidirectional) transformer pre-trained using language modeling on a very large corpus
of ~140 GB of text data with the first token reserved as a control code (such as Links, Books, Wikipedia etc.).`,Q,i,R="The abstract from the paper is the following:",O,X,ot=`<em>Large-scale language models show promising text generation capabilities, but users cannot easily control particular
aspects of the generated text. We release CTRL, a 1.63 billion-parameter conditional transformer language model,
trained to condition on control codes that govern style, content, and task-specific behavior. Control codes were
derived from structure that naturally co-occurs with raw text, preserving the advantages of unsupervised learning while
providing more explicit control over text generation. These codes also allow CTRL to predict which parts of the
training data are most likely given a sequence. This provides a potential method for analyzing large amounts of data
via model-based source attribution.</em>`,we,oe,nt=`This model was contributed by <a href="https://huggingface.co/keskarnitishr" rel="nofollow">keskarnitishr</a>. The original code can be found
<a href="https://github.com/salesforce/ctrl" rel="nofollow">here</a>.`,G,be,A,me,H=`<li>CTRL makes use of control codes to generate text: it requires generations to be started by certain words, sentences
or links to generate coherent text. Refer to the <a href="https://github.com/salesforce/ctrl" rel="nofollow">original implementation</a> for
more information.</li> <li>CTRL is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than
the left.</li> <li>CTRL was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next
token in a sequence. Leveraging this feature allows CTRL to generate syntactically coherent text as it can be
observed in the <em>run_generation.py</em> example script.</li> <li>The PyTorch models can take the <code>past_key_values</code> as input, which is the previously computed key/value attention pairs.
TensorFlow models accepts <code>past</code> as input. Using the <code>past_key_values</code> value prevents the model from re-computing
pre-computed values in the context of text generation. See the <a href="model_doc/ctrl#transformers.CTRLModel.forward"><code>forward</code></a>
method for more information on the usage of this argument.</li>`,ue,N,se,Fe,Xe='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',ze,Ie,ve,S,Ue,We,E,Ne=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> or a <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a>. It is used to
instantiate a CTRL model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/Salesforce/ctrl" rel="nofollow">Salesforce/ctrl</a> architecture from SalesForce.`,ye,he,de=`Configuration objects inherit from <a href="/docs/transformers/pr_30862/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30862/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$e,D,Ce,ae,Ge,U,Me,q,re,qe="Construct a CTRL tokenizer. Based on Byte-Pair-Encoding.",Le,I,He=`This tokenizer inherits from <a href="/docs/transformers/pr_30862/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Be,ke,Ze,je,ce,Oe,W,le,Pe,Re;return g=new Qe({props:{title:"CTRL",local:"ctrl",headingTag:"h1"}}),x=new Qe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),be=new Qe({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),N=new Qe({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ie=new Qe({props:{title:"CTRLConfig",local:"transformers.CTRLConfig",headingTag:"h2"}}),Ue=new Je({props:{name:"class transformers.CTRLConfig",anchor:"transformers.CTRLConfig",parameters:[{name:"vocab_size",val:" = 246534"},{name:"n_positions",val:" = 256"},{name:"n_embd",val:" = 1280"},{name:"dff",val:" = 8192"},{name:"n_layer",val:" = 48"},{name:"n_head",val:" = 16"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CTRLConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 246534) &#x2014;
Vocabulary size of the CTRL model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> or <a href="/docs/transformers/pr_30862/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a>.`,name:"vocab_size"},{anchor:"transformers.CTRLConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.CTRLConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.CTRLConfig.dff",description:`<strong>dff</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimensionality of the inner dimension of the feed forward networks (FFN).`,name:"dff"},{anchor:"transformers.CTRLConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.CTRLConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.CTRLConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.CTRLConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.CTRLConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon to use in the layer normalization layers`,name:"layer_norm_epsilon"},{anchor:"transformers.CTRLConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CTRLConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/configuration_ctrl.py#L24"}}),D=new et({props:{anchor:"transformers.CTRLConfig.example",$$slots:{default:[Mt]},$$scope:{ctx:C}}}),ae=new Qe({props:{title:"CTRLTokenizer",local:"transformers.CTRLTokenizer",headingTag:"h2"}}),Me=new Je({props:{name:"class transformers.CTRLTokenizer",anchor:"transformers.CTRLTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CTRLTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CTRLTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.CTRLTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/tokenization_ctrl.py#L110"}}),Ze=new Je({props:{name:"save_vocabulary",anchor:"transformers.CTRLTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/ctrl/tokenization_ctrl.py#L215"}}),ce=new bt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Xt],pytorch:[Ft]},$$scope:{ctx:C}}}),W=new yt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/ctrl.md"}}),{c(){e=m("meta"),p=r(),t=m("p"),o=r(),b(g.$$.fragment),n=r(),_=m("div"),_.innerHTML=ne,F=r(),b(x.$$.fragment),Y=r(),J=m("p"),J.innerHTML=z,Q=r(),i=m("p"),i.textContent=R,O=r(),X=m("p"),X.innerHTML=ot,we=r(),oe=m("p"),oe.innerHTML=nt,G=r(),b(be.$$.fragment),A=r(),me=m("ul"),me.innerHTML=H,ue=r(),b(N.$$.fragment),se=r(),Fe=m("ul"),Fe.innerHTML=Xe,ze=r(),b(Ie.$$.fragment),ve=r(),S=m("div"),b(Ue.$$.fragment),We=r(),E=m("p"),E.innerHTML=Ne,ye=r(),he=m("p"),he.innerHTML=de,$e=r(),b(D.$$.fragment),Ce=r(),b(ae.$$.fragment),Ge=r(),U=m("div"),b(Me.$$.fragment),q=r(),re=m("p"),re.textContent=qe,Le=r(),I=m("p"),I.innerHTML=He,Be=r(),ke=m("div"),b(Ze.$$.fragment),je=r(),b(ce.$$.fragment),Oe=r(),b(W.$$.fragment),le=r(),Pe=m("p"),this.h()},l(s){const $=Tt("svelte-u9bgzb",document.head);e=u($,"META",{name:!0,content:!0}),$.forEach(a),p=l(s),t=u(s,"P",{}),Te(t).forEach(a),o=l(s),y(g.$$.fragment,s),n=l(s),_=u(s,"DIV",{class:!0,"data-svelte-h":!0}),T(_)!=="svelte-1jjt97v"&&(_.innerHTML=ne),F=l(s),y(x.$$.fragment,s),Y=l(s),J=u(s,"P",{"data-svelte-h":!0}),T(J)!=="svelte-z0k74f"&&(J.innerHTML=z),Q=l(s),i=u(s,"P",{"data-svelte-h":!0}),T(i)!=="svelte-vfdo9a"&&(i.textContent=R),O=l(s),X=u(s,"P",{"data-svelte-h":!0}),T(X)!=="svelte-f7zzo4"&&(X.innerHTML=ot),we=l(s),oe=u(s,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-3n853r"&&(oe.innerHTML=nt),G=l(s),y(be.$$.fragment,s),A=l(s),me=u(s,"UL",{"data-svelte-h":!0}),T(me)!=="svelte-yfbkp1"&&(me.innerHTML=H),ue=l(s),y(N.$$.fragment,s),se=l(s),Fe=u(s,"UL",{"data-svelte-h":!0}),T(Fe)!=="svelte-17u5l9r"&&(Fe.innerHTML=Xe),ze=l(s),y(Ie.$$.fragment,s),ve=l(s),S=u(s,"DIV",{class:!0});var Z=Te(S);y(Ue.$$.fragment,Z),We=l(Z),E=u(Z,"P",{"data-svelte-h":!0}),T(E)!=="svelte-14tqd2s"&&(E.innerHTML=Ne),ye=l(Z),he=u(Z,"P",{"data-svelte-h":!0}),T(he)!=="svelte-dt1yj"&&(he.innerHTML=de),$e=l(Z),y(D.$$.fragment,Z),Z.forEach(a),Ce=l(s),y(ae.$$.fragment,s),Ge=l(s),U=u(s,"DIV",{class:!0});var P=Te(U);y(Me.$$.fragment,P),q=l(P),re=u(P,"P",{"data-svelte-h":!0}),T(re)!=="svelte-1ry85wb"&&(re.textContent=qe),Le=l(P),I=u(P,"P",{"data-svelte-h":!0}),T(I)!=="svelte-1e9cw37"&&(I.innerHTML=He),Be=l(P),ke=u(P,"DIV",{class:!0});var Se=Te(ke);y(Ze.$$.fragment,Se),Se.forEach(a),P.forEach(a),je=l(s),y(ce.$$.fragment,s),Oe=l(s),y(W.$$.fragment,s),le=l(s),Pe=u(s,"P",{}),Te(Pe).forEach(a),this.h()},h(){pe(e,"name","hf:doc:metadata"),pe(e,"content",Et),pe(_,"class","flex flex-wrap space-x-1"),pe(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),pe(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,$){d(document.head,e),c(s,p,$),c(s,t,$),c(s,o,$),M(g,s,$),c(s,n,$),c(s,_,$),c(s,F,$),M(x,s,$),c(s,Y,$),c(s,J,$),c(s,Q,$),c(s,i,$),c(s,O,$),c(s,X,$),c(s,we,$),c(s,oe,$),c(s,G,$),M(be,s,$),c(s,A,$),c(s,me,$),c(s,ue,$),M(N,s,$),c(s,se,$),c(s,Fe,$),c(s,ze,$),M(Ie,s,$),c(s,ve,$),c(s,S,$),M(Ue,S,null),d(S,We),d(S,E),d(S,ye),d(S,he),d(S,$e),M(D,S,null),c(s,Ce,$),M(ae,s,$),c(s,Ge,$),c(s,U,$),M(Me,U,null),d(U,q),d(U,re),d(U,Le),d(U,I),d(U,Be),d(U,ke),M(Ze,ke,null),c(s,je,$),M(ce,s,$),c(s,Oe,$),M(W,s,$),c(s,le,$),c(s,Pe,$),Re=!0},p(s,[$]){const Z={};$&2&&(Z.$$scope={dirty:$,ctx:s}),D.$set(Z);const P={};$&2&&(P.$$scope={dirty:$,ctx:s}),ce.$set(P)},i(s){Re||(k(g.$$.fragment,s),k(x.$$.fragment,s),k(be.$$.fragment,s),k(N.$$.fragment,s),k(Ie.$$.fragment,s),k(Ue.$$.fragment,s),k(D.$$.fragment,s),k(ae.$$.fragment,s),k(Me.$$.fragment,s),k(Ze.$$.fragment,s),k(ce.$$.fragment,s),k(W.$$.fragment,s),Re=!0)},o(s){w(g.$$.fragment,s),w(x.$$.fragment,s),w(be.$$.fragment,s),w(N.$$.fragment,s),w(Ie.$$.fragment,s),w(Ue.$$.fragment,s),w(D.$$.fragment,s),w(ae.$$.fragment,s),w(Me.$$.fragment,s),w(Ze.$$.fragment,s),w(ce.$$.fragment,s),w(W.$$.fragment,s),Re=!1},d(s){s&&(a(p),a(t),a(o),a(n),a(_),a(F),a(Y),a(J),a(Q),a(i),a(O),a(X),a(we),a(oe),a(G),a(A),a(me),a(ue),a(se),a(Fe),a(ze),a(ve),a(S),a(Ce),a(Ge),a(U),a(je),a(Oe),a(le),a(Pe)),a(e),v(g,s),v(x,s),v(be,s),v(N,s),v(Ie,s),v(Ue),v(D),v(ae,s),v(Me),v(Ze),v(ce,s),v(W,s)}}}const Et='{"title":"CTRL","local":"ctrl","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CTRLConfig","local":"transformers.CTRLConfig","sections":[],"depth":2},{"title":"CTRLTokenizer","local":"transformers.CTRLTokenizer","sections":[],"depth":2},{"title":"CTRLModel","local":"transformers.CTRLModel","sections":[],"depth":2},{"title":"CTRLLMHeadModel","local":"transformers.CTRLLMHeadModel","sections":[],"depth":2},{"title":"CTRLForSequenceClassification","local":"transformers.CTRLForSequenceClassification","sections":[],"depth":2},{"title":"TFCTRLModel","local":"transformers.TFCTRLModel","sections":[],"depth":2},{"title":"TFCTRLLMHeadModel","local":"transformers.TFCTRLLMHeadModel","sections":[],"depth":2},{"title":"TFCTRLForSequenceClassification","local":"transformers.TFCTRLForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Pt(C){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends gt{constructor(e){super(),_t(this,e,Pt,Gt,ht,{})}}export{nn as component};
