import{s as cl,n as ml,o as Ml}from"../chunks/scheduler.f7e1785c.js";import{S as hl,i as dl,g as a,s,r as u,m as we,A as yl,h as o,f as l,c as i,j as ht,u as c,x as r,n as Ce,k as Te,y as p,a as n,v as m,d as M,t as h,w as d}from"../chunks/index.d8354395.js";import{Y as fl}from"../chunks/Youtube.90a37f73.js";import{C as Jt}from"../chunks/CodeBlock.191e5103.js";import{H as g,E as gl}from"../chunks/getInferenceSnippets.a345c7e4.js";function wl(Se){let w,$t,vt,bt,U,It,$,Be="We’ve now explored the core concepts of the MCP protocol and how to implement MCP Servers and Clients. In this section, we’re going to make things slightly easier by using Gradio to create an MCP Server!",jt,C,He="<p>Gradio is a popular Python library for quickly creating customizable web interfaces for machine learning models.</p>",xt,b,Gt,I,_e="Gradio allows developers to create UIs for their models with just a few lines of Python code. It’s particularly useful for:",Pt,j,Ee="<li>Creating demos and prototypes</li> <li>Sharing models with non-technical users</li> <li>Testing and debugging model behavior</li>",St,x,Ve="With the addition of MCP support, Gradio now offers a straightforward way to expose AI model capabilities through the standardized MCP protocol.",Bt,G,Re="Combining Gradio with MCP allows you to create both human-friendly interfaces and AI-accessible tools with minimal code. But best of all, Gradio is already well-used by the AI community, so you can use it to share your MCP Servers with others.",Ht,P,_t,S,ke="To use Gradio with MCP support, you’ll need to install Gradio with the MCP extra:",Et,B,Vt,H,Le="You’ll also need an LLM application that supports tool calling using the MCP protocol, such as Cursor ( known as “MCP Hosts”).",Rt,_,kt,E,qe="Let’s walk through a basic example of creating an MCP Server using Gradio:",Lt,V,qt,R,Ae="With this setup, your letter counter function is now accessible through:",At,k,Qe="<li>A traditional Gradio web interface for direct human interaction</li> <li>An MCP Server that can be connected to compatible clients</li>",Qt,L,Ze="The MCP server will be accessible at:",Zt,q,Wt,A,We="The application itself will still be accessible and it looks like this:",Yt,Q,Ye='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit1/7.png" alt="Gradio MCP Server"/>',Nt,Z,zt,W,Ne="When you set <code>mcp_server=True</code> in <code>launch()</code>, several things happen:",Xt,Y,ze="<li>Gradio functions are automatically converted to MCP Tools</li> <li>Input components map to tool argument schemas</li> <li>Output components determine the response format</li> <li>The Gradio server now also listens for MCP protocol messages</li> <li>JSON-RPC over HTTP+SSE is set up for client-server communication</li>",Ft,N,Ot,z,Xe="<li><p><strong>Tool Conversion</strong>: Each API endpoint in your Gradio app is automatically converted into an MCP tool with a corresponding name, description, and input schema. To view the tools and schemas, visit <code>http://your-server:port/gradio_api/mcp/schema</code> or go to the “View API” link in the footer of your Gradio app, and then click on “MCP”.</p></li> <li><p><strong>Environment Variable Support</strong>: There are two ways to enable the MCP server functionality:</p></li>",Kt,T,f,Je,dt,Fe="mcp_server",ve,yt,Oe="launch()",Ue,X,$e,ft,be,F,Dt,J,Ke='<li><p><strong>File Handling</strong>: The server automatically handles file data conversions, including:</p> <ul><li>Converting base64-encoded strings to file data</li> <li>Processing image files and returning them in the correct format</li> <li>Managing temporary file storage</li></ul> <p>It is <strong>strongly</strong> recommended that input images and files be passed as full URLs (“http://…” or “https://…”) as MCP Clients do not always handle local files correctly.</p></li> <li><p><strong>Hosted MCP Servers on 🤗 Spaces</strong>: You can publish your Gradio application for free on Hugging Face Spaces, which will allow you to have a free hosted MCP server. Here’s an example of such a Space: <a href="https://huggingface.co/spaces/abidlabs/mcp-tools" rel="nofollow">https://huggingface.co/spaces/abidlabs/mcp-tools</a></p></li>',te,O,ee,K,De="You can connect any MCP-compatible Space to your assistant via Hugging Face MCP settings:",le,D,tl='<li>Explore MCP-compatible Spaces: <a href="https://huggingface.co/spaces?search=mcp" rel="nofollow">https://huggingface.co/spaces?search=mcp</a></li> <li>Open <a href="https://huggingface.co/settings/mcp" rel="nofollow">https://huggingface.co/settings/mcp</a> (logged in) and add the Space.</li> <li>Restart or refresh your MCP client so it discovers the new tools.</li>',ne,tt,el="These Spaces expose their functions as tools with arguments and descriptions, so your assistant can call them directly.",se,et,ie,y,gt,ll="<p><strong>Type Hints and Docstrings</strong>: Ensure you provide type hints and valid docstrings for your functions. The docstring should include an “Args:” block with indented parameter names.</p>",Ie,wt,nl="<p><strong>String Inputs</strong>: When in doubt, accept input arguments as <code>str</code> and convert them to the desired type inside the function.</p>",je,lt,Ct,sl="<strong>SSE Support</strong>: Some MCP Hosts don’t support SSE-based MCP Servers. In those cases, you can use <code>mcp-remote</code>:",xe,nt,Ge,Tt,il="<p><strong>Restart</strong>: If you encounter connection issues, try restarting both your MCP Client and MCP Server.</p>",ae,st,oe,it,al="You can share your MCP Server by publishing your Gradio app to Hugging Face Spaces. The video below shows how to create a Hugging Face Space.",re,at,pe,ot,ol="Now, you can share your MCP Server with others by sharing your Hugging Face Space.",ue,rt,ce,pt,rl="Gradio’s integration with MCP provides an accessible entry point to the MCP ecosystem. By leveraging Gradio’s simplicity and adding MCP’s standardization, developers can quickly create both human-friendly interfaces and AI-accessible tools with minimal code.",me,ut,pl="As we progress through this course, we’ll explore more sophisticated MCP implementations, but Gradio offers an excellent starting point for understanding and experimenting with the protocol.",Me,ct,ul="In the next unit, we’ll dive deeper into building MCP applications, focusing on setting up development environments, exploring SDKs, and implementing more advanced MCP Servers and Clients.",he,mt,de,Ut,ye;return U=new g({props:{title:"Gradio MCP Integration",local:"gradio-mcp-integration",headingTag:"h1"}}),b=new g({props:{title:"Introduction to Gradio",local:"introduction-to-gradio",headingTag:"h2"}}),P=new g({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),B=new Jt({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwJTIyZ3JhZGlvJTVCbWNwJTVEJTIy",highlighted:'uv pip install <span class="hljs-string">&quot;gradio[mcp]&quot;</span>',wrap:!1}}),_=new g({props:{title:"Creating an MCP Server with Gradio",local:"creating-an-mcp-server-with-gradio",headingTag:"h2"}}),V=new Jt({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlZiUyMGxldHRlcl9jb3VudGVyKHdvcmQlM0ElMjBzdHIlMkMlMjBsZXR0ZXIlM0ElMjBzdHIpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMENvdW50JTIwdGhlJTIwbnVtYmVyJTIwb2YlMjBvY2N1cnJlbmNlcyUyMG9mJTIwYSUyMGxldHRlciUyMGluJTIwYSUyMHdvcmQlMjBvciUyMHRleHQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAoc3RyKSUzQSUyMFRoZSUyMGlucHV0JTIwdGV4dCUyMHRvJTIwc2VhcmNoJTIwdGhyb3VnaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxldHRlciUyMChzdHIpJTNBJTIwVGhlJTIwbGV0dGVyJTIwdG8lMjBzZWFyY2glMjBmb3IlMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW50JTNBJTIwVGhlJTIwbnVtYmVyJTIwb2YlMjB0aW1lcyUyMHRoZSUyMGxldHRlciUyMGFwcGVhcnMlMjBpbiUyMHRoZSUyMHRleHQlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3b3JkJTIwJTNEJTIwd29yZC5sb3dlcigpJTBBJTIwJTIwJTIwJTIwbGV0dGVyJTIwJTNEJTIwbGV0dGVyLmxvd2VyKCklMEElMjAlMjAlMjAlMjBjb3VudCUyMCUzRCUyMHdvcmQuY291bnQobGV0dGVyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNvdW50JTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMHN0YW5kYXJkJTIwR3JhZGlvJTIwaW50ZXJmYWNlJTBBZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGxldHRlcl9jb3VudGVyJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dGJveCUyMiUyQyUyMCUyMnRleHRib3glMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIybnVtYmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJMZXR0ZXIlMjBDb3VudGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJFbnRlciUyMHRleHQlMjBhbmQlMjBhJTIwbGV0dGVyJTIwdG8lMjBjb3VudCUyMGhvdyUyMG1hbnklMjB0aW1lcyUyMHRoZSUyMGxldHRlciUyMGFwcGVhcnMlMjBpbiUyMHRoZSUyMHRleHQuJTIyJTBBKSUwQSUwQSUyMyUyMExhdW5jaCUyMGJvdGglMjB0aGUlMjBHcmFkaW8lMjB3ZWIlMjBpbnRlcmZhY2UlMjBhbmQlMjB0aGUlMjBNQ1AlMjBzZXJ2ZXIlMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBkZW1vLmxhdW5jaChtY3Bfc2VydmVyJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">def</span> <span class="hljs-title function_">letter_counter</span>(<span class="hljs-params">word: <span class="hljs-built_in">str</span>, letter: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Count the number of occurrences of a letter in a word or text.

    Args:
        word (str): The input text to search through
        letter (str): The letter to search for

    Returns:
        int: The number of times the letter appears in the text
    &quot;&quot;&quot;</span>
    word = word.lower()
    letter = letter.lower()
    count = word.count(letter)
    <span class="hljs-keyword">return</span> count

<span class="hljs-comment"># Create a standard Gradio interface</span>
demo = gr.Interface(
    fn=letter_counter,
    inputs=[<span class="hljs-string">&quot;textbox&quot;</span>, <span class="hljs-string">&quot;textbox&quot;</span>],
    outputs=<span class="hljs-string">&quot;number&quot;</span>,
    title=<span class="hljs-string">&quot;Letter Counter&quot;</span>,
    description=<span class="hljs-string">&quot;Enter text and a letter to count how many times the letter appears in the text.&quot;</span>
)

<span class="hljs-comment"># Launch both the Gradio web interface and the MCP server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch(mcp_server=<span class="hljs-literal">True</span>)`,wrap:!1}}),q=new Jt({props:{code:"aHR0cCUzQSUyRiUyRnlvdXItc2VydmVyJTNBcG9ydCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2U=",highlighted:'http:<span class="hljs-regexp">//y</span>our-server:port<span class="hljs-regexp">/gradio_api/m</span>cp/sse',wrap:!1}}),Z=new g({props:{title:"How It Works Behind the Scenes",local:"how-it-works-behind-the-scenes",headingTag:"h2"}}),N=new g({props:{title:"Key Features of the Gradio <> MCP Integration",local:"key-features-of-the-gradio--mcp-integration",headingTag:"h2"}}),X=new Jt({props:{code:"ZGVtby5sYXVuY2gobWNwX3NlcnZlciUzRFRydWUp",highlighted:'demo.launch(mcp_server=<span class="hljs-literal">True</span>)',wrap:!1}}),F=new Jt({props:{code:"ZXhwb3J0JTIwR1JBRElPX01DUF9TRVJWRVIlM0RUcnVl",highlighted:'<span class="hljs-built_in">export</span> GRADIO_MCP_SERVER=True',wrap:!1}}),O=new g({props:{title:"Use MCP-compatible Spaces from your client",local:"use-mcp-compatible-spaces-from-your-client",headingTag:"h2"}}),et=new g({props:{title:"Troubleshooting Tips",local:"troubleshooting-tips",headingTag:"h2"}}),nt=new Jt({props:{code:"JTdCJTBBJTIwJTIwJTIybWNwU2VydmVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWNwLXJlbW90ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHAlM0ElMkYlMkZ5b3VyLXNlcnZlciUzQXBvcnQlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mcpServers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;http://your-server:port/gradio_api/mcp/sse&quot;</span>
      <span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),st=new g({props:{title:"Share your MCP Server",local:"share-your-mcp-server",headingTag:"h2"}}),at=new fl({props:{id:"3bSVKNKb_PY"}}),rt=new g({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),mt=new gl({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/gradio-mcp.mdx"}}),{c(){w=a("meta"),$t=s(),vt=a("p"),bt=s(),u(U.$$.fragment),It=s(),$=a("p"),$.textContent=Be,jt=s(),C=a("blockquote"),C.innerHTML=He,xt=s(),u(b.$$.fragment),Gt=s(),I=a("p"),I.textContent=_e,Pt=s(),j=a("ul"),j.innerHTML=Ee,St=s(),x=a("p"),x.textContent=Ve,Bt=s(),G=a("p"),G.textContent=Re,Ht=s(),u(P.$$.fragment),_t=s(),S=a("p"),S.textContent=ke,Et=s(),u(B.$$.fragment),Vt=s(),H=a("p"),H.textContent=Le,Rt=s(),u(_.$$.fragment),kt=s(),E=a("p"),E.textContent=qe,Lt=s(),u(V.$$.fragment),qt=s(),R=a("p"),R.textContent=Ae,At=s(),k=a("ol"),k.innerHTML=Qe,Qt=s(),L=a("p"),L.textContent=Ze,Zt=s(),u(q.$$.fragment),Wt=s(),A=a("p"),A.textContent=We,Yt=s(),Q=a("p"),Q.innerHTML=Ye,Nt=s(),u(Z.$$.fragment),zt=s(),W=a("p"),W.innerHTML=Ne,Xt=s(),Y=a("ol"),Y.innerHTML=ze,Ft=s(),u(N.$$.fragment),Ot=s(),z=a("ol"),z.innerHTML=Xe,Kt=s(),T=a("ul"),f=a("li"),Je=we("Using the "),dt=a("code"),dt.textContent=Fe,ve=we(" parameter in "),yt=a("code"),yt.textContent=Oe,Ue=we(`:
	`),u(X.$$.fragment),$e=s(),ft=a("li"),be=we(`Using environment variables:
	`),u(F.$$.fragment),Dt=s(),J=a("ol"),J.innerHTML=Ke,te=s(),u(O.$$.fragment),ee=s(),K=a("p"),K.textContent=De,le=s(),D=a("ol"),D.innerHTML=tl,ne=s(),tt=a("p"),tt.textContent=el,se=s(),u(et.$$.fragment),ie=s(),y=a("ol"),gt=a("li"),gt.innerHTML=ll,Ie=s(),wt=a("li"),wt.innerHTML=nl,je=s(),lt=a("li"),Ct=a("p"),Ct.innerHTML=sl,xe=s(),u(nt.$$.fragment),Ge=s(),Tt=a("li"),Tt.innerHTML=il,ae=s(),u(st.$$.fragment),oe=s(),it=a("p"),it.textContent=al,re=s(),u(at.$$.fragment),pe=s(),ot=a("p"),ot.textContent=ol,ue=s(),u(rt.$$.fragment),ce=s(),pt=a("p"),pt.textContent=rl,me=s(),ut=a("p"),ut.textContent=pl,Me=s(),ct=a("p"),ct.textContent=ul,he=s(),u(mt.$$.fragment),de=s(),Ut=a("p"),this.h()},l(t){const e=yl("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),$t=i(t),vt=o(t,"P",{}),ht(vt).forEach(l),bt=i(t),c(U.$$.fragment,t),It=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1r1gtge"&&($.textContent=Be),jt=i(t),C=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-smrbcm"&&(C.innerHTML=He),xt=i(t),c(b.$$.fragment,t),Gt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-14z9p62"&&(I.textContent=_e),Pt=i(t),j=o(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-99ur3v"&&(j.innerHTML=Ee),St=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-lf8duq"&&(x.textContent=Ve),Bt=i(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y0ievc"&&(G.textContent=Re),Ht=i(t),c(P.$$.fragment,t),_t=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1rbj74u"&&(S.textContent=ke),Et=i(t),c(B.$$.fragment,t),Vt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-mcgcva"&&(H.textContent=Le),Rt=i(t),c(_.$$.fragment,t),kt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-o78qi8"&&(E.textContent=qe),Lt=i(t),c(V.$$.fragment,t),qt=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ee2pfb"&&(R.textContent=Ae),At=i(t),k=o(t,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-fibcta"&&(k.innerHTML=Qe),Qt=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-7cf1ja"&&(L.textContent=Ze),Zt=i(t),c(q.$$.fragment,t),Wt=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-u4oo7k"&&(A.textContent=We),Yt=i(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-d00s62"&&(Q.innerHTML=Ye),Nt=i(t),c(Z.$$.fragment,t),zt=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-b8hwz2"&&(W.innerHTML=Ne),Xt=i(t),Y=o(t,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-17ymzc7"&&(Y.innerHTML=ze),Ft=i(t),c(N.$$.fragment,t),Ot=i(t),z=o(t,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-kixwhi"&&(z.innerHTML=Xe),Kt=i(t),T=o(t,"UL",{});var fe=ht(T);f=o(fe,"LI",{});var Mt=ht(f);Je=Ce(Mt,"Using the "),dt=o(Mt,"CODE",{"data-svelte-h":!0}),r(dt)!=="svelte-1ljym0q"&&(dt.textContent=Fe),ve=Ce(Mt," parameter in "),yt=o(Mt,"CODE",{"data-svelte-h":!0}),r(yt)!=="svelte-bu21s"&&(yt.textContent=Oe),Ue=Ce(Mt,`:
	`),c(X.$$.fragment,Mt),Mt.forEach(l),$e=i(fe),ft=o(fe,"LI",{});var Pe=ht(ft);be=Ce(Pe,`Using environment variables:
	`),c(F.$$.fragment,Pe),Pe.forEach(l),fe.forEach(l),Dt=i(t),J=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(J)!=="svelte-1w0fnl0"&&(J.innerHTML=Ke),te=i(t),c(O.$$.fragment,t),ee=i(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ck3qdl"&&(K.textContent=De),le=i(t),D=o(t,"OL",{"data-svelte-h":!0}),r(D)!=="svelte-1naidzp"&&(D.innerHTML=tl),ne=i(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-15z1stf"&&(tt.textContent=el),se=i(t),c(et.$$.fragment,t),ie=i(t),y=o(t,"OL",{});var v=ht(y);gt=o(v,"LI",{"data-svelte-h":!0}),r(gt)!=="svelte-gfnyis"&&(gt.innerHTML=ll),Ie=i(v),wt=o(v,"LI",{"data-svelte-h":!0}),r(wt)!=="svelte-tgtknq"&&(wt.innerHTML=nl),je=i(v),lt=o(v,"LI",{});var ge=ht(lt);Ct=o(ge,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1euh74t"&&(Ct.innerHTML=sl),xe=i(ge),c(nt.$$.fragment,ge),ge.forEach(l),Ge=i(v),Tt=o(v,"LI",{"data-svelte-h":!0}),r(Tt)!=="svelte-17e8f8t"&&(Tt.innerHTML=il),v.forEach(l),ae=i(t),c(st.$$.fragment,t),oe=i(t),it=o(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1713vuh"&&(it.textContent=al),re=i(t),c(at.$$.fragment,t),pe=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-7f2lmd"&&(ot.textContent=ol),ue=i(t),c(rt.$$.fragment,t),ce=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1cuj4qg"&&(pt.textContent=rl),me=i(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-16ly6vm"&&(ut.textContent=pl),Me=i(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-lsux7c"&&(ct.textContent=ul),he=i(t),c(mt.$$.fragment,t),de=i(t),Ut=o(t,"P",{}),ht(Ut).forEach(l),this.h()},h(){Te(w,"name","hf:doc:metadata"),Te(w,"content",Cl),Te(C,"class","tip"),Te(J,"start","3")},m(t,e){p(document.head,w),n(t,$t,e),n(t,vt,e),n(t,bt,e),m(U,t,e),n(t,It,e),n(t,$,e),n(t,jt,e),n(t,C,e),n(t,xt,e),m(b,t,e),n(t,Gt,e),n(t,I,e),n(t,Pt,e),n(t,j,e),n(t,St,e),n(t,x,e),n(t,Bt,e),n(t,G,e),n(t,Ht,e),m(P,t,e),n(t,_t,e),n(t,S,e),n(t,Et,e),m(B,t,e),n(t,Vt,e),n(t,H,e),n(t,Rt,e),m(_,t,e),n(t,kt,e),n(t,E,e),n(t,Lt,e),m(V,t,e),n(t,qt,e),n(t,R,e),n(t,At,e),n(t,k,e),n(t,Qt,e),n(t,L,e),n(t,Zt,e),m(q,t,e),n(t,Wt,e),n(t,A,e),n(t,Yt,e),n(t,Q,e),n(t,Nt,e),m(Z,t,e),n(t,zt,e),n(t,W,e),n(t,Xt,e),n(t,Y,e),n(t,Ft,e),m(N,t,e),n(t,Ot,e),n(t,z,e),n(t,Kt,e),n(t,T,e),p(T,f),p(f,Je),p(f,dt),p(f,ve),p(f,yt),p(f,Ue),m(X,f,null),p(T,$e),p(T,ft),p(ft,be),m(F,ft,null),n(t,Dt,e),n(t,J,e),n(t,te,e),m(O,t,e),n(t,ee,e),n(t,K,e),n(t,le,e),n(t,D,e),n(t,ne,e),n(t,tt,e),n(t,se,e),m(et,t,e),n(t,ie,e),n(t,y,e),p(y,gt),p(y,Ie),p(y,wt),p(y,je),p(y,lt),p(lt,Ct),p(lt,xe),m(nt,lt,null),p(y,Ge),p(y,Tt),n(t,ae,e),m(st,t,e),n(t,oe,e),n(t,it,e),n(t,re,e),m(at,t,e),n(t,pe,e),n(t,ot,e),n(t,ue,e),m(rt,t,e),n(t,ce,e),n(t,pt,e),n(t,me,e),n(t,ut,e),n(t,Me,e),n(t,ct,e),n(t,he,e),m(mt,t,e),n(t,de,e),n(t,Ut,e),ye=!0},p:ml,i(t){ye||(M(U.$$.fragment,t),M(b.$$.fragment,t),M(P.$$.fragment,t),M(B.$$.fragment,t),M(_.$$.fragment,t),M(V.$$.fragment,t),M(q.$$.fragment,t),M(Z.$$.fragment,t),M(N.$$.fragment,t),M(X.$$.fragment,t),M(F.$$.fragment,t),M(O.$$.fragment,t),M(et.$$.fragment,t),M(nt.$$.fragment,t),M(st.$$.fragment,t),M(at.$$.fragment,t),M(rt.$$.fragment,t),M(mt.$$.fragment,t),ye=!0)},o(t){h(U.$$.fragment,t),h(b.$$.fragment,t),h(P.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(V.$$.fragment,t),h(q.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(X.$$.fragment,t),h(F.$$.fragment,t),h(O.$$.fragment,t),h(et.$$.fragment,t),h(nt.$$.fragment,t),h(st.$$.fragment,t),h(at.$$.fragment,t),h(rt.$$.fragment,t),h(mt.$$.fragment,t),ye=!1},d(t){t&&(l($t),l(vt),l(bt),l(It),l($),l(jt),l(C),l(xt),l(Gt),l(I),l(Pt),l(j),l(St),l(x),l(Bt),l(G),l(Ht),l(_t),l(S),l(Et),l(Vt),l(H),l(Rt),l(kt),l(E),l(Lt),l(qt),l(R),l(At),l(k),l(Qt),l(L),l(Zt),l(Wt),l(A),l(Yt),l(Q),l(Nt),l(zt),l(W),l(Xt),l(Y),l(Ft),l(Ot),l(z),l(Kt),l(T),l(Dt),l(J),l(te),l(ee),l(K),l(le),l(D),l(ne),l(tt),l(se),l(ie),l(y),l(ae),l(oe),l(it),l(re),l(pe),l(ot),l(ue),l(ce),l(pt),l(me),l(ut),l(Me),l(ct),l(he),l(de),l(Ut)),l(w),d(U,t),d(b,t),d(P,t),d(B,t),d(_,t),d(V,t),d(q,t),d(Z,t),d(N,t),d(X),d(F),d(O,t),d(et,t),d(nt),d(st,t),d(at,t),d(rt,t),d(mt,t)}}}const Cl='{"title":"Gradio MCP Integration","local":"gradio-mcp-integration","sections":[{"title":"Introduction to Gradio","local":"introduction-to-gradio","sections":[],"depth":2},{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Creating an MCP Server with Gradio","local":"creating-an-mcp-server-with-gradio","sections":[],"depth":2},{"title":"How It Works Behind the Scenes","local":"how-it-works-behind-the-scenes","sections":[],"depth":2},{"title":"Key Features of the Gradio <> MCP Integration","local":"key-features-of-the-gradio--mcp-integration","sections":[],"depth":2},{"title":"Use MCP-compatible Spaces from your client","local":"use-mcp-compatible-spaces-from-your-client","sections":[],"depth":2},{"title":"Troubleshooting Tips","local":"troubleshooting-tips","sections":[],"depth":2},{"title":"Share your MCP Server","local":"share-your-mcp-server","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Tl(Se){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends hl{constructor(w){super(),dl(this,w,Tl,wl,cl,{})}}export{Il as component};
