import{s as te,n as ee,o as le}from"../chunks/scheduler.f7e1785c.js";import{S as ne,i as se,g as i,s,r,A as ae,h as o,f as l,c as a,j as Kt,u as M,x as p,k as D,y as ie,a as n,v as c,d as u,t as m,w as T}from"../chunks/index.d8354395.js";import{C as S}from"../chunks/CodeBlock.191e5103.js";import{H as Y,E as oe}from"../chunks/getInferenceSnippets.a345c7e4.js";function pe(Et){let j,K,z,tt,h,et,f,xt="In this section, we’ll set up the development environment for our Pull Request Agent.",lt,J,kt='<p>We’ll use modern Python tooling with <code>uv</code> for dependency management and create the necessary configuration files. If you’re not familiar with <code>uv</code>, you can learn more about it <a href="https://docs.astral.sh/uv/" rel="nofollow">here</a>.</p>',nt,y,st,g,Ht="Let’s start by creating the project directory and understanding the file structure:",at,U,it,I,Vt="Our final project structure will look like this:",ot,C,pt,v,rt,$,Qt="Let’s walk through the dependencies and configuration for our project.",Mt,b,ct,A,qt="We will use <code>uv</code> to create the <code>pyproject.toml</code> file to define our project:",ut,w,Nt='<p>If you don’t have <code>uv</code> installed, you can follow the instructions <a href="https://docs.astral.sh/uv/getting-started/installation/" rel="nofollow">here</a>.</p>',mt,B,Tt,Z,Gt="For compatibility with various deployment platforms, the same is repeated in <code>requirements.txt</code>",jt,R,Lt="To create a virtual environment, run:",Jt,W,wt,E,Xt="To install the dependencies, run:",dt,x,ht,k,ft,H,_t="Create <code>env.example</code> to document required environment variables:",yt,V,gt,Q,Ft='You will need to get your Hugging Face API token from <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a>.',Ut,q,Pt="You will also need to generate a webhook secret. You can do this by running the following command:",It,N,Ct,G,St="You will then need to add the webhook secret to your <code>.env</code> file based on the <code>env.example</code> file.",vt,L,$t,X,Yt="With our project structure and environment set up, we’re ready to:",bt,_,zt="<li><strong>Create the MCP Server</strong> - Implement the core tagging functionality</li> <li><strong>Build the Webhook Listener</strong> - Handle incoming discussion events</li> <li><strong>Integrate the Agent</strong> - Connect MCP tools with webhook processing</li> <li><strong>Test and Deploy</strong> - Validate functionality and deploy to Spaces</li>",At,F,Ot="In the next section, we’ll dive into creating our MCP server that will handle all the Hugging Face Hub interactions.",Bt,d,Dt="<p>Keep your <code>.env</code> file secure and never commit it to version control. The <code>.env</code> file should be added to your <code>.gitignore</code> file to prevent accidental exposure of secrets.</p>",Zt,P,Rt,O,Wt;return h=new Y({props:{title:"Setting up the Project",local:"setting-up-the-project",headingTag:"h1"}}),y=new Y({props:{title:"Project Structure",local:"project-structure",headingTag:"h2"}}),U=new S({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGbWNwLWNvdXJzZSUyRnRhZy10aGlzLXJlcG8=",highlighted:'git <span class="hljs-built_in">clone</span> https://huggingface.co/spaces/mcp-course/tag-this-repo',wrap:!1}}),C=new S({props:{code:"aGYtcHItYWdlbnQlMkYlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtY3Bfc2VydmVyLnB5JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29yZSUyME1DUCUyMHNlcnZlciUyMHdpdGglMjB0YWdnaW5nJTIwdG9vbHMlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBhcHAucHklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBGYXN0QVBJJTIwd2ViaG9vayUyMGxpc3RlbmVyJTIwYW5kJTIwYWdlbnQlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjByZXF1aXJlbWVudHMudHh0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHl0aG9uJTIwZGVwZW5kZW5jaWVzJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwcHlwcm9qZWN0LnRvbWwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQcm9qZWN0JTIwY29uZmlndXJhdGlvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGVudi5leGFtcGxlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW52aXJvbm1lbnQlMjB2YXJpYWJsZXMlMjB0ZW1wbGF0ZSUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNsZWFudXAucHklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBEZXZlbG9wbWVudCUyMHV0aWxpdHk=",highlighted:`hf-pr-agent/
├── mcp_server.py              <span class="hljs-comment"># Core MCP server with tagging tools</span>
├── app.py                     <span class="hljs-comment"># FastAPI webhook listener and agent</span>
├── requirements.txt           <span class="hljs-comment"># Python dependencies</span>
├── pyproject.toml             <span class="hljs-comment"># Project configuration</span>
├── <span class="hljs-keyword">env</span>.example                <span class="hljs-comment"># Environment variables template</span>
├── cleanup.py                 <span class="hljs-comment"># Development utility</span>`,wrap:!1}}),v=new Y({props:{title:"Dependencies and Configuration",local:"dependencies-and-configuration",headingTag:"h2"}}),b=new Y({props:{title:"1. Python Project Configuration",local:"1-python-project-configuration",headingTag:"h3"}}),B=new S({props:{code:"JTVCcHJvamVjdCU1RCUwQW5hbWUlMjAlM0QlMjAlMjJtY3AtY291cnNlLXVuaXQzLWV4YW1wbGUlMjIlMEF2ZXJzaW9uJTIwJTNEJTIwJTIyMC4xLjAlMjIlMEFkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMkZhc3RBUEklMjBhbmQlMjBHcmFkaW8lMjBhcHAlMjBmb3IlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUyMGRpc2N1c3Npb24lMjB3ZWJob29rcyUyMiUwQXJlYWRtZSUyMCUzRCUyMCUyMlJFQURNRS5tZCUyMiUwQXJlcXVpcmVzLXB5dGhvbiUyMCUzRCUyMCUyMiUzRSUzRDMuMTElMjIlMEFkZXBlbmRlbmNpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJmYXN0YXBpJTNFJTNEMC4xMDQuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnV2aWNvcm4lNUJzdGFuZGFyZCU1RCUzRSUzRDAuMjQuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUzRSUzRDQuMC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaHVnZ2luZ2ZhY2UtaHViJTVCbWNwJTVEJTNFJTNEMC4zMi4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycHlkYW50aWMlM0UlM0QyLjAuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnB5dGhvbi1tdWx0aXBhcnQlM0UlM0QwLjAuNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlcXVlc3RzJTNFJTNEMi4zMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycHl0aG9uLWRvdGVudiUzRSUzRDEuMC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmFzdG1jcCUzRSUzRDIuMC4wJTIyJTJDJTBBJTVEJTBBJTBBJTVCYnVpbGQtc3lzdGVtJTVEJTBBcmVxdWlyZXMlMjAlM0QlMjAlNUIlMjJoYXRjaGxpbmclMjIlNUQlMEFidWlsZC1iYWNrZW5kJTIwJTNEJTIwJTIyaGF0Y2hsaW5nLmJ1aWxkJTIyJTBBJTBBJTVCdG9vbC5oYXRjaC5idWlsZC50YXJnZXRzLndoZWVsJTVEJTBBcGFja2FnZXMlMjAlM0QlMjAlNUIlMjJzcmMlMjIlNUQ=",highlighted:`<span class="hljs-section">[project]</span>
<span class="hljs-attr">name</span> = <span class="hljs-string">&quot;mcp-course-unit3-example&quot;</span>
<span class="hljs-attr">version</span> = <span class="hljs-string">&quot;0.1.0&quot;</span>
<span class="hljs-attr">description</span> = <span class="hljs-string">&quot;FastAPI and Gradio app for Hugging Face Hub discussion webhooks&quot;</span>
<span class="hljs-attr">readme</span> = <span class="hljs-string">&quot;README.md&quot;</span>
<span class="hljs-attr">requires-python</span> = <span class="hljs-string">&quot;&gt;=3.11&quot;</span>
<span class="hljs-attr">dependencies</span> = [
    <span class="hljs-string">&quot;fastapi&gt;=0.104.0&quot;</span>,
    <span class="hljs-string">&quot;uvicorn[standard]&gt;=0.24.0&quot;</span>,
    <span class="hljs-string">&quot;gradio&gt;=4.0.0&quot;</span>,
    <span class="hljs-string">&quot;huggingface-hub[mcp]&gt;=0.32.0&quot;</span>,
    <span class="hljs-string">&quot;pydantic&gt;=2.0.0&quot;</span>,
    <span class="hljs-string">&quot;python-multipart&gt;=0.0.6&quot;</span>,
    <span class="hljs-string">&quot;requests&gt;=2.31.0&quot;</span>,
    <span class="hljs-string">&quot;python-dotenv&gt;=1.0.0&quot;</span>,
    <span class="hljs-string">&quot;fastmcp&gt;=2.0.0&quot;</span>,
]

<span class="hljs-section">[build-system]</span>
<span class="hljs-attr">requires</span> = [<span class="hljs-string">&quot;hatchling&quot;</span>]
<span class="hljs-attr">build-backend</span> = <span class="hljs-string">&quot;hatchling.build&quot;</span>

<span class="hljs-section">[tool.hatch.build.targets.wheel]</span>
<span class="hljs-attr">packages</span> = [<span class="hljs-string">&quot;src&quot;</span>]`,wrap:!1}}),W=new S({props:{code:"dXYlMjB2ZW52JTBBc291cmNlJTIwLnZlbnYlMkZiaW4lMkZhY3RpdmF0ZSUyMCUyMyUyMG9yJTIwLnZlbnYlMkZTY3JpcHRzJTJGYWN0aXZhdGUlMjBvbiUyMFdpbmRvd3M=",highlighted:`uv venv
<span class="hljs-built_in">source</span> .venv/bin/activate <span class="hljs-comment"># or .venv/Scripts/activate on Windows</span>`,wrap:!1}}),x=new S({props:{code:"dXYlMjBzeW5j",highlighted:'uv <span class="hljs-built_in">sync</span>',wrap:!1}}),k=new Y({props:{title:"2. Environment Configuration",local:"2-environment-configuration",headingTag:"h3"}}),V=new S({props:{code:"JTIzJTIwSHVnZ2luZyUyMEZhY2UlMjBBUEklMjBUb2tlbiUyMChyZXF1aXJlZCklMEElMjMlMjBHZXQlMjBmcm9tJTNBJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGdG9rZW5zJTBBSEZfVE9LRU4lM0RoZl95b3VyX3Rva2VuX2hlcmUlMEElMEElMjMlMjBXZWJob29rJTIwU2VjcmV0JTIwKHJlcXVpcmVkJTIwZm9yJTIwcHJvZHVjdGlvbiklMEElMjMlMjBVc2UlMjBhJTIwc3Ryb25nJTJDJTIwcmFuZG9tJTIwc3RyaW5nJTBBV0VCSE9PS19TRUNSRVQlM0R5b3VyLXdlYmhvb2stc2VjcmV0LWhlcmUlMEElMEElMjMlMjBNb2RlbCUyMGZvciUyMHRoZSUyMGFnZW50JTIwKG9wdGlvbmFsKSUwQUhGX01PREVMJTNEb3duZXIlMkZtb2RlbCUwQSUwQSUyMyUyMFByb3ZpZGVyJTIwZm9yJTIwTUNQJTIwYWdlbnQlMjAob3B0aW9uYWwpJTBBSEZfUFJPVklERVIlM0RodWdnaW5nZmFjZQ==",highlighted:`<span class="hljs-comment"># Hugging Face API Token (required)</span>
<span class="hljs-comment"># Get from: https://huggingface.co/settings/tokens</span>
HF_TOKEN=hf_your_token_here

<span class="hljs-comment"># Webhook Secret (required for production)</span>
<span class="hljs-comment"># Use a strong, random string</span>
WEBHOOK_SECRET=your-webhook-secret-here

<span class="hljs-comment"># Model for the agent (optional)</span>
HF_MODEL=owner/model

<span class="hljs-comment"># Provider for MCP agent (optional)</span>
HF_PROVIDER=huggingface`,wrap:!1}}),N=new S({props:{code:"cHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBzZWNyZXRzJTNCJTIwcHJpbnQoc2VjcmV0cy50b2tlbl9oZXgoMzIpKSUyMg==",highlighted:'python -c <span class="hljs-string">&quot;import secrets; print(secrets.token_hex(32))&quot;</span>',wrap:!1}}),L=new Y({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),P=new oe({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/setting-up-the-project.mdx"}}),{c(){j=i("meta"),K=s(),z=i("p"),tt=s(),r(h.$$.fragment),et=s(),f=i("p"),f.textContent=xt,lt=s(),J=i("blockquote"),J.innerHTML=kt,nt=s(),r(y.$$.fragment),st=s(),g=i("p"),g.textContent=Ht,at=s(),r(U.$$.fragment),it=s(),I=i("p"),I.textContent=Vt,ot=s(),r(C.$$.fragment),pt=s(),r(v.$$.fragment),rt=s(),$=i("p"),$.textContent=Qt,Mt=s(),r(b.$$.fragment),ct=s(),A=i("p"),A.innerHTML=qt,ut=s(),w=i("blockquote"),w.innerHTML=Nt,mt=s(),r(B.$$.fragment),Tt=s(),Z=i("p"),Z.innerHTML=Gt,jt=s(),R=i("p"),R.textContent=Lt,Jt=s(),r(W.$$.fragment),wt=s(),E=i("p"),E.textContent=Xt,dt=s(),r(x.$$.fragment),ht=s(),r(k.$$.fragment),ft=s(),H=i("p"),H.innerHTML=_t,yt=s(),r(V.$$.fragment),gt=s(),Q=i("p"),Q.innerHTML=Ft,Ut=s(),q=i("p"),q.textContent=Pt,It=s(),r(N.$$.fragment),Ct=s(),G=i("p"),G.innerHTML=St,vt=s(),r(L.$$.fragment),$t=s(),X=i("p"),X.textContent=Yt,bt=s(),_=i("ol"),_.innerHTML=zt,At=s(),F=i("p"),F.textContent=Ot,Bt=s(),d=i("blockquote"),d.innerHTML=Dt,Zt=s(),r(P.$$.fragment),Rt=s(),O=i("p"),this.h()},l(t){const e=ae("svelte-u9bgzb",document.head);j=o(e,"META",{name:!0,content:!0}),e.forEach(l),K=a(t),z=o(t,"P",{}),Kt(z).forEach(l),tt=a(t),M(h.$$.fragment,t),et=a(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1wjuqx7"&&(f.textContent=xt),lt=a(t),J=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-5jqe1f"&&(J.innerHTML=kt),nt=a(t),M(y.$$.fragment,t),st=a(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1yishkr"&&(g.textContent=Ht),at=a(t),M(U.$$.fragment,t),it=a(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1dygn0i"&&(I.textContent=Vt),ot=a(t),M(C.$$.fragment,t),pt=a(t),M(v.$$.fragment,t),rt=a(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-4m6spw"&&($.textContent=Qt),Mt=a(t),M(b.$$.fragment,t),ct=a(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-j5dv0h"&&(A.innerHTML=qt),ut=a(t),w=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-p3ryqn"&&(w.innerHTML=Nt),mt=a(t),M(B.$$.fragment,t),Tt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-grwm82"&&(Z.innerHTML=Gt),jt=a(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1mr7sjb"&&(R.textContent=Lt),Jt=a(t),M(W.$$.fragment,t),wt=a(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1mrjdan"&&(E.textContent=Xt),dt=a(t),M(x.$$.fragment,t),ht=a(t),M(k.$$.fragment,t),ft=a(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-b0due5"&&(H.innerHTML=_t),yt=a(t),M(V.$$.fragment,t),gt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1m01rh9"&&(Q.innerHTML=Ft),Ut=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-14n3fxz"&&(q.textContent=Pt),It=a(t),M(N.$$.fragment,t),Ct=a(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-5uxnez"&&(G.innerHTML=St),vt=a(t),M(L.$$.fragment,t),$t=a(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14fr4b"&&(X.textContent=Yt),bt=a(t),_=o(t,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-3mrnwz"&&(_.innerHTML=zt),At=a(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1jlfb5a"&&(F.textContent=Ot),Bt=a(t),d=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1r6f1eb"&&(d.innerHTML=Dt),Zt=a(t),M(P.$$.fragment,t),Rt=a(t),O=o(t,"P",{}),Kt(O).forEach(l),this.h()},h(){D(j,"name","hf:doc:metadata"),D(j,"content",re),D(J,"class","tip"),D(w,"class","tip"),D(d,"class","tip")},m(t,e){ie(document.head,j),n(t,K,e),n(t,z,e),n(t,tt,e),c(h,t,e),n(t,et,e),n(t,f,e),n(t,lt,e),n(t,J,e),n(t,nt,e),c(y,t,e),n(t,st,e),n(t,g,e),n(t,at,e),c(U,t,e),n(t,it,e),n(t,I,e),n(t,ot,e),c(C,t,e),n(t,pt,e),c(v,t,e),n(t,rt,e),n(t,$,e),n(t,Mt,e),c(b,t,e),n(t,ct,e),n(t,A,e),n(t,ut,e),n(t,w,e),n(t,mt,e),c(B,t,e),n(t,Tt,e),n(t,Z,e),n(t,jt,e),n(t,R,e),n(t,Jt,e),c(W,t,e),n(t,wt,e),n(t,E,e),n(t,dt,e),c(x,t,e),n(t,ht,e),c(k,t,e),n(t,ft,e),n(t,H,e),n(t,yt,e),c(V,t,e),n(t,gt,e),n(t,Q,e),n(t,Ut,e),n(t,q,e),n(t,It,e),c(N,t,e),n(t,Ct,e),n(t,G,e),n(t,vt,e),c(L,t,e),n(t,$t,e),n(t,X,e),n(t,bt,e),n(t,_,e),n(t,At,e),n(t,F,e),n(t,Bt,e),n(t,d,e),n(t,Zt,e),c(P,t,e),n(t,Rt,e),n(t,O,e),Wt=!0},p:ee,i(t){Wt||(u(h.$$.fragment,t),u(y.$$.fragment,t),u(U.$$.fragment,t),u(C.$$.fragment,t),u(v.$$.fragment,t),u(b.$$.fragment,t),u(B.$$.fragment,t),u(W.$$.fragment,t),u(x.$$.fragment,t),u(k.$$.fragment,t),u(V.$$.fragment,t),u(N.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),Wt=!0)},o(t){m(h.$$.fragment,t),m(y.$$.fragment,t),m(U.$$.fragment,t),m(C.$$.fragment,t),m(v.$$.fragment,t),m(b.$$.fragment,t),m(B.$$.fragment,t),m(W.$$.fragment,t),m(x.$$.fragment,t),m(k.$$.fragment,t),m(V.$$.fragment,t),m(N.$$.fragment,t),m(L.$$.fragment,t),m(P.$$.fragment,t),Wt=!1},d(t){t&&(l(K),l(z),l(tt),l(et),l(f),l(lt),l(J),l(nt),l(st),l(g),l(at),l(it),l(I),l(ot),l(pt),l(rt),l($),l(Mt),l(ct),l(A),l(ut),l(w),l(mt),l(Tt),l(Z),l(jt),l(R),l(Jt),l(wt),l(E),l(dt),l(ht),l(ft),l(H),l(yt),l(gt),l(Q),l(Ut),l(q),l(It),l(Ct),l(G),l(vt),l($t),l(X),l(bt),l(_),l(At),l(F),l(Bt),l(d),l(Zt),l(Rt),l(O)),l(j),T(h,t),T(y,t),T(U,t),T(C,t),T(v,t),T(b,t),T(B,t),T(W,t),T(x,t),T(k,t),T(V,t),T(N,t),T(L,t),T(P,t)}}}const re='{"title":"Setting up the Project","local":"setting-up-the-project","sections":[{"title":"Project Structure","local":"project-structure","sections":[],"depth":2},{"title":"Dependencies and Configuration","local":"dependencies-and-configuration","sections":[{"title":"1. Python Project Configuration","local":"1-python-project-configuration","sections":[],"depth":3},{"title":"2. Environment Configuration","local":"2-environment-configuration","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Me(Et){return le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class je extends ne{constructor(j){super(),se(this,j,Me,pe,te,{})}}export{je as component};
