import{s as us,o as ws,n as ds}from"../chunks/scheduler.f6b352c8.js";import{S as fs,i as bs,g as o,s as a,r as M,A as hs,h as i,f as l,c as n,j as Tl,u as r,x as p,k as js,y as Ul,a as s,v as c,d as m,t as y,w as j}from"../chunks/index.b90df637.js";import{T as Js}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as u,E as Ts}from"../chunks/getInferenceSnippets.cfdd0e7a.js";function Us(qe){let w,J="Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.";return{c(){w=o("p"),w.textContent=J},l(f){w=i(f,"P",{"data-svelte-h":!0}),p(w)!=="svelte-12r8tyg"&&(w.textContent=J)},m(f,Ve){s(f,w,Ve)},p:ds,d(f){f&&l(w)}}}function Cs(qe){let w,J,f,Ve,T,Pe,U,Cl="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",De,C,Il='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',Ke,I,Oe,g,gl='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation">Installation Guide</a>.</li>',et,v,tt,$,vl="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",lt,A,$l='<li><a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',st,_,Al=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,at,Z,_l="Use these if compatible! Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",nt,B,Zl="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",ot,k,Bl="You’re not alone—many community contributions use custom boards or firmware!",it,W,kl="For Feetech and Dynamixel, we currently support these servos:",pt,E,Wl="<li>Feetech:<ul><li>STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code></li> <li>SCS series (protocol 1): <code>scs0009</code></li></ul></li> <li>Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code></li>",Mt,N,El='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there should be a lot of additions to do.',rt,G,Nl="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",ct,x,mt,Y,Gl="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",yt,S,xl="Here, we’ll add the port name and one camera by default for our robot:",jt,R,ut,Q,Yl='Have a look at our <a href="./cameras">Cameras tutorial</a> to understand how to detect and add your camera.',wt,z,Sl="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",dt,H,Rl="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",ft,X,bt,V,ht,L,Ql="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",Jt,b,Tt,F,Ut,q,zl="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",Ct,P,Hl="Example for our 5-DoF arm with one camera:",It,D,gt,K,Xl="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",vt,O,$t,ee,Vl="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",At,te,Ll="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",_t,le,Zt,se,Bt,ae,Fl="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",kt,ne,Wt,oe,ql="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",Et,ie,Nt,pe,Gt,Me,Pl="This method should establish communication with the hardware. Moreover, if your robot needs calibration is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",xt,re,Yt,ce,St,me,Dl="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",Rt,ye,Kl="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",Qt,je,zt,ue,Ht,we,Ol="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",Xt,h,Le,es="Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:",Jl,de,Vt,fe,Lt,be,ts="This should reflect whether your robot has the required calibration loaded.",Ft,he,qt,Je,Pt,Te,ls="The goal of the calibration is twofold:",Dt,Ue,ss="<li>Know the physical range of motion of each motors in order to only send commands within this range.</li> <li>Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will not replicate elsewhere.</li>",Kt,Ce,as="It should implement the logic for calibration (if relevant) and update the <code>self.calibration</code> dictionary. If you are using Feetech or Dynamixel motors, our bus interfaces already include methods to help with this.",Ot,Ie,el,ge,tl,ve,ns="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",ll,$e,sl,Ae,al,_e,os="These are the most important runtime functions: the core I/O loop.",nl,Ze,ol,Be,is="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",il,ke,pl,We,Ml,Ee,ps="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",rl,Ne,cl,Ge,ml,xe,Ms='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',yl,Ye,rs="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",jl,Se,ul,Re,cs="Once your robot class is complete, you can leverage the LeRobot ecosystem:",wl,Qe,ms="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",dl,ze,ys='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',fl,He,bl,Fe,hl;return T=new u({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),I=new u({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),v=new u({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),x=new u({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),R=new d({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jb21tb24uY2FtZXJhcyUyMGltcG9ydCUyMENhbWVyYUNvbmZpZyUwQWZyb20lMjBsZXJvYm90LmNvbW1vbi5jYW1lcmFzLm9wZW5jdiUyMGltcG9ydCUyME9wZW5DVkNhbWVyYUNvbmZpZyUwQWZyb20lMjBsZXJvYm90LmNvbW1vbi5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.common.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.common.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.common.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),X=new d({props:{code:"ZnJvbSUyMGxlcm9ib3QuY29tbW9uLmNhbWVyYXMlMjBpbXBvcnQlMjBtYWtlX2NhbWVyYXNfZnJvbV9jb25maWdzJTBBZnJvbSUyMGxlcm9ib3QuY29tbW9uLm1vdG9ycyUyMGltcG9ydCUyME1vdG9yJTJDJTIwTW90b3JOb3JtTW9kZSUwQWZyb20lMjBsZXJvYm90LmNvbW1vbi5tb3RvcnMuZmVldGVjaCUyMGltcG9ydCUyMEZlZXRlY2hNb3RvcnNCdXMlMEFmcm9tJTIwbGVyb2JvdC5jb21tb24ucm9ib3RzJTIwaW1wb3J0JTIwUm9ib3QlMEElMEFjbGFzcyUyME15Q29vbFJvYm90KFJvYm90KSUzQSUwQSUyMCUyMCUyMCUyMGNvbmZpZ19jbGFzcyUyMCUzRCUyME15Q29vbFJvYm90Q29uZmlnJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm15X2Nvb2xfcm9ib3QlMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwTXlDb29sUm9ib3RDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhjb25maWcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMlMjAlM0QlMjBGZWV0ZWNoTW90b3JzQnVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvcnQlM0RzZWxmLmNvbmZpZy5wb3J0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW90b3JzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMSUyMiUzQSUyME1vdG9yKDElMkMlMjAlMjJzdHMzMjUwJTIyJTJDJTIwTW90b3JOb3JtTW9kZS5SQU5HRV9NMTAwXzEwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8yJTIyJTNBJTIwTW90b3IoMiUyQyUyMCUyMnN0czMyMTUlMjIlMkMlMjBNb3Rvck5vcm1Nb2RlLlJBTkdFX00xMDBfMTAwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzMlMjIlM0ElMjBNb3RvcigzJTJDJTIwJTIyc3RzMzIxNSUyMiUyQyUyME1vdG9yTm9ybU1vZGUuUkFOR0VfTTEwMF8xMDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNCUyMiUzQSUyME1vdG9yKDQlMkMlMjAlMjJzdHMzMjE1JTIyJTJDJTIwTW90b3JOb3JtTW9kZS5SQU5HRV9NMTAwXzEwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF81JTIyJTNBJTIwTW90b3IoNSUyQyUyMCUyMnN0czMyMTUlMjIlMkMlMjBNb3Rvck5vcm1Nb2RlLlJBTkdFX00xMDBfMTAwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbGlicmF0aW9uJTNEc2VsZi5jYWxpYnJhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNhbWVyYXMlMjAlM0QlMjBtYWtlX2NhbWVyYXNfZnJvbV9jb25maWdzKGNvbmZpZy5jYW1lcmFzKQ==",highlighted:`<span class="hljs-keyword">from</span> lerobot.common.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.common.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.common.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.common.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),V=new u({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),b=new Js({props:{warning:!0,$$slots:{default:[Us]},$$scope:{ctx:qe}}}),F=new u({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),D=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),O=new u({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),le=new d({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),se=new u({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),ne=new u({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),ie=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),pe=new u({props:{title:"connect()",local:"connect",headingTag:"h3"}}),re=new d({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),ce=new u({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),je=new d({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),ue=new u({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),de=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTBBZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
   <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
   <span class="hljs-keyword">pass</span>`,wrap:!1}}),fe=new u({props:{title:"is_calibrated",local:"iscalibrated",headingTag:"h3"}}),he=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmJ1cy5pc19jYWxpYnJhdGVk",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_calibrated`,wrap:!1}}),Je=new u({props:{title:"calibrate()",local:"calibrate",headingTag:"h3"}}),Ie=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),ge=new u({props:{title:"configure()",local:"configure",headingTag:"h3"}}),$e=new d({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),Ae=new u({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),Ze=new u({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),ke=new d({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBSdW50aW1lRXJyb3IoJTIyUm9ib3QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZCUyMiklMEElMEElMjAlMjAlMjAlMjBqb2ludF9wb3MlMjAlM0QlMjBzZWxmLm1vdG9yX2ludGVyZmFjZS5yZWFkX2pvaW50X3Bvc2l0aW9ucygpJTBBJTIwJTIwJTIwJTIwZ3JpcHBlciUyMCUzRCUyMHNlbGYubW90b3JfaW50ZXJmYWNlLnJlYWRfZ3JpcHBlcl9zdGF0ZSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBzZWxmLmNhbWVyYS5nZXRfZnJhbWUoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50X3Bvc2l0aW9ucyUyMiUzQSUyMGpvaW50X3BvcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyaXBwZXJfb3BlbiUyMiUzQSUyMGdyaXBwZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1lcmFfaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">&quot;Robot is not connected&quot;</span>)

    joint_pos = self.motor_interface.read_joint_positions()
    gripper = self.motor_interface.read_gripper_state()
    image = self.camera.get_frame()

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_positions&quot;</span>: joint_pos,
        <span class="hljs-string">&quot;gripper_open&quot;</span>: gripper,
        <span class="hljs-string">&quot;camera_image&quot;</span>: image,
    }`,wrap:!1}}),We=new u({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),Ne=new d({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBSdW50aW1lRXJyb3IoJTIyUm9ib3QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZCUyMiklMEElMEElMjAlMjAlMjAlMjBzZWxmLm1vdG9yX2ludGVyZmFjZS5zZXRfam9pbnRfcG9zaXRpb25zKGFjdGlvbiU1QiUyMmpvaW50X3Bvc2l0aW9uX2dvYWxzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMHNlbGYubW90b3JfaW50ZXJmYWNlLnNldF9ncmlwcGVyKGFjdGlvbiU1QiUyMmdyaXBwZXJfY29tbWFuZCUyMiU1RCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">&quot;Robot is not connected&quot;</span>)

    self.motor_interface.set_joint_positions(action[<span class="hljs-string">&quot;joint_position_goals&quot;</span>])
    self.motor_interface.set_gripper(action[<span class="hljs-string">&quot;gripper_command&quot;</span>])

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ge=new u({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),Se=new u({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),He=new Ts({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){w=o("meta"),J=a(),f=o("p"),Ve=a(),M(T.$$.fragment),Pe=a(),U=o("p"),U.textContent=Cl,De=a(),C=o("p"),C.innerHTML=Il,Ke=a(),M(I.$$.fragment),Oe=a(),g=o("ul"),g.innerHTML=gl,et=a(),M(v.$$.fragment),tt=a(),$=o("p"),$.textContent=vl,lt=a(),A=o("ul"),A.innerHTML=$l,st=a(),_=o("p"),_.innerHTML=Al,at=a(),Z=o("p"),Z.textContent=_l,nt=a(),B=o("ul"),B.innerHTML=Zl,ot=a(),k=o("p"),k.textContent=Bl,it=a(),W=o("p"),W.textContent=kl,pt=a(),E=o("ul"),E.innerHTML=Wl,Mt=a(),N=o("p"),N.innerHTML=El,rt=a(),G=o("p"),G.innerHTML=Nl,ct=a(),M(x.$$.fragment),mt=a(),Y=o("p"),Y.innerHTML=Gl,yt=a(),S=o("p"),S.textContent=xl,jt=a(),M(R.$$.fragment),ut=a(),Q=o("p"),Q.innerHTML=Yl,wt=a(),z=o("p"),z.innerHTML=Sl,dt=a(),H=o("p"),H.innerHTML=Rl,ft=a(),M(X.$$.fragment),bt=a(),M(V.$$.fragment),ht=a(),L=o("p"),L.innerHTML=Ql,Jt=a(),M(b.$$.fragment),Tt=a(),M(F.$$.fragment),Ut=a(),q=o("p"),q.innerHTML=zl,Ct=a(),P=o("p"),P.textContent=Hl,It=a(),M(D.$$.fragment),gt=a(),K=o("p"),K.textContent=Xl,vt=a(),M(O.$$.fragment),$t=a(),ee=o("p"),ee.innerHTML=Vl,At=a(),te=o("p"),te.innerHTML=Ll,_t=a(),M(le.$$.fragment),Zt=a(),M(se.$$.fragment),Bt=a(),ae=o("p"),ae.textContent=Fl,kt=a(),M(ne.$$.fragment),Wt=a(),oe=o("p"),oe.innerHTML=ql,Et=a(),M(ie.$$.fragment),Nt=a(),M(pe.$$.fragment),Gt=a(),Me=o("p"),Me.textContent=Pl,xt=a(),M(re.$$.fragment),Yt=a(),M(ce.$$.fragment),St=a(),me=o("p"),me.textContent=Dl,Rt=a(),ye=o("p"),ye.innerHTML=Kl,Qt=a(),M(je.$$.fragment),zt=a(),M(ue.$$.fragment),Ht=a(),we=o("p"),we.textContent=Ol,Xt=a(),h=o("blockquote"),Le=o("p"),Le.textContent=es,Jl=a(),M(de.$$.fragment),Vt=a(),M(fe.$$.fragment),Lt=a(),be=o("p"),be.textContent=ts,Ft=a(),M(he.$$.fragment),qt=a(),M(Je.$$.fragment),Pt=a(),Te=o("p"),Te.textContent=ls,Dt=a(),Ue=o("ul"),Ue.innerHTML=ss,Kt=a(),Ce=o("p"),Ce.innerHTML=as,Ot=a(),M(Ie.$$.fragment),el=a(),M(ge.$$.fragment),tl=a(),ve=o("p"),ve.textContent=ns,ll=a(),M($e.$$.fragment),sl=a(),M(Ae.$$.fragment),al=a(),_e=o("p"),_e.textContent=os,nl=a(),M(Ze.$$.fragment),ol=a(),Be=o("p"),Be.innerHTML=is,il=a(),M(ke.$$.fragment),pl=a(),M(We.$$.fragment),Ml=a(),Ee=o("p"),Ee.innerHTML=ps,rl=a(),M(Ne.$$.fragment),cl=a(),M(Ge.$$.fragment),ml=a(),xe=o("p"),xe.innerHTML=Ms,yl=a(),Ye=o("p"),Ye.innerHTML=rs,jl=a(),M(Se.$$.fragment),ul=a(),Re=o("p"),Re.textContent=cs,wl=a(),Qe=o("ul"),Qe.innerHTML=ms,dl=a(),ze=o("p"),ze.innerHTML=ys,fl=a(),M(He.$$.fragment),bl=a(),Fe=o("p"),this.h()},l(e){const t=hs("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),f=i(e,"P",{}),Tl(f).forEach(l),Ve=n(e),r(T.$$.fragment,e),Pe=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-sl443g"&&(U.textContent=Cl),De=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-njx45z"&&(C.innerHTML=Il),Ke=n(e),r(I.$$.fragment,e),Oe=n(e),g=i(e,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-11itqwk"&&(g.innerHTML=gl),et=n(e),r(v.$$.fragment,e),tt=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-9dsyh9"&&($.textContent=vl),lt=n(e),A=i(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-p8d11k"&&(A.innerHTML=$l),st=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1yhrrnd"&&(_.innerHTML=Al),at=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-4zdzxf"&&(Z.textContent=_l),nt=n(e),B=i(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-1d5xfjp"&&(B.innerHTML=Zl),ot=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1e113uy"&&(k.textContent=Bl),it=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1fd17pl"&&(W.textContent=kl),pt=n(e),E=i(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-d0ywoi"&&(E.innerHTML=Wl),Mt=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-sxoetg"&&(N.innerHTML=El),rt=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-tm2a0s"&&(G.innerHTML=Nl),ct=n(e),r(x.$$.fragment,e),mt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-rc24jv"&&(Y.innerHTML=Gl),yt=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1p0w0g0"&&(S.textContent=xl),jt=n(e),r(R.$$.fragment,e),ut=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-dve2yg"&&(Q.innerHTML=Yl),wt=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-dxku0t"&&(z.innerHTML=Sl),dt=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-nb93rz"&&(H.innerHTML=Rl),ft=n(e),r(X.$$.fragment,e),bt=n(e),r(V.$$.fragment,e),ht=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-l9j1d3"&&(L.innerHTML=Ql),Jt=n(e),r(b.$$.fragment,e),Tt=n(e),r(F.$$.fragment,e),Ut=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-u7pcb4"&&(q.innerHTML=zl),Ct=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1t42iyr"&&(P.textContent=Hl),It=n(e),r(D.$$.fragment,e),gt=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1rkp57y"&&(K.textContent=Xl),vt=n(e),r(O.$$.fragment,e),$t=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-12yyl6o"&&(ee.innerHTML=Vl),At=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1h5avx7"&&(te.innerHTML=Ll),_t=n(e),r(le.$$.fragment,e),Zt=n(e),r(se.$$.fragment,e),Bt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-h4v7d7"&&(ae.textContent=Fl),kt=n(e),r(ne.$$.fragment,e),Wt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1gpnath"&&(oe.innerHTML=ql),Et=n(e),r(ie.$$.fragment,e),Nt=n(e),r(pe.$$.fragment,e),Gt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1d1kz1"&&(Me.textContent=Pl),xt=n(e),r(re.$$.fragment,e),Yt=n(e),r(ce.$$.fragment,e),St=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-lfuhuo"&&(me.textContent=Dl),Rt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1seywak"&&(ye.innerHTML=Kl),Qt=n(e),r(je.$$.fragment,e),zt=n(e),r(ue.$$.fragment,e),Ht=n(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1e7cuec"&&(we.textContent=Ol),Xt=n(e),h=i(e,"BLOCKQUOTE",{});var Xe=Tl(h);Le=i(Xe,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1dxm2cf"&&(Le.textContent=es),Jl=n(Xe),r(de.$$.fragment,Xe),Xe.forEach(l),Vt=n(e),r(fe.$$.fragment,e),Lt=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-10g0kc3"&&(be.textContent=ts),Ft=n(e),r(he.$$.fragment,e),qt=n(e),r(Je.$$.fragment,e),Pt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-15x8ibh"&&(Te.textContent=ls),Dt=n(e),Ue=i(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-1ka4i7r"&&(Ue.innerHTML=ss),Kt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-7etria"&&(Ce.innerHTML=as),Ot=n(e),r(Ie.$$.fragment,e),el=n(e),r(ge.$$.fragment,e),tl=n(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1gxojkw"&&(ve.textContent=ns),ll=n(e),r($e.$$.fragment,e),sl=n(e),r(Ae.$$.fragment,e),al=n(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1qfd9tp"&&(_e.textContent=os),nl=n(e),r(Ze.$$.fragment,e),ol=n(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-adteeq"&&(Be.innerHTML=is),il=n(e),r(ke.$$.fragment,e),pl=n(e),r(We.$$.fragment,e),Ml=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1elar01"&&(Ee.innerHTML=ps),rl=n(e),r(Ne.$$.fragment,e),cl=n(e),r(Ge.$$.fragment,e),ml=n(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-xkh41l"&&(xe.innerHTML=Ms),yl=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-19bs1hk"&&(Ye.innerHTML=rs),jl=n(e),r(Se.$$.fragment,e),ul=n(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-ta7vyn"&&(Re.textContent=cs),wl=n(e),Qe=i(e,"UL",{"data-svelte-h":!0}),p(Qe)!=="svelte-16m8r0w"&&(Qe.innerHTML=ms),dl=n(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-o90m39"&&(ze.innerHTML=ys),fl=n(e),r(He.$$.fragment,e),bl=n(e),Fe=i(e,"P",{}),Tl(Fe).forEach(l),this.h()},h(){js(w,"name","hf:doc:metadata"),js(w,"content",Is)},m(e,t){Ul(document.head,w),s(e,J,t),s(e,f,t),s(e,Ve,t),c(T,e,t),s(e,Pe,t),s(e,U,t),s(e,De,t),s(e,C,t),s(e,Ke,t),c(I,e,t),s(e,Oe,t),s(e,g,t),s(e,et,t),c(v,e,t),s(e,tt,t),s(e,$,t),s(e,lt,t),s(e,A,t),s(e,st,t),s(e,_,t),s(e,at,t),s(e,Z,t),s(e,nt,t),s(e,B,t),s(e,ot,t),s(e,k,t),s(e,it,t),s(e,W,t),s(e,pt,t),s(e,E,t),s(e,Mt,t),s(e,N,t),s(e,rt,t),s(e,G,t),s(e,ct,t),c(x,e,t),s(e,mt,t),s(e,Y,t),s(e,yt,t),s(e,S,t),s(e,jt,t),c(R,e,t),s(e,ut,t),s(e,Q,t),s(e,wt,t),s(e,z,t),s(e,dt,t),s(e,H,t),s(e,ft,t),c(X,e,t),s(e,bt,t),c(V,e,t),s(e,ht,t),s(e,L,t),s(e,Jt,t),c(b,e,t),s(e,Tt,t),c(F,e,t),s(e,Ut,t),s(e,q,t),s(e,Ct,t),s(e,P,t),s(e,It,t),c(D,e,t),s(e,gt,t),s(e,K,t),s(e,vt,t),c(O,e,t),s(e,$t,t),s(e,ee,t),s(e,At,t),s(e,te,t),s(e,_t,t),c(le,e,t),s(e,Zt,t),c(se,e,t),s(e,Bt,t),s(e,ae,t),s(e,kt,t),c(ne,e,t),s(e,Wt,t),s(e,oe,t),s(e,Et,t),c(ie,e,t),s(e,Nt,t),c(pe,e,t),s(e,Gt,t),s(e,Me,t),s(e,xt,t),c(re,e,t),s(e,Yt,t),c(ce,e,t),s(e,St,t),s(e,me,t),s(e,Rt,t),s(e,ye,t),s(e,Qt,t),c(je,e,t),s(e,zt,t),c(ue,e,t),s(e,Ht,t),s(e,we,t),s(e,Xt,t),s(e,h,t),Ul(h,Le),Ul(h,Jl),c(de,h,null),s(e,Vt,t),c(fe,e,t),s(e,Lt,t),s(e,be,t),s(e,Ft,t),c(he,e,t),s(e,qt,t),c(Je,e,t),s(e,Pt,t),s(e,Te,t),s(e,Dt,t),s(e,Ue,t),s(e,Kt,t),s(e,Ce,t),s(e,Ot,t),c(Ie,e,t),s(e,el,t),c(ge,e,t),s(e,tl,t),s(e,ve,t),s(e,ll,t),c($e,e,t),s(e,sl,t),c(Ae,e,t),s(e,al,t),s(e,_e,t),s(e,nl,t),c(Ze,e,t),s(e,ol,t),s(e,Be,t),s(e,il,t),c(ke,e,t),s(e,pl,t),c(We,e,t),s(e,Ml,t),s(e,Ee,t),s(e,rl,t),c(Ne,e,t),s(e,cl,t),c(Ge,e,t),s(e,ml,t),s(e,xe,t),s(e,yl,t),s(e,Ye,t),s(e,jl,t),c(Se,e,t),s(e,ul,t),s(e,Re,t),s(e,wl,t),s(e,Qe,t),s(e,dl,t),s(e,ze,t),s(e,fl,t),c(He,e,t),s(e,bl,t),s(e,Fe,t),hl=!0},p(e,[t]){const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),b.$set(Xe)},i(e){hl||(m(T.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m(V.$$.fragment,e),m(b.$$.fragment,e),m(F.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(je.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),m(he.$$.fragment,e),m(Je.$$.fragment,e),m(Ie.$$.fragment,e),m(ge.$$.fragment,e),m($e.$$.fragment,e),m(Ae.$$.fragment,e),m(Ze.$$.fragment,e),m(ke.$$.fragment,e),m(We.$$.fragment,e),m(Ne.$$.fragment,e),m(Ge.$$.fragment,e),m(Se.$$.fragment,e),m(He.$$.fragment,e),hl=!0)},o(e){y(T.$$.fragment,e),y(I.$$.fragment,e),y(v.$$.fragment,e),y(x.$$.fragment,e),y(R.$$.fragment,e),y(X.$$.fragment,e),y(V.$$.fragment,e),y(b.$$.fragment,e),y(F.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(je.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y($e.$$.fragment,e),y(Ae.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ne.$$.fragment,e),y(Ge.$$.fragment,e),y(Se.$$.fragment,e),y(He.$$.fragment,e),hl=!1},d(e){e&&(l(J),l(f),l(Ve),l(Pe),l(U),l(De),l(C),l(Ke),l(Oe),l(g),l(et),l(tt),l($),l(lt),l(A),l(st),l(_),l(at),l(Z),l(nt),l(B),l(ot),l(k),l(it),l(W),l(pt),l(E),l(Mt),l(N),l(rt),l(G),l(ct),l(mt),l(Y),l(yt),l(S),l(jt),l(ut),l(Q),l(wt),l(z),l(dt),l(H),l(ft),l(bt),l(ht),l(L),l(Jt),l(Tt),l(Ut),l(q),l(Ct),l(P),l(It),l(gt),l(K),l(vt),l($t),l(ee),l(At),l(te),l(_t),l(Zt),l(Bt),l(ae),l(kt),l(Wt),l(oe),l(Et),l(Nt),l(Gt),l(Me),l(xt),l(Yt),l(St),l(me),l(Rt),l(ye),l(Qt),l(zt),l(Ht),l(we),l(Xt),l(h),l(Vt),l(Lt),l(be),l(Ft),l(qt),l(Pt),l(Te),l(Dt),l(Ue),l(Kt),l(Ce),l(Ot),l(el),l(tl),l(ve),l(ll),l(sl),l(al),l(_e),l(nl),l(ol),l(Be),l(il),l(pl),l(Ml),l(Ee),l(rl),l(cl),l(ml),l(xe),l(yl),l(Ye),l(jl),l(ul),l(Re),l(wl),l(Qe),l(dl),l(ze),l(fl),l(bl),l(Fe)),l(w),j(T,e),j(I,e),j(v,e),j(x,e),j(R,e),j(X,e),j(V,e),j(b,e),j(F,e),j(D,e),j(O,e),j(le,e),j(se,e),j(ne,e),j(ie,e),j(pe,e),j(re,e),j(ce,e),j(je,e),j(ue,e),j(de),j(fe,e),j(he,e),j(Je,e),j(Ie,e),j(ge,e),j($e,e),j(Ae,e),j(Ze,e),j(ke,e),j(We,e),j(Ne,e),j(Ge,e),j(Se,e),j(He,e)}}}const Is='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"is_calibrated","local":"iscalibrated","sections":[],"depth":3},{"title":"calibrate()","local":"calibrate","sections":[],"depth":3},{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function gs(qe){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bs extends fs{constructor(w){super(),bs(this,w,gs,Cs,us,{})}}export{Bs as component};
