import{s as Yn,o as Vn,n as R}from"../chunks/scheduler.36a0863c.js";import{S as En,i as Nn,g,s as l,r,A as Fn,h as c,f as t,c as s,j as Rn,u as p,x as b,k as zn,y as Ln,a as n,v as m,d as u,t as d,w as o,m as Qn,n as Sn}from"../chunks/index.156fee99.js";import{T as C}from"../chunks/Tip.8a648467.js";import{Y as Hn}from"../chunks/Youtube.a5d6d567.js";import{C as j}from"../chunks/CodeBlock.4cf998e6.js";import{C as Pn}from"../chunks/CourseFloatingBanner.16bb8bff.js";import{Q as ue}from"../chunks/Question.aeeaa180.js";import{H as U,E as qn}from"../chunks/getInferenceSnippets.472bc46d.js";function Kn(w){let i,y='🏗️ <strong>Pelatihan dari Nol</strong>: Bagian ini membangun dari konten sebelumnya. Untuk panduan menyeluruh mengenai <em>training loop</em> PyTorch dan praktik terbaik, lihat <a href="https://huggingface.co/docs/transformers/main/en/training#train-in-native-pytorch" rel="nofollow">dokumentasi pelatihan 🤗 Transformers</a> dan <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu#model" rel="nofollow">custom training cookbook</a>.';return{c(){i=g("p"),i.innerHTML=y},l(k){i=c(k,"P",{"data-svelte-h":!0}),b(i)!=="svelte-3eg9je"&&(i.innerHTML=y)},m(k,M){n(k,i,M)},p:R,d(k){k&&t(i)}}}function Dn(w){let i,y="💡 <strong>Tips Optimasi Modern</strong>: Untuk performa lebih baik, Anda bisa coba:",k,M,T="<li><strong>AdamW dengan weight decay</strong>: <code>AdamW(model.parameters(), lr=5e-5, weight_decay=0.01)</code></li> <li><strong>Adam 8-bit</strong>: Gunakan <code>bitsandbytes</code> untuk optimasi yang hemat memori</li> <li><strong>Learning rate berbeda</strong>: Biasanya 1e-5 hingga 3e-5 lebih baik untuk model besar</li>",$,f,v='🚀 <strong>Sumber Optimasi</strong>: Pelajari lebih lanjut di <a href="https://huggingface.co/docs/transformers/main/en/performance#optimizer" rel="nofollow">panduan optimasi 🤗 Transformers</a>';return{c(){i=g("p"),i.innerHTML=y,k=l(),M=g("ul"),M.innerHTML=T,$=l(),f=g("p"),f.innerHTML=v},l(h){i=c(h,"P",{"data-svelte-h":!0}),b(i)!=="svelte-x0rdn4"&&(i.innerHTML=y),k=s(h),M=c(h,"UL",{"data-svelte-h":!0}),b(M)!=="svelte-1lkxf2l"&&(M.innerHTML=T),$=s(h),f=c(h,"P",{"data-svelte-h":!0}),b(f)!=="svelte-1s4b77z"&&(f.innerHTML=v)},m(h,J){n(h,i,J),n(h,k,J),n(h,M,J),n(h,$,J),n(h,f,J)},p:R,d(h){h&&(t(i),t(k),t(M),t($),t(f))}}}function On(w){let i,y="💡 <strong>Optimasi Pelatihan Modern</strong>: Untuk efisiensi pelatihan yang lebih baik, pertimbangkan:",k,M,T="<li><strong>Gradient Clipping</strong>: Tambahkan <code>torch.nn.utils.clip_grad_norm_(model.parameters(), max_norm=1.0)</code> sebelum <code>optimizer.step()</code></li> <li><strong>Presisi Campuran (Mixed Precision)</strong>: Gunakan <code>torch.cuda.amp.autocast()</code> dan <code>GradScaler</code></li> <li><strong>Gradient Accumulation</strong>: Kumpulkan gradien dari beberapa batch sebelum melakukan update</li> <li><strong>Checkpointing</strong>: Simpan model secara berkala untuk mencegah kehilangan data jika pelatihan terputus</li>",$,f,v='🔧 <strong>Panduan Implementasi</strong>: Lihat contoh di <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_one" rel="nofollow">efisiensi pelatihan 🤗 Transformers</a> dan <a href="https://huggingface.co/docs/transformers/main/en/optimizers" rel="nofollow">daftar optimizer</a>';return{c(){i=g("p"),i.innerHTML=y,k=l(),M=g("ul"),M.innerHTML=T,$=l(),f=g("p"),f.innerHTML=v},l(h){i=c(h,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1w0udar"&&(i.innerHTML=y),k=s(h),M=c(h,"UL",{"data-svelte-h":!0}),b(M)!=="svelte-l0ufba"&&(M.innerHTML=T),$=s(h),f=c(h,"P",{"data-svelte-h":!0}),b(f)!=="svelte-14z2k2w"&&(f.innerHTML=v)},m(h,J){n(h,i,J),n(h,k,J),n(h,M,J),n(h,$,J),n(h,f,J)},p:R,d(h){h&&(t(i),t(k),t(M),t($),t(f))}}}function al(w){let i,y='📊 <strong>Praktik Terbaik Evaluasi</strong>: Untuk strategi evaluasi dan metrik yang lebih canggih, jelajahi <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">dokumentasi 🤗 Evaluate</a> dan <a href="https://github.com/huggingface/evaluation-guidebook" rel="nofollow">evaluation cookbook komprehensif</a>.';return{c(){i=g("p"),i.innerHTML=y},l(k){i=c(k,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1kxf1z9"&&(i.innerHTML=y)},m(k,M){n(k,i,M)},p:R,d(k){k&&t(i)}}}function el(w){let i,y="✏️ <strong>Coba Sendiri!</strong> Modifikasi training loop sebelumnya untuk melakukan fine-tuning pada dataset SST-2.";return{c(){i=g("p"),i.innerHTML=y},l(k){i=c(k,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1wjs1nx"&&(i.innerHTML=y)},m(k,M){n(k,i,M)},p:R,d(k){k&&t(i)}}}function tl(w){let i,y='⚡ <strong>Pendalaman Accelerate</strong>: Pelajari semua tentang pelatihan terdistribusi, presisi campuran, dan optimasi perangkat keras di <a href="https://huggingface.co/docs/accelerate/" rel="nofollow">dokumentasi 🤗 Accelerate</a> serta contoh praktis di <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">dokumentasi Transformers</a>.';return{c(){i=g("p"),i.innerHTML=y},l(k){i=c(k,"P",{"data-svelte-h":!0}),b(i)!=="svelte-8m7ufz"&&(i.innerHTML=y)},m(k,M){n(k,i,M)},p:R,d(k){k&&t(i)}}}function nl(w){let i;return{c(){i=Qn('⚠️ Untuk mendapatkan kecepatan maksimum pada Cloud TPU, sebaiknya Anda melakukan padding ke panjang tetap dengan `padding="max_length"` dan `max_length` saat menggunakan tokenizer.')},l(y){i=Sn(y,'⚠️ Untuk mendapatkan kecepatan maksimum pada Cloud TPU, sebaiknya Anda melakukan padding ke panjang tetap dengan `padding="max_length"` dan `max_length` saat menggunakan tokenizer.')},m(y,k){n(y,i,k)},d(y){y&&t(i)}}}function ll(w){let i,y='🌐 <strong>Pelatihan Terdistribusi</strong>: Untuk panduan menyeluruh tentang pelatihan multi-GPU dan multi-node, lihat <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_many" rel="nofollow">panduan pelatihan terdistribusi 🤗 Transformers</a> dan <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">scaling training cookbook</a>.';return{c(){i=g("p"),i.innerHTML=y},l(k){i=c(k,"P",{"data-svelte-h":!0}),b(i)!=="svelte-15ozy56"&&(i.innerHTML=y)},m(k,M){n(k,i,M)},p:R,d(k){k&&t(i)}}}function sl(w){let i,y="💡 <strong>Poin Penting:</strong>",k,M,T="<li>Training loop manual memberi Anda kontrol penuh, tapi perlu memahami urutan operasi yang tepat: forward → backward → optimizer step → scheduler step → zero gradients</li> <li>Gunakan AdamW dengan regularisasi weight decay sebagai optimizer utama untuk model transformer</li> <li>Selalu gunakan <code>model.eval()</code> dan <code>torch.no_grad()</code> saat evaluasi untuk hasil yang benar dan efisien</li> <li>🤗 Accelerate memungkinkan pelatihan terdistribusi dengan perubahan kode minimal</li> <li>Manajemen device sangat penting untuk operasi PyTorch yang sukses</li> <li>Teknik modern seperti mixed precision, akumulasi gradien, dan gradient clipping dapat meningkatkan efisiensi pelatihan secara signifikan</li>";return{c(){i=g("p"),i.innerHTML=y,k=l(),M=g("ul"),M.innerHTML=T},l($){i=c($,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1lvsnre"&&(i.innerHTML=y),k=s($),M=c($,"UL",{"data-svelte-h":!0}),b(M)!=="svelte-1l4d4k3"&&(M.innerHTML=T)},m($,f){n($,i,f),n($,k,f),n($,M,f)},p:R,d($){$&&(t(i),t(k),t(M))}}}function il(w){let i,y,k,M,T,$,f,v,h,J,z,Qt="Sekarang kita akan melihat bagaimana mencapai hasil yang sama seperti di bagian sebelumnya <em>tanpa</em> menggunakan kelas <code>Trainer</code>, dengan mengimplementasikan <em>training loop</em> dari nol menggunakan praktik terbaik PyTorch modern. Sekali lagi, kita asumsikan Anda telah menyelesaikan pemrosesan data di bagian 2. Berikut ringkasan singkat yang mencakup semua yang akan Anda butuhkan:",oe,_,ke,H,ge,Y,ce,V,St="Sebelum menulis <em>training loop</em>, kita perlu mendefinisikan beberapa objek. Yang pertama adalah <em>dataloader</em> yang akan kita gunakan untuk melakukan iterasi per batch. Tapi sebelum itu, kita harus melakukan sedikit pasca-pemrosesan pada <code>tokenized_datasets</code> untuk menangani beberapa hal yang sebelumnya dilakukan otomatis oleh <code>Trainer</code>. Secara spesifik, kita perlu:",be,E,Pt="<li>Menghapus kolom yang tidak dibutuhkan model (seperti <code>sentence1</code> dan <code>sentence2</code>).</li> <li>Mengganti nama kolom <code>label</code> menjadi <code>labels</code> (karena model mengharapkan argumen bernama <code>labels</code>).</li> <li>Mengatur format dataset agar mengembalikan tensor PyTorch, bukan list biasa.</li>",Me,N,qt="Langkah-langkah ini dapat dilakukan seperti berikut:",he,F,ye,L,Kt="Kita bisa periksa bahwa hasil akhirnya hanya memiliki kolom yang dapat diterima oleh model:",fe,Q,$e,S,Dt="Sekarang kita bisa mendefinisikan <em>dataloader</em>:",je,P,we,q,Ot="Untuk memastikan tidak ada kesalahan, kita bisa lihat isi satu batch:",Te,K,Je,D,Ue,O,an="Catatan: bentuk tensor (shape) mungkin akan sedikit berbeda karena <code>shuffle=True</code> dan padding dilakukan hingga panjang maksimum dalam setiap batch.",ve,aa,en="Sekarang setelah kita benar-benar selesai dengan praproses data (sebuah tujuan yang memuaskan namun sering kali sulit dicapai bagi praktisi ML), mari kita beralih ke model. Kita menginisialisasinya persis seperti yang kita lakukan di bagian sebelumnya:",Ce,ea,_e,ta,tn="Untuk memastikan bahwa semuanya berjalan lancar selama pelatihan, kita memasukkan batch kita ke dalam model ini:",Ze,na,Be,la,Ie,sa,nn="Semua model 🤗 Transformers akan mengembalikan nilai loss ketika <code>labels</code> diberikan, dan kita juga akan mendapatkan logits (dua untuk setiap input dalam batch kita, sehingga menghasilkan tensor berukuran 8 x 2).",Ae,ia,ln="Sekarang kita hampir siap menulis <em>training loop</em>! Yang tersisa hanyalah optimizer dan scheduler. Kita akan meniru pengaturan default dari <code>Trainer</code>. Optimizer yang digunakan adalah <code>AdamW</code>:",Ge,ra,We,Z,Xe,pa,sn="Akhirnya, scheduler laju pembelajaran (learning rate scheduler) yang digunakan secara default adalah penurunan linier dari nilai maksimum (5e-5) ke 0. Untuk mendefinisikannya dengan benar, kita perlu mengetahui jumlah langkah pelatihan (training steps) yang akan dilakukan, yaitu jumlah epoch yang ingin dijalankan dikalikan dengan jumlah batch pelatihan (yang merupakan panjang dari dataloader pelatihan kita). <code>Trainer</code> menggunakan tiga epoch secara default, jadi kita akan mengikuti pengaturan tersebut:",xe,ma,Re,ua,ze,da,He,oa,rn="Satu hal terakhir: kita akan ingin menggunakan GPU jika tersedia (karena pada CPU, pelatihan bisa memakan waktu beberapa jam dibandingkan hanya beberapa menit di GPU). Untuk melakukan ini, kita mendefinisikan sebuah <code>device</code> tempat kita akan menempatkan model dan batch kita:",Ye,ka,Ve,ga,Ee,ca,pn="Sekarang kita siap untuk melakukan pelatihan! Untuk mengetahui sejauh mana proses pelatihan telah berlangsung, kita menambahkan progress bar berdasarkan jumlah langkah pelatihan kita, menggunakan pustaka <code>tqdm</code>:",Ne,ba,Fe,B,Le,Ma,mn="Anda dapat melihat bahwa inti dari <em>training loop</em> ini mirip seperti yang diperkenalkan di awal. Karena kita belum menambahkan evaluasi atau logging, loop ini tidak akan memberi tahu performa model. Untuk itu, kita perlu menambahkan <em>evaluation loop</em>.",Qe,ha,Se,ya,un="Seperti yang telah kita lakukan sebelumnya, kita akan menggunakan metrik dari pustaka 🤗 Evaluate. Kita sudah melihat metode <code>metric.compute()</code>, tetapi metrik sebenarnya bisa mengakumulasi batch secara bertahap menggunakan metode <code>add_batch()</code>. Setelah semua batch dikumpulkan, kita bisa menghitung hasil akhirnya dengan <code>metric.compute()</code>. Berikut implementasi lengkap dalam loop evaluasi:",Pe,I,qe,fa,Ke,$a,De,ja,dn="Hasil Anda mungkin sedikit berbeda karena inisialisasi acak pada kepala model dan <em>shuffling</em> data, tetapi seharusnya berada pada kisaran yang sama.",Oe,A,at,wa,et,Ta,tt,Ja,on='Loop pelatihan yang kita definisikan sebelumnya bekerja dengan baik pada satu CPU atau GPU. Namun, dengan menggunakan pustaka <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a>, hanya dengan beberapa penyesuaian kita dapat mengaktifkan pelatihan terdistribusi pada beberapa GPU atau TPU. 🤗 Accelerate secara otomatis menangani kompleksitas pelatihan terdistribusi, mixed precision, dan penempatan perangkat (device placement). Dimulai dari pembuatan dataloader untuk pelatihan dan validasi, berikut adalah tampilan loop pelatihan manual kita:',nt,G,lt,Ua,st,va,kn="Langkah pertama adalah mengimpor dan membuat objek <code>Accelerator</code>, yang akan secara otomatis mengatur konfigurasi pelatihan terdistribusi sesuai lingkungan Anda. 🤗 Accelerate akan menangani semua penempatan perangkat, jadi Anda tidak perlu lagi menggunakan <code>model.to(device)</code> — meskipun jika ingin, Anda bisa ganti dengan <code>accelerator.device</code>.",it,Ca,gn="Kemudian, sebagian besar pekerjaan dilakukan pada baris yang mengirimkan dataloader, model, dan optimizer ke <code>accelerator.prepare()</code>. Baris ini akan membungkus objek-objek tersebut dalam kontainer yang sesuai untuk memastikan bahwa pelatihan terdistribusi Anda berjalan sebagaimana mestinya. Perubahan lain yang perlu dilakukan adalah menghapus baris yang memindahkan batch ke <code>device</code> (jika Anda ingin tetap menggunakannya, Anda bisa menggantinya dengan <code>accelerator.device</code>) dan mengganti <code>loss.backward()</code> dengan <code>accelerator.backward(loss)</code>.",rt,W,pt,_a,cn="Jika ingin mencoba langsung, berikut versi lengkap training loop menggunakan 🤗 Accelerate:",mt,Za,ut,Ba,bn="Meletakkan ini dalam sebuah skrip <code>train.py</code> akan membuat skrip tersebut dapat dijalankan pada jenis setup terdistribusi apa pun. Untuk mencobanya di setup terdistribusi Anda, jalankan perintah berikut:",dt,Ia,ot,Aa,Mn="yang akan meminta Anda menjawab beberapa pertanyaan dan menyimpan jawaban Anda dalam sebuah file konfigurasi yang digunakan oleh perintah berikut:",kt,Ga,gt,Wa,hn="yang akan menjalankan pelatihan terdistribusi.",ct,Xa,yn="Jika Anda ingin mencoba ini di sebuah Notebook (misalnya, untuk menguji dengan TPU di Colab), cukup tempelkan kodenya ke dalam sebuah <code>training_function()</code> dan jalankan sel terakhir dengan:",bt,xa,Mt,Ra,fn='Contoh lainnya tersedia di <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">repo 🤗 Accelerate</a>.',ht,X,yt,za,ft,Ha,$n="Setelah Anda mempelajari cara melakukan pelatihan dari awal, berikut beberapa pertimbangan tambahan untuk digunakan dalam produksi:",$t,Ya,jn="<strong>Evaluasi Model</strong>: Jangan hanya bergantung pada akurasi. Gunakan pustaka 🤗 Evaluate untuk evaluasi yang komprehensif.",jt,Va,wn="<strong>Tuning Hyperparameter</strong>: Gunakan pustaka seperti Optuna atau Ray Tune untuk optimasi sistematis.",wt,Ea,Tn="<strong>Pemantauan Model</strong>: Pantau metrik pelatihan, kurva pembelajaran, dan performa validasi.",Tt,Na,Jn="<strong>Berbagi Model</strong>: Setelah pelatihan selesai, unggah ke Hugging Face Hub agar bisa digunakan komunitas.",Jt,Fa,Un="<strong>Efisiensi</strong>: Untuk model besar, gunakan teknik seperti <em>gradient checkpointing</em>, fine-tuning parameter-efisien (LoRA, AdaLoRA), atau metode kuantisasi.",Ut,La,vn="Ini mengakhiri pembahasan mendalam kita tentang fine-tuning menggunakan <em>training loop</em> kustom. Keterampilan yang Anda pelajari di sini akan sangat berguna ketika Anda butuh kontrol penuh atas proses pelatihan atau ingin menerapkan logika pelatihan khusus yang tidak didukung oleh API <code>Trainer</code>.",vt,Qa,Ct,Sa,Cn="Uji pemahaman Anda tentang <em>custom training loop</em> dan teknik pelatihan lanjutan:",_t,Pa,Zt,qa,Bt,Ka,It,Da,At,Oa,Gt,ae,Wt,ee,Xt,te,xt,ne,Rt,le,zt,se,Ht,ie,Yt,re,Vt,pe,Et,x,Nt,me,Ft,de,Lt;return T=new U({props:{title:"Training loop Lengkap",local:"a-full-training",headingTag:"h1"}}),f=new Pn({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),h=new Hn({props:{id:"Dh9CL8fyG80"}}),_=new C({props:{$$slots:{default:[Kn]},$$scope:{ctx:w}}}),H=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Y=new U({props:{title:"Persiapan untuk Pelatihan",local:"prepare-for-training",headingTag:"h3"}}),F=new j({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),Q=new j({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),P=new j({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),K=new j({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),D=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlM0ElMjB0b3JjaC5TaXplKCU1QjglMkMlMjA2NSU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9pZHMlMjIlM0ElMjB0b3JjaC5TaXplKCU1QjglMkMlMjA2NSU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlM0ElMjB0b3JjaC5TaXplKCU1QjglMkMlMjA2NSU1RCklMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;attention_mask&quot;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
    <span class="hljs-string">&quot;input_ids&quot;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
    <span class="hljs-string">&quot;labels&quot;</span>: torch.Size([<span class="hljs-number">8</span>]),
    <span class="hljs-string">&quot;token_type_ids&quot;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
}`,wrap:!1}}),ea=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),na=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),la=new j({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),ra=new j({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Z=new C({props:{$$slots:{default:[Dn]},$$scope:{ctx:w}}}),ma=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),ua=new j({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),da=new U({props:{title:"Training Loop",local:"the-training-loop",headingTag:"h3"}}),ka=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ga=new j({props:{code:"ZGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKQ==",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),ba=new j({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),B=new C({props:{$$slots:{default:[On]},$$scope:{ctx:w}}}),ha=new U({props:{title:"Loop Evaluasi",local:"the-evaluation-loop",headingTag:"h3"}}),I=new C({props:{$$slots:{default:[al]},$$scope:{ctx:w}}}),fa=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),$a=new j({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),A=new C({props:{$$slots:{default:[el]},$$scope:{ctx:w}}}),wa=new U({props:{title:"Percepat Training Loop Anda dengan 🤗 Accelerate",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),Ta=new Hn({props:{id:"s7dy8QRgjJ0"}}),G=new C({props:{$$slots:{default:[tl]},$$scope:{ctx:w}}}),Ua=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),W=new C({props:{$$slots:{default:[nl]},$$scope:{ctx:w}}}),Za=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ia=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ga=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),xa=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),X=new C({props:{$$slots:{default:[ll]},$$scope:{ctx:w}}}),za=new U({props:{title:"Langkah Selanjutnya dan Praktik Terbaik",local:"next-steps-and-best-practices",headingTag:"h3"}}),Qa=new U({props:{title:"Kuis Bagian",local:"section-quiz",headingTag:"h2"}}),Pa=new U({props:{title:"1. Apa perbedaan utama antara optimizer Adam dan AdamW?",local:"1-apa-perbedaan-utama-antara-optimizer-adam-dan-adamw",headingTag:"h3"}}),qa=new ue({props:{choices:[{text:"AdamW menggunakan jadwal laju pembelajaran yang berbeda.",explain:"Penjadwalan learning rate adalah proses terpisah dari pemilihan optimizer."},{text:"AdamW menyertakan regularisasi weight decay yang dipisahkan.",explain:"Benar! AdamW memisahkan weight decay dari pembaruan parameter berbasis gradien, menghasilkan regularisasi yang lebih baik.",correct:!0},{text:"AdamW hanya bekerja dengan model transformer.",explain:"AdamW bisa digunakan untuk semua arsitektur model, bukan hanya transformer."},{text:"AdamW membutuhkan lebih sedikit memori dibanding Adam.",explain:"Keduanya memiliki kebutuhan memori yang serupa."}]}}),Ka=new U({props:{title:"2. Apa urutan operasi yang benar dalam training loop?",local:"2-apa-urutan-operasi-yang-benar-dalam-training-loop",headingTag:"h3"}}),Da=new ue({props:{choices:[{text:"Forward pass → Backward pass → Optimizer step → Zero gradients",explain:"Hampir benar, tapi Anda sebaiknya melakukan zero gradients sebelum forward pass berikutnya agar tidak menumpuk gradien lama."},{text:"Forward pass → Backward pass → Optimizer step → Scheduler step → Zero gradients",explain:"Benar! Ini urutan yang tepat: hitung loss, backward, update parameter, update scheduler, lalu hapus gradien.",correct:!0},{text:"Zero gradients → Forward pass → Optimizer step → Backward pass",explain:"Backward pass harus dilakukan setelah forward pass untuk menghitung gradien dari loss."},{text:"Forward pass → Zero gradients → Backward pass → Optimizer step",explain:"Menghapus gradien sebelum backward pass akan menghapus gradien yang baru saja Anda hitung."}]}}),Oa=new U({props:{title:"3. Apa fungsi utama dari pustaka 🤗 Accelerate?",local:"3-apa-fungsi-utama-dari-pustaka--accelerate",headingTag:"h3"}}),ae=new ue({props:{choices:[{text:"Membuat model Anda lebih cepat dengan mengoptimalkan forward pass.",explain:"Accelerate tidak mengoptimalkan arsitektur model secara langsung."},{text:"Secara otomatis memilih hyperparameter terbaik.",explain:"Accelerate tidak melakukan optimasi hyperparameter."},{text:"Memungkinkan pelatihan terdistribusi di banyak GPU/TPU dengan perubahan kode minimal.",explain:"Benar! Accelerate menangani kompleksitas pelatihan terdistribusi dan memungkinkan kode Anda berjalan mulus di satu atau banyak perangkat.",correct:!0},{text:"Mengkonversi model ke framework lain seperti TensorFlow.",explain:"Accelerate hanya bekerja dalam ekosistem PyTorch."}]}}),ee=new U({props:{title:"4. Mengapa kita memindahkan batch ke device dalam training loop?",local:"4-mengapa-kita-memindahkan-batch-ke-device-dalam-training-loop",headingTag:"h3"}}),te=new ue({props:{choices:[{text:"Untuk mempercepat pelatihan.",explain:"Meskipun itu efek sampingnya, alasan utama adalah kompatibilitas."},{text:"Karena model dan data harus berada di perangkat (CPU/GPU) yang sama untuk komputasi.",explain:"Benar! PyTorch mensyaratkan tensor berada di perangkat yang sama untuk operasi matematis.",correct:!0},{text:"Untuk menghemat memori.",explain:"Memindahkan ke perangkat tidak secara otomatis menghemat memori."},{text:"Karena itu diwajibkan oleh DataLoader.",explain:"DataLoader tidak membutuhkan data berada di device tertentu."}]}}),ne=new U({props:{title:"5. Apa yang dilakukan model.eval() sebelum evaluasi?",local:"5-apa-yang-dilakukan-modeleval-sebelum-evaluasi",headingTag:"h3"}}),le=new ue({props:{choices:[{text:"Membekukan parameter model agar tidak bisa diperbarui.",explain:"`model.eval()` tidak membekukan parameter. Itu dilakukan dengan `requires_grad=False`."},{text:"Mengubah perilaku layer seperti dropout dan batch normalization agar sesuai untuk inferensi.",explain:"Benar! `eval()` menonaktifkan dropout dan menggunakan statistik tetap untuk batch norm.",correct:!0},{text:"Mengaktifkan perhitungan gradien untuk metrik evaluasi.",explain:"Kita justru menggunakan `torch.no_grad()` saat evaluasi untuk menonaktifkan gradien."},{text:"Secara otomatis menghitung metrik evaluasi.",explain:"`model.eval()` hanya mengubah perilaku layer, bukan menghitung metrik."}]}}),se=new U({props:{title:"6. Apa tujuan penggunaan torch.no_grad() saat evaluasi?",local:"6-apa-tujuan-penggunaan-torchnograd-saat-evaluasi",headingTag:"h3"}}),ie=new ue({props:{choices:[{text:"Untuk mencegah model membuat prediksi.",explain:"`torch.no_grad()` tidak mencegah prediksi, hanya menonaktifkan pelacakan gradien."},{text:"Untuk menghemat memori dan mempercepat komputasi dengan menonaktifkan pelacakan gradien.",explain:"Benar! Karena kita tidak membutuhkan gradien saat evaluasi, ini menghemat sumber daya.",correct:!0},{text:"Untuk mengaktifkan mode evaluasi pada model.",explain:"Mode evaluasi diaktifkan dengan `model.eval()`, bukan `torch.no_grad()`."},{text:"Untuk memastikan hasil yang konsisten.",explain:"Reproduksibilitas ditentukan oleh seed acak, bukan oleh `torch.no_grad()`."}]}}),re=new U({props:{title:"7. Apa yang berubah ketika Anda menggunakan 🤗 Accelerate dalam training loop?",local:"7-apa-yang-berubah-ketika-anda-menggunakan--accelerate-dalam-training-loop",headingTag:"h3"}}),pe=new ue({props:{choices:[{text:"Anda harus menulis ulang seluruh training loop dari awal.",explain:"Accelerate hanya membutuhkan sedikit perubahan dari kode PyTorch yang sudah ada."},{text:"Anda membungkus objek penting dengan `accelerator.prepare()` dan menggunakan `accelerator.backward()`.",explain:"Benar! Inilah perubahan utama: bungkus objek penting dan gunakan `accelerator.backward()` untuk kompatibilitas pelatihan terdistribusi.",correct:!0},{text:"Anda harus menentukan jumlah GPU secara eksplisit dalam kode.",explain:"Accelerate secara otomatis mendeteksi perangkat yang tersedia."},{text:"Anda harus menggunakan optimizer dan scheduler yang berbeda.",explain:"Anda tetap bisa menggunakan optimizer dan scheduler yang sama seperti biasa."}]}}),x=new C({props:{$$slots:{default:[sl]},$$scope:{ctx:w}}}),me=new qn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/id/chapter3/4.mdx"}}),{c(){i=g("meta"),y=l(),k=g("p"),M=l(),r(T.$$.fragment),$=l(),r(f.$$.fragment),v=l(),r(h.$$.fragment),J=l(),z=g("p"),z.innerHTML=Qt,oe=l(),r(_.$$.fragment),ke=l(),r(H.$$.fragment),ge=l(),r(Y.$$.fragment),ce=l(),V=g("p"),V.innerHTML=St,be=l(),E=g("ul"),E.innerHTML=Pt,Me=l(),N=g("p"),N.textContent=qt,he=l(),r(F.$$.fragment),ye=l(),L=g("p"),L.textContent=Kt,fe=l(),r(Q.$$.fragment),$e=l(),S=g("p"),S.innerHTML=Dt,je=l(),r(P.$$.fragment),we=l(),q=g("p"),q.textContent=Ot,Te=l(),r(K.$$.fragment),Je=l(),r(D.$$.fragment),Ue=l(),O=g("p"),O.innerHTML=an,ve=l(),aa=g("p"),aa.textContent=en,Ce=l(),r(ea.$$.fragment),_e=l(),ta=g("p"),ta.textContent=tn,Ze=l(),r(na.$$.fragment),Be=l(),r(la.$$.fragment),Ie=l(),sa=g("p"),sa.innerHTML=nn,Ae=l(),ia=g("p"),ia.innerHTML=ln,Ge=l(),r(ra.$$.fragment),We=l(),r(Z.$$.fragment),Xe=l(),pa=g("p"),pa.innerHTML=sn,xe=l(),r(ma.$$.fragment),Re=l(),r(ua.$$.fragment),ze=l(),r(da.$$.fragment),He=l(),oa=g("p"),oa.innerHTML=rn,Ye=l(),r(ka.$$.fragment),Ve=l(),r(ga.$$.fragment),Ee=l(),ca=g("p"),ca.innerHTML=pn,Ne=l(),r(ba.$$.fragment),Fe=l(),r(B.$$.fragment),Le=l(),Ma=g("p"),Ma.innerHTML=mn,Qe=l(),r(ha.$$.fragment),Se=l(),ya=g("p"),ya.innerHTML=un,Pe=l(),r(I.$$.fragment),qe=l(),r(fa.$$.fragment),Ke=l(),r($a.$$.fragment),De=l(),ja=g("p"),ja.innerHTML=dn,Oe=l(),r(A.$$.fragment),at=l(),r(wa.$$.fragment),et=l(),r(Ta.$$.fragment),tt=l(),Ja=g("p"),Ja.innerHTML=on,nt=l(),r(G.$$.fragment),lt=l(),r(Ua.$$.fragment),st=l(),va=g("p"),va.innerHTML=kn,it=l(),Ca=g("p"),Ca.innerHTML=gn,rt=l(),r(W.$$.fragment),pt=l(),_a=g("p"),_a.textContent=cn,mt=l(),r(Za.$$.fragment),ut=l(),Ba=g("p"),Ba.innerHTML=bn,dt=l(),r(Ia.$$.fragment),ot=l(),Aa=g("p"),Aa.textContent=Mn,kt=l(),r(Ga.$$.fragment),gt=l(),Wa=g("p"),Wa.textContent=hn,ct=l(),Xa=g("p"),Xa.innerHTML=yn,bt=l(),r(xa.$$.fragment),Mt=l(),Ra=g("p"),Ra.innerHTML=fn,ht=l(),r(X.$$.fragment),yt=l(),r(za.$$.fragment),ft=l(),Ha=g("p"),Ha.textContent=$n,$t=l(),Ya=g("p"),Ya.innerHTML=jn,jt=l(),Va=g("p"),Va.innerHTML=wn,wt=l(),Ea=g("p"),Ea.innerHTML=Tn,Tt=l(),Na=g("p"),Na.innerHTML=Jn,Jt=l(),Fa=g("p"),Fa.innerHTML=Un,Ut=l(),La=g("p"),La.innerHTML=vn,vt=l(),r(Qa.$$.fragment),Ct=l(),Sa=g("p"),Sa.innerHTML=Cn,_t=l(),r(Pa.$$.fragment),Zt=l(),r(qa.$$.fragment),Bt=l(),r(Ka.$$.fragment),It=l(),r(Da.$$.fragment),At=l(),r(Oa.$$.fragment),Gt=l(),r(ae.$$.fragment),Wt=l(),r(ee.$$.fragment),Xt=l(),r(te.$$.fragment),xt=l(),r(ne.$$.fragment),Rt=l(),r(le.$$.fragment),zt=l(),r(se.$$.fragment),Ht=l(),r(ie.$$.fragment),Yt=l(),r(re.$$.fragment),Vt=l(),r(pe.$$.fragment),Et=l(),r(x.$$.fragment),Nt=l(),r(me.$$.fragment),Ft=l(),de=g("p"),this.h()},l(a){const e=Fn("svelte-u9bgzb",document.head);i=c(e,"META",{name:!0,content:!0}),e.forEach(t),y=s(a),k=c(a,"P",{}),Rn(k).forEach(t),M=s(a),p(T.$$.fragment,a),$=s(a),p(f.$$.fragment,a),v=s(a),p(h.$$.fragment,a),J=s(a),z=c(a,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1ksiak2"&&(z.innerHTML=Qt),oe=s(a),p(_.$$.fragment,a),ke=s(a),p(H.$$.fragment,a),ge=s(a),p(Y.$$.fragment,a),ce=s(a),V=c(a,"P",{"data-svelte-h":!0}),b(V)!=="svelte-cl96xn"&&(V.innerHTML=St),be=s(a),E=c(a,"UL",{"data-svelte-h":!0}),b(E)!=="svelte-1vm6aj7"&&(E.innerHTML=Pt),Me=s(a),N=c(a,"P",{"data-svelte-h":!0}),b(N)!=="svelte-tx5zkb"&&(N.textContent=qt),he=s(a),p(F.$$.fragment,a),ye=s(a),L=c(a,"P",{"data-svelte-h":!0}),b(L)!=="svelte-d4z0g3"&&(L.textContent=Kt),fe=s(a),p(Q.$$.fragment,a),$e=s(a),S=c(a,"P",{"data-svelte-h":!0}),b(S)!=="svelte-sx8yqd"&&(S.innerHTML=Dt),je=s(a),p(P.$$.fragment,a),we=s(a),q=c(a,"P",{"data-svelte-h":!0}),b(q)!=="svelte-1i4lco0"&&(q.textContent=Ot),Te=s(a),p(K.$$.fragment,a),Je=s(a),p(D.$$.fragment,a),Ue=s(a),O=c(a,"P",{"data-svelte-h":!0}),b(O)!=="svelte-19gzc0x"&&(O.innerHTML=an),ve=s(a),aa=c(a,"P",{"data-svelte-h":!0}),b(aa)!=="svelte-2dwt9n"&&(aa.textContent=en),Ce=s(a),p(ea.$$.fragment,a),_e=s(a),ta=c(a,"P",{"data-svelte-h":!0}),b(ta)!=="svelte-6l1xbv"&&(ta.textContent=tn),Ze=s(a),p(na.$$.fragment,a),Be=s(a),p(la.$$.fragment,a),Ie=s(a),sa=c(a,"P",{"data-svelte-h":!0}),b(sa)!=="svelte-ngj8ot"&&(sa.innerHTML=nn),Ae=s(a),ia=c(a,"P",{"data-svelte-h":!0}),b(ia)!=="svelte-13zceo1"&&(ia.innerHTML=ln),Ge=s(a),p(ra.$$.fragment,a),We=s(a),p(Z.$$.fragment,a),Xe=s(a),pa=c(a,"P",{"data-svelte-h":!0}),b(pa)!=="svelte-ha8mw7"&&(pa.innerHTML=sn),xe=s(a),p(ma.$$.fragment,a),Re=s(a),p(ua.$$.fragment,a),ze=s(a),p(da.$$.fragment,a),He=s(a),oa=c(a,"P",{"data-svelte-h":!0}),b(oa)!=="svelte-4kibi0"&&(oa.innerHTML=rn),Ye=s(a),p(ka.$$.fragment,a),Ve=s(a),p(ga.$$.fragment,a),Ee=s(a),ca=c(a,"P",{"data-svelte-h":!0}),b(ca)!=="svelte-1dlxx8s"&&(ca.innerHTML=pn),Ne=s(a),p(ba.$$.fragment,a),Fe=s(a),p(B.$$.fragment,a),Le=s(a),Ma=c(a,"P",{"data-svelte-h":!0}),b(Ma)!=="svelte-r9oxb4"&&(Ma.innerHTML=mn),Qe=s(a),p(ha.$$.fragment,a),Se=s(a),ya=c(a,"P",{"data-svelte-h":!0}),b(ya)!=="svelte-nmnzua"&&(ya.innerHTML=un),Pe=s(a),p(I.$$.fragment,a),qe=s(a),p(fa.$$.fragment,a),Ke=s(a),p($a.$$.fragment,a),De=s(a),ja=c(a,"P",{"data-svelte-h":!0}),b(ja)!=="svelte-1f3rgri"&&(ja.innerHTML=dn),Oe=s(a),p(A.$$.fragment,a),at=s(a),p(wa.$$.fragment,a),et=s(a),p(Ta.$$.fragment,a),tt=s(a),Ja=c(a,"P",{"data-svelte-h":!0}),b(Ja)!=="svelte-dvpuun"&&(Ja.innerHTML=on),nt=s(a),p(G.$$.fragment,a),lt=s(a),p(Ua.$$.fragment,a),st=s(a),va=c(a,"P",{"data-svelte-h":!0}),b(va)!=="svelte-172nv70"&&(va.innerHTML=kn),it=s(a),Ca=c(a,"P",{"data-svelte-h":!0}),b(Ca)!=="svelte-ali4jd"&&(Ca.innerHTML=gn),rt=s(a),p(W.$$.fragment,a),pt=s(a),_a=c(a,"P",{"data-svelte-h":!0}),b(_a)!=="svelte-1o6i8cr"&&(_a.textContent=cn),mt=s(a),p(Za.$$.fragment,a),ut=s(a),Ba=c(a,"P",{"data-svelte-h":!0}),b(Ba)!=="svelte-f7mg2r"&&(Ba.innerHTML=bn),dt=s(a),p(Ia.$$.fragment,a),ot=s(a),Aa=c(a,"P",{"data-svelte-h":!0}),b(Aa)!=="svelte-1q51ui7"&&(Aa.textContent=Mn),kt=s(a),p(Ga.$$.fragment,a),gt=s(a),Wa=c(a,"P",{"data-svelte-h":!0}),b(Wa)!=="svelte-idzpz1"&&(Wa.textContent=hn),ct=s(a),Xa=c(a,"P",{"data-svelte-h":!0}),b(Xa)!=="svelte-uab5ka"&&(Xa.innerHTML=yn),bt=s(a),p(xa.$$.fragment,a),Mt=s(a),Ra=c(a,"P",{"data-svelte-h":!0}),b(Ra)!=="svelte-mwa97v"&&(Ra.innerHTML=fn),ht=s(a),p(X.$$.fragment,a),yt=s(a),p(za.$$.fragment,a),ft=s(a),Ha=c(a,"P",{"data-svelte-h":!0}),b(Ha)!=="svelte-bacda3"&&(Ha.textContent=$n),$t=s(a),Ya=c(a,"P",{"data-svelte-h":!0}),b(Ya)!=="svelte-1bsz4xs"&&(Ya.innerHTML=jn),jt=s(a),Va=c(a,"P",{"data-svelte-h":!0}),b(Va)!=="svelte-18c1x6u"&&(Va.innerHTML=wn),wt=s(a),Ea=c(a,"P",{"data-svelte-h":!0}),b(Ea)!=="svelte-1h6fvl6"&&(Ea.innerHTML=Tn),Tt=s(a),Na=c(a,"P",{"data-svelte-h":!0}),b(Na)!=="svelte-146gadk"&&(Na.innerHTML=Jn),Jt=s(a),Fa=c(a,"P",{"data-svelte-h":!0}),b(Fa)!=="svelte-v25zq2"&&(Fa.innerHTML=Un),Ut=s(a),La=c(a,"P",{"data-svelte-h":!0}),b(La)!=="svelte-ipsvb7"&&(La.innerHTML=vn),vt=s(a),p(Qa.$$.fragment,a),Ct=s(a),Sa=c(a,"P",{"data-svelte-h":!0}),b(Sa)!=="svelte-12h3i9b"&&(Sa.innerHTML=Cn),_t=s(a),p(Pa.$$.fragment,a),Zt=s(a),p(qa.$$.fragment,a),Bt=s(a),p(Ka.$$.fragment,a),It=s(a),p(Da.$$.fragment,a),At=s(a),p(Oa.$$.fragment,a),Gt=s(a),p(ae.$$.fragment,a),Wt=s(a),p(ee.$$.fragment,a),Xt=s(a),p(te.$$.fragment,a),xt=s(a),p(ne.$$.fragment,a),Rt=s(a),p(le.$$.fragment,a),zt=s(a),p(se.$$.fragment,a),Ht=s(a),p(ie.$$.fragment,a),Yt=s(a),p(re.$$.fragment,a),Vt=s(a),p(pe.$$.fragment,a),Et=s(a),p(x.$$.fragment,a),Nt=s(a),p(me.$$.fragment,a),Ft=s(a),de=c(a,"P",{}),Rn(de).forEach(t),this.h()},h(){zn(i,"name","hf:doc:metadata"),zn(i,"content",rl)},m(a,e){Ln(document.head,i),n(a,y,e),n(a,k,e),n(a,M,e),m(T,a,e),n(a,$,e),m(f,a,e),n(a,v,e),m(h,a,e),n(a,J,e),n(a,z,e),n(a,oe,e),m(_,a,e),n(a,ke,e),m(H,a,e),n(a,ge,e),m(Y,a,e),n(a,ce,e),n(a,V,e),n(a,be,e),n(a,E,e),n(a,Me,e),n(a,N,e),n(a,he,e),m(F,a,e),n(a,ye,e),n(a,L,e),n(a,fe,e),m(Q,a,e),n(a,$e,e),n(a,S,e),n(a,je,e),m(P,a,e),n(a,we,e),n(a,q,e),n(a,Te,e),m(K,a,e),n(a,Je,e),m(D,a,e),n(a,Ue,e),n(a,O,e),n(a,ve,e),n(a,aa,e),n(a,Ce,e),m(ea,a,e),n(a,_e,e),n(a,ta,e),n(a,Ze,e),m(na,a,e),n(a,Be,e),m(la,a,e),n(a,Ie,e),n(a,sa,e),n(a,Ae,e),n(a,ia,e),n(a,Ge,e),m(ra,a,e),n(a,We,e),m(Z,a,e),n(a,Xe,e),n(a,pa,e),n(a,xe,e),m(ma,a,e),n(a,Re,e),m(ua,a,e),n(a,ze,e),m(da,a,e),n(a,He,e),n(a,oa,e),n(a,Ye,e),m(ka,a,e),n(a,Ve,e),m(ga,a,e),n(a,Ee,e),n(a,ca,e),n(a,Ne,e),m(ba,a,e),n(a,Fe,e),m(B,a,e),n(a,Le,e),n(a,Ma,e),n(a,Qe,e),m(ha,a,e),n(a,Se,e),n(a,ya,e),n(a,Pe,e),m(I,a,e),n(a,qe,e),m(fa,a,e),n(a,Ke,e),m($a,a,e),n(a,De,e),n(a,ja,e),n(a,Oe,e),m(A,a,e),n(a,at,e),m(wa,a,e),n(a,et,e),m(Ta,a,e),n(a,tt,e),n(a,Ja,e),n(a,nt,e),m(G,a,e),n(a,lt,e),m(Ua,a,e),n(a,st,e),n(a,va,e),n(a,it,e),n(a,Ca,e),n(a,rt,e),m(W,a,e),n(a,pt,e),n(a,_a,e),n(a,mt,e),m(Za,a,e),n(a,ut,e),n(a,Ba,e),n(a,dt,e),m(Ia,a,e),n(a,ot,e),n(a,Aa,e),n(a,kt,e),m(Ga,a,e),n(a,gt,e),n(a,Wa,e),n(a,ct,e),n(a,Xa,e),n(a,bt,e),m(xa,a,e),n(a,Mt,e),n(a,Ra,e),n(a,ht,e),m(X,a,e),n(a,yt,e),m(za,a,e),n(a,ft,e),n(a,Ha,e),n(a,$t,e),n(a,Ya,e),n(a,jt,e),n(a,Va,e),n(a,wt,e),n(a,Ea,e),n(a,Tt,e),n(a,Na,e),n(a,Jt,e),n(a,Fa,e),n(a,Ut,e),n(a,La,e),n(a,vt,e),m(Qa,a,e),n(a,Ct,e),n(a,Sa,e),n(a,_t,e),m(Pa,a,e),n(a,Zt,e),m(qa,a,e),n(a,Bt,e),m(Ka,a,e),n(a,It,e),m(Da,a,e),n(a,At,e),m(Oa,a,e),n(a,Gt,e),m(ae,a,e),n(a,Wt,e),m(ee,a,e),n(a,Xt,e),m(te,a,e),n(a,xt,e),m(ne,a,e),n(a,Rt,e),m(le,a,e),n(a,zt,e),m(se,a,e),n(a,Ht,e),m(ie,a,e),n(a,Yt,e),m(re,a,e),n(a,Vt,e),m(pe,a,e),n(a,Et,e),m(x,a,e),n(a,Nt,e),m(me,a,e),n(a,Ft,e),n(a,de,e),Lt=!0},p(a,[e]){const _n={};e&2&&(_n.$$scope={dirty:e,ctx:a}),_.$set(_n);const Zn={};e&2&&(Zn.$$scope={dirty:e,ctx:a}),Z.$set(Zn);const Bn={};e&2&&(Bn.$$scope={dirty:e,ctx:a}),B.$set(Bn);const In={};e&2&&(In.$$scope={dirty:e,ctx:a}),I.$set(In);const An={};e&2&&(An.$$scope={dirty:e,ctx:a}),A.$set(An);const Gn={};e&2&&(Gn.$$scope={dirty:e,ctx:a}),G.$set(Gn);const Wn={};e&2&&(Wn.$$scope={dirty:e,ctx:a}),W.$set(Wn);const Xn={};e&2&&(Xn.$$scope={dirty:e,ctx:a}),X.$set(Xn);const xn={};e&2&&(xn.$$scope={dirty:e,ctx:a}),x.$set(xn)},i(a){Lt||(u(T.$$.fragment,a),u(f.$$.fragment,a),u(h.$$.fragment,a),u(_.$$.fragment,a),u(H.$$.fragment,a),u(Y.$$.fragment,a),u(F.$$.fragment,a),u(Q.$$.fragment,a),u(P.$$.fragment,a),u(K.$$.fragment,a),u(D.$$.fragment,a),u(ea.$$.fragment,a),u(na.$$.fragment,a),u(la.$$.fragment,a),u(ra.$$.fragment,a),u(Z.$$.fragment,a),u(ma.$$.fragment,a),u(ua.$$.fragment,a),u(da.$$.fragment,a),u(ka.$$.fragment,a),u(ga.$$.fragment,a),u(ba.$$.fragment,a),u(B.$$.fragment,a),u(ha.$$.fragment,a),u(I.$$.fragment,a),u(fa.$$.fragment,a),u($a.$$.fragment,a),u(A.$$.fragment,a),u(wa.$$.fragment,a),u(Ta.$$.fragment,a),u(G.$$.fragment,a),u(Ua.$$.fragment,a),u(W.$$.fragment,a),u(Za.$$.fragment,a),u(Ia.$$.fragment,a),u(Ga.$$.fragment,a),u(xa.$$.fragment,a),u(X.$$.fragment,a),u(za.$$.fragment,a),u(Qa.$$.fragment,a),u(Pa.$$.fragment,a),u(qa.$$.fragment,a),u(Ka.$$.fragment,a),u(Da.$$.fragment,a),u(Oa.$$.fragment,a),u(ae.$$.fragment,a),u(ee.$$.fragment,a),u(te.$$.fragment,a),u(ne.$$.fragment,a),u(le.$$.fragment,a),u(se.$$.fragment,a),u(ie.$$.fragment,a),u(re.$$.fragment,a),u(pe.$$.fragment,a),u(x.$$.fragment,a),u(me.$$.fragment,a),Lt=!0)},o(a){d(T.$$.fragment,a),d(f.$$.fragment,a),d(h.$$.fragment,a),d(_.$$.fragment,a),d(H.$$.fragment,a),d(Y.$$.fragment,a),d(F.$$.fragment,a),d(Q.$$.fragment,a),d(P.$$.fragment,a),d(K.$$.fragment,a),d(D.$$.fragment,a),d(ea.$$.fragment,a),d(na.$$.fragment,a),d(la.$$.fragment,a),d(ra.$$.fragment,a),d(Z.$$.fragment,a),d(ma.$$.fragment,a),d(ua.$$.fragment,a),d(da.$$.fragment,a),d(ka.$$.fragment,a),d(ga.$$.fragment,a),d(ba.$$.fragment,a),d(B.$$.fragment,a),d(ha.$$.fragment,a),d(I.$$.fragment,a),d(fa.$$.fragment,a),d($a.$$.fragment,a),d(A.$$.fragment,a),d(wa.$$.fragment,a),d(Ta.$$.fragment,a),d(G.$$.fragment,a),d(Ua.$$.fragment,a),d(W.$$.fragment,a),d(Za.$$.fragment,a),d(Ia.$$.fragment,a),d(Ga.$$.fragment,a),d(xa.$$.fragment,a),d(X.$$.fragment,a),d(za.$$.fragment,a),d(Qa.$$.fragment,a),d(Pa.$$.fragment,a),d(qa.$$.fragment,a),d(Ka.$$.fragment,a),d(Da.$$.fragment,a),d(Oa.$$.fragment,a),d(ae.$$.fragment,a),d(ee.$$.fragment,a),d(te.$$.fragment,a),d(ne.$$.fragment,a),d(le.$$.fragment,a),d(se.$$.fragment,a),d(ie.$$.fragment,a),d(re.$$.fragment,a),d(pe.$$.fragment,a),d(x.$$.fragment,a),d(me.$$.fragment,a),Lt=!1},d(a){a&&(t(y),t(k),t(M),t($),t(v),t(J),t(z),t(oe),t(ke),t(ge),t(ce),t(V),t(be),t(E),t(Me),t(N),t(he),t(ye),t(L),t(fe),t($e),t(S),t(je),t(we),t(q),t(Te),t(Je),t(Ue),t(O),t(ve),t(aa),t(Ce),t(_e),t(ta),t(Ze),t(Be),t(Ie),t(sa),t(Ae),t(ia),t(Ge),t(We),t(Xe),t(pa),t(xe),t(Re),t(ze),t(He),t(oa),t(Ye),t(Ve),t(Ee),t(ca),t(Ne),t(Fe),t(Le),t(Ma),t(Qe),t(Se),t(ya),t(Pe),t(qe),t(Ke),t(De),t(ja),t(Oe),t(at),t(et),t(tt),t(Ja),t(nt),t(lt),t(st),t(va),t(it),t(Ca),t(rt),t(pt),t(_a),t(mt),t(ut),t(Ba),t(dt),t(ot),t(Aa),t(kt),t(gt),t(Wa),t(ct),t(Xa),t(bt),t(Mt),t(Ra),t(ht),t(yt),t(ft),t(Ha),t($t),t(Ya),t(jt),t(Va),t(wt),t(Ea),t(Tt),t(Na),t(Jt),t(Fa),t(Ut),t(La),t(vt),t(Ct),t(Sa),t(_t),t(Zt),t(Bt),t(It),t(At),t(Gt),t(Wt),t(Xt),t(xt),t(Rt),t(zt),t(Ht),t(Yt),t(Vt),t(Et),t(Nt),t(Ft),t(de)),t(i),o(T,a),o(f,a),o(h,a),o(_,a),o(H,a),o(Y,a),o(F,a),o(Q,a),o(P,a),o(K,a),o(D,a),o(ea,a),o(na,a),o(la,a),o(ra,a),o(Z,a),o(ma,a),o(ua,a),o(da,a),o(ka,a),o(ga,a),o(ba,a),o(B,a),o(ha,a),o(I,a),o(fa,a),o($a,a),o(A,a),o(wa,a),o(Ta,a),o(G,a),o(Ua,a),o(W,a),o(Za,a),o(Ia,a),o(Ga,a),o(xa,a),o(X,a),o(za,a),o(Qa,a),o(Pa,a),o(qa,a),o(Ka,a),o(Da,a),o(Oa,a),o(ae,a),o(ee,a),o(te,a),o(ne,a),o(le,a),o(se,a),o(ie,a),o(re,a),o(pe,a),o(x,a),o(me,a)}}}const rl='{"title":"Training loop Lengkap","local":"a-full-training","sections":[{"title":"Persiapan untuk Pelatihan","local":"prepare-for-training","sections":[],"depth":3},{"title":"Training Loop","local":"the-training-loop","sections":[],"depth":3},{"title":"Loop Evaluasi","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"Percepat Training Loop Anda dengan 🤗 Accelerate","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3},{"title":"Langkah Selanjutnya dan Praktik Terbaik","local":"next-steps-and-best-practices","sections":[],"depth":3},{"title":"Kuis Bagian","local":"section-quiz","sections":[{"title":"1. Apa perbedaan utama antara optimizer Adam dan AdamW?","local":"1-apa-perbedaan-utama-antara-optimizer-adam-dan-adamw","sections":[],"depth":3},{"title":"2. Apa urutan operasi yang benar dalam training loop?","local":"2-apa-urutan-operasi-yang-benar-dalam-training-loop","sections":[],"depth":3},{"title":"3. Apa fungsi utama dari pustaka 🤗 Accelerate?","local":"3-apa-fungsi-utama-dari-pustaka--accelerate","sections":[],"depth":3},{"title":"4. Mengapa kita memindahkan batch ke device dalam training loop?","local":"4-mengapa-kita-memindahkan-batch-ke-device-dalam-training-loop","sections":[],"depth":3},{"title":"5. Apa yang dilakukan model.eval() sebelum evaluasi?","local":"5-apa-yang-dilakukan-modeleval-sebelum-evaluasi","sections":[],"depth":3},{"title":"6. Apa tujuan penggunaan torch.no_grad() saat evaluasi?","local":"6-apa-tujuan-penggunaan-torchnograd-saat-evaluasi","sections":[],"depth":3},{"title":"7. Apa yang berubah ketika Anda menggunakan 🤗 Accelerate dalam training loop?","local":"7-apa-yang-berubah-ketika-anda-menggunakan--accelerate-dalam-training-loop","sections":[],"depth":3}],"depth":2}],"depth":1}';function pl(w){return Vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends En{constructor(i){super(),Nn(this,i,pl,il,Yn,{})}}export{Ml as component};
