import{s as Ts,o as hs,n as us}from"../chunks/scheduler.37c15a92.js";import{S as fs,i as Cs,g as o,s as a,r as p,A as Zs,h as y,f as s,c as n,j as bs,u as M,x as d,k as Js,y as Gs,a as t,v as c,d as i,t as r,w as m}from"../chunks/index.2bf4358c.js";import{T as ws}from"../chunks/Tip.363c041f.js";import{Y as Us}from"../chunks/Youtube.1e50a667.js";import{C as b}from"../chunks/CodeBlock.4e987730.js";import{C as Is}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{H as Bl,E as $s}from"../chunks/getInferenceSnippets.80a69898.js";function ks($l){let j,w="✏️ <strong>试试看！</strong> 修改之前的训练循环以在 SST-2 数据集上微调你的模型。";return{c(){j=o("p"),j.innerHTML=w},l(J){j=y(J,"P",{"data-svelte-h":!0}),d(j)!=="svelte-n66aug"&&(j.innerHTML=w)},m(J,U){t(J,j,U)},p:us,d(J){J&&s(j)}}}function Bs($l){let j,w="⚠️ 为了使云端 TPU 提供的加速中发挥最大的效益，我们建议使用 tokenizer 的 <code>padding=max_length</code> 和 <code>max_length</code> 参数将你的样本填充到固定长度。";return{c(){j=o("p"),j.innerHTML=w},l(J){j=y(J,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1thjlh4"&&(j.innerHTML=w)},m(J,U){t(J,j,U)},p:us,d(J){J&&s(j)}}}function Xs($l){let j,w,J,U,h,Xl,f,Wl,C,Rl,Z,ze="现在，我们将了解如何在不使用 <code>Trainer</code> 类的情况下实现与上一节相同的结果。同样，我们假设你已经完成了第 2 节中的数据处理。下面对第 2 节内容的一个简短总结，涵盖了你需要在本节之前运行的所有内容：",gl,G,vl,I,_l,$,Ne="在正式开始编写我们的训练循环之前，我们需要定义一些对象。首先是我们将用于迭代 batch 的数据加载器。但在定义这些数据加载器之前，我们需要对我们的 <code>tokenized_datasets</code> 进行一些后处理，以自己实现一些 Trainer 自动为我们处理的内容。具体来说，我们需要：",Vl,k,Ee="<li>删除与模型不需要的列（如 <code>sentence1</code> 和 <code>sentence2</code> 列）。</li> <li>将列名 <code>label</code> 重命名为 <code>labels</code> （因为模型默认的输入是 <code>labels</code> ）。</li> <li>设置数据集的格式，使其返回 PyTorch 张量而不是列表。</li>",Yl,B,Fe="针对上面的每个步骤，我们的 <code>tokenized_datasets</code> 都有一个方法：",Al,X,zl,W,Qe="然后，我们可以检查结果中是否只有模型能够接受的列：",Nl,R,El,g,He="至此，我们可以轻松定义数据加载器：",Fl,v,Ql,_,Se="为了快速检验数据处理中没有错误，我们可以这样检验其中的一个 batch：",Hl,V,Sl,Y,xl,A,xe="请注意，这里的形状可能与你略有不同，因为我们为训练数据加载器设置了 <code>shuffle=True</code> ，并且模型会将句子填充到 <code>batch</code> 中的最大长度。",Ll,z,Le="现在我们已经完全完成了数据预处理（对于任何 ML 从业者来说都是一个令人满意但难以实现的目标），让我们将注意力转向模型。我们会像在上一节中所做的那样实例化它：",ql,N,Kl,E,qe="为了确保训练过程中一切顺利，我们将 <code>batch</code> 传递给这个模型：",Pl,F,Dl,Q,Ol,H,Ke="当我们输入 <code>labels</code> 时，🤗 Transformers 模型都将返回这个 <code>batch</code> 的 <code>loss</code> ，我们还得到了 <code>logits</code> （ <code>batch</code> 中的每个输入有两个输出，所以张量大小为 8 x 2）。",le,S,Pe='我们几乎准备好编写我们的训练循环了！我们只是缺少两件事：优化器和学习率调度器。由于我们试图手动实现 <code>Trainer</code> 的功能，我们将使用相同的优化器和学习率调度器。 <code>Trainer</code> 使用的优化器是 <code>AdamW</code> ，它与 <code>Adam</code> 相同，但加入了权重衰减正则化的一点变化（参见 Ilya Loshchilov 和 Frank Hutter 的 <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> ）：',ee,x,se,L,De="最后，默认使用的学习率调度器只是从最大值 （5e-5） 到 0 的线性衰减。为了定义它，我们需要知道我们训练的次数，即所有数据训练的次数（epochs）乘以的 batch 的数量（即我们训练数据加载器的长度）。 <code>Trainer</code> 默认情况下使用三个 <code>epochs</code> ，因此我们定义训练过程如下：",te,q,ae,K,ne,P,pe,D,Oe="最后一件事：如果我们可以访问 GPU，我们将希望使用 GPU（在 CPU 上，训练可能需要几个小时而不是几分钟）。为此，我们定义了一个 <code>device</code> ，它在 GPU 可用的情况下指向 GPU，最后我们将把我们的模型和 <code>batch</code> 放在 <code>device</code> 上：",Me,O,ce,ll,ie,el,ls="我们现在准备好训练了！为了知道训练何时结束，我们使用 <code>tqdm</code> 库，在训练步骤数上添加了一个进度条：",re,sl,me,tl,es="你可以看到训练循环的核心与介绍中的非常相似。我们没有要求在训练的过程中进行检验，所以这个训练循环不会告诉我们任何关于模型目前的状态。我们需要为此添加一个评估循环。",oe,al,ye,nl,ss="正如我们之前所做的那样，我们将使用 🤗 Evaluate 库提供的指标。我们已经了解了 <code>metric.compute()</code> 方法，当我们使用 <code>add_batch()</code> 方法进行预测循环时，实际上该指标可以为我们累积所有 <code>batch</code> 的结果。一旦我们累积了所有 <code>batch</code> ，我们就可以使用 <code>metric.compute()</code> 评估得到的结果。以下是如何在评估循环中实现所有这些的方法：",de,pl,je,Ml,be,cl,ts="同样，由于模型头部初始化和数据打乱的随机性，你的结果会略有不同，但应该相差不多。",Je,u,we,il,Ue,rl,ue,ml,as='我们之前定义的训练循环在单个 CPU 或 GPU 上运行良好。通过使用 <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> 库，只需进行一些调整，我们就可以在多个 GPU 或 TPU 上启用分布式训练。从创建训练和验证数据加载器开始，我们的手动训练循环如下所示：',Te,ol,he,yl,ns="以下是更改的部分：",fe,dl,Ce,jl,ps="要添加的第一行是导入 <code>Accelerator</code> 。第二行实例化一个 <code>Accelerator</code> 对象 它将查看环境并初始化适当的分布式设置。🤗 Accelerate 为你处理数据在设备间的数据传递，因此你可以删除将模型放在设备上的那行代码（或者，如果你愿意，可使用 <code>accelerator.device</code> 代替 <code>device</code> ）。",Ze,bl,Ms="然后大部分工作会在将数据加载器、模型和优化器发送到的 <code>accelerator.prepare()</code> 中完成。这将会把这些对象包装在适当的容器中，以确保你的分布式训练按预期工作。要进行的其余更改是删除将 <code>batch</code> 放在 <code>device</code> 的那行代码（同样，如果你想保留它，你可以将其更改为使用 <code>accelerator.device</code> ） 并将 <code>loss.backward()</code> 替换为 <code>accelerator.backward(loss)</code> 。",Ge,T,Ie,Jl,cs="如果你想复制并粘贴来直接运行，以下是 🤗 Accelerate 的完整训练循环：",$e,wl,ke,Ul,is="把这个放在 <code>train.py</code> 文件中，可以让它在任何类型的分布式设置上运行。要在分布式设置中试用它，请运行以下命令：",Be,ul,Xe,Tl,rs="这将询问你几个配置的问题并将你的回答保存到此命令使用的配置文件中：",We,hl,Re,fl,ms="这将启动分布式训练",ge,Cl,os="这将启动分布式训练。如果你想在 Notebook 中尝试此操作（例如，在 Colab 上使用 TPU 进行测试），只需将代码粘贴到一个 <code>training_function()</code> 函数中，并在最后一个单元格中运行：",ve,Zl,_e,Gl,ys='你可以在 <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a> 找到更多的示例。',Ve,Il,Ye,kl,Ae;return h=new Bl({props:{title:"一个完整的训练",local:"一个完整的训练",headingTag:"h1"}}),f=new Is({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter3/section4.ipynb"}]}}),C=new Us({props:{id:"Dh9CL8fyG80"}}),G=new b({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),I=new Bl({props:{title:"训练前的准备",local:"训练前的准备",headingTag:"h2"}}),X=new b({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),R=new b({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),v=new b({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),V=new b({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),Y=new b({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new b({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),x=new b({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new b({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),P=new Bl({props:{title:"训练循环",local:"训练循环",headingTag:"h2"}}),O=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ll=new b({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),sl=new b({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),al=new Bl({props:{title:"评估循环",local:"评估循环",headingTag:"h2"}}),pl=new b({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),Ml=new b({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),u=new ws({props:{$$slots:{default:[ks]},$$scope:{ctx:$l}}}),il=new Bl({props:{title:"使用🤗 Accelerate 加速你的训练循环",local:"使用🤗 Accelerate加速你的训练循环",headingTag:"h2"}}),rl=new Us({props:{id:"s7dy8QRgjJ0"}}),ol=new b({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),dl=new b({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),T=new ws({props:{$$slots:{default:[Bs]},$$scope:{ctx:$l}}}),wl=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ul=new b({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),hl=new b({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Zl=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Il=new $s({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter3/4.mdx"}}),{c(){j=o("meta"),w=a(),J=o("p"),U=a(),p(h.$$.fragment),Xl=a(),p(f.$$.fragment),Wl=a(),p(C.$$.fragment),Rl=a(),Z=o("p"),Z.innerHTML=ze,gl=a(),p(G.$$.fragment),vl=a(),p(I.$$.fragment),_l=a(),$=o("p"),$.innerHTML=Ne,Vl=a(),k=o("ul"),k.innerHTML=Ee,Yl=a(),B=o("p"),B.innerHTML=Fe,Al=a(),p(X.$$.fragment),zl=a(),W=o("p"),W.textContent=Qe,Nl=a(),p(R.$$.fragment),El=a(),g=o("p"),g.textContent=He,Fl=a(),p(v.$$.fragment),Ql=a(),_=o("p"),_.textContent=Se,Hl=a(),p(V.$$.fragment),Sl=a(),p(Y.$$.fragment),xl=a(),A=o("p"),A.innerHTML=xe,Ll=a(),z=o("p"),z.textContent=Le,ql=a(),p(N.$$.fragment),Kl=a(),E=o("p"),E.innerHTML=qe,Pl=a(),p(F.$$.fragment),Dl=a(),p(Q.$$.fragment),Ol=a(),H=o("p"),H.innerHTML=Ke,le=a(),S=o("p"),S.innerHTML=Pe,ee=a(),p(x.$$.fragment),se=a(),L=o("p"),L.innerHTML=De,te=a(),p(q.$$.fragment),ae=a(),p(K.$$.fragment),ne=a(),p(P.$$.fragment),pe=a(),D=o("p"),D.innerHTML=Oe,Me=a(),p(O.$$.fragment),ce=a(),p(ll.$$.fragment),ie=a(),el=o("p"),el.innerHTML=ls,re=a(),p(sl.$$.fragment),me=a(),tl=o("p"),tl.textContent=es,oe=a(),p(al.$$.fragment),ye=a(),nl=o("p"),nl.innerHTML=ss,de=a(),p(pl.$$.fragment),je=a(),p(Ml.$$.fragment),be=a(),cl=o("p"),cl.textContent=ts,Je=a(),p(u.$$.fragment),we=a(),p(il.$$.fragment),Ue=a(),p(rl.$$.fragment),ue=a(),ml=o("p"),ml.innerHTML=as,Te=a(),p(ol.$$.fragment),he=a(),yl=o("p"),yl.textContent=ns,fe=a(),p(dl.$$.fragment),Ce=a(),jl=o("p"),jl.innerHTML=ps,Ze=a(),bl=o("p"),bl.innerHTML=Ms,Ge=a(),p(T.$$.fragment),Ie=a(),Jl=o("p"),Jl.textContent=cs,$e=a(),p(wl.$$.fragment),ke=a(),Ul=o("p"),Ul.innerHTML=is,Be=a(),p(ul.$$.fragment),Xe=a(),Tl=o("p"),Tl.textContent=rs,We=a(),p(hl.$$.fragment),Re=a(),fl=o("p"),fl.textContent=ms,ge=a(),Cl=o("p"),Cl.innerHTML=os,ve=a(),p(Zl.$$.fragment),_e=a(),Gl=o("p"),Gl.innerHTML=ys,Ve=a(),p(Il.$$.fragment),Ye=a(),kl=o("p"),this.h()},l(l){const e=Zs("svelte-u9bgzb",document.head);j=y(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(l),J=y(l,"P",{}),bs(J).forEach(s),U=n(l),M(h.$$.fragment,l),Xl=n(l),M(f.$$.fragment,l),Wl=n(l),M(C.$$.fragment,l),Rl=n(l),Z=y(l,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-13enyaf"&&(Z.innerHTML=ze),gl=n(l),M(G.$$.fragment,l),vl=n(l),M(I.$$.fragment,l),_l=n(l),$=y(l,"P",{"data-svelte-h":!0}),d($)!=="svelte-1yecb2p"&&($.innerHTML=Ne),Vl=n(l),k=y(l,"UL",{"data-svelte-h":!0}),d(k)!=="svelte-lvny5e"&&(k.innerHTML=Ee),Yl=n(l),B=y(l,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1v2kn1o"&&(B.innerHTML=Fe),Al=n(l),M(X.$$.fragment,l),zl=n(l),W=y(l,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1nix2jt"&&(W.textContent=Qe),Nl=n(l),M(R.$$.fragment,l),El=n(l),g=y(l,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1agqx3n"&&(g.textContent=He),Fl=n(l),M(v.$$.fragment,l),Ql=n(l),_=y(l,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1056o5f"&&(_.textContent=Se),Hl=n(l),M(V.$$.fragment,l),Sl=n(l),M(Y.$$.fragment,l),xl=n(l),A=y(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-15la3hm"&&(A.innerHTML=xe),Ll=n(l),z=y(l,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1fp0mz9"&&(z.textContent=Le),ql=n(l),M(N.$$.fragment,l),Kl=n(l),E=y(l,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1bhzb96"&&(E.innerHTML=qe),Pl=n(l),M(F.$$.fragment,l),Dl=n(l),M(Q.$$.fragment,l),Ol=n(l),H=y(l,"P",{"data-svelte-h":!0}),d(H)!=="svelte-2dyt89"&&(H.innerHTML=Ke),le=n(l),S=y(l,"P",{"data-svelte-h":!0}),d(S)!=="svelte-pzmurp"&&(S.innerHTML=Pe),ee=n(l),M(x.$$.fragment,l),se=n(l),L=y(l,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1wax5dr"&&(L.innerHTML=De),te=n(l),M(q.$$.fragment,l),ae=n(l),M(K.$$.fragment,l),ne=n(l),M(P.$$.fragment,l),pe=n(l),D=y(l,"P",{"data-svelte-h":!0}),d(D)!=="svelte-az2ahg"&&(D.innerHTML=Oe),Me=n(l),M(O.$$.fragment,l),ce=n(l),M(ll.$$.fragment,l),ie=n(l),el=y(l,"P",{"data-svelte-h":!0}),d(el)!=="svelte-spzdap"&&(el.innerHTML=ls),re=n(l),M(sl.$$.fragment,l),me=n(l),tl=y(l,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-1ff2fnh"&&(tl.textContent=es),oe=n(l),M(al.$$.fragment,l),ye=n(l),nl=y(l,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-1ddz8vi"&&(nl.innerHTML=ss),de=n(l),M(pl.$$.fragment,l),je=n(l),M(Ml.$$.fragment,l),be=n(l),cl=y(l,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-55obbg"&&(cl.textContent=ts),Je=n(l),M(u.$$.fragment,l),we=n(l),M(il.$$.fragment,l),Ue=n(l),M(rl.$$.fragment,l),ue=n(l),ml=y(l,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-wubmmt"&&(ml.innerHTML=as),Te=n(l),M(ol.$$.fragment,l),he=n(l),yl=y(l,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-8f4nle"&&(yl.textContent=ns),fe=n(l),M(dl.$$.fragment,l),Ce=n(l),jl=y(l,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-1jqk627"&&(jl.innerHTML=ps),Ze=n(l),bl=y(l,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-yw9l7a"&&(bl.innerHTML=Ms),Ge=n(l),M(T.$$.fragment,l),Ie=n(l),Jl=y(l,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-cz9ffq"&&(Jl.textContent=cs),$e=n(l),M(wl.$$.fragment,l),ke=n(l),Ul=y(l,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-9sxezb"&&(Ul.innerHTML=is),Be=n(l),M(ul.$$.fragment,l),Xe=n(l),Tl=y(l,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-14ydy5s"&&(Tl.textContent=rs),We=n(l),M(hl.$$.fragment,l),Re=n(l),fl=y(l,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-wi892w"&&(fl.textContent=ms),ge=n(l),Cl=y(l,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-1mbq56y"&&(Cl.innerHTML=os),ve=n(l),M(Zl.$$.fragment,l),_e=n(l),Gl=y(l,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-127l9y5"&&(Gl.innerHTML=ys),Ve=n(l),M(Il.$$.fragment,l),Ye=n(l),kl=y(l,"P",{}),bs(kl).forEach(s),this.h()},h(){Js(j,"name","hf:doc:metadata"),Js(j,"content",Ws)},m(l,e){Gs(document.head,j),t(l,w,e),t(l,J,e),t(l,U,e),c(h,l,e),t(l,Xl,e),c(f,l,e),t(l,Wl,e),c(C,l,e),t(l,Rl,e),t(l,Z,e),t(l,gl,e),c(G,l,e),t(l,vl,e),c(I,l,e),t(l,_l,e),t(l,$,e),t(l,Vl,e),t(l,k,e),t(l,Yl,e),t(l,B,e),t(l,Al,e),c(X,l,e),t(l,zl,e),t(l,W,e),t(l,Nl,e),c(R,l,e),t(l,El,e),t(l,g,e),t(l,Fl,e),c(v,l,e),t(l,Ql,e),t(l,_,e),t(l,Hl,e),c(V,l,e),t(l,Sl,e),c(Y,l,e),t(l,xl,e),t(l,A,e),t(l,Ll,e),t(l,z,e),t(l,ql,e),c(N,l,e),t(l,Kl,e),t(l,E,e),t(l,Pl,e),c(F,l,e),t(l,Dl,e),c(Q,l,e),t(l,Ol,e),t(l,H,e),t(l,le,e),t(l,S,e),t(l,ee,e),c(x,l,e),t(l,se,e),t(l,L,e),t(l,te,e),c(q,l,e),t(l,ae,e),c(K,l,e),t(l,ne,e),c(P,l,e),t(l,pe,e),t(l,D,e),t(l,Me,e),c(O,l,e),t(l,ce,e),c(ll,l,e),t(l,ie,e),t(l,el,e),t(l,re,e),c(sl,l,e),t(l,me,e),t(l,tl,e),t(l,oe,e),c(al,l,e),t(l,ye,e),t(l,nl,e),t(l,de,e),c(pl,l,e),t(l,je,e),c(Ml,l,e),t(l,be,e),t(l,cl,e),t(l,Je,e),c(u,l,e),t(l,we,e),c(il,l,e),t(l,Ue,e),c(rl,l,e),t(l,ue,e),t(l,ml,e),t(l,Te,e),c(ol,l,e),t(l,he,e),t(l,yl,e),t(l,fe,e),c(dl,l,e),t(l,Ce,e),t(l,jl,e),t(l,Ze,e),t(l,bl,e),t(l,Ge,e),c(T,l,e),t(l,Ie,e),t(l,Jl,e),t(l,$e,e),c(wl,l,e),t(l,ke,e),t(l,Ul,e),t(l,Be,e),c(ul,l,e),t(l,Xe,e),t(l,Tl,e),t(l,We,e),c(hl,l,e),t(l,Re,e),t(l,fl,e),t(l,ge,e),t(l,Cl,e),t(l,ve,e),c(Zl,l,e),t(l,_e,e),t(l,Gl,e),t(l,Ve,e),c(Il,l,e),t(l,Ye,e),t(l,kl,e),Ae=!0},p(l,[e]){const ds={};e&2&&(ds.$$scope={dirty:e,ctx:l}),u.$set(ds);const js={};e&2&&(js.$$scope={dirty:e,ctx:l}),T.$set(js)},i(l){Ae||(i(h.$$.fragment,l),i(f.$$.fragment,l),i(C.$$.fragment,l),i(G.$$.fragment,l),i(I.$$.fragment,l),i(X.$$.fragment,l),i(R.$$.fragment,l),i(v.$$.fragment,l),i(V.$$.fragment,l),i(Y.$$.fragment,l),i(N.$$.fragment,l),i(F.$$.fragment,l),i(Q.$$.fragment,l),i(x.$$.fragment,l),i(q.$$.fragment,l),i(K.$$.fragment,l),i(P.$$.fragment,l),i(O.$$.fragment,l),i(ll.$$.fragment,l),i(sl.$$.fragment,l),i(al.$$.fragment,l),i(pl.$$.fragment,l),i(Ml.$$.fragment,l),i(u.$$.fragment,l),i(il.$$.fragment,l),i(rl.$$.fragment,l),i(ol.$$.fragment,l),i(dl.$$.fragment,l),i(T.$$.fragment,l),i(wl.$$.fragment,l),i(ul.$$.fragment,l),i(hl.$$.fragment,l),i(Zl.$$.fragment,l),i(Il.$$.fragment,l),Ae=!0)},o(l){r(h.$$.fragment,l),r(f.$$.fragment,l),r(C.$$.fragment,l),r(G.$$.fragment,l),r(I.$$.fragment,l),r(X.$$.fragment,l),r(R.$$.fragment,l),r(v.$$.fragment,l),r(V.$$.fragment,l),r(Y.$$.fragment,l),r(N.$$.fragment,l),r(F.$$.fragment,l),r(Q.$$.fragment,l),r(x.$$.fragment,l),r(q.$$.fragment,l),r(K.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(sl.$$.fragment,l),r(al.$$.fragment,l),r(pl.$$.fragment,l),r(Ml.$$.fragment,l),r(u.$$.fragment,l),r(il.$$.fragment,l),r(rl.$$.fragment,l),r(ol.$$.fragment,l),r(dl.$$.fragment,l),r(T.$$.fragment,l),r(wl.$$.fragment,l),r(ul.$$.fragment,l),r(hl.$$.fragment,l),r(Zl.$$.fragment,l),r(Il.$$.fragment,l),Ae=!1},d(l){l&&(s(w),s(J),s(U),s(Xl),s(Wl),s(Rl),s(Z),s(gl),s(vl),s(_l),s($),s(Vl),s(k),s(Yl),s(B),s(Al),s(zl),s(W),s(Nl),s(El),s(g),s(Fl),s(Ql),s(_),s(Hl),s(Sl),s(xl),s(A),s(Ll),s(z),s(ql),s(Kl),s(E),s(Pl),s(Dl),s(Ol),s(H),s(le),s(S),s(ee),s(se),s(L),s(te),s(ae),s(ne),s(pe),s(D),s(Me),s(ce),s(ie),s(el),s(re),s(me),s(tl),s(oe),s(ye),s(nl),s(de),s(je),s(be),s(cl),s(Je),s(we),s(Ue),s(ue),s(ml),s(Te),s(he),s(yl),s(fe),s(Ce),s(jl),s(Ze),s(bl),s(Ge),s(Ie),s(Jl),s($e),s(ke),s(Ul),s(Be),s(Xe),s(Tl),s(We),s(Re),s(fl),s(ge),s(Cl),s(ve),s(_e),s(Gl),s(Ve),s(Ye),s(kl)),s(j),m(h,l),m(f,l),m(C,l),m(G,l),m(I,l),m(X,l),m(R,l),m(v,l),m(V,l),m(Y,l),m(N,l),m(F,l),m(Q,l),m(x,l),m(q,l),m(K,l),m(P,l),m(O,l),m(ll,l),m(sl,l),m(al,l),m(pl,l),m(Ml,l),m(u,l),m(il,l),m(rl,l),m(ol,l),m(dl,l),m(T,l),m(wl,l),m(ul,l),m(hl,l),m(Zl,l),m(Il,l)}}}const Ws='{"title":"一个完整的训练","local":"一个完整的训练","sections":[{"title":"训练前的准备","local":"训练前的准备","sections":[],"depth":2},{"title":"训练循环","local":"训练循环","sections":[],"depth":2},{"title":"评估循环","local":"评估循环","sections":[],"depth":2},{"title":"使用🤗 Accelerate 加速你的训练循环","local":"使用🤗 Accelerate加速你的训练循环","sections":[],"depth":2}],"depth":1}';function Rs($l){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends fs{constructor(j){super(),Cs(this,j,Rs,Xs,Ts,{})}}export{Ns as component};
